/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.keychain;

import dagger.Module;
import dagger.Provides;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectExpression;
import javax.inject.Singleton;
import org.cryptomator.common.PluginClassLoader;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.integrations.keychain.KeychainAccessProvider;

@Module
public class KeychainModule {
    @Provides
    @Singleton
    static Set<ServiceLoader.Provider<KeychainAccessProvider>> provideAvailableKeychainAccessProviderFactories(PluginClassLoader classLoader) {
        return ServiceLoader.load(KeychainAccessProvider.class, classLoader).stream().collect(Collectors.toUnmodifiableSet());
    }

    @Provides
    @Singleton
    static Set<KeychainAccessProvider> provideSupportedKeychainAccessProviders(Set<ServiceLoader.Provider<KeychainAccessProvider>> availableFactories) {
        return availableFactories.stream().map(ServiceLoader.Provider::get).filter(KeychainAccessProvider::isSupported).collect(Collectors.toUnmodifiableSet());
    }

    @Provides
    @Singleton
    static ObjectExpression<KeychainAccessProvider> provideKeychainAccessProvider(Settings settings, Set<KeychainAccessProvider> providers) {
        return Bindings.createObjectBinding(() -> {
            String selectedProviderClass = (String)settings.keychainProvider().get();
            Optional<KeychainAccessProvider> selectedProvider = providers.stream().filter(provider -> provider.getClass().getName().equals(selectedProviderClass)).findAny();
            KeychainAccessProvider fallbackProvider = providers.stream().findAny().orElse(null);
            return selectedProvider.orElse(fallbackProvider);
        }, (Observable[])new Observable[]{settings.keychainProvider()});
    }
}

