/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.settings;

import com.google.common.base.Suppliers;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cryptomator.common.Environment;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.settings.SettingsJsonAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SettingsProvider
implements Supplier<Settings> {
    private static final Logger LOG = LoggerFactory.getLogger(SettingsProvider.class);
    private static final long SAVE_DELAY_MS = 1000L;
    private final AtomicReference<ScheduledFuture<?>> scheduledSaveCmd = new AtomicReference();
    private final Supplier<Settings> settings = Suppliers.memoize(this::load);
    private final SettingsJsonAdapter settingsJsonAdapter;
    private final Environment env;
    private final ScheduledExecutorService scheduler;
    private final Gson gson;

    @Inject
    public SettingsProvider(SettingsJsonAdapter settingsJsonAdapter, Environment env, ScheduledExecutorService scheduler) {
        this.settingsJsonAdapter = settingsJsonAdapter;
        this.env = env;
        this.scheduler = scheduler;
        this.gson = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().registerTypeAdapter(Settings.class, (Object)settingsJsonAdapter).create();
    }

    @Override
    public Settings get() {
        return this.settings.get();
    }

    private Settings load() {
        Settings settings = this.env.getSettingsPath().flatMap(this::tryLoad).findFirst().orElse(new Settings(this.env));
        settings.setSaveCmd(this::scheduleSave);
        return settings;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Stream<Settings> tryLoad(Path path) {
        LOG.debug("Attempting to load settings from {}", (Object)path);
        try (InputStream in = Files.newInputStream(path, StandardOpenOption.READ);){
            InputStreamReader reader;
            block16: {
                Stream<Settings> stream;
                reader = new InputStreamReader(in, StandardCharsets.UTF_8);
                try {
                    JsonElement json = JsonParser.parseReader((Reader)reader);
                    if (!json.isJsonObject()) break block16;
                    Settings settings = (Settings)this.gson.fromJson(json, Settings.class);
                    LOG.info("Settings loaded from {}", (Object)path);
                    stream = Stream.of(settings);
                }
                catch (Throwable throwable) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ((Reader)reader).close();
                return stream;
            }
            LOG.warn("Invalid json file {}", (Object)path);
            Stream<Settings> stream = Stream.empty();
            ((Reader)reader).close();
            return stream;
        }
        catch (NoSuchFileException e) {
            return Stream.empty();
        }
        catch (JsonParseException | IOException e) {
            LOG.warn("Exception while loading settings from " + path, e);
            return Stream.empty();
        }
    }

    private void scheduleSave(Settings settings) {
        if (settings == null) {
            return;
        }
        Optional<Path> settingsPath = this.env.getSettingsPath().findFirst();
        settingsPath.ifPresent(path -> {
            Runnable saveCommand = () -> this.save(settings, (Path)path);
            ScheduledFuture<?> scheduledTask = this.scheduler.schedule(saveCommand, 1000L, TimeUnit.MILLISECONDS);
            ScheduledFuture<?> previouslyScheduledTask = this.scheduledSaveCmd.getAndSet(scheduledTask);
            if (previouslyScheduledTask != null) {
                previouslyScheduledTask.cancel(false);
            }
        });
    }

    private void save(Settings settings, Path settingsPath) {
        assert (settings != null) : "method should only be invoked by #scheduleSave, which checks for null";
        LOG.debug("Attempting to save settings to {}", (Object)settingsPath);
        try {
            Files.createDirectories(settingsPath.getParent(), new FileAttribute[0]);
            Path tmpPath = settingsPath.resolveSibling(settingsPath.getFileName().toString() + ".tmp");
            try (OutputStream out = Files.newOutputStream(tmpPath, StandardOpenOption.CREATE_NEW);
                 OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
                this.gson.toJson((Object)settings, (Appendable)writer);
            }
            Files.move(tmpPath, settingsPath, StandardCopyOption.REPLACE_EXISTING);
            LOG.info("Settings saved to {}", (Object)settingsPath);
        }
        catch (JsonParseException | IOException e) {
            LOG.error("Failed to save settings.", e);
        }
    }
}

