/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.vaults;

import java.time.Instant;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.collections.ObservableList;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cryptomator.common.vaults.LockNotCompletedException;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.Volume;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AutoLocker {
    private static final Logger LOG = LoggerFactory.getLogger(AutoLocker.class);
    private final ScheduledExecutorService scheduler;
    private final ObservableList<Vault> vaultList;

    @Inject
    public AutoLocker(ScheduledExecutorService scheduler, ObservableList<Vault> vaultList) {
        this.scheduler = scheduler;
        this.vaultList = vaultList;
    }

    public void init() {
        this.scheduler.scheduleAtFixedRate(this::tick, 0L, 1L, TimeUnit.MINUTES);
    }

    private void tick() {
        this.vaultList.stream().filter(Vault::isUnlocked).filter(this::exceedsIdleTime).forEach(this::autolock);
    }

    private void autolock(Vault vault) {
        try {
            vault.lock(false);
            LOG.info("Autolocked {} after idle timeout", (Object)vault.getDisplayName());
        }
        catch (LockNotCompletedException | Volume.VolumeException e) {
            LOG.error("Autolocking failed.", (Throwable)e);
        }
    }

    private boolean exceedsIdleTime(Vault vault) {
        assert (vault.isUnlocked());
        if (vault.getVaultSettings().autoLockWhenIdle().get()) {
            int maxIdleSeconds = vault.getVaultSettings().autoLockIdleSeconds().get();
            Instant deadline = vault.getStats().getLastActivity().plusSeconds(maxIdleSeconds);
            return deadline.isBefore(Instant.now());
        }
        return false;
    }
}

