/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.vaults;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.mountpoint.InvalidMountPointException;
import org.cryptomator.common.mountpoint.MountPointChooser;
import org.cryptomator.common.settings.VolumeImpl;
import org.cryptomator.common.vaults.AbstractVolume;
import org.cryptomator.common.vaults.MountPointRequirement;
import org.cryptomator.common.vaults.Volume;
import org.cryptomator.cryptofs.CryptoFileSystem;
import org.cryptomator.frontend.fuse.mount.EnvironmentVariables;
import org.cryptomator.frontend.fuse.mount.FuseMountException;
import org.cryptomator.frontend.fuse.mount.FuseMountFactory;
import org.cryptomator.frontend.fuse.mount.FuseNotSupportedException;
import org.cryptomator.frontend.fuse.mount.Mount;
import org.cryptomator.frontend.fuse.mount.Mounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuseVolume
extends AbstractVolume {
    private static final Logger LOG = LoggerFactory.getLogger(FuseVolume.class);
    private static final Pattern NON_WHITESPACE_OR_QUOTED = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
    private Mount mount;

    @Inject
    public FuseVolume(@Named(value="orderedMountPointChoosers") Iterable<MountPointChooser> choosers) {
        super(choosers);
    }

    @Override
    public void mount(CryptoFileSystem fs, String mountFlags, Consumer<Throwable> onExitAction) throws InvalidMountPointException, Volume.VolumeException {
        this.mountPoint = this.determineMountPoint();
        this.mount(fs.getPath("/", new String[0]), mountFlags, onExitAction);
    }

    private void mount(Path root, String mountFlags, Consumer<Throwable> onExitAction) throws Volume.VolumeException {
        try {
            Mounter mounter = FuseMountFactory.getMounter();
            EnvironmentVariables envVars = EnvironmentVariables.create().withFlags(this.splitFlags(mountFlags)).withMountPoint(this.mountPoint).withFileNameTranscoder(mounter.defaultFileNameTranscoder()).build();
            this.mount = mounter.mount(root, envVars, onExitAction);
        }
        catch (FuseMountException | FuseNotSupportedException e) {
            throw new Volume.VolumeException("Unable to mount Filesystem", e);
        }
    }

    private String[] splitFlags(String str) {
        ArrayList<String> flags = new ArrayList<String>();
        PeekingIterator matches = Iterators.peekingIterator(NON_WHITESPACE_OR_QUOTED.matcher(str).results().iterator());
        while (matches.hasNext()) {
            Object flag = ((MatchResult)matches.next()).group();
            if (((String)flag).endsWith("=") && matches.hasNext() && ((MatchResult)matches.peek()).group(1) != null) {
                flag = (String)flag + ((MatchResult)matches.next()).group(1);
            } else if (((String)flag).endsWith("=") && matches.hasNext() && ((MatchResult)matches.peek()).group(2) != null) {
                flag = (String)flag + ((MatchResult)matches.next()).group(2);
            }
            flags.add((String)flag);
        }
        return (String[])flags.toArray(String[]::new);
    }

    @Override
    public void reveal(Volume.Revealer revealer) throws Volume.VolumeException {
        try {
            this.mount.reveal(revealer::reveal);
        }
        catch (Exception e) {
            throw new Volume.VolumeException(e);
        }
    }

    @Override
    public boolean supportsForcedUnmount() {
        return true;
    }

    @Override
    public synchronized void unmountForced() throws Volume.VolumeException {
        try {
            this.mount.unmountForced();
        }
        catch (FuseMountException e) {
            throw new Volume.VolumeException(e);
        }
        this.cleanupMountPoint();
    }

    @Override
    public synchronized void unmount() throws Volume.VolumeException {
        try {
            this.mount.unmount();
        }
        catch (FuseMountException e) {
            throw new Volume.VolumeException(e);
        }
        this.cleanupMountPoint();
    }

    @Override
    public boolean isSupported() {
        return FuseVolume.isSupportedStatic();
    }

    @Override
    public VolumeImpl getImplementationType() {
        return VolumeImpl.FUSE;
    }

    @Override
    public MountPointRequirement getMountPointRequirement() {
        return SystemUtils.IS_OS_WINDOWS ? MountPointRequirement.PARENT_NO_MOUNT_POINT : MountPointRequirement.EMPTY_MOUNT_POINT;
    }

    public static boolean isSupportedStatic() {
        return FuseMountFactory.isFuseSupported();
    }
}

