/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.vaults;

import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.mountpoint.InvalidMountPointException;
import org.cryptomator.common.settings.VaultSettings;
import org.cryptomator.common.vaults.DefaultMountFlags;
import org.cryptomator.common.vaults.LockNotCompletedException;
import org.cryptomator.common.vaults.PerVault;
import org.cryptomator.common.vaults.VaultConfigCache;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.common.vaults.VaultStats;
import org.cryptomator.common.vaults.Volume;
import org.cryptomator.cryptofs.CryptoFileSystem;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.CryptoFileSystemProvider;
import org.cryptomator.cryptofs.common.FileSystemCapabilityChecker;
import org.cryptomator.cryptolib.api.CryptoException;
import org.cryptomator.cryptolib.api.MasterkeyLoader;
import org.cryptomator.cryptolib.api.MasterkeyLoadingFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PerVault
public class Vault {
    private static final Logger LOG = LoggerFactory.getLogger(Vault.class);
    private static final Path HOME_DIR = Paths.get(SystemUtils.USER_HOME, new String[0]);
    private static final int UNLIMITED_FILENAME_LENGTH = Integer.MAX_VALUE;
    private final VaultSettings vaultSettings;
    private final Provider<Volume> volumeProvider;
    private final StringBinding defaultMountFlags;
    private final AtomicReference<CryptoFileSystem> cryptoFileSystem;
    private final VaultState state;
    private final ObjectProperty<Exception> lastKnownException;
    private final VaultConfigCache configCache;
    private final VaultStats stats;
    private final StringBinding displayName;
    private final StringBinding displayablePath;
    private final BooleanBinding locked;
    private final BooleanBinding processing;
    private final BooleanBinding unlocked;
    private final BooleanBinding missing;
    private final BooleanBinding needsMigration;
    private final BooleanBinding unknownError;
    private final StringBinding accessPoint;
    private final BooleanBinding accessPointPresent;
    private final BooleanProperty showingStats;
    private volatile Volume volume;

    @Inject
    Vault(VaultSettings vaultSettings, VaultConfigCache configCache, Provider<Volume> volumeProvider, @DefaultMountFlags StringBinding defaultMountFlags, AtomicReference<CryptoFileSystem> cryptoFileSystem, VaultState state, @Named(value="lastKnownException") ObjectProperty<Exception> lastKnownException, VaultStats stats) {
        this.vaultSettings = vaultSettings;
        this.configCache = configCache;
        this.volumeProvider = volumeProvider;
        this.defaultMountFlags = defaultMountFlags;
        this.cryptoFileSystem = cryptoFileSystem;
        this.state = state;
        this.lastKnownException = lastKnownException;
        this.stats = stats;
        this.displayName = Bindings.createStringBinding(this::getDisplayName, (Observable[])new Observable[]{vaultSettings.displayName()});
        this.displayablePath = Bindings.createStringBinding(this::getDisplayablePath, (Observable[])new Observable[]{vaultSettings.path()});
        this.locked = Bindings.createBooleanBinding(this::isLocked, (Observable[])new Observable[]{state});
        this.processing = Bindings.createBooleanBinding(this::isProcessing, (Observable[])new Observable[]{state});
        this.unlocked = Bindings.createBooleanBinding(this::isUnlocked, (Observable[])new Observable[]{state});
        this.missing = Bindings.createBooleanBinding(this::isMissing, (Observable[])new Observable[]{state});
        this.needsMigration = Bindings.createBooleanBinding(this::isNeedsMigration, (Observable[])new Observable[]{state});
        this.unknownError = Bindings.createBooleanBinding(this::isUnknownError, (Observable[])new Observable[]{state});
        this.accessPoint = Bindings.createStringBinding(this::getAccessPoint, (Observable[])new Observable[]{state});
        this.accessPointPresent = this.accessPoint.isNotEmpty();
        this.showingStats = new SimpleBooleanProperty(false);
    }

    private CryptoFileSystem createCryptoFileSystem(MasterkeyLoader keyLoader) throws IOException, MasterkeyLoadingFailedException {
        EnumSet<CryptoFileSystemProperties.FileSystemFlags> flags = EnumSet.noneOf(CryptoFileSystemProperties.FileSystemFlags.class);
        if (this.vaultSettings.usesReadOnlyMode().get()) {
            flags.add(CryptoFileSystemProperties.FileSystemFlags.READONLY);
        } else if (this.vaultSettings.maxCleartextFilenameLength().get() == -1) {
            LOG.debug("Determining cleartext filename length limitations...");
            FileSystemCapabilityChecker checker = new FileSystemCapabilityChecker();
            int shorteningThreshold = this.configCache.get().allegedShorteningThreshold();
            int ciphertextLimit = checker.determineSupportedCiphertextFileNameLength(this.getPath());
            if (ciphertextLimit < shorteningThreshold) {
                int cleartextLimit = checker.determineSupportedCleartextFileNameLength(this.getPath());
                this.vaultSettings.maxCleartextFilenameLength().set(cleartextLimit);
            } else {
                this.vaultSettings.maxCleartextFilenameLength().setValue((Number)Integer.MAX_VALUE);
            }
        }
        if (this.vaultSettings.maxCleartextFilenameLength().get() < Integer.MAX_VALUE) {
            LOG.warn("Limiting cleartext filename length on this device to {}.", (Object)this.vaultSettings.maxCleartextFilenameLength().get());
        }
        CryptoFileSystemProperties fsProps = CryptoFileSystemProperties.cryptoFileSystemProperties().withKeyLoader(keyLoader).withFlags(flags).withMaxCleartextNameLength(this.vaultSettings.maxCleartextFilenameLength().get()).build();
        return CryptoFileSystemProvider.newFileSystem((Path)this.getPath(), (CryptoFileSystemProperties)fsProps);
    }

    private void destroyCryptoFileSystem() {
        LOG.trace("Trying to close associated CryptoFS...");
        CryptoFileSystem fs = this.cryptoFileSystem.getAndSet(null);
        if (fs != null) {
            try {
                fs.close();
            }
            catch (IOException e) {
                LOG.error("Error closing file system.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unlock(MasterkeyLoader keyLoader) throws CryptoException, IOException, Volume.VolumeException, InvalidMountPointException {
        if (this.cryptoFileSystem.get() != null) {
            throw new IllegalStateException("Already unlocked.");
        }
        CryptoFileSystem fs = this.createCryptoFileSystem(keyLoader);
        boolean success = false;
        try {
            this.cryptoFileSystem.set(fs);
            this.volume = (Volume)this.volumeProvider.get();
            this.volume.mount(fs, this.getEffectiveMountFlags(), this::lockOnVolumeExit);
            success = true;
        }
        finally {
            if (!success) {
                this.destroyCryptoFileSystem();
            }
        }
    }

    private void lockOnVolumeExit(Throwable t) {
        LOG.info("Unmounted vault '{}'", (Object)this.getDisplayName());
        this.destroyCryptoFileSystem();
        this.state.set(VaultState.Value.LOCKED);
        if (t != null) {
            LOG.warn("Unexpected unmount and lock of vault " + this.getDisplayName(), t);
        }
    }

    public synchronized void lock(boolean forced) throws Volume.VolumeException, LockNotCompletedException {
        if (forced && this.volume.supportsForcedUnmount()) {
            this.volume.unmountForced();
        } else {
            this.volume.unmount();
        }
        try {
            boolean locked = this.state.awaitState(VaultState.Value.LOCKED, 3000L, TimeUnit.MILLISECONDS);
            if (!locked) {
                throw new LockNotCompletedException("Locking of vault " + this.getDisplayName() + " still in progress.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new LockNotCompletedException(e);
        }
    }

    public void reveal(Volume.Revealer vaultRevealer) throws Volume.VolumeException {
        this.volume.reveal(vaultRevealer);
    }

    public VaultState stateProperty() {
        return this.state;
    }

    public VaultState.Value getState() {
        return this.state.getValue();
    }

    public ObjectProperty<Exception> lastKnownExceptionProperty() {
        return this.lastKnownException;
    }

    public Exception getLastKnownException() {
        return (Exception)this.lastKnownException.get();
    }

    public void setLastKnownException(Exception e) {
        this.lastKnownException.setValue((Object)e);
    }

    public BooleanBinding lockedProperty() {
        return this.locked;
    }

    public boolean isLocked() {
        return this.state.get() == VaultState.Value.LOCKED;
    }

    public BooleanBinding processingProperty() {
        return this.processing;
    }

    public boolean isProcessing() {
        return this.state.get() == VaultState.Value.PROCESSING;
    }

    public BooleanBinding unlockedProperty() {
        return this.unlocked;
    }

    public boolean isUnlocked() {
        return this.state.get() == VaultState.Value.UNLOCKED;
    }

    public BooleanBinding missingProperty() {
        return this.missing;
    }

    public boolean isMissing() {
        return this.state.get() == VaultState.Value.MISSING;
    }

    public BooleanBinding needsMigrationProperty() {
        return this.needsMigration;
    }

    public boolean isNeedsMigration() {
        return this.state.get() == VaultState.Value.NEEDS_MIGRATION;
    }

    public BooleanBinding unknownErrorProperty() {
        return this.unknownError;
    }

    public boolean isUnknownError() {
        return this.state.get() == VaultState.Value.ERROR;
    }

    public StringBinding displayNameProperty() {
        return this.displayName;
    }

    public String getDisplayName() {
        return (String)this.vaultSettings.displayName().get();
    }

    public StringBinding accessPointProperty() {
        return this.accessPoint;
    }

    public String getAccessPoint() {
        if (this.state.getValue() == VaultState.Value.UNLOCKED) {
            assert (this.volume != null);
            return this.volume.getMountPoint().orElse(Path.of("", new String[0])).toString();
        }
        return "";
    }

    public BooleanBinding accessPointPresentProperty() {
        return this.accessPointPresent;
    }

    public boolean isAccessPointPresent() {
        return this.accessPointPresent.get();
    }

    public StringBinding displayablePathProperty() {
        return this.displayablePath;
    }

    public String getDisplayablePath() {
        Path p = (Path)this.vaultSettings.path().get();
        if (p.startsWith(HOME_DIR)) {
            Path relativePath = HOME_DIR.relativize(p);
            String homePrefix = SystemUtils.IS_OS_WINDOWS ? "~\\" : "~/";
            return homePrefix + relativePath.toString();
        }
        return p.toString();
    }

    public BooleanProperty showingStatsProperty() {
        return this.showingStats;
    }

    public boolean isShowingStats() {
        return this.accessPointPresent.get();
    }

    public VaultStats getStats() {
        return this.stats;
    }

    public Observable[] observables() {
        return new Observable[]{this.state};
    }

    public VaultSettings getVaultSettings() {
        return this.vaultSettings;
    }

    public Path getPath() {
        return (Path)this.vaultSettings.path().getValue();
    }

    public boolean isHavingCustomMountFlags() {
        return !Strings.isNullOrEmpty((String)((String)this.vaultSettings.mountFlags().get()));
    }

    public StringBinding defaultMountFlagsProperty() {
        return this.defaultMountFlags;
    }

    public String getDefaultMountFlags() {
        return this.defaultMountFlags.get();
    }

    public String getEffectiveMountFlags() {
        String mountFlags = (String)this.vaultSettings.mountFlags().get();
        if (Strings.isNullOrEmpty((String)mountFlags)) {
            return this.getDefaultMountFlags();
        }
        return mountFlags;
    }

    public VaultConfigCache getVaultConfigCache() {
        return this.configCache;
    }

    public void setCustomMountFlags(String mountFlags) {
        this.vaultSettings.mountFlags().set((Object)mountFlags);
    }

    public String getId() {
        return this.vaultSettings.getId();
    }

    public Optional<Volume> getVolume() {
        return Optional.ofNullable(this.volume);
    }

    public int hashCode() {
        return Objects.hash(this.vaultSettings);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vault) {
            Vault other = (Vault)obj;
            if (obj.getClass().equals(this.getClass())) {
                return Objects.equals(this.vaultSettings, other.vaultSettings);
            }
        }
        return false;
    }

    public boolean supportsForcedUnmount() {
        return this.volume.supportsForcedUnmount();
    }
}

