/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.cryptomator.common.Environment;
import org.cryptomator.common.ShutdownHook;
import org.cryptomator.logging.LoggerModule;

@Singleton
public class LoggerConfiguration {
    private final LoggerContext context;
    private final Environment environment;
    private final Appender<ILoggingEvent> stdout;
    private final Appender<ILoggingEvent> upgrade;
    private final Appender<ILoggingEvent> file;
    private final ShutdownHook shutdownHook;

    @Inject
    LoggerConfiguration(LoggerContext context, Environment environment, @Named(value="stdoutAppender") Appender<ILoggingEvent> stdout, @Named(value="upgradeAppender") Appender<ILoggingEvent> upgrade, @Named(value="fileAppender") Appender<ILoggingEvent> file, ShutdownHook shutdownHook) {
        this.context = context;
        this.environment = environment;
        this.stdout = stdout;
        this.upgrade = upgrade;
        this.file = file;
        this.shutdownHook = shutdownHook;
    }

    public void init() {
        if (this.environment.useCustomLogbackConfig()) {
            Logger root = this.context.getLogger("ROOT");
            root.info("Using external logback configuration file.");
        } else {
            this.context.reset();
            for (Map.Entry<String, Level> loglevel : LoggerModule.DEFAULT_LOG_LEVELS.entrySet()) {
                Logger logger = this.context.getLogger(loglevel.getKey());
                logger.setLevel(loglevel.getValue());
                logger.setAdditive(false);
                logger.addAppender(this.stdout);
                logger.addAppender(this.file);
            }
            Logger upgrades = this.context.getLogger("org.cryptomator.cryptofs.migration");
            upgrades.setLevel(Level.DEBUG);
            upgrades.addAppender(this.stdout);
            upgrades.addAppender(this.upgrade);
            upgrades.addAppender(this.file);
            upgrades.setAdditive(false);
            this.shutdownHook.runOnShutdown(-2147483647, () -> ((LoggerContext)this.context).stop());
        }
    }
}

