/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.addvaultwizard;

import dagger.Lazy;
import java.nio.file.Path;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.ui.addvaultwizard.AddVaultWizardScoped;
import org.cryptomator.ui.addvaultwizard.AddVaultWizardWindow;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;

@AddVaultWizardScoped
public class CreateNewVaultNameController
implements FxController {
    private static final Pattern VALID_NAME_PATTERN = Pattern.compile("[\\w -]+", 256);
    public TextField textField;
    private final Stage window;
    private final Lazy<Scene> welcomeScene;
    private final Lazy<Scene> chooseLocationScene;
    private final ObjectProperty<Path> vaultPath;
    private final StringProperty vaultName;
    private final BooleanBinding validVaultName;
    private final BooleanBinding invalidVaultName;
    private final StringBinding warningText;

    @Inject
    CreateNewVaultNameController(@AddVaultWizardWindow Stage window, @FxmlScene(value=FxmlFile.ADDVAULT_WELCOME) Lazy<Scene> welcomeScene, @FxmlScene(value=FxmlFile.ADDVAULT_NEW_LOCATION) Lazy<Scene> chooseLocationScene, ObjectProperty<Path> vaultPath, @Named(value="vaultName") StringProperty vaultName, ResourceBundle resourceBundle) {
        this.window = window;
        this.welcomeScene = welcomeScene;
        this.chooseLocationScene = chooseLocationScene;
        this.vaultPath = vaultPath;
        this.vaultName = vaultName;
        this.validVaultName = Bindings.createBooleanBinding(this::isValidVaultName, (Observable[])new Observable[]{vaultName});
        this.invalidVaultName = this.validVaultName.not();
        this.warningText = Bindings.when((ObservableBooleanValue)vaultName.isNotEmpty().and((ObservableBooleanValue)this.invalidVaultName)).then(resourceBundle.getString("addvaultwizard.new.invalidName")).otherwise((String)null);
    }

    @FXML
    public void initialize() {
        this.vaultName.bind((ObservableValue)this.textField.textProperty());
        this.vaultName.addListener(this::vaultNameChanged);
    }

    public boolean isValidVaultName() {
        return this.vaultName.get() != null && VALID_NAME_PATTERN.matcher(((String)this.vaultName.get()).trim()).matches();
    }

    private void vaultNameChanged(Observable observable) {
        if (this.isValidVaultName() && this.vaultPath.get() != null) {
            this.vaultPath.set((Object)((Path)this.vaultPath.get()).resolveSibling((String)this.vaultName.get()));
        }
    }

    @FXML
    public void back() {
        this.window.setScene((Scene)this.welcomeScene.get());
    }

    @FXML
    public void next() {
        this.window.setScene((Scene)this.chooseLocationScene.get());
    }

    public BooleanBinding invalidVaultNameProperty() {
        return this.invalidVaultName;
    }

    public boolean isInvalidVaultName() {
        return this.invalidVaultName.get();
    }

    public StringBinding warningTextProperty() {
        return this.warningText;
    }

    public String getWarningText() {
        return this.warningText.get();
    }

    public BooleanBinding showWarningProperty() {
        return this.warningText.isNotEmpty();
    }

    public boolean isShowWarning() {
        return this.showWarningProperty().get();
    }
}

