/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.forgetPassword;

import dagger.BindsInstance;
import dagger.Lazy;
import dagger.Subcomponent;
import java.util.concurrent.CompletableFuture;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javax.inject.Named;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.forgetPassword.ForgetPasswordModule;
import org.cryptomator.ui.forgetPassword.ForgetPasswordScoped;
import org.cryptomator.ui.forgetPassword.ForgetPasswordWindow;

@ForgetPasswordScoped
@Subcomponent(modules={ForgetPasswordModule.class})
public interface ForgetPasswordComponent {
    @ForgetPasswordWindow
    public ReadOnlyBooleanProperty confirmedProperty();

    @ForgetPasswordWindow
    public Stage window();

    @FxmlScene(value=FxmlFile.FORGET_PASSWORD)
    public Lazy<Scene> scene();

    default public CompletableFuture<Boolean> showForgetPassword() {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        Stage stage = this.window();
        stage.setScene((Scene)this.scene().get());
        stage.sizeToScene();
        stage.show();
        stage.setOnHidden(evt -> result.complete(this.confirmedProperty().get()));
        return result;
    }

    @Subcomponent.Builder
    public static interface Builder {
        @BindsInstance
        public Builder vault(@ForgetPasswordWindow Vault var1);

        @BindsInstance
        public Builder owner(@Named(value="forgetPasswordOwner") Stage var1);

        public ForgetPasswordComponent build();
    }
}

