/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.health;

import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.Subscription;
import java.util.Collection;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.SequentialTransition;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;
import org.cryptomator.ui.common.Animations;
import org.cryptomator.ui.common.AutoAnimator;
import org.cryptomator.ui.controls.FontAwesome5Icon;
import org.cryptomator.ui.controls.FontAwesome5IconView;
import org.cryptomator.ui.health.Check;

public class CheckStateIconView
extends FontAwesome5IconView {
    private final ObjectProperty<Check> check = new SimpleObjectProperty();
    private final ObservableObjectValue<Check.CheckState> state = EasyBind.wrapNullable(this.check).mapObservable(Check::stateProperty).asOrdinary();
    private final ObservableObjectValue<DiagnosticResult.Severity> severity = EasyBind.wrapNullable(this.check).mapObservable(Check::highestResultSeverityProperty).asOrdinary();
    private final List<Subscription> subscriptions;
    private final AutoAnimator onRunningRotator;

    public CheckStateIconView() {
        this.glyph.bind((ObservableValue)Bindings.createObjectBinding(this::glyphForState, (Observable[])new Observable[]{this.state, this.severity}));
        this.subscriptions = List.of(EasyBind.includeWhen((Collection)this.getStyleClass(), (Object)"glyph-icon-muted", (ObservableValue)Bindings.equal(this.state, (Object)((Object)Check.CheckState.SKIPPED)).or((ObservableBooleanValue)Bindings.equal(this.state, (Object)((Object)Check.CheckState.CANCELLED)))), EasyBind.includeWhen((Collection)this.getStyleClass(), (Object)"glyph-icon-primary", (ObservableValue)Bindings.equal(this.severity, (Object)DiagnosticResult.Severity.GOOD)), EasyBind.includeWhen((Collection)this.getStyleClass(), (Object)"glyph-icon-orange", (ObservableValue)Bindings.equal(this.severity, (Object)DiagnosticResult.Severity.WARN).or((ObservableBooleanValue)Bindings.equal(this.severity, (Object)DiagnosticResult.Severity.CRITICAL))), EasyBind.includeWhen((Collection)this.getStyleClass(), (Object)"glyph-icon-red", (ObservableValue)Bindings.equal(this.state, (Object)((Object)Check.CheckState.ERROR))));
        SequentialTransition animation = Animations.createDiscrete360Rotation((Node)this);
        this.onRunningRotator = AutoAnimator.animate((Animation)animation).onCondition((ObservableValue<Boolean>)Bindings.equal(this.state, (Object)((Object)Check.CheckState.RUNNING))).afterStop(() -> this.setRotate(0.0)).build();
    }

    private FontAwesome5Icon glyphForState() {
        if (this.state.getValue() == null) {
            return null;
        }
        return switch ((Check.CheckState)((Object)this.state.getValue())) {
            default -> throw new IncompatibleClassChangeError();
            case Check.CheckState.RUNNABLE -> null;
            case Check.CheckState.SKIPPED -> FontAwesome5Icon.FAST_FORWARD;
            case Check.CheckState.SCHEDULED -> FontAwesome5Icon.CLOCK;
            case Check.CheckState.RUNNING -> FontAwesome5Icon.SPINNER;
            case Check.CheckState.ERROR -> FontAwesome5Icon.TIMES;
            case Check.CheckState.CANCELLED -> FontAwesome5Icon.BAN;
            case Check.CheckState.SUCCEEDED -> this.glyphIconForSeverity();
        };
    }

    private FontAwesome5Icon glyphIconForSeverity() {
        if (this.severity.getValue() == null) {
            return null;
        }
        return switch ((DiagnosticResult.Severity)this.severity.getValue()) {
            default -> throw new IncompatibleClassChangeError();
            case DiagnosticResult.Severity.GOOD, DiagnosticResult.Severity.INFO -> FontAwesome5Icon.CHECK;
            case DiagnosticResult.Severity.WARN, DiagnosticResult.Severity.CRITICAL -> FontAwesome5Icon.EXCLAMATION_TRIANGLE;
        };
    }

    public ObjectProperty<Check> checkProperty() {
        return this.check;
    }

    public void setCheck(Check c) {
        this.check.set((Object)c);
    }

    public Check getCheck() {
        return (Check)this.check.get();
    }
}

