/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.keyloading.masterkeyfile;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import dagger.multibindings.StringKey;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.Scene;
import javax.inject.Named;
import org.cryptomator.common.keychain.KeychainManager;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.integrations.keychain.KeychainAccessException;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxControllerKey;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlLoaderFactory;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.common.UserInteractionLock;
import org.cryptomator.ui.forgetPassword.ForgetPasswordComponent;
import org.cryptomator.ui.keyloading.KeyLoading;
import org.cryptomator.ui.keyloading.KeyLoadingScoped;
import org.cryptomator.ui.keyloading.KeyLoadingStrategy;
import org.cryptomator.ui.keyloading.masterkeyfile.MasterkeyFileLoadingStrategy;
import org.cryptomator.ui.keyloading.masterkeyfile.PassphraseEntryController;
import org.cryptomator.ui.keyloading.masterkeyfile.SelectMasterkeyFileController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Module(subcomponents={ForgetPasswordComponent.class})
public abstract class MasterkeyFileLoadingModule {
    private static final Logger LOG = LoggerFactory.getLogger(MasterkeyFileLoadingModule.class);

    @Provides
    @KeyLoadingScoped
    static UserInteractionLock<PasswordEntry> providePasswordEntryLock() {
        return new UserInteractionLock<Object>(null);
    }

    @Provides
    @KeyLoadingScoped
    static UserInteractionLock<MasterkeyFileProvision> provideMasterkeyFileProvisionLock() {
        return new UserInteractionLock<Object>(null);
    }

    @Provides
    @Named(value="savedPassword")
    @KeyLoadingScoped
    static Optional<char[]> provideStoredPassword(KeychainManager keychain, @KeyLoading Vault vault) {
        if (!keychain.isSupported() || keychain.isLocked()) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(keychain.loadPassphrase(vault.getId()));
        }
        catch (KeychainAccessException e) {
            LOG.error("Failed to load entry from system keychain.", (Throwable)e);
            return Optional.empty();
        }
    }

    @Provides
    @KeyLoadingScoped
    static AtomicReference<Path> provideUserProvidedMasterkeyPath() {
        return new AtomicReference<Path>();
    }

    @Provides
    @KeyLoadingScoped
    static AtomicReference<char[]> providePassword(@Named(value="savedPassword") Optional<char[]> storedPassword) {
        return new AtomicReference<char[]>(storedPassword.orElse(null));
    }

    @Provides
    @Named(value="savePassword")
    @KeyLoadingScoped
    static AtomicBoolean provideSavePasswordFlag(@Named(value="savedPassword") Optional<char[]> storedPassword) {
        return new AtomicBoolean(storedPassword.isPresent());
    }

    @Provides
    @FxmlScene(value=FxmlFile.UNLOCK_ENTER_PASSWORD)
    @KeyLoadingScoped
    static Scene provideUnlockScene(@KeyLoading FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.UNLOCK_ENTER_PASSWORD);
    }

    @Provides
    @FxmlScene(value=FxmlFile.UNLOCK_SELECT_MASTERKEYFILE)
    @KeyLoadingScoped
    static Scene provideUnlockSelectMasterkeyFileScene(@KeyLoading FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.UNLOCK_SELECT_MASTERKEYFILE);
    }

    @Binds
    @IntoMap
    @FxControllerKey(value=PassphraseEntryController.class)
    abstract FxController bindUnlockController(PassphraseEntryController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=SelectMasterkeyFileController.class)
    abstract FxController bindUnlockSelectMasterkeyFileController(SelectMasterkeyFileController var1);

    @Binds
    @IntoMap
    @KeyLoadingScoped
    @StringKey(value="masterkeyfile")
    abstract KeyLoadingStrategy bindMasterkeyFileLoadingStrategy(MasterkeyFileLoadingStrategy var1);

    public static enum MasterkeyFileProvision {
        MASTERKEYFILE_PROVIDED,
        CANCELED;

    }

    public static enum PasswordEntry {
        PASSWORD_ENTERED,
        CANCELED;

    }
}

