/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.lock;

import dagger.Lazy;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import org.cryptomator.common.vaults.LockNotCompletedException;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.common.vaults.Volume;
import org.cryptomator.ui.common.ErrorComponent;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.common.UserInteractionLock;
import org.cryptomator.ui.lock.LockModule;
import org.cryptomator.ui.lock.LockWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockWorkflow
extends Task<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(LockWorkflow.class);
    private final Stage lockWindow;
    private final Vault vault;
    private final UserInteractionLock<LockModule.ForceLockDecision> forceLockDecisionLock;
    private final Lazy<Scene> lockForcedScene;
    private final Lazy<Scene> lockFailedScene;
    private final ErrorComponent.Builder errorComponent;

    @Inject
    public LockWorkflow(@LockWindow Stage lockWindow, @LockWindow Vault vault, UserInteractionLock<LockModule.ForceLockDecision> forceLockDecisionLock, @FxmlScene(value=FxmlFile.LOCK_FORCED) Lazy<Scene> lockForcedScene, @FxmlScene(value=FxmlFile.LOCK_FAILED) Lazy<Scene> lockFailedScene, ErrorComponent.Builder errorComponent) {
        this.lockWindow = lockWindow;
        this.vault = vault;
        this.forceLockDecisionLock = forceLockDecisionLock;
        this.lockForcedScene = lockForcedScene;
        this.lockFailedScene = lockFailedScene;
        this.errorComponent = errorComponent;
    }

    protected Void call() throws Volume.VolumeException, InterruptedException, LockNotCompletedException {
        try {
            this.vault.lock(false);
        }
        catch (LockNotCompletedException | Volume.VolumeException e) {
            LOG.debug("Regular lock of {} failed.", (Object)this.vault.getDisplayName(), (Object)e);
            LockModule.ForceLockDecision decision = this.askUserForAction();
            switch (decision) {
                case FORCE: {
                    this.vault.lock(true);
                    break;
                }
                case CANCEL: {
                    this.cancel(false);
                }
            }
        }
        return null;
    }

    private LockModule.ForceLockDecision askUserForAction() throws InterruptedException {
        Platform.runLater(() -> {
            this.lockWindow.setScene((Scene)this.lockForcedScene.get());
            this.lockWindow.show();
            Window owner = this.lockWindow.getOwner();
            if (owner != null) {
                this.lockWindow.setX(owner.getX() + (owner.getWidth() - this.lockWindow.getWidth()) / 2.0);
                this.lockWindow.setY(owner.getY() + (owner.getHeight() - this.lockWindow.getHeight()) / 2.0);
            } else {
                this.lockWindow.centerOnScreen();
            }
        });
        return this.forceLockDecisionLock.awaitInteraction();
    }

    protected void succeeded() {
        LOG.info("Lock of {} succeeded.", (Object)this.vault.getDisplayName());
        this.vault.stateProperty().transition(VaultState.Value.PROCESSING, VaultState.Value.LOCKED);
    }

    protected void failed() {
        Throwable throwable = super.getException();
        LOG.warn("Lock of {} failed.", (Object)this.vault.getDisplayName(), (Object)throwable);
        this.vault.stateProperty().transition(VaultState.Value.PROCESSING, VaultState.Value.UNLOCKED);
        if (throwable instanceof Volume.VolumeException) {
            this.lockWindow.setScene((Scene)this.lockFailedScene.get());
            this.lockWindow.show();
        } else {
            this.errorComponent.cause(throwable).window(this.lockWindow).build().showErrorScene();
        }
    }

    protected void cancelled() {
        LOG.debug("Lock of {} canceled.", (Object)this.vault.getDisplayName());
        this.vault.stateProperty().transition(VaultState.Value.PROCESSING, VaultState.Value.UNLOCKED);
    }
}

