/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.mainwindow;

import com.tobiasdiez.easybind.EasyBind;
import java.util.Optional;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.keychain.KeychainManager;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.fxapp.FxApplication;
import org.cryptomator.ui.mainwindow.MainWindow;
import org.cryptomator.ui.mainwindow.MainWindowScoped;
import org.cryptomator.ui.vaultoptions.SelectedVaultOptionsTab;
import org.cryptomator.ui.vaultoptions.VaultOptionsComponent;

@MainWindowScoped
public class VaultDetailLockedController
implements FxController {
    private final ReadOnlyObjectProperty<Vault> vault;
    private final FxApplication application;
    private final VaultOptionsComponent.Builder vaultOptionsWindow;
    private final KeychainManager keychain;
    private final Stage mainWindow;
    private final BooleanExpression passwordSaved;

    @Inject
    VaultDetailLockedController(ObjectProperty<Vault> vault, FxApplication application, VaultOptionsComponent.Builder vaultOptionsWindow, KeychainManager keychain, @MainWindow Stage mainWindow) {
        this.vault = vault;
        this.application = application;
        this.vaultOptionsWindow = vaultOptionsWindow;
        this.keychain = keychain;
        this.mainWindow = mainWindow;
        this.passwordSaved = keychain.isSupported() && !keychain.isLocked() ? BooleanExpression.booleanExpression((ObservableValue)EasyBind.select(vault).selectObject(v -> keychain.getPassphraseStoredProperty(v.getId()))) : new SimpleBooleanProperty(false);
    }

    @FXML
    public void unlock() {
        this.application.startUnlockWorkflow((Vault)this.vault.get(), Optional.of(this.mainWindow));
    }

    @FXML
    public void showVaultOptions() {
        this.vaultOptionsWindow.vault((Vault)this.vault.get()).build().showVaultOptionsWindow(SelectedVaultOptionsTab.ANY);
    }

    @FXML
    public void showKeyVaultOptions() {
        this.vaultOptionsWindow.vault((Vault)this.vault.get()).build().showVaultOptionsWindow(SelectedVaultOptionsTab.KEY);
    }

    public ReadOnlyObjectProperty<Vault> vaultProperty() {
        return this.vault;
    }

    public Vault getVault() {
        return (Vault)this.vault.get();
    }

    public BooleanExpression passwordSavedProperty() {
        return this.passwordSaved;
    }

    public boolean isPasswordSaved() {
        if (this.keychain.isSupported() && this.vault.get() != null) {
            return this.keychain.getPassphraseStoredProperty(((Vault)this.vault.get()).getId()).get();
        }
        return false;
    }
}

