/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.preferences;

import javafx.application.Application;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContentDisplay;
import javax.inject.Inject;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.fxapp.UpdateChecker;
import org.cryptomator.ui.preferences.PreferencesScoped;

@PreferencesScoped
public class UpdatesPreferencesController
implements FxController {
    private static final String DOWNLOADS_URI = "https://cryptomator.org/downloads";
    private final Application application;
    private final Settings settings;
    private final UpdateChecker updateChecker;
    private final ObjectBinding<ContentDisplay> checkForUpdatesButtonState;
    private final ReadOnlyStringProperty latestVersion;
    private final ReadOnlyStringProperty currentVersion;
    private final BooleanBinding updateAvailable;
    public CheckBox checkForUpdatesCheckbox;

    @Inject
    UpdatesPreferencesController(Application application, Settings settings, UpdateChecker updateChecker) {
        this.application = application;
        this.settings = settings;
        this.updateChecker = updateChecker;
        this.checkForUpdatesButtonState = Bindings.when((ObservableBooleanValue)updateChecker.checkingForUpdatesProperty()).then((Object)ContentDisplay.LEFT).otherwise((Object)ContentDisplay.TEXT_ONLY);
        this.latestVersion = updateChecker.latestVersionProperty();
        this.updateAvailable = this.latestVersion.isNotNull();
        this.currentVersion = updateChecker.currentVersionProperty();
    }

    public void initialize() {
        this.checkForUpdatesCheckbox.selectedProperty().bindBidirectional((Property)this.settings.checkForUpdates());
    }

    @FXML
    public void checkNow() {
        this.updateChecker.checkForUpdatesNow();
    }

    @FXML
    public void visitDownloadsPage() {
        this.application.getHostServices().showDocument(DOWNLOADS_URI);
    }

    public ObjectBinding<ContentDisplay> checkForUpdatesButtonStateProperty() {
        return this.checkForUpdatesButtonState;
    }

    public ContentDisplay getCheckForUpdatesButtonState() {
        return (ContentDisplay)this.checkForUpdatesButtonState.get();
    }

    public ReadOnlyStringProperty latestVersionProperty() {
        return this.latestVersion;
    }

    public String getLatestVersion() {
        return (String)this.latestVersion.get();
    }

    public ReadOnlyStringProperty currentVersionProperty() {
        return this.currentVersion;
    }

    public String getCurrentVersion() {
        return (String)this.currentVersion.get();
    }

    public BooleanBinding updateAvailableProperty() {
        return this.updateAvailable;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable.get();
    }
}

