/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.stats;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javax.inject.Provider;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.ui.common.DefaultSceneFactory;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxControllerKey;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlLoaderFactory;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.common.StageFactory;
import org.cryptomator.ui.stats.VaultStatisticsController;
import org.cryptomator.ui.stats.VaultStatisticsScoped;
import org.cryptomator.ui.stats.VaultStatisticsWindow;

@Module
abstract class VaultStatisticsModule {
    VaultStatisticsModule() {
    }

    @Provides
    @VaultStatisticsWindow
    @VaultStatisticsScoped
    static FxmlLoaderFactory provideFxmlLoaderFactory(Map<Class<? extends FxController>, Provider<FxController>> factories, DefaultSceneFactory sceneFactory, ResourceBundle resourceBundle) {
        return new FxmlLoaderFactory(factories, sceneFactory, resourceBundle);
    }

    @Provides
    @VaultStatisticsWindow
    @VaultStatisticsScoped
    static Stage provideStage(StageFactory factory, ResourceBundle resourceBundle, @VaultStatisticsWindow Vault vault) {
        Stage stage = factory.create();
        stage.setTitle(String.format(resourceBundle.getString("stats.title"), vault.getDisplayName()));
        stage.setResizable(false);
        final WeakReference<Stage> weakStage = new WeakReference<Stage>(stage);
        vault.stateProperty().addListener((ChangeListener)new ChangeListener<VaultState.Value>(){

            public void changed(ObservableValue<? extends VaultState.Value> observable, VaultState.Value oldValue, VaultState.Value newValue) {
                if (newValue != VaultState.Value.UNLOCKED) {
                    Stage stage = (Stage)weakStage.get();
                    if (stage != null) {
                        stage.hide();
                    }
                    observable.removeListener((ChangeListener)this);
                }
            }
        });
        stage.setOnCloseRequest(windowEvent -> vault.showingStatsProperty().setValue(Boolean.valueOf(false)));
        return stage;
    }

    @Provides
    @FxmlScene(value=FxmlFile.VAULT_STATISTICS)
    @VaultStatisticsScoped
    static Scene provideVaultStatisticsScene(@VaultStatisticsWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.VAULT_STATISTICS);
    }

    @Binds
    @IntoMap
    @FxControllerKey(value=VaultStatisticsController.class)
    abstract FxController bindVaultStatisticsController(VaultStatisticsController var1);
}

