/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.unlock;

import com.google.common.base.Throwables;
import dagger.Lazy;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NotDirectoryException;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.mountpoint.InvalidMountPointException;
import org.cryptomator.common.settings.WhenUnlocked;
import org.cryptomator.common.vaults.MountPointRequirement;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.common.vaults.Volume;
import org.cryptomator.cryptolib.api.CryptoException;
import org.cryptomator.ui.common.ErrorComponent;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.common.VaultService;
import org.cryptomator.ui.keyloading.KeyLoadingStrategy;
import org.cryptomator.ui.unlock.UnlockCancelledException;
import org.cryptomator.ui.unlock.UnlockScoped;
import org.cryptomator.ui.unlock.UnlockWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnlockScoped
public class UnlockWorkflow
extends Task<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(UnlockWorkflow.class);
    private final Stage window;
    private final Vault vault;
    private final VaultService vaultService;
    private final Lazy<Scene> successScene;
    private final Lazy<Scene> invalidMountPointScene;
    private final ErrorComponent.Builder errorComponent;
    private final KeyLoadingStrategy keyLoadingStrategy;

    @Inject
    UnlockWorkflow(@UnlockWindow Stage window, @UnlockWindow Vault vault, VaultService vaultService, @FxmlScene(value=FxmlFile.UNLOCK_SUCCESS) Lazy<Scene> successScene, @FxmlScene(value=FxmlFile.UNLOCK_INVALID_MOUNT_POINT) Lazy<Scene> invalidMountPointScene, ErrorComponent.Builder errorComponent, @UnlockWindow KeyLoadingStrategy keyLoadingStrategy) {
        this.window = window;
        this.vault = vault;
        this.vaultService = vaultService;
        this.successScene = successScene;
        this.invalidMountPointScene = invalidMountPointScene;
        this.errorComponent = errorComponent;
        this.keyLoadingStrategy = keyLoadingStrategy;
    }

    protected Boolean call() throws InterruptedException, IOException, Volume.VolumeException, InvalidMountPointException, CryptoException {
        try {
            this.attemptUnlock();
            return true;
        }
        catch (UnlockCancelledException e) {
            this.cancel(false);
            return false;
        }
    }

    private void attemptUnlock() throws IOException, Volume.VolumeException, InvalidMountPointException, CryptoException {
        try {
            this.keyLoadingStrategy.use(this.vault::unlock);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, IOException.class);
            Throwables.propagateIfPossible((Throwable)e, Volume.VolumeException.class);
            Throwables.propagateIfPossible((Throwable)e, InvalidMountPointException.class);
            Throwables.propagateIfPossible((Throwable)e, CryptoException.class);
            throw new IllegalStateException("unexpected exception type", e);
        }
    }

    private void handleInvalidMountPoint(InvalidMountPointException impExc) {
        MountPointRequirement requirement = this.vault.getVolume().orElseThrow(() -> new IllegalStateException("Invalid Mountpoint without a Volume?!", impExc)).getMountPointRequirement();
        assert (requirement != MountPointRequirement.NONE);
        assert (requirement != MountPointRequirement.PARENT_OPT_MOUNT_POINT);
        Throwable cause = impExc.getCause();
        if (cause instanceof NotDirectoryException) {
            if (requirement == MountPointRequirement.PARENT_NO_MOUNT_POINT) {
                LOG.error("Unlock failed. Parent folder is missing: {}", (Object)cause.getMessage());
            } else {
                LOG.error("Unlock failed. Mountpoint doesn't exist (needs to be a folder): {}", (Object)cause.getMessage());
            }
            this.showInvalidMountPointScene();
        } else if (cause instanceof FileAlreadyExistsException) {
            LOG.error("Unlock failed. Mountpoint already exists: {}", (Object)cause.getMessage());
            this.showInvalidMountPointScene();
        } else if (cause instanceof DirectoryNotEmptyException) {
            LOG.error("Unlock failed. Mountpoint not an empty directory: {}", (Object)cause.getMessage());
            this.showInvalidMountPointScene();
        } else {
            this.handleGenericError(impExc);
        }
    }

    private void showInvalidMountPointScene() {
        Platform.runLater(() -> {
            this.window.setScene((Scene)this.invalidMountPointScene.get());
            this.window.show();
        });
    }

    private void handleGenericError(Throwable e) {
        LOG.error("Unlock failed for technical reasons.", e);
        this.errorComponent.cause(e).window(this.window).build().showErrorScene();
    }

    protected void succeeded() {
        LOG.info("Unlock of '{}' succeeded.", (Object)this.vault.getDisplayName());
        switch ((WhenUnlocked)((Object)this.vault.getVaultSettings().actionAfterUnlock().get())) {
            case ASK: {
                Platform.runLater(() -> {
                    this.window.setScene((Scene)this.successScene.get());
                    this.window.show();
                });
                break;
            }
            case REVEAL: {
                Platform.runLater(() -> ((Stage)this.window).close());
                this.vaultService.reveal(this.vault);
                break;
            }
            case IGNORE: {
                Platform.runLater(() -> ((Stage)this.window).close());
            }
        }
        this.vault.stateProperty().transition(VaultState.Value.PROCESSING, VaultState.Value.UNLOCKED);
    }

    protected void failed() {
        LOG.info("Unlock of '{}' failed.", (Object)this.vault.getDisplayName());
        Throwable throwable = super.getException();
        if (throwable instanceof InvalidMountPointException) {
            InvalidMountPointException e = (InvalidMountPointException)throwable;
            this.handleInvalidMountPoint(e);
        } else {
            this.handleGenericError(throwable);
        }
        this.vault.stateProperty().transition(VaultState.Value.PROCESSING, VaultState.Value.LOCKED);
    }

    protected void cancelled() {
        LOG.debug("Unlock of '{}' canceled.", (Object)this.vault.getDisplayName());
        this.vault.stateProperty().transition(VaultState.Value.PROCESSING, VaultState.Value.LOCKED);
    }
}

