/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import com.google.common.base.Preconditions;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.SecretKey;

public class DestroyableSecretKey
implements SecretKey,
AutoCloseable {
    private final transient byte[] key;
    private final String algorithm;
    private boolean destroyed;

    public DestroyableSecretKey(byte[] key, String algorithm) {
        this(key, 0, key.length, algorithm);
    }

    public DestroyableSecretKey(byte[] key, int offset, int len, String algorithm) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"Invalid offset");
        Preconditions.checkArgument((len >= 0 ? 1 : 0) != 0, (Object)"Invalid length");
        Preconditions.checkArgument((key.length >= offset + len ? 1 : 0) != 0, (Object)"Invalid offset/len");
        this.key = new byte[len];
        this.algorithm = (String)Preconditions.checkNotNull((Object)algorithm, (Object)"Algorithm must not be null");
        this.destroyed = false;
        System.arraycopy(key, offset, this.key, 0, len);
    }

    public static DestroyableSecretKey from(Key secretKey) {
        if (secretKey instanceof DestroyableSecretKey) {
            return (DestroyableSecretKey)secretKey;
        }
        return new DestroyableSecretKey(secretKey.getEncoded(), secretKey.getAlgorithm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DestroyableSecretKey generate(SecureRandom csprng, String algorithm, int keyLenBytes) {
        byte[] key = new byte[keyLenBytes];
        try {
            csprng.nextBytes(key);
            DestroyableSecretKey destroyableSecretKey = new DestroyableSecretKey(key, algorithm);
            return destroyableSecretKey;
        }
        finally {
            Arrays.fill(key, (byte)0);
        }
    }

    @Override
    public String getAlgorithm() {
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"Key has been destroyed");
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"Key has been destroyed");
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"Key has been destroyed");
        return this.key;
    }

    public DestroyableSecretKey copy() {
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"Key has been destroyed");
        return new DestroyableSecretKey(this.key, this.algorithm);
    }

    @Override
    public void destroy() {
        Arrays.fill(this.key, (byte)0);
        this.destroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void close() {
        this.destroy();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DestroyableSecretKey that = (DestroyableSecretKey)o;
        return this.algorithm.equals(that.algorithm) && MessageDigest.isEqual(this.key, that.key);
    }

    public int hashCode() {
        int result = Objects.hash(this.algorithm);
        result = 31 * result + Arrays.hashCode(this.key);
        return result;
    }
}

