/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class MessageDigestSupplier {
    public static final MessageDigestSupplier SHA1 = new MessageDigestSupplier("SHA-1");
    private final String digestAlgorithm;
    private final ThreadLocal<MessageDigest> threadLocal;

    public MessageDigestSupplier(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        this.threadLocal = new Provider();
    }

    public MessageDigest get() {
        MessageDigest result = this.threadLocal.get();
        result.reset();
        return result;
    }

    private class Provider
    extends ThreadLocal<MessageDigest> {
        private Provider() {
        }

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance(MessageDigestSupplier.this.digestAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("Invalid digest algorithm.", e);
            }
        }
    }
}

