/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.file.AccessDeniedException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.Set;
import javax.inject.Inject;
import jnr.ffi.Pointer;
import org.cryptomator.frontend.fuse.FileAttributesUtil;
import org.cryptomator.frontend.fuse.OpenFile;
import org.cryptomator.frontend.fuse.OpenFileFactory;
import org.cryptomator.frontend.fuse.OpenOptionsUtil;
import org.cryptomator.frontend.fuse.PerAdapter;
import ru.serce.jnrfuse.struct.FileStat;
import ru.serce.jnrfuse.struct.FuseFileInfo;

@PerAdapter
public class ReadOnlyFileHandler
implements Closeable {
    protected final OpenFileFactory openFiles;
    protected final FileAttributesUtil attrUtil;
    private final OpenOptionsUtil openOptionsUtil;

    @Inject
    public ReadOnlyFileHandler(OpenFileFactory openFiles, FileAttributesUtil attrUtil, OpenOptionsUtil openOptionsUtil) {
        this.openFiles = openFiles;
        this.attrUtil = attrUtil;
        this.openOptionsUtil = openOptionsUtil;
    }

    public void open(Path path, FuseFileInfo fi) throws IOException {
        Set<OpenOption> openOptions = this.openOptionsUtil.fuseOpenFlagsToNioOpenOptions(fi.flags.longValue());
        long fileHandle = this.open(path, openOptions);
        fi.fh.set(fileHandle);
    }

    protected long open(Path path, Set<OpenOption> openOptions) throws AccessDeniedException, IOException {
        if (openOptions.contains(StandardOpenOption.WRITE)) {
            throw new AccessDeniedException(path.toString(), null, "Unsupported open options: WRITE");
        }
        return this.openFiles.open(path, StandardOpenOption.READ);
    }

    public int read(Pointer buf, long size, long offset, FuseFileInfo fi) throws IOException {
        OpenFile file = this.openFiles.get(fi.fh.get());
        if (file == null) {
            throw new ClosedChannelException();
        }
        return file.read(buf, size, offset);
    }

    public void release(FuseFileInfo fi) throws IOException {
        this.openFiles.close(fi.fh.get());
    }

    public int getattr(Path node, BasicFileAttributes attrs, FileStat stat) {
        if (attrs instanceof PosixFileAttributes) {
            PosixFileAttributes posixAttrs = (PosixFileAttributes)attrs;
            long mode = this.attrUtil.posixPermissionsToOctalMode(posixAttrs.permissions());
            stat.st_mode.set((Number)(0x8000L | (mode &= 0x16DL)));
        } else {
            stat.st_mode.set((Number)33060);
        }
        this.attrUtil.copyBasicFileAttributesFromNioToFuse(attrs, stat);
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.openFiles.close();
    }
}

