/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse.mount;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.Normalizer;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import org.cryptomator.frontend.fuse.FileNameTranscoder;
import org.cryptomator.frontend.fuse.FuseNioAdapter;
import org.cryptomator.frontend.fuse.VersionCompare;
import org.cryptomator.frontend.fuse.mount.AbstractMount;
import org.cryptomator.frontend.fuse.mount.AbstractMounter;
import org.cryptomator.frontend.fuse.mount.EnvironmentVariables;
import org.cryptomator.frontend.fuse.mount.FuseMountException;
import org.cryptomator.frontend.fuse.mount.Mount;
import org.cryptomator.frontend.fuse.mount.ProcessUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class MacMounter
extends AbstractMounter {
    private static final Logger LOG = LoggerFactory.getLogger(MacMounter.class);
    private static final boolean IS_MAC = System.getProperty("os.name").toLowerCase().contains("mac");
    private static final Path USER_HOME = Paths.get(System.getProperty("user.home"), new String[0]);
    private static final String MACFUSE_MINIMUM_SUPPORTED_VERSION = "4.0.4";
    private static final String MACFUSE_VERSIONFILE_LOCATION = "/Library/Filesystems/macfuse.fs/Contents/version.plist";
    private static final String MACFUSE_VERSIONFILE_XPATH = "/plist/dict/key[.='CFBundleShortVersionString']/following-sibling::string[1]";
    private static final String PLIST_DTD_URL = "http://www.apple.com/DTDs/PropertyList-1.0.dtd";

    MacMounter() {
    }

    @Override
    public String[] defaultMountFlags() {
        try {
            return new String[]{"-ouid=" + Files.getAttribute(USER_HOME, "unix:uid", new LinkOption[0]), "-ogid=" + Files.getAttribute(USER_HOME, "unix:gid", new LinkOption[0]), "-oatomic_o_trunc", "-oauto_xattr", "-oauto_cache", "-onoappledouble", "-odefault_permissions"};
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public FileNameTranscoder defaultFileNameTranscoder() {
        return FileNameTranscoder.transcoder().withFuseNormalization(Normalizer.Form.NFD);
    }

    @Override
    public boolean isApplicable() {
        return IS_MAC && Files.exists(Paths.get("/usr/local/lib/libosxfuse.2.dylib", new String[0]), new LinkOption[0]) && this.installedVersionSupported();
    }

    @Override
    protected Mount createMountObject(FuseNioAdapter fuseNioAdapter, EnvironmentVariables envVars) {
        return new MacMount(fuseNioAdapter, envVars);
    }

    public boolean installedVersionSupported() {
        String installedVersion = this.getInstalledVersion(MACFUSE_VERSIONFILE_LOCATION, MACFUSE_VERSIONFILE_XPATH);
        if (installedVersion == null) {
            return false;
        }
        return VersionCompare.compareVersions(installedVersion, MACFUSE_MINIMUM_SUPPORTED_VERSION) >= 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getInstalledVersion(String plistFileLocation, String versionXPath) {
        Path plistFile = Paths.get(plistFileLocation, new String[0]);
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        XPath xPath = XPathFactory.newInstance().newXPath();
        try (InputStream in = Files.newInputStream(plistFile, StandardOpenOption.READ);){
            DocumentBuilder docBuilder = domFactory.newDocumentBuilder();
            docBuilder.setEntityResolver(this::resolveEntity);
            Document doc = docBuilder.parse(in);
            NodeList nodeList = (NodeList)xPath.compile(versionXPath).evaluate(doc, XPathConstants.NODESET);
            Node node = nodeList.item(0);
            if (node == null) {
                LOG.error("Did not find {} in document {}.", (Object)versionXPath, (Object)plistFileLocation);
                String string2 = null;
                return string2;
            }
            String string = node.getTextContent();
            return string;
        }
        catch (ParserConfigurationException | XPathException | SAXException e) {
            LOG.error("Could not parse " + plistFileLocation + " to detect version of macFUSE.", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOG.error("Could not read " + plistFileLocation + " to detect version of macFUSE.", (Throwable)e);
            return null;
        }
    }

    private InputSource resolveEntity(String publicId, String systemId) {
        if (PLIST_DTD_URL.equals(systemId)) {
            return new InputSource(this.getClass().getResourceAsStream("/PropertyList-1.0.dtd"));
        }
        return null;
    }

    private static class MacMount
    extends AbstractMount {
        private MacMount(FuseNioAdapter fuseAdapter, EnvironmentVariables envVars) {
            super(fuseAdapter, envVars.getMountPoint());
        }

        @Override
        public void unmountInternal() throws FuseMountException {
            if (!this.fuseAdapter.isMounted()) {
                return;
            }
            ProcessBuilder command = new ProcessBuilder("umount", "--", this.mountPoint.getFileName().toString());
            command.directory(this.mountPoint.getParent().toFile());
            Process proc = ProcessUtil.startAndWaitFor(command, 5L, TimeUnit.SECONDS);
            this.assertUmountSucceeded(proc);
            this.fuseAdapter.setUnmounted();
        }

        @Override
        public void unmountForcedInternal() throws FuseMountException {
            if (!this.fuseAdapter.isMounted()) {
                return;
            }
            ProcessBuilder command = new ProcessBuilder("umount", "-f", "--", this.mountPoint.getFileName().toString());
            command.directory(this.mountPoint.getParent().toFile());
            Process proc = ProcessUtil.startAndWaitFor(command, 5L, TimeUnit.SECONDS);
            this.assertUmountSucceeded(proc);
            this.fuseAdapter.setUnmounted();
        }

        private void assertUmountSucceeded(Process proc) throws FuseMountException {
            if (proc.exitValue() == 0) {
                return;
            }
            try {
                String stderr = ProcessUtil.toString(proc.getErrorStream(), StandardCharsets.US_ASCII);
                if (stderr.contains("not currently mounted")) {
                    LOG.info("Already unmounted");
                    return;
                }
                throw new FuseMountException("Unmount failed. STDERR: " + stderr);
            }
            catch (IOException e) {
                throw new FuseMountException(e);
            }
        }
    }
}

