# dependencies:
# xlib-2.0
# GLib-2.0
# Gdk-3.0
# HarfBuzz-0.0
# GdkPixbuf-2.0
# cairo-1.0
# GObject-2.0
# Pango-1.0
# Gio-2.0
# GModule-2.0
# Atk-1.0
# immediate dependencies:
# xlib-2.0
# Gdk-3.0
# Atk-1.0
# libraries:
# libgtk-3.so.0,libgdk-3.so.0
{.warning[UnusedImport]: off.}
import xlib, glib, gdk, harfbuzz, gdkpixbuf, cairo, gobject, pango, gio, gmodule, atk
const Lib = "libgtk-3.so.0"
{.pragma: libprag, cdecl, dynlib: Lib.}

proc finalizeGObject*[T](o: ref T) =
  if not o.ignoreFinalizer:
    gobject.g_object_remove_toggle_ref(o.impl, gobject.toggleNotify, addr(o[]))

type
  TextDirection* {.size: sizeof(cint), pure.} = enum
    none = 0
    ltr = 1
    rtl = 2

type
  SelectionData00* {.pure.} = object
  SelectionData* = ref object
    impl*: ptr SelectionData00
    ignoreFinalizer*: bool

proc gtk_selection_data_get_type*(): GType {.importc, libprag.}

proc gBoxedFreeGtkSelectionData*(self: SelectionData) =
  if not self.ignoreFinalizer:
    boxedFree(gtk_selection_data_get_type(), cast[ptr SelectionData00](self.impl))

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(SelectionData()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    if not self.ignoreFinalizer and self.impl != nil:
      boxedFree(gtk_selection_data_get_type(), cast[ptr SelectionData00](self.impl))
      self.impl = nil

proc newWithFinalizer*(x: var SelectionData) =
  when defined(gcDestructors):
    new(x)
  else:
    new(x, gBoxedFreeGtkSelectionData)

proc gtk_selection_data_free(self: ptr SelectionData00) {.
    importc, libprag.}

proc free*(self: SelectionData) =
  gtk_selection_data_free(cast[ptr SelectionData00](self.impl))

proc finalizerfree*(self: SelectionData) =
  if not self.ignoreFinalizer:
    gtk_selection_data_free(cast[ptr SelectionData00](self.impl))

proc gtk_selection_data_copy(self: ptr SelectionData00): ptr SelectionData00 {.
    importc, libprag.}

proc copy*(self: SelectionData): SelectionData =
  fnew(result, gBoxedFreeGtkSelectionData)
  result.impl = gtk_selection_data_copy(cast[ptr SelectionData00](self.impl))

proc gtk_selection_data_get_data_type(self: ptr SelectionData00): ptr gdk.Atom00 {.
    importc, libprag.}

proc getDataType*(self: SelectionData): gdk.Atom =
  new(result)
  result.impl = gtk_selection_data_get_data_type(cast[ptr SelectionData00](self.impl))
  result.ignoreFinalizer = true

proc dataType*(self: SelectionData): gdk.Atom =
  new(result)
  result.impl = gtk_selection_data_get_data_type(cast[ptr SelectionData00](self.impl))
  result.ignoreFinalizer = true

proc gtk_selection_data_get_data_with_length(self: ptr SelectionData00; length: var int32): ptr uint8 {.
    importc, libprag.}

proc getData*(self: SelectionData; length: var int): seq[uint8] =
  var length_00: int32
  result = uint8ArrayToSeq(gtk_selection_data_get_data_with_length(cast[ptr SelectionData00](self.impl), length_00), length.int)
  if length.addr != nil:
    length = int(length_00)

proc gtk_selection_data_get_display(self: ptr SelectionData00): ptr gdk.Display00 {.
    importc, libprag.}

proc getDisplay*(self: SelectionData): gdk.Display =
  let gobj = gtk_selection_data_get_display(cast[ptr SelectionData00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc display*(self: SelectionData): gdk.Display =
  let gobj = gtk_selection_data_get_display(cast[ptr SelectionData00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_selection_data_get_format(self: ptr SelectionData00): int32 {.
    importc, libprag.}

proc getFormat*(self: SelectionData): int =
  int(gtk_selection_data_get_format(cast[ptr SelectionData00](self.impl)))

proc format*(self: SelectionData): int =
  int(gtk_selection_data_get_format(cast[ptr SelectionData00](self.impl)))

proc gtk_selection_data_get_length(self: ptr SelectionData00): int32 {.
    importc, libprag.}

proc getLength*(self: SelectionData): int =
  int(gtk_selection_data_get_length(cast[ptr SelectionData00](self.impl)))

proc length*(self: SelectionData): int =
  int(gtk_selection_data_get_length(cast[ptr SelectionData00](self.impl)))

proc gtk_selection_data_get_pixbuf(self: ptr SelectionData00): ptr gdkpixbuf.Pixbuf00 {.
    importc, libprag.}

proc getPixbuf*(self: SelectionData): gdkpixbuf.Pixbuf =
  let gobj = gtk_selection_data_get_pixbuf(cast[ptr SelectionData00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdkpixbuf.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc pixbuf*(self: SelectionData): gdkpixbuf.Pixbuf =
  let gobj = gtk_selection_data_get_pixbuf(cast[ptr SelectionData00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdkpixbuf.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_selection_data_get_selection(self: ptr SelectionData00): ptr gdk.Atom00 {.
    importc, libprag.}

proc getSelection*(self: SelectionData): gdk.Atom =
  new(result)
  result.impl = gtk_selection_data_get_selection(cast[ptr SelectionData00](self.impl))
  result.ignoreFinalizer = true

proc selection*(self: SelectionData): gdk.Atom =
  new(result)
  result.impl = gtk_selection_data_get_selection(cast[ptr SelectionData00](self.impl))
  result.ignoreFinalizer = true

proc gtk_selection_data_get_target(self: ptr SelectionData00): ptr gdk.Atom00 {.
    importc, libprag.}

proc getTarget*(self: SelectionData): gdk.Atom =
  new(result)
  result.impl = gtk_selection_data_get_target(cast[ptr SelectionData00](self.impl))
  result.ignoreFinalizer = true

proc target*(self: SelectionData): gdk.Atom =
  new(result)
  result.impl = gtk_selection_data_get_target(cast[ptr SelectionData00](self.impl))
  result.ignoreFinalizer = true

proc gtk_selection_data_get_text(self: ptr SelectionData00): cstring {.
    importc, libprag.}

proc getText*(self: SelectionData): string =
  let resul0 = gtk_selection_data_get_text(cast[ptr SelectionData00](self.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc text*(self: SelectionData): string =
  let resul0 = gtk_selection_data_get_text(cast[ptr SelectionData00](self.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc gtk_selection_data_get_uris(self: ptr SelectionData00): ptr cstring {.
    importc, libprag.}

proc getUris*(self: SelectionData): seq[string] =
  let resul0 = gtk_selection_data_get_uris(cast[ptr SelectionData00](self.impl))
  if resul0.isNil:
    return
  result = cstringArrayToSeq(resul0)
  g_strfreev(resul0)

proc uris*(self: SelectionData): seq[string] =
  let resul0 = gtk_selection_data_get_uris(cast[ptr SelectionData00](self.impl))
  if resul0.isNil:
    return
  result = cstringArrayToSeq(resul0)
  g_strfreev(resul0)

proc gtk_selection_data_set(self: ptr SelectionData00; `type`: ptr gdk.Atom00;
    format: int32; data: ptr uint8; length: int32) {.
    importc, libprag.}

proc set*(self: SelectionData; `type`: gdk.Atom; format: int;
    data: seq[uint8] | string) =
  let length = int(data.len)
  gtk_selection_data_set(cast[ptr SelectionData00](self.impl), cast[ptr gdk.Atom00](`type`.impl), int32(format), cast[ptr uint8](unsafeaddr(data[0])), int32(length))

proc gtk_selection_data_set_pixbuf(self: ptr SelectionData00; pixbuf: ptr gdkpixbuf.Pixbuf00): gboolean {.
    importc, libprag.}

proc setPixbuf*(self: SelectionData; pixbuf: gdkpixbuf.Pixbuf): bool =
  toBool(gtk_selection_data_set_pixbuf(cast[ptr SelectionData00](self.impl), cast[ptr gdkpixbuf.Pixbuf00](pixbuf.impl)))

proc gtk_selection_data_set_text(self: ptr SelectionData00; str: cstring;
    len: int32): gboolean {.
    importc, libprag.}

proc setText*(self: SelectionData; str: cstring; len: int): bool =
  toBool(gtk_selection_data_set_text(cast[ptr SelectionData00](self.impl), str, int32(len)))

proc gtk_selection_data_set_uris(self: ptr SelectionData00; uris: ptr cstring): gboolean {.
    importc, libprag.}

proc setUris*(self: SelectionData; uris: varargs[string, `$`]): bool =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  toBool(gtk_selection_data_set_uris(cast[ptr SelectionData00](self.impl), seq2CstringArray(uris, fs469n23)))

proc gtk_selection_data_targets_include_image(self: ptr SelectionData00;
    writable: gboolean): gboolean {.
    importc, libprag.}

proc targetsIncludeImage*(self: SelectionData; writable: bool): bool =
  toBool(gtk_selection_data_targets_include_image(cast[ptr SelectionData00](self.impl), gboolean(writable)))

proc gtk_selection_data_targets_include_text(self: ptr SelectionData00): gboolean {.
    importc, libprag.}

proc targetsIncludeText*(self: SelectionData): bool =
  toBool(gtk_selection_data_targets_include_text(cast[ptr SelectionData00](self.impl)))

proc gtk_selection_data_targets_include_uri(self: ptr SelectionData00): gboolean {.
    importc, libprag.}

proc targetsIncludeUri*(self: SelectionData): bool =
  toBool(gtk_selection_data_targets_include_uri(cast[ptr SelectionData00](self.impl)))

type
  DragResult* {.size: sizeof(cint), pure.} = enum
    success = 0
    noTarget = 1
    userCancelled = 2
    timeoutExpired = 3
    grabBroken = 4
    error = 5

type
  DirectionType* {.size: sizeof(cint), pure.} = enum
    tabForward = 0
    tabBackward = 1
    up = 2
    down = 3
    left = 4
    right = 5

type
  Tooltip* = ref object of gobject.Object
  Tooltip00* = object of gobject.Object00

proc gtk_tooltip_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Tooltip()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_tooltip_trigger_tooltip_query(display: ptr gdk.Display00) {.
    importc, libprag.}

proc triggerTooltipQuery*(display: gdk.Display) =
  gtk_tooltip_trigger_tooltip_query(cast[ptr gdk.Display00](display.impl))

proc gtk_tooltip_set_icon(self: ptr Tooltip00; pixbuf: ptr gdkpixbuf.Pixbuf00) {.
    importc, libprag.}

proc setIcon*(self: Tooltip; pixbuf: gdkpixbuf.Pixbuf = nil) =
  gtk_tooltip_set_icon(cast[ptr Tooltip00](self.impl), if pixbuf.isNil: nil else: cast[ptr gdkpixbuf.Pixbuf00](pixbuf.impl))

proc `icon=`*(self: Tooltip; pixbuf: gdkpixbuf.Pixbuf = nil) =
  gtk_tooltip_set_icon(cast[ptr Tooltip00](self.impl), if pixbuf.isNil: nil else: cast[ptr gdkpixbuf.Pixbuf00](pixbuf.impl))

proc gtk_tooltip_set_icon_from_gicon(self: ptr Tooltip00; gicon: ptr gio.Icon00;
    size: int32) {.
    importc, libprag.}

proc setIconFromGicon*(self: Tooltip; gicon: gio.Icon = nil;
    size: int) =
  gtk_tooltip_set_icon_from_gicon(cast[ptr Tooltip00](self.impl), if gicon.isNil: nil else: cast[ptr gio.Icon00](gicon.impl), int32(size))

proc gtk_tooltip_set_icon_from_icon_name(self: ptr Tooltip00; iconName: cstring;
    size: int32) {.
    importc, libprag.}

proc setIconFromIconName*(self: Tooltip; iconName: cstring = nil;
    size: int) =
  gtk_tooltip_set_icon_from_icon_name(cast[ptr Tooltip00](self.impl), iconName, int32(size))

proc gtk_tooltip_set_icon_from_stock(self: ptr Tooltip00; stockId: cstring;
    size: int32) {.
    importc, libprag.}

proc setIconFromStock*(self: Tooltip; stockId: cstring = nil;
    size: int) =
  gtk_tooltip_set_icon_from_stock(cast[ptr Tooltip00](self.impl), stockId, int32(size))

proc gtk_tooltip_set_markup(self: ptr Tooltip00; markup: cstring) {.
    importc, libprag.}

proc setMarkup*(self: Tooltip; markup: cstring = nil) =
  gtk_tooltip_set_markup(cast[ptr Tooltip00](self.impl), markup)

proc `markup=`*(self: Tooltip; markup: cstring = nil) =
  gtk_tooltip_set_markup(cast[ptr Tooltip00](self.impl), markup)

proc gtk_tooltip_set_text(self: ptr Tooltip00; text: cstring) {.
    importc, libprag.}

proc setText*(self: Tooltip; text: cstring = nil) =
  gtk_tooltip_set_text(cast[ptr Tooltip00](self.impl), text)

proc `text=`*(self: Tooltip; text: cstring = nil) =
  gtk_tooltip_set_text(cast[ptr Tooltip00](self.impl), text)

proc gtk_tooltip_set_tip_area(self: ptr Tooltip00; rect: gdk.Rectangle) {.
    importc, libprag.}

proc setTipArea*(self: Tooltip; rect: gdk.Rectangle) =
  gtk_tooltip_set_tip_area(cast[ptr Tooltip00](self.impl), rect)

proc `tipArea=`*(self: Tooltip; rect: gdk.Rectangle) =
  gtk_tooltip_set_tip_area(cast[ptr Tooltip00](self.impl), rect)

type
  WidgetHelpType* {.size: sizeof(cint), pure.} = enum
    tooltip = 0
    whatsThis = 1

type
  StateType* {.size: sizeof(cint), pure.} = enum
    normal = 0
    active = 1
    prelight = 2
    selected = 3
    insensitive = 4
    inconsistent = 5
    focused = 6

type
  StateFlag* {.size: sizeof(cint), pure.} = enum
    active = 0
    prelight = 1
    selected = 2
    insensitive = 3
    inconsistent = 4
    focused = 5
    backdrop = 6
    dirLtr = 7
    dirRtl = 8
    link = 9
    visited = 10
    checked = 11
    dropActive = 12

  StateFlags* {.size: sizeof(cint).} = set[StateFlag]

const
  StateFlagsNormal* = StateFlags({})
proc normal*(t: typedesc[StateFlags]): StateFlags = StateFlags({})

type
  Style* = ref object of gobject.Object
  Style00* = object of gobject.Object00

proc gtk_style_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Style()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scRealize*(self: Style;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "realize", cast[GCallback](p), xdata, nil, cf)

proc scUnrealize*(self: Style;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "unrealize", cast[GCallback](p), xdata, nil, cf)

proc gtk_style_new(): ptr Style00 {.
    importc, libprag.}

proc newStyle*(): Style {.deprecated.}  =
  let gobj = gtk_style_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newStyle*(tdesc: typedesc): tdesc {.deprecated.}  =
  assert(result is Style)
  let gobj = gtk_style_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initStyle*[T](result: var T) {.deprecated.} =
  assert(result is Style)
  let gobj = gtk_style_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_style_apply_default_background(self: ptr Style00; cr: ptr cairo.Context00;
    window: ptr gdk.Window00; stateType: StateType; x: int32; y: int32; width: int32;
    height: int32) {.
    importc, libprag.}

proc applyDefaultBackground*(self: Style; cr: cairo.Context; window: gdk.Window;
    stateType: StateType; x: int; y: int; width: int; height: int) =
  gtk_style_apply_default_background(cast[ptr Style00](self.impl), cast[ptr cairo.Context00](cr.impl), cast[ptr gdk.Window00](window.impl), stateType, int32(x), int32(y), int32(width), int32(height))

proc gtk_style_copy(self: ptr Style00): ptr Style00 {.
    importc, libprag.}

proc copy*(self: Style): Style =
  let gobj = gtk_style_copy(cast[ptr Style00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_style_detach(self: ptr Style00) {.
    importc, libprag.}

proc detach*(self: Style) =
  gtk_style_detach(cast[ptr Style00](self.impl))

proc gtk_style_get_style_property(self: ptr Style00; widgetType: GType; propertyName: cstring;
    value: var gobject.Value) {.
    importc, libprag.}

proc getStyleProperty*(self: Style; widgetType: GType; propertyName: cstring;
    value: var gobject.Value) =
  gtk_style_get_style_property(cast[ptr Style00](self.impl), widgetType, propertyName, value)

proc gtk_style_has_context(self: ptr Style00): gboolean {.
    importc, libprag.}

proc hasContext*(self: Style): bool =
  toBool(gtk_style_has_context(cast[ptr Style00](self.impl)))

proc gtk_style_lookup_color(self: ptr Style00; colorName: cstring; color: var gdk.Color): gboolean {.
    importc, libprag.}

proc lookupColor*(self: Style; colorName: cstring; color: var gdk.Color): bool =
  toBool(gtk_style_lookup_color(cast[ptr Style00](self.impl), colorName, color))

proc gtk_style_set_background(self: ptr Style00; window: ptr gdk.Window00;
    stateType: StateType) {.
    importc, libprag.}

proc setBackground*(self: Style; window: gdk.Window; stateType: StateType) =
  gtk_style_set_background(cast[ptr Style00](self.impl), cast[ptr gdk.Window00](window.impl), stateType)

type
  Widget* = ref object of gobject.InitiallyUnowned
  Widget00* = object of gobject.InitiallyUnowned00

proc gtk_widget_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Widget()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scAccelClosuresChanged*(self: Widget;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "accel-closures-changed", cast[GCallback](p), xdata, nil, cf)

proc scButtonPressEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventButton00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "button-press-event", cast[GCallback](p), xdata, nil, cf)

proc scButtonReleaseEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventButton00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "button-release-event", cast[GCallback](p), xdata, nil, cf)

proc scCanActivateAccel*(self: Widget;  p: proc (self: ptr Widget00; signalId: uint32; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "can-activate-accel", cast[GCallback](p), xdata, nil, cf)

proc scChildNotify*(self: Widget;  p: proc (self: ptr Widget00; childProperty: ptr gobject.ParamSpec00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "child-notify", cast[GCallback](p), xdata, nil, cf)

proc scCompositedChanged*(self: Widget;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "composited-changed", cast[GCallback](p), xdata, nil, cf)

proc scConfigureEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventConfigure00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "configure-event", cast[GCallback](p), xdata, nil, cf)

proc scDamageEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventExpose00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "damage-event", cast[GCallback](p), xdata, nil, cf)

proc scDeleteEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.Event00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "delete-event", cast[GCallback](p), xdata, nil, cf)

proc scDestroy*(self: Widget;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "destroy", cast[GCallback](p), xdata, nil, cf)

proc scDestroyEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.Event00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "destroy-event", cast[GCallback](p), xdata, nil, cf)

proc scDirectionChanged*(self: Widget;  p: proc (self: ptr Widget00; previousDirection: TextDirection; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "direction-changed", cast[GCallback](p), xdata, nil, cf)

proc scDragBegin*(self: Widget;  p: proc (self: ptr Widget00; context: ptr gdk.DragContext00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "drag-begin", cast[GCallback](p), xdata, nil, cf)

proc scDragDataDelete*(self: Widget;  p: proc (self: ptr Widget00; context: ptr gdk.DragContext00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "drag-data-delete", cast[GCallback](p), xdata, nil, cf)

proc scDragDataGet*(self: Widget;  p: proc (self: ptr Widget00; context: ptr gdk.DragContext00; data: ptr SelectionData00; info: uint32;
    time: uint32; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "drag-data-get", cast[GCallback](p), xdata, nil, cf)

proc scDragDataReceived*(self: Widget;  p: proc (self: ptr Widget00; context: ptr gdk.DragContext00; x: int32; y: int32; data: ptr SelectionData00;
    info: uint32; time: uint32; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "drag-data-received", cast[GCallback](p), xdata, nil, cf)

proc scDragDrop*(self: Widget;  p: proc (self: ptr Widget00; context: ptr gdk.DragContext00; x: int32; y: int32; time: uint32; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "drag-drop", cast[GCallback](p), xdata, nil, cf)

proc scDragEnd*(self: Widget;  p: proc (self: ptr Widget00; context: ptr gdk.DragContext00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "drag-end", cast[GCallback](p), xdata, nil, cf)

proc scDragFailed*(self: Widget;  p: proc (self: ptr Widget00; context: ptr gdk.DragContext00; resu: DragResult; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "drag-failed", cast[GCallback](p), xdata, nil, cf)

proc scDragLeave*(self: Widget;  p: proc (self: ptr Widget00; context: ptr gdk.DragContext00; time: uint32; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "drag-leave", cast[GCallback](p), xdata, nil, cf)

proc scDragMotion*(self: Widget;  p: proc (self: ptr Widget00; context: ptr gdk.DragContext00; x: int32; y: int32; time: uint32; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "drag-motion", cast[GCallback](p), xdata, nil, cf)

proc scDraw*(self: Widget;  p: proc (self: ptr Widget00; cr: ptr cairo.Context00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "draw", cast[GCallback](p), xdata, nil, cf)

proc scEnterNotifyEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventCrossing00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "enter-notify-event", cast[GCallback](p), xdata, nil, cf)

proc scEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.Event00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "event", cast[GCallback](p), xdata, nil, cf)

proc scEventAfter*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.Event00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "event-after", cast[GCallback](p), xdata, nil, cf)

proc scFocus*(self: Widget;  p: proc (self: ptr Widget00; direction: DirectionType; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "focus", cast[GCallback](p), xdata, nil, cf)

proc scFocusInEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventFocus00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "focus-in-event", cast[GCallback](p), xdata, nil, cf)

proc scFocusOutEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventFocus00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "focus-out-event", cast[GCallback](p), xdata, nil, cf)

proc scGrabBrokenEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventGrabBroken00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "grab-broken-event", cast[GCallback](p), xdata, nil, cf)

proc scGrabFocus*(self: Widget;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "grab-focus", cast[GCallback](p), xdata, nil, cf)

proc scGrabNotify*(self: Widget;  p: proc (self: ptr Widget00; wasGrabbed: gboolean; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "grab-notify", cast[GCallback](p), xdata, nil, cf)

proc scHide*(self: Widget;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "hide", cast[GCallback](p), xdata, nil, cf)

proc scHierarchyChanged*(self: Widget;  p: proc (self: ptr Widget00; previousToplevel: ptr Widget00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "hierarchy-changed", cast[GCallback](p), xdata, nil, cf)

proc scKeyPressEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventKey00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "key-press-event", cast[GCallback](p), xdata, nil, cf)

proc scKeyReleaseEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventKey00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "key-release-event", cast[GCallback](p), xdata, nil, cf)

proc scKeynavFailed*(self: Widget;  p: proc (self: ptr Widget00; direction: DirectionType; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "keynav-failed", cast[GCallback](p), xdata, nil, cf)

proc scLeaveNotifyEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventCrossing00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "leave-notify-event", cast[GCallback](p), xdata, nil, cf)

proc scMap*(self: Widget;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "map", cast[GCallback](p), xdata, nil, cf)

proc scMapEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventAny00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "map-event", cast[GCallback](p), xdata, nil, cf)

proc scMnemonicActivate*(self: Widget;  p: proc (self: ptr Widget00; groupCycling: gboolean; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "mnemonic-activate", cast[GCallback](p), xdata, nil, cf)

proc scMotionNotifyEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventMotion00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "motion-notify-event", cast[GCallback](p), xdata, nil, cf)

proc scMoveFocus*(self: Widget;  p: proc (self: ptr Widget00; direction: DirectionType; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "move-focus", cast[GCallback](p), xdata, nil, cf)

proc scParentSet*(self: Widget;  p: proc (self: ptr Widget00; oldParent: ptr Widget00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "parent-set", cast[GCallback](p), xdata, nil, cf)

proc scPopupMenu*(self: Widget;  p: proc (self: ptr Widget00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "popup-menu", cast[GCallback](p), xdata, nil, cf)

proc scPropertyNotifyEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventProperty00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "property-notify-event", cast[GCallback](p), xdata, nil, cf)

proc scProximityInEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventProximity00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "proximity-in-event", cast[GCallback](p), xdata, nil, cf)

proc scProximityOutEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventProximity00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "proximity-out-event", cast[GCallback](p), xdata, nil, cf)

proc scQueryTooltip*(self: Widget;  p: proc (self: ptr Widget00; x: int32; y: int32; keyboardMode: gboolean; tooltip: ptr Tooltip00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "query-tooltip", cast[GCallback](p), xdata, nil, cf)

proc scRealize*(self: Widget;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "realize", cast[GCallback](p), xdata, nil, cf)

proc scScreenChanged*(self: Widget;  p: proc (self: ptr Widget00; previousScreen: ptr gdk.Screen00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "screen-changed", cast[GCallback](p), xdata, nil, cf)

proc scScrollEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventScroll00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "scroll-event", cast[GCallback](p), xdata, nil, cf)

proc scSelectionClearEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventSelection00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "selection-clear-event", cast[GCallback](p), xdata, nil, cf)

proc scSelectionGet*(self: Widget;  p: proc (self: ptr Widget00; data: ptr SelectionData00; info: uint32; time: uint32; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "selection-get", cast[GCallback](p), xdata, nil, cf)

proc scSelectionNotifyEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventSelection00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "selection-notify-event", cast[GCallback](p), xdata, nil, cf)

proc scSelectionReceived*(self: Widget;  p: proc (self: ptr Widget00; data: ptr SelectionData00; time: uint32; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "selection-received", cast[GCallback](p), xdata, nil, cf)

proc scSelectionRequestEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventSelection00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "selection-request-event", cast[GCallback](p), xdata, nil, cf)

proc scShow*(self: Widget;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "show", cast[GCallback](p), xdata, nil, cf)

proc scShowHelp*(self: Widget;  p: proc (self: ptr Widget00; helpType: WidgetHelpType; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "show-help", cast[GCallback](p), xdata, nil, cf)

proc scSizeAllocate*(self: Widget;  p: proc (self: ptr Widget00; allocation: gdk.Rectangle; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "size-allocate", cast[GCallback](p), xdata, nil, cf)

proc scStateChanged*(self: Widget;  p: proc (self: ptr Widget00; state: StateType; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "state-changed", cast[GCallback](p), xdata, nil, cf)

proc scStateFlagsChanged*(self: Widget;  p: proc (self: ptr Widget00; flags: StateFlags; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "state-flags-changed", cast[GCallback](p), xdata, nil, cf)

proc scStyleSet*(self: Widget;  p: proc (self: ptr Widget00; previousStyle: ptr Style00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "style-set", cast[GCallback](p), xdata, nil, cf)

proc scStyleUpdated*(self: Widget;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "style-updated", cast[GCallback](p), xdata, nil, cf)

proc scTouchEvent*(self: Widget;  p: proc (self: ptr Widget00; `object`: ptr gdk.Event00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "touch-event", cast[GCallback](p), xdata, nil, cf)

proc scUnmap*(self: Widget;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "unmap", cast[GCallback](p), xdata, nil, cf)

proc scUnmapEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventAny00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "unmap-event", cast[GCallback](p), xdata, nil, cf)

proc scUnrealize*(self: Widget;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "unrealize", cast[GCallback](p), xdata, nil, cf)

proc scVisibilityNotifyEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventVisibility00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "visibility-notify-event", cast[GCallback](p), xdata, nil, cf)

proc scWindowStateEvent*(self: Widget;  p: proc (self: ptr Widget00; event: ptr gdk.EventWindowState00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "window-state-event", cast[GCallback](p), xdata, nil, cf)

proc getDefaultDirection*(): TextDirection {.
    importc: "gtk_widget_get_default_direction", libprag.}

proc gtk_widget_get_default_style(): ptr Style00 {.
    importc, libprag.}

proc getDefaultStyle*(): Style =
  let gobj = gtk_widget_get_default_style()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc popCompositeChild*() {.
    importc: "gtk_widget_pop_composite_child", libprag.}

proc pushCompositeChild*() {.
    importc: "gtk_widget_push_composite_child", libprag.}

proc setDefaultDirection*(dir: TextDirection) {.
    importc: "gtk_widget_set_default_direction", libprag.}

proc gtk_widget_activate(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc activate*(self: Widget): bool =
  toBool(gtk_widget_activate(cast[ptr Widget00](self.impl)))

proc gtk_widget_add_device_events(self: ptr Widget00; device: ptr gdk.Device00;
    events: gdk.EventMask) {.
    importc, libprag.}

proc addDeviceEvents*(self: Widget; device: gdk.Device; events: gdk.EventMask) =
  gtk_widget_add_device_events(cast[ptr Widget00](self.impl), cast[ptr gdk.Device00](device.impl), events)

proc gtk_widget_add_events(self: ptr Widget00; events: gdk.EventMask) {.
    importc, libprag.}

proc addEvents*(self: Widget; events: gdk.EventMask) =
  gtk_widget_add_events(cast[ptr Widget00](self.impl), events)

proc gtk_widget_add_mnemonic_label(self: ptr Widget00; label: ptr Widget00) {.
    importc, libprag.}

proc addMnemonicLabel*(self: Widget; label: Widget) =
  gtk_widget_add_mnemonic_label(cast[ptr Widget00](self.impl), cast[ptr Widget00](label.impl))

proc gtk_widget_can_activate_accel(self: ptr Widget00; signalId: uint32): gboolean {.
    importc, libprag.}

proc canActivateAccel*(self: Widget; signalId: int): bool =
  toBool(gtk_widget_can_activate_accel(cast[ptr Widget00](self.impl), uint32(signalId)))

proc gtk_widget_child_focus(self: ptr Widget00; direction: DirectionType): gboolean {.
    importc, libprag.}

proc childFocus*(self: Widget; direction: DirectionType): bool =
  toBool(gtk_widget_child_focus(cast[ptr Widget00](self.impl), direction))

proc gtk_widget_child_notify(self: ptr Widget00; childProperty: cstring) {.
    importc, libprag.}

proc childNotify*(self: Widget; childProperty: cstring) =
  gtk_widget_child_notify(cast[ptr Widget00](self.impl), childProperty)

proc gtk_widget_class_path(self: ptr Widget00; pathLength: var uint32; path: var cstring;
    pathReversed: var cstring) {.
    importc, libprag.}

proc classPath*(self: Widget; pathLength: var int = cast[var int](nil);
    path: var string = cast[var string](nil); pathReversed: var string = cast[var string](nil)) =
  var path_00: cstring
  var pathReversed_00: cstring
  var pathLength_00: uint32
  gtk_widget_class_path(cast[ptr Widget00](self.impl), pathLength_00, path_00, pathReversed_00)
  if path.addr != nil:
    path = $(path_00)
  if pathReversed.addr != nil:
    pathReversed = $(pathReversed_00)
  if pathLength.addr != nil:
    pathLength = int(pathLength_00)

proc gtk_widget_create_pango_context(self: ptr Widget00): ptr pango.Context00 {.
    importc, libprag.}

proc createPangoContext*(self: Widget): pango.Context =
  let gobj = gtk_widget_create_pango_context(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, pango.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_create_pango_layout(self: ptr Widget00; text: cstring): ptr pango.Layout00 {.
    importc, libprag.}

proc createPangoLayout*(self: Widget; text: cstring = nil): pango.Layout =
  let gobj = gtk_widget_create_pango_layout(cast[ptr Widget00](self.impl), text)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, pango.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_destroy(self: ptr Widget00) {.
    importc, libprag.}

proc destroy*(self: Widget) =
  gtk_widget_destroy(cast[ptr Widget00](self.impl))

proc gtk_widget_device_is_shadowed(self: ptr Widget00; device: ptr gdk.Device00): gboolean {.
    importc, libprag.}

proc deviceIsShadowed*(self: Widget; device: gdk.Device): bool =
  toBool(gtk_widget_device_is_shadowed(cast[ptr Widget00](self.impl), cast[ptr gdk.Device00](device.impl)))

proc gtk_drag_check_threshold(self: ptr Widget00; startX: int32; startY: int32;
    currentX: int32; currentY: int32): gboolean {.
    importc, libprag.}

proc dragCheckThreshold*(self: Widget; startX: int; startY: int; currentX: int;
    currentY: int): bool =
  toBool(gtk_drag_check_threshold(cast[ptr Widget00](self.impl), int32(startX), int32(startY), int32(currentX), int32(currentY)))

proc gtk_drag_dest_add_image_targets(self: ptr Widget00) {.
    importc, libprag.}

proc dragDestAddImageTargets*(self: Widget) =
  gtk_drag_dest_add_image_targets(cast[ptr Widget00](self.impl))

proc gtk_drag_dest_add_text_targets(self: ptr Widget00) {.
    importc, libprag.}

proc dragDestAddTextTargets*(self: Widget) =
  gtk_drag_dest_add_text_targets(cast[ptr Widget00](self.impl))

proc gtk_drag_dest_add_uri_targets(self: ptr Widget00) {.
    importc, libprag.}

proc dragDestAddUriTargets*(self: Widget) =
  gtk_drag_dest_add_uri_targets(cast[ptr Widget00](self.impl))

proc gtk_drag_dest_get_track_motion(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc dragDestGetTrackMotion*(self: Widget): bool =
  toBool(gtk_drag_dest_get_track_motion(cast[ptr Widget00](self.impl)))

proc gtk_drag_dest_set_proxy(self: ptr Widget00; proxyWindow: ptr gdk.Window00;
    protocol: gdk.DragProtocol; useCoordinates: gboolean) {.
    importc, libprag.}

proc dragDestSetProxy*(self: Widget; proxyWindow: gdk.Window; protocol: gdk.DragProtocol;
    useCoordinates: bool) =
  gtk_drag_dest_set_proxy(cast[ptr Widget00](self.impl), cast[ptr gdk.Window00](proxyWindow.impl), protocol, gboolean(useCoordinates))

proc gtk_drag_dest_set_track_motion(self: ptr Widget00; trackMotion: gboolean) {.
    importc, libprag.}

proc dragDestSetTrackMotion*(self: Widget; trackMotion: bool = true) =
  gtk_drag_dest_set_track_motion(cast[ptr Widget00](self.impl), gboolean(trackMotion))

proc gtk_drag_dest_unset(self: ptr Widget00) {.
    importc, libprag.}

proc dragDestUnset*(self: Widget) =
  gtk_drag_dest_unset(cast[ptr Widget00](self.impl))

proc gtk_drag_get_data(self: ptr Widget00; context: ptr gdk.DragContext00;
    target: ptr gdk.Atom00; time: uint32) {.
    importc, libprag.}

proc dragGetData*(self: Widget; context: gdk.DragContext; target: gdk.Atom;
    time: int) =
  gtk_drag_get_data(cast[ptr Widget00](self.impl), cast[ptr gdk.DragContext00](context.impl), cast[ptr gdk.Atom00](target.impl), uint32(time))

proc gtk_drag_highlight(self: ptr Widget00) {.
    importc, libprag.}

proc dragHighlight*(self: Widget) =
  gtk_drag_highlight(cast[ptr Widget00](self.impl))

proc gtk_drag_source_add_image_targets(self: ptr Widget00) {.
    importc, libprag.}

proc dragSourceAddImageTargets*(self: Widget) =
  gtk_drag_source_add_image_targets(cast[ptr Widget00](self.impl))

proc gtk_drag_source_add_text_targets(self: ptr Widget00) {.
    importc, libprag.}

proc dragSourceAddTextTargets*(self: Widget) =
  gtk_drag_source_add_text_targets(cast[ptr Widget00](self.impl))

proc gtk_drag_source_add_uri_targets(self: ptr Widget00) {.
    importc, libprag.}

proc dragSourceAddUriTargets*(self: Widget) =
  gtk_drag_source_add_uri_targets(cast[ptr Widget00](self.impl))

proc gtk_drag_source_set_icon_gicon(self: ptr Widget00; icon: ptr gio.Icon00) {.
    importc, libprag.}

proc dragSourceSetIconGicon*(self: Widget; icon: gio.Icon) =
  gtk_drag_source_set_icon_gicon(cast[ptr Widget00](self.impl), cast[ptr gio.Icon00](icon.impl))

proc gtk_drag_source_set_icon_name(self: ptr Widget00; iconName: cstring) {.
    importc, libprag.}

proc dragSourceSetIconName*(self: Widget; iconName: cstring) =
  gtk_drag_source_set_icon_name(cast[ptr Widget00](self.impl), iconName)

proc gtk_drag_source_set_icon_pixbuf(self: ptr Widget00; pixbuf: ptr gdkpixbuf.Pixbuf00) {.
    importc, libprag.}

proc dragSourceSetIconPixbuf*(self: Widget; pixbuf: gdkpixbuf.Pixbuf) =
  gtk_drag_source_set_icon_pixbuf(cast[ptr Widget00](self.impl), cast[ptr gdkpixbuf.Pixbuf00](pixbuf.impl))

proc gtk_drag_source_set_icon_stock(self: ptr Widget00; stockId: cstring) {.
    importc, libprag.}

proc dragSourceSetIconStock*(self: Widget; stockId: cstring) =
  gtk_drag_source_set_icon_stock(cast[ptr Widget00](self.impl), stockId)

proc gtk_drag_source_unset(self: ptr Widget00) {.
    importc, libprag.}

proc dragSourceUnset*(self: Widget) =
  gtk_drag_source_unset(cast[ptr Widget00](self.impl))

proc gtk_drag_unhighlight(self: ptr Widget00) {.
    importc, libprag.}

proc dragUnhighlight*(self: Widget) =
  gtk_drag_unhighlight(cast[ptr Widget00](self.impl))

proc gtk_widget_draw(self: ptr Widget00; cr: ptr cairo.Context00) {.
    importc, libprag.}

proc draw*(self: Widget; cr: cairo.Context) =
  gtk_widget_draw(cast[ptr Widget00](self.impl), cast[ptr cairo.Context00](cr.impl))

proc gtk_widget_ensure_style(self: ptr Widget00) {.
    importc, libprag.}

proc ensureStyle*(self: Widget) =
  gtk_widget_ensure_style(cast[ptr Widget00](self.impl))

proc gtk_widget_error_bell(self: ptr Widget00) {.
    importc, libprag.}

proc errorBell*(self: Widget) =
  gtk_widget_error_bell(cast[ptr Widget00](self.impl))

proc gtk_widget_event(self: ptr Widget00; event: ptr gdk.Event00): gboolean {.
    importc, libprag.}

proc event*(self: Widget; event: gdk.Event): bool =
  toBool(gtk_widget_event(cast[ptr Widget00](self.impl), cast[ptr gdk.Event00](event.impl)))

proc gtk_widget_freeze_child_notify(self: ptr Widget00) {.
    importc, libprag.}

proc freezeChildNotify*(self: Widget) =
  gtk_widget_freeze_child_notify(cast[ptr Widget00](self.impl))

proc gtk_widget_get_accessible(self: ptr Widget00): ptr atk.Object00 {.
    importc, libprag.}

proc getAccessible*(self: Widget): atk.Object =
  let gobj = gtk_widget_get_accessible(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, atk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc accessible*(self: Widget): atk.Object =
  let gobj = gtk_widget_get_accessible(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, atk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_get_action_group(self: ptr Widget00; prefix: cstring): ptr gio.ActionGroup00 {.
    importc, libprag.}

proc getActionGroup*(self: Widget; prefix: cstring): gio.ActionGroup =
  let gobj = gtk_widget_get_action_group(cast[ptr Widget00](self.impl), prefix)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_get_allocated_baseline(self: ptr Widget00): int32 {.
    importc, libprag.}

proc getAllocatedBaseline*(self: Widget): int =
  int(gtk_widget_get_allocated_baseline(cast[ptr Widget00](self.impl)))

proc allocatedBaseline*(self: Widget): int =
  int(gtk_widget_get_allocated_baseline(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_allocated_height(self: ptr Widget00): int32 {.
    importc, libprag.}

proc getAllocatedHeight*(self: Widget): int =
  int(gtk_widget_get_allocated_height(cast[ptr Widget00](self.impl)))

proc allocatedHeight*(self: Widget): int =
  int(gtk_widget_get_allocated_height(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_allocated_size(self: ptr Widget00; allocation: var gdk.Rectangle;
    baseline: var int32) {.
    importc, libprag.}

proc getAllocatedSize*(self: Widget; allocation: var gdk.Rectangle;
    baseline: var int = cast[var int](nil)) =
  var baseline_00: int32
  gtk_widget_get_allocated_size(cast[ptr Widget00](self.impl), allocation, baseline_00)
  if baseline.addr != nil:
    baseline = int(baseline_00)

proc gtk_widget_get_allocated_width(self: ptr Widget00): int32 {.
    importc, libprag.}

proc getAllocatedWidth*(self: Widget): int =
  int(gtk_widget_get_allocated_width(cast[ptr Widget00](self.impl)))

proc allocatedWidth*(self: Widget): int =
  int(gtk_widget_get_allocated_width(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_allocation(self: ptr Widget00; allocation: var gdk.Rectangle) {.
    importc, libprag.}

proc getAllocation*(self: Widget; allocation: var gdk.Rectangle) =
  gtk_widget_get_allocation(cast[ptr Widget00](self.impl), allocation)

proc getAllocation*(self: Widget): gdk.Rectangle =
  gtk_widget_get_allocation(cast[ptr Widget00](self.impl), result)

proc gtk_widget_get_ancestor(self: ptr Widget00; widgetType: GType): ptr Widget00 {.
    importc, libprag.}

proc getAncestor*(self: Widget; widgetType: GType): Widget =
  let gobj = gtk_widget_get_ancestor(cast[ptr Widget00](self.impl), widgetType)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_get_app_paintable(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc getAppPaintable*(self: Widget): bool =
  toBool(gtk_widget_get_app_paintable(cast[ptr Widget00](self.impl)))

proc appPaintable*(self: Widget): bool =
  toBool(gtk_widget_get_app_paintable(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_can_default(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc getCanDefault*(self: Widget): bool =
  toBool(gtk_widget_get_can_default(cast[ptr Widget00](self.impl)))

proc canDefault*(self: Widget): bool =
  toBool(gtk_widget_get_can_default(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_can_focus(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc getCanFocus*(self: Widget): bool =
  toBool(gtk_widget_get_can_focus(cast[ptr Widget00](self.impl)))

proc canFocus*(self: Widget): bool =
  toBool(gtk_widget_get_can_focus(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_child_visible(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc getChildVisible*(self: Widget): bool =
  toBool(gtk_widget_get_child_visible(cast[ptr Widget00](self.impl)))

proc childVisible*(self: Widget): bool =
  toBool(gtk_widget_get_child_visible(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_clip(self: ptr Widget00; clip: var gdk.Rectangle) {.
    importc, libprag.}

proc getClip*(self: Widget; clip: var gdk.Rectangle) =
  gtk_widget_get_clip(cast[ptr Widget00](self.impl), clip)

proc getClip*(self: Widget): gdk.Rectangle =
  gtk_widget_get_clip(cast[ptr Widget00](self.impl), result)

proc gtk_widget_get_composite_name(self: ptr Widget00): cstring {.
    importc, libprag.}

proc getCompositeName*(self: Widget): string =
  let resul0 = gtk_widget_get_composite_name(cast[ptr Widget00](self.impl))
  result = $resul0
  cogfree(resul0)

proc compositeName*(self: Widget): string =
  let resul0 = gtk_widget_get_composite_name(cast[ptr Widget00](self.impl))
  result = $resul0
  cogfree(resul0)

proc gtk_widget_get_device_enabled(self: ptr Widget00; device: ptr gdk.Device00): gboolean {.
    importc, libprag.}

proc getDeviceEnabled*(self: Widget; device: gdk.Device): bool =
  toBool(gtk_widget_get_device_enabled(cast[ptr Widget00](self.impl), cast[ptr gdk.Device00](device.impl)))

proc gtk_widget_get_device_events(self: ptr Widget00; device: ptr gdk.Device00): gdk.EventMask {.
    importc, libprag.}

proc getDeviceEvents*(self: Widget; device: gdk.Device): gdk.EventMask =
  gtk_widget_get_device_events(cast[ptr Widget00](self.impl), cast[ptr gdk.Device00](device.impl))

proc gtk_widget_get_direction(self: ptr Widget00): TextDirection {.
    importc, libprag.}

proc getDirection*(self: Widget): TextDirection =
  gtk_widget_get_direction(cast[ptr Widget00](self.impl))

proc direction*(self: Widget): TextDirection =
  gtk_widget_get_direction(cast[ptr Widget00](self.impl))

proc gtk_widget_get_display(self: ptr Widget00): ptr gdk.Display00 {.
    importc, libprag.}

proc getDisplay*(self: Widget): gdk.Display =
  let gobj = gtk_widget_get_display(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc display*(self: Widget): gdk.Display =
  let gobj = gtk_widget_get_display(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_get_double_buffered(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc getDoubleBuffered*(self: Widget): bool =
  toBool(gtk_widget_get_double_buffered(cast[ptr Widget00](self.impl)))

proc doubleBuffered*(self: Widget): bool =
  toBool(gtk_widget_get_double_buffered(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_events(self: ptr Widget00): int32 {.
    importc, libprag.}

proc getEvents*(self: Widget): int =
  int(gtk_widget_get_events(cast[ptr Widget00](self.impl)))

proc events*(self: Widget): int =
  int(gtk_widget_get_events(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_focus_on_click(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc getFocusOnClick*(self: Widget): bool =
  toBool(gtk_widget_get_focus_on_click(cast[ptr Widget00](self.impl)))

proc focusOnClick*(self: Widget): bool =
  toBool(gtk_widget_get_focus_on_click(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_font_map(self: ptr Widget00): ptr pango.FontMap00 {.
    importc, libprag.}

proc getFontMap*(self: Widget): pango.FontMap =
  let gobj = gtk_widget_get_font_map(cast[ptr Widget00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, pango.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc fontMap*(self: Widget): pango.FontMap =
  let gobj = gtk_widget_get_font_map(cast[ptr Widget00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, pango.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_get_font_options(self: ptr Widget00): ptr cairo.FontOptions00 {.
    importc, libprag.}

proc getFontOptions*(self: Widget): cairo.FontOptions =
  let impl0 = gtk_widget_get_font_options(cast[ptr Widget00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreeCairoFontOptions)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(cairo_gobject_font_options_get_type(), impl0))

proc fontOptions*(self: Widget): cairo.FontOptions =
  let impl0 = gtk_widget_get_font_options(cast[ptr Widget00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreeCairoFontOptions)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(cairo_gobject_font_options_get_type(), impl0))

proc gtk_widget_get_frame_clock(self: ptr Widget00): ptr gdk.FrameClock00 {.
    importc, libprag.}

proc getFrameClock*(self: Widget): gdk.FrameClock =
  let gobj = gtk_widget_get_frame_clock(cast[ptr Widget00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc frameClock*(self: Widget): gdk.FrameClock =
  let gobj = gtk_widget_get_frame_clock(cast[ptr Widget00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_get_has_tooltip(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc getHasTooltip*(self: Widget): bool =
  toBool(gtk_widget_get_has_tooltip(cast[ptr Widget00](self.impl)))

proc hasTooltip*(self: Widget): bool =
  toBool(gtk_widget_get_has_tooltip(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_has_window(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc getHasWindow*(self: Widget): bool =
  toBool(gtk_widget_get_has_window(cast[ptr Widget00](self.impl)))

proc hasWindow*(self: Widget): bool =
  toBool(gtk_widget_get_has_window(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_hexpand(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc getHexpand*(self: Widget): bool =
  toBool(gtk_widget_get_hexpand(cast[ptr Widget00](self.impl)))

proc hexpand*(self: Widget): bool =
  toBool(gtk_widget_get_hexpand(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_hexpand_set(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc getHexpandSet*(self: Widget): bool =
  toBool(gtk_widget_get_hexpand_set(cast[ptr Widget00](self.impl)))

proc hexpandSet*(self: Widget): bool =
  toBool(gtk_widget_get_hexpand_set(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_mapped(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc getMapped*(self: Widget): bool =
  toBool(gtk_widget_get_mapped(cast[ptr Widget00](self.impl)))

proc mapped*(self: Widget): bool =
  toBool(gtk_widget_get_mapped(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_margin_bottom(self: ptr Widget00): int32 {.
    importc, libprag.}

proc getMarginBottom*(self: Widget): int =
  int(gtk_widget_get_margin_bottom(cast[ptr Widget00](self.impl)))

proc marginBottom*(self: Widget): int =
  int(gtk_widget_get_margin_bottom(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_margin_end(self: ptr Widget00): int32 {.
    importc, libprag.}

proc getMarginEnd*(self: Widget): int =
  int(gtk_widget_get_margin_end(cast[ptr Widget00](self.impl)))

proc marginEnd*(self: Widget): int =
  int(gtk_widget_get_margin_end(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_margin_left(self: ptr Widget00): int32 {.
    importc, libprag.}

proc getMarginLeft*(self: Widget): int =
  int(gtk_widget_get_margin_left(cast[ptr Widget00](self.impl)))

proc marginLeft*(self: Widget): int =
  int(gtk_widget_get_margin_left(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_margin_right(self: ptr Widget00): int32 {.
    importc, libprag.}

proc getMarginRight*(self: Widget): int =
  int(gtk_widget_get_margin_right(cast[ptr Widget00](self.impl)))

proc marginRight*(self: Widget): int =
  int(gtk_widget_get_margin_right(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_margin_start(self: ptr Widget00): int32 {.
    importc, libprag.}

proc getMarginStart*(self: Widget): int =
  int(gtk_widget_get_margin_start(cast[ptr Widget00](self.impl)))

proc marginStart*(self: Widget): int =
  int(gtk_widget_get_margin_start(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_margin_top(self: ptr Widget00): int32 {.
    importc, libprag.}

proc getMarginTop*(self: Widget): int =
  int(gtk_widget_get_margin_top(cast[ptr Widget00](self.impl)))

proc marginTop*(self: Widget): int =
  int(gtk_widget_get_margin_top(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_modifier_mask(self: ptr Widget00; intent: gdk.ModifierIntent): gdk.ModifierType {.
    importc, libprag.}

proc getModifierMask*(self: Widget; intent: gdk.ModifierIntent): gdk.ModifierType =
  gtk_widget_get_modifier_mask(cast[ptr Widget00](self.impl), intent)

proc gtk_widget_get_name(self: ptr Widget00): cstring {.
    importc, libprag.}

proc getName*(self: Widget): string =
  result = $gtk_widget_get_name(cast[ptr Widget00](self.impl))

proc name*(self: Widget): string =
  result = $gtk_widget_get_name(cast[ptr Widget00](self.impl))

proc gtk_widget_get_no_show_all(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc getNoShowAll*(self: Widget): bool =
  toBool(gtk_widget_get_no_show_all(cast[ptr Widget00](self.impl)))

proc noShowAll*(self: Widget): bool =
  toBool(gtk_widget_get_no_show_all(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_opacity(self: ptr Widget00): cdouble {.
    importc, libprag.}

proc getOpacity*(self: Widget): cdouble =
  gtk_widget_get_opacity(cast[ptr Widget00](self.impl))

proc opacity*(self: Widget): cdouble =
  gtk_widget_get_opacity(cast[ptr Widget00](self.impl))

proc gtk_widget_get_pango_context(self: ptr Widget00): ptr pango.Context00 {.
    importc, libprag.}

proc getPangoContext*(self: Widget): pango.Context =
  let gobj = gtk_widget_get_pango_context(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, pango.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc pangoContext*(self: Widget): pango.Context =
  let gobj = gtk_widget_get_pango_context(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, pango.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_get_parent(self: ptr Widget00): ptr Widget00 {.
    importc, libprag.}

proc getParent*(self: Widget): Widget =
  let gobj = gtk_widget_get_parent(cast[ptr Widget00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc parent*(self: Widget): Widget =
  let gobj = gtk_widget_get_parent(cast[ptr Widget00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_get_parent_window(self: ptr Widget00): ptr gdk.Window00 {.
    importc, libprag.}

proc getParentWindow*(self: Widget): gdk.Window =
  let gobj = gtk_widget_get_parent_window(cast[ptr Widget00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc parentWindow*(self: Widget): gdk.Window =
  let gobj = gtk_widget_get_parent_window(cast[ptr Widget00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_get_pointer(self: ptr Widget00; x: var int32; y: var int32) {.
    importc, libprag.}

proc getPointer*(self: Widget; x: var int = cast[var int](nil);
    y: var int = cast[var int](nil)) =
  var y_00: int32
  var x_00: int32
  gtk_widget_get_pointer(cast[ptr Widget00](self.impl), x_00, y_00)
  if y.addr != nil:
    y = int(y_00)
  if x.addr != nil:
    x = int(x_00)

proc gtk_widget_get_preferred_height(self: ptr Widget00; minimumHeight: var int32;
    naturalHeight: var int32) {.
    importc, libprag.}

proc getPreferredHeight*(self: Widget; minimumHeight: var int = cast[var int](nil);
    naturalHeight: var int = cast[var int](nil)) =
  var naturalHeight_00: int32
  var minimumHeight_00: int32
  gtk_widget_get_preferred_height(cast[ptr Widget00](self.impl), minimumHeight_00, naturalHeight_00)
  if naturalHeight.addr != nil:
    naturalHeight = int(naturalHeight_00)
  if minimumHeight.addr != nil:
    minimumHeight = int(minimumHeight_00)

proc gtk_widget_get_preferred_height_and_baseline_for_width(self: ptr Widget00;
    width: int32; minimumHeight: var int32; naturalHeight: var int32; minimumBaseline: var int32;
    naturalBaseline: var int32) {.
    importc, libprag.}

proc getPreferredHeightAndBaselineForWidth*(self: Widget;
    width: int; minimumHeight: var int = cast[var int](nil); naturalHeight: var int = cast[var int](nil);
    minimumBaseline: var int = cast[var int](nil); naturalBaseline: var int = cast[var int](nil)) =
  var minimumBaseline_00: int32
  var naturalHeight_00: int32
  var minimumHeight_00: int32
  var naturalBaseline_00: int32
  gtk_widget_get_preferred_height_and_baseline_for_width(cast[ptr Widget00](self.impl), int32(width), minimumHeight_00, naturalHeight_00, minimumBaseline_00, naturalBaseline_00)
  if minimumBaseline.addr != nil:
    minimumBaseline = int(minimumBaseline_00)
  if naturalHeight.addr != nil:
    naturalHeight = int(naturalHeight_00)
  if minimumHeight.addr != nil:
    minimumHeight = int(minimumHeight_00)
  if naturalBaseline.addr != nil:
    naturalBaseline = int(naturalBaseline_00)

proc gtk_widget_get_preferred_height_for_width(self: ptr Widget00; width: int32;
    minimumHeight: var int32; naturalHeight: var int32) {.
    importc, libprag.}

proc getPreferredHeightForWidth*(self: Widget; width: int;
    minimumHeight: var int = cast[var int](nil); naturalHeight: var int = cast[var int](nil)) =
  var naturalHeight_00: int32
  var minimumHeight_00: int32
  gtk_widget_get_preferred_height_for_width(cast[ptr Widget00](self.impl), int32(width), minimumHeight_00, naturalHeight_00)
  if naturalHeight.addr != nil:
    naturalHeight = int(naturalHeight_00)
  if minimumHeight.addr != nil:
    minimumHeight = int(minimumHeight_00)

proc gtk_widget_get_preferred_width(self: ptr Widget00; minimumWidth: var int32;
    naturalWidth: var int32) {.
    importc, libprag.}

proc getPreferredWidth*(self: Widget; minimumWidth: var int = cast[var int](nil);
    naturalWidth: var int = cast[var int](nil)) =
  var minimumWidth_00: int32
  var naturalWidth_00: int32
  gtk_widget_get_preferred_width(cast[ptr Widget00](self.impl), minimumWidth_00, naturalWidth_00)
  if minimumWidth.addr != nil:
    minimumWidth = int(minimumWidth_00)
  if naturalWidth.addr != nil:
    naturalWidth = int(naturalWidth_00)

proc gtk_widget_get_preferred_width_for_height(self: ptr Widget00; height: int32;
    minimumWidth: var int32; naturalWidth: var int32) {.
    importc, libprag.}

proc getPreferredWidthForHeight*(self: Widget; height: int;
    minimumWidth: var int = cast[var int](nil); naturalWidth: var int = cast[var int](nil)) =
  var minimumWidth_00: int32
  var naturalWidth_00: int32
  gtk_widget_get_preferred_width_for_height(cast[ptr Widget00](self.impl), int32(height), minimumWidth_00, naturalWidth_00)
  if minimumWidth.addr != nil:
    minimumWidth = int(minimumWidth_00)
  if naturalWidth.addr != nil:
    naturalWidth = int(naturalWidth_00)

proc gtk_widget_get_realized(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc getRealized*(self: Widget): bool =
  toBool(gtk_widget_get_realized(cast[ptr Widget00](self.impl)))

proc realized*(self: Widget): bool =
  toBool(gtk_widget_get_realized(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_receives_default(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc getReceivesDefault*(self: Widget): bool =
  toBool(gtk_widget_get_receives_default(cast[ptr Widget00](self.impl)))

proc receivesDefault*(self: Widget): bool =
  toBool(gtk_widget_get_receives_default(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_root_window(self: ptr Widget00): ptr gdk.Window00 {.
    importc, libprag.}

proc getRootWindow*(self: Widget): gdk.Window =
  let gobj = gtk_widget_get_root_window(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc rootWindow*(self: Widget): gdk.Window =
  let gobj = gtk_widget_get_root_window(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_get_scale_factor(self: ptr Widget00): int32 {.
    importc, libprag.}

proc getScaleFactor*(self: Widget): int =
  int(gtk_widget_get_scale_factor(cast[ptr Widget00](self.impl)))

proc scaleFactor*(self: Widget): int =
  int(gtk_widget_get_scale_factor(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_screen(self: ptr Widget00): ptr gdk.Screen00 {.
    importc, libprag.}

proc getScreen*(self: Widget): gdk.Screen =
  let gobj = gtk_widget_get_screen(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc screen*(self: Widget): gdk.Screen =
  let gobj = gtk_widget_get_screen(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_get_sensitive(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc getSensitive*(self: Widget): bool =
  toBool(gtk_widget_get_sensitive(cast[ptr Widget00](self.impl)))

proc sensitive*(self: Widget): bool =
  toBool(gtk_widget_get_sensitive(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_size_request(self: ptr Widget00; width: var int32; height: var int32) {.
    importc, libprag.}

proc getSizeRequest*(self: Widget; width: var int = cast[var int](nil);
    height: var int = cast[var int](nil)) =
  var width_00: int32
  var height_00: int32
  gtk_widget_get_size_request(cast[ptr Widget00](self.impl), width_00, height_00)
  if width.addr != nil:
    width = int(width_00)
  if height.addr != nil:
    height = int(height_00)

proc gtk_widget_get_state(self: ptr Widget00): StateType {.
    importc, libprag.}

proc getState*(self: Widget): StateType =
  gtk_widget_get_state(cast[ptr Widget00](self.impl))

proc state*(self: Widget): StateType =
  gtk_widget_get_state(cast[ptr Widget00](self.impl))

proc gtk_widget_get_state_flags(self: ptr Widget00): StateFlags {.
    importc, libprag.}

proc getStateFlags*(self: Widget): StateFlags =
  gtk_widget_get_state_flags(cast[ptr Widget00](self.impl))

proc stateFlags*(self: Widget): StateFlags =
  gtk_widget_get_state_flags(cast[ptr Widget00](self.impl))

proc gtk_widget_get_style(self: ptr Widget00): ptr Style00 {.
    importc, libprag.}

proc getStyle*(self: Widget): Style =
  let gobj = gtk_widget_get_style(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc style*(self: Widget): Style =
  let gobj = gtk_widget_get_style(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_get_support_multidevice(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc getSupportMultidevice*(self: Widget): bool =
  toBool(gtk_widget_get_support_multidevice(cast[ptr Widget00](self.impl)))

proc supportMultidevice*(self: Widget): bool =
  toBool(gtk_widget_get_support_multidevice(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_template_child(self: ptr Widget00; widgetType: GType;
    name: cstring): ptr gobject.Object00 {.
    importc, libprag.}

proc getTemplateChild*(self: Widget; widgetType: GType; name: cstring): gobject.Object =
  let gobj = gtk_widget_get_template_child(cast[ptr Widget00](self.impl), widgetType, name)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gobject.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_get_tooltip_markup(self: ptr Widget00): cstring {.
    importc, libprag.}

proc getTooltipMarkup*(self: Widget): string =
  let resul0 = gtk_widget_get_tooltip_markup(cast[ptr Widget00](self.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc tooltipMarkup*(self: Widget): string =
  let resul0 = gtk_widget_get_tooltip_markup(cast[ptr Widget00](self.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc gtk_widget_get_tooltip_text(self: ptr Widget00): cstring {.
    importc, libprag.}

proc getTooltipText*(self: Widget): string =
  let resul0 = gtk_widget_get_tooltip_text(cast[ptr Widget00](self.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc tooltipText*(self: Widget): string =
  let resul0 = gtk_widget_get_tooltip_text(cast[ptr Widget00](self.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc gtk_widget_get_toplevel(self: ptr Widget00): ptr Widget00 {.
    importc, libprag.}

proc getToplevel*(self: Widget): Widget =
  let gobj = gtk_widget_get_toplevel(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc toplevel*(self: Widget): Widget =
  let gobj = gtk_widget_get_toplevel(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_get_vexpand(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc getVexpand*(self: Widget): bool =
  toBool(gtk_widget_get_vexpand(cast[ptr Widget00](self.impl)))

proc vexpand*(self: Widget): bool =
  toBool(gtk_widget_get_vexpand(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_vexpand_set(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc getVexpandSet*(self: Widget): bool =
  toBool(gtk_widget_get_vexpand_set(cast[ptr Widget00](self.impl)))

proc vexpandSet*(self: Widget): bool =
  toBool(gtk_widget_get_vexpand_set(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_visible(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc getVisible*(self: Widget): bool =
  toBool(gtk_widget_get_visible(cast[ptr Widget00](self.impl)))

proc visible*(self: Widget): bool =
  toBool(gtk_widget_get_visible(cast[ptr Widget00](self.impl)))

proc gtk_widget_get_visual(self: ptr Widget00): ptr gdk.Visual00 {.
    importc, libprag.}

proc getVisual*(self: Widget): gdk.Visual =
  let gobj = gtk_widget_get_visual(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc visual*(self: Widget): gdk.Visual =
  let gobj = gtk_widget_get_visual(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_get_window(self: ptr Widget00): ptr gdk.Window00 {.
    importc, libprag.}

proc getWindow*(self: Widget): gdk.Window =
  let gobj = gtk_widget_get_window(cast[ptr Widget00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc window*(self: Widget): gdk.Window =
  let gobj = gtk_widget_get_window(cast[ptr Widget00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_grab_add(self: ptr Widget00) {.
    importc, libprag.}

proc grabAdd*(self: Widget) =
  gtk_grab_add(cast[ptr Widget00](self.impl))

proc gtk_widget_grab_default(self: ptr Widget00) {.
    importc, libprag.}

proc grabDefault*(self: Widget) =
  gtk_widget_grab_default(cast[ptr Widget00](self.impl))

proc gtk_widget_grab_focus(self: ptr Widget00) {.
    importc, libprag.}

proc grabFocus*(self: Widget) =
  gtk_widget_grab_focus(cast[ptr Widget00](self.impl))

proc gtk_grab_remove(self: ptr Widget00) {.
    importc, libprag.}

proc grabRemove*(self: Widget) =
  gtk_grab_remove(cast[ptr Widget00](self.impl))

proc gtk_widget_has_default(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc hasDefault*(self: Widget): bool =
  toBool(gtk_widget_has_default(cast[ptr Widget00](self.impl)))

proc gtk_widget_has_focus(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc hasFocus*(self: Widget): bool =
  toBool(gtk_widget_has_focus(cast[ptr Widget00](self.impl)))

proc gtk_widget_has_grab(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc hasGrab*(self: Widget): bool =
  toBool(gtk_widget_has_grab(cast[ptr Widget00](self.impl)))

proc gtk_widget_has_rc_style(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc hasRcStyle*(self: Widget): bool =
  toBool(gtk_widget_has_rc_style(cast[ptr Widget00](self.impl)))

proc gtk_widget_has_screen(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc hasScreen*(self: Widget): bool =
  toBool(gtk_widget_has_screen(cast[ptr Widget00](self.impl)))

proc gtk_widget_has_visible_focus(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc hasVisibleFocus*(self: Widget): bool =
  toBool(gtk_widget_has_visible_focus(cast[ptr Widget00](self.impl)))

proc gtk_widget_hide(self: ptr Widget00) {.
    importc, libprag.}

proc hide*(self: Widget) =
  gtk_widget_hide(cast[ptr Widget00](self.impl))

proc gtk_widget_hide_on_delete(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc hideOnDelete*(self: Widget): bool =
  toBool(gtk_widget_hide_on_delete(cast[ptr Widget00](self.impl)))

proc gtk_widget_in_destruction(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc inDestruction*(self: Widget): bool =
  toBool(gtk_widget_in_destruction(cast[ptr Widget00](self.impl)))

proc gtk_widget_init_template(self: ptr Widget00) {.
    importc, libprag.}

proc initTemplate*(self: Widget) =
  gtk_widget_init_template(cast[ptr Widget00](self.impl))

proc gtk_widget_input_shape_combine_region(self: ptr Widget00; region: ptr cairo.Region00) {.
    importc, libprag.}

proc inputShapeCombineRegion*(self: Widget; region: cairo.Region = nil) =
  gtk_widget_input_shape_combine_region(cast[ptr Widget00](self.impl), if region.isNil: nil else: cast[ptr cairo.Region00](region.impl))

proc gtk_widget_insert_action_group(self: ptr Widget00; name: cstring; group: ptr gio.ActionGroup00) {.
    importc, libprag.}

proc insertActionGroup*(self: Widget; name: cstring; group: gio.ActionGroup | gio.SimpleActionGroup = nil) =
  gtk_widget_insert_action_group(cast[ptr Widget00](self.impl), name, if group.isNil: nil else: cast[ptr gio.ActionGroup00](group.impl))

proc gtk_widget_intersect(self: ptr Widget00; area: gdk.Rectangle; intersection: var gdk.Rectangle): gboolean {.
    importc, libprag.}

proc intersect*(self: Widget; area: gdk.Rectangle; intersection: var gdk.Rectangle = cast[var gdk.Rectangle](nil)): bool =
  toBool(gtk_widget_intersect(cast[ptr Widget00](self.impl), area, intersection))

proc gtk_widget_is_ancestor(self: ptr Widget00; ancestor: ptr Widget00): gboolean {.
    importc, libprag.}

proc isAncestor*(self: Widget; ancestor: Widget): bool =
  toBool(gtk_widget_is_ancestor(cast[ptr Widget00](self.impl), cast[ptr Widget00](ancestor.impl)))

proc gtk_widget_is_composited(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc isComposited*(self: Widget): bool =
  toBool(gtk_widget_is_composited(cast[ptr Widget00](self.impl)))

proc gtk_widget_is_drawable(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc isDrawable*(self: Widget): bool =
  toBool(gtk_widget_is_drawable(cast[ptr Widget00](self.impl)))

proc gtk_widget_is_focus(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc isFocus*(self: Widget): bool =
  toBool(gtk_widget_is_focus(cast[ptr Widget00](self.impl)))

proc gtk_widget_is_sensitive(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc isSensitive*(self: Widget): bool =
  toBool(gtk_widget_is_sensitive(cast[ptr Widget00](self.impl)))

proc gtk_widget_is_toplevel(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc isToplevel*(self: Widget): bool =
  toBool(gtk_widget_is_toplevel(cast[ptr Widget00](self.impl)))

proc gtk_widget_is_visible(self: ptr Widget00): gboolean {.
    importc, libprag.}

proc isVisible*(self: Widget): bool =
  toBool(gtk_widget_is_visible(cast[ptr Widget00](self.impl)))

proc gtk_widget_keynav_failed(self: ptr Widget00; direction: DirectionType): gboolean {.
    importc, libprag.}

proc keynavFailed*(self: Widget; direction: DirectionType): bool =
  toBool(gtk_widget_keynav_failed(cast[ptr Widget00](self.impl), direction))

proc gtk_widget_list_accel_closures(self: ptr Widget00): ptr glib.List {.
    importc, libprag.}

proc listAccelClosures*(self: Widget): seq[gobject.Closure] =
  let resul0 = gtk_widget_list_accel_closures(cast[ptr Widget00](self.impl))
  result = glistStructs2seq[gobject.Closure](resul0, true)
  g_list_free(resul0)

proc gtk_widget_list_action_prefixes(self: ptr Widget00): ptr cstring {.
    importc, libprag.}

proc listActionPrefixes*(self: Widget): seq[string] =
  cstringArrayToSeq(gtk_widget_list_action_prefixes(cast[ptr Widget00](self.impl)))

proc gtk_widget_list_mnemonic_labels(self: ptr Widget00): ptr glib.List {.
    importc, libprag.}

proc listMnemonicLabels*(self: Widget): seq[Widget] =
  let resul0 = gtk_widget_list_mnemonic_labels(cast[ptr Widget00](self.impl))
  result = glistObjects2seq(Widget, resul0, false)
  g_list_free(resul0)

proc gtk_widget_map(self: ptr Widget00) {.
    importc, libprag.}

proc map*(self: Widget) =
  gtk_widget_map(cast[ptr Widget00](self.impl))

proc gtk_widget_mnemonic_activate(self: ptr Widget00; groupCycling: gboolean): gboolean {.
    importc, libprag.}

proc mnemonicActivate*(self: Widget; groupCycling: bool): bool =
  toBool(gtk_widget_mnemonic_activate(cast[ptr Widget00](self.impl), gboolean(groupCycling)))

proc gtk_widget_modify_base(self: ptr Widget00; state: StateType; color: gdk.Color) {.
    importc, libprag.}

proc modifyBase*(self: Widget; state: StateType; color: gdk.Color = cast[var gdk.Color](nil)) =
  gtk_widget_modify_base(cast[ptr Widget00](self.impl), state, color)

proc gtk_widget_modify_bg(self: ptr Widget00; state: StateType; color: gdk.Color) {.
    importc, libprag.}

proc modifyBg*(self: Widget; state: StateType; color: gdk.Color = cast[var gdk.Color](nil)) =
  gtk_widget_modify_bg(cast[ptr Widget00](self.impl), state, color)

proc gtk_widget_modify_cursor(self: ptr Widget00; primary: gdk.Color; secondary: gdk.Color) {.
    importc, libprag.}

proc modifyCursor*(self: Widget; primary: gdk.Color = cast[var gdk.Color](nil);
    secondary: gdk.Color = cast[var gdk.Color](nil)) =
  gtk_widget_modify_cursor(cast[ptr Widget00](self.impl), primary, secondary)

proc gtk_widget_modify_fg(self: ptr Widget00; state: StateType; color: gdk.Color) {.
    importc, libprag.}

proc modifyFg*(self: Widget; state: StateType; color: gdk.Color = cast[var gdk.Color](nil)) =
  gtk_widget_modify_fg(cast[ptr Widget00](self.impl), state, color)

proc gtk_widget_modify_font(self: ptr Widget00; fontDesc: ptr pango.FontDescription00) {.
    importc, libprag.}

proc modifyFont*(self: Widget; fontDesc: pango.FontDescription = nil) =
  gtk_widget_modify_font(cast[ptr Widget00](self.impl), if fontDesc.isNil: nil else: cast[ptr pango.FontDescription00](fontDesc.impl))

proc gtk_widget_modify_text(self: ptr Widget00; state: StateType; color: gdk.Color) {.
    importc, libprag.}

proc modifyText*(self: Widget; state: StateType; color: gdk.Color = cast[var gdk.Color](nil)) =
  gtk_widget_modify_text(cast[ptr Widget00](self.impl), state, color)

proc gtk_widget_override_background_color(self: ptr Widget00; state: StateFlags;
    color: gdk.RGBA) {.
    importc, libprag.}

proc overrideBackgroundColor*(self: Widget; state: StateFlags;
    color: gdk.RGBA = cast[var gdk.RGBA](nil)) =
  gtk_widget_override_background_color(cast[ptr Widget00](self.impl), state, color)

proc gtk_widget_override_color(self: ptr Widget00; state: StateFlags; color: gdk.RGBA) {.
    importc, libprag.}

proc overrideColor*(self: Widget; state: StateFlags; color: gdk.RGBA = cast[var gdk.RGBA](nil)) =
  gtk_widget_override_color(cast[ptr Widget00](self.impl), state, color)

proc gtk_widget_override_cursor(self: ptr Widget00; cursor: gdk.RGBA; secondaryCursor: gdk.RGBA) {.
    importc, libprag.}

proc overrideCursor*(self: Widget; cursor: gdk.RGBA = cast[var gdk.RGBA](nil);
    secondaryCursor: gdk.RGBA = cast[var gdk.RGBA](nil)) =
  gtk_widget_override_cursor(cast[ptr Widget00](self.impl), cursor, secondaryCursor)

proc gtk_widget_override_font(self: ptr Widget00; fontDesc: ptr pango.FontDescription00) {.
    importc, libprag.}

proc overrideFont*(self: Widget; fontDesc: pango.FontDescription = nil) =
  gtk_widget_override_font(cast[ptr Widget00](self.impl), if fontDesc.isNil: nil else: cast[ptr pango.FontDescription00](fontDesc.impl))

proc gtk_widget_override_symbolic_color(self: ptr Widget00; name: cstring;
    color: gdk.RGBA) {.
    importc, libprag.}

proc overrideSymbolicColor*(self: Widget; name: cstring; color: gdk.RGBA = cast[var gdk.RGBA](nil)) =
  gtk_widget_override_symbolic_color(cast[ptr Widget00](self.impl), name, color)

proc gtk_widget_path(self: ptr Widget00; pathLength: var uint32; path: var cstring;
    pathReversed: var cstring) {.
    importc, libprag.}

proc path*(self: Widget; pathLength: var int = cast[var int](nil);
    path: var string = cast[var string](nil); pathReversed: var string = cast[var string](nil)) =
  var path_00: cstring
  var pathReversed_00: cstring
  var pathLength_00: uint32
  gtk_widget_path(cast[ptr Widget00](self.impl), pathLength_00, path_00, pathReversed_00)
  if path.addr != nil:
    path = $(path_00)
  if pathReversed.addr != nil:
    pathReversed = $(pathReversed_00)
  if pathLength.addr != nil:
    pathLength = int(pathLength_00)

proc gtk_widget_queue_allocate(self: ptr Widget00) {.
    importc, libprag.}

proc queueAllocate*(self: Widget) =
  gtk_widget_queue_allocate(cast[ptr Widget00](self.impl))

proc gtk_widget_queue_compute_expand(self: ptr Widget00) {.
    importc, libprag.}

proc queueComputeExpand*(self: Widget) =
  gtk_widget_queue_compute_expand(cast[ptr Widget00](self.impl))

proc gtk_widget_queue_draw(self: ptr Widget00) {.
    importc, libprag.}

proc queueDraw*(self: Widget) =
  gtk_widget_queue_draw(cast[ptr Widget00](self.impl))

proc gtk_widget_queue_draw_area(self: ptr Widget00; x: int32; y: int32; width: int32;
    height: int32) {.
    importc, libprag.}

proc queueDrawArea*(self: Widget; x: int; y: int; width: int;
    height: int) =
  gtk_widget_queue_draw_area(cast[ptr Widget00](self.impl), int32(x), int32(y), int32(width), int32(height))

proc gtk_widget_queue_draw_region(self: ptr Widget00; region: ptr cairo.Region00) {.
    importc, libprag.}

proc queueDrawRegion*(self: Widget; region: cairo.Region) =
  gtk_widget_queue_draw_region(cast[ptr Widget00](self.impl), cast[ptr cairo.Region00](region.impl))

proc gtk_widget_queue_resize(self: ptr Widget00) {.
    importc, libprag.}

proc queueResize*(self: Widget) =
  gtk_widget_queue_resize(cast[ptr Widget00](self.impl))

proc gtk_widget_queue_resize_no_redraw(self: ptr Widget00) {.
    importc, libprag.}

proc queueResizeNoRedraw*(self: Widget) =
  gtk_widget_queue_resize_no_redraw(cast[ptr Widget00](self.impl))

proc gtk_widget_realize(self: ptr Widget00) {.
    importc, libprag.}

proc realize*(self: Widget) =
  gtk_widget_realize(cast[ptr Widget00](self.impl))

proc gtk_widget_region_intersect(self: ptr Widget00; region: ptr cairo.Region00): ptr cairo.Region00 {.
    importc, libprag.}

proc regionIntersect*(self: Widget; region: cairo.Region): cairo.Region =
  fnew(result, gBoxedFreeCairoRegion)
  result.impl = gtk_widget_region_intersect(cast[ptr Widget00](self.impl), cast[ptr cairo.Region00](region.impl))

proc gtk_widget_register_window(self: ptr Widget00; window: ptr gdk.Window00) {.
    importc, libprag.}

proc registerWindow*(self: Widget; window: gdk.Window) =
  gtk_widget_register_window(cast[ptr Widget00](self.impl), cast[ptr gdk.Window00](window.impl))

proc gtk_widget_remove_mnemonic_label(self: ptr Widget00; label: ptr Widget00) {.
    importc, libprag.}

proc removeMnemonicLabel*(self: Widget; label: Widget) =
  gtk_widget_remove_mnemonic_label(cast[ptr Widget00](self.impl), cast[ptr Widget00](label.impl))

proc gtk_widget_remove_tick_callback(self: ptr Widget00; id: uint32) {.
    importc, libprag.}

proc removeTickCallback*(self: Widget; id: int) =
  gtk_widget_remove_tick_callback(cast[ptr Widget00](self.impl), uint32(id))

proc gtk_widget_render_icon(self: ptr Widget00; stockId: cstring; size: int32;
    detail: cstring): ptr gdkpixbuf.Pixbuf00 {.
    importc, libprag.}

proc renderIcon*(self: Widget; stockId: cstring; size: int; detail: cstring = nil): gdkpixbuf.Pixbuf =
  let gobj = gtk_widget_render_icon(cast[ptr Widget00](self.impl), stockId, int32(size), detail)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdkpixbuf.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_render_icon_pixbuf(self: ptr Widget00; stockId: cstring;
    size: int32): ptr gdkpixbuf.Pixbuf00 {.
    importc, libprag.}

proc renderIconPixbuf*(self: Widget; stockId: cstring; size: int): gdkpixbuf.Pixbuf =
  let gobj = gtk_widget_render_icon_pixbuf(cast[ptr Widget00](self.impl), stockId, int32(size))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdkpixbuf.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_reparent(self: ptr Widget00; newParent: ptr Widget00) {.
    importc, libprag.}

proc reparent*(self: Widget; newParent: Widget) =
  gtk_widget_reparent(cast[ptr Widget00](self.impl), cast[ptr Widget00](newParent.impl))

proc gtk_widget_reset_rc_styles(self: ptr Widget00) {.
    importc, libprag.}

proc resetRcStyles*(self: Widget) =
  gtk_widget_reset_rc_styles(cast[ptr Widget00](self.impl))

proc gtk_widget_reset_style(self: ptr Widget00) {.
    importc, libprag.}

proc resetStyle*(self: Widget) =
  gtk_widget_reset_style(cast[ptr Widget00](self.impl))

proc gtk_widget_send_expose(self: ptr Widget00; event: ptr gdk.Event00): int32 {.
    importc, libprag.}

proc sendExpose*(self: Widget; event: gdk.Event): int =
  int(gtk_widget_send_expose(cast[ptr Widget00](self.impl), cast[ptr gdk.Event00](event.impl)))

proc gtk_widget_send_focus_change(self: ptr Widget00; event: ptr gdk.Event00): gboolean {.
    importc, libprag.}

proc sendFocusChange*(self: Widget; event: gdk.Event): bool =
  toBool(gtk_widget_send_focus_change(cast[ptr Widget00](self.impl), cast[ptr gdk.Event00](event.impl)))

proc gtk_widget_set_allocation(self: ptr Widget00; allocation: gdk.Rectangle) {.
    importc, libprag.}

proc setAllocation*(self: Widget; allocation: gdk.Rectangle) =
  gtk_widget_set_allocation(cast[ptr Widget00](self.impl), allocation)

proc `allocation=`*(self: Widget; allocation: gdk.Rectangle) =
  gtk_widget_set_allocation(cast[ptr Widget00](self.impl), allocation)

proc gtk_widget_set_app_paintable(self: ptr Widget00; appPaintable: gboolean) {.
    importc, libprag.}

proc setAppPaintable*(self: Widget; appPaintable: bool = true) =
  gtk_widget_set_app_paintable(cast[ptr Widget00](self.impl), gboolean(appPaintable))

proc `appPaintable=`*(self: Widget; appPaintable: bool) =
  gtk_widget_set_app_paintable(cast[ptr Widget00](self.impl), gboolean(appPaintable))

proc gtk_widget_set_can_default(self: ptr Widget00; canDefault: gboolean) {.
    importc, libprag.}

proc setCanDefault*(self: Widget; canDefault: bool = true) =
  gtk_widget_set_can_default(cast[ptr Widget00](self.impl), gboolean(canDefault))

proc `canDefault=`*(self: Widget; canDefault: bool) =
  gtk_widget_set_can_default(cast[ptr Widget00](self.impl), gboolean(canDefault))

proc gtk_widget_set_can_focus(self: ptr Widget00; canFocus: gboolean) {.
    importc, libprag.}

proc setCanFocus*(self: Widget; canFocus: bool = true) =
  gtk_widget_set_can_focus(cast[ptr Widget00](self.impl), gboolean(canFocus))

proc `canFocus=`*(self: Widget; canFocus: bool) =
  gtk_widget_set_can_focus(cast[ptr Widget00](self.impl), gboolean(canFocus))

proc gtk_widget_set_child_visible(self: ptr Widget00; isVisible: gboolean) {.
    importc, libprag.}

proc setChildVisible*(self: Widget; isVisible: bool = true) =
  gtk_widget_set_child_visible(cast[ptr Widget00](self.impl), gboolean(isVisible))

proc `childVisible=`*(self: Widget; isVisible: bool) =
  gtk_widget_set_child_visible(cast[ptr Widget00](self.impl), gboolean(isVisible))

proc gtk_widget_set_clip(self: ptr Widget00; clip: gdk.Rectangle) {.
    importc, libprag.}

proc setClip*(self: Widget; clip: gdk.Rectangle) =
  gtk_widget_set_clip(cast[ptr Widget00](self.impl), clip)

proc `clip=`*(self: Widget; clip: gdk.Rectangle) =
  gtk_widget_set_clip(cast[ptr Widget00](self.impl), clip)

proc gtk_widget_set_composite_name(self: ptr Widget00; name: cstring) {.
    importc, libprag.}

proc setCompositeName*(self: Widget; name: cstring) =
  gtk_widget_set_composite_name(cast[ptr Widget00](self.impl), name)

proc `compositeName=`*(self: Widget; name: cstring) =
  gtk_widget_set_composite_name(cast[ptr Widget00](self.impl), name)

proc gtk_widget_set_device_enabled(self: ptr Widget00; device: ptr gdk.Device00;
    enabled: gboolean) {.
    importc, libprag.}

proc setDeviceEnabled*(self: Widget; device: gdk.Device; enabled: bool) =
  gtk_widget_set_device_enabled(cast[ptr Widget00](self.impl), cast[ptr gdk.Device00](device.impl), gboolean(enabled))

proc gtk_widget_set_device_events(self: ptr Widget00; device: ptr gdk.Device00;
    events: gdk.EventMask) {.
    importc, libprag.}

proc setDeviceEvents*(self: Widget; device: gdk.Device; events: gdk.EventMask) =
  gtk_widget_set_device_events(cast[ptr Widget00](self.impl), cast[ptr gdk.Device00](device.impl), events)

proc gtk_widget_set_direction(self: ptr Widget00; dir: TextDirection) {.
    importc, libprag.}

proc setDirection*(self: Widget; dir: TextDirection) =
  gtk_widget_set_direction(cast[ptr Widget00](self.impl), dir)

proc `direction=`*(self: Widget; dir: TextDirection) =
  gtk_widget_set_direction(cast[ptr Widget00](self.impl), dir)

proc gtk_widget_set_double_buffered(self: ptr Widget00; doubleBuffered: gboolean) {.
    importc, libprag.}

proc setDoubleBuffered*(self: Widget; doubleBuffered: bool = true) =
  gtk_widget_set_double_buffered(cast[ptr Widget00](self.impl), gboolean(doubleBuffered))

proc `doubleBuffered=`*(self: Widget; doubleBuffered: bool) =
  gtk_widget_set_double_buffered(cast[ptr Widget00](self.impl), gboolean(doubleBuffered))

proc gtk_widget_set_events(self: ptr Widget00; events: gdk.EventMask) {.
    importc, libprag.}

proc setEvents*(self: Widget; events: gdk.EventMask) =
  gtk_widget_set_events(cast[ptr Widget00](self.impl), events)

proc `events=`*(self: Widget; events: gdk.EventMask) =
  gtk_widget_set_events(cast[ptr Widget00](self.impl), events)

proc gtk_widget_set_focus_on_click(self: ptr Widget00; focusOnClick: gboolean) {.
    importc, libprag.}

proc setFocusOnClick*(self: Widget; focusOnClick: bool = true) =
  gtk_widget_set_focus_on_click(cast[ptr Widget00](self.impl), gboolean(focusOnClick))

proc `focusOnClick=`*(self: Widget; focusOnClick: bool) =
  gtk_widget_set_focus_on_click(cast[ptr Widget00](self.impl), gboolean(focusOnClick))

proc gtk_widget_set_font_map(self: ptr Widget00; fontMap: ptr pango.FontMap00) {.
    importc, libprag.}

proc setFontMap*(self: Widget; fontMap: pango.FontMap = nil) =
  gtk_widget_set_font_map(cast[ptr Widget00](self.impl), if fontMap.isNil: nil else: cast[ptr pango.FontMap00](fontMap.impl))

proc `fontMap=`*(self: Widget; fontMap: pango.FontMap = nil) =
  gtk_widget_set_font_map(cast[ptr Widget00](self.impl), if fontMap.isNil: nil else: cast[ptr pango.FontMap00](fontMap.impl))

proc gtk_widget_set_font_options(self: ptr Widget00; options: ptr cairo.FontOptions00) {.
    importc, libprag.}

proc setFontOptions*(self: Widget; options: cairo.FontOptions = nil) =
  gtk_widget_set_font_options(cast[ptr Widget00](self.impl), if options.isNil: nil else: cast[ptr cairo.FontOptions00](options.impl))

proc `fontOptions=`*(self: Widget; options: cairo.FontOptions = nil) =
  gtk_widget_set_font_options(cast[ptr Widget00](self.impl), if options.isNil: nil else: cast[ptr cairo.FontOptions00](options.impl))

proc gtk_widget_set_has_tooltip(self: ptr Widget00; hasTooltip: gboolean) {.
    importc, libprag.}

proc setHasTooltip*(self: Widget; hasTooltip: bool = true) =
  gtk_widget_set_has_tooltip(cast[ptr Widget00](self.impl), gboolean(hasTooltip))

proc `hasTooltip=`*(self: Widget; hasTooltip: bool) =
  gtk_widget_set_has_tooltip(cast[ptr Widget00](self.impl), gboolean(hasTooltip))

proc gtk_widget_set_has_window(self: ptr Widget00; hasWindow: gboolean) {.
    importc, libprag.}

proc setHasWindow*(self: Widget; hasWindow: bool = true) =
  gtk_widget_set_has_window(cast[ptr Widget00](self.impl), gboolean(hasWindow))

proc `hasWindow=`*(self: Widget; hasWindow: bool) =
  gtk_widget_set_has_window(cast[ptr Widget00](self.impl), gboolean(hasWindow))

proc gtk_widget_set_hexpand(self: ptr Widget00; expand: gboolean) {.
    importc, libprag.}

proc setHexpand*(self: Widget; expand: bool = true) =
  gtk_widget_set_hexpand(cast[ptr Widget00](self.impl), gboolean(expand))

proc `hexpand=`*(self: Widget; expand: bool) =
  gtk_widget_set_hexpand(cast[ptr Widget00](self.impl), gboolean(expand))

proc gtk_widget_set_hexpand_set(self: ptr Widget00; set: gboolean) {.
    importc, libprag.}

proc setHexpandSet*(self: Widget; set: bool = true) =
  gtk_widget_set_hexpand_set(cast[ptr Widget00](self.impl), gboolean(set))

proc `hexpandSet=`*(self: Widget; set: bool) =
  gtk_widget_set_hexpand_set(cast[ptr Widget00](self.impl), gboolean(set))

proc gtk_widget_set_mapped(self: ptr Widget00; mapped: gboolean) {.
    importc, libprag.}

proc setMapped*(self: Widget; mapped: bool = true) =
  gtk_widget_set_mapped(cast[ptr Widget00](self.impl), gboolean(mapped))

proc `mapped=`*(self: Widget; mapped: bool) =
  gtk_widget_set_mapped(cast[ptr Widget00](self.impl), gboolean(mapped))

proc gtk_widget_set_margin_bottom(self: ptr Widget00; margin: int32) {.
    importc, libprag.}

proc setMarginBottom*(self: Widget; margin: int) =
  gtk_widget_set_margin_bottom(cast[ptr Widget00](self.impl), int32(margin))

proc `marginBottom=`*(self: Widget; margin: int) =
  gtk_widget_set_margin_bottom(cast[ptr Widget00](self.impl), int32(margin))

proc gtk_widget_set_margin_end(self: ptr Widget00; margin: int32) {.
    importc, libprag.}

proc setMarginEnd*(self: Widget; margin: int) =
  gtk_widget_set_margin_end(cast[ptr Widget00](self.impl), int32(margin))

proc `marginEnd=`*(self: Widget; margin: int) =
  gtk_widget_set_margin_end(cast[ptr Widget00](self.impl), int32(margin))

proc gtk_widget_set_margin_left(self: ptr Widget00; margin: int32) {.
    importc, libprag.}

proc setMarginLeft*(self: Widget; margin: int) =
  gtk_widget_set_margin_left(cast[ptr Widget00](self.impl), int32(margin))

proc `marginLeft=`*(self: Widget; margin: int) =
  gtk_widget_set_margin_left(cast[ptr Widget00](self.impl), int32(margin))

proc gtk_widget_set_margin_right(self: ptr Widget00; margin: int32) {.
    importc, libprag.}

proc setMarginRight*(self: Widget; margin: int) =
  gtk_widget_set_margin_right(cast[ptr Widget00](self.impl), int32(margin))

proc `marginRight=`*(self: Widget; margin: int) =
  gtk_widget_set_margin_right(cast[ptr Widget00](self.impl), int32(margin))

proc gtk_widget_set_margin_start(self: ptr Widget00; margin: int32) {.
    importc, libprag.}

proc setMarginStart*(self: Widget; margin: int) =
  gtk_widget_set_margin_start(cast[ptr Widget00](self.impl), int32(margin))

proc `marginStart=`*(self: Widget; margin: int) =
  gtk_widget_set_margin_start(cast[ptr Widget00](self.impl), int32(margin))

proc gtk_widget_set_margin_top(self: ptr Widget00; margin: int32) {.
    importc, libprag.}

proc setMarginTop*(self: Widget; margin: int) =
  gtk_widget_set_margin_top(cast[ptr Widget00](self.impl), int32(margin))

proc `marginTop=`*(self: Widget; margin: int) =
  gtk_widget_set_margin_top(cast[ptr Widget00](self.impl), int32(margin))

proc gtk_widget_set_name(self: ptr Widget00; name: cstring) {.
    importc, libprag.}

proc setName*(self: Widget; name: cstring) =
  gtk_widget_set_name(cast[ptr Widget00](self.impl), name)

proc `name=`*(self: Widget; name: cstring) =
  gtk_widget_set_name(cast[ptr Widget00](self.impl), name)

proc gtk_widget_set_no_show_all(self: ptr Widget00; noShowAll: gboolean) {.
    importc, libprag.}

proc setNoShowAll*(self: Widget; noShowAll: bool = true) =
  gtk_widget_set_no_show_all(cast[ptr Widget00](self.impl), gboolean(noShowAll))

proc `noShowAll=`*(self: Widget; noShowAll: bool) =
  gtk_widget_set_no_show_all(cast[ptr Widget00](self.impl), gboolean(noShowAll))

proc gtk_widget_set_opacity(self: ptr Widget00; opacity: cdouble) {.
    importc, libprag.}

proc setOpacity*(self: Widget; opacity: cdouble) =
  gtk_widget_set_opacity(cast[ptr Widget00](self.impl), opacity)

proc `opacity=`*(self: Widget; opacity: cdouble) =
  gtk_widget_set_opacity(cast[ptr Widget00](self.impl), opacity)

proc gtk_widget_set_parent(self: ptr Widget00; parent: ptr Widget00) {.
    importc, libprag.}

proc setParent*(self: Widget; parent: Widget) =
  gtk_widget_set_parent(cast[ptr Widget00](self.impl), cast[ptr Widget00](parent.impl))

proc `parent=`*(self: Widget; parent: Widget) =
  gtk_widget_set_parent(cast[ptr Widget00](self.impl), cast[ptr Widget00](parent.impl))

proc gtk_widget_set_parent_window(self: ptr Widget00; parentWindow: ptr gdk.Window00) {.
    importc, libprag.}

proc setParentWindow*(self: Widget; parentWindow: gdk.Window) =
  gtk_widget_set_parent_window(cast[ptr Widget00](self.impl), cast[ptr gdk.Window00](parentWindow.impl))

proc `parentWindow=`*(self: Widget; parentWindow: gdk.Window) =
  gtk_widget_set_parent_window(cast[ptr Widget00](self.impl), cast[ptr gdk.Window00](parentWindow.impl))

proc gtk_widget_set_realized(self: ptr Widget00; realized: gboolean) {.
    importc, libprag.}

proc setRealized*(self: Widget; realized: bool = true) =
  gtk_widget_set_realized(cast[ptr Widget00](self.impl), gboolean(realized))

proc `realized=`*(self: Widget; realized: bool) =
  gtk_widget_set_realized(cast[ptr Widget00](self.impl), gboolean(realized))

proc gtk_widget_set_receives_default(self: ptr Widget00; receivesDefault: gboolean) {.
    importc, libprag.}

proc setReceivesDefault*(self: Widget; receivesDefault: bool = true) =
  gtk_widget_set_receives_default(cast[ptr Widget00](self.impl), gboolean(receivesDefault))

proc `receivesDefault=`*(self: Widget; receivesDefault: bool) =
  gtk_widget_set_receives_default(cast[ptr Widget00](self.impl), gboolean(receivesDefault))

proc gtk_widget_set_redraw_on_allocate(self: ptr Widget00; redrawOnAllocate: gboolean) {.
    importc, libprag.}

proc setRedrawOnAllocate*(self: Widget; redrawOnAllocate: bool = true) =
  gtk_widget_set_redraw_on_allocate(cast[ptr Widget00](self.impl), gboolean(redrawOnAllocate))

proc `redrawOnAllocate=`*(self: Widget; redrawOnAllocate: bool) =
  gtk_widget_set_redraw_on_allocate(cast[ptr Widget00](self.impl), gboolean(redrawOnAllocate))

proc gtk_widget_set_sensitive(self: ptr Widget00; sensitive: gboolean) {.
    importc, libprag.}

proc setSensitive*(self: Widget; sensitive: bool = true) =
  gtk_widget_set_sensitive(cast[ptr Widget00](self.impl), gboolean(sensitive))

proc `sensitive=`*(self: Widget; sensitive: bool) =
  gtk_widget_set_sensitive(cast[ptr Widget00](self.impl), gboolean(sensitive))

proc gtk_widget_set_size_request(self: ptr Widget00; width: int32; height: int32) {.
    importc, libprag.}

proc setSizeRequest*(self: Widget; width: int; height: int) =
  gtk_widget_set_size_request(cast[ptr Widget00](self.impl), int32(width), int32(height))

proc gtk_widget_set_state(self: ptr Widget00; state: StateType) {.
    importc, libprag.}

proc setState*(self: Widget; state: StateType) =
  gtk_widget_set_state(cast[ptr Widget00](self.impl), state)

proc `state=`*(self: Widget; state: StateType) =
  gtk_widget_set_state(cast[ptr Widget00](self.impl), state)

proc gtk_widget_set_state_flags(self: ptr Widget00; flags: StateFlags; clear: gboolean) {.
    importc, libprag.}

proc setStateFlags*(self: Widget; flags: StateFlags; clear: bool) =
  gtk_widget_set_state_flags(cast[ptr Widget00](self.impl), flags, gboolean(clear))

proc gtk_widget_set_style(self: ptr Widget00; style: ptr Style00) {.
    importc, libprag.}

proc setStyle*(self: Widget; style: Style = nil) =
  gtk_widget_set_style(cast[ptr Widget00](self.impl), if style.isNil: nil else: cast[ptr Style00](style.impl))

proc `style=`*(self: Widget; style: Style = nil) =
  gtk_widget_set_style(cast[ptr Widget00](self.impl), if style.isNil: nil else: cast[ptr Style00](style.impl))

proc gtk_widget_set_support_multidevice(self: ptr Widget00; supportMultidevice: gboolean) {.
    importc, libprag.}

proc setSupportMultidevice*(self: Widget; supportMultidevice: bool = true) =
  gtk_widget_set_support_multidevice(cast[ptr Widget00](self.impl), gboolean(supportMultidevice))

proc `supportMultidevice=`*(self: Widget; supportMultidevice: bool) =
  gtk_widget_set_support_multidevice(cast[ptr Widget00](self.impl), gboolean(supportMultidevice))

proc gtk_widget_set_tooltip_markup(self: ptr Widget00; markup: cstring) {.
    importc, libprag.}

proc setTooltipMarkup*(self: Widget; markup: cstring = nil) =
  gtk_widget_set_tooltip_markup(cast[ptr Widget00](self.impl), markup)

proc `tooltipMarkup=`*(self: Widget; markup: cstring = nil) =
  gtk_widget_set_tooltip_markup(cast[ptr Widget00](self.impl), markup)

proc gtk_widget_set_tooltip_text(self: ptr Widget00; text: cstring) {.
    importc, libprag.}

proc setTooltipText*(self: Widget; text: cstring = nil) =
  gtk_widget_set_tooltip_text(cast[ptr Widget00](self.impl), text)

proc `tooltipText=`*(self: Widget; text: cstring = nil) =
  gtk_widget_set_tooltip_text(cast[ptr Widget00](self.impl), text)

proc gtk_widget_set_vexpand(self: ptr Widget00; expand: gboolean) {.
    importc, libprag.}

proc setVexpand*(self: Widget; expand: bool = true) =
  gtk_widget_set_vexpand(cast[ptr Widget00](self.impl), gboolean(expand))

proc `vexpand=`*(self: Widget; expand: bool) =
  gtk_widget_set_vexpand(cast[ptr Widget00](self.impl), gboolean(expand))

proc gtk_widget_set_vexpand_set(self: ptr Widget00; set: gboolean) {.
    importc, libprag.}

proc setVexpandSet*(self: Widget; set: bool = true) =
  gtk_widget_set_vexpand_set(cast[ptr Widget00](self.impl), gboolean(set))

proc `vexpandSet=`*(self: Widget; set: bool) =
  gtk_widget_set_vexpand_set(cast[ptr Widget00](self.impl), gboolean(set))

proc gtk_widget_set_visible(self: ptr Widget00; visible: gboolean) {.
    importc, libprag.}

proc setVisible*(self: Widget; visible: bool = true) =
  gtk_widget_set_visible(cast[ptr Widget00](self.impl), gboolean(visible))

proc `visible=`*(self: Widget; visible: bool) =
  gtk_widget_set_visible(cast[ptr Widget00](self.impl), gboolean(visible))

proc gtk_widget_set_visual(self: ptr Widget00; visual: ptr gdk.Visual00) {.
    importc, libprag.}

proc setVisual*(self: Widget; visual: gdk.Visual = nil) =
  gtk_widget_set_visual(cast[ptr Widget00](self.impl), if visual.isNil: nil else: cast[ptr gdk.Visual00](visual.impl))

proc `visual=`*(self: Widget; visual: gdk.Visual = nil) =
  gtk_widget_set_visual(cast[ptr Widget00](self.impl), if visual.isNil: nil else: cast[ptr gdk.Visual00](visual.impl))

proc gtk_widget_set_window(self: ptr Widget00; window: ptr gdk.Window00) {.
    importc, libprag.}

proc setWindow*(self: Widget; window: gdk.Window) =
  gtk_widget_set_window(cast[ptr Widget00](self.impl), cast[ptr gdk.Window00](g_object_ref(window.impl)))

proc `window=`*(self: Widget; window: gdk.Window) =
  gtk_widget_set_window(cast[ptr Widget00](self.impl), cast[ptr gdk.Window00](g_object_ref(window.impl)))

proc gtk_widget_shape_combine_region(self: ptr Widget00; region: ptr cairo.Region00) {.
    importc, libprag.}

proc shapeCombineRegion*(self: Widget; region: cairo.Region = nil) =
  gtk_widget_shape_combine_region(cast[ptr Widget00](self.impl), if region.isNil: nil else: cast[ptr cairo.Region00](region.impl))

proc gtk_widget_show(self: ptr Widget00) {.
    importc, libprag.}

proc show*(self: Widget) =
  gtk_widget_show(cast[ptr Widget00](self.impl))

proc gtk_widget_show_all(self: ptr Widget00) {.
    importc, libprag.}

proc showAll*(self: Widget) =
  gtk_widget_show_all(cast[ptr Widget00](self.impl))

proc gtk_widget_show_now(self: ptr Widget00) {.
    importc, libprag.}

proc showNow*(self: Widget) =
  gtk_widget_show_now(cast[ptr Widget00](self.impl))

proc gtk_widget_size_allocate(self: ptr Widget00; allocation: gdk.Rectangle) {.
    importc, libprag.}

proc sizeAllocate*(self: Widget; allocation: gdk.Rectangle) =
  gtk_widget_size_allocate(cast[ptr Widget00](self.impl), allocation)

proc gtk_widget_size_allocate_with_baseline(self: ptr Widget00; allocation: gdk.Rectangle;
    baseline: int32) {.
    importc, libprag.}

proc sizeAllocateWithBaseline*(self: Widget; allocation: gdk.Rectangle;
    baseline: int) =
  gtk_widget_size_allocate_with_baseline(cast[ptr Widget00](self.impl), allocation, int32(baseline))

proc gtk_widget_style_attach(self: ptr Widget00) {.
    importc, libprag.}

proc styleAttach*(self: Widget) =
  gtk_widget_style_attach(cast[ptr Widget00](self.impl))

proc gtk_widget_style_get_property(self: ptr Widget00; propertyName: cstring;
    value: gobject.Value) {.
    importc, libprag.}

proc styleGetProperty*(self: Widget; propertyName: cstring; value: gobject.Value) =
  gtk_widget_style_get_property(cast[ptr Widget00](self.impl), propertyName, value)

proc gtk_widget_thaw_child_notify(self: ptr Widget00) {.
    importc, libprag.}

proc thawChildNotify*(self: Widget) =
  gtk_widget_thaw_child_notify(cast[ptr Widget00](self.impl))

proc gtk_widget_translate_coordinates(self: ptr Widget00; destWidget: ptr Widget00;
    srcX: int32; srcY: int32; destX: var int32; destY: var int32): gboolean {.
    importc, libprag.}

proc translateCoordinates*(self: Widget; destWidget: Widget; srcX: int;
    srcY: int; destX: var int = cast[var int](nil); destY: var int = cast[var int](nil)): bool =
  var destY_00: int32
  var destX_00: int32
  result = toBool(gtk_widget_translate_coordinates(cast[ptr Widget00](self.impl), cast[ptr Widget00](destWidget.impl), int32(srcX), int32(srcY), destX_00, destY_00))
  if destY.addr != nil:
    destY = int(destY_00)
  if destX.addr != nil:
    destX = int(destX_00)

proc gtk_widget_trigger_tooltip_query(self: ptr Widget00) {.
    importc, libprag.}

proc triggerTooltipQuery*(self: Widget) =
  gtk_widget_trigger_tooltip_query(cast[ptr Widget00](self.impl))

proc gtk_widget_unmap(self: ptr Widget00) {.
    importc, libprag.}

proc unmap*(self: Widget) =
  gtk_widget_unmap(cast[ptr Widget00](self.impl))

proc gtk_widget_unparent(self: ptr Widget00) {.
    importc, libprag.}

proc unparent*(self: Widget) =
  gtk_widget_unparent(cast[ptr Widget00](self.impl))

proc gtk_widget_unrealize(self: ptr Widget00) {.
    importc, libprag.}

proc unrealize*(self: Widget) =
  gtk_widget_unrealize(cast[ptr Widget00](self.impl))

proc gtk_widget_unregister_window(self: ptr Widget00; window: ptr gdk.Window00) {.
    importc, libprag.}

proc unregisterWindow*(self: Widget; window: gdk.Window) =
  gtk_widget_unregister_window(cast[ptr Widget00](self.impl), cast[ptr gdk.Window00](window.impl))

proc gtk_widget_unset_state_flags(self: ptr Widget00; flags: StateFlags) {.
    importc, libprag.}

proc unsetStateFlags*(self: Widget; flags: StateFlags) =
  gtk_widget_unset_state_flags(cast[ptr Widget00](self.impl), flags)

type
  Container* = ref object of Widget
  Container00* = object of Widget00

proc gtk_container_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Container()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scAdd*(self: Container;  p: proc (self: ptr Container00; `object`: ptr Widget00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "add", cast[GCallback](p), xdata, nil, cf)

proc scCheckResize*(self: Container;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "check-resize", cast[GCallback](p), xdata, nil, cf)

proc scRemove*(self: Container;  p: proc (self: ptr Container00; `object`: ptr Widget00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "remove", cast[GCallback](p), xdata, nil, cf)

proc scSetFocusChild*(self: Container;  p: proc (self: ptr Container00; `object`: ptr Widget00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "set-focus-child", cast[GCallback](p), xdata, nil, cf)

proc gtk_container_add(self: ptr Container00; widget: ptr Widget00) {.
    importc, libprag.}

proc add*(self: Container; widget: Widget) =
  gtk_container_add(cast[ptr Container00](self.impl), cast[ptr Widget00](widget.impl))

proc gtk_container_check_resize(self: ptr Container00) {.
    importc, libprag.}

proc checkResize*(self: Container) =
  gtk_container_check_resize(cast[ptr Container00](self.impl))

proc gtk_container_child_get_property(self: ptr Container00; child: ptr Widget00;
    propertyName: cstring; value: gobject.Value) {.
    importc, libprag.}

proc childGetProperty*(self: Container; child: Widget; propertyName: cstring;
    value: gobject.Value) =
  gtk_container_child_get_property(cast[ptr Container00](self.impl), cast[ptr Widget00](child.impl), propertyName, value)

proc gtk_container_child_notify(self: ptr Container00; child: ptr Widget00;
    childProperty: cstring) {.
    importc, libprag.}

proc childNotify*(self: Container; child: Widget; childProperty: cstring) =
  gtk_container_child_notify(cast[ptr Container00](self.impl), cast[ptr Widget00](child.impl), childProperty)

proc gtk_container_child_notify_by_pspec(self: ptr Container00; child: ptr Widget00;
    pspec: ptr gobject.ParamSpec00) {.
    importc, libprag.}

proc childNotifyByPspec*(self: Container; child: Widget;
    pspec: gobject.ParamSpec) =
  gtk_container_child_notify_by_pspec(cast[ptr Container00](self.impl), cast[ptr Widget00](child.impl), cast[ptr gobject.ParamSpec00](pspec.impl))

proc gtk_container_child_set_property(self: ptr Container00; child: ptr Widget00;
    propertyName: cstring; value: gobject.Value) {.
    importc, libprag.}

proc childSetProperty*(self: Container; child: Widget; propertyName: cstring;
    value: gobject.Value) =
  gtk_container_child_set_property(cast[ptr Container00](self.impl), cast[ptr Widget00](child.impl), propertyName, value)

proc gtk_container_child_type(self: ptr Container00): GType {.
    importc, libprag.}

proc childType*(self: Container): GType =
  gtk_container_child_type(cast[ptr Container00](self.impl))

proc gtk_container_get_border_width(self: ptr Container00): uint32 {.
    importc, libprag.}

proc getBorderWidth*(self: Container): int =
  int(gtk_container_get_border_width(cast[ptr Container00](self.impl)))

proc borderWidth*(self: Container): int =
  int(gtk_container_get_border_width(cast[ptr Container00](self.impl)))

proc gtk_container_get_children(self: ptr Container00): ptr glib.List {.
    importc, libprag.}

proc getChildren*(self: Container): seq[Widget] =
  let resul0 = gtk_container_get_children(cast[ptr Container00](self.impl))
  result = glistObjects2seq(Widget, resul0, false)
  g_list_free(resul0)

proc children*(self: Container): seq[Widget] =
  let resul0 = gtk_container_get_children(cast[ptr Container00](self.impl))
  result = glistObjects2seq(Widget, resul0, false)
  g_list_free(resul0)

proc gtk_container_get_focus_child(self: ptr Container00): ptr Widget00 {.
    importc, libprag.}

proc getFocusChild*(self: Container): Widget =
  let gobj = gtk_container_get_focus_child(cast[ptr Container00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc focusChild*(self: Container): Widget =
  let gobj = gtk_container_get_focus_child(cast[ptr Container00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_container_propagate_draw(self: ptr Container00; child: ptr Widget00;
    cr: ptr cairo.Context00) {.
    importc, libprag.}

proc propagateDraw*(self: Container; child: Widget; cr: cairo.Context) =
  gtk_container_propagate_draw(cast[ptr Container00](self.impl), cast[ptr Widget00](child.impl), cast[ptr cairo.Context00](cr.impl))

proc gtk_container_remove(self: ptr Container00; widget: ptr Widget00) {.
    importc, libprag.}

proc remove*(self: Container; widget: Widget) =
  gtk_container_remove(cast[ptr Container00](self.impl), cast[ptr Widget00](widget.impl))

proc gtk_container_resize_children(self: ptr Container00) {.
    importc, libprag.}

proc resizeChildren*(self: Container) =
  gtk_container_resize_children(cast[ptr Container00](self.impl))

proc gtk_container_set_border_width(self: ptr Container00; borderWidth: uint32) {.
    importc, libprag.}

proc setBorderWidth*(self: Container; borderWidth: int) =
  gtk_container_set_border_width(cast[ptr Container00](self.impl), uint32(borderWidth))

proc `borderWidth=`*(self: Container; borderWidth: int) =
  gtk_container_set_border_width(cast[ptr Container00](self.impl), uint32(borderWidth))

proc gtk_container_set_focus_chain(self: ptr Container00; focusableWidgets: ptr glib.List) {.
    importc, libprag.}

proc setFocusChain*(self: Container; focusableWidgets: seq[Widget]) =
  var tempResGL = seq2GList(focusableWidgets)
  gtk_container_set_focus_chain(cast[ptr Container00](self.impl), tempResGL)
  g_list_free(tempResGL)

proc `focusChain=`*(self: Container; focusableWidgets: seq[Widget]) =
  var tempResGL = seq2GList(focusableWidgets)
  gtk_container_set_focus_chain(cast[ptr Container00](self.impl), tempResGL)
  g_list_free(tempResGL)

proc gtk_container_set_focus_child(self: ptr Container00; child: ptr Widget00) {.
    importc, libprag.}

proc setFocusChild*(self: Container; child: Widget = nil) =
  gtk_container_set_focus_child(cast[ptr Container00](self.impl), if child.isNil: nil else: cast[ptr Widget00](child.impl))

proc `focusChild=`*(self: Container; child: Widget = nil) =
  gtk_container_set_focus_child(cast[ptr Container00](self.impl), if child.isNil: nil else: cast[ptr Widget00](child.impl))

proc gtk_container_set_reallocate_redraws(self: ptr Container00; needsRedraws: gboolean) {.
    importc, libprag.}

proc setReallocateRedraws*(self: Container; needsRedraws: bool = true) =
  gtk_container_set_reallocate_redraws(cast[ptr Container00](self.impl), gboolean(needsRedraws))

proc `reallocateRedraws=`*(self: Container; needsRedraws: bool) =
  gtk_container_set_reallocate_redraws(cast[ptr Container00](self.impl), gboolean(needsRedraws))

proc gtk_container_unset_focus_chain(self: ptr Container00) {.
    importc, libprag.}

proc unsetFocusChain*(self: Container) =
  gtk_container_unset_focus_chain(cast[ptr Container00](self.impl))

type
  Bin* = ref object of Container
  Bin00* = object of Container00

proc gtk_bin_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Bin()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_bin_get_child(self: ptr Bin00): ptr Widget00 {.
    importc, libprag.}

proc getChild*(self: Bin): Widget =
  let gobj = gtk_bin_get_child(cast[ptr Bin00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc child*(self: Bin): Widget =
  let gobj = gtk_bin_get_child(cast[ptr Bin00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_tooltip_set_custom(self: ptr Tooltip00; customWidget: ptr Widget00) {.
    importc, libprag.}

proc setCustom*(self: Tooltip; customWidget: Widget = nil) =
  gtk_tooltip_set_custom(cast[ptr Tooltip00](self.impl), if customWidget.isNil: nil else: cast[ptr Widget00](customWidget.impl))

proc `custom=`*(self: Tooltip; customWidget: Widget = nil) =
  gtk_tooltip_set_custom(cast[ptr Tooltip00](self.impl), if customWidget.isNil: nil else: cast[ptr Widget00](customWidget.impl))

type
  Accessible* = ref object of atk.Object
  Accessible00* = object of atk.Object00

proc gtk_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Accessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_accessible_connect_widget_destroyed(self: ptr Accessible00) {.
    importc, libprag.}

proc connectWidgetDestroyed*(self: Accessible) =
  gtk_accessible_connect_widget_destroyed(cast[ptr Accessible00](self.impl))

proc gtk_accessible_get_widget(self: ptr Accessible00): ptr Widget00 {.
    importc, libprag.}

proc getWidget*(self: Accessible): Widget =
  let gobj = gtk_accessible_get_widget(cast[ptr Accessible00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc widget*(self: Accessible): Widget =
  let gobj = gtk_accessible_get_widget(cast[ptr Accessible00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_accessible_set_widget(self: ptr Accessible00; widget: ptr Widget00) {.
    importc, libprag.}

proc setWidget*(self: Accessible; widget: Widget = nil) =
  gtk_accessible_set_widget(cast[ptr Accessible00](self.impl), if widget.isNil: nil else: cast[ptr Widget00](widget.impl))

proc `widget=`*(self: Accessible; widget: Widget = nil) =
  gtk_accessible_set_widget(cast[ptr Accessible00](self.impl), if widget.isNil: nil else: cast[ptr Widget00](widget.impl))

type
  WidgetAccessible* = ref object of Accessible
  WidgetAccessible00* = object of Accessible00

proc gtk_widget_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(WidgetAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  ContainerAccessible* = ref object of WidgetAccessible
  ContainerAccessible00* = object of WidgetAccessible00

proc gtk_container_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ContainerAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  WindowAccessible* = ref object of ContainerAccessible
  WindowAccessible00* = object of ContainerAccessible00

proc gtk_window_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(WindowAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  PlugAccessible* = ref object of WindowAccessible
  PlugAccessible00* = object of WindowAccessible00

proc gtk_plug_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(PlugAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_plug_accessible_get_id(self: ptr PlugAccessible00): cstring {.
    importc, libprag.}

proc getId*(self: PlugAccessible): string =
  let resul0 = gtk_plug_accessible_get_id(cast[ptr PlugAccessible00](self.impl))
  result = $resul0
  cogfree(resul0)

proc id*(self: PlugAccessible): string =
  let resul0 = gtk_plug_accessible_get_id(cast[ptr PlugAccessible00](self.impl))
  result = $resul0
  cogfree(resul0)

type
  Window* = ref object of Bin
  Window00* = object of Bin00

proc gtk_window_get_type*(): GType {.importc, libprag.}

proc scActivateDefault*(self: Window | PlugAccessible | WindowAccessible;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "activate-default", cast[GCallback](p), xdata, nil, cf)

proc scActivateFocus*(self: Window | PlugAccessible | WindowAccessible;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "activate-focus", cast[GCallback](p), xdata, nil, cf)

proc scEnableDebugging*(self: Window | PlugAccessible | WindowAccessible;  p: proc (self: ptr Window00; toggle: gboolean; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "enable-debugging", cast[GCallback](p), xdata, nil, cf)

proc scKeysChanged*(self: Window | PlugAccessible | WindowAccessible;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "keys-changed", cast[GCallback](p), xdata, nil, cf)

proc scSetFocus*(self: Window | PlugAccessible | WindowAccessible;  p: proc (self: ptr Window00; widget: ptr Widget00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "set-focus", cast[GCallback](p), xdata, nil, cf)

proc gtk_window_get_default_icon_list(): ptr glib.List {.
    importc, libprag.}

proc getDefaultIconList*(): seq[gdkpixbuf.Pixbuf] =
  let resul0 = gtk_window_get_default_icon_list()
  result = glistObjects2seq(gdkpixbuf.Pixbuf, resul0, false)
  g_list_free(resul0)

proc gtk_window_get_default_icon_name(): cstring {.
    importc, libprag.}

proc getDefaultIconName*(): string =
  result = $gtk_window_get_default_icon_name()

proc gtk_window_list_toplevels(): ptr glib.List {.
    importc, libprag.}

proc listToplevels*(): seq[Widget] =
  let resul0 = gtk_window_list_toplevels()
  result = glistObjects2seq(Widget, resul0, false)
  g_list_free(resul0)

proc gtk_window_set_auto_startup_notification(setting: gboolean) {.
    importc, libprag.}

proc setAutoStartupNotification*(setting: bool = true) =
  gtk_window_set_auto_startup_notification(gboolean(setting))

proc gtk_window_set_default_icon(icon: ptr gdkpixbuf.Pixbuf00) {.
    importc, libprag.}

proc setDefaultIcon*(icon: gdkpixbuf.Pixbuf) =
  gtk_window_set_default_icon(cast[ptr gdkpixbuf.Pixbuf00](icon.impl))

proc gtk_window_set_default_icon_from_file(filename: cstring; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc setDefaultIconFromFile*(filename: cstring): bool =
  var gerror: ptr glib.Error
  let resul0 = gtk_window_set_default_icon_from_file(filename, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc setDefaultIconList*(list: ptr glib.List) {.
    importc: "gtk_window_set_default_icon_list", libprag.}

proc setDefaultIconName*(name: cstring) {.
    importc: "gtk_window_set_default_icon_name", libprag.}

proc gtk_window_set_interactive_debugging(enable: gboolean) {.
    importc, libprag.}

proc setInteractiveDebugging*(enable: bool = true) =
  gtk_window_set_interactive_debugging(gboolean(enable))

proc gtk_window_activate_default(self: ptr Window00): gboolean {.
    importc, libprag.}

proc activateDefault*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_activate_default(cast[ptr Window00](self.impl)))

proc gtk_window_activate_focus(self: ptr Window00): gboolean {.
    importc, libprag.}

proc activateFocus*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_activate_focus(cast[ptr Window00](self.impl)))

proc gtk_window_activate_key(self: ptr Window00; event: ptr gdk.EventKey00): gboolean {.
    importc, libprag.}

proc activateKey*(self: Window | PlugAccessible | WindowAccessible;
    event: gdk.EventKey): bool =
  toBool(gtk_window_activate_key(cast[ptr Window00](self.impl), cast[ptr gdk.EventKey00](event.impl)))

proc gtk_window_add_mnemonic(self: ptr Window00; keyval: uint32; target: ptr Widget00) {.
    importc, libprag.}

proc addMnemonic*(self: Window | PlugAccessible | WindowAccessible;
    keyval: int; target: Widget) =
  gtk_window_add_mnemonic(cast[ptr Window00](self.impl), uint32(keyval), cast[ptr Widget00](target.impl))

proc gtk_window_begin_move_drag(self: ptr Window00; button: int32; rootX: int32;
    rootY: int32; timestamp: uint32) {.
    importc, libprag.}

proc beginMoveDrag*(self: Window | PlugAccessible | WindowAccessible;
    button: int; rootX: int; rootY: int; timestamp: int) =
  gtk_window_begin_move_drag(cast[ptr Window00](self.impl), int32(button), int32(rootX), int32(rootY), uint32(timestamp))

proc gtk_window_begin_resize_drag(self: ptr Window00; edge: gdk.WindowEdge;
    button: int32; rootX: int32; rootY: int32; timestamp: uint32) {.
    importc, libprag.}

proc beginResizeDrag*(self: Window | PlugAccessible | WindowAccessible;
    edge: gdk.WindowEdge; button: int; rootX: int; rootY: int; timestamp: int) =
  gtk_window_begin_resize_drag(cast[ptr Window00](self.impl), edge, int32(button), int32(rootX), int32(rootY), uint32(timestamp))

proc gtk_window_close(self: ptr Window00) {.
    importc, libprag.}

proc close*(self: Window | PlugAccessible | WindowAccessible) =
  gtk_window_close(cast[ptr Window00](self.impl))

proc gtk_window_deiconify(self: ptr Window00) {.
    importc, libprag.}

proc deiconify*(self: Window | PlugAccessible | WindowAccessible) =
  gtk_window_deiconify(cast[ptr Window00](self.impl))

proc gtk_window_fullscreen(self: ptr Window00) {.
    importc, libprag.}

proc fullscreen*(self: Window | PlugAccessible | WindowAccessible) =
  gtk_window_fullscreen(cast[ptr Window00](self.impl))

proc gtk_window_fullscreen_on_monitor(self: ptr Window00; screen: ptr gdk.Screen00;
    monitor: int32) {.
    importc, libprag.}

proc fullscreenOnMonitor*(self: Window | PlugAccessible | WindowAccessible;
    screen: gdk.Screen; monitor: int) =
  gtk_window_fullscreen_on_monitor(cast[ptr Window00](self.impl), cast[ptr gdk.Screen00](screen.impl), int32(monitor))

proc gtk_window_get_accept_focus(self: ptr Window00): gboolean {.
    importc, libprag.}

proc getAcceptFocus*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_accept_focus(cast[ptr Window00](self.impl)))

proc acceptFocus*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_accept_focus(cast[ptr Window00](self.impl)))

proc gtk_window_get_attached_to(self: ptr Window00): ptr Widget00 {.
    importc, libprag.}

proc getAttachedTo*(self: Window | PlugAccessible | WindowAccessible): Widget =
  let gobj = gtk_window_get_attached_to(cast[ptr Window00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc attachedTo*(self: Window | PlugAccessible | WindowAccessible): Widget =
  let gobj = gtk_window_get_attached_to(cast[ptr Window00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_window_get_decorated(self: ptr Window00): gboolean {.
    importc, libprag.}

proc getDecorated*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_decorated(cast[ptr Window00](self.impl)))

proc decorated*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_decorated(cast[ptr Window00](self.impl)))

proc gtk_window_get_default_size(self: ptr Window00; width: var int32; height: var int32) {.
    importc, libprag.}

proc getDefaultSize*(self: Window | PlugAccessible | WindowAccessible;
    width: var int = cast[var int](nil); height: var int = cast[var int](nil)) =
  var width_00: int32
  var height_00: int32
  gtk_window_get_default_size(cast[ptr Window00](self.impl), width_00, height_00)
  if width.addr != nil:
    width = int(width_00)
  if height.addr != nil:
    height = int(height_00)

proc gtk_window_get_default_widget(self: ptr Window00): ptr Widget00 {.
    importc, libprag.}

proc getDefaultWidget*(self: Window | PlugAccessible | WindowAccessible): Widget =
  let gobj = gtk_window_get_default_widget(cast[ptr Window00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc defaultWidget*(self: Window | PlugAccessible | WindowAccessible): Widget =
  let gobj = gtk_window_get_default_widget(cast[ptr Window00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_window_get_deletable(self: ptr Window00): gboolean {.
    importc, libprag.}

proc getDeletable*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_deletable(cast[ptr Window00](self.impl)))

proc deletable*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_deletable(cast[ptr Window00](self.impl)))

proc gtk_window_get_destroy_with_parent(self: ptr Window00): gboolean {.
    importc, libprag.}

proc getDestroyWithParent*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_destroy_with_parent(cast[ptr Window00](self.impl)))

proc destroyWithParent*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_destroy_with_parent(cast[ptr Window00](self.impl)))

proc gtk_window_get_focus(self: ptr Window00): ptr Widget00 {.
    importc, libprag.}

proc getFocus*(self: Window | PlugAccessible | WindowAccessible): Widget =
  let gobj = gtk_window_get_focus(cast[ptr Window00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc focus*(self: Window | PlugAccessible | WindowAccessible): Widget =
  let gobj = gtk_window_get_focus(cast[ptr Window00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_window_get_focus_on_map(self: ptr Window00): gboolean {.
    importc, libprag.}

proc getFocusOnMap*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_focus_on_map(cast[ptr Window00](self.impl)))

proc focusOnMap*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_focus_on_map(cast[ptr Window00](self.impl)))

proc gtk_window_get_focus_visible(self: ptr Window00): gboolean {.
    importc, libprag.}

proc getFocusVisible*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_focus_visible(cast[ptr Window00](self.impl)))

proc focusVisible*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_focus_visible(cast[ptr Window00](self.impl)))

proc gtk_window_get_gravity(self: ptr Window00): gdk.Gravity {.
    importc, libprag.}

proc getGravity*(self: Window | PlugAccessible | WindowAccessible): gdk.Gravity =
  gtk_window_get_gravity(cast[ptr Window00](self.impl))

proc gravity*(self: Window | PlugAccessible | WindowAccessible): gdk.Gravity =
  gtk_window_get_gravity(cast[ptr Window00](self.impl))

proc gtk_window_get_has_resize_grip(self: ptr Window00): gboolean {.
    importc, libprag.}

proc getHasResizeGrip*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_has_resize_grip(cast[ptr Window00](self.impl)))

proc hasResizeGrip*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_has_resize_grip(cast[ptr Window00](self.impl)))

proc gtk_window_get_hide_titlebar_when_maximized(self: ptr Window00): gboolean {.
    importc, libprag.}

proc getHideTitlebarWhenMaximized*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_hide_titlebar_when_maximized(cast[ptr Window00](self.impl)))

proc hideTitlebarWhenMaximized*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_hide_titlebar_when_maximized(cast[ptr Window00](self.impl)))

proc gtk_window_get_icon(self: ptr Window00): ptr gdkpixbuf.Pixbuf00 {.
    importc, libprag.}

proc getIcon*(self: Window | PlugAccessible | WindowAccessible): gdkpixbuf.Pixbuf =
  let gobj = gtk_window_get_icon(cast[ptr Window00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdkpixbuf.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc icon*(self: Window | PlugAccessible | WindowAccessible): gdkpixbuf.Pixbuf =
  let gobj = gtk_window_get_icon(cast[ptr Window00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdkpixbuf.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_window_get_icon_list(self: ptr Window00): ptr glib.List {.
    importc, libprag.}

proc getIconList*(self: Window | PlugAccessible | WindowAccessible): seq[gdkpixbuf.Pixbuf] =
  let resul0 = gtk_window_get_icon_list(cast[ptr Window00](self.impl))
  result = glistObjects2seq(gdkpixbuf.Pixbuf, resul0, false)
  g_list_free(resul0)

proc iconList*(self: Window | PlugAccessible | WindowAccessible): seq[gdkpixbuf.Pixbuf] =
  let resul0 = gtk_window_get_icon_list(cast[ptr Window00](self.impl))
  result = glistObjects2seq(gdkpixbuf.Pixbuf, resul0, false)
  g_list_free(resul0)

proc gtk_window_get_icon_name(self: ptr Window00): cstring {.
    importc, libprag.}

proc getIconName*(self: Window | PlugAccessible | WindowAccessible): string =
  let resul0 = gtk_window_get_icon_name(cast[ptr Window00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc iconName*(self: Window | PlugAccessible | WindowAccessible): string =
  let resul0 = gtk_window_get_icon_name(cast[ptr Window00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc gtk_window_get_mnemonic_modifier(self: ptr Window00): gdk.ModifierType {.
    importc, libprag.}

proc getMnemonicModifier*(self: Window | PlugAccessible | WindowAccessible): gdk.ModifierType =
  gtk_window_get_mnemonic_modifier(cast[ptr Window00](self.impl))

proc mnemonicModifier*(self: Window | PlugAccessible | WindowAccessible): gdk.ModifierType =
  gtk_window_get_mnemonic_modifier(cast[ptr Window00](self.impl))

proc gtk_window_get_mnemonics_visible(self: ptr Window00): gboolean {.
    importc, libprag.}

proc getMnemonicsVisible*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_mnemonics_visible(cast[ptr Window00](self.impl)))

proc mnemonicsVisible*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_mnemonics_visible(cast[ptr Window00](self.impl)))

proc gtk_window_get_modal(self: ptr Window00): gboolean {.
    importc, libprag.}

proc getModal*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_modal(cast[ptr Window00](self.impl)))

proc modal*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_modal(cast[ptr Window00](self.impl)))

proc gtk_window_get_opacity(self: ptr Window00): cdouble {.
    importc, libprag.}

proc getOpacity*(self: Window | PlugAccessible | WindowAccessible): cdouble =
  gtk_window_get_opacity(cast[ptr Window00](self.impl))

proc opacity*(self: Window | PlugAccessible | WindowAccessible): cdouble =
  gtk_window_get_opacity(cast[ptr Window00](self.impl))

proc gtk_window_get_position(self: ptr Window00; rootX: var int32; rootY: var int32) {.
    importc, libprag.}

proc getPosition*(self: Window | PlugAccessible | WindowAccessible;
    rootX: var int = cast[var int](nil); rootY: var int = cast[var int](nil)) =
  var rootY_00: int32
  var rootX_00: int32
  gtk_window_get_position(cast[ptr Window00](self.impl), rootX_00, rootY_00)
  if rootY.addr != nil:
    rootY = int(rootY_00)
  if rootX.addr != nil:
    rootX = int(rootX_00)

proc gtk_window_get_resizable(self: ptr Window00): gboolean {.
    importc, libprag.}

proc getResizable*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_resizable(cast[ptr Window00](self.impl)))

proc resizable*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_resizable(cast[ptr Window00](self.impl)))

proc gtk_window_get_resize_grip_area(self: ptr Window00; rect: var gdk.Rectangle): gboolean {.
    importc, libprag.}

proc getResizeGripArea*(self: Window | PlugAccessible | WindowAccessible;
    rect: var gdk.Rectangle): bool =
  toBool(gtk_window_get_resize_grip_area(cast[ptr Window00](self.impl), rect))

proc gtk_window_get_role(self: ptr Window00): cstring {.
    importc, libprag.}

proc getRole*(self: Window | PlugAccessible | WindowAccessible): string =
  let resul0 = gtk_window_get_role(cast[ptr Window00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc role*(self: Window | PlugAccessible | WindowAccessible): string =
  let resul0 = gtk_window_get_role(cast[ptr Window00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc gtk_window_get_screen(self: ptr Window00): ptr gdk.Screen00 {.
    importc, libprag.}

proc getScreen*(self: Window | PlugAccessible | WindowAccessible): gdk.Screen =
  let gobj = gtk_window_get_screen(cast[ptr Window00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc screen*(self: Window | PlugAccessible | WindowAccessible): gdk.Screen =
  let gobj = gtk_window_get_screen(cast[ptr Window00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_window_get_size(self: ptr Window00; width: var int32; height: var int32) {.
    importc, libprag.}

proc getSize*(self: Window | PlugAccessible | WindowAccessible;
    width: var int; height: var int) =
  var width_00: int32
  var height_00: int32
  gtk_window_get_size(cast[ptr Window00](self.impl), width_00, height_00)
  if width.addr != nil:
    width = int(width_00)
  if height.addr != nil:
    height = int(height_00)

proc gtk_window_get_skip_pager_hint(self: ptr Window00): gboolean {.
    importc, libprag.}

proc getSkipPagerHint*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_skip_pager_hint(cast[ptr Window00](self.impl)))

proc skipPagerHint*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_skip_pager_hint(cast[ptr Window00](self.impl)))

proc gtk_window_get_skip_taskbar_hint(self: ptr Window00): gboolean {.
    importc, libprag.}

proc getSkipTaskbarHint*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_skip_taskbar_hint(cast[ptr Window00](self.impl)))

proc skipTaskbarHint*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_skip_taskbar_hint(cast[ptr Window00](self.impl)))

proc gtk_window_get_title(self: ptr Window00): cstring {.
    importc, libprag.}

proc getTitle*(self: Window | PlugAccessible | WindowAccessible): string =
  let resul0 = gtk_window_get_title(cast[ptr Window00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc title*(self: Window | PlugAccessible | WindowAccessible): string =
  let resul0 = gtk_window_get_title(cast[ptr Window00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc gtk_window_get_titlebar(self: ptr Window00): ptr Widget00 {.
    importc, libprag.}

proc getTitlebar*(self: Window | PlugAccessible | WindowAccessible): Widget =
  let gobj = gtk_window_get_titlebar(cast[ptr Window00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc titlebar*(self: Window | PlugAccessible | WindowAccessible): Widget =
  let gobj = gtk_window_get_titlebar(cast[ptr Window00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_window_get_transient_for(self: ptr Window00): ptr Window00 {.
    importc, libprag.}

proc getTransientFor*(self: Window | PlugAccessible | WindowAccessible): Window =
  let gobj = gtk_window_get_transient_for(cast[ptr Window00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc transientFor*(self: Window | PlugAccessible | WindowAccessible): Window =
  let gobj = gtk_window_get_transient_for(cast[ptr Window00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_window_get_type_hint(self: ptr Window00): gdk.WindowTypeHint {.
    importc, libprag.}

proc getTypeHint*(self: Window | PlugAccessible | WindowAccessible): gdk.WindowTypeHint =
  gtk_window_get_type_hint(cast[ptr Window00](self.impl))

proc typeHint*(self: Window | PlugAccessible | WindowAccessible): gdk.WindowTypeHint =
  gtk_window_get_type_hint(cast[ptr Window00](self.impl))

proc gtk_window_get_urgency_hint(self: ptr Window00): gboolean {.
    importc, libprag.}

proc getUrgencyHint*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_urgency_hint(cast[ptr Window00](self.impl)))

proc urgencyHint*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_get_urgency_hint(cast[ptr Window00](self.impl)))

proc gtk_window_has_group(self: ptr Window00): gboolean {.
    importc, libprag.}

proc hasGroup*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_has_group(cast[ptr Window00](self.impl)))

proc gtk_window_has_toplevel_focus(self: ptr Window00): gboolean {.
    importc, libprag.}

proc hasToplevelFocus*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_has_toplevel_focus(cast[ptr Window00](self.impl)))

proc gtk_window_iconify(self: ptr Window00) {.
    importc, libprag.}

proc iconify*(self: Window | PlugAccessible | WindowAccessible) =
  gtk_window_iconify(cast[ptr Window00](self.impl))

proc gtk_window_is_active(self: ptr Window00): gboolean {.
    importc, libprag.}

proc isActive*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_is_active(cast[ptr Window00](self.impl)))

proc gtk_window_is_maximized(self: ptr Window00): gboolean {.
    importc, libprag.}

proc isMaximized*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_is_maximized(cast[ptr Window00](self.impl)))

proc gtk_window_maximize(self: ptr Window00) {.
    importc, libprag.}

proc maximize*(self: Window | PlugAccessible | WindowAccessible) =
  gtk_window_maximize(cast[ptr Window00](self.impl))

proc gtk_window_mnemonic_activate(self: ptr Window00; keyval: uint32; modifier: gdk.ModifierType): gboolean {.
    importc, libprag.}

proc mnemonicActivate*(self: Window | PlugAccessible | WindowAccessible;
    keyval: int; modifier: gdk.ModifierType): bool =
  toBool(gtk_window_mnemonic_activate(cast[ptr Window00](self.impl), uint32(keyval), modifier))

proc gtk_window_move(self: ptr Window00; x: int32; y: int32) {.
    importc, libprag.}

proc move*(self: Window | PlugAccessible | WindowAccessible; x: int;
    y: int) =
  gtk_window_move(cast[ptr Window00](self.impl), int32(x), int32(y))

proc gtk_window_parse_geometry(self: ptr Window00; geometry: cstring): gboolean {.
    importc, libprag.}

proc parseGeometry*(self: Window | PlugAccessible | WindowAccessible;
    geometry: cstring): bool =
  toBool(gtk_window_parse_geometry(cast[ptr Window00](self.impl), geometry))

proc gtk_window_present(self: ptr Window00) {.
    importc, libprag.}

proc present*(self: Window | PlugAccessible | WindowAccessible) =
  gtk_window_present(cast[ptr Window00](self.impl))

proc gtk_window_present_with_time(self: ptr Window00; timestamp: uint32) {.
    importc, libprag.}

proc presentWithTime*(self: Window | PlugAccessible | WindowAccessible;
    timestamp: int) =
  gtk_window_present_with_time(cast[ptr Window00](self.impl), uint32(timestamp))

proc gtk_window_propagate_key_event(self: ptr Window00; event: ptr gdk.EventKey00): gboolean {.
    importc, libprag.}

proc propagateKeyEvent*(self: Window | PlugAccessible | WindowAccessible;
    event: gdk.EventKey): bool =
  toBool(gtk_window_propagate_key_event(cast[ptr Window00](self.impl), cast[ptr gdk.EventKey00](event.impl)))

proc gtk_window_remove_mnemonic(self: ptr Window00; keyval: uint32; target: ptr Widget00) {.
    importc, libprag.}

proc removeMnemonic*(self: Window | PlugAccessible | WindowAccessible;
    keyval: int; target: Widget) =
  gtk_window_remove_mnemonic(cast[ptr Window00](self.impl), uint32(keyval), cast[ptr Widget00](target.impl))

proc gtk_window_reshow_with_initial_size(self: ptr Window00) {.
    importc, libprag.}

proc reshowWithInitialSize*(self: Window | PlugAccessible | WindowAccessible) =
  gtk_window_reshow_with_initial_size(cast[ptr Window00](self.impl))

proc gtk_window_resize(self: ptr Window00; width: int32; height: int32) {.
    importc, libprag.}

proc resize*(self: Window | PlugAccessible | WindowAccessible;
    width: int; height: int) =
  gtk_window_resize(cast[ptr Window00](self.impl), int32(width), int32(height))

proc gtk_window_resize_grip_is_visible(self: ptr Window00): gboolean {.
    importc, libprag.}

proc resizeGripIsVisible*(self: Window | PlugAccessible | WindowAccessible): bool =
  toBool(gtk_window_resize_grip_is_visible(cast[ptr Window00](self.impl)))

proc gtk_window_resize_to_geometry(self: ptr Window00; width: int32; height: int32) {.
    importc, libprag.}

proc resizeToGeometry*(self: Window | PlugAccessible | WindowAccessible;
    width: int; height: int) =
  gtk_window_resize_to_geometry(cast[ptr Window00](self.impl), int32(width), int32(height))

proc gtk_window_set_accept_focus(self: ptr Window00; setting: gboolean) {.
    importc, libprag.}

proc setAcceptFocus*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool = true) =
  gtk_window_set_accept_focus(cast[ptr Window00](self.impl), gboolean(setting))

proc `acceptFocus=`*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool) =
  gtk_window_set_accept_focus(cast[ptr Window00](self.impl), gboolean(setting))

proc gtk_window_set_attached_to(self: ptr Window00; attachWidget: ptr Widget00) {.
    importc, libprag.}

proc setAttachedTo*(self: Window | PlugAccessible | WindowAccessible;
    attachWidget: Widget = nil) =
  gtk_window_set_attached_to(cast[ptr Window00](self.impl), if attachWidget.isNil: nil else: cast[ptr Widget00](attachWidget.impl))

proc `attachedTo=`*(self: Window | PlugAccessible | WindowAccessible;
    attachWidget: Widget = nil) =
  gtk_window_set_attached_to(cast[ptr Window00](self.impl), if attachWidget.isNil: nil else: cast[ptr Widget00](attachWidget.impl))

proc gtk_window_set_decorated(self: ptr Window00; setting: gboolean) {.
    importc, libprag.}

proc setDecorated*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool = true) =
  gtk_window_set_decorated(cast[ptr Window00](self.impl), gboolean(setting))

proc `decorated=`*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool) =
  gtk_window_set_decorated(cast[ptr Window00](self.impl), gboolean(setting))

proc gtk_window_set_default(self: ptr Window00; defaultWidget: ptr Widget00) {.
    importc, libprag.}

proc setDefault*(self: Window | PlugAccessible | WindowAccessible;
    defaultWidget: Widget = nil) =
  gtk_window_set_default(cast[ptr Window00](self.impl), if defaultWidget.isNil: nil else: cast[ptr Widget00](defaultWidget.impl))

proc `default=`*(self: Window | PlugAccessible | WindowAccessible;
    defaultWidget: Widget = nil) =
  gtk_window_set_default(cast[ptr Window00](self.impl), if defaultWidget.isNil: nil else: cast[ptr Widget00](defaultWidget.impl))

proc gtk_window_set_default_geometry(self: ptr Window00; width: int32; height: int32) {.
    importc, libprag.}

proc setDefaultGeometry*(self: Window | PlugAccessible | WindowAccessible;
    width: int; height: int) =
  gtk_window_set_default_geometry(cast[ptr Window00](self.impl), int32(width), int32(height))

proc gtk_window_set_default_size(self: ptr Window00; width: int32; height: int32) {.
    importc, libprag.}

proc setDefaultSize*(self: Window | PlugAccessible | WindowAccessible;
    width: int; height: int) =
  gtk_window_set_default_size(cast[ptr Window00](self.impl), int32(width), int32(height))

proc `defaultSize=`*(self: Window; dim: tuple[width: int; height: int]) =
  gtk_window_set_default_size(cast[ptr Window00](self.impl), int32(dim[0]), int32(dim[1]))

proc gtk_window_set_deletable(self: ptr Window00; setting: gboolean) {.
    importc, libprag.}

proc setDeletable*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool = true) =
  gtk_window_set_deletable(cast[ptr Window00](self.impl), gboolean(setting))

proc `deletable=`*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool) =
  gtk_window_set_deletable(cast[ptr Window00](self.impl), gboolean(setting))

proc gtk_window_set_destroy_with_parent(self: ptr Window00; setting: gboolean) {.
    importc, libprag.}

proc setDestroyWithParent*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool = true) =
  gtk_window_set_destroy_with_parent(cast[ptr Window00](self.impl), gboolean(setting))

proc `destroyWithParent=`*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool) =
  gtk_window_set_destroy_with_parent(cast[ptr Window00](self.impl), gboolean(setting))

proc gtk_window_set_focus(self: ptr Window00; focus: ptr Widget00) {.
    importc, libprag.}

proc setFocus*(self: Window | PlugAccessible | WindowAccessible;
    focus: Widget = nil) =
  gtk_window_set_focus(cast[ptr Window00](self.impl), if focus.isNil: nil else: cast[ptr Widget00](focus.impl))

proc `focus=`*(self: Window | PlugAccessible | WindowAccessible;
    focus: Widget = nil) =
  gtk_window_set_focus(cast[ptr Window00](self.impl), if focus.isNil: nil else: cast[ptr Widget00](focus.impl))

proc gtk_window_set_focus_on_map(self: ptr Window00; setting: gboolean) {.
    importc, libprag.}

proc setFocusOnMap*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool = true) =
  gtk_window_set_focus_on_map(cast[ptr Window00](self.impl), gboolean(setting))

proc `focusOnMap=`*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool) =
  gtk_window_set_focus_on_map(cast[ptr Window00](self.impl), gboolean(setting))

proc gtk_window_set_focus_visible(self: ptr Window00; setting: gboolean) {.
    importc, libprag.}

proc setFocusVisible*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool = true) =
  gtk_window_set_focus_visible(cast[ptr Window00](self.impl), gboolean(setting))

proc `focusVisible=`*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool) =
  gtk_window_set_focus_visible(cast[ptr Window00](self.impl), gboolean(setting))

proc gtk_window_set_geometry_hints(self: ptr Window00; geometryWidget: ptr Widget00;
    geometry: gdk.Geometry; geomMask: gdk.WindowHints) {.
    importc, libprag.}

proc setGeometryHints*(self: Window | PlugAccessible | WindowAccessible;
    geometryWidget: Widget = nil; geometry: gdk.Geometry = cast[var gdk.Geometry](nil);
    geomMask: gdk.WindowHints) =
  gtk_window_set_geometry_hints(cast[ptr Window00](self.impl), if geometryWidget.isNil: nil else: cast[ptr Widget00](geometryWidget.impl), geometry, geomMask)

proc gtk_window_set_gravity(self: ptr Window00; gravity: gdk.Gravity) {.
    importc, libprag.}

proc setGravity*(self: Window | PlugAccessible | WindowAccessible;
    gravity: gdk.Gravity) =
  gtk_window_set_gravity(cast[ptr Window00](self.impl), gravity)

proc `gravity=`*(self: Window | PlugAccessible | WindowAccessible;
    gravity: gdk.Gravity) =
  gtk_window_set_gravity(cast[ptr Window00](self.impl), gravity)

proc gtk_window_set_has_resize_grip(self: ptr Window00; value: gboolean) {.
    importc, libprag.}

proc setHasResizeGrip*(self: Window | PlugAccessible | WindowAccessible;
    value: bool = true) =
  gtk_window_set_has_resize_grip(cast[ptr Window00](self.impl), gboolean(value))

proc `hasResizeGrip=`*(self: Window | PlugAccessible | WindowAccessible;
    value: bool) =
  gtk_window_set_has_resize_grip(cast[ptr Window00](self.impl), gboolean(value))

proc gtk_window_set_has_user_ref_count(self: ptr Window00; setting: gboolean) {.
    importc, libprag.}

proc setHasUserRefCount*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool = true) =
  gtk_window_set_has_user_ref_count(cast[ptr Window00](self.impl), gboolean(setting))

proc `hasUserRefCount=`*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool) =
  gtk_window_set_has_user_ref_count(cast[ptr Window00](self.impl), gboolean(setting))

proc gtk_window_set_hide_titlebar_when_maximized(self: ptr Window00; setting: gboolean) {.
    importc, libprag.}

proc setHideTitlebarWhenMaximized*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool = true) =
  gtk_window_set_hide_titlebar_when_maximized(cast[ptr Window00](self.impl), gboolean(setting))

proc `hideTitlebarWhenMaximized=`*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool) =
  gtk_window_set_hide_titlebar_when_maximized(cast[ptr Window00](self.impl), gboolean(setting))

proc gtk_window_set_icon(self: ptr Window00; icon: ptr gdkpixbuf.Pixbuf00) {.
    importc, libprag.}

proc setIcon*(self: Window | PlugAccessible | WindowAccessible;
    icon: gdkpixbuf.Pixbuf = nil) =
  gtk_window_set_icon(cast[ptr Window00](self.impl), if icon.isNil: nil else: cast[ptr gdkpixbuf.Pixbuf00](icon.impl))

proc `icon=`*(self: Window | PlugAccessible | WindowAccessible;
    icon: gdkpixbuf.Pixbuf = nil) =
  gtk_window_set_icon(cast[ptr Window00](self.impl), if icon.isNil: nil else: cast[ptr gdkpixbuf.Pixbuf00](icon.impl))

proc gtk_window_set_icon_from_file(self: ptr Window00; filename: cstring;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc setIconFromFile*(self: Window | PlugAccessible | WindowAccessible;
    filename: cstring): bool =
  var gerror: ptr glib.Error
  let resul0 = gtk_window_set_icon_from_file(cast[ptr Window00](self.impl), filename, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc gtk_window_set_icon_list(self: ptr Window00; list: ptr glib.List) {.
    importc, libprag.}

proc setIconList*(self: Window | PlugAccessible | WindowAccessible;
    list: seq[gdkpixbuf.Pixbuf]) =
  var tempResGL = seq2GList(list)
  gtk_window_set_icon_list(cast[ptr Window00](self.impl), tempResGL)
  g_list_free(tempResGL)

proc `iconList=`*(self: Window | PlugAccessible | WindowAccessible;
    list: seq[gdkpixbuf.Pixbuf]) =
  var tempResGL = seq2GList(list)
  gtk_window_set_icon_list(cast[ptr Window00](self.impl), tempResGL)
  g_list_free(tempResGL)

proc gtk_window_set_icon_name(self: ptr Window00; name: cstring) {.
    importc, libprag.}

proc setIconName*(self: Window | PlugAccessible | WindowAccessible;
    name: cstring = nil) =
  gtk_window_set_icon_name(cast[ptr Window00](self.impl), name)

proc `iconName=`*(self: Window | PlugAccessible | WindowAccessible;
    name: cstring = nil) =
  gtk_window_set_icon_name(cast[ptr Window00](self.impl), name)

proc gtk_window_set_keep_above(self: ptr Window00; setting: gboolean) {.
    importc, libprag.}

proc setKeepAbove*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool = true) =
  gtk_window_set_keep_above(cast[ptr Window00](self.impl), gboolean(setting))

proc `keepAbove=`*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool) =
  gtk_window_set_keep_above(cast[ptr Window00](self.impl), gboolean(setting))

proc gtk_window_set_keep_below(self: ptr Window00; setting: gboolean) {.
    importc, libprag.}

proc setKeepBelow*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool = true) =
  gtk_window_set_keep_below(cast[ptr Window00](self.impl), gboolean(setting))

proc `keepBelow=`*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool) =
  gtk_window_set_keep_below(cast[ptr Window00](self.impl), gboolean(setting))

proc gtk_window_set_mnemonic_modifier(self: ptr Window00; modifier: gdk.ModifierType) {.
    importc, libprag.}

proc setMnemonicModifier*(self: Window | PlugAccessible | WindowAccessible;
    modifier: gdk.ModifierType) =
  gtk_window_set_mnemonic_modifier(cast[ptr Window00](self.impl), modifier)

proc `mnemonicModifier=`*(self: Window | PlugAccessible | WindowAccessible;
    modifier: gdk.ModifierType) =
  gtk_window_set_mnemonic_modifier(cast[ptr Window00](self.impl), modifier)

proc gtk_window_set_mnemonics_visible(self: ptr Window00; setting: gboolean) {.
    importc, libprag.}

proc setMnemonicsVisible*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool = true) =
  gtk_window_set_mnemonics_visible(cast[ptr Window00](self.impl), gboolean(setting))

proc `mnemonicsVisible=`*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool) =
  gtk_window_set_mnemonics_visible(cast[ptr Window00](self.impl), gboolean(setting))

proc gtk_window_set_modal(self: ptr Window00; modal: gboolean) {.
    importc, libprag.}

proc setModal*(self: Window | PlugAccessible | WindowAccessible;
    modal: bool = true) =
  gtk_window_set_modal(cast[ptr Window00](self.impl), gboolean(modal))

proc `modal=`*(self: Window | PlugAccessible | WindowAccessible;
    modal: bool) =
  gtk_window_set_modal(cast[ptr Window00](self.impl), gboolean(modal))

proc gtk_window_set_opacity(self: ptr Window00; opacity: cdouble) {.
    importc, libprag.}

proc setOpacity*(self: Window | PlugAccessible | WindowAccessible;
    opacity: cdouble) =
  gtk_window_set_opacity(cast[ptr Window00](self.impl), opacity)

proc `opacity=`*(self: Window | PlugAccessible | WindowAccessible;
    opacity: cdouble) =
  gtk_window_set_opacity(cast[ptr Window00](self.impl), opacity)

proc gtk_window_set_resizable(self: ptr Window00; resizable: gboolean) {.
    importc, libprag.}

proc setResizable*(self: Window | PlugAccessible | WindowAccessible;
    resizable: bool = true) =
  gtk_window_set_resizable(cast[ptr Window00](self.impl), gboolean(resizable))

proc `resizable=`*(self: Window | PlugAccessible | WindowAccessible;
    resizable: bool) =
  gtk_window_set_resizable(cast[ptr Window00](self.impl), gboolean(resizable))

proc gtk_window_set_role(self: ptr Window00; role: cstring) {.
    importc, libprag.}

proc setRole*(self: Window | PlugAccessible | WindowAccessible;
    role: cstring) =
  gtk_window_set_role(cast[ptr Window00](self.impl), role)

proc `role=`*(self: Window | PlugAccessible | WindowAccessible;
    role: cstring) =
  gtk_window_set_role(cast[ptr Window00](self.impl), role)

proc gtk_window_set_screen(self: ptr Window00; screen: ptr gdk.Screen00) {.
    importc, libprag.}

proc setScreen*(self: Window | PlugAccessible | WindowAccessible;
    screen: gdk.Screen) =
  gtk_window_set_screen(cast[ptr Window00](self.impl), cast[ptr gdk.Screen00](screen.impl))

proc `screen=`*(self: Window | PlugAccessible | WindowAccessible;
    screen: gdk.Screen) =
  gtk_window_set_screen(cast[ptr Window00](self.impl), cast[ptr gdk.Screen00](screen.impl))

proc gtk_window_set_skip_pager_hint(self: ptr Window00; setting: gboolean) {.
    importc, libprag.}

proc setSkipPagerHint*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool = true) =
  gtk_window_set_skip_pager_hint(cast[ptr Window00](self.impl), gboolean(setting))

proc `skipPagerHint=`*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool) =
  gtk_window_set_skip_pager_hint(cast[ptr Window00](self.impl), gboolean(setting))

proc gtk_window_set_skip_taskbar_hint(self: ptr Window00; setting: gboolean) {.
    importc, libprag.}

proc setSkipTaskbarHint*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool = true) =
  gtk_window_set_skip_taskbar_hint(cast[ptr Window00](self.impl), gboolean(setting))

proc `skipTaskbarHint=`*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool) =
  gtk_window_set_skip_taskbar_hint(cast[ptr Window00](self.impl), gboolean(setting))

proc gtk_window_set_startup_id(self: ptr Window00; startupId: cstring) {.
    importc, libprag.}

proc setStartupId*(self: Window | PlugAccessible | WindowAccessible;
    startupId: cstring) =
  gtk_window_set_startup_id(cast[ptr Window00](self.impl), startupId)

proc `startupId=`*(self: Window | PlugAccessible | WindowAccessible;
    startupId: cstring) =
  gtk_window_set_startup_id(cast[ptr Window00](self.impl), startupId)

proc gtk_window_set_title(self: ptr Window00; title: cstring) {.
    importc, libprag.}

proc setTitle*(self: Window | PlugAccessible | WindowAccessible;
    title: cstring) =
  gtk_window_set_title(cast[ptr Window00](self.impl), title)

proc `title=`*(self: Window | PlugAccessible | WindowAccessible;
    title: cstring) =
  gtk_window_set_title(cast[ptr Window00](self.impl), title)

proc gtk_window_set_titlebar(self: ptr Window00; titlebar: ptr Widget00) {.
    importc, libprag.}

proc setTitlebar*(self: Window | PlugAccessible | WindowAccessible;
    titlebar: Widget = nil) =
  gtk_window_set_titlebar(cast[ptr Window00](self.impl), if titlebar.isNil: nil else: cast[ptr Widget00](titlebar.impl))

proc `titlebar=`*(self: Window | PlugAccessible | WindowAccessible;
    titlebar: Widget = nil) =
  gtk_window_set_titlebar(cast[ptr Window00](self.impl), if titlebar.isNil: nil else: cast[ptr Widget00](titlebar.impl))

proc gtk_window_set_transient_for(self: ptr Window00; parent: ptr Window00) {.
    importc, libprag.}

proc setTransientFor*(self: Window | PlugAccessible | WindowAccessible;
    parent: Window = nil) =
  gtk_window_set_transient_for(cast[ptr Window00](self.impl), if parent.isNil: nil else: cast[ptr Window00](parent.impl))

proc `transientFor=`*(self: Window | PlugAccessible | WindowAccessible;
    parent: Window = nil) =
  gtk_window_set_transient_for(cast[ptr Window00](self.impl), if parent.isNil: nil else: cast[ptr Window00](parent.impl))

proc gtk_window_set_type_hint(self: ptr Window00; hint: gdk.WindowTypeHint) {.
    importc, libprag.}

proc setTypeHint*(self: Window | PlugAccessible | WindowAccessible;
    hint: gdk.WindowTypeHint) =
  gtk_window_set_type_hint(cast[ptr Window00](self.impl), hint)

proc `typeHint=`*(self: Window | PlugAccessible | WindowAccessible;
    hint: gdk.WindowTypeHint) =
  gtk_window_set_type_hint(cast[ptr Window00](self.impl), hint)

proc gtk_window_set_urgency_hint(self: ptr Window00; setting: gboolean) {.
    importc, libprag.}

proc setUrgencyHint*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool = true) =
  gtk_window_set_urgency_hint(cast[ptr Window00](self.impl), gboolean(setting))

proc `urgencyHint=`*(self: Window | PlugAccessible | WindowAccessible;
    setting: bool) =
  gtk_window_set_urgency_hint(cast[ptr Window00](self.impl), gboolean(setting))

proc gtk_window_set_wmclass(self: ptr Window00; wmclassName: cstring; wmclassClass: cstring) {.
    importc, libprag.}

proc setWmclass*(self: Window | PlugAccessible | WindowAccessible;
    wmclassName: cstring; wmclassClass: cstring) =
  gtk_window_set_wmclass(cast[ptr Window00](self.impl), wmclassName, wmclassClass)

proc gtk_window_stick(self: ptr Window00) {.
    importc, libprag.}

proc stick*(self: Window | PlugAccessible | WindowAccessible) =
  gtk_window_stick(cast[ptr Window00](self.impl))

proc gtk_window_unfullscreen(self: ptr Window00) {.
    importc, libprag.}

proc unfullscreen*(self: Window | PlugAccessible | WindowAccessible) =
  gtk_window_unfullscreen(cast[ptr Window00](self.impl))

proc gtk_window_unmaximize(self: ptr Window00) {.
    importc, libprag.}

proc unmaximize*(self: Window | PlugAccessible | WindowAccessible) =
  gtk_window_unmaximize(cast[ptr Window00](self.impl))

proc gtk_window_unstick(self: ptr Window00) {.
    importc, libprag.}

proc unstick*(self: Window | PlugAccessible | WindowAccessible) =
  gtk_window_unstick(cast[ptr Window00](self.impl))

type
  Dialog* = ref object of Window
  Dialog00* = object of Window00

proc gtk_dialog_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Dialog()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scClose*(self: Dialog;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "close", cast[GCallback](p), xdata, nil, cf)

proc scResponse*(self: Dialog;  p: proc (self: ptr Dialog00; responseId: int32; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "response", cast[GCallback](p), xdata, nil, cf)

proc gtk_dialog_new(): ptr Dialog00 {.
    importc, libprag.}

proc newDialog*(): Dialog =
  let gobj = gtk_dialog_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newDialog*(tdesc: typedesc): tdesc =
  assert(result is Dialog)
  let gobj = gtk_dialog_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initDialog*[T](result: var T) {.deprecated.} =
  assert(result is Dialog)
  let gobj = gtk_dialog_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_dialog_add_action_widget(self: ptr Dialog00; child: ptr Widget00;
    responseId: int32) {.
    importc, libprag.}

proc addActionWidget*(self: Dialog; child: Widget; responseId: int) =
  gtk_dialog_add_action_widget(cast[ptr Dialog00](self.impl), cast[ptr Widget00](child.impl), int32(responseId))

proc gtk_dialog_add_button(self: ptr Dialog00; buttonText: cstring; responseId: int32): ptr Widget00 {.
    importc, libprag.}

proc addButton*(self: Dialog; buttonText: cstring; responseId: int): Widget =
  let gobj = gtk_dialog_add_button(cast[ptr Dialog00](self.impl), buttonText, int32(responseId))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_dialog_get_response_for_widget(self: ptr Dialog00; widget: ptr Widget00): int32 {.
    importc, libprag.}

proc getResponseForWidget*(self: Dialog; widget: Widget): int =
  int(gtk_dialog_get_response_for_widget(cast[ptr Dialog00](self.impl), cast[ptr Widget00](widget.impl)))

proc gtk_dialog_get_widget_for_response(self: ptr Dialog00; responseId: int32): ptr Widget00 {.
    importc, libprag.}

proc getWidgetForResponse*(self: Dialog; responseId: int): Widget =
  let gobj = gtk_dialog_get_widget_for_response(cast[ptr Dialog00](self.impl), int32(responseId))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_dialog_response(self: ptr Dialog00; responseId: int32) {.
    importc, libprag.}

proc response*(self: Dialog; responseId: int) =
  gtk_dialog_response(cast[ptr Dialog00](self.impl), int32(responseId))

proc gtk_dialog_run(self: ptr Dialog00): int32 {.
    importc, libprag.}

proc run*(self: Dialog): int =
  int(gtk_dialog_run(cast[ptr Dialog00](self.impl)))

proc gtk_dialog_set_alternative_button_order_from_array(self: ptr Dialog00;
    nParams: int32; newOrder: ptr int32) {.
    importc, libprag.}

proc setAlternativeButtonOrderFromArray*(self: Dialog; newOrder: seq[int32]) =
  let nParams = int(newOrder.len)
  gtk_dialog_set_alternative_button_order_from_array(cast[ptr Dialog00](self.impl), int32(nParams), cast[ptr int32](unsafeaddr(newOrder[0])))

proc gtk_dialog_set_default_response(self: ptr Dialog00; responseId: int32) {.
    importc, libprag.}

proc setDefaultResponse*(self: Dialog; responseId: int) =
  gtk_dialog_set_default_response(cast[ptr Dialog00](self.impl), int32(responseId))

proc `defaultResponse=`*(self: Dialog; responseId: int) =
  gtk_dialog_set_default_response(cast[ptr Dialog00](self.impl), int32(responseId))

proc gtk_dialog_set_response_sensitive(self: ptr Dialog00; responseId: int32;
    setting: gboolean) {.
    importc, libprag.}

proc setResponseSensitive*(self: Dialog; responseId: int; setting: bool) =
  gtk_dialog_set_response_sensitive(cast[ptr Dialog00](self.impl), int32(responseId), gboolean(setting))

type
  AboutDialog* = ref object of Dialog
  AboutDialog00* = object of Dialog00

proc gtk_about_dialog_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(AboutDialog()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scActivateLink*(self: AboutDialog;  p: proc (self: ptr AboutDialog00; uri: cstring; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "activate-link", cast[GCallback](p), xdata, nil, cf)

proc gtk_about_dialog_new(): ptr AboutDialog00 {.
    importc, libprag.}

proc newAboutDialog*(): AboutDialog =
  let gobj = gtk_about_dialog_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newAboutDialog*(tdesc: typedesc): tdesc =
  assert(result is AboutDialog)
  let gobj = gtk_about_dialog_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initAboutDialog*[T](result: var T) {.deprecated.} =
  assert(result is AboutDialog)
  let gobj = gtk_about_dialog_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_about_dialog_add_credit_section(self: ptr AboutDialog00; sectionName: cstring;
    people: ptr cstring) {.
    importc, libprag.}

proc addCreditSection*(self: AboutDialog; sectionName: cstring;
    people: varargs[string, `$`]) =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  gtk_about_dialog_add_credit_section(cast[ptr AboutDialog00](self.impl), sectionName, seq2CstringArray(people, fs469n23))

proc gtk_about_dialog_get_artists(self: ptr AboutDialog00): ptr cstring {.
    importc, libprag.}

proc getArtists*(self: AboutDialog): seq[string] =
  cstringArrayToSeq(gtk_about_dialog_get_artists(cast[ptr AboutDialog00](self.impl)))

proc artists*(self: AboutDialog): seq[string] =
  cstringArrayToSeq(gtk_about_dialog_get_artists(cast[ptr AboutDialog00](self.impl)))

proc gtk_about_dialog_get_authors(self: ptr AboutDialog00): ptr cstring {.
    importc, libprag.}

proc getAuthors*(self: AboutDialog): seq[string] =
  cstringArrayToSeq(gtk_about_dialog_get_authors(cast[ptr AboutDialog00](self.impl)))

proc authors*(self: AboutDialog): seq[string] =
  cstringArrayToSeq(gtk_about_dialog_get_authors(cast[ptr AboutDialog00](self.impl)))

proc gtk_about_dialog_get_comments(self: ptr AboutDialog00): cstring {.
    importc, libprag.}

proc getComments*(self: AboutDialog): string =
  result = $gtk_about_dialog_get_comments(cast[ptr AboutDialog00](self.impl))

proc comments*(self: AboutDialog): string =
  result = $gtk_about_dialog_get_comments(cast[ptr AboutDialog00](self.impl))

proc gtk_about_dialog_get_copyright(self: ptr AboutDialog00): cstring {.
    importc, libprag.}

proc getCopyright*(self: AboutDialog): string =
  result = $gtk_about_dialog_get_copyright(cast[ptr AboutDialog00](self.impl))

proc copyright*(self: AboutDialog): string =
  result = $gtk_about_dialog_get_copyright(cast[ptr AboutDialog00](self.impl))

proc gtk_about_dialog_get_documenters(self: ptr AboutDialog00): ptr cstring {.
    importc, libprag.}

proc getDocumenters*(self: AboutDialog): seq[string] =
  cstringArrayToSeq(gtk_about_dialog_get_documenters(cast[ptr AboutDialog00](self.impl)))

proc documenters*(self: AboutDialog): seq[string] =
  cstringArrayToSeq(gtk_about_dialog_get_documenters(cast[ptr AboutDialog00](self.impl)))

proc gtk_about_dialog_get_license(self: ptr AboutDialog00): cstring {.
    importc, libprag.}

proc getLicense*(self: AboutDialog): string =
  result = $gtk_about_dialog_get_license(cast[ptr AboutDialog00](self.impl))

proc license*(self: AboutDialog): string =
  result = $gtk_about_dialog_get_license(cast[ptr AboutDialog00](self.impl))

proc gtk_about_dialog_get_logo(self: ptr AboutDialog00): ptr gdkpixbuf.Pixbuf00 {.
    importc, libprag.}

proc getLogo*(self: AboutDialog): gdkpixbuf.Pixbuf =
  let gobj = gtk_about_dialog_get_logo(cast[ptr AboutDialog00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdkpixbuf.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc logo*(self: AboutDialog): gdkpixbuf.Pixbuf =
  let gobj = gtk_about_dialog_get_logo(cast[ptr AboutDialog00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdkpixbuf.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_about_dialog_get_logo_icon_name(self: ptr AboutDialog00): cstring {.
    importc, libprag.}

proc getLogoIconName*(self: AboutDialog): string =
  result = $gtk_about_dialog_get_logo_icon_name(cast[ptr AboutDialog00](self.impl))

proc logoIconName*(self: AboutDialog): string =
  result = $gtk_about_dialog_get_logo_icon_name(cast[ptr AboutDialog00](self.impl))

proc gtk_about_dialog_get_program_name(self: ptr AboutDialog00): cstring {.
    importc, libprag.}

proc getProgramName*(self: AboutDialog): string =
  result = $gtk_about_dialog_get_program_name(cast[ptr AboutDialog00](self.impl))

proc programName*(self: AboutDialog): string =
  result = $gtk_about_dialog_get_program_name(cast[ptr AboutDialog00](self.impl))

proc gtk_about_dialog_get_translator_credits(self: ptr AboutDialog00): cstring {.
    importc, libprag.}

proc getTranslatorCredits*(self: AboutDialog): string =
  result = $gtk_about_dialog_get_translator_credits(cast[ptr AboutDialog00](self.impl))

proc translatorCredits*(self: AboutDialog): string =
  result = $gtk_about_dialog_get_translator_credits(cast[ptr AboutDialog00](self.impl))

proc gtk_about_dialog_get_version(self: ptr AboutDialog00): cstring {.
    importc, libprag.}

proc getVersion*(self: AboutDialog): string =
  result = $gtk_about_dialog_get_version(cast[ptr AboutDialog00](self.impl))

proc version*(self: AboutDialog): string =
  result = $gtk_about_dialog_get_version(cast[ptr AboutDialog00](self.impl))

proc gtk_about_dialog_get_website(self: ptr AboutDialog00): cstring {.
    importc, libprag.}

proc getWebsite*(self: AboutDialog): string =
  result = $gtk_about_dialog_get_website(cast[ptr AboutDialog00](self.impl))

proc website*(self: AboutDialog): string =
  result = $gtk_about_dialog_get_website(cast[ptr AboutDialog00](self.impl))

proc gtk_about_dialog_get_website_label(self: ptr AboutDialog00): cstring {.
    importc, libprag.}

proc getWebsiteLabel*(self: AboutDialog): string =
  result = $gtk_about_dialog_get_website_label(cast[ptr AboutDialog00](self.impl))

proc websiteLabel*(self: AboutDialog): string =
  result = $gtk_about_dialog_get_website_label(cast[ptr AboutDialog00](self.impl))

proc gtk_about_dialog_get_wrap_license(self: ptr AboutDialog00): gboolean {.
    importc, libprag.}

proc getWrapLicense*(self: AboutDialog): bool =
  toBool(gtk_about_dialog_get_wrap_license(cast[ptr AboutDialog00](self.impl)))

proc wrapLicense*(self: AboutDialog): bool =
  toBool(gtk_about_dialog_get_wrap_license(cast[ptr AboutDialog00](self.impl)))

proc gtk_about_dialog_set_artists(self: ptr AboutDialog00; artists: ptr cstring) {.
    importc, libprag.}

proc setArtists*(self: AboutDialog; artists: varargs[string, `$`]) =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  gtk_about_dialog_set_artists(cast[ptr AboutDialog00](self.impl), seq2CstringArray(artists, fs469n23))

proc `artists=`*(self: AboutDialog; artists: varargs[string, `$`]) =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  gtk_about_dialog_set_artists(cast[ptr AboutDialog00](self.impl), seq2CstringArray(artists, fs469n23))

proc gtk_about_dialog_set_authors(self: ptr AboutDialog00; authors: ptr cstring) {.
    importc, libprag.}

proc setAuthors*(self: AboutDialog; authors: varargs[string, `$`]) =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  gtk_about_dialog_set_authors(cast[ptr AboutDialog00](self.impl), seq2CstringArray(authors, fs469n23))

proc `authors=`*(self: AboutDialog; authors: varargs[string, `$`]) =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  gtk_about_dialog_set_authors(cast[ptr AboutDialog00](self.impl), seq2CstringArray(authors, fs469n23))

proc gtk_about_dialog_set_comments(self: ptr AboutDialog00; comments: cstring) {.
    importc, libprag.}

proc setComments*(self: AboutDialog; comments: cstring = nil) =
  gtk_about_dialog_set_comments(cast[ptr AboutDialog00](self.impl), comments)

proc `comments=`*(self: AboutDialog; comments: cstring = nil) =
  gtk_about_dialog_set_comments(cast[ptr AboutDialog00](self.impl), comments)

proc gtk_about_dialog_set_copyright(self: ptr AboutDialog00; copyright: cstring) {.
    importc, libprag.}

proc setCopyright*(self: AboutDialog; copyright: cstring = nil) =
  gtk_about_dialog_set_copyright(cast[ptr AboutDialog00](self.impl), copyright)

proc `copyright=`*(self: AboutDialog; copyright: cstring = nil) =
  gtk_about_dialog_set_copyright(cast[ptr AboutDialog00](self.impl), copyright)

proc gtk_about_dialog_set_documenters(self: ptr AboutDialog00; documenters: ptr cstring) {.
    importc, libprag.}

proc setDocumenters*(self: AboutDialog; documenters: varargs[string, `$`]) =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  gtk_about_dialog_set_documenters(cast[ptr AboutDialog00](self.impl), seq2CstringArray(documenters, fs469n23))

proc `documenters=`*(self: AboutDialog; documenters: varargs[string, `$`]) =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  gtk_about_dialog_set_documenters(cast[ptr AboutDialog00](self.impl), seq2CstringArray(documenters, fs469n23))

proc gtk_about_dialog_set_license(self: ptr AboutDialog00; license: cstring) {.
    importc, libprag.}

proc setLicense*(self: AboutDialog; license: cstring = nil) =
  gtk_about_dialog_set_license(cast[ptr AboutDialog00](self.impl), license)

proc `license=`*(self: AboutDialog; license: cstring = nil) =
  gtk_about_dialog_set_license(cast[ptr AboutDialog00](self.impl), license)

proc gtk_about_dialog_set_logo(self: ptr AboutDialog00; logo: ptr gdkpixbuf.Pixbuf00) {.
    importc, libprag.}

proc setLogo*(self: AboutDialog; logo: gdkpixbuf.Pixbuf = nil) =
  gtk_about_dialog_set_logo(cast[ptr AboutDialog00](self.impl), if logo.isNil: nil else: cast[ptr gdkpixbuf.Pixbuf00](logo.impl))

proc `logo=`*(self: AboutDialog; logo: gdkpixbuf.Pixbuf = nil) =
  gtk_about_dialog_set_logo(cast[ptr AboutDialog00](self.impl), if logo.isNil: nil else: cast[ptr gdkpixbuf.Pixbuf00](logo.impl))

proc gtk_about_dialog_set_logo_icon_name(self: ptr AboutDialog00; iconName: cstring) {.
    importc, libprag.}

proc setLogoIconName*(self: AboutDialog; iconName: cstring = nil) =
  gtk_about_dialog_set_logo_icon_name(cast[ptr AboutDialog00](self.impl), iconName)

proc `logoIconName=`*(self: AboutDialog; iconName: cstring = nil) =
  gtk_about_dialog_set_logo_icon_name(cast[ptr AboutDialog00](self.impl), iconName)

proc gtk_about_dialog_set_program_name(self: ptr AboutDialog00; name: cstring) {.
    importc, libprag.}

proc setProgramName*(self: AboutDialog; name: cstring) =
  gtk_about_dialog_set_program_name(cast[ptr AboutDialog00](self.impl), name)

proc `programName=`*(self: AboutDialog; name: cstring) =
  gtk_about_dialog_set_program_name(cast[ptr AboutDialog00](self.impl), name)

proc gtk_about_dialog_set_translator_credits(self: ptr AboutDialog00; translatorCredits: cstring) {.
    importc, libprag.}

proc setTranslatorCredits*(self: AboutDialog; translatorCredits: cstring = nil) =
  gtk_about_dialog_set_translator_credits(cast[ptr AboutDialog00](self.impl), translatorCredits)

proc `translatorCredits=`*(self: AboutDialog; translatorCredits: cstring = nil) =
  gtk_about_dialog_set_translator_credits(cast[ptr AboutDialog00](self.impl), translatorCredits)

proc gtk_about_dialog_set_version(self: ptr AboutDialog00; version: cstring) {.
    importc, libprag.}

proc setVersion*(self: AboutDialog; version: cstring = nil) =
  gtk_about_dialog_set_version(cast[ptr AboutDialog00](self.impl), version)

proc `version=`*(self: AboutDialog; version: cstring = nil) =
  gtk_about_dialog_set_version(cast[ptr AboutDialog00](self.impl), version)

proc gtk_about_dialog_set_website(self: ptr AboutDialog00; website: cstring) {.
    importc, libprag.}

proc setWebsite*(self: AboutDialog; website: cstring = nil) =
  gtk_about_dialog_set_website(cast[ptr AboutDialog00](self.impl), website)

proc `website=`*(self: AboutDialog; website: cstring = nil) =
  gtk_about_dialog_set_website(cast[ptr AboutDialog00](self.impl), website)

proc gtk_about_dialog_set_website_label(self: ptr AboutDialog00; websiteLabel: cstring) {.
    importc, libprag.}

proc setWebsiteLabel*(self: AboutDialog; websiteLabel: cstring) =
  gtk_about_dialog_set_website_label(cast[ptr AboutDialog00](self.impl), websiteLabel)

proc `websiteLabel=`*(self: AboutDialog; websiteLabel: cstring) =
  gtk_about_dialog_set_website_label(cast[ptr AboutDialog00](self.impl), websiteLabel)

proc gtk_about_dialog_set_wrap_license(self: ptr AboutDialog00; wrapLicense: gboolean) {.
    importc, libprag.}

proc setWrapLicense*(self: AboutDialog; wrapLicense: bool = true) =
  gtk_about_dialog_set_wrap_license(cast[ptr AboutDialog00](self.impl), gboolean(wrapLicense))

proc `wrapLicense=`*(self: AboutDialog; wrapLicense: bool) =
  gtk_about_dialog_set_wrap_license(cast[ptr AboutDialog00](self.impl), gboolean(wrapLicense))

proc gtk_widget_get_tooltip_window(self: ptr Widget00): ptr Window00 {.
    importc, libprag.}

proc getTooltipWindow*(self: Widget): Window =
  let gobj = gtk_widget_get_tooltip_window(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc tooltipWindow*(self: Widget): Window =
  let gobj = gtk_widget_get_tooltip_window(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_set_tooltip_window(self: ptr Widget00; customWindow: ptr Window00) {.
    importc, libprag.}

proc setTooltipWindow*(self: Widget; customWindow: Window = nil) =
  gtk_widget_set_tooltip_window(cast[ptr Widget00](self.impl), if customWindow.isNil: nil else: cast[ptr Window00](customWindow.impl))

proc `tooltipWindow=`*(self: Widget; customWindow: Window = nil) =
  gtk_widget_set_tooltip_window(cast[ptr Widget00](self.impl), if customWindow.isNil: nil else: cast[ptr Window00](customWindow.impl))

type
  WindowGroup* = ref object of gobject.Object
  WindowGroup00* = object of gobject.Object00

proc gtk_window_group_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(WindowGroup()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_window_group_new(): ptr WindowGroup00 {.
    importc, libprag.}

proc newWindowGroup*(): WindowGroup =
  let gobj = gtk_window_group_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newWindowGroup*(tdesc: typedesc): tdesc =
  assert(result is WindowGroup)
  let gobj = gtk_window_group_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initWindowGroup*[T](result: var T) {.deprecated.} =
  assert(result is WindowGroup)
  let gobj = gtk_window_group_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_window_group_add_window(self: ptr WindowGroup00; window: ptr Window00) {.
    importc, libprag.}

proc addWindow*(self: WindowGroup; window: Window) =
  gtk_window_group_add_window(cast[ptr WindowGroup00](self.impl), cast[ptr Window00](window.impl))

proc gtk_window_group_get_current_device_grab(self: ptr WindowGroup00; device: ptr gdk.Device00): ptr Widget00 {.
    importc, libprag.}

proc getCurrentDeviceGrab*(self: WindowGroup; device: gdk.Device): Widget =
  let gobj = gtk_window_group_get_current_device_grab(cast[ptr WindowGroup00](self.impl), cast[ptr gdk.Device00](device.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_window_group_get_current_grab(self: ptr WindowGroup00): ptr Widget00 {.
    importc, libprag.}

proc getCurrentGrab*(self: WindowGroup): Widget =
  let gobj = gtk_window_group_get_current_grab(cast[ptr WindowGroup00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc currentGrab*(self: WindowGroup): Widget =
  let gobj = gtk_window_group_get_current_grab(cast[ptr WindowGroup00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_window_group_list_windows(self: ptr WindowGroup00): ptr glib.List {.
    importc, libprag.}

proc listWindows*(self: WindowGroup): seq[Window] =
  let resul0 = gtk_window_group_list_windows(cast[ptr WindowGroup00](self.impl))
  result = glistObjects2seq(Window, resul0, false)
  g_list_free(resul0)

proc gtk_window_group_remove_window(self: ptr WindowGroup00; window: ptr Window00) {.
    importc, libprag.}

proc removeWindow*(self: WindowGroup; window: Window) =
  gtk_window_group_remove_window(cast[ptr WindowGroup00](self.impl), cast[ptr Window00](window.impl))

proc gtk_window_get_group(self: ptr Window00): ptr WindowGroup00 {.
    importc, libprag.}

proc getGroup*(self: Window | PlugAccessible | WindowAccessible): WindowGroup =
  let gobj = gtk_window_get_group(cast[ptr Window00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc group*(self: Window | PlugAccessible | WindowAccessible): WindowGroup =
  let gobj = gtk_window_get_group(cast[ptr Window00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  WindowType* {.size: sizeof(cint), pure.} = enum
    toplevel = 0
    popup = 1

proc gtk_window_new(`type`: WindowType): ptr Window00 {.
    importc, libprag.}

proc newWindow*(`type`: WindowType = WindowType.toplevel): Window =
  let gobj = gtk_window_new(`type`)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    GC_ref(result)
    result.ignoreFinalizer = true
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newWindow*(tdesc: typedesc; `type`: WindowType = WindowType.toplevel): tdesc =
  assert(result is Window)
  let gobj = gtk_window_new(`type`)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    GC_ref(result)
    result.ignoreFinalizer = true
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initWindow*[T](result: var T; `type`: WindowType = WindowType.toplevel) {.deprecated.} =
  assert(result is Window)
  let gobj = gtk_window_new(`type`)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    GC_ref(result)
    result.ignoreFinalizer = true
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_window_get_window_type(self: ptr Window00): WindowType {.
    importc, libprag.}

proc getWindowType*(self: Window | PlugAccessible | WindowAccessible): WindowType =
  gtk_window_get_window_type(cast[ptr Window00](self.impl))

proc windowType*(self: Window | PlugAccessible | WindowAccessible): WindowType =
  gtk_window_get_window_type(cast[ptr Window00](self.impl))

type
  Application* = ref object of gio.GApplication
  Application00* = object of gio.GApplication00

proc gtk_application_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Application()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scQueryEnd*(self: Application;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "query-end", cast[GCallback](p), xdata, nil, cf)

proc scWindowAdded*(self: Application;  p: proc (self: ptr Application00; window: ptr Window00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "window-added", cast[GCallback](p), xdata, nil, cf)

proc scWindowRemoved*(self: Application;  p: proc (self: ptr Application00; window: ptr Window00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "window-removed", cast[GCallback](p), xdata, nil, cf)

proc gtk_application_new(applicationId: cstring; flags: gio.ApplicationFlags): ptr Application00 {.
    importc, libprag.}

proc newApplication*(applicationId: cstring = nil; flags: gio.ApplicationFlags = {}): Application =
  let gobj = gtk_application_new(applicationId, flags)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newApplication*(tdesc: typedesc; applicationId: cstring = nil; flags: gio.ApplicationFlags = {}): tdesc =
  assert(result is Application)
  let gobj = gtk_application_new(applicationId, flags)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initApplication*[T](result: var T; applicationId: cstring = nil; flags: gio.ApplicationFlags = {}) {.deprecated.} =
  assert(result is Application)
  let gobj = gtk_application_new(applicationId, flags)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_application_add_accelerator(self: ptr Application00; accelerator: cstring;
    actionName: cstring; parameter: ptr glib.Variant00) {.
    importc, libprag.}

proc addAccelerator*(self: Application; accelerator: cstring;
    actionName: cstring; parameter: glib.Variant = nil) =
  gtk_application_add_accelerator(cast[ptr Application00](self.impl), accelerator, actionName, if parameter.isNil: nil else: cast[ptr glib.Variant00](parameter.impl))

proc gtk_application_add_window(self: ptr Application00; window: ptr Window00) {.
    importc, libprag.}

proc addWindow*(self: Application; window: Window) =
  gtk_application_add_window(cast[ptr Application00](self.impl), cast[ptr Window00](window.impl))

proc gtk_application_get_accels_for_action(self: ptr Application00; detailedActionName: cstring): ptr cstring {.
    importc, libprag.}

proc getAccelsForAction*(self: Application; detailedActionName: cstring): seq[string] =
  let resul0 = gtk_application_get_accels_for_action(cast[ptr Application00](self.impl), detailedActionName)
  if resul0.isNil:
    return
  result = cstringArrayToSeq(resul0)
  g_strfreev(resul0)

proc gtk_application_get_actions_for_accel(self: ptr Application00; accel: cstring): ptr cstring {.
    importc, libprag.}

proc getActionsForAccel*(self: Application; accel: cstring): seq[string] =
  let resul0 = gtk_application_get_actions_for_accel(cast[ptr Application00](self.impl), accel)
  if resul0.isNil:
    return
  result = cstringArrayToSeq(resul0)
  g_strfreev(resul0)

proc gtk_application_get_active_window(self: ptr Application00): ptr Window00 {.
    importc, libprag.}

proc getActiveWindow*(self: Application): Window =
  let gobj = gtk_application_get_active_window(cast[ptr Application00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc activeWindow*(self: Application): Window =
  let gobj = gtk_application_get_active_window(cast[ptr Application00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_application_get_app_menu(self: ptr Application00): ptr gio.MenuModel00 {.
    importc, libprag.}

proc getAppMenu*(self: Application): gio.MenuModel =
  let gobj = gtk_application_get_app_menu(cast[ptr Application00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc appMenu*(self: Application): gio.MenuModel =
  let gobj = gtk_application_get_app_menu(cast[ptr Application00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_application_get_menu_by_id(self: ptr Application00; id: cstring): ptr gio.Menu00 {.
    importc, libprag.}

proc getMenuById*(self: Application; id: cstring): gio.Menu =
  let gobj = gtk_application_get_menu_by_id(cast[ptr Application00](self.impl), id)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_application_get_menubar(self: ptr Application00): ptr gio.MenuModel00 {.
    importc, libprag.}

proc getMenubar*(self: Application): gio.MenuModel =
  let gobj = gtk_application_get_menubar(cast[ptr Application00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc menubar*(self: Application): gio.MenuModel =
  let gobj = gtk_application_get_menubar(cast[ptr Application00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_application_get_window_by_id(self: ptr Application00; id: uint32): ptr Window00 {.
    importc, libprag.}

proc getWindowById*(self: Application; id: int): Window =
  let gobj = gtk_application_get_window_by_id(cast[ptr Application00](self.impl), uint32(id))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_application_get_windows(self: ptr Application00): ptr glib.List {.
    importc, libprag.}

proc getWindows*(self: Application): seq[Window] =
  result = glistObjects2seq(Window, gtk_application_get_windows(cast[ptr Application00](self.impl)), false)

proc windows*(self: Application): seq[Window] =
  result = glistObjects2seq(Window, gtk_application_get_windows(cast[ptr Application00](self.impl)), false)

proc gtk_application_list_action_descriptions(self: ptr Application00): ptr cstring {.
    importc, libprag.}

proc listActionDescriptions*(self: Application): seq[string] =
  let resul0 = gtk_application_list_action_descriptions(cast[ptr Application00](self.impl))
  if resul0.isNil:
    return
  result = cstringArrayToSeq(resul0)
  g_strfreev(resul0)

proc gtk_application_prefers_app_menu(self: ptr Application00): gboolean {.
    importc, libprag.}

proc prefersAppMenu*(self: Application): bool =
  toBool(gtk_application_prefers_app_menu(cast[ptr Application00](self.impl)))

proc gtk_application_remove_accelerator(self: ptr Application00; actionName: cstring;
    parameter: ptr glib.Variant00) {.
    importc, libprag.}

proc removeAccelerator*(self: Application; actionName: cstring;
    parameter: glib.Variant = nil) =
  gtk_application_remove_accelerator(cast[ptr Application00](self.impl), actionName, if parameter.isNil: nil else: cast[ptr glib.Variant00](parameter.impl))

proc gtk_application_remove_window(self: ptr Application00; window: ptr Window00) {.
    importc, libprag.}

proc removeWindow*(self: Application; window: Window) =
  gtk_application_remove_window(cast[ptr Application00](self.impl), cast[ptr Window00](window.impl))

proc gtk_application_set_accels_for_action(self: ptr Application00; detailedActionName: cstring;
    accels: ptr cstring) {.
    importc, libprag.}

proc setAccelsForAction*(self: Application; detailedActionName: cstring;
    accels: varargs[string, `$`]) =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  gtk_application_set_accels_for_action(cast[ptr Application00](self.impl), detailedActionName, seq2CstringArray(accels, fs469n23))

proc gtk_application_set_app_menu(self: ptr Application00; appMenu: ptr gio.MenuModel00) {.
    importc, libprag.}

proc setAppMenu*(self: Application; appMenu: gio.MenuModel = nil) =
  gtk_application_set_app_menu(cast[ptr Application00](self.impl), if appMenu.isNil: nil else: cast[ptr gio.MenuModel00](appMenu.impl))

proc `appMenu=`*(self: Application; appMenu: gio.MenuModel = nil) =
  gtk_application_set_app_menu(cast[ptr Application00](self.impl), if appMenu.isNil: nil else: cast[ptr gio.MenuModel00](appMenu.impl))

proc gtk_application_set_menubar(self: ptr Application00; menubar: ptr gio.MenuModel00) {.
    importc, libprag.}

proc setMenubar*(self: Application; menubar: gio.MenuModel = nil) =
  gtk_application_set_menubar(cast[ptr Application00](self.impl), if menubar.isNil: nil else: cast[ptr gio.MenuModel00](menubar.impl))

proc `menubar=`*(self: Application; menubar: gio.MenuModel = nil) =
  gtk_application_set_menubar(cast[ptr Application00](self.impl), if menubar.isNil: nil else: cast[ptr gio.MenuModel00](menubar.impl))

proc gtk_application_uninhibit(self: ptr Application00; cookie: uint32) {.
    importc, libprag.}

proc uninhibit*(self: Application; cookie: int) =
  gtk_application_uninhibit(cast[ptr Application00](self.impl), uint32(cookie))

proc gtk_window_get_application(self: ptr Window00): ptr Application00 {.
    importc, libprag.}

proc getApplication*(self: Window | PlugAccessible | WindowAccessible): Application =
  let gobj = gtk_window_get_application(cast[ptr Window00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc application*(self: Window | PlugAccessible | WindowAccessible): Application =
  let gobj = gtk_window_get_application(cast[ptr Window00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_window_set_application(self: ptr Window00; application: ptr Application00) {.
    importc, libprag.}

proc setApplication*(self: Window | PlugAccessible | WindowAccessible;
    application: Application = nil) =
  gtk_window_set_application(cast[ptr Window00](self.impl), if application.isNil: nil else: cast[ptr Application00](application.impl))

proc `application=`*(self: Window | PlugAccessible | WindowAccessible;
    application: Application = nil) =
  gtk_window_set_application(cast[ptr Window00](self.impl), if application.isNil: nil else: cast[ptr Application00](application.impl))

type
  ApplicationInhibitFlag* {.size: sizeof(cint), pure.} = enum
    logout = 0
    switch = 1
    suspend = 2
    idle = 3

  ApplicationInhibitFlags* {.size: sizeof(cint).} = set[ApplicationInhibitFlag]

proc gtk_application_inhibit(self: ptr Application00; window: ptr Window00;
    flags: ApplicationInhibitFlags; reason: cstring): uint32 {.
    importc, libprag.}

proc inhibit*(self: Application; window: Window = nil; flags: ApplicationInhibitFlags;
    reason: cstring = nil): int =
  int(gtk_application_inhibit(cast[ptr Application00](self.impl), if window.isNil: nil else: cast[ptr Window00](window.impl), flags, reason))

proc gtk_application_is_inhibited(self: ptr Application00; flags: ApplicationInhibitFlags): gboolean {.
    importc, libprag.}

proc isInhibited*(self: Application; flags: ApplicationInhibitFlags): bool =
  toBool(gtk_application_is_inhibited(cast[ptr Application00](self.impl), flags))

type
  WindowPosition* {.size: sizeof(cint), pure.} = enum
    none = 0
    center = 1
    mouse = 2
    centerAlways = 3
    centerOnParent = 4

proc gtk_window_set_position(self: ptr Window00; position: WindowPosition) {.
    importc, libprag.}

proc setPosition*(self: Window | PlugAccessible | WindowAccessible;
    position: WindowPosition) =
  gtk_window_set_position(cast[ptr Window00](self.impl), position)

proc `position=`*(self: Window | PlugAccessible | WindowAccessible;
    position: WindowPosition) =
  gtk_window_set_position(cast[ptr Window00](self.impl), position)

type
  Box* = ref object of Container
  Box00* = object of Container00

proc gtk_box_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Box()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_box_get_center_widget(self: ptr Box00): ptr Widget00 {.
    importc, libprag.}

proc getCenterWidget*(self: Box): Widget =
  let gobj = gtk_box_get_center_widget(cast[ptr Box00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc centerWidget*(self: Box): Widget =
  let gobj = gtk_box_get_center_widget(cast[ptr Box00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_box_get_homogeneous(self: ptr Box00): gboolean {.
    importc, libprag.}

proc getHomogeneous*(self: Box): bool =
  toBool(gtk_box_get_homogeneous(cast[ptr Box00](self.impl)))

proc homogeneous*(self: Box): bool =
  toBool(gtk_box_get_homogeneous(cast[ptr Box00](self.impl)))

proc gtk_box_get_spacing(self: ptr Box00): int32 {.
    importc, libprag.}

proc getSpacing*(self: Box): int =
  int(gtk_box_get_spacing(cast[ptr Box00](self.impl)))

proc spacing*(self: Box): int =
  int(gtk_box_get_spacing(cast[ptr Box00](self.impl)))

proc gtk_box_pack_end(self: ptr Box00; child: ptr Widget00; expand: gboolean;
    fill: gboolean; padding: uint32) {.
    importc, libprag.}

proc packEnd*(self: Box; child: Widget; expand: bool; fill: bool;
    padding: int) =
  gtk_box_pack_end(cast[ptr Box00](self.impl), cast[ptr Widget00](child.impl), gboolean(expand), gboolean(fill), uint32(padding))

proc gtk_box_pack_start(self: ptr Box00; child: ptr Widget00; expand: gboolean;
    fill: gboolean; padding: uint32) {.
    importc, libprag.}

proc packStart*(self: Box; child: Widget; expand: bool; fill: bool;
    padding: int) =
  gtk_box_pack_start(cast[ptr Box00](self.impl), cast[ptr Widget00](child.impl), gboolean(expand), gboolean(fill), uint32(padding))

proc gtk_box_reorder_child(self: ptr Box00; child: ptr Widget00; position: int32) {.
    importc, libprag.}

proc reorderChild*(self: Box; child: Widget; position: int) =
  gtk_box_reorder_child(cast[ptr Box00](self.impl), cast[ptr Widget00](child.impl), int32(position))

proc gtk_box_set_center_widget(self: ptr Box00; widget: ptr Widget00) {.
    importc, libprag.}

proc setCenterWidget*(self: Box; widget: Widget = nil) =
  gtk_box_set_center_widget(cast[ptr Box00](self.impl), if widget.isNil: nil else: cast[ptr Widget00](widget.impl))

proc `centerWidget=`*(self: Box; widget: Widget = nil) =
  gtk_box_set_center_widget(cast[ptr Box00](self.impl), if widget.isNil: nil else: cast[ptr Widget00](widget.impl))

proc gtk_box_set_homogeneous(self: ptr Box00; homogeneous: gboolean) {.
    importc, libprag.}

proc setHomogeneous*(self: Box; homogeneous: bool = true) =
  gtk_box_set_homogeneous(cast[ptr Box00](self.impl), gboolean(homogeneous))

proc `homogeneous=`*(self: Box; homogeneous: bool) =
  gtk_box_set_homogeneous(cast[ptr Box00](self.impl), gboolean(homogeneous))

proc gtk_box_set_spacing(self: ptr Box00; spacing: int32) {.
    importc, libprag.}

proc setSpacing*(self: Box; spacing: int) =
  gtk_box_set_spacing(cast[ptr Box00](self.impl), int32(spacing))

proc `spacing=`*(self: Box; spacing: int) =
  gtk_box_set_spacing(cast[ptr Box00](self.impl), int32(spacing))

proc gtk_dialog_get_action_area(self: ptr Dialog00): ptr Box00 {.
    importc, libprag.}

proc getActionArea*(self: Dialog): Box =
  let gobj = gtk_dialog_get_action_area(cast[ptr Dialog00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc actionArea*(self: Dialog): Box =
  let gobj = gtk_dialog_get_action_area(cast[ptr Dialog00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_dialog_get_content_area(self: ptr Dialog00): ptr Box00 {.
    importc, libprag.}

proc getContentArea*(self: Dialog): Box =
  let gobj = gtk_dialog_get_content_area(cast[ptr Dialog00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc contentArea*(self: Dialog): Box =
  let gobj = gtk_dialog_get_content_area(cast[ptr Dialog00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  BaselinePosition* {.size: sizeof(cint), pure.} = enum
    top = 0
    center = 1
    bottom = 2

proc gtk_box_get_baseline_position(self: ptr Box00): BaselinePosition {.
    importc, libprag.}

proc getBaselinePosition*(self: Box): BaselinePosition =
  gtk_box_get_baseline_position(cast[ptr Box00](self.impl))

proc baselinePosition*(self: Box): BaselinePosition =
  gtk_box_get_baseline_position(cast[ptr Box00](self.impl))

proc gtk_box_set_baseline_position(self: ptr Box00; position: BaselinePosition) {.
    importc, libprag.}

proc setBaselinePosition*(self: Box; position: BaselinePosition) =
  gtk_box_set_baseline_position(cast[ptr Box00](self.impl), position)

proc `baselinePosition=`*(self: Box; position: BaselinePosition) =
  gtk_box_set_baseline_position(cast[ptr Box00](self.impl), position)

type
  PackType* {.size: sizeof(cint), pure.} = enum
    start = 0
    `end` = 1

proc gtk_box_query_child_packing(self: ptr Box00; child: ptr Widget00; expand: var gboolean;
    fill: var gboolean; padding: var uint32; packType: var PackType) {.
    importc, libprag.}

proc queryChildPacking*(self: Box; child: Widget; expand: var bool;
    fill: var bool; padding: var int; packType: var PackType) =
  var fill_00: gboolean
  var padding_00: uint32
  var expand_00: gboolean
  gtk_box_query_child_packing(cast[ptr Box00](self.impl), cast[ptr Widget00](child.impl), expand_00, fill_00, padding_00, packType)
  if fill.addr != nil:
    fill = toBool(fill_00)
  if padding.addr != nil:
    padding = int(padding_00)
  if expand.addr != nil:
    expand = toBool(expand_00)

proc gtk_box_set_child_packing(self: ptr Box00; child: ptr Widget00; expand: gboolean;
    fill: gboolean; padding: uint32; packType: PackType) {.
    importc, libprag.}

proc setChildPacking*(self: Box; child: Widget; expand: bool; fill: bool;
    padding: int; packType: PackType) =
  gtk_box_set_child_packing(cast[ptr Box00](self.impl), cast[ptr Widget00](child.impl), gboolean(expand), gboolean(fill), uint32(padding), packType)

type
  HeaderBar* = ref object of Container
  HeaderBar00* = object of Container00

proc gtk_header_bar_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(HeaderBar()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_header_bar_new(): ptr HeaderBar00 {.
    importc, libprag.}

proc newHeaderBar*(): HeaderBar =
  let gobj = gtk_header_bar_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newHeaderBar*(tdesc: typedesc): tdesc =
  assert(result is HeaderBar)
  let gobj = gtk_header_bar_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initHeaderBar*[T](result: var T) {.deprecated.} =
  assert(result is HeaderBar)
  let gobj = gtk_header_bar_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_header_bar_get_custom_title(self: ptr HeaderBar00): ptr Widget00 {.
    importc, libprag.}

proc getCustomTitle*(self: HeaderBar): Widget =
  let gobj = gtk_header_bar_get_custom_title(cast[ptr HeaderBar00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc customTitle*(self: HeaderBar): Widget =
  let gobj = gtk_header_bar_get_custom_title(cast[ptr HeaderBar00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_header_bar_get_decoration_layout(self: ptr HeaderBar00): cstring {.
    importc, libprag.}

proc getDecorationLayout*(self: HeaderBar): string =
  result = $gtk_header_bar_get_decoration_layout(cast[ptr HeaderBar00](self.impl))

proc decorationLayout*(self: HeaderBar): string =
  result = $gtk_header_bar_get_decoration_layout(cast[ptr HeaderBar00](self.impl))

proc gtk_header_bar_get_has_subtitle(self: ptr HeaderBar00): gboolean {.
    importc, libprag.}

proc getHasSubtitle*(self: HeaderBar): bool =
  toBool(gtk_header_bar_get_has_subtitle(cast[ptr HeaderBar00](self.impl)))

proc hasSubtitle*(self: HeaderBar): bool =
  toBool(gtk_header_bar_get_has_subtitle(cast[ptr HeaderBar00](self.impl)))

proc gtk_header_bar_get_show_close_button(self: ptr HeaderBar00): gboolean {.
    importc, libprag.}

proc getShowCloseButton*(self: HeaderBar): bool =
  toBool(gtk_header_bar_get_show_close_button(cast[ptr HeaderBar00](self.impl)))

proc showCloseButton*(self: HeaderBar): bool =
  toBool(gtk_header_bar_get_show_close_button(cast[ptr HeaderBar00](self.impl)))

proc gtk_header_bar_get_subtitle(self: ptr HeaderBar00): cstring {.
    importc, libprag.}

proc getSubtitle*(self: HeaderBar): string =
  let resul0 = gtk_header_bar_get_subtitle(cast[ptr HeaderBar00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc subtitle*(self: HeaderBar): string =
  let resul0 = gtk_header_bar_get_subtitle(cast[ptr HeaderBar00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc gtk_header_bar_get_title(self: ptr HeaderBar00): cstring {.
    importc, libprag.}

proc getTitle*(self: HeaderBar): string =
  let resul0 = gtk_header_bar_get_title(cast[ptr HeaderBar00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc title*(self: HeaderBar): string =
  let resul0 = gtk_header_bar_get_title(cast[ptr HeaderBar00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc gtk_header_bar_pack_end(self: ptr HeaderBar00; child: ptr Widget00) {.
    importc, libprag.}

proc packEnd*(self: HeaderBar; child: Widget) =
  gtk_header_bar_pack_end(cast[ptr HeaderBar00](self.impl), cast[ptr Widget00](child.impl))

proc gtk_header_bar_pack_start(self: ptr HeaderBar00; child: ptr Widget00) {.
    importc, libprag.}

proc packStart*(self: HeaderBar; child: Widget) =
  gtk_header_bar_pack_start(cast[ptr HeaderBar00](self.impl), cast[ptr Widget00](child.impl))

proc gtk_header_bar_set_custom_title(self: ptr HeaderBar00; titleWidget: ptr Widget00) {.
    importc, libprag.}

proc setCustomTitle*(self: HeaderBar; titleWidget: Widget = nil) =
  gtk_header_bar_set_custom_title(cast[ptr HeaderBar00](self.impl), if titleWidget.isNil: nil else: cast[ptr Widget00](titleWidget.impl))

proc `customTitle=`*(self: HeaderBar; titleWidget: Widget = nil) =
  gtk_header_bar_set_custom_title(cast[ptr HeaderBar00](self.impl), if titleWidget.isNil: nil else: cast[ptr Widget00](titleWidget.impl))

proc gtk_header_bar_set_decoration_layout(self: ptr HeaderBar00; layout: cstring) {.
    importc, libprag.}

proc setDecorationLayout*(self: HeaderBar; layout: cstring = nil) =
  gtk_header_bar_set_decoration_layout(cast[ptr HeaderBar00](self.impl), layout)

proc `decorationLayout=`*(self: HeaderBar; layout: cstring = nil) =
  gtk_header_bar_set_decoration_layout(cast[ptr HeaderBar00](self.impl), layout)

proc gtk_header_bar_set_has_subtitle(self: ptr HeaderBar00; setting: gboolean) {.
    importc, libprag.}

proc setHasSubtitle*(self: HeaderBar; setting: bool = true) =
  gtk_header_bar_set_has_subtitle(cast[ptr HeaderBar00](self.impl), gboolean(setting))

proc `hasSubtitle=`*(self: HeaderBar; setting: bool) =
  gtk_header_bar_set_has_subtitle(cast[ptr HeaderBar00](self.impl), gboolean(setting))

proc gtk_header_bar_set_show_close_button(self: ptr HeaderBar00; setting: gboolean) {.
    importc, libprag.}

proc setShowCloseButton*(self: HeaderBar; setting: bool = true) =
  gtk_header_bar_set_show_close_button(cast[ptr HeaderBar00](self.impl), gboolean(setting))

proc `showCloseButton=`*(self: HeaderBar; setting: bool) =
  gtk_header_bar_set_show_close_button(cast[ptr HeaderBar00](self.impl), gboolean(setting))

proc gtk_header_bar_set_subtitle(self: ptr HeaderBar00; subtitle: cstring) {.
    importc, libprag.}

proc setSubtitle*(self: HeaderBar; subtitle: cstring = nil) =
  gtk_header_bar_set_subtitle(cast[ptr HeaderBar00](self.impl), subtitle)

proc `subtitle=`*(self: HeaderBar; subtitle: cstring = nil) =
  gtk_header_bar_set_subtitle(cast[ptr HeaderBar00](self.impl), subtitle)

proc gtk_header_bar_set_title(self: ptr HeaderBar00; title: cstring) {.
    importc, libprag.}

proc setTitle*(self: HeaderBar; title: cstring = nil) =
  gtk_header_bar_set_title(cast[ptr HeaderBar00](self.impl), title)

proc `title=`*(self: HeaderBar; title: cstring = nil) =
  gtk_header_bar_set_title(cast[ptr HeaderBar00](self.impl), title)

proc gtk_dialog_get_header_bar(self: ptr Dialog00): ptr HeaderBar00 {.
    importc, libprag.}

proc getHeaderBar*(self: Dialog): HeaderBar =
  let gobj = gtk_dialog_get_header_bar(cast[ptr Dialog00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc headerBar*(self: Dialog): HeaderBar =
  let gobj = gtk_dialog_get_header_bar(cast[ptr Dialog00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  License* {.size: sizeof(cint), pure.} = enum
    unknown = 0
    custom = 1
    gpl_2_0 = 2
    gpl_3_0 = 3
    lgpl_2_1 = 4
    lgpl_3_0 = 5
    bsd = 6
    mitX11 = 7
    artistic = 8
    gpl_2_0Only = 9
    gpl_3_0Only = 10
    lgpl_2_1Only = 11
    lgpl_3_0Only = 12
    agpl_3_0 = 13
    agpl_3_0Only = 14
    bsd_3 = 15
    apache_2_0 = 16
    mpl_2_0 = 17

proc gtk_about_dialog_get_license_type(self: ptr AboutDialog00): License {.
    importc, libprag.}

proc getLicenseType*(self: AboutDialog): License =
  gtk_about_dialog_get_license_type(cast[ptr AboutDialog00](self.impl))

proc licenseType*(self: AboutDialog): License =
  gtk_about_dialog_get_license_type(cast[ptr AboutDialog00](self.impl))

proc gtk_about_dialog_set_license_type(self: ptr AboutDialog00; licenseType: License) {.
    importc, libprag.}

proc setLicenseType*(self: AboutDialog; licenseType: License) =
  gtk_about_dialog_set_license_type(cast[ptr AboutDialog00](self.impl), licenseType)

proc `licenseType=`*(self: AboutDialog; licenseType: License) =
  gtk_about_dialog_set_license_type(cast[ptr AboutDialog00](self.impl), licenseType)

type
  IconSet00* {.pure.} = object
  IconSet* = ref object
    impl*: ptr IconSet00
    ignoreFinalizer*: bool

proc gtk_icon_set_get_type*(): GType {.importc, libprag.}

proc gBoxedFreeGtkIconSet*(self: IconSet) =
  if not self.ignoreFinalizer:
    boxedFree(gtk_icon_set_get_type(), cast[ptr IconSet00](self.impl))

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(IconSet()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    if not self.ignoreFinalizer and self.impl != nil:
      boxedFree(gtk_icon_set_get_type(), cast[ptr IconSet00](self.impl))
      self.impl = nil

proc newWithFinalizer*(x: var IconSet) =
  when defined(gcDestructors):
    new(x)
  else:
    new(x, gBoxedFreeGtkIconSet)

proc gtk_icon_set_unref(self: ptr IconSet00) {.
    importc, libprag.}

proc unref*(self: IconSet) =
  gtk_icon_set_unref(cast[ptr IconSet00](self.impl))

proc finalizerunref*(self: IconSet) =
  if not self.ignoreFinalizer:
    gtk_icon_set_unref(cast[ptr IconSet00](self.impl))

proc gtk_icon_set_new_from_pixbuf(pixbuf: ptr gdkpixbuf.Pixbuf00): ptr IconSet00 {.
    importc, libprag.}

proc newIconSetFromPixbuf*(pixbuf: gdkpixbuf.Pixbuf): IconSet {.deprecated.}  =
  fnew(result, gBoxedFreeGtkIconSet)
  result.impl = gtk_icon_set_new_from_pixbuf(cast[ptr gdkpixbuf.Pixbuf00](pixbuf.impl))

proc newIconSetFromPixbuf*(tdesc: typedesc; pixbuf: gdkpixbuf.Pixbuf): tdesc {.deprecated.}  =
  assert(result is IconSet)
  fnew(result, gBoxedFreeGtkIconSet)
  result.impl = gtk_icon_set_new_from_pixbuf(cast[ptr gdkpixbuf.Pixbuf00](pixbuf.impl))

proc initIconSetFromPixbuf*[T](result: var T; pixbuf: gdkpixbuf.Pixbuf) {.deprecated.} =
  assert(result is IconSet)
  fnew(result, gBoxedFreeGtkIconSet)
  result.impl = gtk_icon_set_new_from_pixbuf(cast[ptr gdkpixbuf.Pixbuf00](pixbuf.impl))

proc gtk_icon_set_copy(self: ptr IconSet00): ptr IconSet00 {.
    importc, libprag.}

proc copy*(self: IconSet): IconSet =
  fnew(result, gBoxedFreeGtkIconSet)
  result.impl = gtk_icon_set_copy(cast[ptr IconSet00](self.impl))

proc gtk_icon_set_ref(self: ptr IconSet00): ptr IconSet00 {.
    importc, libprag.}

proc `ref`*(self: IconSet): IconSet =
  fnew(result, gBoxedFreeGtkIconSet)
  result.impl = gtk_icon_set_ref(cast[ptr IconSet00](self.impl))

proc gtk_icon_set_render_icon(self: ptr IconSet00; style: ptr Style00; direction: TextDirection;
    state: StateType; size: int32; widget: ptr Widget00; detail: cstring): ptr gdkpixbuf.Pixbuf00 {.
    importc, libprag.}

proc renderIcon*(self: IconSet; style: Style = nil; direction: TextDirection;
    state: StateType; size: int; widget: Widget = nil; detail: cstring = nil): gdkpixbuf.Pixbuf =
  let gobj = gtk_icon_set_render_icon(cast[ptr IconSet00](self.impl), if style.isNil: nil else: cast[ptr Style00](style.impl), direction, state, int32(size), if widget.isNil: nil else: cast[ptr Widget00](widget.impl), detail)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdkpixbuf.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_icon_set_new(): ptr IconSet00 {.
    importc, libprag.}

proc newIconSet*(): IconSet {.deprecated.}  =
  fnew(result, gBoxedFreeGtkIconSet)
  result.impl = gtk_icon_set_new()

proc newIconSet*(tdesc: typedesc): tdesc {.deprecated.}  =
  assert(result is IconSet)
  fnew(result, gBoxedFreeGtkIconSet)
  result.impl = gtk_icon_set_new()

proc initIconSet*[T](result: var T) {.deprecated.} =
  assert(result is IconSet)
  fnew(result, gBoxedFreeGtkIconSet)
  result.impl = gtk_icon_set_new()

proc gtk_style_lookup_icon_set(self: ptr Style00; stockId: cstring): ptr IconSet00 {.
    importc, libprag.}

proc lookupIconSet*(self: Style; stockId: cstring): IconSet =
  fnew(result, gBoxedFreeGtkIconSet)
  result.impl = gtk_style_lookup_icon_set(cast[ptr Style00](self.impl), stockId)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(gtk_icon_set_get_type(), result.impl))

type
  IconSource00* {.pure.} = object
  IconSource* = ref object
    impl*: ptr IconSource00
    ignoreFinalizer*: bool

proc gtk_icon_source_get_type*(): GType {.importc, libprag.}

proc gBoxedFreeGtkIconSource*(self: IconSource) =
  if not self.ignoreFinalizer:
    boxedFree(gtk_icon_source_get_type(), cast[ptr IconSource00](self.impl))

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(IconSource()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    if not self.ignoreFinalizer and self.impl != nil:
      boxedFree(gtk_icon_source_get_type(), cast[ptr IconSource00](self.impl))
      self.impl = nil

proc newWithFinalizer*(x: var IconSource) =
  when defined(gcDestructors):
    new(x)
  else:
    new(x, gBoxedFreeGtkIconSource)

proc gtk_icon_source_free(self: ptr IconSource00) {.
    importc, libprag.}

proc free*(self: IconSource) =
  gtk_icon_source_free(cast[ptr IconSource00](self.impl))

proc finalizerfree*(self: IconSource) =
  if not self.ignoreFinalizer:
    gtk_icon_source_free(cast[ptr IconSource00](self.impl))

proc gtk_icon_source_copy(self: ptr IconSource00): ptr IconSource00 {.
    importc, libprag.}

proc copy*(self: IconSource): IconSource =
  fnew(result, gBoxedFreeGtkIconSource)
  result.impl = gtk_icon_source_copy(cast[ptr IconSource00](self.impl))

proc gtk_icon_source_new(): ptr IconSource00 {.
    importc, libprag.}

proc newIconSource*(): IconSource {.deprecated.}  =
  fnew(result, gBoxedFreeGtkIconSource)
  result.impl = gtk_icon_source_new()

proc newIconSource*(tdesc: typedesc): tdesc {.deprecated.}  =
  assert(result is IconSource)
  fnew(result, gBoxedFreeGtkIconSource)
  result.impl = gtk_icon_source_new()

proc initIconSource*[T](result: var T) {.deprecated.} =
  assert(result is IconSource)
  fnew(result, gBoxedFreeGtkIconSource)
  result.impl = gtk_icon_source_new()

proc gtk_icon_source_get_direction(self: ptr IconSource00): TextDirection {.
    importc, libprag.}

proc getDirection*(self: IconSource): TextDirection =
  gtk_icon_source_get_direction(cast[ptr IconSource00](self.impl))

proc direction*(self: IconSource): TextDirection =
  gtk_icon_source_get_direction(cast[ptr IconSource00](self.impl))

proc gtk_icon_source_get_direction_wildcarded(self: ptr IconSource00): gboolean {.
    importc, libprag.}

proc getDirectionWildcarded*(self: IconSource): bool =
  toBool(gtk_icon_source_get_direction_wildcarded(cast[ptr IconSource00](self.impl)))

proc directionWildcarded*(self: IconSource): bool =
  toBool(gtk_icon_source_get_direction_wildcarded(cast[ptr IconSource00](self.impl)))

proc gtk_icon_source_get_filename(self: ptr IconSource00): cstring {.
    importc, libprag.}

proc getFilename*(self: IconSource): string =
  result = $gtk_icon_source_get_filename(cast[ptr IconSource00](self.impl))

proc filename*(self: IconSource): string =
  result = $gtk_icon_source_get_filename(cast[ptr IconSource00](self.impl))

proc gtk_icon_source_get_icon_name(self: ptr IconSource00): cstring {.
    importc, libprag.}

proc getIconName*(self: IconSource): string =
  result = $gtk_icon_source_get_icon_name(cast[ptr IconSource00](self.impl))

proc iconName*(self: IconSource): string =
  result = $gtk_icon_source_get_icon_name(cast[ptr IconSource00](self.impl))

proc gtk_icon_source_get_pixbuf(self: ptr IconSource00): ptr gdkpixbuf.Pixbuf00 {.
    importc, libprag.}

proc getPixbuf*(self: IconSource): gdkpixbuf.Pixbuf =
  let gobj = gtk_icon_source_get_pixbuf(cast[ptr IconSource00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdkpixbuf.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc pixbuf*(self: IconSource): gdkpixbuf.Pixbuf =
  let gobj = gtk_icon_source_get_pixbuf(cast[ptr IconSource00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdkpixbuf.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_icon_source_get_size(self: ptr IconSource00): int32 {.
    importc, libprag.}

proc getSize*(self: IconSource): int =
  int(gtk_icon_source_get_size(cast[ptr IconSource00](self.impl)))

proc size*(self: IconSource): int =
  int(gtk_icon_source_get_size(cast[ptr IconSource00](self.impl)))

proc gtk_icon_source_get_size_wildcarded(self: ptr IconSource00): gboolean {.
    importc, libprag.}

proc getSizeWildcarded*(self: IconSource): bool =
  toBool(gtk_icon_source_get_size_wildcarded(cast[ptr IconSource00](self.impl)))

proc sizeWildcarded*(self: IconSource): bool =
  toBool(gtk_icon_source_get_size_wildcarded(cast[ptr IconSource00](self.impl)))

proc gtk_icon_source_get_state(self: ptr IconSource00): StateType {.
    importc, libprag.}

proc getState*(self: IconSource): StateType =
  gtk_icon_source_get_state(cast[ptr IconSource00](self.impl))

proc state*(self: IconSource): StateType =
  gtk_icon_source_get_state(cast[ptr IconSource00](self.impl))

proc gtk_icon_source_get_state_wildcarded(self: ptr IconSource00): gboolean {.
    importc, libprag.}

proc getStateWildcarded*(self: IconSource): bool =
  toBool(gtk_icon_source_get_state_wildcarded(cast[ptr IconSource00](self.impl)))

proc stateWildcarded*(self: IconSource): bool =
  toBool(gtk_icon_source_get_state_wildcarded(cast[ptr IconSource00](self.impl)))

proc gtk_icon_source_set_direction(self: ptr IconSource00; direction: TextDirection) {.
    importc, libprag.}

proc setDirection*(self: IconSource; direction: TextDirection) =
  gtk_icon_source_set_direction(cast[ptr IconSource00](self.impl), direction)

proc `direction=`*(self: IconSource; direction: TextDirection) =
  gtk_icon_source_set_direction(cast[ptr IconSource00](self.impl), direction)

proc gtk_icon_source_set_direction_wildcarded(self: ptr IconSource00; setting: gboolean) {.
    importc, libprag.}

proc setDirectionWildcarded*(self: IconSource; setting: bool = true) =
  gtk_icon_source_set_direction_wildcarded(cast[ptr IconSource00](self.impl), gboolean(setting))

proc `directionWildcarded=`*(self: IconSource; setting: bool) =
  gtk_icon_source_set_direction_wildcarded(cast[ptr IconSource00](self.impl), gboolean(setting))

proc gtk_icon_source_set_filename(self: ptr IconSource00; filename: cstring) {.
    importc, libprag.}

proc setFilename*(self: IconSource; filename: cstring) =
  gtk_icon_source_set_filename(cast[ptr IconSource00](self.impl), filename)

proc `filename=`*(self: IconSource; filename: cstring) =
  gtk_icon_source_set_filename(cast[ptr IconSource00](self.impl), filename)

proc gtk_icon_source_set_icon_name(self: ptr IconSource00; iconName: cstring) {.
    importc, libprag.}

proc setIconName*(self: IconSource; iconName: cstring = nil) =
  gtk_icon_source_set_icon_name(cast[ptr IconSource00](self.impl), iconName)

proc `iconName=`*(self: IconSource; iconName: cstring = nil) =
  gtk_icon_source_set_icon_name(cast[ptr IconSource00](self.impl), iconName)

proc gtk_icon_source_set_pixbuf(self: ptr IconSource00; pixbuf: ptr gdkpixbuf.Pixbuf00) {.
    importc, libprag.}

proc setPixbuf*(self: IconSource; pixbuf: gdkpixbuf.Pixbuf) =
  gtk_icon_source_set_pixbuf(cast[ptr IconSource00](self.impl), cast[ptr gdkpixbuf.Pixbuf00](pixbuf.impl))

proc `pixbuf=`*(self: IconSource; pixbuf: gdkpixbuf.Pixbuf) =
  gtk_icon_source_set_pixbuf(cast[ptr IconSource00](self.impl), cast[ptr gdkpixbuf.Pixbuf00](pixbuf.impl))

proc gtk_icon_source_set_size(self: ptr IconSource00; size: int32) {.
    importc, libprag.}

proc setSize*(self: IconSource; size: int) =
  gtk_icon_source_set_size(cast[ptr IconSource00](self.impl), int32(size))

proc `size=`*(self: IconSource; size: int) =
  gtk_icon_source_set_size(cast[ptr IconSource00](self.impl), int32(size))

proc gtk_icon_source_set_size_wildcarded(self: ptr IconSource00; setting: gboolean) {.
    importc, libprag.}

proc setSizeWildcarded*(self: IconSource; setting: bool = true) =
  gtk_icon_source_set_size_wildcarded(cast[ptr IconSource00](self.impl), gboolean(setting))

proc `sizeWildcarded=`*(self: IconSource; setting: bool) =
  gtk_icon_source_set_size_wildcarded(cast[ptr IconSource00](self.impl), gboolean(setting))

proc gtk_icon_source_set_state(self: ptr IconSource00; state: StateType) {.
    importc, libprag.}

proc setState*(self: IconSource; state: StateType) =
  gtk_icon_source_set_state(cast[ptr IconSource00](self.impl), state)

proc `state=`*(self: IconSource; state: StateType) =
  gtk_icon_source_set_state(cast[ptr IconSource00](self.impl), state)

proc gtk_icon_source_set_state_wildcarded(self: ptr IconSource00; setting: gboolean) {.
    importc, libprag.}

proc setStateWildcarded*(self: IconSource; setting: bool = true) =
  gtk_icon_source_set_state_wildcarded(cast[ptr IconSource00](self.impl), gboolean(setting))

proc `stateWildcarded=`*(self: IconSource; setting: bool) =
  gtk_icon_source_set_state_wildcarded(cast[ptr IconSource00](self.impl), gboolean(setting))

proc gtk_style_render_icon(self: ptr Style00; source: ptr IconSource00; direction: TextDirection;
    state: StateType; size: int32; widget: ptr Widget00; detail: cstring): ptr gdkpixbuf.Pixbuf00 {.
    importc, libprag.}

proc renderIcon*(self: Style; source: IconSource; direction: TextDirection;
    state: StateType; size: int; widget: Widget = nil; detail: cstring = nil): gdkpixbuf.Pixbuf =
  let gobj = gtk_style_render_icon(cast[ptr Style00](self.impl), cast[ptr IconSource00](source.impl), direction, state, int32(size), if widget.isNil: nil else: cast[ptr Widget00](widget.impl), detail)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdkpixbuf.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_icon_set_add_source(self: ptr IconSet00; source: ptr IconSource00) {.
    importc, libprag.}

proc addSource*(self: IconSet; source: IconSource) =
  gtk_icon_set_add_source(cast[ptr IconSet00](self.impl), cast[ptr IconSource00](source.impl))

type
  Orientation* {.size: sizeof(cint), pure.} = enum
    horizontal = 0
    vertical = 1

proc gtk_widget_compute_expand(self: ptr Widget00; orientation: Orientation): gboolean {.
    importc, libprag.}

proc computeExpand*(self: Widget; orientation: Orientation): bool =
  toBool(gtk_widget_compute_expand(cast[ptr Widget00](self.impl), orientation))

proc gtk_box_new(orientation: Orientation; spacing: int32): ptr Box00 {.
    importc, libprag.}

proc newBox*(orientation: Orientation; spacing: int = 0): Box =
  let gobj = gtk_box_new(orientation, int32(spacing))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newBox*(tdesc: typedesc; orientation: Orientation; spacing: int = 0): tdesc =
  assert(result is Box)
  let gobj = gtk_box_new(orientation, int32(spacing))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initBox*[T](result: var T; orientation: Orientation; spacing: int = 0) {.deprecated.} =
  assert(result is Box)
  let gobj = gtk_box_new(orientation, int32(spacing))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  DestFlag* {.size: sizeof(cint), pure.} = enum
    motion = 0
    highlight = 1
    drop = 2

  DestDefaults* {.size: sizeof(cint).} = set[DestFlag]

type
  TargetEntry00* {.pure.} = object
    target*: cstring
    flags*: uint32
    info*: uint32
  TargetEntry* = ref object
    impl*: ptr TargetEntry00
    ignoreFinalizer*: bool

proc gtk_target_entry_get_type*(): GType {.importc, libprag.}

proc gBoxedFreeGtkTargetEntry*(self: TargetEntry) =
  if not self.ignoreFinalizer:
    boxedFree(gtk_target_entry_get_type(), cast[ptr TargetEntry00](self.impl))

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(TargetEntry()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    if not self.ignoreFinalizer and self.impl != nil:
      boxedFree(gtk_target_entry_get_type(), cast[ptr TargetEntry00](self.impl))
      self.impl = nil

proc newWithFinalizer*(x: var TargetEntry) =
  when defined(gcDestructors):
    new(x)
  else:
    new(x, gBoxedFreeGtkTargetEntry)

proc seq2TargetEntryArray(s: openarray[TargetEntry]; a: var cstringArray):  ptr TargetEntry00 =
  assert s.high < 256
  let x = cast[ptr UncheckedArray[ptr TargetEntry00]](a)
  for i, o in s:
    x[i] = o.impl
  return cast[ptr TargetEntry00](x)

proc newTargetEntry*(target: cstring; flags: int; info: int): TargetEntry

proc priv_target_table_free(targets: ptr TargetEntry00; nTargets: int32) {.importc: "gtk_target_table_free", libprag.}

proc targetEntryArrayToSeq(s: ptr TargetEntry00; n: int):  seq[TargetEntry] =
  let a = cast[ptr UncheckedArray[ptr TargetEntry00]](s)
  for i in 0 ..< n:
    result.add(newTargetEntry(a[i].target,  a[i].flags.int, a[i].info.int))
  priv_target_table_free(s, n.int32)



proc gtk_target_entry_free(self: ptr TargetEntry00) {.
    importc, libprag.}

proc free*(self: TargetEntry) =
  gtk_target_entry_free(cast[ptr TargetEntry00](self.impl))

proc finalizerfree*(self: TargetEntry) =
  if not self.ignoreFinalizer:
    gtk_target_entry_free(cast[ptr TargetEntry00](self.impl))

proc gtk_target_entry_copy(self: ptr TargetEntry00): ptr TargetEntry00 {.
    importc, libprag.}

proc copy*(self: TargetEntry): TargetEntry =
  fnew(result, gBoxedFreeGtkTargetEntry)
  result.impl = gtk_target_entry_copy(cast[ptr TargetEntry00](self.impl))

proc gtk_target_entry_new(target: cstring; flags: uint32; info: uint32): ptr TargetEntry00 {.
    importc, libprag.}

proc newTargetEntry*(target: cstring; flags: int; info: int): TargetEntry =
  fnew(result, gBoxedFreeGtkTargetEntry)
  result.impl = gtk_target_entry_new(target, uint32(flags), uint32(info))

proc newTargetEntry*(tdesc: typedesc; target: cstring; flags: int; info: int): tdesc =
  assert(result is TargetEntry)
  fnew(result, gBoxedFreeGtkTargetEntry)
  result.impl = gtk_target_entry_new(target, uint32(flags), uint32(info))

proc initTargetEntry*[T](result: var T; target: cstring; flags: int; info: int) {.deprecated.} =
  assert(result is TargetEntry)
  fnew(result, gBoxedFreeGtkTargetEntry)
  result.impl = gtk_target_entry_new(target, uint32(flags), uint32(info))

proc gtk_drag_dest_set(self: ptr Widget00; flags: DestDefaults; targets: ptr TargetEntry00;
    nTargets: int32; actions: gdk.DragAction) {.
    importc, libprag.}

proc dragDestSet*(self: Widget; flags: DestDefaults; targets: seq[TargetEntry];
    actions: gdk.DragAction) =
  let nTargets = int(targets.len)
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  gtk_drag_dest_set(cast[ptr Widget00](self.impl), flags, seq2TargetEntryArray(targets, fs469n23), int32(nTargets), actions)

proc gtk_drag_source_set(self: ptr Widget00; startButtonMask: gdk.ModifierType;
    targets: ptr TargetEntry00; nTargets: int32; actions: gdk.DragAction) {.
    importc, libprag.}

proc dragSourceSet*(self: Widget; startButtonMask: gdk.ModifierType;
    targets: seq[TargetEntry]; actions: gdk.DragAction) =
  let nTargets = int(targets.len)
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  gtk_drag_source_set(cast[ptr Widget00](self.impl), startButtonMask, seq2TargetEntryArray(targets, fs469n23), int32(nTargets), actions)

type
  TargetList00* {.pure.} = object
  TargetList* = ref object
    impl*: ptr TargetList00
    ignoreFinalizer*: bool

proc gtk_target_list_get_type*(): GType {.importc, libprag.}

proc gBoxedFreeGtkTargetList*(self: TargetList) =
  if not self.ignoreFinalizer:
    boxedFree(gtk_target_list_get_type(), cast[ptr TargetList00](self.impl))

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(TargetList()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    if not self.ignoreFinalizer and self.impl != nil:
      boxedFree(gtk_target_list_get_type(), cast[ptr TargetList00](self.impl))
      self.impl = nil

proc newWithFinalizer*(x: var TargetList) =
  when defined(gcDestructors):
    new(x)
  else:
    new(x, gBoxedFreeGtkTargetList)

proc gtk_target_list_unref(self: ptr TargetList00) {.
    importc, libprag.}

proc unref*(self: TargetList) =
  gtk_target_list_unref(cast[ptr TargetList00](self.impl))

proc finalizerunref*(self: TargetList) =
  if not self.ignoreFinalizer:
    gtk_target_list_unref(cast[ptr TargetList00](self.impl))

proc gtk_target_list_add(self: ptr TargetList00; target: ptr gdk.Atom00;
    flags: uint32; info: uint32) {.
    importc, libprag.}

proc add*(self: TargetList; target: gdk.Atom; flags: int;
    info: int) =
  gtk_target_list_add(cast[ptr TargetList00](self.impl), cast[ptr gdk.Atom00](target.impl), uint32(flags), uint32(info))

proc gtk_target_list_add_image_targets(self: ptr TargetList00; info: uint32;
    writable: gboolean) {.
    importc, libprag.}

proc addImageTargets*(self: TargetList; info: int; writable: bool) =
  gtk_target_list_add_image_targets(cast[ptr TargetList00](self.impl), uint32(info), gboolean(writable))

proc gtk_target_list_add_table(self: ptr TargetList00; targets: ptr TargetEntry00;
    ntargets: uint32) {.
    importc, libprag.}

proc addTable*(self: TargetList; targets: seq[TargetEntry]) =
  let ntargets = int(targets.len)
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  gtk_target_list_add_table(cast[ptr TargetList00](self.impl), seq2TargetEntryArray(targets, fs469n23), uint32(ntargets))

proc gtk_target_list_add_text_targets(self: ptr TargetList00; info: uint32) {.
    importc, libprag.}

proc addTextTargets*(self: TargetList; info: int) =
  gtk_target_list_add_text_targets(cast[ptr TargetList00](self.impl), uint32(info))

proc gtk_target_list_add_uri_targets(self: ptr TargetList00; info: uint32) {.
    importc, libprag.}

proc addUriTargets*(self: TargetList; info: int) =
  gtk_target_list_add_uri_targets(cast[ptr TargetList00](self.impl), uint32(info))

proc gtk_target_list_find(self: ptr TargetList00; target: ptr gdk.Atom00;
    info: var uint32): gboolean {.
    importc, libprag.}

proc findTargetList*(self: TargetList; target: gdk.Atom; info: var int = cast[var int](nil)): bool =
  var info_00: uint32
  result = toBool(gtk_target_list_find(cast[ptr TargetList00](self.impl), cast[ptr gdk.Atom00](target.impl), info_00))
  if info.addr != nil:
    info = int(info_00)

proc gtk_target_list_ref(self: ptr TargetList00): ptr TargetList00 {.
    importc, libprag.}

proc `ref`*(self: TargetList): TargetList =
  fnew(result, gBoxedFreeGtkTargetList)
  result.impl = gtk_target_list_ref(cast[ptr TargetList00](self.impl))

proc gtk_target_list_remove(self: ptr TargetList00; target: ptr gdk.Atom00) {.
    importc, libprag.}

proc remove*(self: TargetList; target: gdk.Atom) =
  gtk_target_list_remove(cast[ptr TargetList00](self.impl), cast[ptr gdk.Atom00](target.impl))

proc gtk_target_list_new(targets: ptr TargetEntry00; ntargets: uint32): ptr TargetList00 {.
    importc, libprag.}

proc newTargetList*(targets: seq[TargetEntry]): TargetList =
  let ntargets = int(targets.len)
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  fnew(result, gBoxedFreeGtkTargetList)
  result.impl = gtk_target_list_new(seq2TargetEntryArray(targets, fs469n23), uint32(ntargets))

proc newTargetList*(tdesc: typedesc; targets: seq[TargetEntry]): tdesc =
  let ntargets = int(targets.len)
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  assert(result is TargetList)
  fnew(result, gBoxedFreeGtkTargetList)
  result.impl = gtk_target_list_new(seq2TargetEntryArray(targets, fs469n23), uint32(ntargets))

proc initTargetList*[T](result: var T; targets: seq[TargetEntry]) {.deprecated.} =
  let ntargets = int(targets.len)
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  assert(result is TargetList)
  fnew(result, gBoxedFreeGtkTargetList)
  result.impl = gtk_target_list_new(seq2TargetEntryArray(targets, fs469n23), uint32(ntargets))

proc gtk_drag_begin(self: ptr Widget00; targets: ptr TargetList00; actions: gdk.DragAction;
    button: int32; event: ptr gdk.Event00): ptr gdk.DragContext00 {.
    importc, libprag.}

proc dragBegin*(self: Widget; targets: TargetList; actions: gdk.DragAction;
    button: int; event: gdk.Event = nil): gdk.DragContext =
  let gobj = gtk_drag_begin(cast[ptr Widget00](self.impl), cast[ptr TargetList00](targets.impl), actions, int32(button), if event.isNil: nil else: cast[ptr gdk.Event00](event.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_drag_begin_with_coordinates(self: ptr Widget00; targets: ptr TargetList00;
    actions: gdk.DragAction; button: int32; event: ptr gdk.Event00; x: int32;
    y: int32): ptr gdk.DragContext00 {.
    importc, libprag.}

proc dragBeginWithCoordinates*(self: Widget; targets: TargetList; actions: gdk.DragAction;
    button: int; event: gdk.Event = nil; x: int; y: int): gdk.DragContext =
  let gobj = gtk_drag_begin_with_coordinates(cast[ptr Widget00](self.impl), cast[ptr TargetList00](targets.impl), actions, int32(button), if event.isNil: nil else: cast[ptr gdk.Event00](event.impl), int32(x), int32(y))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_drag_dest_find_target(self: ptr Widget00; context: ptr gdk.DragContext00;
    targetList: ptr TargetList00): ptr gdk.Atom00 {.
    importc, libprag.}

proc dragDestFindTarget*(self: Widget; context: gdk.DragContext; targetList: TargetList = nil): gdk.Atom =
  new(result)
  result.impl = gtk_drag_dest_find_target(cast[ptr Widget00](self.impl), cast[ptr gdk.DragContext00](context.impl), if targetList.isNil: nil else: cast[ptr TargetList00](targetList.impl))
  result.ignoreFinalizer = true

proc gtk_drag_dest_get_target_list(self: ptr Widget00): ptr TargetList00 {.
    importc, libprag.}

proc dragDestGetTargetList*(self: Widget): TargetList =
  let impl0 = gtk_drag_dest_get_target_list(cast[ptr Widget00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreeGtkTargetList)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(gtk_target_list_get_type(), impl0))

proc gtk_drag_dest_set_target_list(self: ptr Widget00; targetList: ptr TargetList00) {.
    importc, libprag.}

proc dragDestSetTargetList*(self: Widget; targetList: TargetList = nil) =
  gtk_drag_dest_set_target_list(cast[ptr Widget00](self.impl), if targetList.isNil: nil else: cast[ptr TargetList00](targetList.impl))

proc gtk_drag_source_get_target_list(self: ptr Widget00): ptr TargetList00 {.
    importc, libprag.}

proc dragSourceGetTargetList*(self: Widget): TargetList =
  let impl0 = gtk_drag_source_get_target_list(cast[ptr Widget00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreeGtkTargetList)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(gtk_target_list_get_type(), impl0))

proc gtk_drag_source_set_target_list(self: ptr Widget00; targetList: ptr TargetList00) {.
    importc, libprag.}

proc dragSourceSetTargetList*(self: Widget; targetList: TargetList = nil) =
  gtk_drag_source_set_target_list(cast[ptr Widget00](self.impl), if targetList.isNil: nil else: cast[ptr TargetList00](targetList.impl))

type
  Clipboard* = ref object of gobject.Object
  Clipboard00* = object of gobject.Object00

proc gtk_clipboard_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Clipboard()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scOwnerChange*(self: Clipboard;  p: proc (self: ptr Clipboard00; event: ptr gdk.EventOwnerChange00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "owner-change", cast[GCallback](p), xdata, nil, cf)

proc gtk_clipboard_get(selection: ptr gdk.Atom00): ptr Clipboard00 {.
    importc, libprag.}

proc getClipboard*(selection: gdk.Atom): Clipboard =
  let gobj = gtk_clipboard_get(cast[ptr gdk.Atom00](selection.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc clipboard*(selection: gdk.Atom): Clipboard =
  let gobj = gtk_clipboard_get(cast[ptr gdk.Atom00](selection.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_clipboard_get_default(display: ptr gdk.Display00): ptr Clipboard00 {.
    importc, libprag.}

proc getDefaultClipboard*(display: gdk.Display): Clipboard =
  let gobj = gtk_clipboard_get_default(cast[ptr gdk.Display00](display.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc defaultClipboard*(display: gdk.Display): Clipboard =
  let gobj = gtk_clipboard_get_default(cast[ptr gdk.Display00](display.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_clipboard_get_for_display(display: ptr gdk.Display00; selection: ptr gdk.Atom00): ptr Clipboard00 {.
    importc, libprag.}

proc getForDisplay*(display: gdk.Display; selection: gdk.Atom): Clipboard =
  let gobj = gtk_clipboard_get_for_display(cast[ptr gdk.Display00](display.impl), cast[ptr gdk.Atom00](selection.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_clipboard_clear(self: ptr Clipboard00) {.
    importc, libprag.}

proc clear*(self: Clipboard) =
  gtk_clipboard_clear(cast[ptr Clipboard00](self.impl))

proc gtk_clipboard_get_display(self: ptr Clipboard00): ptr gdk.Display00 {.
    importc, libprag.}

proc getDisplay*(self: Clipboard): gdk.Display =
  let gobj = gtk_clipboard_get_display(cast[ptr Clipboard00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc display*(self: Clipboard): gdk.Display =
  let gobj = gtk_clipboard_get_display(cast[ptr Clipboard00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_clipboard_get_owner(self: ptr Clipboard00): ptr gobject.Object00 {.
    importc, libprag.}

proc getOwner*(self: Clipboard): gobject.Object =
  let gobj = gtk_clipboard_get_owner(cast[ptr Clipboard00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gobject.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc owner*(self: Clipboard): gobject.Object =
  let gobj = gtk_clipboard_get_owner(cast[ptr Clipboard00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gobject.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_clipboard_set_can_store(self: ptr Clipboard00; targets: ptr TargetEntry00;
    nTargets: int32) {.
    importc, libprag.}

proc setCanStore*(self: Clipboard; targets: seq[TargetEntry]) =
  let nTargets = int(targets.len)
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  gtk_clipboard_set_can_store(cast[ptr Clipboard00](self.impl), seq2TargetEntryArray(targets, fs469n23), int32(nTargets))

proc gtk_clipboard_set_image(self: ptr Clipboard00; pixbuf: ptr gdkpixbuf.Pixbuf00) {.
    importc, libprag.}

proc setImage*(self: Clipboard; pixbuf: gdkpixbuf.Pixbuf) =
  gtk_clipboard_set_image(cast[ptr Clipboard00](self.impl), cast[ptr gdkpixbuf.Pixbuf00](pixbuf.impl))

proc `image=`*(self: Clipboard; pixbuf: gdkpixbuf.Pixbuf) =
  gtk_clipboard_set_image(cast[ptr Clipboard00](self.impl), cast[ptr gdkpixbuf.Pixbuf00](pixbuf.impl))

proc gtk_clipboard_set_text(self: ptr Clipboard00; text: cstring; len: int32) {.
    importc, libprag.}

proc setText*(self: Clipboard; text: cstring; len: int) =
  gtk_clipboard_set_text(cast[ptr Clipboard00](self.impl), text, int32(len))

proc gtk_clipboard_store(self: ptr Clipboard00) {.
    importc, libprag.}

proc store*(self: Clipboard) =
  gtk_clipboard_store(cast[ptr Clipboard00](self.impl))

proc gtk_clipboard_wait_for_contents(self: ptr Clipboard00; target: ptr gdk.Atom00): ptr SelectionData00 {.
    importc, libprag.}

proc waitForContents*(self: Clipboard; target: gdk.Atom): SelectionData =
  let impl0 = gtk_clipboard_wait_for_contents(cast[ptr Clipboard00](self.impl), cast[ptr gdk.Atom00](target.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreeGtkSelectionData)
  result.impl = impl0

proc gtk_clipboard_wait_for_image(self: ptr Clipboard00): ptr gdkpixbuf.Pixbuf00 {.
    importc, libprag.}

proc waitForImage*(self: Clipboard): gdkpixbuf.Pixbuf =
  let gobj = gtk_clipboard_wait_for_image(cast[ptr Clipboard00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdkpixbuf.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_clipboard_wait_for_targets(self: ptr Clipboard00; targets: var ptr ptr gdk.Atom00;
    nTargets: var int32): gboolean {.
    importc, libprag.}

proc waitForTargets*(self: Clipboard; targets: var ptr ptr gdk.Atom00;
    nTargets: var int): bool =
  var nTargets_00: int32
  result = toBool(gtk_clipboard_wait_for_targets(cast[ptr Clipboard00](self.impl), targets, nTargets_00))
  if nTargets.addr != nil:
    nTargets = int(nTargets_00)

proc gtk_clipboard_wait_for_text(self: ptr Clipboard00): cstring {.
    importc, libprag.}

proc waitForText*(self: Clipboard): string =
  let resul0 = gtk_clipboard_wait_for_text(cast[ptr Clipboard00](self.impl))
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc gtk_clipboard_wait_for_uris(self: ptr Clipboard00): ptr cstring {.
    importc, libprag.}

proc waitForUris*(self: Clipboard): seq[string] =
  let resul0 = gtk_clipboard_wait_for_uris(cast[ptr Clipboard00](self.impl))
  if resul0.isNil:
    return
  result = cstringArrayToSeq(resul0)
  g_strfreev(resul0)

proc gtk_clipboard_wait_is_image_available(self: ptr Clipboard00): gboolean {.
    importc, libprag.}

proc waitIsImageAvailable*(self: Clipboard): bool =
  toBool(gtk_clipboard_wait_is_image_available(cast[ptr Clipboard00](self.impl)))

proc gtk_clipboard_wait_is_target_available(self: ptr Clipboard00; target: ptr gdk.Atom00): gboolean {.
    importc, libprag.}

proc waitIsTargetAvailable*(self: Clipboard; target: gdk.Atom): bool =
  toBool(gtk_clipboard_wait_is_target_available(cast[ptr Clipboard00](self.impl), cast[ptr gdk.Atom00](target.impl)))

proc gtk_clipboard_wait_is_text_available(self: ptr Clipboard00): gboolean {.
    importc, libprag.}

proc waitIsTextAvailable*(self: Clipboard): bool =
  toBool(gtk_clipboard_wait_is_text_available(cast[ptr Clipboard00](self.impl)))

proc gtk_clipboard_wait_is_uris_available(self: ptr Clipboard00): gboolean {.
    importc, libprag.}

proc waitIsUrisAvailable*(self: Clipboard): bool =
  toBool(gtk_clipboard_wait_is_uris_available(cast[ptr Clipboard00](self.impl)))

proc gtk_widget_get_clipboard(self: ptr Widget00; selection: ptr gdk.Atom00): ptr Clipboard00 {.
    importc, libprag.}

proc getClipboard*(self: Widget; selection: gdk.Atom): Clipboard =
  let gobj = gtk_widget_get_clipboard(cast[ptr Widget00](self.impl), cast[ptr gdk.Atom00](selection.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  SizeRequestMode* {.size: sizeof(cint), pure.} = enum
    heightForWidth = 0
    widthForHeight = 1
    constantSize = 2

proc gtk_widget_get_request_mode(self: ptr Widget00): SizeRequestMode {.
    importc, libprag.}

proc getRequestMode*(self: Widget): SizeRequestMode =
  gtk_widget_get_request_mode(cast[ptr Widget00](self.impl))

proc requestMode*(self: Widget): SizeRequestMode =
  gtk_widget_get_request_mode(cast[ptr Widget00](self.impl))

type
  Settings* = ref object of gobject.Object
  Settings00* = object of gobject.Object00

proc gtk_settings_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Settings()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_settings_get_default(): ptr Settings00 {.
    importc, libprag.}

proc getDefaultSettings*(): Settings =
  let gobj = gtk_settings_get_default()
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_settings_get_for_screen(screen: ptr gdk.Screen00): ptr Settings00 {.
    importc, libprag.}

proc getSettingsForScreen*(screen: gdk.Screen): Settings =
  let gobj = gtk_settings_get_for_screen(cast[ptr gdk.Screen00](screen.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_settings_install_property(pspec: ptr gobject.ParamSpec00) {.
    importc, libprag.}

proc installProperty*(pspec: gobject.ParamSpec) =
  gtk_settings_install_property(cast[ptr gobject.ParamSpec00](pspec.impl))

proc gtk_settings_reset_property(self: ptr Settings00; name: cstring) {.
    importc, libprag.}

proc resetProperty*(self: Settings; name: cstring) =
  gtk_settings_reset_property(cast[ptr Settings00](self.impl), name)

proc gtk_settings_set_double_property(self: ptr Settings00; name: cstring;
    vDouble: cdouble; origin: cstring) {.
    importc, libprag.}

proc setDoubleProperty*(self: Settings; name: cstring; vDouble: cdouble;
    origin: cstring) =
  gtk_settings_set_double_property(cast[ptr Settings00](self.impl), name, vDouble, origin)

proc gtk_settings_set_long_property(self: ptr Settings00; name: cstring;
    vLong: int64; origin: cstring) {.
    importc, libprag.}

proc setLongProperty*(self: Settings; name: cstring; vLong: int64;
    origin: cstring) =
  gtk_settings_set_long_property(cast[ptr Settings00](self.impl), name, vLong, origin)

proc gtk_settings_set_string_property(self: ptr Settings00; name: cstring;
    vString: cstring; origin: cstring) {.
    importc, libprag.}

proc setStringProperty*(self: Settings; name: cstring; vString: cstring;
    origin: cstring) =
  gtk_settings_set_string_property(cast[ptr Settings00](self.impl), name, vString, origin)

proc gtk_widget_get_settings(self: ptr Widget00): ptr Settings00 {.
    importc, libprag.}

proc getSettings*(self: Widget): Settings =
  let gobj = gtk_widget_get_settings(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  SettingsValue* {.pure, byRef.} = object
    origin*: cstring
    value*: gobject.Value

proc gtk_settings_set_property_value(self: ptr Settings00; name: cstring;
    svalue: SettingsValue) {.
    importc, libprag.}

proc setPropertyValue*(self: Settings; name: cstring; svalue: SettingsValue) =
  gtk_settings_set_property_value(cast[ptr Settings00](self.impl), name, svalue)

type
  StyleContext* = ref object of gobject.Object
  StyleContext00* = object of gobject.Object00

proc gtk_style_context_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(StyleContext()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scChanged*(self: StyleContext;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "changed", cast[GCallback](p), xdata, nil, cf)

proc gtk_style_context_new(): ptr StyleContext00 {.
    importc, libprag.}

proc newStyleContext*(): StyleContext =
  let gobj = gtk_style_context_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newStyleContext*(tdesc: typedesc): tdesc =
  assert(result is StyleContext)
  let gobj = gtk_style_context_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initStyleContext*[T](result: var T) {.deprecated.} =
  assert(result is StyleContext)
  let gobj = gtk_style_context_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_style_context_reset_widgets(screen: ptr gdk.Screen00) {.
    importc, libprag.}

proc resetWidgets*(screen: gdk.Screen) =
  gtk_style_context_reset_widgets(cast[ptr gdk.Screen00](screen.impl))

proc gtk_style_context_add_class(self: ptr StyleContext00; className: cstring) {.
    importc, libprag.}

proc addClass*(self: StyleContext; className: cstring) =
  gtk_style_context_add_class(cast[ptr StyleContext00](self.impl), className)

proc gtk_style_context_cancel_animations(self: ptr StyleContext00; regionId: pointer) {.
    importc, libprag.}

proc cancelAnimations*(self: StyleContext; regionId: pointer) =
  gtk_style_context_cancel_animations(cast[ptr StyleContext00](self.impl), regionId)

proc gtk_style_context_get_background_color(self: ptr StyleContext00; state: StateFlags;
    color: var gdk.RGBA) {.
    importc, libprag.}

proc getBackgroundColor*(self: StyleContext; state: StateFlags;
    color: var gdk.RGBA) =
  gtk_style_context_get_background_color(cast[ptr StyleContext00](self.impl), state, color)

proc gtk_style_context_get_border_color(self: ptr StyleContext00; state: StateFlags;
    color: var gdk.RGBA) {.
    importc, libprag.}

proc getBorderColor*(self: StyleContext; state: StateFlags;
    color: var gdk.RGBA) =
  gtk_style_context_get_border_color(cast[ptr StyleContext00](self.impl), state, color)

proc gtk_style_context_get_color(self: ptr StyleContext00; state: StateFlags;
    color: var gdk.RGBA) {.
    importc, libprag.}

proc getColor*(self: StyleContext; state: StateFlags; color: var gdk.RGBA) =
  gtk_style_context_get_color(cast[ptr StyleContext00](self.impl), state, color)

proc gtk_style_context_get_direction(self: ptr StyleContext00): TextDirection {.
    importc, libprag.}

proc getDirection*(self: StyleContext): TextDirection =
  gtk_style_context_get_direction(cast[ptr StyleContext00](self.impl))

proc direction*(self: StyleContext): TextDirection =
  gtk_style_context_get_direction(cast[ptr StyleContext00](self.impl))

proc gtk_style_context_get_font(self: ptr StyleContext00; state: StateFlags): ptr pango.FontDescription00 {.
    importc, libprag.}

proc getFont*(self: StyleContext; state: StateFlags): pango.FontDescription =
  fnew(result, gBoxedFreePangoFontDescription)
  result.impl = gtk_style_context_get_font(cast[ptr StyleContext00](self.impl), state)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(pango_font_description_get_type(), result.impl))

proc gtk_style_context_get_frame_clock(self: ptr StyleContext00): ptr gdk.FrameClock00 {.
    importc, libprag.}

proc getFrameClock*(self: StyleContext): gdk.FrameClock =
  let gobj = gtk_style_context_get_frame_clock(cast[ptr StyleContext00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc frameClock*(self: StyleContext): gdk.FrameClock =
  let gobj = gtk_style_context_get_frame_clock(cast[ptr StyleContext00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_style_context_get_parent(self: ptr StyleContext00): ptr StyleContext00 {.
    importc, libprag.}

proc getParent*(self: StyleContext): StyleContext =
  let gobj = gtk_style_context_get_parent(cast[ptr StyleContext00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc parent*(self: StyleContext): StyleContext =
  let gobj = gtk_style_context_get_parent(cast[ptr StyleContext00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_style_context_get_property(self: ptr StyleContext00; property: cstring;
    state: StateFlags; value: var gobject.Value) {.
    importc, libprag.}

proc getProperty*(self: StyleContext; property: cstring;
    state: StateFlags; value: var gobject.Value) =
  gtk_style_context_get_property(cast[ptr StyleContext00](self.impl), property, state, value)

proc gtk_style_context_get_scale(self: ptr StyleContext00): int32 {.
    importc, libprag.}

proc getScale*(self: StyleContext): int =
  int(gtk_style_context_get_scale(cast[ptr StyleContext00](self.impl)))

proc scale*(self: StyleContext): int =
  int(gtk_style_context_get_scale(cast[ptr StyleContext00](self.impl)))

proc gtk_style_context_get_screen(self: ptr StyleContext00): ptr gdk.Screen00 {.
    importc, libprag.}

proc getScreen*(self: StyleContext): gdk.Screen =
  let gobj = gtk_style_context_get_screen(cast[ptr StyleContext00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc screen*(self: StyleContext): gdk.Screen =
  let gobj = gtk_style_context_get_screen(cast[ptr StyleContext00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_style_context_get_state(self: ptr StyleContext00): StateFlags {.
    importc, libprag.}

proc getState*(self: StyleContext): StateFlags =
  gtk_style_context_get_state(cast[ptr StyleContext00](self.impl))

proc state*(self: StyleContext): StateFlags =
  gtk_style_context_get_state(cast[ptr StyleContext00](self.impl))

proc gtk_style_context_get_style_property(self: ptr StyleContext00; propertyName: cstring;
    value: gobject.Value) {.
    importc, libprag.}

proc getStyleProperty*(self: StyleContext; propertyName: cstring;
    value: gobject.Value) =
  gtk_style_context_get_style_property(cast[ptr StyleContext00](self.impl), propertyName, value)

proc gtk_style_context_has_class(self: ptr StyleContext00; className: cstring): gboolean {.
    importc, libprag.}

proc hasClass*(self: StyleContext; className: cstring): bool =
  toBool(gtk_style_context_has_class(cast[ptr StyleContext00](self.impl), className))

proc gtk_style_context_invalidate(self: ptr StyleContext00) {.
    importc, libprag.}

proc invalidate*(self: StyleContext) =
  gtk_style_context_invalidate(cast[ptr StyleContext00](self.impl))

proc gtk_style_context_list_classes(self: ptr StyleContext00): ptr glib.List {.
    importc, libprag.}

proc listClasses*(self: StyleContext): seq[cstring] =
  let resul0 = gtk_style_context_list_classes(cast[ptr StyleContext00](self.impl))
  g_list_free(resul0)

proc gtk_style_context_list_regions(self: ptr StyleContext00): ptr glib.List {.
    importc, libprag.}

proc listRegions*(self: StyleContext): seq[cstring] =
  let resul0 = gtk_style_context_list_regions(cast[ptr StyleContext00](self.impl))
  g_list_free(resul0)

proc gtk_style_context_lookup_color(self: ptr StyleContext00; colorName: cstring;
    color: var gdk.RGBA): gboolean {.
    importc, libprag.}

proc lookupColor*(self: StyleContext; colorName: cstring;
    color: var gdk.RGBA): bool =
  toBool(gtk_style_context_lookup_color(cast[ptr StyleContext00](self.impl), colorName, color))

proc gtk_style_context_lookup_icon_set(self: ptr StyleContext00; stockId: cstring): ptr IconSet00 {.
    importc, libprag.}

proc lookupIconSet*(self: StyleContext; stockId: cstring): IconSet =
  let impl0 = gtk_style_context_lookup_icon_set(cast[ptr StyleContext00](self.impl), stockId)
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreeGtkIconSet)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(gtk_icon_set_get_type(), impl0))

proc gtk_style_context_notify_state_change(self: ptr StyleContext00; window: ptr gdk.Window00;
    regionId: pointer; state: StateType; stateValue: gboolean) {.
    importc, libprag.}

proc notifyStateChange*(self: StyleContext; window: gdk.Window;
    regionId: pointer; state: StateType; stateValue: bool) =
  gtk_style_context_notify_state_change(cast[ptr StyleContext00](self.impl), cast[ptr gdk.Window00](window.impl), regionId, state, gboolean(stateValue))

proc gtk_style_context_pop_animatable_region(self: ptr StyleContext00) {.
    importc, libprag.}

proc popAnimatableRegion*(self: StyleContext) =
  gtk_style_context_pop_animatable_region(cast[ptr StyleContext00](self.impl))

proc gtk_style_context_push_animatable_region(self: ptr StyleContext00; regionId: pointer) {.
    importc, libprag.}

proc pushAnimatableRegion*(self: StyleContext; regionId: pointer) =
  gtk_style_context_push_animatable_region(cast[ptr StyleContext00](self.impl), regionId)

proc gtk_style_context_remove_class(self: ptr StyleContext00; className: cstring) {.
    importc, libprag.}

proc removeClass*(self: StyleContext; className: cstring) =
  gtk_style_context_remove_class(cast[ptr StyleContext00](self.impl), className)

proc gtk_style_context_remove_region(self: ptr StyleContext00; regionName: cstring) {.
    importc, libprag.}

proc removeRegion*(self: StyleContext; regionName: cstring) =
  gtk_style_context_remove_region(cast[ptr StyleContext00](self.impl), regionName)

proc gtk_style_context_restore(self: ptr StyleContext00) {.
    importc, libprag.}

proc restore*(self: StyleContext) =
  gtk_style_context_restore(cast[ptr StyleContext00](self.impl))

proc gtk_style_context_save(self: ptr StyleContext00) {.
    importc, libprag.}

proc save*(self: StyleContext) =
  gtk_style_context_save(cast[ptr StyleContext00](self.impl))

proc gtk_style_context_scroll_animations(self: ptr StyleContext00; window: ptr gdk.Window00;
    dx: int32; dy: int32) {.
    importc, libprag.}

proc scrollAnimations*(self: StyleContext; window: gdk.Window;
    dx: int; dy: int) =
  gtk_style_context_scroll_animations(cast[ptr StyleContext00](self.impl), cast[ptr gdk.Window00](window.impl), int32(dx), int32(dy))

proc gtk_style_context_set_background(self: ptr StyleContext00; window: ptr gdk.Window00) {.
    importc, libprag.}

proc setBackground*(self: StyleContext; window: gdk.Window) =
  gtk_style_context_set_background(cast[ptr StyleContext00](self.impl), cast[ptr gdk.Window00](window.impl))

proc `background=`*(self: StyleContext; window: gdk.Window) =
  gtk_style_context_set_background(cast[ptr StyleContext00](self.impl), cast[ptr gdk.Window00](window.impl))

proc gtk_style_context_set_direction(self: ptr StyleContext00; direction: TextDirection) {.
    importc, libprag.}

proc setDirection*(self: StyleContext; direction: TextDirection) =
  gtk_style_context_set_direction(cast[ptr StyleContext00](self.impl), direction)

proc `direction=`*(self: StyleContext; direction: TextDirection) =
  gtk_style_context_set_direction(cast[ptr StyleContext00](self.impl), direction)

proc gtk_style_context_set_frame_clock(self: ptr StyleContext00; frameClock: ptr gdk.FrameClock00) {.
    importc, libprag.}

proc setFrameClock*(self: StyleContext; frameClock: gdk.FrameClock) =
  gtk_style_context_set_frame_clock(cast[ptr StyleContext00](self.impl), cast[ptr gdk.FrameClock00](frameClock.impl))

proc `frameClock=`*(self: StyleContext; frameClock: gdk.FrameClock) =
  gtk_style_context_set_frame_clock(cast[ptr StyleContext00](self.impl), cast[ptr gdk.FrameClock00](frameClock.impl))

proc gtk_style_context_set_parent(self: ptr StyleContext00; parent: ptr StyleContext00) {.
    importc, libprag.}

proc setParent*(self: StyleContext; parent: StyleContext = nil) =
  gtk_style_context_set_parent(cast[ptr StyleContext00](self.impl), if parent.isNil: nil else: cast[ptr StyleContext00](parent.impl))

proc `parent=`*(self: StyleContext; parent: StyleContext = nil) =
  gtk_style_context_set_parent(cast[ptr StyleContext00](self.impl), if parent.isNil: nil else: cast[ptr StyleContext00](parent.impl))

proc gtk_style_context_set_scale(self: ptr StyleContext00; scale: int32) {.
    importc, libprag.}

proc setScale*(self: StyleContext; scale: int) =
  gtk_style_context_set_scale(cast[ptr StyleContext00](self.impl), int32(scale))

proc `scale=`*(self: StyleContext; scale: int) =
  gtk_style_context_set_scale(cast[ptr StyleContext00](self.impl), int32(scale))

proc gtk_style_context_set_screen(self: ptr StyleContext00; screen: ptr gdk.Screen00) {.
    importc, libprag.}

proc setScreen*(self: StyleContext; screen: gdk.Screen) =
  gtk_style_context_set_screen(cast[ptr StyleContext00](self.impl), cast[ptr gdk.Screen00](screen.impl))

proc `screen=`*(self: StyleContext; screen: gdk.Screen) =
  gtk_style_context_set_screen(cast[ptr StyleContext00](self.impl), cast[ptr gdk.Screen00](screen.impl))

proc gtk_style_context_set_state(self: ptr StyleContext00; flags: StateFlags) {.
    importc, libprag.}

proc setState*(self: StyleContext; flags: StateFlags) =
  gtk_style_context_set_state(cast[ptr StyleContext00](self.impl), flags)

proc `state=`*(self: StyleContext; flags: StateFlags) =
  gtk_style_context_set_state(cast[ptr StyleContext00](self.impl), flags)

proc gtk_style_context_state_is_running(self: ptr StyleContext00; state: StateType;
    progress: var cdouble): gboolean {.
    importc, libprag.}

proc stateIsRunning*(self: StyleContext; state: StateType;
    progress: var cdouble): bool =
  toBool(gtk_style_context_state_is_running(cast[ptr StyleContext00](self.impl), state, progress))

proc gtk_widget_get_style_context(self: ptr Widget00): ptr StyleContext00 {.
    importc, libprag.}

proc getStyleContext*(self: Widget): StyleContext =
  let gobj = gtk_widget_get_style_context(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc styleContext*(self: Widget): StyleContext =
  let gobj = gtk_widget_get_style_context(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_icon_set_render_icon_pixbuf(self: ptr IconSet00; context: ptr StyleContext00;
    size: int32): ptr gdkpixbuf.Pixbuf00 {.
    importc, libprag.}

proc renderIconPixbuf*(self: IconSet; context: StyleContext;
    size: int): gdkpixbuf.Pixbuf =
  let gobj = gtk_icon_set_render_icon_pixbuf(cast[ptr IconSet00](self.impl), cast[ptr StyleContext00](context.impl), int32(size))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdkpixbuf.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_icon_set_render_icon_surface(self: ptr IconSet00; context: ptr StyleContext00;
    size: int32; scale: int32; forWindow: ptr gdk.Window00): ptr cairo.Surface00 {.
    importc, libprag.}

proc renderIconSurface*(self: IconSet; context: StyleContext;
    size: int; scale: int; forWindow: gdk.Window = nil): cairo.Surface =
  fnew(result, gBoxedFreeCairoSurface)
  result.impl = gtk_icon_set_render_icon_surface(cast[ptr IconSet00](self.impl), cast[ptr StyleContext00](context.impl), int32(size), int32(scale), if forWindow.isNil: nil else: cast[ptr gdk.Window00](forWindow.impl))

type
  Border* {.pure, byRef.} = object
    left*: int16
    right*: int16
    top*: int16
    bottom*: int16

proc gtk_border_get_type*(): GType {.importc, libprag.}

proc gtk_border_free(self: Border) {.
    importc, libprag.}

proc free*(self: Border) =
  gtk_border_free(self)

proc gtk_border_copy(self: Border): ptr Border {.
    importc, libprag.}

proc copy*(self: Border): ptr Border =
  gtk_border_copy(self)

proc new*(): ptr Border {.
    importc: "gtk_border_new", libprag.}

proc gtk_style_context_get_border(self: ptr StyleContext00; state: StateFlags;
    border: var Border) {.
    importc, libprag.}

proc getBorder*(self: StyleContext; state: StateFlags;
    border: var Border) =
  gtk_style_context_get_border(cast[ptr StyleContext00](self.impl), state, border)

proc gtk_style_context_get_margin(self: ptr StyleContext00; state: StateFlags;
    margin: var Border) {.
    importc, libprag.}

proc getMargin*(self: StyleContext; state: StateFlags;
    margin: var Border) =
  gtk_style_context_get_margin(cast[ptr StyleContext00](self.impl), state, margin)

proc gtk_style_context_get_padding(self: ptr StyleContext00; state: StateFlags;
    padding: var Border) {.
    importc, libprag.}

proc getPadding*(self: StyleContext; state: StateFlags;
    padding: var Border) =
  gtk_style_context_get_padding(cast[ptr StyleContext00](self.impl), state, padding)

type
  CssSection00* {.pure.} = object
  CssSection* = ref object
    impl*: ptr CssSection00
    ignoreFinalizer*: bool

proc gtk_css_section_get_type*(): GType {.importc, libprag.}

proc gBoxedFreeGtkCssSection*(self: CssSection) =
  if not self.ignoreFinalizer:
    boxedFree(gtk_css_section_get_type(), cast[ptr CssSection00](self.impl))

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(CssSection()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    if not self.ignoreFinalizer and self.impl != nil:
      boxedFree(gtk_css_section_get_type(), cast[ptr CssSection00](self.impl))
      self.impl = nil

proc newWithFinalizer*(x: var CssSection) =
  when defined(gcDestructors):
    new(x)
  else:
    new(x, gBoxedFreeGtkCssSection)

proc gtk_css_section_unref(self: ptr CssSection00) {.
    importc, libprag.}

proc unref*(self: CssSection) =
  gtk_css_section_unref(cast[ptr CssSection00](self.impl))

proc finalizerunref*(self: CssSection) =
  if not self.ignoreFinalizer:
    gtk_css_section_unref(cast[ptr CssSection00](self.impl))

proc gtk_css_section_get_end_position(self: ptr CssSection00): uint32 {.
    importc, libprag.}

proc getEndPosition*(self: CssSection): int =
  int(gtk_css_section_get_end_position(cast[ptr CssSection00](self.impl)))

proc endPosition*(self: CssSection): int =
  int(gtk_css_section_get_end_position(cast[ptr CssSection00](self.impl)))

proc gtk_css_section_get_file(self: ptr CssSection00): ptr gio.GFile00 {.
    importc, libprag.}

proc getFile*(self: CssSection): gio.GFile =
  let gobj = gtk_css_section_get_file(cast[ptr CssSection00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc file*(self: CssSection): gio.GFile =
  let gobj = gtk_css_section_get_file(cast[ptr CssSection00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_css_section_get_parent(self: ptr CssSection00): ptr CssSection00 {.
    importc, libprag.}

proc getParent*(self: CssSection): CssSection =
  let impl0 = gtk_css_section_get_parent(cast[ptr CssSection00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreeGtkCssSection)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(gtk_css_section_get_type(), impl0))

proc parent*(self: CssSection): CssSection =
  let impl0 = gtk_css_section_get_parent(cast[ptr CssSection00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreeGtkCssSection)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(gtk_css_section_get_type(), impl0))

proc gtk_css_section_get_start_line(self: ptr CssSection00): uint32 {.
    importc, libprag.}

proc getStartLine*(self: CssSection): int =
  int(gtk_css_section_get_start_line(cast[ptr CssSection00](self.impl)))

proc startLine*(self: CssSection): int =
  int(gtk_css_section_get_start_line(cast[ptr CssSection00](self.impl)))

proc gtk_css_section_get_start_position(self: ptr CssSection00): uint32 {.
    importc, libprag.}

proc getStartPosition*(self: CssSection): int =
  int(gtk_css_section_get_start_position(cast[ptr CssSection00](self.impl)))

proc startPosition*(self: CssSection): int =
  int(gtk_css_section_get_start_position(cast[ptr CssSection00](self.impl)))

proc gtk_css_section_ref(self: ptr CssSection00): ptr CssSection00 {.
    importc, libprag.}

proc `ref`*(self: CssSection): CssSection =
  fnew(result, gBoxedFreeGtkCssSection)
  result.impl = gtk_css_section_ref(cast[ptr CssSection00](self.impl))

proc gtk_css_section_get_end_line(self: ptr CssSection00): uint32 {.
    importc, libprag.}

proc getEndLine*(self: CssSection): int =
  int(gtk_css_section_get_end_line(cast[ptr CssSection00](self.impl)))

proc endLine*(self: CssSection): int =
  int(gtk_css_section_get_end_line(cast[ptr CssSection00](self.impl)))

proc gtk_style_context_get_section(self: ptr StyleContext00; property: cstring): ptr CssSection00 {.
    importc, libprag.}

proc getSection*(self: StyleContext; property: cstring): CssSection =
  let impl0 = gtk_style_context_get_section(cast[ptr StyleContext00](self.impl), property)
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreeGtkCssSection)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(gtk_css_section_get_type(), impl0))

type
  CssSectionType* {.size: sizeof(cint), pure.} = enum
    document = 0
    `import` = 1
    colorDefinition = 2
    bindingSet = 3
    ruleset = 4
    selector = 5
    declaration = 6
    value = 7
    keyframes = 8

proc gtk_css_section_get_section_type(self: ptr CssSection00): CssSectionType {.
    importc, libprag.}

proc getSectionType*(self: CssSection): CssSectionType =
  gtk_css_section_get_section_type(cast[ptr CssSection00](self.impl))

proc sectionType*(self: CssSection): CssSectionType =
  gtk_css_section_get_section_type(cast[ptr CssSection00](self.impl))

type
  RegionFlag* {.size: sizeof(cint), pure.} = enum
    even = 0
    odd = 1
    first = 2
    last = 3
    only = 4
    sorted = 5

  RegionFlags* {.size: sizeof(cint).} = set[RegionFlag]

proc gtk_style_context_add_region(self: ptr StyleContext00; regionName: cstring;
    flags: RegionFlags) {.
    importc, libprag.}

proc addRegion*(self: StyleContext; regionName: cstring;
    flags: RegionFlags) =
  gtk_style_context_add_region(cast[ptr StyleContext00](self.impl), regionName, flags)

proc gtk_style_context_has_region(self: ptr StyleContext00; regionName: cstring;
    flagsReturn: var RegionFlags): gboolean {.
    importc, libprag.}

proc hasRegion*(self: StyleContext; regionName: cstring;
    flagsReturn: var RegionFlags = cast[var RegionFlags](nil)): bool =
  toBool(gtk_style_context_has_region(cast[ptr StyleContext00](self.impl), regionName, flagsReturn))

type
  StyleProvider00* = object of gobject.Object00
  StyleProvider* = ref object of gobject.Object

type
  StyleProperties* = ref object of gobject.Object
  StyleProperties00* = object of gobject.Object00

proc gtk_style_properties_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(StyleProperties()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_style_properties_new(): ptr StyleProperties00 {.
    importc, libprag.}

proc newStyleProperties*(): StyleProperties {.deprecated.}  =
  let gobj = gtk_style_properties_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newStyleProperties*(tdesc: typedesc): tdesc {.deprecated.}  =
  assert(result is StyleProperties)
  let gobj = gtk_style_properties_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initStyleProperties*[T](result: var T) {.deprecated.} =
  assert(result is StyleProperties)
  let gobj = gtk_style_properties_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_style_properties_clear(self: ptr StyleProperties00) {.
    importc, libprag.}

proc clear*(self: StyleProperties) =
  gtk_style_properties_clear(cast[ptr StyleProperties00](self.impl))

proc gtk_style_properties_get_property(self: ptr StyleProperties00; property: cstring;
    state: StateFlags; value: var gobject.Value): gboolean {.
    importc, libprag.}

proc getProperty*(self: StyleProperties; property: cstring;
    state: StateFlags; value: var gobject.Value): bool =
  toBool(gtk_style_properties_get_property(cast[ptr StyleProperties00](self.impl), property, state, value))

proc gtk_style_properties_merge(self: ptr StyleProperties00; propsToMerge: ptr StyleProperties00;
    replace: gboolean) {.
    importc, libprag.}

proc merge*(self: StyleProperties; propsToMerge: StyleProperties;
    replace: bool) =
  gtk_style_properties_merge(cast[ptr StyleProperties00](self.impl), cast[ptr StyleProperties00](propsToMerge.impl), gboolean(replace))

proc gtk_style_properties_set_property(self: ptr StyleProperties00; property: cstring;
    state: StateFlags; value: gobject.Value) {.
    importc, libprag.}

proc setProperty*(self: StyleProperties; property: cstring;
    state: StateFlags; value: gobject.Value) =
  gtk_style_properties_set_property(cast[ptr StyleProperties00](self.impl), property, state, value)

proc gtk_style_properties_unset_property(self: ptr StyleProperties00; property: cstring;
    state: StateFlags) {.
    importc, libprag.}

proc unsetProperty*(self: StyleProperties; property: cstring;
    state: StateFlags) =
  gtk_style_properties_unset_property(cast[ptr StyleProperties00](self.impl), property, state)

type
  CssProvider* = ref object of gobject.Object
  CssProvider00* = object of gobject.Object00

proc gtk_css_provider_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(CssProvider()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scParsingError*(self: CssProvider;  p: proc (self: ptr CssProvider00; section: ptr CssSection00; error: ptr glib.Error; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "parsing-error", cast[GCallback](p), xdata, nil, cf)

proc gtk_css_provider_new(): ptr CssProvider00 {.
    importc, libprag.}

proc newCssProvider*(): CssProvider =
  let gobj = gtk_css_provider_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newCssProvider*(tdesc: typedesc): tdesc =
  assert(result is CssProvider)
  let gobj = gtk_css_provider_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initCssProvider*[T](result: var T) {.deprecated.} =
  assert(result is CssProvider)
  let gobj = gtk_css_provider_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_css_provider_get_default(): ptr CssProvider00 {.
    importc, libprag.}

proc getDefaultCssProvider*(): CssProvider =
  let gobj = gtk_css_provider_get_default()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_css_provider_get_named(name: cstring; variant: cstring): ptr CssProvider00 {.
    importc, libprag.}

proc getNamed*(name: cstring; variant: cstring = nil): CssProvider =
  let gobj = gtk_css_provider_get_named(name, variant)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_css_provider_load_from_data(self: ptr CssProvider00; data: ptr uint8;
    length: int64; error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc loadFromData*(self: CssProvider; data: seq[uint8] | string): bool =
  let length = int64(data.len)
  var gerror: ptr glib.Error
  let resul0 = gtk_css_provider_load_from_data(cast[ptr CssProvider00](self.impl), cast[ptr uint8](unsafeaddr(data[0])), length, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc gtk_css_provider_load_from_file(self: ptr CssProvider00; file: ptr gio.GFile00;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc loadFromFile*(self: CssProvider; file: gio.GFile): bool =
  var gerror: ptr glib.Error
  let resul0 = gtk_css_provider_load_from_file(cast[ptr CssProvider00](self.impl), cast[ptr gio.GFile00](file.impl), addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc gtk_css_provider_load_from_path(self: ptr CssProvider00; path: cstring;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc loadFromPath*(self: CssProvider; path: cstring): bool =
  var gerror: ptr glib.Error
  let resul0 = gtk_css_provider_load_from_path(cast[ptr CssProvider00](self.impl), path, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc gtk_css_provider_load_from_resource(self: ptr CssProvider00; resourcePath: cstring) {.
    importc, libprag.}

proc loadFromResource*(self: CssProvider; resourcePath: cstring) =
  gtk_css_provider_load_from_resource(cast[ptr CssProvider00](self.impl), resourcePath)

proc gtk_css_provider_to_string(self: ptr CssProvider00): cstring {.
    importc, libprag.}

proc toString*(self: CssProvider): string =
  let resul0 = gtk_css_provider_to_string(cast[ptr CssProvider00](self.impl))
  result = $resul0
  cogfree(resul0)

proc gtk_style_context_add_provider_for_screen(screen: ptr gdk.Screen00;
    provider: ptr StyleProvider00; priority: uint32) {.
    importc, libprag.}

proc addProviderForScreen*(screen: gdk.Screen; provider: StyleProvider | StyleProperties | CssProvider | Settings;
    priority: int) =
  gtk_style_context_add_provider_for_screen(cast[ptr gdk.Screen00](screen.impl), cast[ptr StyleProvider00](provider.impl), uint32(priority))

proc gtk_style_context_remove_provider_for_screen(screen: ptr gdk.Screen00;
    provider: ptr StyleProvider00) {.
    importc, libprag.}

proc removeProviderForScreen*(screen: gdk.Screen; provider: StyleProvider | StyleProperties | CssProvider | Settings) =
  gtk_style_context_remove_provider_for_screen(cast[ptr gdk.Screen00](screen.impl), cast[ptr StyleProvider00](provider.impl))

proc gtk_style_context_add_provider(self: ptr StyleContext00; provider: ptr StyleProvider00;
    priority: uint32) {.
    importc, libprag.}

proc addProvider*(self: StyleContext; provider: StyleProvider | StyleProperties | CssProvider | Settings;
    priority: int) =
  gtk_style_context_add_provider(cast[ptr StyleContext00](self.impl), cast[ptr StyleProvider00](provider.impl), uint32(priority))

proc gtk_style_context_remove_provider(self: ptr StyleContext00; provider: ptr StyleProvider00) {.
    importc, libprag.}

proc removeProvider*(self: StyleContext; provider: StyleProvider | StyleProperties | CssProvider | Settings) =
  gtk_style_context_remove_provider(cast[ptr StyleContext00](self.impl), cast[ptr StyleProvider00](provider.impl))

type
  SymbolicColor00* {.pure.} = object
  SymbolicColor* = ref object
    impl*: ptr SymbolicColor00
    ignoreFinalizer*: bool

proc gtk_symbolic_color_get_type*(): GType {.importc, libprag.}

proc gBoxedFreeGtkSymbolicColor*(self: SymbolicColor) =
  if not self.ignoreFinalizer:
    boxedFree(gtk_symbolic_color_get_type(), cast[ptr SymbolicColor00](self.impl))

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(SymbolicColor()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    if not self.ignoreFinalizer and self.impl != nil:
      boxedFree(gtk_symbolic_color_get_type(), cast[ptr SymbolicColor00](self.impl))
      self.impl = nil

proc newWithFinalizer*(x: var SymbolicColor) =
  when defined(gcDestructors):
    new(x)
  else:
    new(x, gBoxedFreeGtkSymbolicColor)

proc gtk_symbolic_color_unref(self: ptr SymbolicColor00) {.
    importc, libprag.}

proc unref*(self: SymbolicColor) =
  gtk_symbolic_color_unref(cast[ptr SymbolicColor00](self.impl))

proc finalizerunref*(self: SymbolicColor) =
  if not self.ignoreFinalizer:
    gtk_symbolic_color_unref(cast[ptr SymbolicColor00](self.impl))

proc gtk_symbolic_color_new_literal(color: gdk.RGBA): ptr SymbolicColor00 {.
    importc, libprag.}

proc newSymbolicColorLiteral*(color: gdk.RGBA): SymbolicColor {.deprecated.}  =
  fnew(result, gBoxedFreeGtkSymbolicColor)
  result.impl = gtk_symbolic_color_new_literal(color)

proc newSymbolicColorLiteral*(tdesc: typedesc; color: gdk.RGBA): tdesc {.deprecated.}  =
  assert(result is SymbolicColor)
  fnew(result, gBoxedFreeGtkSymbolicColor)
  result.impl = gtk_symbolic_color_new_literal(color)

proc initSymbolicColorLiteral*[T](result: var T; color: gdk.RGBA) {.deprecated.} =
  assert(result is SymbolicColor)
  fnew(result, gBoxedFreeGtkSymbolicColor)
  result.impl = gtk_symbolic_color_new_literal(color)

proc gtk_symbolic_color_new_mix(color1: ptr SymbolicColor00; color2: ptr SymbolicColor00;
    factor: cdouble): ptr SymbolicColor00 {.
    importc, libprag.}

proc newSymbolicColorMix*(color1: SymbolicColor; color2: SymbolicColor;
    factor: cdouble): SymbolicColor {.deprecated.}  =
  fnew(result, gBoxedFreeGtkSymbolicColor)
  result.impl = gtk_symbolic_color_new_mix(cast[ptr SymbolicColor00](color1.impl), cast[ptr SymbolicColor00](color2.impl), factor)

proc newSymbolicColorMix*(tdesc: typedesc; color1: SymbolicColor; color2: SymbolicColor;
    factor: cdouble): tdesc {.deprecated.}  =
  assert(result is SymbolicColor)
  fnew(result, gBoxedFreeGtkSymbolicColor)
  result.impl = gtk_symbolic_color_new_mix(cast[ptr SymbolicColor00](color1.impl), cast[ptr SymbolicColor00](color2.impl), factor)

proc initSymbolicColorMix*[T](result: var T; color1: SymbolicColor; color2: SymbolicColor;
    factor: cdouble) {.deprecated.} =
  assert(result is SymbolicColor)
  fnew(result, gBoxedFreeGtkSymbolicColor)
  result.impl = gtk_symbolic_color_new_mix(cast[ptr SymbolicColor00](color1.impl), cast[ptr SymbolicColor00](color2.impl), factor)

proc gtk_symbolic_color_new_name(name: cstring): ptr SymbolicColor00 {.
    importc, libprag.}

proc newSymbolicColorName*(name: cstring): SymbolicColor {.deprecated.}  =
  fnew(result, gBoxedFreeGtkSymbolicColor)
  result.impl = gtk_symbolic_color_new_name(name)

proc newSymbolicColorName*(tdesc: typedesc; name: cstring): tdesc {.deprecated.}  =
  assert(result is SymbolicColor)
  fnew(result, gBoxedFreeGtkSymbolicColor)
  result.impl = gtk_symbolic_color_new_name(name)

proc initSymbolicColorName*[T](result: var T; name: cstring) {.deprecated.} =
  assert(result is SymbolicColor)
  fnew(result, gBoxedFreeGtkSymbolicColor)
  result.impl = gtk_symbolic_color_new_name(name)

proc gtk_symbolic_color_new_shade(color: ptr SymbolicColor00; factor: cdouble): ptr SymbolicColor00 {.
    importc, libprag.}

proc newSymbolicColorShade*(color: SymbolicColor; factor: cdouble): SymbolicColor {.deprecated.}  =
  fnew(result, gBoxedFreeGtkSymbolicColor)
  result.impl = gtk_symbolic_color_new_shade(cast[ptr SymbolicColor00](color.impl), factor)

proc newSymbolicColorShade*(tdesc: typedesc; color: SymbolicColor; factor: cdouble): tdesc {.deprecated.}  =
  assert(result is SymbolicColor)
  fnew(result, gBoxedFreeGtkSymbolicColor)
  result.impl = gtk_symbolic_color_new_shade(cast[ptr SymbolicColor00](color.impl), factor)

proc initSymbolicColorShade*[T](result: var T; color: SymbolicColor; factor: cdouble) {.deprecated.} =
  assert(result is SymbolicColor)
  fnew(result, gBoxedFreeGtkSymbolicColor)
  result.impl = gtk_symbolic_color_new_shade(cast[ptr SymbolicColor00](color.impl), factor)

proc gtk_symbolic_color_new_win32(themeClass: cstring; id: int32): ptr SymbolicColor00 {.
    importc, libprag.}

proc newSymbolicColorWin32*(themeClass: cstring; id: int): SymbolicColor {.deprecated.}  =
  fnew(result, gBoxedFreeGtkSymbolicColor)
  result.impl = gtk_symbolic_color_new_win32(themeClass, int32(id))

proc newSymbolicColorWin32*(tdesc: typedesc; themeClass: cstring; id: int): tdesc {.deprecated.}  =
  assert(result is SymbolicColor)
  fnew(result, gBoxedFreeGtkSymbolicColor)
  result.impl = gtk_symbolic_color_new_win32(themeClass, int32(id))

proc initSymbolicColorWin32*[T](result: var T; themeClass: cstring; id: int) {.deprecated.} =
  assert(result is SymbolicColor)
  fnew(result, gBoxedFreeGtkSymbolicColor)
  result.impl = gtk_symbolic_color_new_win32(themeClass, int32(id))

proc gtk_symbolic_color_ref(self: ptr SymbolicColor00): ptr SymbolicColor00 {.
    importc, libprag.}

proc `ref`*(self: SymbolicColor): SymbolicColor =
  fnew(result, gBoxedFreeGtkSymbolicColor)
  result.impl = gtk_symbolic_color_ref(cast[ptr SymbolicColor00](self.impl))

proc gtk_symbolic_color_resolve(self: ptr SymbolicColor00; props: ptr StyleProperties00;
    resolvedColor: var gdk.RGBA): gboolean {.
    importc, libprag.}

proc resolve*(self: SymbolicColor; props: StyleProperties = nil;
    resolvedColor: var gdk.RGBA): bool =
  toBool(gtk_symbolic_color_resolve(cast[ptr SymbolicColor00](self.impl), if props.isNil: nil else: cast[ptr StyleProperties00](props.impl), resolvedColor))

proc gtk_symbolic_color_to_string(self: ptr SymbolicColor00): cstring {.
    importc, libprag.}

proc toString*(self: SymbolicColor): string =
  let resul0 = gtk_symbolic_color_to_string(cast[ptr SymbolicColor00](self.impl))
  result = $resul0
  cogfree(resul0)

proc gtk_symbolic_color_new_alpha(color: ptr SymbolicColor00; factor: cdouble): ptr SymbolicColor00 {.
    importc, libprag.}

proc newSymbolicColorAlpha*(color: SymbolicColor; factor: cdouble): SymbolicColor {.deprecated.}  =
  fnew(result, gBoxedFreeGtkSymbolicColor)
  result.impl = gtk_symbolic_color_new_alpha(cast[ptr SymbolicColor00](color.impl), factor)

proc newSymbolicColorAlpha*(tdesc: typedesc; color: SymbolicColor; factor: cdouble): tdesc {.deprecated.}  =
  assert(result is SymbolicColor)
  fnew(result, gBoxedFreeGtkSymbolicColor)
  result.impl = gtk_symbolic_color_new_alpha(cast[ptr SymbolicColor00](color.impl), factor)

proc initSymbolicColorAlpha*[T](result: var T; color: SymbolicColor; factor: cdouble) {.deprecated.} =
  assert(result is SymbolicColor)
  fnew(result, gBoxedFreeGtkSymbolicColor)
  result.impl = gtk_symbolic_color_new_alpha(cast[ptr SymbolicColor00](color.impl), factor)

proc gtk_style_properties_lookup_color(self: ptr StyleProperties00; name: cstring): ptr SymbolicColor00 {.
    importc, libprag.}

proc lookupColor*(self: StyleProperties; name: cstring): SymbolicColor =
  fnew(result, gBoxedFreeGtkSymbolicColor)
  result.impl = gtk_style_properties_lookup_color(cast[ptr StyleProperties00](self.impl), name)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(gtk_symbolic_color_get_type(), result.impl))

proc gtk_style_properties_map_color(self: ptr StyleProperties00; name: cstring;
    color: ptr SymbolicColor00) {.
    importc, libprag.}

proc mapColor*(self: StyleProperties; name: cstring;
    color: SymbolicColor) =
  gtk_style_properties_map_color(cast[ptr StyleProperties00](self.impl), name, cast[ptr SymbolicColor00](color.impl))

type
  JunctionSides* {.size: sizeof(cint), pure.} = enum
    none = 0
    cornerTopleft = 1
    cornerTopright = 2
    top = 3
    cornerBottomleft = 4
    left = 5
    cornerBottomright = 8
    right = 10
    bottom = 12

proc gtk_style_context_get_junction_sides(self: ptr StyleContext00): JunctionSides {.
    importc, libprag.}

proc getJunctionSides*(self: StyleContext): JunctionSides =
  gtk_style_context_get_junction_sides(cast[ptr StyleContext00](self.impl))

proc junctionSides*(self: StyleContext): JunctionSides =
  gtk_style_context_get_junction_sides(cast[ptr StyleContext00](self.impl))

proc gtk_style_context_set_junction_sides(self: ptr StyleContext00; sides: JunctionSides) {.
    importc, libprag.}

proc setJunctionSides*(self: StyleContext; sides: JunctionSides) =
  gtk_style_context_set_junction_sides(cast[ptr StyleContext00](self.impl), sides)

proc `junctionSides=`*(self: StyleContext; sides: JunctionSides) =
  gtk_style_context_set_junction_sides(cast[ptr StyleContext00](self.impl), sides)

type
  StyleContextPrintFlag* {.size: sizeof(cint), pure.} = enum
    recurse = 0
    showStyle = 1

  StyleContextPrintFlags* {.size: sizeof(cint).} = set[StyleContextPrintFlag]

const
  StyleContextPrintFlagsNone* = StyleContextPrintFlags({})
proc none*(t: typedesc[StyleContextPrintFlags]): StyleContextPrintFlags = StyleContextPrintFlags({})

proc gtk_style_context_to_string(self: ptr StyleContext00; flags: StyleContextPrintFlags): cstring {.
    importc, libprag.}

proc toString*(self: StyleContext; flags: StyleContextPrintFlags): string =
  let resul0 = gtk_style_context_to_string(cast[ptr StyleContext00](self.impl), flags)
  result = $resul0
  cogfree(resul0)

type
  RcStyle* = ref object of gobject.Object
  RcStyle00* = object of gobject.Object00

proc gtk_rc_style_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(RcStyle()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_rc_style_new(): ptr RcStyle00 {.
    importc, libprag.}

proc newRcStyle*(): RcStyle {.deprecated.}  =
  let gobj = gtk_rc_style_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newRcStyle*(tdesc: typedesc): tdesc {.deprecated.}  =
  assert(result is RcStyle)
  let gobj = gtk_rc_style_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initRcStyle*[T](result: var T) {.deprecated.} =
  assert(result is RcStyle)
  let gobj = gtk_rc_style_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_rc_style_copy(self: ptr RcStyle00): ptr RcStyle00 {.
    importc, libprag.}

proc copy*(self: RcStyle): RcStyle =
  let gobj = gtk_rc_style_copy(cast[ptr RcStyle00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_get_modifier_style(self: ptr Widget00): ptr RcStyle00 {.
    importc, libprag.}

proc getModifierStyle*(self: Widget): RcStyle =
  let gobj = gtk_widget_get_modifier_style(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc modifierStyle*(self: Widget): RcStyle =
  let gobj = gtk_widget_get_modifier_style(cast[ptr Widget00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_widget_modify_style(self: ptr Widget00; style: ptr RcStyle00) {.
    importc, libprag.}

proc modifyStyle*(self: Widget; style: RcStyle) =
  gtk_widget_modify_style(cast[ptr Widget00](self.impl), cast[ptr RcStyle00](style.impl))

type
  AccelGroup* = ref object of gobject.Object
  AccelGroup00* = object of gobject.Object00

proc gtk_accel_group_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(AccelGroup()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scAccelActivate*(self: AccelGroup;  p: proc (self: ptr AccelGroup00; acceleratable: ptr gobject.Object00; keyval: uint32; modifier: gdk.ModifierType; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "accel-activate", cast[GCallback](p), xdata, nil, cf)

proc scAccelChanged*(self: AccelGroup;  p: proc (self: ptr AccelGroup00; keyval: uint32; modifier: gdk.ModifierType; accelClosure: ptr gobject.Closure00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "accel-changed", cast[GCallback](p), xdata, nil, cf)

proc gtk_accel_group_new(): ptr AccelGroup00 {.
    importc, libprag.}

proc newAccelGroup*(): AccelGroup =
  let gobj = gtk_accel_group_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newAccelGroup*(tdesc: typedesc): tdesc =
  assert(result is AccelGroup)
  let gobj = gtk_accel_group_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initAccelGroup*[T](result: var T) {.deprecated.} =
  assert(result is AccelGroup)
  let gobj = gtk_accel_group_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_accel_group_from_accel_closure(closure: ptr gobject.Closure00): ptr AccelGroup00 {.
    importc, libprag.}

proc fromAccelClosure*(closure: gobject.Closure): AccelGroup =
  let gobj = gtk_accel_group_from_accel_closure(cast[ptr gobject.Closure00](closure.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_accel_group_activate(self: ptr AccelGroup00; accelQuark: uint32;
    acceleratable: ptr gobject.Object00; accelKey: uint32; accelMods: gdk.ModifierType): gboolean {.
    importc, libprag.}

proc activate*(self: AccelGroup; accelQuark: int; acceleratable: gobject.Object;
    accelKey: int; accelMods: gdk.ModifierType): bool =
  toBool(gtk_accel_group_activate(cast[ptr AccelGroup00](self.impl), uint32(accelQuark), cast[ptr gobject.Object00](acceleratable.impl), uint32(accelKey), accelMods))

proc gtk_accel_group_connect_by_path(self: ptr AccelGroup00; accelPath: cstring;
    closure: ptr gobject.Closure00) {.
    importc, libprag.}

proc connectByPath*(self: AccelGroup; accelPath: cstring;
    closure: gobject.Closure) =
  gtk_accel_group_connect_by_path(cast[ptr AccelGroup00](self.impl), accelPath, cast[ptr gobject.Closure00](closure.impl))

proc gtk_accel_group_disconnect(self: ptr AccelGroup00; closure: ptr gobject.Closure00): gboolean {.
    importc, libprag.}

proc disconnect*(self: AccelGroup; closure: gobject.Closure = nil): bool =
  toBool(gtk_accel_group_disconnect(cast[ptr AccelGroup00](self.impl), if closure.isNil: nil else: cast[ptr gobject.Closure00](closure.impl)))

proc gtk_accel_group_disconnect_key(self: ptr AccelGroup00; accelKey: uint32;
    accelMods: gdk.ModifierType): gboolean {.
    importc, libprag.}

proc disconnectKey*(self: AccelGroup; accelKey: int; accelMods: gdk.ModifierType): bool =
  toBool(gtk_accel_group_disconnect_key(cast[ptr AccelGroup00](self.impl), uint32(accelKey), accelMods))

proc gtk_accel_group_get_is_locked(self: ptr AccelGroup00): gboolean {.
    importc, libprag.}

proc getIsLocked*(self: AccelGroup): bool =
  toBool(gtk_accel_group_get_is_locked(cast[ptr AccelGroup00](self.impl)))

proc isLocked*(self: AccelGroup): bool =
  toBool(gtk_accel_group_get_is_locked(cast[ptr AccelGroup00](self.impl)))

proc gtk_accel_group_get_modifier_mask(self: ptr AccelGroup00): gdk.ModifierType {.
    importc, libprag.}

proc getModifierMask*(self: AccelGroup): gdk.ModifierType =
  gtk_accel_group_get_modifier_mask(cast[ptr AccelGroup00](self.impl))

proc modifierMask*(self: AccelGroup): gdk.ModifierType =
  gtk_accel_group_get_modifier_mask(cast[ptr AccelGroup00](self.impl))

proc gtk_accel_group_lock(self: ptr AccelGroup00) {.
    importc, libprag.}

proc lock*(self: AccelGroup) =
  gtk_accel_group_lock(cast[ptr AccelGroup00](self.impl))

proc gtk_accel_group_unlock(self: ptr AccelGroup00) {.
    importc, libprag.}

proc unlock*(self: AccelGroup) =
  gtk_accel_group_unlock(cast[ptr AccelGroup00](self.impl))

proc gtk_widget_remove_accelerator(self: ptr Widget00; accelGroup: ptr AccelGroup00;
    accelKey: uint32; accelMods: gdk.ModifierType): gboolean {.
    importc, libprag.}

proc removeAccelerator*(self: Widget; accelGroup: AccelGroup;
    accelKey: int; accelMods: gdk.ModifierType): bool =
  toBool(gtk_widget_remove_accelerator(cast[ptr Widget00](self.impl), cast[ptr AccelGroup00](accelGroup.impl), uint32(accelKey), accelMods))

proc gtk_widget_set_accel_path(self: ptr Widget00; accelPath: cstring; accelGroup: ptr AccelGroup00) {.
    importc, libprag.}

proc setAccelPath*(self: Widget; accelPath: cstring = nil; accelGroup: AccelGroup = nil) =
  gtk_widget_set_accel_path(cast[ptr Widget00](self.impl), accelPath, if accelGroup.isNil: nil else: cast[ptr AccelGroup00](accelGroup.impl))

proc gtk_window_add_accel_group(self: ptr Window00; accelGroup: ptr AccelGroup00) {.
    importc, libprag.}

proc addAccelGroup*(self: Window | PlugAccessible | WindowAccessible;
    accelGroup: AccelGroup) =
  gtk_window_add_accel_group(cast[ptr Window00](self.impl), cast[ptr AccelGroup00](accelGroup.impl))

proc gtk_window_remove_accel_group(self: ptr Window00; accelGroup: ptr AccelGroup00) {.
    importc, libprag.}

proc removeAccelGroup*(self: Window | PlugAccessible | WindowAccessible;
    accelGroup: AccelGroup) =
  gtk_window_remove_accel_group(cast[ptr Window00](self.impl), cast[ptr AccelGroup00](accelGroup.impl))

type
  AccelFlag* {.size: sizeof(cint), pure.} = enum
    visible = 0
    locked = 1

  AccelFlags* {.size: sizeof(cint).} = set[AccelFlag]

proc gtk_widget_add_accelerator(self: ptr Widget00; accelSignal: cstring;
    accelGroup: ptr AccelGroup00; accelKey: uint32; accelMods: gdk.ModifierType;
    accelFlags: AccelFlags) {.
    importc, libprag.}

proc addAccelerator*(self: Widget; accelSignal: cstring; accelGroup: AccelGroup;
    accelKey: int; accelMods: gdk.ModifierType; accelFlags: AccelFlags) =
  gtk_widget_add_accelerator(cast[ptr Widget00](self.impl), accelSignal, cast[ptr AccelGroup00](accelGroup.impl), uint32(accelKey), accelMods, accelFlags)

proc gtk_accel_group_connect(self: ptr AccelGroup00; accelKey: uint32; accelMods: gdk.ModifierType;
    accelFlags: AccelFlags; closure: ptr gobject.Closure00) {.
    importc, libprag.}

proc connect*(self: AccelGroup; accelKey: int; accelMods: gdk.ModifierType;
    accelFlags: AccelFlags; closure: gobject.Closure) =
  gtk_accel_group_connect(cast[ptr AccelGroup00](self.impl), uint32(accelKey), accelMods, accelFlags, cast[ptr gobject.Closure00](closure.impl))

type
  AccelGroupEntry00* {.pure.} = object
  AccelGroupEntry* = ref object
    impl*: ptr AccelGroupEntry00
    ignoreFinalizer*: bool

proc gtk_accel_group_query(self: ptr AccelGroup00; accelKey: uint32; accelMods: gdk.ModifierType;
    nEntries: var uint32): ptr AccelGroupEntry00 {.
    importc, libprag.}

proc query*(self: AccelGroup; accelKey: int; accelMods: gdk.ModifierType;
    nEntries: var int = cast[var int](nil)): ptr AccelGroupEntry00 =
  var nEntries_00: uint32
  let resul0 = gtk_accel_group_query(cast[ptr AccelGroup00](self.impl), uint32(accelKey), accelMods, nEntries_00)
  if resul0.isNil:
    return
  result = resul0
  if nEntries.addr != nil:
    nEntries = int(nEntries_00)

type
  Align* {.size: sizeof(cint), pure.} = enum
    fill = 0
    start = 1
    `end` = 2
    center = 3
    baseline = 4

proc gtk_widget_get_halign(self: ptr Widget00): Align {.
    importc, libprag.}

proc getHalign*(self: Widget): Align =
  gtk_widget_get_halign(cast[ptr Widget00](self.impl))

proc halign*(self: Widget): Align =
  gtk_widget_get_halign(cast[ptr Widget00](self.impl))

proc gtk_widget_get_valign(self: ptr Widget00): Align {.
    importc, libprag.}

proc getValign*(self: Widget): Align =
  gtk_widget_get_valign(cast[ptr Widget00](self.impl))

proc valign*(self: Widget): Align =
  gtk_widget_get_valign(cast[ptr Widget00](self.impl))

proc gtk_widget_get_valign_with_baseline(self: ptr Widget00): Align {.
    importc, libprag.}

proc getValignWithBaseline*(self: Widget): Align =
  gtk_widget_get_valign_with_baseline(cast[ptr Widget00](self.impl))

proc valignWithBaseline*(self: Widget): Align =
  gtk_widget_get_valign_with_baseline(cast[ptr Widget00](self.impl))

proc gtk_widget_set_halign(self: ptr Widget00; align: Align) {.
    importc, libprag.}

proc setHalign*(self: Widget; align: Align) =
  gtk_widget_set_halign(cast[ptr Widget00](self.impl), align)

proc `halign=`*(self: Widget; align: Align) =
  gtk_widget_set_halign(cast[ptr Widget00](self.impl), align)

proc gtk_widget_set_valign(self: ptr Widget00; align: Align) {.
    importc, libprag.}

proc setValign*(self: Widget; align: Align) =
  gtk_widget_set_valign(cast[ptr Widget00](self.impl), align)

proc `valign=`*(self: Widget; align: Align) =
  gtk_widget_set_valign(cast[ptr Widget00](self.impl), align)

type
  Requisition* {.pure, byRef.} = object
    width*: int32
    height*: int32

proc gtk_requisition_get_type*(): GType {.importc, libprag.}

proc gtk_requisition_free(self: Requisition) {.
    importc, libprag.}

proc free*(self: Requisition) =
  gtk_requisition_free(self)

proc gtk_requisition_copy(self: Requisition): ptr Requisition {.
    importc, libprag.}

proc copy*(self: Requisition): ptr Requisition =
  gtk_requisition_copy(self)

proc newRequisition*(): ptr Requisition {.
    importc: "gtk_requisition_new", libprag.}

proc gtk_widget_get_child_requisition(self: ptr Widget00; requisition: var Requisition) {.
    importc, libprag.}

proc getChildRequisition*(self: Widget; requisition: var Requisition) =
  gtk_widget_get_child_requisition(cast[ptr Widget00](self.impl), requisition)

proc getChildRequisition*(self: Widget): Requisition =
  gtk_widget_get_child_requisition(cast[ptr Widget00](self.impl), result)

proc gtk_widget_get_preferred_size(self: ptr Widget00; minimumSize: var Requisition;
    naturalSize: var Requisition) {.
    importc, libprag.}

proc getPreferredSize*(self: Widget; minimumSize: var Requisition = cast[var Requisition](nil);
    naturalSize: var Requisition = cast[var Requisition](nil)) =
  gtk_widget_get_preferred_size(cast[ptr Widget00](self.impl), minimumSize, naturalSize)

proc gtk_widget_get_requisition(self: ptr Widget00; requisition: var Requisition) {.
    importc, libprag.}

proc getRequisition*(self: Widget; requisition: var Requisition) =
  gtk_widget_get_requisition(cast[ptr Widget00](self.impl), requisition)

proc getRequisition*(self: Widget): Requisition =
  gtk_widget_get_requisition(cast[ptr Widget00](self.impl), result)

proc gtk_widget_size_request(self: ptr Widget00; requisition: var Requisition) {.
    importc, libprag.}

proc sizeRequest*(self: Widget; requisition: var Requisition) =
  gtk_widget_size_request(cast[ptr Widget00](self.impl), requisition)

proc sizeRequest*(self: Widget): Requisition =
  gtk_widget_size_request(cast[ptr Widget00](self.impl), result)

type
  WidgetPath00* {.pure.} = object
  WidgetPath* = ref object
    impl*: ptr WidgetPath00
    ignoreFinalizer*: bool

proc gtk_widget_path_get_type*(): GType {.importc, libprag.}

proc gBoxedFreeGtkWidgetPath*(self: WidgetPath) =
  if not self.ignoreFinalizer:
    boxedFree(gtk_widget_path_get_type(), cast[ptr WidgetPath00](self.impl))

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(WidgetPath()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    if not self.ignoreFinalizer and self.impl != nil:
      boxedFree(gtk_widget_path_get_type(), cast[ptr WidgetPath00](self.impl))
      self.impl = nil

proc newWithFinalizer*(x: var WidgetPath) =
  when defined(gcDestructors):
    new(x)
  else:
    new(x, gBoxedFreeGtkWidgetPath)

proc gtk_widget_path_free(self: ptr WidgetPath00) {.
    importc, libprag.}

proc free*(self: WidgetPath) =
  gtk_widget_path_free(cast[ptr WidgetPath00](self.impl))

proc finalizerfree*(self: WidgetPath) =
  if not self.ignoreFinalizer:
    gtk_widget_path_free(cast[ptr WidgetPath00](self.impl))

proc gtk_widget_path_append_for_widget(self: ptr WidgetPath00; widget: ptr Widget00): int32 {.
    importc, libprag.}

proc appendForWidget*(self: WidgetPath; widget: Widget): int =
  int(gtk_widget_path_append_for_widget(cast[ptr WidgetPath00](self.impl), cast[ptr Widget00](widget.impl)))

proc gtk_widget_path_append_type(self: ptr WidgetPath00; `type`: GType): int32 {.
    importc, libprag.}

proc appendType*(self: WidgetPath; `type`: GType): int =
  int(gtk_widget_path_append_type(cast[ptr WidgetPath00](self.impl), `type`))

proc gtk_widget_path_append_with_siblings(self: ptr WidgetPath00; siblings: ptr WidgetPath00;
    siblingIndex: uint32): int32 {.
    importc, libprag.}

proc appendWithSiblings*(self: WidgetPath; siblings: WidgetPath;
    siblingIndex: int): int =
  int(gtk_widget_path_append_with_siblings(cast[ptr WidgetPath00](self.impl), cast[ptr WidgetPath00](siblings.impl), uint32(siblingIndex)))

proc gtk_widget_path_copy(self: ptr WidgetPath00): ptr WidgetPath00 {.
    importc, libprag.}

proc copy*(self: WidgetPath): WidgetPath =
  fnew(result, gBoxedFreeGtkWidgetPath)
  result.impl = gtk_widget_path_copy(cast[ptr WidgetPath00](self.impl))

proc gtk_widget_path_new(): ptr WidgetPath00 {.
    importc, libprag.}

proc newWidgetPath*(): WidgetPath =
  fnew(result, gBoxedFreeGtkWidgetPath)
  result.impl = gtk_widget_path_new()

proc newWidgetPath*(tdesc: typedesc): tdesc =
  assert(result is WidgetPath)
  fnew(result, gBoxedFreeGtkWidgetPath)
  result.impl = gtk_widget_path_new()

proc initWidgetPath*[T](result: var T) {.deprecated.} =
  assert(result is WidgetPath)
  fnew(result, gBoxedFreeGtkWidgetPath)
  result.impl = gtk_widget_path_new()

proc gtk_widget_path_get_object_type(self: ptr WidgetPath00): GType {.
    importc, libprag.}

proc getObjectType*(self: WidgetPath): GType =
  gtk_widget_path_get_object_type(cast[ptr WidgetPath00](self.impl))

proc objectType*(self: WidgetPath): GType =
  gtk_widget_path_get_object_type(cast[ptr WidgetPath00](self.impl))

proc gtk_widget_path_has_parent(self: ptr WidgetPath00; `type`: GType): gboolean {.
    importc, libprag.}

proc hasParent*(self: WidgetPath; `type`: GType): bool =
  toBool(gtk_widget_path_has_parent(cast[ptr WidgetPath00](self.impl), `type`))

proc gtk_widget_path_is_type(self: ptr WidgetPath00; `type`: GType): gboolean {.
    importc, libprag.}

proc isType*(self: WidgetPath; `type`: GType): bool =
  toBool(gtk_widget_path_is_type(cast[ptr WidgetPath00](self.impl), `type`))

proc gtk_widget_path_iter_add_class(self: ptr WidgetPath00; pos: int32; name: cstring) {.
    importc, libprag.}

proc iterAddClass*(self: WidgetPath; pos: int; name: cstring) =
  gtk_widget_path_iter_add_class(cast[ptr WidgetPath00](self.impl), int32(pos), name)

proc gtk_widget_path_iter_add_region(self: ptr WidgetPath00; pos: int32;
    name: cstring; flags: RegionFlags) {.
    importc, libprag.}

proc iterAddRegion*(self: WidgetPath; pos: int; name: cstring;
    flags: RegionFlags) =
  gtk_widget_path_iter_add_region(cast[ptr WidgetPath00](self.impl), int32(pos), name, flags)

proc gtk_widget_path_iter_clear_classes(self: ptr WidgetPath00; pos: int32) {.
    importc, libprag.}

proc iterClearClasses*(self: WidgetPath; pos: int) =
  gtk_widget_path_iter_clear_classes(cast[ptr WidgetPath00](self.impl), int32(pos))

proc gtk_widget_path_iter_clear_regions(self: ptr WidgetPath00; pos: int32) {.
    importc, libprag.}

proc iterClearRegions*(self: WidgetPath; pos: int) =
  gtk_widget_path_iter_clear_regions(cast[ptr WidgetPath00](self.impl), int32(pos))

proc gtk_widget_path_iter_get_name(self: ptr WidgetPath00; pos: int32): cstring {.
    importc, libprag.}

proc iterGetName*(self: WidgetPath; pos: int): string =
  let resul0 = gtk_widget_path_iter_get_name(cast[ptr WidgetPath00](self.impl), int32(pos))
  if resul0.isNil:
    return
  result = $resul0

proc gtk_widget_path_iter_get_object_name(self: ptr WidgetPath00; pos: int32): cstring {.
    importc, libprag.}

proc iterGetObjectName*(self: WidgetPath; pos: int): string =
  let resul0 = gtk_widget_path_iter_get_object_name(cast[ptr WidgetPath00](self.impl), int32(pos))
  if resul0.isNil:
    return
  result = $resul0

proc gtk_widget_path_iter_get_object_type(self: ptr WidgetPath00; pos: int32): GType {.
    importc, libprag.}

proc iterGetObjectType*(self: WidgetPath; pos: int): GType =
  gtk_widget_path_iter_get_object_type(cast[ptr WidgetPath00](self.impl), int32(pos))

proc gtk_widget_path_iter_get_sibling_index(self: ptr WidgetPath00; pos: int32): uint32 {.
    importc, libprag.}

proc iterGetSiblingIndex*(self: WidgetPath; pos: int): int =
  int(gtk_widget_path_iter_get_sibling_index(cast[ptr WidgetPath00](self.impl), int32(pos)))

proc gtk_widget_path_iter_get_siblings(self: ptr WidgetPath00; pos: int32): ptr WidgetPath00 {.
    importc, libprag.}

proc iterGetSiblings*(self: WidgetPath; pos: int): WidgetPath =
  fnew(result, gBoxedFreeGtkWidgetPath)
  result.impl = gtk_widget_path_iter_get_siblings(cast[ptr WidgetPath00](self.impl), int32(pos))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(gtk_widget_path_get_type(), result.impl))

proc gtk_widget_path_iter_get_state(self: ptr WidgetPath00; pos: int32): StateFlags {.
    importc, libprag.}

proc iterGetState*(self: WidgetPath; pos: int): StateFlags =
  gtk_widget_path_iter_get_state(cast[ptr WidgetPath00](self.impl), int32(pos))

proc gtk_widget_path_iter_has_class(self: ptr WidgetPath00; pos: int32; name: cstring): gboolean {.
    importc, libprag.}

proc iterHasClass*(self: WidgetPath; pos: int; name: cstring): bool =
  toBool(gtk_widget_path_iter_has_class(cast[ptr WidgetPath00](self.impl), int32(pos), name))

proc gtk_widget_path_iter_has_name(self: ptr WidgetPath00; pos: int32; name: cstring): gboolean {.
    importc, libprag.}

proc iterHasName*(self: WidgetPath; pos: int; name: cstring): bool =
  toBool(gtk_widget_path_iter_has_name(cast[ptr WidgetPath00](self.impl), int32(pos), name))

proc gtk_widget_path_iter_has_qclass(self: ptr WidgetPath00; pos: int32;
    qname: uint32): gboolean {.
    importc, libprag.}

proc iterHasQclass*(self: WidgetPath; pos: int; qname: int): bool =
  toBool(gtk_widget_path_iter_has_qclass(cast[ptr WidgetPath00](self.impl), int32(pos), uint32(qname)))

proc gtk_widget_path_iter_has_qname(self: ptr WidgetPath00; pos: int32; qname: uint32): gboolean {.
    importc, libprag.}

proc iterHasQname*(self: WidgetPath; pos: int; qname: int): bool =
  toBool(gtk_widget_path_iter_has_qname(cast[ptr WidgetPath00](self.impl), int32(pos), uint32(qname)))

proc gtk_widget_path_iter_has_qregion(self: ptr WidgetPath00; pos: int32;
    qname: uint32; flags: var RegionFlags): gboolean {.
    importc, libprag.}

proc iterHasQregion*(self: WidgetPath; pos: int; qname: int;
    flags: var RegionFlags): bool =
  toBool(gtk_widget_path_iter_has_qregion(cast[ptr WidgetPath00](self.impl), int32(pos), uint32(qname), flags))

proc gtk_widget_path_iter_has_region(self: ptr WidgetPath00; pos: int32;
    name: cstring; flags: var RegionFlags): gboolean {.
    importc, libprag.}

proc iterHasRegion*(self: WidgetPath; pos: int; name: cstring;
    flags: var RegionFlags): bool =
  toBool(gtk_widget_path_iter_has_region(cast[ptr WidgetPath00](self.impl), int32(pos), name, flags))

proc gtk_widget_path_iter_list_classes(self: ptr WidgetPath00; pos: int32): ptr glib.SList {.
    importc, libprag.}

proc iterListClasses*(self: WidgetPath; pos: int): seq[cstring] =
  let resul0 = gtk_widget_path_iter_list_classes(cast[ptr WidgetPath00](self.impl), int32(pos))
  g_slist_free(resul0)

proc gtk_widget_path_iter_list_regions(self: ptr WidgetPath00; pos: int32): ptr glib.SList {.
    importc, libprag.}

proc iterListRegions*(self: WidgetPath; pos: int): seq[cstring] =
  let resul0 = gtk_widget_path_iter_list_regions(cast[ptr WidgetPath00](self.impl), int32(pos))
  g_slist_free(resul0)

proc gtk_widget_path_iter_remove_class(self: ptr WidgetPath00; pos: int32;
    name: cstring) {.
    importc, libprag.}

proc iterRemoveClass*(self: WidgetPath; pos: int; name: cstring) =
  gtk_widget_path_iter_remove_class(cast[ptr WidgetPath00](self.impl), int32(pos), name)

proc gtk_widget_path_iter_remove_region(self: ptr WidgetPath00; pos: int32;
    name: cstring) {.
    importc, libprag.}

proc iterRemoveRegion*(self: WidgetPath; pos: int; name: cstring) =
  gtk_widget_path_iter_remove_region(cast[ptr WidgetPath00](self.impl), int32(pos), name)

proc gtk_widget_path_iter_set_name(self: ptr WidgetPath00; pos: int32; name: cstring) {.
    importc, libprag.}

proc iterSetName*(self: WidgetPath; pos: int; name: cstring) =
  gtk_widget_path_iter_set_name(cast[ptr WidgetPath00](self.impl), int32(pos), name)

proc gtk_widget_path_iter_set_object_name(self: ptr WidgetPath00; pos: int32;
    name: cstring) {.
    importc, libprag.}

proc iterSetObjectName*(self: WidgetPath; pos: int; name: cstring = nil) =
  gtk_widget_path_iter_set_object_name(cast[ptr WidgetPath00](self.impl), int32(pos), name)

proc gtk_widget_path_iter_set_object_type(self: ptr WidgetPath00; pos: int32;
    `type`: GType) {.
    importc, libprag.}

proc iterSetObjectType*(self: WidgetPath; pos: int; `type`: GType) =
  gtk_widget_path_iter_set_object_type(cast[ptr WidgetPath00](self.impl), int32(pos), `type`)

proc gtk_widget_path_iter_set_state(self: ptr WidgetPath00; pos: int32; state: StateFlags) {.
    importc, libprag.}

proc iterSetState*(self: WidgetPath; pos: int; state: StateFlags) =
  gtk_widget_path_iter_set_state(cast[ptr WidgetPath00](self.impl), int32(pos), state)

proc gtk_widget_path_length(self: ptr WidgetPath00): int32 {.
    importc, libprag.}

proc length*(self: WidgetPath): int =
  int(gtk_widget_path_length(cast[ptr WidgetPath00](self.impl)))

proc gtk_widget_path_prepend_type(self: ptr WidgetPath00; `type`: GType) {.
    importc, libprag.}

proc prependType*(self: WidgetPath; `type`: GType) =
  gtk_widget_path_prepend_type(cast[ptr WidgetPath00](self.impl), `type`)

proc gtk_widget_path_ref(self: ptr WidgetPath00): ptr WidgetPath00 {.
    importc, libprag.}

proc `ref`*(self: WidgetPath): WidgetPath =
  fnew(result, gBoxedFreeGtkWidgetPath)
  result.impl = gtk_widget_path_ref(cast[ptr WidgetPath00](self.impl))

proc gtk_widget_path_to_string(self: ptr WidgetPath00): cstring {.
    importc, libprag.}

proc toString*(self: WidgetPath): string =
  let resul0 = gtk_widget_path_to_string(cast[ptr WidgetPath00](self.impl))
  result = $resul0
  cogfree(resul0)

proc gtk_widget_path_unref(self: ptr WidgetPath00) {.
    importc, libprag.}

proc unref*(self: WidgetPath) =
  gtk_widget_path_unref(cast[ptr WidgetPath00](self.impl))

proc finalizerunref*(self: WidgetPath) =
  if not self.ignoreFinalizer:
    gtk_widget_path_unref(cast[ptr WidgetPath00](self.impl))

proc gtk_widget_get_path(self: ptr Widget00): ptr WidgetPath00 {.
    importc, libprag.}

proc getPath*(self: Widget): WidgetPath =
  fnew(result, gBoxedFreeGtkWidgetPath)
  result.impl = gtk_widget_get_path(cast[ptr Widget00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(gtk_widget_path_get_type(), result.impl))

proc path*(self: Widget): WidgetPath =
  fnew(result, gBoxedFreeGtkWidgetPath)
  result.impl = gtk_widget_get_path(cast[ptr Widget00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(gtk_widget_path_get_type(), result.impl))

proc gtk_container_get_path_for_child(self: ptr Container00; child: ptr Widget00): ptr WidgetPath00 {.
    importc, libprag.}

proc getPathForChild*(self: Container; child: Widget): WidgetPath =
  fnew(result, gBoxedFreeGtkWidgetPath)
  result.impl = gtk_container_get_path_for_child(cast[ptr Container00](self.impl), cast[ptr Widget00](child.impl))

proc gtk_style_context_get_path(self: ptr StyleContext00): ptr WidgetPath00 {.
    importc, libprag.}

proc getPath*(self: StyleContext): WidgetPath =
  fnew(result, gBoxedFreeGtkWidgetPath)
  result.impl = gtk_style_context_get_path(cast[ptr StyleContext00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(gtk_widget_path_get_type(), result.impl))

proc path*(self: StyleContext): WidgetPath =
  fnew(result, gBoxedFreeGtkWidgetPath)
  result.impl = gtk_style_context_get_path(cast[ptr StyleContext00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(gtk_widget_path_get_type(), result.impl))

proc gtk_style_context_set_path(self: ptr StyleContext00; path: ptr WidgetPath00) {.
    importc, libprag.}

proc setPath*(self: StyleContext; path: WidgetPath) =
  gtk_style_context_set_path(cast[ptr StyleContext00](self.impl), cast[ptr WidgetPath00](path.impl))

proc `path=`*(self: StyleContext; path: WidgetPath) =
  gtk_style_context_set_path(cast[ptr StyleContext00](self.impl), cast[ptr WidgetPath00](path.impl))

proc gtk_style_provider_get_style(self: ptr StyleProvider00; path: ptr WidgetPath00): ptr StyleProperties00 {.
    importc, libprag.}

proc getStyle*(self: StyleProvider | StyleProperties | CssProvider | Settings;
    path: WidgetPath): StyleProperties =
  let gobj = gtk_style_provider_get_style(cast[ptr StyleProvider00](self.impl), cast[ptr WidgetPath00](path.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_style_provider_get_style_property(self: ptr StyleProvider00; path: ptr WidgetPath00;
    state: StateFlags; pspec: ptr gobject.ParamSpec00; value: var gobject.Value): gboolean {.
    importc, libprag.}

proc getStyleProperty*(self: StyleProvider | StyleProperties | CssProvider | Settings;
    path: WidgetPath; state: StateFlags; pspec: gobject.ParamSpec; value: var gobject.Value): bool =
  toBool(gtk_style_provider_get_style_property(cast[ptr StyleProvider00](self.impl), cast[ptr WidgetPath00](path.impl), state, cast[ptr gobject.ParamSpec00](pspec.impl), value))

type
  IconFactory* = ref object of gobject.Object
  IconFactory00* = object of gobject.Object00

proc gtk_icon_factory_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(IconFactory()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_icon_factory_new(): ptr IconFactory00 {.
    importc, libprag.}

proc newIconFactory*(): IconFactory {.deprecated.}  =
  let gobj = gtk_icon_factory_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newIconFactory*(tdesc: typedesc): tdesc {.deprecated.}  =
  assert(result is IconFactory)
  let gobj = gtk_icon_factory_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initIconFactory*[T](result: var T) {.deprecated.} =
  assert(result is IconFactory)
  let gobj = gtk_icon_factory_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_icon_factory_lookup_default(stockId: cstring): ptr IconSet00 {.
    importc, libprag.}

proc lookupDefault*(stockId: cstring): IconSet =
  fnew(result, gBoxedFreeGtkIconSet)
  result.impl = gtk_icon_factory_lookup_default(stockId)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(gtk_icon_set_get_type(), result.impl))

proc gtk_icon_factory_add(self: ptr IconFactory00; stockId: cstring; iconSet: ptr IconSet00) {.
    importc, libprag.}

proc add*(self: IconFactory; stockId: cstring; iconSet: IconSet) =
  gtk_icon_factory_add(cast[ptr IconFactory00](self.impl), stockId, cast[ptr IconSet00](iconSet.impl))

proc gtk_icon_factory_add_default(self: ptr IconFactory00) {.
    importc, libprag.}

proc addDefault*(self: IconFactory) =
  gtk_icon_factory_add_default(cast[ptr IconFactory00](self.impl))

proc gtk_icon_factory_lookup(self: ptr IconFactory00; stockId: cstring): ptr IconSet00 {.
    importc, libprag.}

proc lookup*(self: IconFactory; stockId: cstring): IconSet =
  fnew(result, gBoxedFreeGtkIconSet)
  result.impl = gtk_icon_factory_lookup(cast[ptr IconFactory00](self.impl), stockId)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(gtk_icon_set_get_type(), result.impl))

proc gtk_icon_factory_remove_default(self: ptr IconFactory00) {.
    importc, libprag.}

proc removeDefault*(self: IconFactory) =
  gtk_icon_factory_remove_default(cast[ptr IconFactory00](self.impl))

proc gtk_style_provider_get_icon_factory(self: ptr StyleProvider00; path: ptr WidgetPath00): ptr IconFactory00 {.
    importc, libprag.}

proc getIconFactory*(self: StyleProvider | StyleProperties | CssProvider | Settings;
    path: WidgetPath): IconFactory =
  let gobj = gtk_style_provider_get_icon_factory(cast[ptr StyleProvider00](self.impl), cast[ptr WidgetPath00](path.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  Adjustment* = ref object of gobject.InitiallyUnowned
  Adjustment00* = object of gobject.InitiallyUnowned00

proc gtk_adjustment_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Adjustment()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scChanged*(self: Adjustment;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "changed", cast[GCallback](p), xdata, nil, cf)

proc scValueChanged*(self: Adjustment;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "value-changed", cast[GCallback](p), xdata, nil, cf)

proc gtk_adjustment_new(value: cdouble; lower: cdouble; upper: cdouble; stepIncrement: cdouble;
    pageIncrement: cdouble; pageSize: cdouble): ptr Adjustment00 {.
    importc, libprag.}

proc newAdjustment*(value: cdouble; lower: cdouble; upper: cdouble; stepIncrement: cdouble;
    pageIncrement: cdouble; pageSize: cdouble = 1.0): Adjustment =
  let gobj = gtk_adjustment_new(value, lower, upper, stepIncrement, pageIncrement, pageSize)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newAdjustment*(tdesc: typedesc; value: cdouble; lower: cdouble; upper: cdouble; stepIncrement: cdouble;
    pageIncrement: cdouble; pageSize: cdouble = 1.0): tdesc =
  assert(result is Adjustment)
  let gobj = gtk_adjustment_new(value, lower, upper, stepIncrement, pageIncrement, pageSize)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initAdjustment*[T](result: var T; value: cdouble; lower: cdouble; upper: cdouble; stepIncrement: cdouble;
    pageIncrement: cdouble; pageSize: cdouble = 1.0) {.deprecated.} =
  assert(result is Adjustment)
  let gobj = gtk_adjustment_new(value, lower, upper, stepIncrement, pageIncrement, pageSize)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_adjustment_changed(self: ptr Adjustment00) {.
    importc, libprag.}

proc changed*(self: Adjustment) =
  gtk_adjustment_changed(cast[ptr Adjustment00](self.impl))

proc gtk_adjustment_clamp_page(self: ptr Adjustment00; lower: cdouble; upper: cdouble) {.
    importc, libprag.}

proc clampPage*(self: Adjustment; lower: cdouble; upper: cdouble) =
  gtk_adjustment_clamp_page(cast[ptr Adjustment00](self.impl), lower, upper)

proc gtk_adjustment_configure(self: ptr Adjustment00; value: cdouble; lower: cdouble;
    upper: cdouble; stepIncrement: cdouble; pageIncrement: cdouble; pageSize: cdouble) {.
    importc, libprag.}

proc configure*(self: Adjustment; value: cdouble; lower: cdouble;
    upper: cdouble; stepIncrement: cdouble; pageIncrement: cdouble; pageSize: cdouble) =
  gtk_adjustment_configure(cast[ptr Adjustment00](self.impl), value, lower, upper, stepIncrement, pageIncrement, pageSize)

proc gtk_adjustment_get_lower(self: ptr Adjustment00): cdouble {.
    importc, libprag.}

proc getLower*(self: Adjustment): cdouble =
  gtk_adjustment_get_lower(cast[ptr Adjustment00](self.impl))

proc lower*(self: Adjustment): cdouble =
  gtk_adjustment_get_lower(cast[ptr Adjustment00](self.impl))

proc gtk_adjustment_get_minimum_increment(self: ptr Adjustment00): cdouble {.
    importc, libprag.}

proc getMinimumIncrement*(self: Adjustment): cdouble =
  gtk_adjustment_get_minimum_increment(cast[ptr Adjustment00](self.impl))

proc minimumIncrement*(self: Adjustment): cdouble =
  gtk_adjustment_get_minimum_increment(cast[ptr Adjustment00](self.impl))

proc gtk_adjustment_get_page_increment(self: ptr Adjustment00): cdouble {.
    importc, libprag.}

proc getPageIncrement*(self: Adjustment): cdouble =
  gtk_adjustment_get_page_increment(cast[ptr Adjustment00](self.impl))

proc pageIncrement*(self: Adjustment): cdouble =
  gtk_adjustment_get_page_increment(cast[ptr Adjustment00](self.impl))

proc gtk_adjustment_get_page_size(self: ptr Adjustment00): cdouble {.
    importc, libprag.}

proc getPageSize*(self: Adjustment): cdouble =
  gtk_adjustment_get_page_size(cast[ptr Adjustment00](self.impl))

proc pageSize*(self: Adjustment): cdouble =
  gtk_adjustment_get_page_size(cast[ptr Adjustment00](self.impl))

proc gtk_adjustment_get_step_increment(self: ptr Adjustment00): cdouble {.
    importc, libprag.}

proc getStepIncrement*(self: Adjustment): cdouble =
  gtk_adjustment_get_step_increment(cast[ptr Adjustment00](self.impl))

proc stepIncrement*(self: Adjustment): cdouble =
  gtk_adjustment_get_step_increment(cast[ptr Adjustment00](self.impl))

proc gtk_adjustment_get_upper(self: ptr Adjustment00): cdouble {.
    importc, libprag.}

proc getUpper*(self: Adjustment): cdouble =
  gtk_adjustment_get_upper(cast[ptr Adjustment00](self.impl))

proc upper*(self: Adjustment): cdouble =
  gtk_adjustment_get_upper(cast[ptr Adjustment00](self.impl))

proc gtk_adjustment_get_value(self: ptr Adjustment00): cdouble {.
    importc, libprag.}

proc getValue*(self: Adjustment): cdouble =
  gtk_adjustment_get_value(cast[ptr Adjustment00](self.impl))

proc value*(self: Adjustment): cdouble =
  gtk_adjustment_get_value(cast[ptr Adjustment00](self.impl))

proc gtk_adjustment_set_lower(self: ptr Adjustment00; lower: cdouble) {.
    importc, libprag.}

proc setLower*(self: Adjustment; lower: cdouble) =
  gtk_adjustment_set_lower(cast[ptr Adjustment00](self.impl), lower)

proc `lower=`*(self: Adjustment; lower: cdouble) =
  gtk_adjustment_set_lower(cast[ptr Adjustment00](self.impl), lower)

proc gtk_adjustment_set_page_increment(self: ptr Adjustment00; pageIncrement: cdouble) {.
    importc, libprag.}

proc setPageIncrement*(self: Adjustment; pageIncrement: cdouble) =
  gtk_adjustment_set_page_increment(cast[ptr Adjustment00](self.impl), pageIncrement)

proc `pageIncrement=`*(self: Adjustment; pageIncrement: cdouble) =
  gtk_adjustment_set_page_increment(cast[ptr Adjustment00](self.impl), pageIncrement)

proc gtk_adjustment_set_page_size(self: ptr Adjustment00; pageSize: cdouble) {.
    importc, libprag.}

proc setPageSize*(self: Adjustment; pageSize: cdouble) =
  gtk_adjustment_set_page_size(cast[ptr Adjustment00](self.impl), pageSize)

proc `pageSize=`*(self: Adjustment; pageSize: cdouble) =
  gtk_adjustment_set_page_size(cast[ptr Adjustment00](self.impl), pageSize)

proc gtk_adjustment_set_step_increment(self: ptr Adjustment00; stepIncrement: cdouble) {.
    importc, libprag.}

proc setStepIncrement*(self: Adjustment; stepIncrement: cdouble) =
  gtk_adjustment_set_step_increment(cast[ptr Adjustment00](self.impl), stepIncrement)

proc `stepIncrement=`*(self: Adjustment; stepIncrement: cdouble) =
  gtk_adjustment_set_step_increment(cast[ptr Adjustment00](self.impl), stepIncrement)

proc gtk_adjustment_set_upper(self: ptr Adjustment00; upper: cdouble) {.
    importc, libprag.}

proc setUpper*(self: Adjustment; upper: cdouble) =
  gtk_adjustment_set_upper(cast[ptr Adjustment00](self.impl), upper)

proc `upper=`*(self: Adjustment; upper: cdouble) =
  gtk_adjustment_set_upper(cast[ptr Adjustment00](self.impl), upper)

proc gtk_adjustment_set_value(self: ptr Adjustment00; value: cdouble) {.
    importc, libprag.}

proc setValue*(self: Adjustment; value: cdouble) =
  gtk_adjustment_set_value(cast[ptr Adjustment00](self.impl), value)

proc `value=`*(self: Adjustment; value: cdouble) =
  gtk_adjustment_set_value(cast[ptr Adjustment00](self.impl), value)

proc gtk_adjustment_value_changed(self: ptr Adjustment00) {.
    importc, libprag.}

proc valueChanged*(self: Adjustment) =
  gtk_adjustment_value_changed(cast[ptr Adjustment00](self.impl))

proc gtk_container_get_focus_hadjustment(self: ptr Container00): ptr Adjustment00 {.
    importc, libprag.}

proc getFocusHadjustment*(self: Container): Adjustment =
  let gobj = gtk_container_get_focus_hadjustment(cast[ptr Container00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc focusHadjustment*(self: Container): Adjustment =
  let gobj = gtk_container_get_focus_hadjustment(cast[ptr Container00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_container_get_focus_vadjustment(self: ptr Container00): ptr Adjustment00 {.
    importc, libprag.}

proc getFocusVadjustment*(self: Container): Adjustment =
  let gobj = gtk_container_get_focus_vadjustment(cast[ptr Container00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc focusVadjustment*(self: Container): Adjustment =
  let gobj = gtk_container_get_focus_vadjustment(cast[ptr Container00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_container_set_focus_hadjustment(self: ptr Container00; adjustment: ptr Adjustment00) {.
    importc, libprag.}

proc setFocusHadjustment*(self: Container; adjustment: Adjustment) =
  gtk_container_set_focus_hadjustment(cast[ptr Container00](self.impl), cast[ptr Adjustment00](adjustment.impl))

proc `focusHadjustment=`*(self: Container; adjustment: Adjustment) =
  gtk_container_set_focus_hadjustment(cast[ptr Container00](self.impl), cast[ptr Adjustment00](adjustment.impl))

proc gtk_container_set_focus_vadjustment(self: ptr Container00; adjustment: ptr Adjustment00) {.
    importc, libprag.}

proc setFocusVadjustment*(self: Container; adjustment: Adjustment) =
  gtk_container_set_focus_vadjustment(cast[ptr Container00](self.impl), cast[ptr Adjustment00](adjustment.impl))

proc `focusVadjustment=`*(self: Container; adjustment: Adjustment) =
  gtk_container_set_focus_vadjustment(cast[ptr Container00](self.impl), cast[ptr Adjustment00](adjustment.impl))

type
  ResizeMode* {.size: sizeof(cint), pure.} = enum
    parent = 0
    queue = 1
    immediate = 2

proc gtk_container_get_resize_mode(self: ptr Container00): ResizeMode {.
    importc, libprag.}

proc getResizeMode*(self: Container): ResizeMode =
  gtk_container_get_resize_mode(cast[ptr Container00](self.impl))

proc resizeMode*(self: Container): ResizeMode =
  gtk_container_get_resize_mode(cast[ptr Container00](self.impl))

proc gtk_container_set_resize_mode(self: ptr Container00; resizeMode: ResizeMode) {.
    importc, libprag.}

proc setResizeMode*(self: Container; resizeMode: ResizeMode) =
  gtk_container_set_resize_mode(cast[ptr Container00](self.impl), resizeMode)

proc `resizeMode=`*(self: Container; resizeMode: ResizeMode) =
  gtk_container_set_resize_mode(cast[ptr Container00](self.impl), resizeMode)

type
  TextIter* {.pure, byRef.} = object
    dummy1*: pointer
    dummy2*: pointer
    dummy3*: int32
    dummy4*: int32
    dummy5*: int32
    dummy6*: int32
    dummy7*: int32
    dummy8*: int32
    dummy9*: pointer
    dummy10*: pointer
    dummy11*: int32
    dummy12*: int32
    dummy13*: int32
    dummy14*: pointer

proc gtk_text_iter_get_type*(): GType {.importc, libprag.}

proc gtk_text_iter_free(self: TextIter) {.
    importc, libprag.}

proc free*(self: TextIter) =
  gtk_text_iter_free(self)

proc gtk_text_iter_backward_char(self: TextIter): gboolean {.
    importc, libprag.}

proc backwardChar*(self: TextIter): bool =
  toBool(gtk_text_iter_backward_char(self))

proc gtk_text_iter_backward_chars(self: TextIter; count: int32): gboolean {.
    importc, libprag.}

proc backwardChars*(self: TextIter; count: int): bool =
  toBool(gtk_text_iter_backward_chars(self, int32(count)))

proc gtk_text_iter_backward_cursor_position(self: TextIter): gboolean {.
    importc, libprag.}

proc backwardCursorPosition*(self: TextIter): bool =
  toBool(gtk_text_iter_backward_cursor_position(self))

proc gtk_text_iter_backward_cursor_positions(self: TextIter; count: int32): gboolean {.
    importc, libprag.}

proc backwardCursorPositions*(self: TextIter; count: int): bool =
  toBool(gtk_text_iter_backward_cursor_positions(self, int32(count)))

proc gtk_text_iter_backward_line(self: TextIter): gboolean {.
    importc, libprag.}

proc backwardLine*(self: TextIter): bool =
  toBool(gtk_text_iter_backward_line(self))

proc gtk_text_iter_backward_lines(self: TextIter; count: int32): gboolean {.
    importc, libprag.}

proc backwardLines*(self: TextIter; count: int): bool =
  toBool(gtk_text_iter_backward_lines(self, int32(count)))

proc gtk_text_iter_backward_sentence_start(self: TextIter): gboolean {.
    importc, libprag.}

proc backwardSentenceStart*(self: TextIter): bool =
  toBool(gtk_text_iter_backward_sentence_start(self))

proc gtk_text_iter_backward_sentence_starts(self: TextIter; count: int32): gboolean {.
    importc, libprag.}

proc backwardSentenceStarts*(self: TextIter; count: int): bool =
  toBool(gtk_text_iter_backward_sentence_starts(self, int32(count)))

proc gtk_text_iter_backward_visible_cursor_position(self: TextIter): gboolean {.
    importc, libprag.}

proc backwardVisibleCursorPosition*(self: TextIter): bool =
  toBool(gtk_text_iter_backward_visible_cursor_position(self))

proc gtk_text_iter_backward_visible_cursor_positions(self: TextIter; count: int32): gboolean {.
    importc, libprag.}

proc backwardVisibleCursorPositions*(self: TextIter; count: int): bool =
  toBool(gtk_text_iter_backward_visible_cursor_positions(self, int32(count)))

proc gtk_text_iter_backward_visible_line(self: TextIter): gboolean {.
    importc, libprag.}

proc backwardVisibleLine*(self: TextIter): bool =
  toBool(gtk_text_iter_backward_visible_line(self))

proc gtk_text_iter_backward_visible_lines(self: TextIter; count: int32): gboolean {.
    importc, libprag.}

proc backwardVisibleLines*(self: TextIter; count: int): bool =
  toBool(gtk_text_iter_backward_visible_lines(self, int32(count)))

proc gtk_text_iter_backward_visible_word_start(self: TextIter): gboolean {.
    importc, libprag.}

proc backwardVisibleWordStart*(self: TextIter): bool =
  toBool(gtk_text_iter_backward_visible_word_start(self))

proc gtk_text_iter_backward_visible_word_starts(self: TextIter; count: int32): gboolean {.
    importc, libprag.}

proc backwardVisibleWordStarts*(self: TextIter; count: int): bool =
  toBool(gtk_text_iter_backward_visible_word_starts(self, int32(count)))

proc gtk_text_iter_backward_word_start(self: TextIter): gboolean {.
    importc, libprag.}

proc backwardWordStart*(self: TextIter): bool =
  toBool(gtk_text_iter_backward_word_start(self))

proc gtk_text_iter_backward_word_starts(self: TextIter; count: int32): gboolean {.
    importc, libprag.}

proc backwardWordStarts*(self: TextIter; count: int): bool =
  toBool(gtk_text_iter_backward_word_starts(self, int32(count)))

proc gtk_text_iter_can_insert(self: TextIter; defaultEditability: gboolean): gboolean {.
    importc, libprag.}

proc canInsert*(self: TextIter; defaultEditability: bool): bool =
  toBool(gtk_text_iter_can_insert(self, gboolean(defaultEditability)))

proc gtk_text_iter_compare(self: TextIter; rhs: TextIter): int32 {.
    importc, libprag.}

proc compare*(self: TextIter; rhs: TextIter): int =
  int(gtk_text_iter_compare(self, rhs))

proc gtk_text_iter_editable(self: TextIter; defaultSetting: gboolean): gboolean {.
    importc, libprag.}

proc editable*(self: TextIter; defaultSetting: bool): bool =
  toBool(gtk_text_iter_editable(self, gboolean(defaultSetting)))

proc gtk_text_iter_ends_line(self: TextIter): gboolean {.
    importc, libprag.}

proc endsLine*(self: TextIter): bool =
  toBool(gtk_text_iter_ends_line(self))

proc gtk_text_iter_ends_sentence(self: TextIter): gboolean {.
    importc, libprag.}

proc endsSentence*(self: TextIter): bool =
  toBool(gtk_text_iter_ends_sentence(self))

proc gtk_text_iter_ends_word(self: TextIter): gboolean {.
    importc, libprag.}

proc endsWord*(self: TextIter): bool =
  toBool(gtk_text_iter_ends_word(self))

proc gtk_text_iter_equal(self: TextIter; rhs: TextIter): gboolean {.
    importc, libprag.}

proc equal*(self: TextIter; rhs: TextIter): bool =
  toBool(gtk_text_iter_equal(self, rhs))

proc gtk_text_iter_forward_char(self: TextIter): gboolean {.
    importc, libprag.}

proc forwardChar*(self: TextIter): bool =
  toBool(gtk_text_iter_forward_char(self))

proc gtk_text_iter_forward_chars(self: TextIter; count: int32): gboolean {.
    importc, libprag.}

proc forwardChars*(self: TextIter; count: int): bool =
  toBool(gtk_text_iter_forward_chars(self, int32(count)))

proc gtk_text_iter_forward_cursor_position(self: TextIter): gboolean {.
    importc, libprag.}

proc forwardCursorPosition*(self: TextIter): bool =
  toBool(gtk_text_iter_forward_cursor_position(self))

proc gtk_text_iter_forward_cursor_positions(self: TextIter; count: int32): gboolean {.
    importc, libprag.}

proc forwardCursorPositions*(self: TextIter; count: int): bool =
  toBool(gtk_text_iter_forward_cursor_positions(self, int32(count)))

proc gtk_text_iter_forward_line(self: TextIter): gboolean {.
    importc, libprag.}

proc forwardLine*(self: TextIter): bool =
  toBool(gtk_text_iter_forward_line(self))

proc gtk_text_iter_forward_lines(self: TextIter; count: int32): gboolean {.
    importc, libprag.}

proc forwardLines*(self: TextIter; count: int): bool =
  toBool(gtk_text_iter_forward_lines(self, int32(count)))

proc gtk_text_iter_forward_sentence_end(self: TextIter): gboolean {.
    importc, libprag.}

proc forwardSentenceEnd*(self: TextIter): bool =
  toBool(gtk_text_iter_forward_sentence_end(self))

proc gtk_text_iter_forward_sentence_ends(self: TextIter; count: int32): gboolean {.
    importc, libprag.}

proc forwardSentenceEnds*(self: TextIter; count: int): bool =
  toBool(gtk_text_iter_forward_sentence_ends(self, int32(count)))

proc gtk_text_iter_forward_to_end(self: TextIter) {.
    importc, libprag.}

proc forwardToEnd*(self: TextIter) =
  gtk_text_iter_forward_to_end(self)

proc gtk_text_iter_forward_to_line_end(self: TextIter): gboolean {.
    importc, libprag.}

proc forwardToLineEnd*(self: TextIter): bool =
  toBool(gtk_text_iter_forward_to_line_end(self))

proc gtk_text_iter_forward_visible_cursor_position(self: TextIter): gboolean {.
    importc, libprag.}

proc forwardVisibleCursorPosition*(self: TextIter): bool =
  toBool(gtk_text_iter_forward_visible_cursor_position(self))

proc gtk_text_iter_forward_visible_cursor_positions(self: TextIter; count: int32): gboolean {.
    importc, libprag.}

proc forwardVisibleCursorPositions*(self: TextIter; count: int): bool =
  toBool(gtk_text_iter_forward_visible_cursor_positions(self, int32(count)))

proc gtk_text_iter_forward_visible_line(self: TextIter): gboolean {.
    importc, libprag.}

proc forwardVisibleLine*(self: TextIter): bool =
  toBool(gtk_text_iter_forward_visible_line(self))

proc gtk_text_iter_forward_visible_lines(self: TextIter; count: int32): gboolean {.
    importc, libprag.}

proc forwardVisibleLines*(self: TextIter; count: int): bool =
  toBool(gtk_text_iter_forward_visible_lines(self, int32(count)))

proc gtk_text_iter_forward_visible_word_end(self: TextIter): gboolean {.
    importc, libprag.}

proc forwardVisibleWordEnd*(self: TextIter): bool =
  toBool(gtk_text_iter_forward_visible_word_end(self))

proc gtk_text_iter_forward_visible_word_ends(self: TextIter; count: int32): gboolean {.
    importc, libprag.}

proc forwardVisibleWordEnds*(self: TextIter; count: int): bool =
  toBool(gtk_text_iter_forward_visible_word_ends(self, int32(count)))

proc gtk_text_iter_forward_word_end(self: TextIter): gboolean {.
    importc, libprag.}

proc forwardWordEnd*(self: TextIter): bool =
  toBool(gtk_text_iter_forward_word_end(self))

proc gtk_text_iter_forward_word_ends(self: TextIter; count: int32): gboolean {.
    importc, libprag.}

proc forwardWordEnds*(self: TextIter; count: int): bool =
  toBool(gtk_text_iter_forward_word_ends(self, int32(count)))

proc gtk_text_iter_assign(self: TextIter; other: TextIter) {.
    importc, libprag.}

proc assign*(self: TextIter; other: TextIter) =
  gtk_text_iter_assign(self, other)

proc gtk_text_iter_get_bytes_in_line(self: TextIter): int32 {.
    importc, libprag.}

proc getBytesInLine*(self: TextIter): int =
  int(gtk_text_iter_get_bytes_in_line(self))

proc bytesInLine*(self: TextIter): int =
  int(gtk_text_iter_get_bytes_in_line(self))

proc gtk_text_iter_get_char(self: TextIter): gunichar {.
    importc, libprag.}

proc getChar*(self: TextIter): gunichar =
  gtk_text_iter_get_char(self)

proc gtk_text_iter_get_chars_in_line(self: TextIter): int32 {.
    importc, libprag.}

proc getCharsInLine*(self: TextIter): int =
  int(gtk_text_iter_get_chars_in_line(self))

proc charsInLine*(self: TextIter): int =
  int(gtk_text_iter_get_chars_in_line(self))

proc gtk_text_iter_get_language(self: TextIter): ptr pango.Language00 {.
    importc, libprag.}

proc getLanguage*(self: TextIter): pango.Language =
  fnew(result, gBoxedFreePangoLanguage)
  result.impl = gtk_text_iter_get_language(self)

proc language*(self: TextIter): pango.Language =
  fnew(result, gBoxedFreePangoLanguage)
  result.impl = gtk_text_iter_get_language(self)

proc gtk_text_iter_get_line(self: TextIter): int32 {.
    importc, libprag.}

proc getLine*(self: TextIter): int =
  int(gtk_text_iter_get_line(self))

proc line*(self: TextIter): int =
  int(gtk_text_iter_get_line(self))

proc gtk_text_iter_get_line_index(self: TextIter): int32 {.
    importc, libprag.}

proc getLineIndex*(self: TextIter): int =
  int(gtk_text_iter_get_line_index(self))

proc lineIndex*(self: TextIter): int =
  int(gtk_text_iter_get_line_index(self))

proc gtk_text_iter_get_line_offset(self: TextIter): int32 {.
    importc, libprag.}

proc getLineOffset*(self: TextIter): int =
  int(gtk_text_iter_get_line_offset(self))

proc lineOffset*(self: TextIter): int =
  int(gtk_text_iter_get_line_offset(self))

proc gtk_text_iter_get_offset(self: TextIter): int32 {.
    importc, libprag.}

proc getOffset*(self: TextIter): int =
  int(gtk_text_iter_get_offset(self))

proc offset*(self: TextIter): int =
  int(gtk_text_iter_get_offset(self))

proc gtk_text_iter_get_pixbuf(self: TextIter): ptr gdkpixbuf.Pixbuf00 {.
    importc, libprag.}

proc getPixbuf*(self: TextIter): gdkpixbuf.Pixbuf =
  let gobj = gtk_text_iter_get_pixbuf(self)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdkpixbuf.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc pixbuf*(self: TextIter): gdkpixbuf.Pixbuf =
  let gobj = gtk_text_iter_get_pixbuf(self)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdkpixbuf.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_text_iter_get_slice(self: TextIter; `end`: TextIter): cstring {.
    importc, libprag.}

proc getSlice*(self: TextIter; `end`: TextIter): string =
  let resul0 = gtk_text_iter_get_slice(self, `end`)
  result = $resul0
  cogfree(resul0)

proc gtk_text_iter_get_text(self: TextIter; `end`: TextIter): cstring {.
    importc, libprag.}

proc getText*(self: TextIter; `end`: TextIter): string =
  let resul0 = gtk_text_iter_get_text(self, `end`)
  result = $resul0
  cogfree(resul0)

proc gtk_text_iter_get_visible_line_index(self: TextIter): int32 {.
    importc, libprag.}

proc getVisibleLineIndex*(self: TextIter): int =
  int(gtk_text_iter_get_visible_line_index(self))

proc visibleLineIndex*(self: TextIter): int =
  int(gtk_text_iter_get_visible_line_index(self))

proc gtk_text_iter_get_visible_line_offset(self: TextIter): int32 {.
    importc, libprag.}

proc getVisibleLineOffset*(self: TextIter): int =
  int(gtk_text_iter_get_visible_line_offset(self))

proc visibleLineOffset*(self: TextIter): int =
  int(gtk_text_iter_get_visible_line_offset(self))

proc gtk_text_iter_get_visible_slice(self: TextIter; `end`: TextIter): cstring {.
    importc, libprag.}

proc getVisibleSlice*(self: TextIter; `end`: TextIter): string =
  let resul0 = gtk_text_iter_get_visible_slice(self, `end`)
  result = $resul0
  cogfree(resul0)

proc gtk_text_iter_get_visible_text(self: TextIter; `end`: TextIter): cstring {.
    importc, libprag.}

proc getVisibleText*(self: TextIter; `end`: TextIter): string =
  let resul0 = gtk_text_iter_get_visible_text(self, `end`)
  result = $resul0
  cogfree(resul0)

proc gtk_text_iter_in_range(self: TextIter; start: TextIter; `end`: TextIter): gboolean {.
    importc, libprag.}

proc inRange*(self: TextIter; start: TextIter; `end`: TextIter): bool =
  toBool(gtk_text_iter_in_range(self, start, `end`))

proc gtk_text_iter_inside_sentence(self: TextIter): gboolean {.
    importc, libprag.}

proc insideSentence*(self: TextIter): bool =
  toBool(gtk_text_iter_inside_sentence(self))

proc gtk_text_iter_inside_word(self: TextIter): gboolean {.
    importc, libprag.}

proc insideWord*(self: TextIter): bool =
  toBool(gtk_text_iter_inside_word(self))

proc gtk_text_iter_is_cursor_position(self: TextIter): gboolean {.
    importc, libprag.}

proc isCursorPosition*(self: TextIter): bool =
  toBool(gtk_text_iter_is_cursor_position(self))

proc gtk_text_iter_is_end(self: TextIter): gboolean {.
    importc, libprag.}

proc isEnd*(self: TextIter): bool =
  toBool(gtk_text_iter_is_end(self))

proc gtk_text_iter_is_start(self: TextIter): gboolean {.
    importc, libprag.}

proc isStart*(self: TextIter): bool =
  toBool(gtk_text_iter_is_start(self))

proc gtk_text_iter_order(self: TextIter; second: TextIter) {.
    importc, libprag.}

proc order*(self: TextIter; second: TextIter) =
  gtk_text_iter_order(self, second)

proc gtk_text_iter_set_line(self: TextIter; lineNumber: int32) {.
    importc, libprag.}

proc setLine*(self: TextIter; lineNumber: int) =
  gtk_text_iter_set_line(self, int32(lineNumber))

proc `line=`*(self: TextIter; lineNumber: int) =
  gtk_text_iter_set_line(self, int32(lineNumber))

proc gtk_text_iter_set_line_index(self: TextIter; byteOnLine: int32) {.
    importc, libprag.}

proc setLineIndex*(self: TextIter; byteOnLine: int) =
  gtk_text_iter_set_line_index(self, int32(byteOnLine))

proc `lineIndex=`*(self: TextIter; byteOnLine: int) =
  gtk_text_iter_set_line_index(self, int32(byteOnLine))

proc gtk_text_iter_set_line_offset(self: TextIter; charOnLine: int32) {.
    importc, libprag.}

proc setLineOffset*(self: TextIter; charOnLine: int) =
  gtk_text_iter_set_line_offset(self, int32(charOnLine))

proc `lineOffset=`*(self: TextIter; charOnLine: int) =
  gtk_text_iter_set_line_offset(self, int32(charOnLine))

proc gtk_text_iter_set_offset(self: TextIter; charOffset: int32) {.
    importc, libprag.}

proc setOffset*(self: TextIter; charOffset: int) =
  gtk_text_iter_set_offset(self, int32(charOffset))

proc `offset=`*(self: TextIter; charOffset: int) =
  gtk_text_iter_set_offset(self, int32(charOffset))

proc gtk_text_iter_set_visible_line_index(self: TextIter; byteOnLine: int32) {.
    importc, libprag.}

proc setVisibleLineIndex*(self: TextIter; byteOnLine: int) =
  gtk_text_iter_set_visible_line_index(self, int32(byteOnLine))

proc `visibleLineIndex=`*(self: TextIter; byteOnLine: int) =
  gtk_text_iter_set_visible_line_index(self, int32(byteOnLine))

proc gtk_text_iter_set_visible_line_offset(self: TextIter; charOnLine: int32) {.
    importc, libprag.}

proc setVisibleLineOffset*(self: TextIter; charOnLine: int) =
  gtk_text_iter_set_visible_line_offset(self, int32(charOnLine))

proc `visibleLineOffset=`*(self: TextIter; charOnLine: int) =
  gtk_text_iter_set_visible_line_offset(self, int32(charOnLine))

proc gtk_text_iter_starts_line(self: TextIter): gboolean {.
    importc, libprag.}

proc startsLine*(self: TextIter): bool =
  toBool(gtk_text_iter_starts_line(self))

proc gtk_text_iter_starts_sentence(self: TextIter): gboolean {.
    importc, libprag.}

proc startsSentence*(self: TextIter): bool =
  toBool(gtk_text_iter_starts_sentence(self))

proc gtk_text_iter_starts_word(self: TextIter): gboolean {.
    importc, libprag.}

proc startsWord*(self: TextIter): bool =
  toBool(gtk_text_iter_starts_word(self))

type
  TextTag* = ref object of gobject.Object
  TextTag00* = object of gobject.Object00

proc gtk_text_tag_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(TextTag()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scEvent*(self: TextTag;  p: proc (self: ptr TextTag00; `object`: ptr gobject.Object00; event: ptr gdk.Event00; iter: TextIter; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "event", cast[GCallback](p), xdata, nil, cf)

proc gtk_text_tag_new(name: cstring): ptr TextTag00 {.
    importc, libprag.}

proc newTextTag*(name: cstring = nil): TextTag =
  let gobj = gtk_text_tag_new(name)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newTextTag*(tdesc: typedesc; name: cstring = nil): tdesc =
  assert(result is TextTag)
  let gobj = gtk_text_tag_new(name)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initTextTag*[T](result: var T; name: cstring = nil) {.deprecated.} =
  assert(result is TextTag)
  let gobj = gtk_text_tag_new(name)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_text_tag_changed(self: ptr TextTag00; sizeChanged: gboolean) {.
    importc, libprag.}

proc changed*(self: TextTag; sizeChanged: bool) =
  gtk_text_tag_changed(cast[ptr TextTag00](self.impl), gboolean(sizeChanged))

proc gtk_text_tag_event(self: ptr TextTag00; eventObject: ptr gobject.Object00;
    event: ptr gdk.Event00; iter: TextIter): gboolean {.
    importc, libprag.}

proc event*(self: TextTag; eventObject: gobject.Object; event: gdk.Event;
    iter: TextIter): bool =
  toBool(gtk_text_tag_event(cast[ptr TextTag00](self.impl), cast[ptr gobject.Object00](eventObject.impl), cast[ptr gdk.Event00](event.impl), iter))

proc gtk_text_tag_get_priority(self: ptr TextTag00): int32 {.
    importc, libprag.}

proc getPriority*(self: TextTag): int =
  int(gtk_text_tag_get_priority(cast[ptr TextTag00](self.impl)))

proc priority*(self: TextTag): int =
  int(gtk_text_tag_get_priority(cast[ptr TextTag00](self.impl)))

proc gtk_text_tag_set_priority(self: ptr TextTag00; priority: int32) {.
    importc, libprag.}

proc setPriority*(self: TextTag; priority: int) =
  gtk_text_tag_set_priority(cast[ptr TextTag00](self.impl), int32(priority))

proc `priority=`*(self: TextTag; priority: int) =
  gtk_text_tag_set_priority(cast[ptr TextTag00](self.impl), int32(priority))

proc gtk_text_iter_backward_to_tag_toggle(self: TextIter; tag: ptr TextTag00): gboolean {.
    importc, libprag.}

proc backwardToTagToggle*(self: TextIter; tag: TextTag = nil): bool =
  toBool(gtk_text_iter_backward_to_tag_toggle(self, if tag.isNil: nil else: cast[ptr TextTag00](tag.impl)))

proc gtk_text_iter_begins_tag(self: TextIter; tag: ptr TextTag00): gboolean {.
    importc, libprag.}

proc beginsTag*(self: TextIter; tag: TextTag = nil): bool =
  toBool(gtk_text_iter_begins_tag(self, if tag.isNil: nil else: cast[ptr TextTag00](tag.impl)))

proc gtk_text_iter_ends_tag(self: TextIter; tag: ptr TextTag00): gboolean {.
    importc, libprag.}

proc endsTag*(self: TextIter; tag: TextTag = nil): bool =
  toBool(gtk_text_iter_ends_tag(self, if tag.isNil: nil else: cast[ptr TextTag00](tag.impl)))

proc gtk_text_iter_forward_to_tag_toggle(self: TextIter; tag: ptr TextTag00): gboolean {.
    importc, libprag.}

proc forwardToTagToggle*(self: TextIter; tag: TextTag = nil): bool =
  toBool(gtk_text_iter_forward_to_tag_toggle(self, if tag.isNil: nil else: cast[ptr TextTag00](tag.impl)))

proc gtk_text_iter_get_tags(self: TextIter): ptr glib.SList {.
    importc, libprag.}

proc getTags*(self: TextIter): seq[TextTag] =
  let resul0 = gtk_text_iter_get_tags(self)
  result = gslistObjects2seq(TextTag, resul0, false)
  g_slist_free(resul0)

proc tags*(self: TextIter): seq[TextTag] =
  let resul0 = gtk_text_iter_get_tags(self)
  result = gslistObjects2seq(TextTag, resul0, false)
  g_slist_free(resul0)

proc gtk_text_iter_get_toggled_tags(self: TextIter; toggledOn: gboolean): ptr glib.SList {.
    importc, libprag.}

proc getToggledTags*(self: TextIter; toggledOn: bool): seq[TextTag] =
  let resul0 = gtk_text_iter_get_toggled_tags(self, gboolean(toggledOn))
  result = gslistObjects2seq(TextTag, resul0, false)
  g_slist_free(resul0)

proc gtk_text_iter_has_tag(self: TextIter; tag: ptr TextTag00): gboolean {.
    importc, libprag.}

proc hasTag*(self: TextIter; tag: TextTag): bool =
  toBool(gtk_text_iter_has_tag(self, cast[ptr TextTag00](tag.impl)))

proc gtk_text_iter_starts_tag(self: TextIter; tag: ptr TextTag00): gboolean {.
    importc, libprag.}

proc startsTag*(self: TextIter; tag: TextTag = nil): bool =
  toBool(gtk_text_iter_starts_tag(self, if tag.isNil: nil else: cast[ptr TextTag00](tag.impl)))

proc gtk_text_iter_toggles_tag(self: TextIter; tag: ptr TextTag00): gboolean {.
    importc, libprag.}

proc togglesTag*(self: TextIter; tag: TextTag = nil): bool =
  toBool(gtk_text_iter_toggles_tag(self, if tag.isNil: nil else: cast[ptr TextTag00](tag.impl)))

type
  TextSearchFlag* {.size: sizeof(cint), pure.} = enum
    visibleOnly = 0
    textOnly = 1
    caseInsensitive = 2

  TextSearchFlags* {.size: sizeof(cint).} = set[TextSearchFlag]

proc gtk_text_iter_backward_search(self: TextIter; str: cstring; flags: TextSearchFlags;
    matchStart: var TextIter; matchEnd: var TextIter; limit: TextIter): gboolean {.
    importc, libprag.}

proc backwardSearch*(self: TextIter; str: cstring; flags: TextSearchFlags;
    matchStart: var TextIter = cast[var TextIter](nil); matchEnd: var TextIter = cast[var TextIter](nil);
    limit: TextIter = cast[var TextIter](nil)): bool =
  toBool(gtk_text_iter_backward_search(self, str, flags, matchStart, matchEnd, limit))

proc gtk_text_iter_forward_search(self: TextIter; str: cstring; flags: TextSearchFlags;
    matchStart: var TextIter; matchEnd: var TextIter; limit: TextIter): gboolean {.
    importc, libprag.}

proc forwardSearch*(self: TextIter; str: cstring; flags: TextSearchFlags;
    matchStart: var TextIter = cast[var TextIter](nil); matchEnd: var TextIter = cast[var TextIter](nil);
    limit: TextIter = cast[var TextIter](nil)): bool =
  toBool(gtk_text_iter_forward_search(self, str, flags, matchStart, matchEnd, limit))

type
  TextAttributes00* {.pure.} = object
  TextAttributes* = ref object
    impl*: ptr TextAttributes00
    ignoreFinalizer*: bool

proc gtk_text_attributes_get_type*(): GType {.importc, libprag.}

proc gBoxedFreeGtkTextAttributes*(self: TextAttributes) =
  if not self.ignoreFinalizer:
    boxedFree(gtk_text_attributes_get_type(), cast[ptr TextAttributes00](self.impl))

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(TextAttributes()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    if not self.ignoreFinalizer and self.impl != nil:
      boxedFree(gtk_text_attributes_get_type(), cast[ptr TextAttributes00](self.impl))
      self.impl = nil

proc newWithFinalizer*(x: var TextAttributes) =
  when defined(gcDestructors):
    new(x)
  else:
    new(x, gBoxedFreeGtkTextAttributes)

proc gtk_text_attributes_unref(self: ptr TextAttributes00) {.
    importc, libprag.}

proc unref*(self: TextAttributes) =
  gtk_text_attributes_unref(cast[ptr TextAttributes00](self.impl))

proc finalizerunref*(self: TextAttributes) =
  if not self.ignoreFinalizer:
    gtk_text_attributes_unref(cast[ptr TextAttributes00](self.impl))

proc gtk_text_attributes_copy(self: ptr TextAttributes00): ptr TextAttributes00 {.
    importc, libprag.}

proc copy*(self: TextAttributes): TextAttributes =
  fnew(result, gBoxedFreeGtkTextAttributes)
  result.impl = gtk_text_attributes_copy(cast[ptr TextAttributes00](self.impl))

proc gtk_text_attributes_copy_values(self: ptr TextAttributes00; dest: ptr TextAttributes00) {.
    importc, libprag.}

proc copyValues*(self: TextAttributes; dest: TextAttributes) =
  gtk_text_attributes_copy_values(cast[ptr TextAttributes00](self.impl), cast[ptr TextAttributes00](dest.impl))

proc gtk_text_attributes_ref(self: ptr TextAttributes00): ptr TextAttributes00 {.
    importc, libprag.}

proc `ref`*(self: TextAttributes): TextAttributes =
  fnew(result, gBoxedFreeGtkTextAttributes)
  result.impl = gtk_text_attributes_ref(cast[ptr TextAttributes00](self.impl))

proc gtk_text_attributes_new(): ptr TextAttributes00 {.
    importc, libprag.}

proc newTextAttributes*(): TextAttributes =
  fnew(result, gBoxedFreeGtkTextAttributes)
  result.impl = gtk_text_attributes_new()

proc newTextAttributes*(tdesc: typedesc): tdesc =
  assert(result is TextAttributes)
  fnew(result, gBoxedFreeGtkTextAttributes)
  result.impl = gtk_text_attributes_new()

proc initTextAttributes*[T](result: var T) {.deprecated.} =
  assert(result is TextAttributes)
  fnew(result, gBoxedFreeGtkTextAttributes)
  result.impl = gtk_text_attributes_new()

proc gtk_text_iter_get_attributes(self: TextIter; values: var TextAttributes00): gboolean {.
    importc, libprag.}

proc getAttributes*(self: TextIter; values: var TextAttributes00): bool =
  toBool(gtk_text_iter_get_attributes(self, values))

type
  TextChildAnchor* = ref object of gobject.Object
  TextChildAnchor00* = object of gobject.Object00

proc gtk_text_child_anchor_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(TextChildAnchor()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_text_child_anchor_new(): ptr TextChildAnchor00 {.
    importc, libprag.}

proc newTextChildAnchor*(): TextChildAnchor =
  let gobj = gtk_text_child_anchor_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newTextChildAnchor*(tdesc: typedesc): tdesc =
  assert(result is TextChildAnchor)
  let gobj = gtk_text_child_anchor_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initTextChildAnchor*[T](result: var T) {.deprecated.} =
  assert(result is TextChildAnchor)
  let gobj = gtk_text_child_anchor_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_text_child_anchor_get_deleted(self: ptr TextChildAnchor00): gboolean {.
    importc, libprag.}

proc getDeleted*(self: TextChildAnchor): bool =
  toBool(gtk_text_child_anchor_get_deleted(cast[ptr TextChildAnchor00](self.impl)))

proc deleted*(self: TextChildAnchor): bool =
  toBool(gtk_text_child_anchor_get_deleted(cast[ptr TextChildAnchor00](self.impl)))

proc gtk_text_child_anchor_get_widgets(self: ptr TextChildAnchor00): ptr glib.List {.
    importc, libprag.}

proc getWidgets*(self: TextChildAnchor): seq[Widget] =
  let resul0 = gtk_text_child_anchor_get_widgets(cast[ptr TextChildAnchor00](self.impl))
  result = glistObjects2seq(Widget, resul0, false)
  g_list_free(resul0)

proc widgets*(self: TextChildAnchor): seq[Widget] =
  let resul0 = gtk_text_child_anchor_get_widgets(cast[ptr TextChildAnchor00](self.impl))
  result = glistObjects2seq(Widget, resul0, false)
  g_list_free(resul0)

proc gtk_text_iter_get_child_anchor(self: TextIter): ptr TextChildAnchor00 {.
    importc, libprag.}

proc getChildAnchor*(self: TextIter): TextChildAnchor =
  let gobj = gtk_text_iter_get_child_anchor(self)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc childAnchor*(self: TextIter): TextChildAnchor =
  let gobj = gtk_text_iter_get_child_anchor(self)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  TextMark* = ref object of gobject.Object
  TextMark00* = object of gobject.Object00

proc gtk_text_mark_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(TextMark()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_text_mark_new(name: cstring; leftGravity: gboolean): ptr TextMark00 {.
    importc, libprag.}

proc newTextMark*(name: cstring = nil; leftGravity: bool): TextMark =
  let gobj = gtk_text_mark_new(name, gboolean(leftGravity))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newTextMark*(tdesc: typedesc; name: cstring = nil; leftGravity: bool): tdesc =
  assert(result is TextMark)
  let gobj = gtk_text_mark_new(name, gboolean(leftGravity))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initTextMark*[T](result: var T; name: cstring = nil; leftGravity: bool) {.deprecated.} =
  assert(result is TextMark)
  let gobj = gtk_text_mark_new(name, gboolean(leftGravity))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_text_mark_get_deleted(self: ptr TextMark00): gboolean {.
    importc, libprag.}

proc getDeleted*(self: TextMark): bool =
  toBool(gtk_text_mark_get_deleted(cast[ptr TextMark00](self.impl)))

proc deleted*(self: TextMark): bool =
  toBool(gtk_text_mark_get_deleted(cast[ptr TextMark00](self.impl)))

proc gtk_text_mark_get_left_gravity(self: ptr TextMark00): gboolean {.
    importc, libprag.}

proc getLeftGravity*(self: TextMark): bool =
  toBool(gtk_text_mark_get_left_gravity(cast[ptr TextMark00](self.impl)))

proc leftGravity*(self: TextMark): bool =
  toBool(gtk_text_mark_get_left_gravity(cast[ptr TextMark00](self.impl)))

proc gtk_text_mark_get_name(self: ptr TextMark00): cstring {.
    importc, libprag.}

proc getName*(self: TextMark): string =
  let resul0 = gtk_text_mark_get_name(cast[ptr TextMark00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc name*(self: TextMark): string =
  let resul0 = gtk_text_mark_get_name(cast[ptr TextMark00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc gtk_text_mark_get_visible(self: ptr TextMark00): gboolean {.
    importc, libprag.}

proc getVisible*(self: TextMark): bool =
  toBool(gtk_text_mark_get_visible(cast[ptr TextMark00](self.impl)))

proc visible*(self: TextMark): bool =
  toBool(gtk_text_mark_get_visible(cast[ptr TextMark00](self.impl)))

proc gtk_text_mark_set_visible(self: ptr TextMark00; setting: gboolean) {.
    importc, libprag.}

proc setVisible*(self: TextMark; setting: bool = true) =
  gtk_text_mark_set_visible(cast[ptr TextMark00](self.impl), gboolean(setting))

proc `visible=`*(self: TextMark; setting: bool) =
  gtk_text_mark_set_visible(cast[ptr TextMark00](self.impl), gboolean(setting))

type
  TextBuffer* = ref object of gobject.Object
  TextBuffer00* = object of gobject.Object00

proc gtk_text_buffer_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(TextBuffer()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scApplyTag*(self: TextBuffer;  p: proc (self: ptr TextBuffer00; tag: ptr TextTag00; start: TextIter; `end`: TextIter; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "apply-tag", cast[GCallback](p), xdata, nil, cf)

proc scBeginUserAction*(self: TextBuffer;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "begin-user-action", cast[GCallback](p), xdata, nil, cf)

proc scChanged*(self: TextBuffer;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "changed", cast[GCallback](p), xdata, nil, cf)

proc scDeleteRange*(self: TextBuffer;  p: proc (self: ptr TextBuffer00; start: TextIter; `end`: TextIter; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "delete-range", cast[GCallback](p), xdata, nil, cf)

proc scEndUserAction*(self: TextBuffer;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "end-user-action", cast[GCallback](p), xdata, nil, cf)

proc scInsertChildAnchor*(self: TextBuffer;  p: proc (self: ptr TextBuffer00; location: TextIter; anchor: ptr TextChildAnchor00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "insert-child-anchor", cast[GCallback](p), xdata, nil, cf)

proc scInsertPixbuf*(self: TextBuffer;  p: proc (self: ptr TextBuffer00; location: TextIter; pixbuf: ptr gdkpixbuf.Pixbuf00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "insert-pixbuf", cast[GCallback](p), xdata, nil, cf)

proc scInsertText*(self: TextBuffer;  p: proc (self: ptr TextBuffer00; location: TextIter; text: cstring; len: int32; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "insert-text", cast[GCallback](p), xdata, nil, cf)

proc scMarkDeleted*(self: TextBuffer;  p: proc (self: ptr TextBuffer00; mark: ptr TextMark00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "mark-deleted", cast[GCallback](p), xdata, nil, cf)

proc scMarkSet*(self: TextBuffer;  p: proc (self: ptr TextBuffer00; location: TextIter; mark: ptr TextMark00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "mark-set", cast[GCallback](p), xdata, nil, cf)

proc scModifiedChanged*(self: TextBuffer;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "modified-changed", cast[GCallback](p), xdata, nil, cf)

proc scPasteDone*(self: TextBuffer;  p: proc (self: ptr TextBuffer00; clipboard: ptr Clipboard00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "paste-done", cast[GCallback](p), xdata, nil, cf)

proc scRemoveTag*(self: TextBuffer;  p: proc (self: ptr TextBuffer00; tag: ptr TextTag00; start: TextIter; `end`: TextIter; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "remove-tag", cast[GCallback](p), xdata, nil, cf)

proc gtk_text_buffer_add_mark(self: ptr TextBuffer00; mark: ptr TextMark00;
    where: TextIter) {.
    importc, libprag.}

proc addMark*(self: TextBuffer; mark: TextMark; where: TextIter) =
  gtk_text_buffer_add_mark(cast[ptr TextBuffer00](self.impl), cast[ptr TextMark00](mark.impl), where)

proc gtk_text_buffer_add_selection_clipboard(self: ptr TextBuffer00; clipboard: ptr Clipboard00) {.
    importc, libprag.}

proc addSelectionClipboard*(self: TextBuffer; clipboard: Clipboard) =
  gtk_text_buffer_add_selection_clipboard(cast[ptr TextBuffer00](self.impl), cast[ptr Clipboard00](clipboard.impl))

proc gtk_text_buffer_apply_tag(self: ptr TextBuffer00; tag: ptr TextTag00;
    start: TextIter; `end`: TextIter) {.
    importc, libprag.}

proc applyTag*(self: TextBuffer; tag: TextTag; start: TextIter;
    `end`: TextIter) =
  gtk_text_buffer_apply_tag(cast[ptr TextBuffer00](self.impl), cast[ptr TextTag00](tag.impl), start, `end`)

proc gtk_text_buffer_apply_tag_by_name(self: ptr TextBuffer00; name: cstring;
    start: TextIter; `end`: TextIter) {.
    importc, libprag.}

proc applyTagByName*(self: TextBuffer; name: cstring; start: TextIter;
    `end`: TextIter) =
  gtk_text_buffer_apply_tag_by_name(cast[ptr TextBuffer00](self.impl), name, start, `end`)

proc gtk_text_buffer_backspace(self: ptr TextBuffer00; iter: TextIter; interactive: gboolean;
    defaultEditable: gboolean): gboolean {.
    importc, libprag.}

proc backspace*(self: TextBuffer; iter: TextIter; interactive: bool;
    defaultEditable: bool): bool =
  toBool(gtk_text_buffer_backspace(cast[ptr TextBuffer00](self.impl), iter, gboolean(interactive), gboolean(defaultEditable)))

proc gtk_text_buffer_begin_user_action(self: ptr TextBuffer00) {.
    importc, libprag.}

proc beginUserAction*(self: TextBuffer) =
  gtk_text_buffer_begin_user_action(cast[ptr TextBuffer00](self.impl))

proc gtk_text_buffer_copy_clipboard(self: ptr TextBuffer00; clipboard: ptr Clipboard00) {.
    importc, libprag.}

proc copyClipboard*(self: TextBuffer; clipboard: Clipboard) =
  gtk_text_buffer_copy_clipboard(cast[ptr TextBuffer00](self.impl), cast[ptr Clipboard00](clipboard.impl))

proc gtk_text_buffer_create_child_anchor(self: ptr TextBuffer00; iter: TextIter): ptr TextChildAnchor00 {.
    importc, libprag.}

proc createChildAnchor*(self: TextBuffer; iter: TextIter): TextChildAnchor =
  let gobj = gtk_text_buffer_create_child_anchor(cast[ptr TextBuffer00](self.impl), iter)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_text_buffer_create_mark(self: ptr TextBuffer00; markName: cstring;
    where: TextIter; leftGravity: gboolean): ptr TextMark00 {.
    importc, libprag.}

proc createMark*(self: TextBuffer; markName: cstring = nil;
    where: TextIter; leftGravity: bool): TextMark =
  let gobj = gtk_text_buffer_create_mark(cast[ptr TextBuffer00](self.impl), markName, where, gboolean(leftGravity))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_text_buffer_cut_clipboard(self: ptr TextBuffer00; clipboard: ptr Clipboard00;
    defaultEditable: gboolean) {.
    importc, libprag.}

proc cutClipboard*(self: TextBuffer; clipboard: Clipboard;
    defaultEditable: bool) =
  gtk_text_buffer_cut_clipboard(cast[ptr TextBuffer00](self.impl), cast[ptr Clipboard00](clipboard.impl), gboolean(defaultEditable))

proc gtk_text_buffer_delete(self: ptr TextBuffer00; start: TextIter; `end`: TextIter) {.
    importc, libprag.}

proc delete*(self: TextBuffer; start: TextIter; `end`: TextIter) =
  gtk_text_buffer_delete(cast[ptr TextBuffer00](self.impl), start, `end`)

proc gtk_text_buffer_delete_interactive(self: ptr TextBuffer00; startIter: TextIter;
    endIter: TextIter; defaultEditable: gboolean): gboolean {.
    importc, libprag.}

proc deleteInteractive*(self: TextBuffer; startIter: TextIter;
    endIter: TextIter; defaultEditable: bool): bool =
  toBool(gtk_text_buffer_delete_interactive(cast[ptr TextBuffer00](self.impl), startIter, endIter, gboolean(defaultEditable)))

proc gtk_text_buffer_delete_mark(self: ptr TextBuffer00; mark: ptr TextMark00) {.
    importc, libprag.}

proc deleteMark*(self: TextBuffer; mark: TextMark) =
  gtk_text_buffer_delete_mark(cast[ptr TextBuffer00](self.impl), cast[ptr TextMark00](mark.impl))

proc gtk_text_buffer_delete_mark_by_name(self: ptr TextBuffer00; name: cstring) {.
    importc, libprag.}

proc deleteMarkByName*(self: TextBuffer; name: cstring) =
  gtk_text_buffer_delete_mark_by_name(cast[ptr TextBuffer00](self.impl), name)

proc gtk_text_buffer_delete_selection(self: ptr TextBuffer00; interactive: gboolean;
    defaultEditable: gboolean): gboolean {.
    importc, libprag.}

proc deleteSelection*(self: TextBuffer; interactive: bool;
    defaultEditable: bool): bool =
  toBool(gtk_text_buffer_delete_selection(cast[ptr TextBuffer00](self.impl), gboolean(interactive), gboolean(defaultEditable)))

proc gtk_text_buffer_deserialize(self: ptr TextBuffer00; contentBuffer: ptr TextBuffer00;
    format: ptr gdk.Atom00; iter: TextIter; data: ptr uint8; length: uint64;
    error: ptr ptr glib.Error = nil): gboolean {.
    importc, libprag.}

proc deserialize*(self: TextBuffer; contentBuffer: TextBuffer;
    format: gdk.Atom; iter: TextIter; data: seq[uint8] | string): bool =
  let length = uint64(data.len)
  var gerror: ptr glib.Error
  let resul0 = gtk_text_buffer_deserialize(cast[ptr TextBuffer00](self.impl), cast[ptr TextBuffer00](contentBuffer.impl), cast[ptr gdk.Atom00](format.impl), iter, cast[ptr uint8](unsafeaddr(data[0])), length, addr gerror)
  if gerror != nil:
    let msg = $gerror.message
    g_error_free(gerror[])
    raise newException(GException, msg)
  result = toBool(resul0)

proc gtk_text_buffer_deserialize_get_can_create_tags(self: ptr TextBuffer00;
    format: ptr gdk.Atom00): gboolean {.
    importc, libprag.}

proc deserializeGetCanCreateTags*(self: TextBuffer; format: gdk.Atom): bool =
  toBool(gtk_text_buffer_deserialize_get_can_create_tags(cast[ptr TextBuffer00](self.impl), cast[ptr gdk.Atom00](format.impl)))

proc gtk_text_buffer_deserialize_set_can_create_tags(self: ptr TextBuffer00;
    format: ptr gdk.Atom00; canCreateTags: gboolean) {.
    importc, libprag.}

proc deserializeSetCanCreateTags*(self: TextBuffer; format: gdk.Atom;
    canCreateTags: bool) =
  gtk_text_buffer_deserialize_set_can_create_tags(cast[ptr TextBuffer00](self.impl), cast[ptr gdk.Atom00](format.impl), gboolean(canCreateTags))

proc gtk_text_buffer_end_user_action(self: ptr TextBuffer00) {.
    importc, libprag.}

proc endUserAction*(self: TextBuffer) =
  gtk_text_buffer_end_user_action(cast[ptr TextBuffer00](self.impl))

proc gtk_text_buffer_get_bounds(self: ptr TextBuffer00; start: var TextIter;
    `end`: var TextIter) {.
    importc, libprag.}

proc getBounds*(self: TextBuffer; start: var TextIter; `end`: var TextIter) =
  gtk_text_buffer_get_bounds(cast[ptr TextBuffer00](self.impl), start, `end`)

proc gtk_text_buffer_get_char_count(self: ptr TextBuffer00): int32 {.
    importc, libprag.}

proc getCharCount*(self: TextBuffer): int =
  int(gtk_text_buffer_get_char_count(cast[ptr TextBuffer00](self.impl)))

proc charCount*(self: TextBuffer): int =
  int(gtk_text_buffer_get_char_count(cast[ptr TextBuffer00](self.impl)))

proc gtk_text_buffer_get_copy_target_list(self: ptr TextBuffer00): ptr TargetList00 {.
    importc, libprag.}

proc getCopyTargetList*(self: TextBuffer): TargetList =
  fnew(result, gBoxedFreeGtkTargetList)
  result.impl = gtk_text_buffer_get_copy_target_list(cast[ptr TextBuffer00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(gtk_target_list_get_type(), result.impl))

proc copyTargetList*(self: TextBuffer): TargetList =
  fnew(result, gBoxedFreeGtkTargetList)
  result.impl = gtk_text_buffer_get_copy_target_list(cast[ptr TextBuffer00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(gtk_target_list_get_type(), result.impl))

proc gtk_text_buffer_get_deserialize_formats(self: ptr TextBuffer00; nFormats: var int32): ptr ptr gdk.Atom00 {.
    importc, libprag.}

proc getDeserializeFormats*(self: TextBuffer; nFormats: var int): ptr ptr gdk.Atom00 =
  var nFormats_00: int32
  result = gtk_text_buffer_get_deserialize_formats(cast[ptr TextBuffer00](self.impl), nFormats_00)
  if nFormats.addr != nil:
    nFormats = int(nFormats_00)

proc gtk_text_buffer_get_end_iter(self: ptr TextBuffer00; iter: var TextIter) {.
    importc, libprag.}

proc getEndIter*(self: TextBuffer; iter: var TextIter) =
  gtk_text_buffer_get_end_iter(cast[ptr TextBuffer00](self.impl), iter)

proc getEndIter*(self: TextBuffer): TextIter =
  gtk_text_buffer_get_end_iter(cast[ptr TextBuffer00](self.impl), result)

proc gtk_text_buffer_get_has_selection(self: ptr TextBuffer00): gboolean {.
    importc, libprag.}

proc getHasSelection*(self: TextBuffer): bool =
  toBool(gtk_text_buffer_get_has_selection(cast[ptr TextBuffer00](self.impl)))

proc hasSelection*(self: TextBuffer): bool =
  toBool(gtk_text_buffer_get_has_selection(cast[ptr TextBuffer00](self.impl)))

proc gtk_text_buffer_get_insert(self: ptr TextBuffer00): ptr TextMark00 {.
    importc, libprag.}

proc getInsert*(self: TextBuffer): TextMark =
  let gobj = gtk_text_buffer_get_insert(cast[ptr TextBuffer00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc insert*(self: TextBuffer): TextMark =
  let gobj = gtk_text_buffer_get_insert(cast[ptr TextBuffer00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_text_buffer_get_iter_at_child_anchor(self: ptr TextBuffer00; iter: var TextIter;
    anchor: ptr TextChildAnchor00) {.
    importc, libprag.}

proc getIterAtChildAnchor*(self: TextBuffer; iter: var TextIter;
    anchor: TextChildAnchor) =
  gtk_text_buffer_get_iter_at_child_anchor(cast[ptr TextBuffer00](self.impl), iter, cast[ptr TextChildAnchor00](anchor.impl))

proc gtk_text_buffer_get_iter_at_line(self: ptr TextBuffer00; iter: var TextIter;
    lineNumber: int32) {.
    importc, libprag.}

proc getIterAtLine*(self: TextBuffer; iter: var TextIter;
    lineNumber: int) =
  gtk_text_buffer_get_iter_at_line(cast[ptr TextBuffer00](self.impl), iter, int32(lineNumber))

proc gtk_text_buffer_get_iter_at_line_index(self: ptr TextBuffer00; iter: var TextIter;
    lineNumber: int32; byteIndex: int32) {.
    importc, libprag.}

proc getIterAtLineIndex*(self: TextBuffer; iter: var TextIter;
    lineNumber: int; byteIndex: int) =
  gtk_text_buffer_get_iter_at_line_index(cast[ptr TextBuffer00](self.impl), iter, int32(lineNumber), int32(byteIndex))

proc gtk_text_buffer_get_iter_at_line_offset(self: ptr TextBuffer00; iter: var TextIter;
    lineNumber: int32; charOffset: int32) {.
    importc, libprag.}

proc getIterAtLineOffset*(self: TextBuffer; iter: var TextIter;
    lineNumber: int; charOffset: int) =
  gtk_text_buffer_get_iter_at_line_offset(cast[ptr TextBuffer00](self.impl), iter, int32(lineNumber), int32(charOffset))

proc gtk_text_buffer_get_iter_at_mark(self: ptr TextBuffer00; iter: var TextIter;
    mark: ptr TextMark00) {.
    importc, libprag.}

proc getIterAtMark*(self: TextBuffer; iter: var TextIter;
    mark: TextMark) =
  gtk_text_buffer_get_iter_at_mark(cast[ptr TextBuffer00](self.impl), iter, cast[ptr TextMark00](mark.impl))

proc gtk_text_buffer_get_iter_at_offset(self: ptr TextBuffer00; iter: var TextIter;
    charOffset: int32) {.
    importc, libprag.}

proc getIterAtOffset*(self: TextBuffer; iter: var TextIter;
    charOffset: int) =
  gtk_text_buffer_get_iter_at_offset(cast[ptr TextBuffer00](self.impl), iter, int32(charOffset))

proc gtk_text_buffer_get_line_count(self: ptr TextBuffer00): int32 {.
    importc, libprag.}

proc getLineCount*(self: TextBuffer): int =
  int(gtk_text_buffer_get_line_count(cast[ptr TextBuffer00](self.impl)))

proc lineCount*(self: TextBuffer): int =
  int(gtk_text_buffer_get_line_count(cast[ptr TextBuffer00](self.impl)))

proc gtk_text_buffer_get_mark(self: ptr TextBuffer00; name: cstring): ptr TextMark00 {.
    importc, libprag.}

proc getMark*(self: TextBuffer; name: cstring): TextMark =
  let gobj = gtk_text_buffer_get_mark(cast[ptr TextBuffer00](self.impl), name)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_text_buffer_get_modified(self: ptr TextBuffer00): gboolean {.
    importc, libprag.}

proc getModified*(self: TextBuffer): bool =
  toBool(gtk_text_buffer_get_modified(cast[ptr TextBuffer00](self.impl)))

proc modified*(self: TextBuffer): bool =
  toBool(gtk_text_buffer_get_modified(cast[ptr TextBuffer00](self.impl)))

proc gtk_text_buffer_get_paste_target_list(self: ptr TextBuffer00): ptr TargetList00 {.
    importc, libprag.}

proc getPasteTargetList*(self: TextBuffer): TargetList =
  fnew(result, gBoxedFreeGtkTargetList)
  result.impl = gtk_text_buffer_get_paste_target_list(cast[ptr TextBuffer00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(gtk_target_list_get_type(), result.impl))

proc pasteTargetList*(self: TextBuffer): TargetList =
  fnew(result, gBoxedFreeGtkTargetList)
  result.impl = gtk_text_buffer_get_paste_target_list(cast[ptr TextBuffer00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(gtk_target_list_get_type(), result.impl))

proc gtk_text_buffer_get_selection_bound(self: ptr TextBuffer00): ptr TextMark00 {.
    importc, libprag.}

proc getSelectionBound*(self: TextBuffer): TextMark =
  let gobj = gtk_text_buffer_get_selection_bound(cast[ptr TextBuffer00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc selectionBound*(self: TextBuffer): TextMark =
  let gobj = gtk_text_buffer_get_selection_bound(cast[ptr TextBuffer00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_text_buffer_get_selection_bounds(self: ptr TextBuffer00; start: var TextIter;
    `end`: var TextIter): gboolean {.
    importc, libprag.}

proc getSelectionBounds*(self: TextBuffer; start: var TextIter;
    `end`: var TextIter): bool =
  toBool(gtk_text_buffer_get_selection_bounds(cast[ptr TextBuffer00](self.impl), start, `end`))

proc gtk_text_buffer_get_serialize_formats(self: ptr TextBuffer00; nFormats: var int32): ptr ptr gdk.Atom00 {.
    importc, libprag.}

proc getSerializeFormats*(self: TextBuffer; nFormats: var int): ptr ptr gdk.Atom00 =
  var nFormats_00: int32
  result = gtk_text_buffer_get_serialize_formats(cast[ptr TextBuffer00](self.impl), nFormats_00)
  if nFormats.addr != nil:
    nFormats = int(nFormats_00)

proc gtk_text_buffer_get_slice(self: ptr TextBuffer00; start: TextIter; `end`: TextIter;
    includeHiddenChars: gboolean): cstring {.
    importc, libprag.}

proc getSlice*(self: TextBuffer; start: TextIter; `end`: TextIter;
    includeHiddenChars: bool): string =
  let resul0 = gtk_text_buffer_get_slice(cast[ptr TextBuffer00](self.impl), start, `end`, gboolean(includeHiddenChars))
  result = $resul0
  cogfree(resul0)

proc gtk_text_buffer_get_start_iter(self: ptr TextBuffer00; iter: var TextIter) {.
    importc, libprag.}

proc getStartIter*(self: TextBuffer; iter: var TextIter) =
  gtk_text_buffer_get_start_iter(cast[ptr TextBuffer00](self.impl), iter)

proc getStartIter*(self: TextBuffer): TextIter =
  gtk_text_buffer_get_start_iter(cast[ptr TextBuffer00](self.impl), result)

proc gtk_text_buffer_get_text(self: ptr TextBuffer00; start: TextIter; `end`: TextIter;
    includeHiddenChars: gboolean): cstring {.
    importc, libprag.}

proc getText*(self: TextBuffer; start: TextIter; `end`: TextIter;
    includeHiddenChars: bool): string =
  let resul0 = gtk_text_buffer_get_text(cast[ptr TextBuffer00](self.impl), start, `end`, gboolean(includeHiddenChars))
  result = $resul0
  cogfree(resul0)

proc gtk_text_buffer_insert(self: ptr TextBuffer00; iter: TextIter; text: cstring;
    len: int32) {.
    importc, libprag.}

proc insert*(self: TextBuffer; iter: TextIter; text: cstring;
    len: int) =
  gtk_text_buffer_insert(cast[ptr TextBuffer00](self.impl), iter, text, int32(len))

proc gtk_text_buffer_insert_at_cursor(self: ptr TextBuffer00; text: cstring;
    len: int32) {.
    importc, libprag.}

proc insertAtCursor*(self: TextBuffer; text: cstring; len: int) =
  gtk_text_buffer_insert_at_cursor(cast[ptr TextBuffer00](self.impl), text, int32(len))

proc gtk_text_buffer_insert_child_anchor(self: ptr TextBuffer00; iter: TextIter;
    anchor: ptr TextChildAnchor00) {.
    importc, libprag.}

proc insertChildAnchor*(self: TextBuffer; iter: TextIter;
    anchor: TextChildAnchor) =
  gtk_text_buffer_insert_child_anchor(cast[ptr TextBuffer00](self.impl), iter, cast[ptr TextChildAnchor00](anchor.impl))

proc gtk_text_buffer_insert_interactive(self: ptr TextBuffer00; iter: TextIter;
    text: cstring; len: int32; defaultEditable: gboolean): gboolean {.
    importc, libprag.}

proc insertInteractive*(self: TextBuffer; iter: TextIter;
    text: cstring; len: int; defaultEditable: bool): bool =
  toBool(gtk_text_buffer_insert_interactive(cast[ptr TextBuffer00](self.impl), iter, text, int32(len), gboolean(defaultEditable)))

proc gtk_text_buffer_insert_interactive_at_cursor(self: ptr TextBuffer00;
    text: cstring; len: int32; defaultEditable: gboolean): gboolean {.
    importc, libprag.}

proc insertInteractiveAtCursor*(self: TextBuffer; text: cstring;
    len: int; defaultEditable: bool): bool =
  toBool(gtk_text_buffer_insert_interactive_at_cursor(cast[ptr TextBuffer00](self.impl), text, int32(len), gboolean(defaultEditable)))

proc gtk_text_buffer_insert_markup(self: ptr TextBuffer00; iter: TextIter;
    markup: cstring; len: int32) {.
    importc, libprag.}

proc insertMarkup*(self: TextBuffer; iter: TextIter; markup: cstring;
    len: int) =
  gtk_text_buffer_insert_markup(cast[ptr TextBuffer00](self.impl), iter, markup, int32(len))

proc gtk_text_buffer_insert_pixbuf(self: ptr TextBuffer00; iter: TextIter;
    pixbuf: ptr gdkpixbuf.Pixbuf00) {.
    importc, libprag.}

proc insertPixbuf*(self: TextBuffer; iter: TextIter; pixbuf: gdkpixbuf.Pixbuf) =
  gtk_text_buffer_insert_pixbuf(cast[ptr TextBuffer00](self.impl), iter, cast[ptr gdkpixbuf.Pixbuf00](pixbuf.impl))

proc gtk_text_buffer_insert_range(self: ptr TextBuffer00; iter: TextIter;
    start: TextIter; `end`: TextIter) {.
    importc, libprag.}

proc insertRange*(self: TextBuffer; iter: TextIter; start: TextIter;
    `end`: TextIter) =
  gtk_text_buffer_insert_range(cast[ptr TextBuffer00](self.impl), iter, start, `end`)

proc gtk_text_buffer_insert_range_interactive(self: ptr TextBuffer00; iter: TextIter;
    start: TextIter; `end`: TextIter; defaultEditable: gboolean): gboolean {.
    importc, libprag.}

proc insertRangeInteractive*(self: TextBuffer; iter: TextIter;
    start: TextIter; `end`: TextIter; defaultEditable: bool): bool =
  toBool(gtk_text_buffer_insert_range_interactive(cast[ptr TextBuffer00](self.impl), iter, start, `end`, gboolean(defaultEditable)))

proc gtk_text_buffer_move_mark(self: ptr TextBuffer00; mark: ptr TextMark00;
    where: TextIter) {.
    importc, libprag.}

proc moveMark*(self: TextBuffer; mark: TextMark; where: TextIter) =
  gtk_text_buffer_move_mark(cast[ptr TextBuffer00](self.impl), cast[ptr TextMark00](mark.impl), where)

proc gtk_text_buffer_move_mark_by_name(self: ptr TextBuffer00; name: cstring;
    where: TextIter) {.
    importc, libprag.}

proc moveMarkByName*(self: TextBuffer; name: cstring; where: TextIter) =
  gtk_text_buffer_move_mark_by_name(cast[ptr TextBuffer00](self.impl), name, where)

proc gtk_text_buffer_paste_clipboard(self: ptr TextBuffer00; clipboard: ptr Clipboard00;
    overrideLocation: TextIter; defaultEditable: gboolean) {.
    importc, libprag.}

proc pasteClipboard*(self: TextBuffer; clipboard: Clipboard;
    overrideLocation: TextIter = cast[var TextIter](nil); defaultEditable: bool) =
  gtk_text_buffer_paste_clipboard(cast[ptr TextBuffer00](self.impl), cast[ptr Clipboard00](clipboard.impl), overrideLocation, gboolean(defaultEditable))

proc gtk_text_buffer_place_cursor(self: ptr TextBuffer00; where: TextIter) {.
    importc, libprag.}

proc placeCursor*(self: TextBuffer; where: TextIter) =
  gtk_text_buffer_place_cursor(cast[ptr TextBuffer00](self.impl), where)

proc gtk_text_buffer_register_deserialize_tagset(self: ptr TextBuffer00;
    tagsetName: cstring): ptr gdk.Atom00 {.
    importc, libprag.}

proc registerDeserializeTagset*(self: TextBuffer; tagsetName: cstring = nil): gdk.Atom =
  new(result)
  result.impl = gtk_text_buffer_register_deserialize_tagset(cast[ptr TextBuffer00](self.impl), tagsetName)
  result.ignoreFinalizer = true

proc gtk_text_buffer_register_serialize_tagset(self: ptr TextBuffer00; tagsetName: cstring): ptr gdk.Atom00 {.
    importc, libprag.}

proc registerSerializeTagset*(self: TextBuffer; tagsetName: cstring = nil): gdk.Atom =
  new(result)
  result.impl = gtk_text_buffer_register_serialize_tagset(cast[ptr TextBuffer00](self.impl), tagsetName)
  result.ignoreFinalizer = true

proc gtk_text_buffer_remove_all_tags(self: ptr TextBuffer00; start: TextIter;
    `end`: TextIter) {.
    importc, libprag.}

proc removeAllTags*(self: TextBuffer; start: TextIter; `end`: TextIter) =
  gtk_text_buffer_remove_all_tags(cast[ptr TextBuffer00](self.impl), start, `end`)

proc gtk_text_buffer_remove_selection_clipboard(self: ptr TextBuffer00; clipboard: ptr Clipboard00) {.
    importc, libprag.}

proc removeSelectionClipboard*(self: TextBuffer; clipboard: Clipboard) =
  gtk_text_buffer_remove_selection_clipboard(cast[ptr TextBuffer00](self.impl), cast[ptr Clipboard00](clipboard.impl))

proc gtk_text_buffer_remove_tag(self: ptr TextBuffer00; tag: ptr TextTag00;
    start: TextIter; `end`: TextIter) {.
    importc, libprag.}

proc removeTag*(self: TextBuffer; tag: TextTag; start: TextIter;
    `end`: TextIter) =
  gtk_text_buffer_remove_tag(cast[ptr TextBuffer00](self.impl), cast[ptr TextTag00](tag.impl), start, `end`)

proc gtk_text_buffer_remove_tag_by_name(self: ptr TextBuffer00; name: cstring;
    start: TextIter; `end`: TextIter) {.
    importc, libprag.}

proc removeTagByName*(self: TextBuffer; name: cstring;
    start: TextIter; `end`: TextIter) =
  gtk_text_buffer_remove_tag_by_name(cast[ptr TextBuffer00](self.impl), name, start, `end`)

proc gtk_text_buffer_select_range(self: ptr TextBuffer00; ins: TextIter;
    bound: TextIter) {.
    importc, libprag.}

proc selectRange*(self: TextBuffer; ins: TextIter; bound: TextIter) =
  gtk_text_buffer_select_range(cast[ptr TextBuffer00](self.impl), ins, bound)

proc gtk_text_buffer_serialize(self: ptr TextBuffer00; contentBuffer: ptr TextBuffer00;
    format: ptr gdk.Atom00; start: TextIter; `end`: TextIter; length: var uint64): ptr uint8 {.
    importc, libprag.}

proc serialize*(self: TextBuffer; contentBuffer: TextBuffer;
    format: gdk.Atom; start: TextIter; `end`: TextIter; length: var uint64): seq[uint8] =
  let resul0 = gtk_text_buffer_serialize(cast[ptr TextBuffer00](self.impl), cast[ptr TextBuffer00](contentBuffer.impl), cast[ptr gdk.Atom00](format.impl), start, `end`, length)
  result = uint8ArrayToSeq(resul0, length.int)
  cogfree(resul0)

proc gtk_text_buffer_set_modified(self: ptr TextBuffer00; setting: gboolean) {.
    importc, libprag.}

proc setModified*(self: TextBuffer; setting: bool = true) =
  gtk_text_buffer_set_modified(cast[ptr TextBuffer00](self.impl), gboolean(setting))

proc `modified=`*(self: TextBuffer; setting: bool) =
  gtk_text_buffer_set_modified(cast[ptr TextBuffer00](self.impl), gboolean(setting))

proc gtk_text_buffer_set_text(self: ptr TextBuffer00; text: cstring; len: int32) {.
    importc, libprag.}

proc setText*(self: TextBuffer; text: cstring; len: int) =
  gtk_text_buffer_set_text(cast[ptr TextBuffer00](self.impl), text, int32(len))

proc gtk_text_buffer_unregister_deserialize_format(self: ptr TextBuffer00;
    format: ptr gdk.Atom00) {.
    importc, libprag.}

proc unregisterDeserializeFormat*(self: TextBuffer; format: gdk.Atom) =
  gtk_text_buffer_unregister_deserialize_format(cast[ptr TextBuffer00](self.impl), cast[ptr gdk.Atom00](format.impl))

proc gtk_text_buffer_unregister_serialize_format(self: ptr TextBuffer00;
    format: ptr gdk.Atom00) {.
    importc, libprag.}

proc unregisterSerializeFormat*(self: TextBuffer; format: gdk.Atom) =
  gtk_text_buffer_unregister_serialize_format(cast[ptr TextBuffer00](self.impl), cast[ptr gdk.Atom00](format.impl))

proc gtk_selection_data_targets_include_rich_text(self: ptr SelectionData00;
    buffer: ptr TextBuffer00): gboolean {.
    importc, libprag.}

proc targetsIncludeRichText*(self: SelectionData; buffer: TextBuffer): bool =
  toBool(gtk_selection_data_targets_include_rich_text(cast[ptr SelectionData00](self.impl), cast[ptr TextBuffer00](buffer.impl)))

proc gtk_target_list_add_rich_text_targets(self: ptr TargetList00; info: uint32;
    deserializable: gboolean; buffer: ptr TextBuffer00) {.
    importc, libprag.}

proc addRichTextTargets*(self: TargetList; info: int; deserializable: bool;
    buffer: TextBuffer) =
  gtk_target_list_add_rich_text_targets(cast[ptr TargetList00](self.impl), uint32(info), gboolean(deserializable), cast[ptr TextBuffer00](buffer.impl))

proc gtk_clipboard_wait_for_rich_text(self: ptr Clipboard00; buffer: ptr TextBuffer00;
    format: var ptr gdk.Atom00; length: var uint64): ptr uint8 {.
    importc, libprag.}

proc waitForRichText*(self: Clipboard; buffer: TextBuffer;
    format: var ptr gdk.Atom00; length: var uint64): seq[uint8] =
  let resul0 = gtk_clipboard_wait_for_rich_text(cast[ptr Clipboard00](self.impl), cast[ptr TextBuffer00](buffer.impl), format, length)
  if resul0.isNil:
    return
  result = uint8ArrayToSeq(resul0, length.int)
  cogfree(resul0)

proc gtk_clipboard_wait_is_rich_text_available(self: ptr Clipboard00; buffer: ptr TextBuffer00): gboolean {.
    importc, libprag.}

proc waitIsRichTextAvailable*(self: Clipboard; buffer: TextBuffer): bool =
  toBool(gtk_clipboard_wait_is_rich_text_available(cast[ptr Clipboard00](self.impl), cast[ptr TextBuffer00](buffer.impl)))

proc gtk_text_iter_get_buffer(self: TextIter): ptr TextBuffer00 {.
    importc, libprag.}

proc getBuffer*(self: TextIter): TextBuffer =
  let gobj = gtk_text_iter_get_buffer(self)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc buffer*(self: TextIter): TextBuffer =
  let gobj = gtk_text_iter_get_buffer(self)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_text_iter_get_marks(self: TextIter): ptr glib.SList {.
    importc, libprag.}

proc getMarks*(self: TextIter): seq[TextMark] =
  let resul0 = gtk_text_iter_get_marks(self)
  result = gslistObjects2seq(TextMark, resul0, false)
  g_slist_free(resul0)

proc marks*(self: TextIter): seq[TextMark] =
  let resul0 = gtk_text_iter_get_marks(self)
  result = gslistObjects2seq(TextMark, resul0, false)
  g_slist_free(resul0)

proc gtk_text_mark_get_buffer(self: ptr TextMark00): ptr TextBuffer00 {.
    importc, libprag.}

proc getBuffer*(self: TextMark): TextBuffer =
  let gobj = gtk_text_mark_get_buffer(cast[ptr TextMark00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc buffer*(self: TextMark): TextBuffer =
  let gobj = gtk_text_mark_get_buffer(cast[ptr TextMark00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  TextTagTable* = ref object of gobject.Object
  TextTagTable00* = object of gobject.Object00

proc gtk_text_tag_table_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(TextTagTable()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scTagAdded*(self: TextTagTable;  p: proc (self: ptr TextTagTable00; tag: ptr TextTag00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "tag-added", cast[GCallback](p), xdata, nil, cf)

proc scTagChanged*(self: TextTagTable;  p: proc (self: ptr TextTagTable00; tag: ptr TextTag00; sizeChanged: gboolean; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "tag-changed", cast[GCallback](p), xdata, nil, cf)

proc scTagRemoved*(self: TextTagTable;  p: proc (self: ptr TextTagTable00; tag: ptr TextTag00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "tag-removed", cast[GCallback](p), xdata, nil, cf)

proc gtk_text_tag_table_new(): ptr TextTagTable00 {.
    importc, libprag.}

proc newTextTagTable*(): TextTagTable =
  let gobj = gtk_text_tag_table_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newTextTagTable*(tdesc: typedesc): tdesc =
  assert(result is TextTagTable)
  let gobj = gtk_text_tag_table_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initTextTagTable*[T](result: var T) {.deprecated.} =
  assert(result is TextTagTable)
  let gobj = gtk_text_tag_table_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_text_tag_table_add(self: ptr TextTagTable00; tag: ptr TextTag00): gboolean {.
    importc, libprag.}

proc add*(self: TextTagTable; tag: TextTag): bool =
  toBool(gtk_text_tag_table_add(cast[ptr TextTagTable00](self.impl), cast[ptr TextTag00](tag.impl)))

proc gtk_text_tag_table_get_size(self: ptr TextTagTable00): int32 {.
    importc, libprag.}

proc getSize*(self: TextTagTable): int =
  int(gtk_text_tag_table_get_size(cast[ptr TextTagTable00](self.impl)))

proc size*(self: TextTagTable): int =
  int(gtk_text_tag_table_get_size(cast[ptr TextTagTable00](self.impl)))

proc gtk_text_tag_table_lookup(self: ptr TextTagTable00; name: cstring): ptr TextTag00 {.
    importc, libprag.}

proc lookup*(self: TextTagTable; name: cstring): TextTag =
  let gobj = gtk_text_tag_table_lookup(cast[ptr TextTagTable00](self.impl), name)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_text_tag_table_remove(self: ptr TextTagTable00; tag: ptr TextTag00) {.
    importc, libprag.}

proc remove*(self: TextTagTable; tag: TextTag) =
  gtk_text_tag_table_remove(cast[ptr TextTagTable00](self.impl), cast[ptr TextTag00](tag.impl))

proc gtk_text_buffer_new(table: ptr TextTagTable00): ptr TextBuffer00 {.
    importc, libprag.}

proc newTextBuffer*(table: TextTagTable = nil): TextBuffer =
  let gobj = gtk_text_buffer_new(if table.isNil: nil else: cast[ptr TextTagTable00](table.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newTextBuffer*(tdesc: typedesc; table: TextTagTable = nil): tdesc =
  assert(result is TextBuffer)
  let gobj = gtk_text_buffer_new(if table.isNil: nil else: cast[ptr TextTagTable00](table.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initTextBuffer*[T](result: var T; table: TextTagTable = nil) {.deprecated.} =
  assert(result is TextBuffer)
  let gobj = gtk_text_buffer_new(if table.isNil: nil else: cast[ptr TextTagTable00](table.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_text_buffer_get_tag_table(self: ptr TextBuffer00): ptr TextTagTable00 {.
    importc, libprag.}

proc getTagTable*(self: TextBuffer): TextTagTable =
  let gobj = gtk_text_buffer_get_tag_table(cast[ptr TextBuffer00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc tagTable*(self: TextBuffer): TextTagTable =
  let gobj = gtk_text_buffer_get_tag_table(cast[ptr TextBuffer00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  AccelGroupActivate* = proc (accelGroup: ptr AccelGroup00; acceleratable: ptr gobject.Object00;
    keyval: uint32; modifier: gdk.ModifierType): gboolean {.cdecl.}

type
  AccelKey* {.pure, byRef.} = object
    accelKey*: uint32
    accelMods*: gdk.ModifierType
    accelFlags*: uint32

type
  AccelGroupFindFunc* = proc (key: AccelKey; closure: ptr gobject.Closure00; data: pointer): gboolean {.cdecl.}

proc gtk_accel_group_find(self: ptr AccelGroup00; findFunc: AccelGroupFindFunc;
    data: pointer): ptr AccelKey {.
    importc, libprag.}

proc findAccelGroup*(self: AccelGroup; findFunc: AccelGroupFindFunc;
    data: pointer): ptr AccelKey =
  gtk_accel_group_find(cast[ptr AccelGroup00](self.impl), findFunc, data)

type
  Misc* = ref object of Widget
  Misc00* = object of Widget00

proc gtk_misc_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Misc()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_misc_get_alignment(self: ptr Misc00; xalign: var cfloat; yalign: var cfloat) {.
    importc, libprag.}

proc getAlignment*(self: Misc; xalign: var cfloat = cast[var cfloat](nil);
    yalign: var cfloat = cast[var cfloat](nil)) =
  gtk_misc_get_alignment(cast[ptr Misc00](self.impl), xalign, yalign)

proc gtk_misc_get_padding(self: ptr Misc00; xpad: var int32; ypad: var int32) {.
    importc, libprag.}

proc getPadding*(self: Misc; xpad: var int = cast[var int](nil);
    ypad: var int = cast[var int](nil)) =
  var ypad_00: int32
  var xpad_00: int32
  gtk_misc_get_padding(cast[ptr Misc00](self.impl), xpad_00, ypad_00)
  if ypad.addr != nil:
    ypad = int(ypad_00)
  if xpad.addr != nil:
    xpad = int(xpad_00)

proc gtk_misc_set_alignment(self: ptr Misc00; xalign: cfloat; yalign: cfloat) {.
    importc, libprag.}

proc setAlignment*(self: Misc; xalign: cfloat; yalign: cfloat) =
  gtk_misc_set_alignment(cast[ptr Misc00](self.impl), xalign, yalign)

proc gtk_misc_set_padding(self: ptr Misc00; xpad: int32; ypad: int32) {.
    importc, libprag.}

proc setPadding*(self: Misc; xpad: int; ypad: int) =
  gtk_misc_set_padding(cast[ptr Misc00](self.impl), int32(xpad), int32(ypad))

type
  MovementStep* {.size: sizeof(cint), pure.} = enum
    logicalPositions = 0
    visualPositions = 1
    words = 2
    displayLines = 3
    displayLineEnds = 4
    paragraphs = 5
    paragraphEnds = 6
    pages = 7
    bufferEnds = 8
    horizontalPages = 9

type
  MenuDirectionType* {.size: sizeof(cint), pure.} = enum
    parent = 0
    child = 1
    next = 2
    prev = 3

type
  MenuShell* = ref object of Container
  MenuShell00* = object of Container00

proc gtk_menu_shell_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(MenuShell()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scActivateCurrent*(self: MenuShell;  p: proc (self: ptr MenuShell00; forceHide: gboolean; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "activate-current", cast[GCallback](p), xdata, nil, cf)

proc scCancel*(self: MenuShell;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "cancel", cast[GCallback](p), xdata, nil, cf)

proc scCycleFocus*(self: MenuShell;  p: proc (self: ptr MenuShell00; direction: DirectionType; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "cycle-focus", cast[GCallback](p), xdata, nil, cf)

proc scDeactivate*(self: MenuShell;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "deactivate", cast[GCallback](p), xdata, nil, cf)

proc scInsert*(self: MenuShell;  p: proc (self: ptr MenuShell00; child: ptr Widget00; position: int32; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "insert", cast[GCallback](p), xdata, nil, cf)

proc scMoveCurrent*(self: MenuShell;  p: proc (self: ptr MenuShell00; direction: MenuDirectionType; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "move-current", cast[GCallback](p), xdata, nil, cf)

proc scMoveSelected*(self: MenuShell;  p: proc (self: ptr MenuShell00; distance: int32; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "move-selected", cast[GCallback](p), xdata, nil, cf)

proc scSelectionDone*(self: MenuShell;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "selection-done", cast[GCallback](p), xdata, nil, cf)

proc gtk_menu_shell_activate_item(self: ptr MenuShell00; menuItem: ptr Widget00;
    forceDeactivate: gboolean) {.
    importc, libprag.}

proc activateItem*(self: MenuShell; menuItem: Widget; forceDeactivate: bool) =
  gtk_menu_shell_activate_item(cast[ptr MenuShell00](self.impl), cast[ptr Widget00](menuItem.impl), gboolean(forceDeactivate))

proc gtk_menu_shell_bind_model(self: ptr MenuShell00; model: ptr gio.MenuModel00;
    actionNamespace: cstring; withSeparators: gboolean) {.
    importc, libprag.}

proc bindModel*(self: MenuShell; model: gio.MenuModel = nil;
    actionNamespace: cstring = nil; withSeparators: bool) =
  gtk_menu_shell_bind_model(cast[ptr MenuShell00](self.impl), if model.isNil: nil else: cast[ptr gio.MenuModel00](model.impl), actionNamespace, gboolean(withSeparators))

proc gtk_menu_shell_cancel(self: ptr MenuShell00) {.
    importc, libprag.}

proc cancel*(self: MenuShell) =
  gtk_menu_shell_cancel(cast[ptr MenuShell00](self.impl))

proc gtk_menu_shell_deactivate(self: ptr MenuShell00) {.
    importc, libprag.}

proc deactivate*(self: MenuShell) =
  gtk_menu_shell_deactivate(cast[ptr MenuShell00](self.impl))

proc gtk_menu_shell_deselect(self: ptr MenuShell00) {.
    importc, libprag.}

proc deselect*(self: MenuShell) =
  gtk_menu_shell_deselect(cast[ptr MenuShell00](self.impl))

proc gtk_menu_shell_get_parent_shell(self: ptr MenuShell00): ptr Widget00 {.
    importc, libprag.}

proc getParentShell*(self: MenuShell): Widget =
  let gobj = gtk_menu_shell_get_parent_shell(cast[ptr MenuShell00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc parentShell*(self: MenuShell): Widget =
  let gobj = gtk_menu_shell_get_parent_shell(cast[ptr MenuShell00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_menu_shell_get_selected_item(self: ptr MenuShell00): ptr Widget00 {.
    importc, libprag.}

proc getSelectedItem*(self: MenuShell): Widget =
  let gobj = gtk_menu_shell_get_selected_item(cast[ptr MenuShell00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc selectedItem*(self: MenuShell): Widget =
  let gobj = gtk_menu_shell_get_selected_item(cast[ptr MenuShell00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_menu_shell_get_take_focus(self: ptr MenuShell00): gboolean {.
    importc, libprag.}

proc getTakeFocus*(self: MenuShell): bool =
  toBool(gtk_menu_shell_get_take_focus(cast[ptr MenuShell00](self.impl)))

proc takeFocus*(self: MenuShell): bool =
  toBool(gtk_menu_shell_get_take_focus(cast[ptr MenuShell00](self.impl)))

proc gtk_menu_shell_insert(self: ptr MenuShell00; child: ptr Widget00; position: int32) {.
    importc, libprag.}

proc insert*(self: MenuShell; child: Widget; position: int) =
  gtk_menu_shell_insert(cast[ptr MenuShell00](self.impl), cast[ptr Widget00](child.impl), int32(position))

proc gtk_menu_shell_prepend(self: ptr MenuShell00; child: ptr Widget00) {.
    importc, libprag.}

proc prepend*(self: MenuShell; child: Widget) =
  gtk_menu_shell_prepend(cast[ptr MenuShell00](self.impl), cast[ptr Widget00](child.impl))

proc gtk_menu_shell_select_first(self: ptr MenuShell00; searchSensitive: gboolean) {.
    importc, libprag.}

proc selectFirst*(self: MenuShell; searchSensitive: bool) =
  gtk_menu_shell_select_first(cast[ptr MenuShell00](self.impl), gboolean(searchSensitive))

proc gtk_menu_shell_select_item(self: ptr MenuShell00; menuItem: ptr Widget00) {.
    importc, libprag.}

proc selectItem*(self: MenuShell; menuItem: Widget) =
  gtk_menu_shell_select_item(cast[ptr MenuShell00](self.impl), cast[ptr Widget00](menuItem.impl))

proc gtk_menu_shell_set_take_focus(self: ptr MenuShell00; takeFocus: gboolean) {.
    importc, libprag.}

proc setTakeFocus*(self: MenuShell; takeFocus: bool = true) =
  gtk_menu_shell_set_take_focus(cast[ptr MenuShell00](self.impl), gboolean(takeFocus))

proc `takeFocus=`*(self: MenuShell; takeFocus: bool) =
  gtk_menu_shell_set_take_focus(cast[ptr MenuShell00](self.impl), gboolean(takeFocus))

type
  ScrollType* {.size: sizeof(cint), pure.} = enum
    none = 0
    jump = 1
    stepBackward = 2
    stepForward = 3
    pageBackward = 4
    pageForward = 5
    stepUp = 6
    stepDown = 7
    pageUp = 8
    pageDown = 9
    stepLeft = 10
    stepRight = 11
    pageLeft = 12
    pageRight = 13
    start = 14
    `end` = 15

type
  Menu* = ref object of MenuShell
  Menu00* = object of MenuShell00

proc gtk_menu_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Menu()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scMoveScroll*(self: Menu;  p: proc (self: ptr Menu00; scrollType: ScrollType; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "move-scroll", cast[GCallback](p), xdata, nil, cf)

proc scPoppedUp*(self: Menu;  p: proc (self: ptr Menu00; flippedRect: pointer; finalRect: pointer; flippedX: gboolean; flippedY: gboolean; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "popped-up", cast[GCallback](p), xdata, nil, cf)

proc gtk_menu_new(): ptr Menu00 {.
    importc, libprag.}

proc newMenu*(): Menu =
  let gobj = gtk_menu_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newMenu*(tdesc: typedesc): tdesc =
  assert(result is Menu)
  let gobj = gtk_menu_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initMenu*[T](result: var T) {.deprecated.} =
  assert(result is Menu)
  let gobj = gtk_menu_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_menu_new_from_model(model: ptr gio.MenuModel00): ptr Menu00 {.
    importc, libprag.}

proc newMenuFromModel*(model: gio.MenuModel): Menu =
  let gobj = gtk_menu_new_from_model(cast[ptr gio.MenuModel00](model.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newMenuFromModel*(tdesc: typedesc; model: gio.MenuModel): tdesc =
  assert(result is Menu)
  let gobj = gtk_menu_new_from_model(cast[ptr gio.MenuModel00](model.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initMenuFromModel*[T](result: var T; model: gio.MenuModel) {.deprecated.} =
  assert(result is Menu)
  let gobj = gtk_menu_new_from_model(cast[ptr gio.MenuModel00](model.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_menu_get_for_attach_widget(widget: ptr Widget00): ptr glib.List {.
    importc, libprag.}

proc getForAttachWidget*(widget: Widget): seq[Widget] =
  result = glistObjects2seq(Widget, gtk_menu_get_for_attach_widget(cast[ptr Widget00](widget.impl)), false)

proc forAttachWidget*(widget: Widget): seq[Widget] =
  result = glistObjects2seq(Widget, gtk_menu_get_for_attach_widget(cast[ptr Widget00](widget.impl)), false)

proc gtk_menu_attach(self: ptr Menu00; child: ptr Widget00; leftAttach: uint32;
    rightAttach: uint32; topAttach: uint32; bottomAttach: uint32) {.
    importc, libprag.}

proc attach*(self: Menu; child: Widget; leftAttach: int; rightAttach: int;
    topAttach: int; bottomAttach: int) =
  gtk_menu_attach(cast[ptr Menu00](self.impl), cast[ptr Widget00](child.impl), uint32(leftAttach), uint32(rightAttach), uint32(topAttach), uint32(bottomAttach))

proc gtk_menu_detach(self: ptr Menu00) {.
    importc, libprag.}

proc detach*(self: Menu) =
  gtk_menu_detach(cast[ptr Menu00](self.impl))

proc gtk_menu_get_accel_group(self: ptr Menu00): ptr AccelGroup00 {.
    importc, libprag.}

proc getAccelGroup*(self: Menu): AccelGroup =
  let gobj = gtk_menu_get_accel_group(cast[ptr Menu00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc accelGroup*(self: Menu): AccelGroup =
  let gobj = gtk_menu_get_accel_group(cast[ptr Menu00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_menu_get_accel_path(self: ptr Menu00): cstring {.
    importc, libprag.}

proc getAccelPath*(self: Menu): string =
  result = $gtk_menu_get_accel_path(cast[ptr Menu00](self.impl))

proc accelPath*(self: Menu): string =
  result = $gtk_menu_get_accel_path(cast[ptr Menu00](self.impl))

proc gtk_menu_get_active(self: ptr Menu00): ptr Widget00 {.
    importc, libprag.}

proc getActive*(self: Menu): Widget =
  let gobj = gtk_menu_get_active(cast[ptr Menu00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc active*(self: Menu): Widget =
  let gobj = gtk_menu_get_active(cast[ptr Menu00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_menu_get_attach_widget(self: ptr Menu00): ptr Widget00 {.
    importc, libprag.}

proc getAttachWidget*(self: Menu): Widget =
  let gobj = gtk_menu_get_attach_widget(cast[ptr Menu00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc attachWidget*(self: Menu): Widget =
  let gobj = gtk_menu_get_attach_widget(cast[ptr Menu00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_menu_get_monitor(self: ptr Menu00): int32 {.
    importc, libprag.}

proc getMonitor*(self: Menu): int =
  int(gtk_menu_get_monitor(cast[ptr Menu00](self.impl)))

proc monitor*(self: Menu): int =
  int(gtk_menu_get_monitor(cast[ptr Menu00](self.impl)))

proc gtk_menu_get_reserve_toggle_size(self: ptr Menu00): gboolean {.
    importc, libprag.}

proc getReserveToggleSize*(self: Menu): bool =
  toBool(gtk_menu_get_reserve_toggle_size(cast[ptr Menu00](self.impl)))

proc reserveToggleSize*(self: Menu): bool =
  toBool(gtk_menu_get_reserve_toggle_size(cast[ptr Menu00](self.impl)))

proc gtk_menu_get_tearoff_state(self: ptr Menu00): gboolean {.
    importc, libprag.}

proc getTearoffState*(self: Menu): bool =
  toBool(gtk_menu_get_tearoff_state(cast[ptr Menu00](self.impl)))

proc tearoffState*(self: Menu): bool =
  toBool(gtk_menu_get_tearoff_state(cast[ptr Menu00](self.impl)))

proc gtk_menu_get_title(self: ptr Menu00): cstring {.
    importc, libprag.}

proc getTitle*(self: Menu): string =
  result = $gtk_menu_get_title(cast[ptr Menu00](self.impl))

proc title*(self: Menu): string =
  result = $gtk_menu_get_title(cast[ptr Menu00](self.impl))

proc gtk_menu_place_on_monitor(self: ptr Menu00; monitor: ptr gdk.Monitor00) {.
    importc, libprag.}

proc placeOnMonitor*(self: Menu; monitor: gdk.Monitor) =
  gtk_menu_place_on_monitor(cast[ptr Menu00](self.impl), cast[ptr gdk.Monitor00](monitor.impl))

proc gtk_menu_popdown(self: ptr Menu00) {.
    importc, libprag.}

proc popdown*(self: Menu) =
  gtk_menu_popdown(cast[ptr Menu00](self.impl))

proc gtk_menu_popup_at_pointer(self: ptr Menu00; triggerEvent: ptr gdk.Event00) {.
    importc, libprag.}

proc popupAtPointer*(self: Menu; triggerEvent: gdk.Event = nil) =
  gtk_menu_popup_at_pointer(cast[ptr Menu00](self.impl), if triggerEvent.isNil: nil else: cast[ptr gdk.Event00](triggerEvent.impl))

proc gtk_menu_popup_at_rect(self: ptr Menu00; rectWindow: ptr gdk.Window00;
    rect: gdk.Rectangle; rectAnchor: gdk.Gravity; menuAnchor: gdk.Gravity;
    triggerEvent: ptr gdk.Event00) {.
    importc, libprag.}

proc popupAtRect*(self: Menu; rectWindow: gdk.Window; rect: gdk.Rectangle;
    rectAnchor: gdk.Gravity; menuAnchor: gdk.Gravity; triggerEvent: gdk.Event = nil) =
  gtk_menu_popup_at_rect(cast[ptr Menu00](self.impl), cast[ptr gdk.Window00](rectWindow.impl), rect, rectAnchor, menuAnchor, if triggerEvent.isNil: nil else: cast[ptr gdk.Event00](triggerEvent.impl))

proc gtk_menu_popup_at_widget(self: ptr Menu00; widget: ptr Widget00; widgetAnchor: gdk.Gravity;
    menuAnchor: gdk.Gravity; triggerEvent: ptr gdk.Event00) {.
    importc, libprag.}

proc popupAtWidget*(self: Menu; widget: Widget; widgetAnchor: gdk.Gravity;
    menuAnchor: gdk.Gravity; triggerEvent: gdk.Event = nil) =
  gtk_menu_popup_at_widget(cast[ptr Menu00](self.impl), cast[ptr Widget00](widget.impl), widgetAnchor, menuAnchor, if triggerEvent.isNil: nil else: cast[ptr gdk.Event00](triggerEvent.impl))

proc gtk_menu_reorder_child(self: ptr Menu00; child: ptr Widget00; position: int32) {.
    importc, libprag.}

proc reorderChild*(self: Menu; child: Widget; position: int) =
  gtk_menu_reorder_child(cast[ptr Menu00](self.impl), cast[ptr Widget00](child.impl), int32(position))

proc gtk_menu_reposition(self: ptr Menu00) {.
    importc, libprag.}

proc reposition*(self: Menu) =
  gtk_menu_reposition(cast[ptr Menu00](self.impl))

proc gtk_menu_set_accel_group(self: ptr Menu00; accelGroup: ptr AccelGroup00) {.
    importc, libprag.}

proc setAccelGroup*(self: Menu; accelGroup: AccelGroup = nil) =
  gtk_menu_set_accel_group(cast[ptr Menu00](self.impl), if accelGroup.isNil: nil else: cast[ptr AccelGroup00](accelGroup.impl))

proc `accelGroup=`*(self: Menu; accelGroup: AccelGroup = nil) =
  gtk_menu_set_accel_group(cast[ptr Menu00](self.impl), if accelGroup.isNil: nil else: cast[ptr AccelGroup00](accelGroup.impl))

proc gtk_menu_set_accel_path(self: ptr Menu00; accelPath: cstring) {.
    importc, libprag.}

proc setAccelPath*(self: Menu; accelPath: cstring = nil) =
  gtk_menu_set_accel_path(cast[ptr Menu00](self.impl), accelPath)

proc `accelPath=`*(self: Menu; accelPath: cstring = nil) =
  gtk_menu_set_accel_path(cast[ptr Menu00](self.impl), accelPath)

proc gtk_menu_set_active(self: ptr Menu00; index: uint32) {.
    importc, libprag.}

proc setActive*(self: Menu; index: int) =
  gtk_menu_set_active(cast[ptr Menu00](self.impl), uint32(index))

proc `active=`*(self: Menu; index: int) =
  gtk_menu_set_active(cast[ptr Menu00](self.impl), uint32(index))

proc gtk_menu_set_monitor(self: ptr Menu00; monitorNum: int32) {.
    importc, libprag.}

proc setMonitor*(self: Menu; monitorNum: int) =
  gtk_menu_set_monitor(cast[ptr Menu00](self.impl), int32(monitorNum))

proc `monitor=`*(self: Menu; monitorNum: int) =
  gtk_menu_set_monitor(cast[ptr Menu00](self.impl), int32(monitorNum))

proc gtk_menu_set_reserve_toggle_size(self: ptr Menu00; reserveToggleSize: gboolean) {.
    importc, libprag.}

proc setReserveToggleSize*(self: Menu; reserveToggleSize: bool = true) =
  gtk_menu_set_reserve_toggle_size(cast[ptr Menu00](self.impl), gboolean(reserveToggleSize))

proc `reserveToggleSize=`*(self: Menu; reserveToggleSize: bool) =
  gtk_menu_set_reserve_toggle_size(cast[ptr Menu00](self.impl), gboolean(reserveToggleSize))

proc gtk_menu_set_screen(self: ptr Menu00; screen: ptr gdk.Screen00) {.
    importc, libprag.}

proc setScreen*(self: Menu; screen: gdk.Screen = nil) =
  gtk_menu_set_screen(cast[ptr Menu00](self.impl), if screen.isNil: nil else: cast[ptr gdk.Screen00](screen.impl))

proc `screen=`*(self: Menu; screen: gdk.Screen = nil) =
  gtk_menu_set_screen(cast[ptr Menu00](self.impl), if screen.isNil: nil else: cast[ptr gdk.Screen00](screen.impl))

proc gtk_menu_set_tearoff_state(self: ptr Menu00; tornOff: gboolean) {.
    importc, libprag.}

proc setTearoffState*(self: Menu; tornOff: bool = true) =
  gtk_menu_set_tearoff_state(cast[ptr Menu00](self.impl), gboolean(tornOff))

proc `tearoffState=`*(self: Menu; tornOff: bool) =
  gtk_menu_set_tearoff_state(cast[ptr Menu00](self.impl), gboolean(tornOff))

proc gtk_menu_set_title(self: ptr Menu00; title: cstring) {.
    importc, libprag.}

proc setTitle*(self: Menu; title: cstring = nil) =
  gtk_menu_set_title(cast[ptr Menu00](self.impl), title)

proc `title=`*(self: Menu; title: cstring = nil) =
  gtk_menu_set_title(cast[ptr Menu00](self.impl), title)

type
  Label* = ref object of Misc
  Label00* = object of Misc00

proc gtk_label_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Label()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scActivateCurrentLink*(self: Label;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "activate-current-link", cast[GCallback](p), xdata, nil, cf)

proc scActivateLink*(self: Label;  p: proc (self: ptr Label00; uri: cstring; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "activate-link", cast[GCallback](p), xdata, nil, cf)

proc scCopyClipboard*(self: Label;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "copy-clipboard", cast[GCallback](p), xdata, nil, cf)

proc scMoveCursor*(self: Label;  p: proc (self: ptr Label00; step: MovementStep; count: int32; extendSelection: gboolean; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "move-cursor", cast[GCallback](p), xdata, nil, cf)

proc scPopulatePopup*(self: Label;  p: proc (self: ptr Label00; menu: ptr Menu00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "populate-popup", cast[GCallback](p), xdata, nil, cf)

proc gtk_label_new(str: cstring): ptr Label00 {.
    importc, libprag.}

proc newLabel*(str: cstring = nil): Label =
  let gobj = gtk_label_new(str)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newLabel*(tdesc: typedesc; str: cstring = nil): tdesc =
  assert(result is Label)
  let gobj = gtk_label_new(str)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initLabel*[T](result: var T; str: cstring = nil) {.deprecated.} =
  assert(result is Label)
  let gobj = gtk_label_new(str)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_label_new_with_mnemonic(str: cstring): ptr Label00 {.
    importc, libprag.}

proc newLabelWithMnemonic*(str: cstring = nil): Label =
  let gobj = gtk_label_new_with_mnemonic(str)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newLabelWithMnemonic*(tdesc: typedesc; str: cstring = nil): tdesc =
  assert(result is Label)
  let gobj = gtk_label_new_with_mnemonic(str)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initLabelWithMnemonic*[T](result: var T; str: cstring = nil) {.deprecated.} =
  assert(result is Label)
  let gobj = gtk_label_new_with_mnemonic(str)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_label_get_angle(self: ptr Label00): cdouble {.
    importc, libprag.}

proc getAngle*(self: Label): cdouble =
  gtk_label_get_angle(cast[ptr Label00](self.impl))

proc angle*(self: Label): cdouble =
  gtk_label_get_angle(cast[ptr Label00](self.impl))

proc gtk_label_get_attributes(self: ptr Label00): ptr pango.AttrList00 {.
    importc, libprag.}

proc getAttributes*(self: Label): pango.AttrList =
  let impl0 = gtk_label_get_attributes(cast[ptr Label00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreePangoAttrList)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(pango_attr_list_get_type(), impl0))

proc attributes*(self: Label): pango.AttrList =
  let impl0 = gtk_label_get_attributes(cast[ptr Label00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreePangoAttrList)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(pango_attr_list_get_type(), impl0))

proc gtk_label_get_current_uri(self: ptr Label00): cstring {.
    importc, libprag.}

proc getCurrentUri*(self: Label): string =
  result = $gtk_label_get_current_uri(cast[ptr Label00](self.impl))

proc currentUri*(self: Label): string =
  result = $gtk_label_get_current_uri(cast[ptr Label00](self.impl))

proc gtk_label_get_ellipsize(self: ptr Label00): pango.EllipsizeMode {.
    importc, libprag.}

proc getEllipsize*(self: Label): pango.EllipsizeMode =
  gtk_label_get_ellipsize(cast[ptr Label00](self.impl))

proc ellipsize*(self: Label): pango.EllipsizeMode =
  gtk_label_get_ellipsize(cast[ptr Label00](self.impl))

proc gtk_label_get_label(self: ptr Label00): cstring {.
    importc, libprag.}

proc getLabel*(self: Label): string =
  result = $gtk_label_get_label(cast[ptr Label00](self.impl))

proc label*(self: Label): string =
  result = $gtk_label_get_label(cast[ptr Label00](self.impl))

proc gtk_label_get_layout(self: ptr Label00): ptr pango.Layout00 {.
    importc, libprag.}

proc getLayout*(self: Label): pango.Layout =
  let gobj = gtk_label_get_layout(cast[ptr Label00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, pango.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc layout*(self: Label): pango.Layout =
  let gobj = gtk_label_get_layout(cast[ptr Label00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, pango.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_label_get_layout_offsets(self: ptr Label00; x: var int32; y: var int32) {.
    importc, libprag.}

proc getLayoutOffsets*(self: Label; x: var int = cast[var int](nil);
    y: var int = cast[var int](nil)) =
  var y_00: int32
  var x_00: int32
  gtk_label_get_layout_offsets(cast[ptr Label00](self.impl), x_00, y_00)
  if y.addr != nil:
    y = int(y_00)
  if x.addr != nil:
    x = int(x_00)

proc gtk_label_get_line_wrap(self: ptr Label00): gboolean {.
    importc, libprag.}

proc getLineWrap*(self: Label): bool =
  toBool(gtk_label_get_line_wrap(cast[ptr Label00](self.impl)))

proc lineWrap*(self: Label): bool =
  toBool(gtk_label_get_line_wrap(cast[ptr Label00](self.impl)))

proc gtk_label_get_line_wrap_mode(self: ptr Label00): pango.WrapMode {.
    importc, libprag.}

proc getLineWrapMode*(self: Label): pango.WrapMode =
  gtk_label_get_line_wrap_mode(cast[ptr Label00](self.impl))

proc lineWrapMode*(self: Label): pango.WrapMode =
  gtk_label_get_line_wrap_mode(cast[ptr Label00](self.impl))

proc gtk_label_get_lines(self: ptr Label00): int32 {.
    importc, libprag.}

proc getLines*(self: Label): int =
  int(gtk_label_get_lines(cast[ptr Label00](self.impl)))

proc lines*(self: Label): int =
  int(gtk_label_get_lines(cast[ptr Label00](self.impl)))

proc gtk_label_get_max_width_chars(self: ptr Label00): int32 {.
    importc, libprag.}

proc getMaxWidthChars*(self: Label): int =
  int(gtk_label_get_max_width_chars(cast[ptr Label00](self.impl)))

proc maxWidthChars*(self: Label): int =
  int(gtk_label_get_max_width_chars(cast[ptr Label00](self.impl)))

proc gtk_label_get_mnemonic_keyval(self: ptr Label00): uint32 {.
    importc, libprag.}

proc getMnemonicKeyval*(self: Label): int =
  int(gtk_label_get_mnemonic_keyval(cast[ptr Label00](self.impl)))

proc mnemonicKeyval*(self: Label): int =
  int(gtk_label_get_mnemonic_keyval(cast[ptr Label00](self.impl)))

proc gtk_label_get_mnemonic_widget(self: ptr Label00): ptr Widget00 {.
    importc, libprag.}

proc getMnemonicWidget*(self: Label): Widget =
  let gobj = gtk_label_get_mnemonic_widget(cast[ptr Label00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc mnemonicWidget*(self: Label): Widget =
  let gobj = gtk_label_get_mnemonic_widget(cast[ptr Label00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_label_get_selectable(self: ptr Label00): gboolean {.
    importc, libprag.}

proc getSelectable*(self: Label): bool =
  toBool(gtk_label_get_selectable(cast[ptr Label00](self.impl)))

proc selectable*(self: Label): bool =
  toBool(gtk_label_get_selectable(cast[ptr Label00](self.impl)))

proc gtk_label_get_selection_bounds(self: ptr Label00; start: var int32;
    `end`: var int32): gboolean {.
    importc, libprag.}

proc getSelectionBounds*(self: Label; start: var int; `end`: var int): bool =
  var start_00: int32
  var end_00: int32
  result = toBool(gtk_label_get_selection_bounds(cast[ptr Label00](self.impl), start_00, end_00))
  if start.addr != nil:
    start = int(start_00)
  if `end`.addr != nil:
    `end` = int(end_00)

proc gtk_label_get_single_line_mode(self: ptr Label00): gboolean {.
    importc, libprag.}

proc getSingleLineMode*(self: Label): bool =
  toBool(gtk_label_get_single_line_mode(cast[ptr Label00](self.impl)))

proc singleLineMode*(self: Label): bool =
  toBool(gtk_label_get_single_line_mode(cast[ptr Label00](self.impl)))

proc gtk_label_get_text(self: ptr Label00): cstring {.
    importc, libprag.}

proc getText*(self: Label): string =
  result = $gtk_label_get_text(cast[ptr Label00](self.impl))

proc text*(self: Label): string =
  result = $gtk_label_get_text(cast[ptr Label00](self.impl))

proc gtk_label_get_track_visited_links(self: ptr Label00): gboolean {.
    importc, libprag.}

proc getTrackVisitedLinks*(self: Label): bool =
  toBool(gtk_label_get_track_visited_links(cast[ptr Label00](self.impl)))

proc trackVisitedLinks*(self: Label): bool =
  toBool(gtk_label_get_track_visited_links(cast[ptr Label00](self.impl)))

proc gtk_label_get_use_markup(self: ptr Label00): gboolean {.
    importc, libprag.}

proc getUseMarkup*(self: Label): bool =
  toBool(gtk_label_get_use_markup(cast[ptr Label00](self.impl)))

proc useMarkup*(self: Label): bool =
  toBool(gtk_label_get_use_markup(cast[ptr Label00](self.impl)))

proc gtk_label_get_use_underline(self: ptr Label00): gboolean {.
    importc, libprag.}

proc getUseUnderline*(self: Label): bool =
  toBool(gtk_label_get_use_underline(cast[ptr Label00](self.impl)))

proc useUnderline*(self: Label): bool =
  toBool(gtk_label_get_use_underline(cast[ptr Label00](self.impl)))

proc gtk_label_get_width_chars(self: ptr Label00): int32 {.
    importc, libprag.}

proc getWidthChars*(self: Label): int =
  int(gtk_label_get_width_chars(cast[ptr Label00](self.impl)))

proc widthChars*(self: Label): int =
  int(gtk_label_get_width_chars(cast[ptr Label00](self.impl)))

proc gtk_label_get_xalign(self: ptr Label00): cfloat {.
    importc, libprag.}

proc getXalign*(self: Label): cfloat =
  gtk_label_get_xalign(cast[ptr Label00](self.impl))

proc xalign*(self: Label): cfloat =
  gtk_label_get_xalign(cast[ptr Label00](self.impl))

proc gtk_label_get_yalign(self: ptr Label00): cfloat {.
    importc, libprag.}

proc getYalign*(self: Label): cfloat =
  gtk_label_get_yalign(cast[ptr Label00](self.impl))

proc yalign*(self: Label): cfloat =
  gtk_label_get_yalign(cast[ptr Label00](self.impl))

proc gtk_label_select_region(self: ptr Label00; startOffset: int32; endOffset: int32) {.
    importc, libprag.}

proc selectRegion*(self: Label; startOffset: int; endOffset: int) =
  gtk_label_select_region(cast[ptr Label00](self.impl), int32(startOffset), int32(endOffset))

proc gtk_label_set_angle(self: ptr Label00; angle: cdouble) {.
    importc, libprag.}

proc setAngle*(self: Label; angle: cdouble) =
  gtk_label_set_angle(cast[ptr Label00](self.impl), angle)

proc `angle=`*(self: Label; angle: cdouble) =
  gtk_label_set_angle(cast[ptr Label00](self.impl), angle)

proc gtk_label_set_attributes(self: ptr Label00; attrs: ptr pango.AttrList00) {.
    importc, libprag.}

proc setAttributes*(self: Label; attrs: pango.AttrList = nil) =
  gtk_label_set_attributes(cast[ptr Label00](self.impl), if attrs.isNil: nil else: cast[ptr pango.AttrList00](attrs.impl))

proc `attributes=`*(self: Label; attrs: pango.AttrList = nil) =
  gtk_label_set_attributes(cast[ptr Label00](self.impl), if attrs.isNil: nil else: cast[ptr pango.AttrList00](attrs.impl))

proc gtk_label_set_ellipsize(self: ptr Label00; mode: pango.EllipsizeMode) {.
    importc, libprag.}

proc setEllipsize*(self: Label; mode: pango.EllipsizeMode) =
  gtk_label_set_ellipsize(cast[ptr Label00](self.impl), mode)

proc `ellipsize=`*(self: Label; mode: pango.EllipsizeMode) =
  gtk_label_set_ellipsize(cast[ptr Label00](self.impl), mode)

proc gtk_label_set_label(self: ptr Label00; str: cstring) {.
    importc, libprag.}

proc setLabel*(self: Label; str: cstring) =
  gtk_label_set_label(cast[ptr Label00](self.impl), str)

proc `label=`*(self: Label; str: cstring) =
  gtk_label_set_label(cast[ptr Label00](self.impl), str)

proc gtk_label_set_line_wrap(self: ptr Label00; wrap: gboolean) {.
    importc, libprag.}

proc setLineWrap*(self: Label; wrap: bool = true) =
  gtk_label_set_line_wrap(cast[ptr Label00](self.impl), gboolean(wrap))

proc `lineWrap=`*(self: Label; wrap: bool) =
  gtk_label_set_line_wrap(cast[ptr Label00](self.impl), gboolean(wrap))

proc gtk_label_set_line_wrap_mode(self: ptr Label00; wrapMode: pango.WrapMode) {.
    importc, libprag.}

proc setLineWrapMode*(self: Label; wrapMode: pango.WrapMode) =
  gtk_label_set_line_wrap_mode(cast[ptr Label00](self.impl), wrapMode)

proc `lineWrapMode=`*(self: Label; wrapMode: pango.WrapMode) =
  gtk_label_set_line_wrap_mode(cast[ptr Label00](self.impl), wrapMode)

proc gtk_label_set_lines(self: ptr Label00; lines: int32) {.
    importc, libprag.}

proc setLines*(self: Label; lines: int) =
  gtk_label_set_lines(cast[ptr Label00](self.impl), int32(lines))

proc `lines=`*(self: Label; lines: int) =
  gtk_label_set_lines(cast[ptr Label00](self.impl), int32(lines))

proc gtk_label_set_markup(self: ptr Label00; str: cstring) {.
    importc, libprag.}

proc setMarkup*(self: Label; str: cstring) =
  gtk_label_set_markup(cast[ptr Label00](self.impl), str)

proc `markup=`*(self: Label; str: cstring) =
  gtk_label_set_markup(cast[ptr Label00](self.impl), str)

proc gtk_label_set_markup_with_mnemonic(self: ptr Label00; str: cstring) {.
    importc, libprag.}

proc setMarkupWithMnemonic*(self: Label; str: cstring) =
  gtk_label_set_markup_with_mnemonic(cast[ptr Label00](self.impl), str)

proc `markupWithMnemonic=`*(self: Label; str: cstring) =
  gtk_label_set_markup_with_mnemonic(cast[ptr Label00](self.impl), str)

proc gtk_label_set_max_width_chars(self: ptr Label00; nChars: int32) {.
    importc, libprag.}

proc setMaxWidthChars*(self: Label; nChars: int) =
  gtk_label_set_max_width_chars(cast[ptr Label00](self.impl), int32(nChars))

proc `maxWidthChars=`*(self: Label; nChars: int) =
  gtk_label_set_max_width_chars(cast[ptr Label00](self.impl), int32(nChars))

proc gtk_label_set_mnemonic_widget(self: ptr Label00; widget: ptr Widget00) {.
    importc, libprag.}

proc setMnemonicWidget*(self: Label; widget: Widget = nil) =
  gtk_label_set_mnemonic_widget(cast[ptr Label00](self.impl), if widget.isNil: nil else: cast[ptr Widget00](widget.impl))

proc `mnemonicWidget=`*(self: Label; widget: Widget = nil) =
  gtk_label_set_mnemonic_widget(cast[ptr Label00](self.impl), if widget.isNil: nil else: cast[ptr Widget00](widget.impl))

proc gtk_label_set_pattern(self: ptr Label00; pattern: cstring) {.
    importc, libprag.}

proc setPattern*(self: Label; pattern: cstring) =
  gtk_label_set_pattern(cast[ptr Label00](self.impl), pattern)

proc `pattern=`*(self: Label; pattern: cstring) =
  gtk_label_set_pattern(cast[ptr Label00](self.impl), pattern)

proc gtk_label_set_selectable(self: ptr Label00; setting: gboolean) {.
    importc, libprag.}

proc setSelectable*(self: Label; setting: bool = true) =
  gtk_label_set_selectable(cast[ptr Label00](self.impl), gboolean(setting))

proc `selectable=`*(self: Label; setting: bool) =
  gtk_label_set_selectable(cast[ptr Label00](self.impl), gboolean(setting))

proc gtk_label_set_single_line_mode(self: ptr Label00; singleLineMode: gboolean) {.
    importc, libprag.}

proc setSingleLineMode*(self: Label; singleLineMode: bool = true) =
  gtk_label_set_single_line_mode(cast[ptr Label00](self.impl), gboolean(singleLineMode))

proc `singleLineMode=`*(self: Label; singleLineMode: bool) =
  gtk_label_set_single_line_mode(cast[ptr Label00](self.impl), gboolean(singleLineMode))

proc gtk_label_set_text(self: ptr Label00; str: cstring) {.
    importc, libprag.}

proc setText*(self: Label; str: cstring) =
  gtk_label_set_text(cast[ptr Label00](self.impl), str)

proc `text=`*(self: Label; str: cstring) =
  gtk_label_set_text(cast[ptr Label00](self.impl), str)

proc gtk_label_set_text_with_mnemonic(self: ptr Label00; str: cstring) {.
    importc, libprag.}

proc setTextWithMnemonic*(self: Label; str: cstring) =
  gtk_label_set_text_with_mnemonic(cast[ptr Label00](self.impl), str)

proc `textWithMnemonic=`*(self: Label; str: cstring) =
  gtk_label_set_text_with_mnemonic(cast[ptr Label00](self.impl), str)

proc gtk_label_set_track_visited_links(self: ptr Label00; trackLinks: gboolean) {.
    importc, libprag.}

proc setTrackVisitedLinks*(self: Label; trackLinks: bool = true) =
  gtk_label_set_track_visited_links(cast[ptr Label00](self.impl), gboolean(trackLinks))

proc `trackVisitedLinks=`*(self: Label; trackLinks: bool) =
  gtk_label_set_track_visited_links(cast[ptr Label00](self.impl), gboolean(trackLinks))

proc gtk_label_set_use_markup(self: ptr Label00; setting: gboolean) {.
    importc, libprag.}

proc setUseMarkup*(self: Label; setting: bool = true) =
  gtk_label_set_use_markup(cast[ptr Label00](self.impl), gboolean(setting))

proc `useMarkup=`*(self: Label; setting: bool) =
  gtk_label_set_use_markup(cast[ptr Label00](self.impl), gboolean(setting))

proc gtk_label_set_use_underline(self: ptr Label00; setting: gboolean) {.
    importc, libprag.}

proc setUseUnderline*(self: Label; setting: bool = true) =
  gtk_label_set_use_underline(cast[ptr Label00](self.impl), gboolean(setting))

proc `useUnderline=`*(self: Label; setting: bool) =
  gtk_label_set_use_underline(cast[ptr Label00](self.impl), gboolean(setting))

proc gtk_label_set_width_chars(self: ptr Label00; nChars: int32) {.
    importc, libprag.}

proc setWidthChars*(self: Label; nChars: int) =
  gtk_label_set_width_chars(cast[ptr Label00](self.impl), int32(nChars))

proc `widthChars=`*(self: Label; nChars: int) =
  gtk_label_set_width_chars(cast[ptr Label00](self.impl), int32(nChars))

proc gtk_label_set_xalign(self: ptr Label00; xalign: cfloat) {.
    importc, libprag.}

proc setXalign*(self: Label; xalign: cfloat) =
  gtk_label_set_xalign(cast[ptr Label00](self.impl), xalign)

proc `xalign=`*(self: Label; xalign: cfloat) =
  gtk_label_set_xalign(cast[ptr Label00](self.impl), xalign)

proc gtk_label_set_yalign(self: ptr Label00; yalign: cfloat) {.
    importc, libprag.}

proc setYalign*(self: Label; yalign: cfloat) =
  gtk_label_set_yalign(cast[ptr Label00](self.impl), yalign)

proc `yalign=`*(self: Label; yalign: cfloat) =
  gtk_label_set_yalign(cast[ptr Label00](self.impl), yalign)

type
  AccelLabel* = ref object of Label
  AccelLabel00* = object of Label00

proc gtk_accel_label_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(AccelLabel()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_accel_label_new(string: cstring): ptr AccelLabel00 {.
    importc, libprag.}

proc newAccelLabel*(string: cstring): AccelLabel =
  let gobj = gtk_accel_label_new(string)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newAccelLabel*(tdesc: typedesc; string: cstring): tdesc =
  assert(result is AccelLabel)
  let gobj = gtk_accel_label_new(string)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initAccelLabel*[T](result: var T; string: cstring) {.deprecated.} =
  assert(result is AccelLabel)
  let gobj = gtk_accel_label_new(string)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_accel_label_get_accel(self: ptr AccelLabel00; acceleratorKey: var uint32;
    acceleratorMods: var gdk.ModifierType) {.
    importc, libprag.}

proc getAccel*(self: AccelLabel; acceleratorKey: var int;
    acceleratorMods: var gdk.ModifierType) =
  var acceleratorKey_00: uint32
  gtk_accel_label_get_accel(cast[ptr AccelLabel00](self.impl), acceleratorKey_00, acceleratorMods)
  if acceleratorKey.addr != nil:
    acceleratorKey = int(acceleratorKey_00)

proc gtk_accel_label_get_accel_widget(self: ptr AccelLabel00): ptr Widget00 {.
    importc, libprag.}

proc getAccelWidget*(self: AccelLabel): Widget =
  let gobj = gtk_accel_label_get_accel_widget(cast[ptr AccelLabel00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc accelWidget*(self: AccelLabel): Widget =
  let gobj = gtk_accel_label_get_accel_widget(cast[ptr AccelLabel00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_accel_label_get_accel_width(self: ptr AccelLabel00): uint32 {.
    importc, libprag.}

proc getAccelWidth*(self: AccelLabel): int =
  int(gtk_accel_label_get_accel_width(cast[ptr AccelLabel00](self.impl)))

proc accelWidth*(self: AccelLabel): int =
  int(gtk_accel_label_get_accel_width(cast[ptr AccelLabel00](self.impl)))

proc gtk_accel_label_refetch(self: ptr AccelLabel00): gboolean {.
    importc, libprag.}

proc refetch*(self: AccelLabel): bool =
  toBool(gtk_accel_label_refetch(cast[ptr AccelLabel00](self.impl)))

proc gtk_accel_label_set_accel(self: ptr AccelLabel00; acceleratorKey: uint32;
    acceleratorMods: gdk.ModifierType) {.
    importc, libprag.}

proc setAccel*(self: AccelLabel; acceleratorKey: int; acceleratorMods: gdk.ModifierType) =
  gtk_accel_label_set_accel(cast[ptr AccelLabel00](self.impl), uint32(acceleratorKey), acceleratorMods)

proc gtk_accel_label_set_accel_closure(self: ptr AccelLabel00; accelClosure: ptr gobject.Closure00) {.
    importc, libprag.}

proc setAccelClosure*(self: AccelLabel; accelClosure: gobject.Closure = nil) =
  gtk_accel_label_set_accel_closure(cast[ptr AccelLabel00](self.impl), if accelClosure.isNil: nil else: cast[ptr gobject.Closure00](accelClosure.impl))

proc `accelClosure=`*(self: AccelLabel; accelClosure: gobject.Closure = nil) =
  gtk_accel_label_set_accel_closure(cast[ptr AccelLabel00](self.impl), if accelClosure.isNil: nil else: cast[ptr gobject.Closure00](accelClosure.impl))

proc gtk_accel_label_set_accel_widget(self: ptr AccelLabel00; accelWidget: ptr Widget00) {.
    importc, libprag.}

proc setAccelWidget*(self: AccelLabel; accelWidget: Widget = nil) =
  gtk_accel_label_set_accel_widget(cast[ptr AccelLabel00](self.impl), if accelWidget.isNil: nil else: cast[ptr Widget00](accelWidget.impl))

proc `accelWidget=`*(self: AccelLabel; accelWidget: Widget = nil) =
  gtk_accel_label_set_accel_widget(cast[ptr AccelLabel00](self.impl), if accelWidget.isNil: nil else: cast[ptr Widget00](accelWidget.impl))

type
  Justification* {.size: sizeof(cint), pure.} = enum
    left = 0
    right = 1
    center = 2
    fill = 3

proc gtk_label_get_justify(self: ptr Label00): Justification {.
    importc, libprag.}

proc getJustify*(self: Label): Justification =
  gtk_label_get_justify(cast[ptr Label00](self.impl))

proc justify*(self: Label): Justification =
  gtk_label_get_justify(cast[ptr Label00](self.impl))

proc gtk_label_set_justify(self: ptr Label00; jtype: Justification) {.
    importc, libprag.}

proc setJustify*(self: Label; jtype: Justification) =
  gtk_label_set_justify(cast[ptr Label00](self.impl), jtype)

proc `justify=`*(self: Label; jtype: Justification) =
  gtk_label_set_justify(cast[ptr Label00](self.impl), jtype)

type
  MenuItem* = ref object of Bin
  MenuItem00* = object of Bin00

proc gtk_menu_item_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(MenuItem()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scActivate*(self: MenuItem;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "activate", cast[GCallback](p), xdata, nil, cf)

proc scActivateItem*(self: MenuItem;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "activate-item", cast[GCallback](p), xdata, nil, cf)

proc scDeselect*(self: MenuItem;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "deselect", cast[GCallback](p), xdata, nil, cf)

proc scSelect*(self: MenuItem;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "select", cast[GCallback](p), xdata, nil, cf)

proc scToggleSizeAllocate*(self: MenuItem;  p: proc (self: ptr MenuItem00; `object`: int32; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "toggle-size-allocate", cast[GCallback](p), xdata, nil, cf)

proc scToggleSizeRequest*(self: MenuItem;  p: proc (self: ptr MenuItem00; `object`: pointer; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "toggle-size-request", cast[GCallback](p), xdata, nil, cf)

proc gtk_menu_item_new(): ptr MenuItem00 {.
    importc, libprag.}

proc newMenuItem*(): MenuItem =
  let gobj = gtk_menu_item_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newMenuItem*(tdesc: typedesc): tdesc =
  assert(result is MenuItem)
  let gobj = gtk_menu_item_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initMenuItem*[T](result: var T) {.deprecated.} =
  assert(result is MenuItem)
  let gobj = gtk_menu_item_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_menu_item_new_with_label(label: cstring): ptr MenuItem00 {.
    importc, libprag.}

proc newMenuItemWithLabel*(label: cstring): MenuItem =
  let gobj = gtk_menu_item_new_with_label(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newMenuItemWithLabel*(tdesc: typedesc; label: cstring): tdesc =
  assert(result is MenuItem)
  let gobj = gtk_menu_item_new_with_label(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initMenuItemWithLabel*[T](result: var T; label: cstring) {.deprecated.} =
  assert(result is MenuItem)
  let gobj = gtk_menu_item_new_with_label(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_menu_item_new_with_mnemonic(label: cstring): ptr MenuItem00 {.
    importc, libprag.}

proc newMenuItemWithMnemonic*(label: cstring): MenuItem =
  let gobj = gtk_menu_item_new_with_mnemonic(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newMenuItemWithMnemonic*(tdesc: typedesc; label: cstring): tdesc =
  assert(result is MenuItem)
  let gobj = gtk_menu_item_new_with_mnemonic(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initMenuItemWithMnemonic*[T](result: var T; label: cstring) {.deprecated.} =
  assert(result is MenuItem)
  let gobj = gtk_menu_item_new_with_mnemonic(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_menu_item_activate(self: ptr MenuItem00) {.
    importc, libprag.}

proc activate*(self: MenuItem) =
  gtk_menu_item_activate(cast[ptr MenuItem00](self.impl))

proc gtk_menu_item_deselect(self: ptr MenuItem00) {.
    importc, libprag.}

proc deselect*(self: MenuItem) =
  gtk_menu_item_deselect(cast[ptr MenuItem00](self.impl))

proc gtk_menu_item_get_accel_path(self: ptr MenuItem00): cstring {.
    importc, libprag.}

proc getAccelPath*(self: MenuItem): string =
  let resul0 = gtk_menu_item_get_accel_path(cast[ptr MenuItem00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc accelPath*(self: MenuItem): string =
  let resul0 = gtk_menu_item_get_accel_path(cast[ptr MenuItem00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc gtk_menu_item_get_label(self: ptr MenuItem00): cstring {.
    importc, libprag.}

proc getLabel*(self: MenuItem): string =
  result = $gtk_menu_item_get_label(cast[ptr MenuItem00](self.impl))

proc label*(self: MenuItem): string =
  result = $gtk_menu_item_get_label(cast[ptr MenuItem00](self.impl))

proc gtk_menu_item_get_reserve_indicator(self: ptr MenuItem00): gboolean {.
    importc, libprag.}

proc getReserveIndicator*(self: MenuItem): bool =
  toBool(gtk_menu_item_get_reserve_indicator(cast[ptr MenuItem00](self.impl)))

proc reserveIndicator*(self: MenuItem): bool =
  toBool(gtk_menu_item_get_reserve_indicator(cast[ptr MenuItem00](self.impl)))

proc gtk_menu_item_get_right_justified(self: ptr MenuItem00): gboolean {.
    importc, libprag.}

proc getRightJustified*(self: MenuItem): bool =
  toBool(gtk_menu_item_get_right_justified(cast[ptr MenuItem00](self.impl)))

proc rightJustified*(self: MenuItem): bool =
  toBool(gtk_menu_item_get_right_justified(cast[ptr MenuItem00](self.impl)))

proc gtk_menu_item_get_submenu(self: ptr MenuItem00): ptr Widget00 {.
    importc, libprag.}

proc getSubmenu*(self: MenuItem): Widget =
  let gobj = gtk_menu_item_get_submenu(cast[ptr MenuItem00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc submenu*(self: MenuItem): Widget =
  let gobj = gtk_menu_item_get_submenu(cast[ptr MenuItem00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_menu_item_get_use_underline(self: ptr MenuItem00): gboolean {.
    importc, libprag.}

proc getUseUnderline*(self: MenuItem): bool =
  toBool(gtk_menu_item_get_use_underline(cast[ptr MenuItem00](self.impl)))

proc useUnderline*(self: MenuItem): bool =
  toBool(gtk_menu_item_get_use_underline(cast[ptr MenuItem00](self.impl)))

proc gtk_menu_item_select(self: ptr MenuItem00) {.
    importc, libprag.}

proc select*(self: MenuItem) =
  gtk_menu_item_select(cast[ptr MenuItem00](self.impl))

proc gtk_menu_item_set_accel_path(self: ptr MenuItem00; accelPath: cstring) {.
    importc, libprag.}

proc setAccelPath*(self: MenuItem; accelPath: cstring = nil) =
  gtk_menu_item_set_accel_path(cast[ptr MenuItem00](self.impl), accelPath)

proc `accelPath=`*(self: MenuItem; accelPath: cstring = nil) =
  gtk_menu_item_set_accel_path(cast[ptr MenuItem00](self.impl), accelPath)

proc gtk_menu_item_set_label(self: ptr MenuItem00; label: cstring) {.
    importc, libprag.}

proc setLabel*(self: MenuItem; label: cstring) =
  gtk_menu_item_set_label(cast[ptr MenuItem00](self.impl), label)

proc `label=`*(self: MenuItem; label: cstring) =
  gtk_menu_item_set_label(cast[ptr MenuItem00](self.impl), label)

proc gtk_menu_item_set_reserve_indicator(self: ptr MenuItem00; reserve: gboolean) {.
    importc, libprag.}

proc setReserveIndicator*(self: MenuItem; reserve: bool = true) =
  gtk_menu_item_set_reserve_indicator(cast[ptr MenuItem00](self.impl), gboolean(reserve))

proc `reserveIndicator=`*(self: MenuItem; reserve: bool) =
  gtk_menu_item_set_reserve_indicator(cast[ptr MenuItem00](self.impl), gboolean(reserve))

proc gtk_menu_item_set_right_justified(self: ptr MenuItem00; rightJustified: gboolean) {.
    importc, libprag.}

proc setRightJustified*(self: MenuItem; rightJustified: bool = true) =
  gtk_menu_item_set_right_justified(cast[ptr MenuItem00](self.impl), gboolean(rightJustified))

proc `rightJustified=`*(self: MenuItem; rightJustified: bool) =
  gtk_menu_item_set_right_justified(cast[ptr MenuItem00](self.impl), gboolean(rightJustified))

proc gtk_menu_item_set_submenu(self: ptr MenuItem00; submenu: ptr Menu00) {.
    importc, libprag.}

proc setSubmenu*(self: MenuItem; submenu: Menu = nil) =
  gtk_menu_item_set_submenu(cast[ptr MenuItem00](self.impl), if submenu.isNil: nil else: cast[ptr Menu00](submenu.impl))

proc `submenu=`*(self: MenuItem; submenu: Menu = nil) =
  gtk_menu_item_set_submenu(cast[ptr MenuItem00](self.impl), if submenu.isNil: nil else: cast[ptr Menu00](submenu.impl))

proc gtk_menu_item_set_use_underline(self: ptr MenuItem00; setting: gboolean) {.
    importc, libprag.}

proc setUseUnderline*(self: MenuItem; setting: bool = true) =
  gtk_menu_item_set_use_underline(cast[ptr MenuItem00](self.impl), gboolean(setting))

proc `useUnderline=`*(self: MenuItem; setting: bool) =
  gtk_menu_item_set_use_underline(cast[ptr MenuItem00](self.impl), gboolean(setting))

proc gtk_menu_item_toggle_size_allocate(self: ptr MenuItem00; allocation: int32) {.
    importc, libprag.}

proc toggleSizeAllocate*(self: MenuItem; allocation: int) =
  gtk_menu_item_toggle_size_allocate(cast[ptr MenuItem00](self.impl), int32(allocation))

proc gtk_menu_item_toggle_size_request(self: ptr MenuItem00; requisition: var int32) {.
    importc, libprag.}

proc toggleSizeRequest*(self: MenuItem; requisition: var int) =
  var requisition_00 = int32(requisition)
  gtk_menu_item_toggle_size_request(cast[ptr MenuItem00](self.impl), requisition_00)
  requisition = int(requisition_00)

proc gtk_menu_shell_append(self: ptr MenuShell00; child: ptr MenuItem00) {.
    importc, libprag.}

proc append*(self: MenuShell; child: MenuItem) =
  gtk_menu_shell_append(cast[ptr MenuShell00](self.impl), cast[ptr MenuItem00](child.impl))

type
  AccelMap* = ref object of gobject.Object
  AccelMap00* = object of gobject.Object00

proc gtk_accel_map_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(AccelMap()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scChanged*(self: AccelMap;  p: proc (self: ptr AccelMap00; accelPath: cstring; accelKey: uint32; accelMods: gdk.ModifierType; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "changed", cast[GCallback](p), xdata, nil, cf)

proc gtk_accel_map_add_entry(accelPath: cstring; accelKey: uint32; accelMods: gdk.ModifierType) {.
    importc, libprag.}

proc addEntry*(accelPath: cstring; accelKey: int; accelMods: gdk.ModifierType) =
  gtk_accel_map_add_entry(accelPath, uint32(accelKey), accelMods)

proc addFilter*(filterPattern: cstring) {.
    importc: "gtk_accel_map_add_filter", libprag.}

proc gtk_accel_map_change_entry(accelPath: cstring; accelKey: uint32; accelMods: gdk.ModifierType;
    replace: gboolean): gboolean {.
    importc, libprag.}

proc changeEntry*(accelPath: cstring; accelKey: int; accelMods: gdk.ModifierType;
    replace: bool): bool =
  toBool(gtk_accel_map_change_entry(accelPath, uint32(accelKey), accelMods, gboolean(replace)))

proc gtk_accel_map_get(): ptr AccelMap00 {.
    importc, libprag.}

proc getAccelMap*(): AccelMap =
  let gobj = gtk_accel_map_get()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc load*(fileName: cstring) {.
    importc: "gtk_accel_map_load", libprag.}

proc gtk_accel_map_load_fd(fd: int32) {.
    importc, libprag.}

proc loadFd*(fd: int) =
  gtk_accel_map_load_fd(int32(fd))

proc gtk_accel_map_load_scanner(scanner: ptr glib.Scanner00) {.
    importc, libprag.}

proc loadScanner*(scanner: glib.Scanner) =
  gtk_accel_map_load_scanner(cast[ptr glib.Scanner00](scanner.impl))

proc lockPath*(accelPath: cstring) {.
    importc: "gtk_accel_map_lock_path", libprag.}

proc gtk_accel_map_lookup_entry(accelPath: cstring; key: var AccelKey): gboolean {.
    importc, libprag.}

proc lookupEntry*(accelPath: cstring; key: var AccelKey = cast[var AccelKey](nil)): bool =
  toBool(gtk_accel_map_lookup_entry(accelPath, key))

proc save*(fileName: cstring) {.
    importc: "gtk_accel_map_save", libprag.}

proc gtk_accel_map_save_fd(fd: int32) {.
    importc, libprag.}

proc saveFd*(fd: int) =
  gtk_accel_map_save_fd(int32(fd))

proc unlockPath*(accelPath: cstring) {.
    importc: "gtk_accel_map_unlock_path", libprag.}

type
  AccelMapForeach* = proc (data: pointer; accelPath: cstring; accelKey: uint32; accelMods: gdk.ModifierType;
    changed: gboolean) {.cdecl.}

proc foreach*(data: pointer; foreachFunc: AccelMapForeach) {.
    importc: "gtk_accel_map_foreach", libprag.}

proc foreachUnfiltered*(data: pointer; foreachFunc: AccelMapForeach) {.
    importc: "gtk_accel_map_foreach_unfiltered", libprag.}

type
  ExpanderAccessible* = ref object of ContainerAccessible
  ExpanderAccessible00* = object of ContainerAccessible00

proc gtk_expander_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ExpanderAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  CellAccessible* = ref object of Accessible
  CellAccessible00* = object of Accessible00

proc gtk_cell_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(CellAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  ContainerCellAccessible* = ref object of CellAccessible
  ContainerCellAccessible00* = object of CellAccessible00

proc gtk_container_cell_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ContainerCellAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_container_cell_accessible_new(): ptr ContainerCellAccessible00 {.
    importc, libprag.}

proc newContainerCellAccessible*(): ContainerCellAccessible =
  let gobj = gtk_container_cell_accessible_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newContainerCellAccessible*(tdesc: typedesc): tdesc =
  assert(result is ContainerCellAccessible)
  let gobj = gtk_container_cell_accessible_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initContainerCellAccessible*[T](result: var T) {.deprecated.} =
  assert(result is ContainerCellAccessible)
  let gobj = gtk_container_cell_accessible_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_container_cell_accessible_add_child(self: ptr ContainerCellAccessible00;
    child: ptr CellAccessible00) {.
    importc, libprag.}

proc addChild*(self: ContainerCellAccessible;
    child: CellAccessible) =
  gtk_container_cell_accessible_add_child(cast[ptr ContainerCellAccessible00](self.impl), cast[ptr CellAccessible00](child.impl))

proc gtk_container_cell_accessible_get_children(self: ptr ContainerCellAccessible00): ptr glib.List {.
    importc, libprag.}

proc getChildren*(self: ContainerCellAccessible): seq[CellAccessible] =
  result = glistObjects2seq(CellAccessible, gtk_container_cell_accessible_get_children(cast[ptr ContainerCellAccessible00](self.impl)), false)

proc children*(self: ContainerCellAccessible): seq[CellAccessible] =
  result = glistObjects2seq(CellAccessible, gtk_container_cell_accessible_get_children(cast[ptr ContainerCellAccessible00](self.impl)), false)

proc gtk_container_cell_accessible_remove_child(self: ptr ContainerCellAccessible00;
    child: ptr CellAccessible00) {.
    importc, libprag.}

proc removeChild*(self: ContainerCellAccessible;
    child: CellAccessible) =
  gtk_container_cell_accessible_remove_child(cast[ptr ContainerCellAccessible00](self.impl), cast[ptr CellAccessible00](child.impl))

type
  ButtonAccessible* = ref object of ContainerAccessible
  ButtonAccessible00* = object of ContainerAccessible00

proc gtk_button_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ButtonAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  LockButtonAccessible* = ref object of ButtonAccessible
  LockButtonAccessible00* = object of ButtonAccessible00

proc gtk_lock_button_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(LockButtonAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  SwitchAccessible* = ref object of WidgetAccessible
  SwitchAccessible00* = object of WidgetAccessible00

proc gtk_switch_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(SwitchAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  MenuItemAccessible* = ref object of ContainerAccessible
  MenuItemAccessible00* = object of ContainerAccessible00

proc gtk_menu_item_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(MenuItemAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  CheckMenuItemAccessible* = ref object of MenuItemAccessible
  CheckMenuItemAccessible00* = object of MenuItemAccessible00

proc gtk_check_menu_item_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(CheckMenuItemAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  ToggleButtonAccessible* = ref object of ButtonAccessible
  ToggleButtonAccessible00* = object of ButtonAccessible00

proc gtk_toggle_button_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ToggleButtonAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  RadioButtonAccessible* = ref object of ToggleButtonAccessible
  RadioButtonAccessible00* = object of ToggleButtonAccessible00

proc gtk_radio_button_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(RadioButtonAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  LinkButtonAccessible* = ref object of ButtonAccessible
  LinkButtonAccessible00* = object of ButtonAccessible00

proc gtk_link_button_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(LinkButtonAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  RendererCellAccessible* = ref object of CellAccessible
  RendererCellAccessible00* = object of CellAccessible00

proc gtk_renderer_cell_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(RendererCellAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  ImageCellAccessible* = ref object of RendererCellAccessible
  ImageCellAccessible00* = object of RendererCellAccessible00

proc gtk_image_cell_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ImageCellAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  EntryAccessible* = ref object of WidgetAccessible
  EntryAccessible00* = object of WidgetAccessible00

proc gtk_entry_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(EntryAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  SpinButtonAccessible* = ref object of EntryAccessible
  SpinButtonAccessible00* = object of EntryAccessible00

proc gtk_spin_button_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(SpinButtonAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  MenuButtonAccessible* = ref object of ToggleButtonAccessible
  MenuButtonAccessible00* = object of ToggleButtonAccessible00

proc gtk_menu_button_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(MenuButtonAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  ComboBoxAccessible* = ref object of ContainerAccessible
  ComboBoxAccessible00* = object of ContainerAccessible00

proc gtk_combo_box_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ComboBoxAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  RadioMenuItemAccessible* = ref object of CheckMenuItemAccessible
  RadioMenuItemAccessible00* = object of CheckMenuItemAccessible00

proc gtk_radio_menu_item_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(RadioMenuItemAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  ScaleButtonAccessible* = ref object of ButtonAccessible
  ScaleButtonAccessible00* = object of ButtonAccessible00

proc gtk_scale_button_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ScaleButtonAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  BooleanCellAccessible* = ref object of RendererCellAccessible
  BooleanCellAccessible00* = object of RendererCellAccessible00

proc gtk_boolean_cell_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(BooleanCellAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  TextCellAccessible* = ref object of RendererCellAccessible
  TextCellAccessible00* = object of RendererCellAccessible00

proc gtk_text_cell_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(TextCellAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  EntryIconAccessible* = ref object of atk.Object
  EntryIconAccessible00* = object of atk.Object00

proc gtk_entry_icon_accessible_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(EntryIconAccessible()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

type
  Action* = ref object of gobject.Object
  Action00* = object of gobject.Object00

proc gtk_action_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Action()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scActivate*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "activate", cast[GCallback](p), xdata, nil, cf)

proc gtk_action_new(name: cstring; label: cstring; tooltip: cstring; stockId: cstring): ptr Action00 {.
    importc, libprag.}

proc newAction*(name: cstring; label: cstring = nil; tooltip: cstring = nil;
    stockId: cstring = nil): Action {.deprecated.}  =
  let gobj = gtk_action_new(name, label, tooltip, stockId)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newAction*(tdesc: typedesc; name: cstring; label: cstring = nil; tooltip: cstring = nil;
    stockId: cstring = nil): tdesc {.deprecated.}  =
  assert(result is Action)
  let gobj = gtk_action_new(name, label, tooltip, stockId)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initAction*[T](result: var T; name: cstring; label: cstring = nil; tooltip: cstring = nil;
    stockId: cstring = nil) {.deprecated.} =
  assert(result is Action)
  let gobj = gtk_action_new(name, label, tooltip, stockId)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_action_activate(self: ptr Action00) {.
    importc, libprag.}

proc activate*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible) =
  gtk_action_activate(cast[ptr Action00](self.impl))

proc gtk_action_block_activate(self: ptr Action00) {.
    importc, libprag.}

proc blockActivate*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible) =
  gtk_action_block_activate(cast[ptr Action00](self.impl))

proc gtk_action_connect_accelerator(self: ptr Action00) {.
    importc, libprag.}

proc connectAccelerator*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible) =
  gtk_action_connect_accelerator(cast[ptr Action00](self.impl))

proc gtk_action_create_icon(self: ptr Action00; iconSize: int32): ptr Widget00 {.
    importc, libprag.}

proc createIcon*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    iconSize: int): Widget =
  let gobj = gtk_action_create_icon(cast[ptr Action00](self.impl), int32(iconSize))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_action_create_menu(self: ptr Action00): ptr Widget00 {.
    importc, libprag.}

proc createMenu*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): Widget =
  let gobj = gtk_action_create_menu(cast[ptr Action00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_action_create_menu_item(self: ptr Action00): ptr Widget00 {.
    importc, libprag.}

proc createMenuItem*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): Widget =
  let gobj = gtk_action_create_menu_item(cast[ptr Action00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_action_create_tool_item(self: ptr Action00): ptr Widget00 {.
    importc, libprag.}

proc createToolItem*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): Widget =
  let gobj = gtk_action_create_tool_item(cast[ptr Action00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_action_disconnect_accelerator(self: ptr Action00) {.
    importc, libprag.}

proc disconnectAccelerator*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible) =
  gtk_action_disconnect_accelerator(cast[ptr Action00](self.impl))

proc gtk_action_get_accel_closure(self: ptr Action00): ptr gobject.Closure00 {.
    importc, libprag.}

proc getAccelClosure*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): gobject.Closure =
  fnew(result, gBoxedFreeGClosure)
  result.impl = gtk_action_get_accel_closure(cast[ptr Action00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_closure_get_type(), result.impl))

proc accelClosure*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): gobject.Closure =
  fnew(result, gBoxedFreeGClosure)
  result.impl = gtk_action_get_accel_closure(cast[ptr Action00](self.impl))
  result.impl = cast[typeof(result.impl)](g_boxed_copy(g_closure_get_type(), result.impl))

proc gtk_action_get_accel_path(self: ptr Action00): cstring {.
    importc, libprag.}

proc getAccelPath*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): string =
  result = $gtk_action_get_accel_path(cast[ptr Action00](self.impl))

proc accelPath*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): string =
  result = $gtk_action_get_accel_path(cast[ptr Action00](self.impl))

proc gtk_action_get_always_show_image(self: ptr Action00): gboolean {.
    importc, libprag.}

proc getAlwaysShowImage*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): bool =
  toBool(gtk_action_get_always_show_image(cast[ptr Action00](self.impl)))

proc alwaysShowImage*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): bool =
  toBool(gtk_action_get_always_show_image(cast[ptr Action00](self.impl)))

proc gtk_action_get_gicon(self: ptr Action00): ptr gio.Icon00 {.
    importc, libprag.}

proc getGicon*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): gio.Icon =
  let gobj = gtk_action_get_gicon(cast[ptr Action00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gicon*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): gio.Icon =
  let gobj = gtk_action_get_gicon(cast[ptr Action00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_action_get_icon_name(self: ptr Action00): cstring {.
    importc, libprag.}

proc getIconName*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): string =
  result = $gtk_action_get_icon_name(cast[ptr Action00](self.impl))

proc iconName*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): string =
  result = $gtk_action_get_icon_name(cast[ptr Action00](self.impl))

proc gtk_action_get_is_important(self: ptr Action00): gboolean {.
    importc, libprag.}

proc getIsImportant*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): bool =
  toBool(gtk_action_get_is_important(cast[ptr Action00](self.impl)))

proc isImportant*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): bool =
  toBool(gtk_action_get_is_important(cast[ptr Action00](self.impl)))

proc gtk_action_get_label(self: ptr Action00): cstring {.
    importc, libprag.}

proc getLabel*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): string =
  result = $gtk_action_get_label(cast[ptr Action00](self.impl))

proc label*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): string =
  result = $gtk_action_get_label(cast[ptr Action00](self.impl))

proc gtk_action_get_name(self: ptr Action00): cstring {.
    importc, libprag.}

proc getName*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): string =
  result = $gtk_action_get_name(cast[ptr Action00](self.impl))

proc name*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): string =
  result = $gtk_action_get_name(cast[ptr Action00](self.impl))

proc gtk_action_get_proxies(self: ptr Action00): ptr glib.SList {.
    importc, libprag.}

proc getProxies*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): seq[Widget] =
  result = gslistObjects2seq(Widget, gtk_action_get_proxies(cast[ptr Action00](self.impl)), false)

proc proxies*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): seq[Widget] =
  result = gslistObjects2seq(Widget, gtk_action_get_proxies(cast[ptr Action00](self.impl)), false)

proc gtk_action_get_sensitive(self: ptr Action00): gboolean {.
    importc, libprag.}

proc getSensitive*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): bool =
  toBool(gtk_action_get_sensitive(cast[ptr Action00](self.impl)))

proc sensitive*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): bool =
  toBool(gtk_action_get_sensitive(cast[ptr Action00](self.impl)))

proc gtk_action_get_short_label(self: ptr Action00): cstring {.
    importc, libprag.}

proc getShortLabel*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): string =
  result = $gtk_action_get_short_label(cast[ptr Action00](self.impl))

proc shortLabel*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): string =
  result = $gtk_action_get_short_label(cast[ptr Action00](self.impl))

proc gtk_action_get_stock_id(self: ptr Action00): cstring {.
    importc, libprag.}

proc getStockId*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): string =
  result = $gtk_action_get_stock_id(cast[ptr Action00](self.impl))

proc stockId*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): string =
  result = $gtk_action_get_stock_id(cast[ptr Action00](self.impl))

proc gtk_action_get_tooltip(self: ptr Action00): cstring {.
    importc, libprag.}

proc getTooltip*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): string =
  result = $gtk_action_get_tooltip(cast[ptr Action00](self.impl))

proc tooltip*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): string =
  result = $gtk_action_get_tooltip(cast[ptr Action00](self.impl))

proc gtk_action_get_visible(self: ptr Action00): gboolean {.
    importc, libprag.}

proc getVisible*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): bool =
  toBool(gtk_action_get_visible(cast[ptr Action00](self.impl)))

proc visible*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): bool =
  toBool(gtk_action_get_visible(cast[ptr Action00](self.impl)))

proc gtk_action_get_visible_horizontal(self: ptr Action00): gboolean {.
    importc, libprag.}

proc getVisibleHorizontal*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): bool =
  toBool(gtk_action_get_visible_horizontal(cast[ptr Action00](self.impl)))

proc visibleHorizontal*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): bool =
  toBool(gtk_action_get_visible_horizontal(cast[ptr Action00](self.impl)))

proc gtk_action_get_visible_vertical(self: ptr Action00): gboolean {.
    importc, libprag.}

proc getVisibleVertical*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): bool =
  toBool(gtk_action_get_visible_vertical(cast[ptr Action00](self.impl)))

proc visibleVertical*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): bool =
  toBool(gtk_action_get_visible_vertical(cast[ptr Action00](self.impl)))

proc gtk_action_is_sensitive(self: ptr Action00): gboolean {.
    importc, libprag.}

proc isSensitive*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): bool =
  toBool(gtk_action_is_sensitive(cast[ptr Action00](self.impl)))

proc gtk_action_is_visible(self: ptr Action00): gboolean {.
    importc, libprag.}

proc isVisible*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible): bool =
  toBool(gtk_action_is_visible(cast[ptr Action00](self.impl)))

proc gtk_action_set_accel_group(self: ptr Action00; accelGroup: ptr AccelGroup00) {.
    importc, libprag.}

proc setAccelGroup*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    accelGroup: AccelGroup = nil) =
  gtk_action_set_accel_group(cast[ptr Action00](self.impl), if accelGroup.isNil: nil else: cast[ptr AccelGroup00](accelGroup.impl))

proc `accelGroup=`*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    accelGroup: AccelGroup = nil) =
  gtk_action_set_accel_group(cast[ptr Action00](self.impl), if accelGroup.isNil: nil else: cast[ptr AccelGroup00](accelGroup.impl))

proc gtk_action_set_accel_path(self: ptr Action00; accelPath: cstring) {.
    importc, libprag.}

proc setAccelPath*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    accelPath: cstring) =
  gtk_action_set_accel_path(cast[ptr Action00](self.impl), accelPath)

proc `accelPath=`*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    accelPath: cstring) =
  gtk_action_set_accel_path(cast[ptr Action00](self.impl), accelPath)

proc gtk_action_set_always_show_image(self: ptr Action00; alwaysShow: gboolean) {.
    importc, libprag.}

proc setAlwaysShowImage*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    alwaysShow: bool = true) =
  gtk_action_set_always_show_image(cast[ptr Action00](self.impl), gboolean(alwaysShow))

proc `alwaysShowImage=`*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    alwaysShow: bool) =
  gtk_action_set_always_show_image(cast[ptr Action00](self.impl), gboolean(alwaysShow))

proc gtk_action_set_gicon(self: ptr Action00; icon: ptr gio.Icon00) {.
    importc, libprag.}

proc setGicon*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    icon: gio.Icon) =
  gtk_action_set_gicon(cast[ptr Action00](self.impl), cast[ptr gio.Icon00](icon.impl))

proc `gicon=`*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    icon: gio.Icon) =
  gtk_action_set_gicon(cast[ptr Action00](self.impl), cast[ptr gio.Icon00](icon.impl))

proc gtk_action_set_icon_name(self: ptr Action00; iconName: cstring) {.
    importc, libprag.}

proc setIconName*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    iconName: cstring) =
  gtk_action_set_icon_name(cast[ptr Action00](self.impl), iconName)

proc `iconName=`*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    iconName: cstring) =
  gtk_action_set_icon_name(cast[ptr Action00](self.impl), iconName)

proc gtk_action_set_is_important(self: ptr Action00; isImportant: gboolean) {.
    importc, libprag.}

proc setIsImportant*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    isImportant: bool = true) =
  gtk_action_set_is_important(cast[ptr Action00](self.impl), gboolean(isImportant))

proc `isImportant=`*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    isImportant: bool) =
  gtk_action_set_is_important(cast[ptr Action00](self.impl), gboolean(isImportant))

proc gtk_action_set_label(self: ptr Action00; label: cstring) {.
    importc, libprag.}

proc setLabel*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    label: cstring) =
  gtk_action_set_label(cast[ptr Action00](self.impl), label)

proc `label=`*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    label: cstring) =
  gtk_action_set_label(cast[ptr Action00](self.impl), label)

proc gtk_action_set_sensitive(self: ptr Action00; sensitive: gboolean) {.
    importc, libprag.}

proc setSensitive*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    sensitive: bool = true) =
  gtk_action_set_sensitive(cast[ptr Action00](self.impl), gboolean(sensitive))

proc `sensitive=`*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    sensitive: bool) =
  gtk_action_set_sensitive(cast[ptr Action00](self.impl), gboolean(sensitive))

proc gtk_action_set_short_label(self: ptr Action00; shortLabel: cstring) {.
    importc, libprag.}

proc setShortLabel*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    shortLabel: cstring) =
  gtk_action_set_short_label(cast[ptr Action00](self.impl), shortLabel)

proc `shortLabel=`*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    shortLabel: cstring) =
  gtk_action_set_short_label(cast[ptr Action00](self.impl), shortLabel)

proc gtk_action_set_stock_id(self: ptr Action00; stockId: cstring) {.
    importc, libprag.}

proc setStockId*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    stockId: cstring) =
  gtk_action_set_stock_id(cast[ptr Action00](self.impl), stockId)

proc `stockId=`*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    stockId: cstring) =
  gtk_action_set_stock_id(cast[ptr Action00](self.impl), stockId)

proc gtk_action_set_tooltip(self: ptr Action00; tooltip: cstring) {.
    importc, libprag.}

proc setTooltip*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    tooltip: cstring) =
  gtk_action_set_tooltip(cast[ptr Action00](self.impl), tooltip)

proc `tooltip=`*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    tooltip: cstring) =
  gtk_action_set_tooltip(cast[ptr Action00](self.impl), tooltip)

proc gtk_action_set_visible(self: ptr Action00; visible: gboolean) {.
    importc, libprag.}

proc setVisible*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    visible: bool = true) =
  gtk_action_set_visible(cast[ptr Action00](self.impl), gboolean(visible))

proc `visible=`*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    visible: bool) =
  gtk_action_set_visible(cast[ptr Action00](self.impl), gboolean(visible))

proc gtk_action_set_visible_horizontal(self: ptr Action00; visibleHorizontal: gboolean) {.
    importc, libprag.}

proc setVisibleHorizontal*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    visibleHorizontal: bool = true) =
  gtk_action_set_visible_horizontal(cast[ptr Action00](self.impl), gboolean(visibleHorizontal))

proc `visibleHorizontal=`*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    visibleHorizontal: bool) =
  gtk_action_set_visible_horizontal(cast[ptr Action00](self.impl), gboolean(visibleHorizontal))

proc gtk_action_set_visible_vertical(self: ptr Action00; visibleVertical: gboolean) {.
    importc, libprag.}

proc setVisibleVertical*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    visibleVertical: bool = true) =
  gtk_action_set_visible_vertical(cast[ptr Action00](self.impl), gboolean(visibleVertical))

proc `visibleVertical=`*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible;
    visibleVertical: bool) =
  gtk_action_set_visible_vertical(cast[ptr Action00](self.impl), gboolean(visibleVertical))

proc gtk_action_unblock_activate(self: ptr Action00) {.
    importc, libprag.}

proc unblockActivate*(self: Action | ExpanderAccessible | ContainerCellAccessible | LockButtonAccessible | SwitchAccessible | CheckMenuItemAccessible | RadioButtonAccessible | LinkButtonAccessible | ImageCellAccessible | SpinButtonAccessible | MenuButtonAccessible | ComboBoxAccessible | ToggleButtonAccessible | MenuItemAccessible | RendererCellAccessible | RadioMenuItemAccessible | ScaleButtonAccessible | BooleanCellAccessible | ButtonAccessible | TextCellAccessible | EntryIconAccessible | CellAccessible | EntryAccessible) =
  gtk_action_unblock_activate(cast[ptr Action00](self.impl))

type
  ComboBox* = ref object of Bin
  ComboBox00* = object of Bin00

proc gtk_combo_box_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ComboBox()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scChanged*(self: ComboBox;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "changed", cast[GCallback](p), xdata, nil, cf)

proc scFormatEntryText*(self: ComboBox;  p: proc (self: ptr ComboBox00; path: cstring; xdata: pointer): cstring {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "format-entry-text", cast[GCallback](p), xdata, nil, cf)

proc scMoveActive*(self: ComboBox;  p: proc (self: ptr ComboBox00; scrollType: ScrollType; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "move-active", cast[GCallback](p), xdata, nil, cf)

proc scPopdown*(self: ComboBox;  p: proc (self: ptr ComboBox00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "popdown", cast[GCallback](p), xdata, nil, cf)

proc scPopup*(self: ComboBox;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "popup", cast[GCallback](p), xdata, nil, cf)

proc gtk_combo_box_new(): ptr ComboBox00 {.
    importc, libprag.}

proc newComboBox*(): ComboBox =
  let gobj = gtk_combo_box_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newComboBox*(tdesc: typedesc): tdesc =
  assert(result is ComboBox)
  let gobj = gtk_combo_box_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initComboBox*[T](result: var T) {.deprecated.} =
  assert(result is ComboBox)
  let gobj = gtk_combo_box_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_combo_box_new_with_entry(): ptr ComboBox00 {.
    importc, libprag.}

proc newComboBoxWithEntry*(): ComboBox =
  let gobj = gtk_combo_box_new_with_entry()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newComboBoxWithEntry*(tdesc: typedesc): tdesc =
  assert(result is ComboBox)
  let gobj = gtk_combo_box_new_with_entry()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initComboBoxWithEntry*[T](result: var T) {.deprecated.} =
  assert(result is ComboBox)
  let gobj = gtk_combo_box_new_with_entry()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_combo_box_get_active(self: ptr ComboBox00): int32 {.
    importc, libprag.}

proc getActive*(self: ComboBox): int =
  int(gtk_combo_box_get_active(cast[ptr ComboBox00](self.impl)))

proc active*(self: ComboBox): int =
  int(gtk_combo_box_get_active(cast[ptr ComboBox00](self.impl)))

proc gtk_combo_box_get_active_id(self: ptr ComboBox00): cstring {.
    importc, libprag.}

proc getActiveId*(self: ComboBox): string =
  let resul0 = gtk_combo_box_get_active_id(cast[ptr ComboBox00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc activeId*(self: ComboBox): string =
  let resul0 = gtk_combo_box_get_active_id(cast[ptr ComboBox00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc gtk_combo_box_get_add_tearoffs(self: ptr ComboBox00): gboolean {.
    importc, libprag.}

proc getAddTearoffs*(self: ComboBox): bool =
  toBool(gtk_combo_box_get_add_tearoffs(cast[ptr ComboBox00](self.impl)))

proc addTearoffs*(self: ComboBox): bool =
  toBool(gtk_combo_box_get_add_tearoffs(cast[ptr ComboBox00](self.impl)))

proc gtk_combo_box_get_column_span_column(self: ptr ComboBox00): int32 {.
    importc, libprag.}

proc getColumnSpanColumn*(self: ComboBox): int =
  int(gtk_combo_box_get_column_span_column(cast[ptr ComboBox00](self.impl)))

proc columnSpanColumn*(self: ComboBox): int =
  int(gtk_combo_box_get_column_span_column(cast[ptr ComboBox00](self.impl)))

proc gtk_combo_box_get_entry_text_column(self: ptr ComboBox00): int32 {.
    importc, libprag.}

proc getEntryTextColumn*(self: ComboBox): int =
  int(gtk_combo_box_get_entry_text_column(cast[ptr ComboBox00](self.impl)))

proc entryTextColumn*(self: ComboBox): int =
  int(gtk_combo_box_get_entry_text_column(cast[ptr ComboBox00](self.impl)))

proc gtk_combo_box_get_focus_on_click(self: ptr ComboBox00): gboolean {.
    importc, libprag.}

proc getFocusOnClick*(self: ComboBox): bool =
  toBool(gtk_combo_box_get_focus_on_click(cast[ptr ComboBox00](self.impl)))

proc focusOnClick*(self: ComboBox): bool =
  toBool(gtk_combo_box_get_focus_on_click(cast[ptr ComboBox00](self.impl)))

proc gtk_combo_box_get_has_entry(self: ptr ComboBox00): gboolean {.
    importc, libprag.}

proc getHasEntry*(self: ComboBox): bool =
  toBool(gtk_combo_box_get_has_entry(cast[ptr ComboBox00](self.impl)))

proc hasEntry*(self: ComboBox): bool =
  toBool(gtk_combo_box_get_has_entry(cast[ptr ComboBox00](self.impl)))

proc gtk_combo_box_get_id_column(self: ptr ComboBox00): int32 {.
    importc, libprag.}

proc getIdColumn*(self: ComboBox): int =
  int(gtk_combo_box_get_id_column(cast[ptr ComboBox00](self.impl)))

proc idColumn*(self: ComboBox): int =
  int(gtk_combo_box_get_id_column(cast[ptr ComboBox00](self.impl)))

proc gtk_combo_box_get_popup_accessible(self: ptr ComboBox00): ptr atk.Object00 {.
    importc, libprag.}

proc getPopupAccessible*(self: ComboBox): atk.Object =
  let gobj = gtk_combo_box_get_popup_accessible(cast[ptr ComboBox00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, atk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc popupAccessible*(self: ComboBox): atk.Object =
  let gobj = gtk_combo_box_get_popup_accessible(cast[ptr ComboBox00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, atk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_combo_box_get_popup_fixed_width(self: ptr ComboBox00): gboolean {.
    importc, libprag.}

proc getPopupFixedWidth*(self: ComboBox): bool =
  toBool(gtk_combo_box_get_popup_fixed_width(cast[ptr ComboBox00](self.impl)))

proc popupFixedWidth*(self: ComboBox): bool =
  toBool(gtk_combo_box_get_popup_fixed_width(cast[ptr ComboBox00](self.impl)))

proc gtk_combo_box_get_row_span_column(self: ptr ComboBox00): int32 {.
    importc, libprag.}

proc getRowSpanColumn*(self: ComboBox): int =
  int(gtk_combo_box_get_row_span_column(cast[ptr ComboBox00](self.impl)))

proc rowSpanColumn*(self: ComboBox): int =
  int(gtk_combo_box_get_row_span_column(cast[ptr ComboBox00](self.impl)))

proc gtk_combo_box_get_title(self: ptr ComboBox00): cstring {.
    importc, libprag.}

proc getTitle*(self: ComboBox): string =
  result = $gtk_combo_box_get_title(cast[ptr ComboBox00](self.impl))

proc title*(self: ComboBox): string =
  result = $gtk_combo_box_get_title(cast[ptr ComboBox00](self.impl))

proc gtk_combo_box_get_wrap_width(self: ptr ComboBox00): int32 {.
    importc, libprag.}

proc getWrapWidth*(self: ComboBox): int =
  int(gtk_combo_box_get_wrap_width(cast[ptr ComboBox00](self.impl)))

proc wrapWidth*(self: ComboBox): int =
  int(gtk_combo_box_get_wrap_width(cast[ptr ComboBox00](self.impl)))

proc gtk_combo_box_popdown(self: ptr ComboBox00) {.
    importc, libprag.}

proc popdown*(self: ComboBox) =
  gtk_combo_box_popdown(cast[ptr ComboBox00](self.impl))

proc gtk_combo_box_popup(self: ptr ComboBox00) {.
    importc, libprag.}

proc popup*(self: ComboBox) =
  gtk_combo_box_popup(cast[ptr ComboBox00](self.impl))

proc gtk_combo_box_popup_for_device(self: ptr ComboBox00; device: ptr gdk.Device00) {.
    importc, libprag.}

proc popupForDevice*(self: ComboBox; device: gdk.Device) =
  gtk_combo_box_popup_for_device(cast[ptr ComboBox00](self.impl), cast[ptr gdk.Device00](device.impl))

proc gtk_combo_box_set_active(self: ptr ComboBox00; index: int32) {.
    importc, libprag.}

proc setActive*(self: ComboBox; index: int) =
  gtk_combo_box_set_active(cast[ptr ComboBox00](self.impl), int32(index))

proc `active=`*(self: ComboBox; index: int) =
  gtk_combo_box_set_active(cast[ptr ComboBox00](self.impl), int32(index))

proc gtk_combo_box_set_active_id(self: ptr ComboBox00; activeId: cstring): gboolean {.
    importc, libprag.}

proc setActiveId*(self: ComboBox; activeId: cstring = nil): bool =
  toBool(gtk_combo_box_set_active_id(cast[ptr ComboBox00](self.impl), activeId))

proc gtk_combo_box_set_add_tearoffs(self: ptr ComboBox00; addTearoffs: gboolean) {.
    importc, libprag.}

proc setAddTearoffs*(self: ComboBox; addTearoffs: bool = true) =
  gtk_combo_box_set_add_tearoffs(cast[ptr ComboBox00](self.impl), gboolean(addTearoffs))

proc `addTearoffs=`*(self: ComboBox; addTearoffs: bool) =
  gtk_combo_box_set_add_tearoffs(cast[ptr ComboBox00](self.impl), gboolean(addTearoffs))

proc gtk_combo_box_set_column_span_column(self: ptr ComboBox00; columnSpan: int32) {.
    importc, libprag.}

proc setColumnSpanColumn*(self: ComboBox; columnSpan: int) =
  gtk_combo_box_set_column_span_column(cast[ptr ComboBox00](self.impl), int32(columnSpan))

proc `columnSpanColumn=`*(self: ComboBox; columnSpan: int) =
  gtk_combo_box_set_column_span_column(cast[ptr ComboBox00](self.impl), int32(columnSpan))

proc gtk_combo_box_set_entry_text_column(self: ptr ComboBox00; textColumn: int32) {.
    importc, libprag.}

proc setEntryTextColumn*(self: ComboBox; textColumn: int) =
  gtk_combo_box_set_entry_text_column(cast[ptr ComboBox00](self.impl), int32(textColumn))

proc `entryTextColumn=`*(self: ComboBox; textColumn: int) =
  gtk_combo_box_set_entry_text_column(cast[ptr ComboBox00](self.impl), int32(textColumn))

proc gtk_combo_box_set_focus_on_click(self: ptr ComboBox00; focusOnClick: gboolean) {.
    importc, libprag.}

proc setFocusOnClick*(self: ComboBox; focusOnClick: bool = true) =
  gtk_combo_box_set_focus_on_click(cast[ptr ComboBox00](self.impl), gboolean(focusOnClick))

proc `focusOnClick=`*(self: ComboBox; focusOnClick: bool) =
  gtk_combo_box_set_focus_on_click(cast[ptr ComboBox00](self.impl), gboolean(focusOnClick))

proc gtk_combo_box_set_id_column(self: ptr ComboBox00; idColumn: int32) {.
    importc, libprag.}

proc setIdColumn*(self: ComboBox; idColumn: int) =
  gtk_combo_box_set_id_column(cast[ptr ComboBox00](self.impl), int32(idColumn))

proc `idColumn=`*(self: ComboBox; idColumn: int) =
  gtk_combo_box_set_id_column(cast[ptr ComboBox00](self.impl), int32(idColumn))

proc gtk_combo_box_set_popup_fixed_width(self: ptr ComboBox00; fixed: gboolean) {.
    importc, libprag.}

proc setPopupFixedWidth*(self: ComboBox; fixed: bool = true) =
  gtk_combo_box_set_popup_fixed_width(cast[ptr ComboBox00](self.impl), gboolean(fixed))

proc `popupFixedWidth=`*(self: ComboBox; fixed: bool) =
  gtk_combo_box_set_popup_fixed_width(cast[ptr ComboBox00](self.impl), gboolean(fixed))

proc gtk_combo_box_set_row_span_column(self: ptr ComboBox00; rowSpan: int32) {.
    importc, libprag.}

proc setRowSpanColumn*(self: ComboBox; rowSpan: int) =
  gtk_combo_box_set_row_span_column(cast[ptr ComboBox00](self.impl), int32(rowSpan))

proc `rowSpanColumn=`*(self: ComboBox; rowSpan: int) =
  gtk_combo_box_set_row_span_column(cast[ptr ComboBox00](self.impl), int32(rowSpan))

proc gtk_combo_box_set_title(self: ptr ComboBox00; title: cstring) {.
    importc, libprag.}

proc setTitle*(self: ComboBox; title: cstring) =
  gtk_combo_box_set_title(cast[ptr ComboBox00](self.impl), title)

proc `title=`*(self: ComboBox; title: cstring) =
  gtk_combo_box_set_title(cast[ptr ComboBox00](self.impl), title)

proc gtk_combo_box_set_wrap_width(self: ptr ComboBox00; width: int32) {.
    importc, libprag.}

proc setWrapWidth*(self: ComboBox; width: int) =
  gtk_combo_box_set_wrap_width(cast[ptr ComboBox00](self.impl), int32(width))

proc `wrapWidth=`*(self: ComboBox; width: int) =
  gtk_combo_box_set_wrap_width(cast[ptr ComboBox00](self.impl), int32(width))

type
  ComboBoxText* = ref object of ComboBox
  ComboBoxText00* = object of ComboBox00

proc gtk_combo_box_text_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ComboBoxText()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_combo_box_text_new(): ptr ComboBoxText00 {.
    importc, libprag.}

proc newComboBoxText*(): ComboBoxText =
  let gobj = gtk_combo_box_text_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newComboBoxText*(tdesc: typedesc): tdesc =
  assert(result is ComboBoxText)
  let gobj = gtk_combo_box_text_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initComboBoxText*[T](result: var T) {.deprecated.} =
  assert(result is ComboBoxText)
  let gobj = gtk_combo_box_text_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_combo_box_text_new_with_entry(): ptr ComboBoxText00 {.
    importc, libprag.}

proc newComboBoxTextWithEntry*(): ComboBoxText =
  let gobj = gtk_combo_box_text_new_with_entry()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newComboBoxTextWithEntry*(tdesc: typedesc): tdesc =
  assert(result is ComboBoxText)
  let gobj = gtk_combo_box_text_new_with_entry()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initComboBoxTextWithEntry*[T](result: var T) {.deprecated.} =
  assert(result is ComboBoxText)
  let gobj = gtk_combo_box_text_new_with_entry()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_combo_box_text_append(self: ptr ComboBoxText00; id: cstring; text: cstring) {.
    importc, libprag.}

proc append*(self: ComboBoxText; id: cstring = nil; text: cstring) =
  gtk_combo_box_text_append(cast[ptr ComboBoxText00](self.impl), id, text)

proc gtk_combo_box_text_append_text(self: ptr ComboBoxText00; text: cstring) {.
    importc, libprag.}

proc appendText*(self: ComboBoxText; text: cstring) =
  gtk_combo_box_text_append_text(cast[ptr ComboBoxText00](self.impl), text)

proc gtk_combo_box_text_get_active_text(self: ptr ComboBoxText00): cstring {.
    importc, libprag.}

proc getActiveText*(self: ComboBoxText): string =
  let resul0 = gtk_combo_box_text_get_active_text(cast[ptr ComboBoxText00](self.impl))
  result = $resul0
  cogfree(resul0)

proc activeText*(self: ComboBoxText): string =
  let resul0 = gtk_combo_box_text_get_active_text(cast[ptr ComboBoxText00](self.impl))
  result = $resul0
  cogfree(resul0)

proc gtk_combo_box_text_insert(self: ptr ComboBoxText00; position: int32;
    id: cstring; text: cstring) {.
    importc, libprag.}

proc insert*(self: ComboBoxText; position: int; id: cstring = nil;
    text: cstring) =
  gtk_combo_box_text_insert(cast[ptr ComboBoxText00](self.impl), int32(position), id, text)

proc gtk_combo_box_text_insert_text(self: ptr ComboBoxText00; position: int32;
    text: cstring) {.
    importc, libprag.}

proc insertText*(self: ComboBoxText; position: int; text: cstring) =
  gtk_combo_box_text_insert_text(cast[ptr ComboBoxText00](self.impl), int32(position), text)

proc gtk_combo_box_text_prepend(self: ptr ComboBoxText00; id: cstring; text: cstring) {.
    importc, libprag.}

proc prepend*(self: ComboBoxText; id: cstring = nil; text: cstring) =
  gtk_combo_box_text_prepend(cast[ptr ComboBoxText00](self.impl), id, text)

proc gtk_combo_box_text_prepend_text(self: ptr ComboBoxText00; text: cstring) {.
    importc, libprag.}

proc prependText*(self: ComboBoxText; text: cstring) =
  gtk_combo_box_text_prepend_text(cast[ptr ComboBoxText00](self.impl), text)

proc gtk_combo_box_text_remove(self: ptr ComboBoxText00; position: int32) {.
    importc, libprag.}

proc remove*(self: ComboBoxText; position: int) =
  gtk_combo_box_text_remove(cast[ptr ComboBoxText00](self.impl), int32(position))

proc gtk_combo_box_text_remove_all(self: ptr ComboBoxText00) {.
    importc, libprag.}

proc removeAll*(self: ComboBoxText) =
  gtk_combo_box_text_remove_all(cast[ptr ComboBoxText00](self.impl))

type
  DeleteType* {.size: sizeof(cint), pure.} = enum
    chars = 0
    wordEnds = 1
    words = 2
    displayLines = 3
    displayLineEnds = 4
    paragraphEnds = 5
    paragraphs = 6
    whitespace = 7

type
  EntryIconPosition* {.size: sizeof(cint), pure.} = enum
    primary = 0
    secondary = 1

type
  Entry* = ref object of Widget
  Entry00* = object of Widget00

proc gtk_entry_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Entry()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scActivate*(self: Entry;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "activate", cast[GCallback](p), xdata, nil, cf)

proc scBackspace*(self: Entry;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "backspace", cast[GCallback](p), xdata, nil, cf)

proc scCopyClipboard*(self: Entry;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "copy-clipboard", cast[GCallback](p), xdata, nil, cf)

proc scCutClipboard*(self: Entry;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "cut-clipboard", cast[GCallback](p), xdata, nil, cf)

proc scDeleteFromCursor*(self: Entry;  p: proc (self: ptr Entry00; `type`: DeleteType; count: int32; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "delete-from-cursor", cast[GCallback](p), xdata, nil, cf)

proc scIconPress*(self: Entry;  p: proc (self: ptr Entry00; iconPos: EntryIconPosition; event: ptr gdk.Event00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "icon-press", cast[GCallback](p), xdata, nil, cf)

proc scIconRelease*(self: Entry;  p: proc (self: ptr Entry00; iconPos: EntryIconPosition; event: ptr gdk.Event00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "icon-release", cast[GCallback](p), xdata, nil, cf)

proc scInsertAtCursor*(self: Entry;  p: proc (self: ptr Entry00; string: cstring; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "insert-at-cursor", cast[GCallback](p), xdata, nil, cf)

proc scInsertEmoji*(self: Entry;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "insert-emoji", cast[GCallback](p), xdata, nil, cf)

proc scMoveCursor*(self: Entry;  p: proc (self: ptr Entry00; step: MovementStep; count: int32; extendSelection: gboolean; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "move-cursor", cast[GCallback](p), xdata, nil, cf)

proc scPasteClipboard*(self: Entry;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "paste-clipboard", cast[GCallback](p), xdata, nil, cf)

proc scPopulatePopup*(self: Entry;  p: proc (self: ptr Entry00; widget: ptr Widget00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "populate-popup", cast[GCallback](p), xdata, nil, cf)

proc scPreeditChanged*(self: Entry;  p: proc (self: ptr Entry00; preedit: cstring; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "preedit-changed", cast[GCallback](p), xdata, nil, cf)

proc scToggleOverwrite*(self: Entry;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "toggle-overwrite", cast[GCallback](p), xdata, nil, cf)

proc gtk_entry_new(): ptr Entry00 {.
    importc, libprag.}

proc newEntry*(): Entry =
  let gobj = gtk_entry_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newEntry*(tdesc: typedesc): tdesc =
  assert(result is Entry)
  let gobj = gtk_entry_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initEntry*[T](result: var T) {.deprecated.} =
  assert(result is Entry)
  let gobj = gtk_entry_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_entry_get_activates_default(self: ptr Entry00): gboolean {.
    importc, libprag.}

proc getActivatesDefault*(self: Entry): bool =
  toBool(gtk_entry_get_activates_default(cast[ptr Entry00](self.impl)))

proc activatesDefault*(self: Entry): bool =
  toBool(gtk_entry_get_activates_default(cast[ptr Entry00](self.impl)))

proc gtk_entry_get_alignment(self: ptr Entry00): cfloat {.
    importc, libprag.}

proc getAlignment*(self: Entry): cfloat =
  gtk_entry_get_alignment(cast[ptr Entry00](self.impl))

proc alignment*(self: Entry): cfloat =
  gtk_entry_get_alignment(cast[ptr Entry00](self.impl))

proc gtk_entry_get_attributes(self: ptr Entry00): ptr pango.AttrList00 {.
    importc, libprag.}

proc getAttributes*(self: Entry): pango.AttrList =
  let impl0 = gtk_entry_get_attributes(cast[ptr Entry00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreePangoAttrList)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(pango_attr_list_get_type(), impl0))

proc attributes*(self: Entry): pango.AttrList =
  let impl0 = gtk_entry_get_attributes(cast[ptr Entry00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreePangoAttrList)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(pango_attr_list_get_type(), impl0))

proc gtk_entry_get_current_icon_drag_source(self: ptr Entry00): int32 {.
    importc, libprag.}

proc getCurrentIconDragSource*(self: Entry): int =
  int(gtk_entry_get_current_icon_drag_source(cast[ptr Entry00](self.impl)))

proc currentIconDragSource*(self: Entry): int =
  int(gtk_entry_get_current_icon_drag_source(cast[ptr Entry00](self.impl)))

proc gtk_entry_get_cursor_hadjustment(self: ptr Entry00): ptr Adjustment00 {.
    importc, libprag.}

proc getCursorHadjustment*(self: Entry): Adjustment =
  let gobj = gtk_entry_get_cursor_hadjustment(cast[ptr Entry00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc cursorHadjustment*(self: Entry): Adjustment =
  let gobj = gtk_entry_get_cursor_hadjustment(cast[ptr Entry00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_entry_get_has_frame(self: ptr Entry00): gboolean {.
    importc, libprag.}

proc getHasFrame*(self: Entry): bool =
  toBool(gtk_entry_get_has_frame(cast[ptr Entry00](self.impl)))

proc hasFrame*(self: Entry): bool =
  toBool(gtk_entry_get_has_frame(cast[ptr Entry00](self.impl)))

proc gtk_entry_get_icon_activatable(self: ptr Entry00; iconPos: EntryIconPosition): gboolean {.
    importc, libprag.}

proc getIconActivatable*(self: Entry; iconPos: EntryIconPosition): bool =
  toBool(gtk_entry_get_icon_activatable(cast[ptr Entry00](self.impl), iconPos))

proc gtk_entry_get_icon_area(self: ptr Entry00; iconPos: EntryIconPosition;
    iconArea: var gdk.Rectangle) {.
    importc, libprag.}

proc getIconArea*(self: Entry; iconPos: EntryIconPosition; iconArea: var gdk.Rectangle) =
  gtk_entry_get_icon_area(cast[ptr Entry00](self.impl), iconPos, iconArea)

proc gtk_entry_get_icon_at_pos(self: ptr Entry00; x: int32; y: int32): int32 {.
    importc, libprag.}

proc getIconAtPos*(self: Entry; x: int; y: int): int =
  int(gtk_entry_get_icon_at_pos(cast[ptr Entry00](self.impl), int32(x), int32(y)))

proc gtk_entry_get_icon_gicon(self: ptr Entry00; iconPos: EntryIconPosition): ptr gio.Icon00 {.
    importc, libprag.}

proc getIconGicon*(self: Entry; iconPos: EntryIconPosition): gio.Icon =
  let gobj = gtk_entry_get_icon_gicon(cast[ptr Entry00](self.impl), iconPos)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gio.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_entry_get_icon_name(self: ptr Entry00; iconPos: EntryIconPosition): cstring {.
    importc, libprag.}

proc getIconName*(self: Entry; iconPos: EntryIconPosition): string =
  let resul0 = gtk_entry_get_icon_name(cast[ptr Entry00](self.impl), iconPos)
  if resul0.isNil:
    return
  result = $resul0

proc gtk_entry_get_icon_pixbuf(self: ptr Entry00; iconPos: EntryIconPosition): ptr gdkpixbuf.Pixbuf00 {.
    importc, libprag.}

proc getIconPixbuf*(self: Entry; iconPos: EntryIconPosition): gdkpixbuf.Pixbuf =
  let gobj = gtk_entry_get_icon_pixbuf(cast[ptr Entry00](self.impl), iconPos)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdkpixbuf.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_entry_get_icon_sensitive(self: ptr Entry00; iconPos: EntryIconPosition): gboolean {.
    importc, libprag.}

proc getIconSensitive*(self: Entry; iconPos: EntryIconPosition): bool =
  toBool(gtk_entry_get_icon_sensitive(cast[ptr Entry00](self.impl), iconPos))

proc gtk_entry_get_icon_stock(self: ptr Entry00; iconPos: EntryIconPosition): cstring {.
    importc, libprag.}

proc getIconStock*(self: Entry; iconPos: EntryIconPosition): string =
  result = $gtk_entry_get_icon_stock(cast[ptr Entry00](self.impl), iconPos)

proc gtk_entry_get_icon_tooltip_markup(self: ptr Entry00; iconPos: EntryIconPosition): cstring {.
    importc, libprag.}

proc getIconTooltipMarkup*(self: Entry; iconPos: EntryIconPosition): string =
  let resul0 = gtk_entry_get_icon_tooltip_markup(cast[ptr Entry00](self.impl), iconPos)
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc gtk_entry_get_icon_tooltip_text(self: ptr Entry00; iconPos: EntryIconPosition): cstring {.
    importc, libprag.}

proc getIconTooltipText*(self: Entry; iconPos: EntryIconPosition): string =
  let resul0 = gtk_entry_get_icon_tooltip_text(cast[ptr Entry00](self.impl), iconPos)
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc gtk_entry_get_inner_border(self: ptr Entry00): ptr Border {.
    importc, libprag.}

proc getInnerBorder*(self: Entry): ptr Border =
  gtk_entry_get_inner_border(cast[ptr Entry00](self.impl))

proc innerBorder*(self: Entry): ptr Border =
  gtk_entry_get_inner_border(cast[ptr Entry00](self.impl))

proc gtk_entry_get_invisible_char(self: ptr Entry00): gunichar {.
    importc, libprag.}

proc getInvisibleChar*(self: Entry): gunichar =
  gtk_entry_get_invisible_char(cast[ptr Entry00](self.impl))

proc invisibleChar*(self: Entry): gunichar =
  gtk_entry_get_invisible_char(cast[ptr Entry00](self.impl))

proc gtk_entry_get_layout(self: ptr Entry00): ptr pango.Layout00 {.
    importc, libprag.}

proc getLayout*(self: Entry): pango.Layout =
  let gobj = gtk_entry_get_layout(cast[ptr Entry00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, pango.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc layout*(self: Entry): pango.Layout =
  let gobj = gtk_entry_get_layout(cast[ptr Entry00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, pango.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_entry_get_layout_offsets(self: ptr Entry00; x: var int32; y: var int32) {.
    importc, libprag.}

proc getLayoutOffsets*(self: Entry; x: var int = cast[var int](nil);
    y: var int = cast[var int](nil)) =
  var y_00: int32
  var x_00: int32
  gtk_entry_get_layout_offsets(cast[ptr Entry00](self.impl), x_00, y_00)
  if y.addr != nil:
    y = int(y_00)
  if x.addr != nil:
    x = int(x_00)

proc gtk_entry_get_max_length(self: ptr Entry00): int32 {.
    importc, libprag.}

proc getMaxLength*(self: Entry): int =
  int(gtk_entry_get_max_length(cast[ptr Entry00](self.impl)))

proc maxLength*(self: Entry): int =
  int(gtk_entry_get_max_length(cast[ptr Entry00](self.impl)))

proc gtk_entry_get_max_width_chars(self: ptr Entry00): int32 {.
    importc, libprag.}

proc getMaxWidthChars*(self: Entry): int =
  int(gtk_entry_get_max_width_chars(cast[ptr Entry00](self.impl)))

proc maxWidthChars*(self: Entry): int =
  int(gtk_entry_get_max_width_chars(cast[ptr Entry00](self.impl)))

proc gtk_entry_get_overwrite_mode(self: ptr Entry00): gboolean {.
    importc, libprag.}

proc getOverwriteMode*(self: Entry): bool =
  toBool(gtk_entry_get_overwrite_mode(cast[ptr Entry00](self.impl)))

proc overwriteMode*(self: Entry): bool =
  toBool(gtk_entry_get_overwrite_mode(cast[ptr Entry00](self.impl)))

proc gtk_entry_get_placeholder_text(self: ptr Entry00): cstring {.
    importc, libprag.}

proc getPlaceholderText*(self: Entry): string =
  result = $gtk_entry_get_placeholder_text(cast[ptr Entry00](self.impl))

proc placeholderText*(self: Entry): string =
  result = $gtk_entry_get_placeholder_text(cast[ptr Entry00](self.impl))

proc gtk_entry_get_progress_fraction(self: ptr Entry00): cdouble {.
    importc, libprag.}

proc getProgressFraction*(self: Entry): cdouble =
  gtk_entry_get_progress_fraction(cast[ptr Entry00](self.impl))

proc progressFraction*(self: Entry): cdouble =
  gtk_entry_get_progress_fraction(cast[ptr Entry00](self.impl))

proc gtk_entry_get_progress_pulse_step(self: ptr Entry00): cdouble {.
    importc, libprag.}

proc getProgressPulseStep*(self: Entry): cdouble =
  gtk_entry_get_progress_pulse_step(cast[ptr Entry00](self.impl))

proc progressPulseStep*(self: Entry): cdouble =
  gtk_entry_get_progress_pulse_step(cast[ptr Entry00](self.impl))

proc gtk_entry_get_tabs(self: ptr Entry00): ptr pango.TabArray00 {.
    importc, libprag.}

proc getTabs*(self: Entry): pango.TabArray =
  let impl0 = gtk_entry_get_tabs(cast[ptr Entry00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreePangoTabArray)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(pango_tab_array_get_type(), impl0))

proc tabs*(self: Entry): pango.TabArray =
  let impl0 = gtk_entry_get_tabs(cast[ptr Entry00](self.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreePangoTabArray)
  result.impl = cast[typeof(result.impl)](g_boxed_copy(pango_tab_array_get_type(), impl0))

proc gtk_entry_get_text(self: ptr Entry00): cstring {.
    importc, libprag.}

proc getText*(self: Entry): string =
  result = $gtk_entry_get_text(cast[ptr Entry00](self.impl))

proc text*(self: Entry): string =
  result = $gtk_entry_get_text(cast[ptr Entry00](self.impl))

proc gtk_entry_get_text_area(self: ptr Entry00; textArea: var gdk.Rectangle) {.
    importc, libprag.}

proc getTextArea*(self: Entry; textArea: var gdk.Rectangle) =
  gtk_entry_get_text_area(cast[ptr Entry00](self.impl), textArea)

proc getTextArea*(self: Entry): gdk.Rectangle =
  gtk_entry_get_text_area(cast[ptr Entry00](self.impl), result)

proc gtk_entry_get_text_length(self: ptr Entry00): uint16 {.
    importc, libprag.}

proc getTextLength*(self: Entry): uint16 =
  gtk_entry_get_text_length(cast[ptr Entry00](self.impl))

proc textLength*(self: Entry): uint16 =
  gtk_entry_get_text_length(cast[ptr Entry00](self.impl))

proc gtk_entry_get_visibility(self: ptr Entry00): gboolean {.
    importc, libprag.}

proc getVisibility*(self: Entry): bool =
  toBool(gtk_entry_get_visibility(cast[ptr Entry00](self.impl)))

proc visibility*(self: Entry): bool =
  toBool(gtk_entry_get_visibility(cast[ptr Entry00](self.impl)))

proc gtk_entry_get_width_chars(self: ptr Entry00): int32 {.
    importc, libprag.}

proc getWidthChars*(self: Entry): int =
  int(gtk_entry_get_width_chars(cast[ptr Entry00](self.impl)))

proc widthChars*(self: Entry): int =
  int(gtk_entry_get_width_chars(cast[ptr Entry00](self.impl)))

proc gtk_entry_grab_focus_without_selecting(self: ptr Entry00) {.
    importc, libprag.}

proc grabFocusWithoutSelecting*(self: Entry) =
  gtk_entry_grab_focus_without_selecting(cast[ptr Entry00](self.impl))

proc gtk_entry_im_context_filter_keypress(self: ptr Entry00; event: ptr gdk.EventKey00): gboolean {.
    importc, libprag.}

proc imContextFilterKeypress*(self: Entry; event: gdk.EventKey): bool =
  toBool(gtk_entry_im_context_filter_keypress(cast[ptr Entry00](self.impl), cast[ptr gdk.EventKey00](event.impl)))

proc gtk_entry_layout_index_to_text_index(self: ptr Entry00; layoutIndex: int32): int32 {.
    importc, libprag.}

proc layoutIndexToTextIndex*(self: Entry; layoutIndex: int): int =
  int(gtk_entry_layout_index_to_text_index(cast[ptr Entry00](self.impl), int32(layoutIndex)))

proc gtk_entry_progress_pulse(self: ptr Entry00) {.
    importc, libprag.}

proc progressPulse*(self: Entry) =
  gtk_entry_progress_pulse(cast[ptr Entry00](self.impl))

proc gtk_entry_reset_im_context(self: ptr Entry00) {.
    importc, libprag.}

proc resetImContext*(self: Entry) =
  gtk_entry_reset_im_context(cast[ptr Entry00](self.impl))

proc gtk_entry_set_activates_default(self: ptr Entry00; setting: gboolean) {.
    importc, libprag.}

proc setActivatesDefault*(self: Entry; setting: bool = true) =
  gtk_entry_set_activates_default(cast[ptr Entry00](self.impl), gboolean(setting))

proc `activatesDefault=`*(self: Entry; setting: bool) =
  gtk_entry_set_activates_default(cast[ptr Entry00](self.impl), gboolean(setting))

proc gtk_entry_set_alignment(self: ptr Entry00; xalign: cfloat) {.
    importc, libprag.}

proc setAlignment*(self: Entry; xalign: cfloat) =
  gtk_entry_set_alignment(cast[ptr Entry00](self.impl), xalign)

proc `alignment=`*(self: Entry; xalign: cfloat) =
  gtk_entry_set_alignment(cast[ptr Entry00](self.impl), xalign)

proc gtk_entry_set_attributes(self: ptr Entry00; attrs: ptr pango.AttrList00) {.
    importc, libprag.}

proc setAttributes*(self: Entry; attrs: pango.AttrList) =
  gtk_entry_set_attributes(cast[ptr Entry00](self.impl), cast[ptr pango.AttrList00](attrs.impl))

proc `attributes=`*(self: Entry; attrs: pango.AttrList) =
  gtk_entry_set_attributes(cast[ptr Entry00](self.impl), cast[ptr pango.AttrList00](attrs.impl))

proc gtk_entry_set_cursor_hadjustment(self: ptr Entry00; adjustment: ptr Adjustment00) {.
    importc, libprag.}

proc setCursorHadjustment*(self: Entry; adjustment: Adjustment = nil) =
  gtk_entry_set_cursor_hadjustment(cast[ptr Entry00](self.impl), if adjustment.isNil: nil else: cast[ptr Adjustment00](adjustment.impl))

proc `cursorHadjustment=`*(self: Entry; adjustment: Adjustment = nil) =
  gtk_entry_set_cursor_hadjustment(cast[ptr Entry00](self.impl), if adjustment.isNil: nil else: cast[ptr Adjustment00](adjustment.impl))

proc gtk_entry_set_has_frame(self: ptr Entry00; setting: gboolean) {.
    importc, libprag.}

proc setHasFrame*(self: Entry; setting: bool = true) =
  gtk_entry_set_has_frame(cast[ptr Entry00](self.impl), gboolean(setting))

proc `hasFrame=`*(self: Entry; setting: bool) =
  gtk_entry_set_has_frame(cast[ptr Entry00](self.impl), gboolean(setting))

proc gtk_entry_set_icon_activatable(self: ptr Entry00; iconPos: EntryIconPosition;
    activatable: gboolean) {.
    importc, libprag.}

proc setIconActivatable*(self: Entry; iconPos: EntryIconPosition;
    activatable: bool) =
  gtk_entry_set_icon_activatable(cast[ptr Entry00](self.impl), iconPos, gboolean(activatable))

proc gtk_entry_set_icon_drag_source(self: ptr Entry00; iconPos: EntryIconPosition;
    targetList: ptr TargetList00; actions: gdk.DragAction) {.
    importc, libprag.}

proc setIconDragSource*(self: Entry; iconPos: EntryIconPosition;
    targetList: TargetList; actions: gdk.DragAction) =
  gtk_entry_set_icon_drag_source(cast[ptr Entry00](self.impl), iconPos, cast[ptr TargetList00](targetList.impl), actions)

proc gtk_entry_set_icon_from_gicon(self: ptr Entry00; iconPos: EntryIconPosition;
    icon: ptr gio.Icon00) {.
    importc, libprag.}

proc setIconFromGicon*(self: Entry; iconPos: EntryIconPosition;
    icon: gio.Icon = nil) =
  gtk_entry_set_icon_from_gicon(cast[ptr Entry00](self.impl), iconPos, if icon.isNil: nil else: cast[ptr gio.Icon00](icon.impl))

proc gtk_entry_set_icon_from_icon_name(self: ptr Entry00; iconPos: EntryIconPosition;
    iconName: cstring) {.
    importc, libprag.}

proc setIconFromIconName*(self: Entry; iconPos: EntryIconPosition;
    iconName: cstring = nil) =
  gtk_entry_set_icon_from_icon_name(cast[ptr Entry00](self.impl), iconPos, iconName)

proc gtk_entry_set_icon_from_pixbuf(self: ptr Entry00; iconPos: EntryIconPosition;
    pixbuf: ptr gdkpixbuf.Pixbuf00) {.
    importc, libprag.}

proc setIconFromPixbuf*(self: Entry; iconPos: EntryIconPosition;
    pixbuf: gdkpixbuf.Pixbuf = nil) =
  gtk_entry_set_icon_from_pixbuf(cast[ptr Entry00](self.impl), iconPos, if pixbuf.isNil: nil else: cast[ptr gdkpixbuf.Pixbuf00](pixbuf.impl))

proc gtk_entry_set_icon_from_stock(self: ptr Entry00; iconPos: EntryIconPosition;
    stockId: cstring) {.
    importc, libprag.}

proc setIconFromStock*(self: Entry; iconPos: EntryIconPosition;
    stockId: cstring = nil) =
  gtk_entry_set_icon_from_stock(cast[ptr Entry00](self.impl), iconPos, stockId)

proc gtk_entry_set_icon_sensitive(self: ptr Entry00; iconPos: EntryIconPosition;
    sensitive: gboolean) {.
    importc, libprag.}

proc setIconSensitive*(self: Entry; iconPos: EntryIconPosition;
    sensitive: bool) =
  gtk_entry_set_icon_sensitive(cast[ptr Entry00](self.impl), iconPos, gboolean(sensitive))

proc gtk_entry_set_icon_tooltip_markup(self: ptr Entry00; iconPos: EntryIconPosition;
    tooltip: cstring) {.
    importc, libprag.}

proc setIconTooltipMarkup*(self: Entry; iconPos: EntryIconPosition;
    tooltip: cstring = nil) =
  gtk_entry_set_icon_tooltip_markup(cast[ptr Entry00](self.impl), iconPos, tooltip)

proc gtk_entry_set_icon_tooltip_text(self: ptr Entry00; iconPos: EntryIconPosition;
    tooltip: cstring) {.
    importc, libprag.}

proc setIconTooltipText*(self: Entry; iconPos: EntryIconPosition;
    tooltip: cstring = nil) =
  gtk_entry_set_icon_tooltip_text(cast[ptr Entry00](self.impl), iconPos, tooltip)

proc gtk_entry_set_inner_border(self: ptr Entry00; border: Border) {.
    importc, libprag.}

proc setInnerBorder*(self: Entry; border: Border = cast[var Border](nil)) =
  gtk_entry_set_inner_border(cast[ptr Entry00](self.impl), border)

proc `innerBorder=`*(self: Entry; border: Border = cast[var Border](nil)) =
  gtk_entry_set_inner_border(cast[ptr Entry00](self.impl), border)

proc gtk_entry_set_invisible_char(self: ptr Entry00; ch: gunichar) {.
    importc, libprag.}

proc setInvisibleChar*(self: Entry; ch: gunichar) =
  gtk_entry_set_invisible_char(cast[ptr Entry00](self.impl), ch)

proc `invisibleChar=`*(self: Entry; ch: gunichar) =
  gtk_entry_set_invisible_char(cast[ptr Entry00](self.impl), ch)

proc gtk_entry_set_max_length(self: ptr Entry00; max: int32) {.
    importc, libprag.}

proc setMaxLength*(self: Entry; max: int) =
  gtk_entry_set_max_length(cast[ptr Entry00](self.impl), int32(max))

proc `maxLength=`*(self: Entry; max: int) =
  gtk_entry_set_max_length(cast[ptr Entry00](self.impl), int32(max))

proc gtk_entry_set_max_width_chars(self: ptr Entry00; nChars: int32) {.
    importc, libprag.}

proc setMaxWidthChars*(self: Entry; nChars: int) =
  gtk_entry_set_max_width_chars(cast[ptr Entry00](self.impl), int32(nChars))

proc `maxWidthChars=`*(self: Entry; nChars: int) =
  gtk_entry_set_max_width_chars(cast[ptr Entry00](self.impl), int32(nChars))

proc gtk_entry_set_overwrite_mode(self: ptr Entry00; overwrite: gboolean) {.
    importc, libprag.}

proc setOverwriteMode*(self: Entry; overwrite: bool = true) =
  gtk_entry_set_overwrite_mode(cast[ptr Entry00](self.impl), gboolean(overwrite))

proc `overwriteMode=`*(self: Entry; overwrite: bool) =
  gtk_entry_set_overwrite_mode(cast[ptr Entry00](self.impl), gboolean(overwrite))

proc gtk_entry_set_placeholder_text(self: ptr Entry00; text: cstring) {.
    importc, libprag.}

proc setPlaceholderText*(self: Entry; text: cstring = nil) =
  gtk_entry_set_placeholder_text(cast[ptr Entry00](self.impl), text)

proc `placeholderText=`*(self: Entry; text: cstring = nil) =
  gtk_entry_set_placeholder_text(cast[ptr Entry00](self.impl), text)

proc gtk_entry_set_progress_fraction(self: ptr Entry00; fraction: cdouble) {.
    importc, libprag.}

proc setProgressFraction*(self: Entry; fraction: cdouble) =
  gtk_entry_set_progress_fraction(cast[ptr Entry00](self.impl), fraction)

proc `progressFraction=`*(self: Entry; fraction: cdouble) =
  gtk_entry_set_progress_fraction(cast[ptr Entry00](self.impl), fraction)

proc gtk_entry_set_progress_pulse_step(self: ptr Entry00; fraction: cdouble) {.
    importc, libprag.}

proc setProgressPulseStep*(self: Entry; fraction: cdouble) =
  gtk_entry_set_progress_pulse_step(cast[ptr Entry00](self.impl), fraction)

proc `progressPulseStep=`*(self: Entry; fraction: cdouble) =
  gtk_entry_set_progress_pulse_step(cast[ptr Entry00](self.impl), fraction)

proc gtk_entry_set_tabs(self: ptr Entry00; tabs: ptr pango.TabArray00) {.
    importc, libprag.}

proc setTabs*(self: Entry; tabs: pango.TabArray) =
  gtk_entry_set_tabs(cast[ptr Entry00](self.impl), cast[ptr pango.TabArray00](tabs.impl))

proc `tabs=`*(self: Entry; tabs: pango.TabArray) =
  gtk_entry_set_tabs(cast[ptr Entry00](self.impl), cast[ptr pango.TabArray00](tabs.impl))

proc gtk_entry_set_text(self: ptr Entry00; text: cstring) {.
    importc, libprag.}

proc setText*(self: Entry; text: cstring) =
  gtk_entry_set_text(cast[ptr Entry00](self.impl), text)

proc `text=`*(self: Entry; text: cstring) =
  gtk_entry_set_text(cast[ptr Entry00](self.impl), text)

proc gtk_entry_set_visibility(self: ptr Entry00; visible: gboolean) {.
    importc, libprag.}

proc setVisibility*(self: Entry; visible: bool = true) =
  gtk_entry_set_visibility(cast[ptr Entry00](self.impl), gboolean(visible))

proc `visibility=`*(self: Entry; visible: bool) =
  gtk_entry_set_visibility(cast[ptr Entry00](self.impl), gboolean(visible))

proc gtk_entry_set_width_chars(self: ptr Entry00; nChars: int32) {.
    importc, libprag.}

proc setWidthChars*(self: Entry; nChars: int) =
  gtk_entry_set_width_chars(cast[ptr Entry00](self.impl), int32(nChars))

proc `widthChars=`*(self: Entry; nChars: int) =
  gtk_entry_set_width_chars(cast[ptr Entry00](self.impl), int32(nChars))

proc gtk_entry_text_index_to_layout_index(self: ptr Entry00; textIndex: int32): int32 {.
    importc, libprag.}

proc textIndexToLayoutIndex*(self: Entry; textIndex: int): int =
  int(gtk_entry_text_index_to_layout_index(cast[ptr Entry00](self.impl), int32(textIndex)))

proc gtk_entry_unset_invisible_char(self: ptr Entry00) {.
    importc, libprag.}

proc unsetInvisibleChar*(self: Entry) =
  gtk_entry_unset_invisible_char(cast[ptr Entry00](self.impl))

type
  SpinButton* = ref object of Entry
  SpinButton00* = object of Entry00

proc gtk_spin_button_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(SpinButton()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scChangeValue*(self: SpinButton;  p: proc (self: ptr SpinButton00; scroll: ScrollType; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "change-value", cast[GCallback](p), xdata, nil, cf)

proc scInput*(self: SpinButton;  p: proc (self: ptr SpinButton00; newValue: var cdouble; xdata: pointer): int32 {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "input", cast[GCallback](p), xdata, nil, cf)

proc scOutput*(self: SpinButton;  p: proc (self: ptr SpinButton00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "output", cast[GCallback](p), xdata, nil, cf)

proc scValueChanged*(self: SpinButton;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "value-changed", cast[GCallback](p), xdata, nil, cf)

proc scWrapped*(self: SpinButton;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "wrapped", cast[GCallback](p), xdata, nil, cf)

proc gtk_spin_button_new(adjustment: ptr Adjustment00; climbRate: cdouble;
    digits: uint32): ptr SpinButton00 {.
    importc, libprag.}

proc newSpinButton*(adjustment: Adjustment = nil; climbRate: cdouble;
    digits: int): SpinButton =
  let gobj = gtk_spin_button_new(if adjustment.isNil: nil else: cast[ptr Adjustment00](adjustment.impl), climbRate, uint32(digits))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newSpinButton*(tdesc: typedesc; adjustment: Adjustment = nil; climbRate: cdouble;
    digits: int): tdesc =
  assert(result is SpinButton)
  let gobj = gtk_spin_button_new(if adjustment.isNil: nil else: cast[ptr Adjustment00](adjustment.impl), climbRate, uint32(digits))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initSpinButton*[T](result: var T; adjustment: Adjustment = nil; climbRate: cdouble;
    digits: int) {.deprecated.} =
  assert(result is SpinButton)
  let gobj = gtk_spin_button_new(if adjustment.isNil: nil else: cast[ptr Adjustment00](adjustment.impl), climbRate, uint32(digits))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_spin_button_new_with_range(min: cdouble; max: cdouble; step: cdouble): ptr SpinButton00 {.
    importc, libprag.}

proc newSpinButtonWithRange*(min: cdouble; max: cdouble; step: cdouble): SpinButton =
  let gobj = gtk_spin_button_new_with_range(min, max, step)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newSpinButtonWithRange*(tdesc: typedesc; min: cdouble; max: cdouble; step: cdouble): tdesc =
  assert(result is SpinButton)
  let gobj = gtk_spin_button_new_with_range(min, max, step)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initSpinButtonWithRange*[T](result: var T; min: cdouble; max: cdouble; step: cdouble) {.deprecated.} =
  assert(result is SpinButton)
  let gobj = gtk_spin_button_new_with_range(min, max, step)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_spin_button_configure(self: ptr SpinButton00; adjustment: ptr Adjustment00;
    climbRate: cdouble; digits: uint32) {.
    importc, libprag.}

proc configure*(self: SpinButton; adjustment: Adjustment = nil;
    climbRate: cdouble; digits: int) =
  gtk_spin_button_configure(cast[ptr SpinButton00](self.impl), if adjustment.isNil: nil else: cast[ptr Adjustment00](adjustment.impl), climbRate, uint32(digits))

proc gtk_spin_button_get_adjustment(self: ptr SpinButton00): ptr Adjustment00 {.
    importc, libprag.}

proc getAdjustment*(self: SpinButton): Adjustment =
  let gobj = gtk_spin_button_get_adjustment(cast[ptr SpinButton00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc adjustment*(self: SpinButton): Adjustment =
  let gobj = gtk_spin_button_get_adjustment(cast[ptr SpinButton00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_spin_button_get_digits(self: ptr SpinButton00): uint32 {.
    importc, libprag.}

proc getDigits*(self: SpinButton): int =
  int(gtk_spin_button_get_digits(cast[ptr SpinButton00](self.impl)))

proc digits*(self: SpinButton): int =
  int(gtk_spin_button_get_digits(cast[ptr SpinButton00](self.impl)))

proc gtk_spin_button_get_increments(self: ptr SpinButton00; step: var cdouble;
    page: var cdouble) {.
    importc, libprag.}

proc getIncrements*(self: SpinButton; step: var cdouble = cast[var cdouble](nil);
    page: var cdouble = cast[var cdouble](nil)) =
  gtk_spin_button_get_increments(cast[ptr SpinButton00](self.impl), step, page)

proc gtk_spin_button_get_numeric(self: ptr SpinButton00): gboolean {.
    importc, libprag.}

proc getNumeric*(self: SpinButton): bool =
  toBool(gtk_spin_button_get_numeric(cast[ptr SpinButton00](self.impl)))

proc numeric*(self: SpinButton): bool =
  toBool(gtk_spin_button_get_numeric(cast[ptr SpinButton00](self.impl)))

proc gtk_spin_button_get_range(self: ptr SpinButton00; min: var cdouble;
    max: var cdouble) {.
    importc, libprag.}

proc getRange*(self: SpinButton; min: var cdouble = cast[var cdouble](nil);
    max: var cdouble = cast[var cdouble](nil)) =
  gtk_spin_button_get_range(cast[ptr SpinButton00](self.impl), min, max)

proc gtk_spin_button_get_snap_to_ticks(self: ptr SpinButton00): gboolean {.
    importc, libprag.}

proc getSnapToTicks*(self: SpinButton): bool =
  toBool(gtk_spin_button_get_snap_to_ticks(cast[ptr SpinButton00](self.impl)))

proc snapToTicks*(self: SpinButton): bool =
  toBool(gtk_spin_button_get_snap_to_ticks(cast[ptr SpinButton00](self.impl)))

proc gtk_spin_button_get_value(self: ptr SpinButton00): cdouble {.
    importc, libprag.}

proc getValue*(self: SpinButton): cdouble =
  gtk_spin_button_get_value(cast[ptr SpinButton00](self.impl))

proc value*(self: SpinButton): cdouble =
  gtk_spin_button_get_value(cast[ptr SpinButton00](self.impl))

proc gtk_spin_button_get_value_as_int(self: ptr SpinButton00): int32 {.
    importc, libprag.}

proc getValueAsInt*(self: SpinButton): int =
  int(gtk_spin_button_get_value_as_int(cast[ptr SpinButton00](self.impl)))

proc valueAsInt*(self: SpinButton): int =
  int(gtk_spin_button_get_value_as_int(cast[ptr SpinButton00](self.impl)))

proc gtk_spin_button_get_wrap(self: ptr SpinButton00): gboolean {.
    importc, libprag.}

proc getWrap*(self: SpinButton): bool =
  toBool(gtk_spin_button_get_wrap(cast[ptr SpinButton00](self.impl)))

proc wrap*(self: SpinButton): bool =
  toBool(gtk_spin_button_get_wrap(cast[ptr SpinButton00](self.impl)))

proc gtk_spin_button_set_adjustment(self: ptr SpinButton00; adjustment: ptr Adjustment00) {.
    importc, libprag.}

proc setAdjustment*(self: SpinButton; adjustment: Adjustment) =
  gtk_spin_button_set_adjustment(cast[ptr SpinButton00](self.impl), cast[ptr Adjustment00](adjustment.impl))

proc `adjustment=`*(self: SpinButton; adjustment: Adjustment) =
  gtk_spin_button_set_adjustment(cast[ptr SpinButton00](self.impl), cast[ptr Adjustment00](adjustment.impl))

proc gtk_spin_button_set_digits(self: ptr SpinButton00; digits: uint32) {.
    importc, libprag.}

proc setDigits*(self: SpinButton; digits: int) =
  gtk_spin_button_set_digits(cast[ptr SpinButton00](self.impl), uint32(digits))

proc `digits=`*(self: SpinButton; digits: int) =
  gtk_spin_button_set_digits(cast[ptr SpinButton00](self.impl), uint32(digits))

proc gtk_spin_button_set_increments(self: ptr SpinButton00; step: cdouble;
    page: cdouble) {.
    importc, libprag.}

proc setIncrements*(self: SpinButton; step: cdouble; page: cdouble) =
  gtk_spin_button_set_increments(cast[ptr SpinButton00](self.impl), step, page)

proc gtk_spin_button_set_numeric(self: ptr SpinButton00; numeric: gboolean) {.
    importc, libprag.}

proc setNumeric*(self: SpinButton; numeric: bool = true) =
  gtk_spin_button_set_numeric(cast[ptr SpinButton00](self.impl), gboolean(numeric))

proc `numeric=`*(self: SpinButton; numeric: bool) =
  gtk_spin_button_set_numeric(cast[ptr SpinButton00](self.impl), gboolean(numeric))

proc gtk_spin_button_set_range(self: ptr SpinButton00; min: cdouble; max: cdouble) {.
    importc, libprag.}

proc setRange*(self: SpinButton; min: cdouble; max: cdouble) =
  gtk_spin_button_set_range(cast[ptr SpinButton00](self.impl), min, max)

proc gtk_spin_button_set_snap_to_ticks(self: ptr SpinButton00; snapToTicks: gboolean) {.
    importc, libprag.}

proc setSnapToTicks*(self: SpinButton; snapToTicks: bool = true) =
  gtk_spin_button_set_snap_to_ticks(cast[ptr SpinButton00](self.impl), gboolean(snapToTicks))

proc `snapToTicks=`*(self: SpinButton; snapToTicks: bool) =
  gtk_spin_button_set_snap_to_ticks(cast[ptr SpinButton00](self.impl), gboolean(snapToTicks))

proc gtk_spin_button_set_value(self: ptr SpinButton00; value: cdouble) {.
    importc, libprag.}

proc setValue*(self: SpinButton; value: cdouble) =
  gtk_spin_button_set_value(cast[ptr SpinButton00](self.impl), value)

proc `value=`*(self: SpinButton; value: cdouble) =
  gtk_spin_button_set_value(cast[ptr SpinButton00](self.impl), value)

proc gtk_spin_button_set_wrap(self: ptr SpinButton00; wrap: gboolean) {.
    importc, libprag.}

proc setWrap*(self: SpinButton; wrap: bool = true) =
  gtk_spin_button_set_wrap(cast[ptr SpinButton00](self.impl), gboolean(wrap))

proc `wrap=`*(self: SpinButton; wrap: bool) =
  gtk_spin_button_set_wrap(cast[ptr SpinButton00](self.impl), gboolean(wrap))

proc gtk_spin_button_update(self: ptr SpinButton00) {.
    importc, libprag.}

proc update*(self: SpinButton) =
  gtk_spin_button_update(cast[ptr SpinButton00](self.impl))

type
  AppChooserButton* = ref object of ComboBox
  AppChooserButton00* = object of ComboBox00

proc gtk_app_chooser_button_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(AppChooserButton()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scCustomItemActivated*(self: AppChooserButton;  p: proc (self: ptr AppChooserButton00; itemName: cstring; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "custom-item-activated", cast[GCallback](p), xdata, nil, cf)

proc gtk_app_chooser_button_new(contentType: cstring): ptr AppChooserButton00 {.
    importc, libprag.}

proc newAppChooserButton*(contentType: cstring): AppChooserButton =
  let gobj = gtk_app_chooser_button_new(contentType)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newAppChooserButton*(tdesc: typedesc; contentType: cstring): tdesc =
  assert(result is AppChooserButton)
  let gobj = gtk_app_chooser_button_new(contentType)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initAppChooserButton*[T](result: var T; contentType: cstring) {.deprecated.} =
  assert(result is AppChooserButton)
  let gobj = gtk_app_chooser_button_new(contentType)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_app_chooser_button_append_custom_item(self: ptr AppChooserButton00;
    name: cstring; label: cstring; icon: ptr gio.Icon00) {.
    importc, libprag.}

proc appendCustomItem*(self: AppChooserButton; name: cstring;
    label: cstring; icon: gio.Icon) =
  gtk_app_chooser_button_append_custom_item(cast[ptr AppChooserButton00](self.impl), name, label, cast[ptr gio.Icon00](icon.impl))

proc gtk_app_chooser_button_append_separator(self: ptr AppChooserButton00) {.
    importc, libprag.}

proc appendSeparator*(self: AppChooserButton) =
  gtk_app_chooser_button_append_separator(cast[ptr AppChooserButton00](self.impl))

proc gtk_app_chooser_button_get_heading(self: ptr AppChooserButton00): cstring {.
    importc, libprag.}

proc getHeading*(self: AppChooserButton): string =
  let resul0 = gtk_app_chooser_button_get_heading(cast[ptr AppChooserButton00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc heading*(self: AppChooserButton): string =
  let resul0 = gtk_app_chooser_button_get_heading(cast[ptr AppChooserButton00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc gtk_app_chooser_button_get_show_default_item(self: ptr AppChooserButton00): gboolean {.
    importc, libprag.}

proc getShowDefaultItem*(self: AppChooserButton): bool =
  toBool(gtk_app_chooser_button_get_show_default_item(cast[ptr AppChooserButton00](self.impl)))

proc showDefaultItem*(self: AppChooserButton): bool =
  toBool(gtk_app_chooser_button_get_show_default_item(cast[ptr AppChooserButton00](self.impl)))

proc gtk_app_chooser_button_get_show_dialog_item(self: ptr AppChooserButton00): gboolean {.
    importc, libprag.}

proc getShowDialogItem*(self: AppChooserButton): bool =
  toBool(gtk_app_chooser_button_get_show_dialog_item(cast[ptr AppChooserButton00](self.impl)))

proc showDialogItem*(self: AppChooserButton): bool =
  toBool(gtk_app_chooser_button_get_show_dialog_item(cast[ptr AppChooserButton00](self.impl)))

proc gtk_app_chooser_button_set_active_custom_item(self: ptr AppChooserButton00;
    name: cstring) {.
    importc, libprag.}

proc setActiveCustomItem*(self: AppChooserButton;
    name: cstring) =
  gtk_app_chooser_button_set_active_custom_item(cast[ptr AppChooserButton00](self.impl), name)

proc `activeCustomItem=`*(self: AppChooserButton;
    name: cstring) =
  gtk_app_chooser_button_set_active_custom_item(cast[ptr AppChooserButton00](self.impl), name)

proc gtk_app_chooser_button_set_heading(self: ptr AppChooserButton00; heading: cstring) {.
    importc, libprag.}

proc setHeading*(self: AppChooserButton; heading: cstring) =
  gtk_app_chooser_button_set_heading(cast[ptr AppChooserButton00](self.impl), heading)

proc `heading=`*(self: AppChooserButton; heading: cstring) =
  gtk_app_chooser_button_set_heading(cast[ptr AppChooserButton00](self.impl), heading)

proc gtk_app_chooser_button_set_show_default_item(self: ptr AppChooserButton00;
    setting: gboolean) {.
    importc, libprag.}

proc setShowDefaultItem*(self: AppChooserButton;
    setting: bool = true) =
  gtk_app_chooser_button_set_show_default_item(cast[ptr AppChooserButton00](self.impl), gboolean(setting))

proc `showDefaultItem=`*(self: AppChooserButton;
    setting: bool) =
  gtk_app_chooser_button_set_show_default_item(cast[ptr AppChooserButton00](self.impl), gboolean(setting))

proc gtk_app_chooser_button_set_show_dialog_item(self: ptr AppChooserButton00;
    setting: gboolean) {.
    importc, libprag.}

proc setShowDialogItem*(self: AppChooserButton;
    setting: bool = true) =
  gtk_app_chooser_button_set_show_dialog_item(cast[ptr AppChooserButton00](self.impl), gboolean(setting))

proc `showDialogItem=`*(self: AppChooserButton;
    setting: bool) =
  gtk_app_chooser_button_set_show_dialog_item(cast[ptr AppChooserButton00](self.impl), gboolean(setting))

type
  SearchEntry* = ref object of Entry
  SearchEntry00* = object of Entry00

proc gtk_search_entry_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(SearchEntry()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scNextMatch*(self: SearchEntry;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "next-match", cast[GCallback](p), xdata, nil, cf)

proc scPreviousMatch*(self: SearchEntry;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "previous-match", cast[GCallback](p), xdata, nil, cf)

proc scSearchChanged*(self: SearchEntry;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "search-changed", cast[GCallback](p), xdata, nil, cf)

proc scStopSearch*(self: SearchEntry;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "stop-search", cast[GCallback](p), xdata, nil, cf)

proc gtk_search_entry_new(): ptr SearchEntry00 {.
    importc, libprag.}

proc newSearchEntry*(): SearchEntry =
  let gobj = gtk_search_entry_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newSearchEntry*(tdesc: typedesc): tdesc =
  assert(result is SearchEntry)
  let gobj = gtk_search_entry_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initSearchEntry*[T](result: var T) {.deprecated.} =
  assert(result is SearchEntry)
  let gobj = gtk_search_entry_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_search_entry_handle_event(self: ptr SearchEntry00; event: ptr gdk.Event00): gboolean {.
    importc, libprag.}

proc handleEvent*(self: SearchEntry; event: gdk.Event): bool =
  toBool(gtk_search_entry_handle_event(cast[ptr SearchEntry00](self.impl), cast[ptr gdk.Event00](event.impl)))

type
  CellEditable00* = object of gobject.Object00
  CellEditable* = ref object of gobject.Object

proc scEditingDone*(self: CellEditable | ComboBoxText | SpinButton | AppChooserButton | Entry | SearchEntry | ComboBox;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "editing-done", cast[GCallback](p), xdata, nil, cf)

proc scRemoveWidget*(self: CellEditable | ComboBoxText | SpinButton | AppChooserButton | Entry | SearchEntry | ComboBox;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "remove-widget", cast[GCallback](p), xdata, nil, cf)

proc gtk_cell_editable_editing_done(self: ptr CellEditable00) {.
    importc, libprag.}

proc editingDone*(self: CellEditable | ComboBoxText | SpinButton | AppChooserButton | Entry | SearchEntry | ComboBox) =
  gtk_cell_editable_editing_done(cast[ptr CellEditable00](self.impl))

proc gtk_cell_editable_remove_widget(self: ptr CellEditable00) {.
    importc, libprag.}

proc removeWidget*(self: CellEditable | ComboBoxText | SpinButton | AppChooserButton | Entry | SearchEntry | ComboBox) =
  gtk_cell_editable_remove_widget(cast[ptr CellEditable00](self.impl))

proc gtk_cell_editable_start_editing(self: ptr CellEditable00; event: ptr gdk.Event00) {.
    importc, libprag.}

proc startEditing*(self: CellEditable | ComboBoxText | SpinButton | AppChooserButton | Entry | SearchEntry | ComboBox;
    event: gdk.Event = nil) =
  gtk_cell_editable_start_editing(cast[ptr CellEditable00](self.impl), if event.isNil: nil else: cast[ptr gdk.Event00](event.impl))

type
  CellRenderer* = ref object of gobject.InitiallyUnowned
  CellRenderer00* = object of gobject.InitiallyUnowned00

proc gtk_cell_renderer_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(CellRenderer()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scEditingCanceled*(self: CellRenderer;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "editing-canceled", cast[GCallback](p), xdata, nil, cf)

proc scEditingStarted*(self: CellRenderer;  p: proc (self: ptr CellRenderer00; editable: ptr CellEditable00; path: cstring; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "editing-started", cast[GCallback](p), xdata, nil, cf)

proc gtk_cell_renderer_get_alignment(self: ptr CellRenderer00; xalign: var cfloat;
    yalign: var cfloat) {.
    importc, libprag.}

proc getAlignment*(self: CellRenderer; xalign: var cfloat = cast[var cfloat](nil);
    yalign: var cfloat = cast[var cfloat](nil)) =
  gtk_cell_renderer_get_alignment(cast[ptr CellRenderer00](self.impl), xalign, yalign)

proc gtk_cell_renderer_get_fixed_size(self: ptr CellRenderer00; width: var int32;
    height: var int32) {.
    importc, libprag.}

proc getFixedSize*(self: CellRenderer; width: var int = cast[var int](nil);
    height: var int = cast[var int](nil)) =
  var width_00: int32
  var height_00: int32
  gtk_cell_renderer_get_fixed_size(cast[ptr CellRenderer00](self.impl), width_00, height_00)
  if width.addr != nil:
    width = int(width_00)
  if height.addr != nil:
    height = int(height_00)

proc gtk_cell_renderer_get_padding(self: ptr CellRenderer00; xpad: var int32;
    ypad: var int32) {.
    importc, libprag.}

proc getPadding*(self: CellRenderer; xpad: var int = cast[var int](nil);
    ypad: var int = cast[var int](nil)) =
  var ypad_00: int32
  var xpad_00: int32
  gtk_cell_renderer_get_padding(cast[ptr CellRenderer00](self.impl), xpad_00, ypad_00)
  if ypad.addr != nil:
    ypad = int(ypad_00)
  if xpad.addr != nil:
    xpad = int(xpad_00)

proc gtk_cell_renderer_get_preferred_height(self: ptr CellRenderer00; widget: ptr Widget00;
    minimumSize: var int32; naturalSize: var int32) {.
    importc, libprag.}

proc getPreferredHeight*(self: CellRenderer; widget: Widget;
    minimumSize: var int = cast[var int](nil); naturalSize: var int = cast[var int](nil)) =
  var minimumSize_00: int32
  var naturalSize_00: int32
  gtk_cell_renderer_get_preferred_height(cast[ptr CellRenderer00](self.impl), cast[ptr Widget00](widget.impl), minimumSize_00, naturalSize_00)
  if minimumSize.addr != nil:
    minimumSize = int(minimumSize_00)
  if naturalSize.addr != nil:
    naturalSize = int(naturalSize_00)

proc gtk_cell_renderer_get_preferred_height_for_width(self: ptr CellRenderer00;
    widget: ptr Widget00; width: int32; minimumHeight: var int32; naturalHeight: var int32) {.
    importc, libprag.}

proc getPreferredHeightForWidth*(self: CellRenderer;
    widget: Widget; width: int; minimumHeight: var int = cast[var int](nil);
    naturalHeight: var int = cast[var int](nil)) =
  var naturalHeight_00: int32
  var minimumHeight_00: int32
  gtk_cell_renderer_get_preferred_height_for_width(cast[ptr CellRenderer00](self.impl), cast[ptr Widget00](widget.impl), int32(width), minimumHeight_00, naturalHeight_00)
  if naturalHeight.addr != nil:
    naturalHeight = int(naturalHeight_00)
  if minimumHeight.addr != nil:
    minimumHeight = int(minimumHeight_00)

proc gtk_cell_renderer_get_preferred_size(self: ptr CellRenderer00; widget: ptr Widget00;
    minimumSize: var Requisition; naturalSize: var Requisition) {.
    importc, libprag.}

proc getPreferredSize*(self: CellRenderer; widget: Widget;
    minimumSize: var Requisition = cast[var Requisition](nil); naturalSize: var Requisition = cast[var Requisition](nil)) =
  gtk_cell_renderer_get_preferred_size(cast[ptr CellRenderer00](self.impl), cast[ptr Widget00](widget.impl), minimumSize, naturalSize)

proc gtk_cell_renderer_get_preferred_width(self: ptr CellRenderer00; widget: ptr Widget00;
    minimumSize: var int32; naturalSize: var int32) {.
    importc, libprag.}

proc getPreferredWidth*(self: CellRenderer; widget: Widget;
    minimumSize: var int = cast[var int](nil); naturalSize: var int = cast[var int](nil)) =
  var minimumSize_00: int32
  var naturalSize_00: int32
  gtk_cell_renderer_get_preferred_width(cast[ptr CellRenderer00](self.impl), cast[ptr Widget00](widget.impl), minimumSize_00, naturalSize_00)
  if minimumSize.addr != nil:
    minimumSize = int(minimumSize_00)
  if naturalSize.addr != nil:
    naturalSize = int(naturalSize_00)

proc gtk_cell_renderer_get_preferred_width_for_height(self: ptr CellRenderer00;
    widget: ptr Widget00; height: int32; minimumWidth: var int32; naturalWidth: var int32) {.
    importc, libprag.}

proc getPreferredWidthForHeight*(self: CellRenderer;
    widget: Widget; height: int; minimumWidth: var int = cast[var int](nil);
    naturalWidth: var int = cast[var int](nil)) =
  var minimumWidth_00: int32
  var naturalWidth_00: int32
  gtk_cell_renderer_get_preferred_width_for_height(cast[ptr CellRenderer00](self.impl), cast[ptr Widget00](widget.impl), int32(height), minimumWidth_00, naturalWidth_00)
  if minimumWidth.addr != nil:
    minimumWidth = int(minimumWidth_00)
  if naturalWidth.addr != nil:
    naturalWidth = int(naturalWidth_00)

proc gtk_cell_renderer_get_request_mode(self: ptr CellRenderer00): SizeRequestMode {.
    importc, libprag.}

proc getRequestMode*(self: CellRenderer): SizeRequestMode =
  gtk_cell_renderer_get_request_mode(cast[ptr CellRenderer00](self.impl))

proc requestMode*(self: CellRenderer): SizeRequestMode =
  gtk_cell_renderer_get_request_mode(cast[ptr CellRenderer00](self.impl))

proc gtk_cell_renderer_get_sensitive(self: ptr CellRenderer00): gboolean {.
    importc, libprag.}

proc getSensitive*(self: CellRenderer): bool =
  toBool(gtk_cell_renderer_get_sensitive(cast[ptr CellRenderer00](self.impl)))

proc sensitive*(self: CellRenderer): bool =
  toBool(gtk_cell_renderer_get_sensitive(cast[ptr CellRenderer00](self.impl)))

proc gtk_cell_renderer_get_size(self: ptr CellRenderer00; widget: ptr Widget00;
    cellArea: gdk.Rectangle; xOffset: var int32; yOffset: var int32; width: var int32;
    height: var int32) {.
    importc, libprag.}

proc getSize*(self: CellRenderer; widget: Widget; cellArea: gdk.Rectangle = cast[var gdk.Rectangle](nil);
    xOffset: var int = cast[var int](nil); yOffset: var int = cast[var int](nil);
    width: var int = cast[var int](nil); height: var int = cast[var int](nil)) =
  var width_00: int32
  var yOffset_00: int32
  var xOffset_00: int32
  var height_00: int32
  gtk_cell_renderer_get_size(cast[ptr CellRenderer00](self.impl), cast[ptr Widget00](widget.impl), cellArea, xOffset_00, yOffset_00, width_00, height_00)
  if width.addr != nil:
    width = int(width_00)
  if yOffset.addr != nil:
    yOffset = int(yOffset_00)
  if xOffset.addr != nil:
    xOffset = int(xOffset_00)
  if height.addr != nil:
    height = int(height_00)

proc gtk_cell_renderer_get_visible(self: ptr CellRenderer00): gboolean {.
    importc, libprag.}

proc getVisible*(self: CellRenderer): bool =
  toBool(gtk_cell_renderer_get_visible(cast[ptr CellRenderer00](self.impl)))

proc visible*(self: CellRenderer): bool =
  toBool(gtk_cell_renderer_get_visible(cast[ptr CellRenderer00](self.impl)))

proc gtk_cell_renderer_is_activatable(self: ptr CellRenderer00): gboolean {.
    importc, libprag.}

proc isActivatable*(self: CellRenderer): bool =
  toBool(gtk_cell_renderer_is_activatable(cast[ptr CellRenderer00](self.impl)))

proc gtk_cell_renderer_set_alignment(self: ptr CellRenderer00; xalign: cfloat;
    yalign: cfloat) {.
    importc, libprag.}

proc setAlignment*(self: CellRenderer; xalign: cfloat;
    yalign: cfloat) =
  gtk_cell_renderer_set_alignment(cast[ptr CellRenderer00](self.impl), xalign, yalign)

proc gtk_cell_renderer_set_fixed_size(self: ptr CellRenderer00; width: int32;
    height: int32) {.
    importc, libprag.}

proc setFixedSize*(self: CellRenderer; width: int; height: int) =
  gtk_cell_renderer_set_fixed_size(cast[ptr CellRenderer00](self.impl), int32(width), int32(height))

proc gtk_cell_renderer_set_padding(self: ptr CellRenderer00; xpad: int32;
    ypad: int32) {.
    importc, libprag.}

proc setPadding*(self: CellRenderer; xpad: int; ypad: int) =
  gtk_cell_renderer_set_padding(cast[ptr CellRenderer00](self.impl), int32(xpad), int32(ypad))

proc gtk_cell_renderer_set_sensitive(self: ptr CellRenderer00; sensitive: gboolean) {.
    importc, libprag.}

proc setSensitive*(self: CellRenderer; sensitive: bool = true) =
  gtk_cell_renderer_set_sensitive(cast[ptr CellRenderer00](self.impl), gboolean(sensitive))

proc `sensitive=`*(self: CellRenderer; sensitive: bool) =
  gtk_cell_renderer_set_sensitive(cast[ptr CellRenderer00](self.impl), gboolean(sensitive))

proc gtk_cell_renderer_set_visible(self: ptr CellRenderer00; visible: gboolean) {.
    importc, libprag.}

proc setVisible*(self: CellRenderer; visible: bool = true) =
  gtk_cell_renderer_set_visible(cast[ptr CellRenderer00](self.impl), gboolean(visible))

proc `visible=`*(self: CellRenderer; visible: bool) =
  gtk_cell_renderer_set_visible(cast[ptr CellRenderer00](self.impl), gboolean(visible))

proc gtk_cell_renderer_stop_editing(self: ptr CellRenderer00; canceled: gboolean) {.
    importc, libprag.}

proc stopEditing*(self: CellRenderer; canceled: bool) =
  gtk_cell_renderer_stop_editing(cast[ptr CellRenderer00](self.impl), gboolean(canceled))

proc gtk_renderer_cell_accessible_new(renderer: ptr CellRenderer00): ptr RendererCellAccessible00 {.
    importc, libprag.}

proc newRendererCellAccessible*(renderer: CellRenderer): RendererCellAccessible =
  let gobj = gtk_renderer_cell_accessible_new(cast[ptr CellRenderer00](renderer.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newRendererCellAccessible*(tdesc: typedesc; renderer: CellRenderer): tdesc =
  assert(result is RendererCellAccessible)
  let gobj = gtk_renderer_cell_accessible_new(cast[ptr CellRenderer00](renderer.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initRendererCellAccessible*[T](result: var T; renderer: CellRenderer) {.deprecated.} =
  assert(result is RendererCellAccessible)
  let gobj = gtk_renderer_cell_accessible_new(cast[ptr CellRenderer00](renderer.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  CellRendererState* {.size: sizeof(cint), pure.} = enum
    selected = 1
    prelit = 2
    insensitive = 4
    sorted = 8
    focused = 16
    expandable = 32
    expanded = 64

proc gtk_cell_renderer_activate(self: ptr CellRenderer00; event: ptr gdk.Event00;
    widget: ptr Widget00; path: cstring; backgroundArea: gdk.Rectangle; cellArea: gdk.Rectangle;
    flags: CellRendererState): gboolean {.
    importc, libprag.}

proc activate*(self: CellRenderer; event: gdk.Event; widget: Widget;
    path: cstring; backgroundArea: gdk.Rectangle; cellArea: gdk.Rectangle;
    flags: CellRendererState): bool =
  toBool(gtk_cell_renderer_activate(cast[ptr CellRenderer00](self.impl), cast[ptr gdk.Event00](event.impl), cast[ptr Widget00](widget.impl), path, backgroundArea, cellArea, flags))

proc gtk_cell_renderer_get_aligned_area(self: ptr CellRenderer00; widget: ptr Widget00;
    flags: CellRendererState; cellArea: gdk.Rectangle; alignedArea: var gdk.Rectangle) {.
    importc, libprag.}

proc getAlignedArea*(self: CellRenderer; widget: Widget;
    flags: CellRendererState; cellArea: gdk.Rectangle; alignedArea: var gdk.Rectangle) =
  gtk_cell_renderer_get_aligned_area(cast[ptr CellRenderer00](self.impl), cast[ptr Widget00](widget.impl), flags, cellArea, alignedArea)

proc gtk_cell_renderer_get_state(self: ptr CellRenderer00; widget: ptr Widget00;
    cellState: CellRendererState): StateFlags {.
    importc, libprag.}

proc getState*(self: CellRenderer; widget: Widget = nil;
    cellState: CellRendererState): StateFlags =
  gtk_cell_renderer_get_state(cast[ptr CellRenderer00](self.impl), if widget.isNil: nil else: cast[ptr Widget00](widget.impl), cellState)

proc gtk_cell_renderer_render(self: ptr CellRenderer00; cr: ptr cairo.Context00;
    widget: ptr Widget00; backgroundArea: gdk.Rectangle; cellArea: gdk.Rectangle;
    flags: CellRendererState) {.
    importc, libprag.}

proc render*(self: CellRenderer; cr: cairo.Context; widget: Widget;
    backgroundArea: gdk.Rectangle; cellArea: gdk.Rectangle; flags: CellRendererState) =
  gtk_cell_renderer_render(cast[ptr CellRenderer00](self.impl), cast[ptr cairo.Context00](cr.impl), cast[ptr Widget00](widget.impl), backgroundArea, cellArea, flags)

proc gtk_cell_renderer_start_editing(self: ptr CellRenderer00; event: ptr gdk.Event00;
    widget: ptr Widget00; path: cstring; backgroundArea: gdk.Rectangle; cellArea: gdk.Rectangle;
    flags: CellRendererState): ptr CellEditable00 {.
    importc, libprag.}

proc startEditing*(self: CellRenderer; event: gdk.Event = nil;
    widget: Widget; path: cstring; backgroundArea: gdk.Rectangle; cellArea: gdk.Rectangle;
    flags: CellRendererState): CellEditable =
  let gobj = gtk_cell_renderer_start_editing(cast[ptr CellRenderer00](self.impl), if event.isNil: nil else: cast[ptr gdk.Event00](event.impl), cast[ptr Widget00](widget.impl), path, backgroundArea, cellArea, flags)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  ImageType* {.size: sizeof(cint), pure.} = enum
    empty = 0
    pixbuf = 1
    stock = 2
    iconSet = 3
    animation = 4
    iconName = 5
    gicon = 6
    surface = 7

proc gtk_entry_get_icon_storage_type(self: ptr Entry00; iconPos: EntryIconPosition): ImageType {.
    importc, libprag.}

proc getIconStorageType*(self: Entry; iconPos: EntryIconPosition): ImageType =
  gtk_entry_get_icon_storage_type(cast[ptr Entry00](self.impl), iconPos)

type
  EntryBuffer* = ref object of gobject.Object
  EntryBuffer00* = object of gobject.Object00

proc gtk_entry_buffer_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(EntryBuffer()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scDeletedText*(self: EntryBuffer;  p: proc (self: ptr EntryBuffer00; position: uint32; nChars: uint32; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "deleted-text", cast[GCallback](p), xdata, nil, cf)

proc scInsertedText*(self: EntryBuffer;  p: proc (self: ptr EntryBuffer00; position: uint32; chars: cstring; nChars: uint32; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "inserted-text", cast[GCallback](p), xdata, nil, cf)

proc gtk_entry_buffer_new(initialChars: cstring; nInitialChars: int32): ptr EntryBuffer00 {.
    importc, libprag.}

proc newEntryBuffer*(initialChars: cstring = nil; nInitialChars: int): EntryBuffer =
  let gobj = gtk_entry_buffer_new(initialChars, int32(nInitialChars))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newEntryBuffer*(tdesc: typedesc; initialChars: cstring = nil; nInitialChars: int): tdesc =
  assert(result is EntryBuffer)
  let gobj = gtk_entry_buffer_new(initialChars, int32(nInitialChars))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initEntryBuffer*[T](result: var T; initialChars: cstring = nil; nInitialChars: int) {.deprecated.} =
  assert(result is EntryBuffer)
  let gobj = gtk_entry_buffer_new(initialChars, int32(nInitialChars))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_entry_buffer_delete_text(self: ptr EntryBuffer00; position: uint32;
    nChars: int32): uint32 {.
    importc, libprag.}

proc deleteText*(self: EntryBuffer; position: int; nChars: int): int =
  int(gtk_entry_buffer_delete_text(cast[ptr EntryBuffer00](self.impl), uint32(position), int32(nChars)))

proc gtk_entry_buffer_emit_deleted_text(self: ptr EntryBuffer00; position: uint32;
    nChars: uint32) {.
    importc, libprag.}

proc emitDeletedText*(self: EntryBuffer; position: int;
    nChars: int) =
  gtk_entry_buffer_emit_deleted_text(cast[ptr EntryBuffer00](self.impl), uint32(position), uint32(nChars))

proc gtk_entry_buffer_emit_inserted_text(self: ptr EntryBuffer00; position: uint32;
    chars: cstring; nChars: uint32) {.
    importc, libprag.}

proc emitInsertedText*(self: EntryBuffer; position: int;
    chars: cstring; nChars: int) =
  gtk_entry_buffer_emit_inserted_text(cast[ptr EntryBuffer00](self.impl), uint32(position), chars, uint32(nChars))

proc gtk_entry_buffer_get_bytes(self: ptr EntryBuffer00): uint64 {.
    importc, libprag.}

proc getBytes*(self: EntryBuffer): uint64 =
  gtk_entry_buffer_get_bytes(cast[ptr EntryBuffer00](self.impl))

proc bytes*(self: EntryBuffer): uint64 =
  gtk_entry_buffer_get_bytes(cast[ptr EntryBuffer00](self.impl))

proc gtk_entry_buffer_get_length(self: ptr EntryBuffer00): uint32 {.
    importc, libprag.}

proc getLength*(self: EntryBuffer): int =
  int(gtk_entry_buffer_get_length(cast[ptr EntryBuffer00](self.impl)))

proc length*(self: EntryBuffer): int =
  int(gtk_entry_buffer_get_length(cast[ptr EntryBuffer00](self.impl)))

proc gtk_entry_buffer_get_max_length(self: ptr EntryBuffer00): int32 {.
    importc, libprag.}

proc getMaxLength*(self: EntryBuffer): int =
  int(gtk_entry_buffer_get_max_length(cast[ptr EntryBuffer00](self.impl)))

proc maxLength*(self: EntryBuffer): int =
  int(gtk_entry_buffer_get_max_length(cast[ptr EntryBuffer00](self.impl)))

proc gtk_entry_buffer_get_text(self: ptr EntryBuffer00): cstring {.
    importc, libprag.}

proc getText*(self: EntryBuffer): string =
  result = $gtk_entry_buffer_get_text(cast[ptr EntryBuffer00](self.impl))

proc text*(self: EntryBuffer): string =
  result = $gtk_entry_buffer_get_text(cast[ptr EntryBuffer00](self.impl))

proc gtk_entry_buffer_insert_text(self: ptr EntryBuffer00; position: uint32;
    chars: cstring; nChars: int32): uint32 {.
    importc, libprag.}

proc insertText*(self: EntryBuffer; position: int; chars: cstring;
    nChars: int): int =
  int(gtk_entry_buffer_insert_text(cast[ptr EntryBuffer00](self.impl), uint32(position), chars, int32(nChars)))

proc gtk_entry_buffer_set_max_length(self: ptr EntryBuffer00; maxLength: int32) {.
    importc, libprag.}

proc setMaxLength*(self: EntryBuffer; maxLength: int) =
  gtk_entry_buffer_set_max_length(cast[ptr EntryBuffer00](self.impl), int32(maxLength))

proc `maxLength=`*(self: EntryBuffer; maxLength: int) =
  gtk_entry_buffer_set_max_length(cast[ptr EntryBuffer00](self.impl), int32(maxLength))

proc gtk_entry_buffer_set_text(self: ptr EntryBuffer00; chars: cstring; nChars: int32) {.
    importc, libprag.}

proc setText*(self: EntryBuffer; chars: cstring; nChars: int) =
  gtk_entry_buffer_set_text(cast[ptr EntryBuffer00](self.impl), chars, int32(nChars))

proc gtk_entry_new_with_buffer(buffer: ptr EntryBuffer00): ptr Entry00 {.
    importc, libprag.}

proc newEntryWithBuffer*(buffer: EntryBuffer): Entry =
  let gobj = gtk_entry_new_with_buffer(cast[ptr EntryBuffer00](buffer.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newEntryWithBuffer*(tdesc: typedesc; buffer: EntryBuffer): tdesc =
  assert(result is Entry)
  let gobj = gtk_entry_new_with_buffer(cast[ptr EntryBuffer00](buffer.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initEntryWithBuffer*[T](result: var T; buffer: EntryBuffer) {.deprecated.} =
  assert(result is Entry)
  let gobj = gtk_entry_new_with_buffer(cast[ptr EntryBuffer00](buffer.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_entry_get_buffer(self: ptr Entry00): ptr EntryBuffer00 {.
    importc, libprag.}

proc getBuffer*(self: Entry): EntryBuffer =
  let gobj = gtk_entry_get_buffer(cast[ptr Entry00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc buffer*(self: Entry): EntryBuffer =
  let gobj = gtk_entry_get_buffer(cast[ptr Entry00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_entry_set_buffer(self: ptr Entry00; buffer: ptr EntryBuffer00) {.
    importc, libprag.}

proc setBuffer*(self: Entry; buffer: EntryBuffer) =
  gtk_entry_set_buffer(cast[ptr Entry00](self.impl), cast[ptr EntryBuffer00](buffer.impl))

proc `buffer=`*(self: Entry; buffer: EntryBuffer) =
  gtk_entry_set_buffer(cast[ptr Entry00](self.impl), cast[ptr EntryBuffer00](buffer.impl))

type
  InputHints* {.size: sizeof(cint), pure.} = enum
    none = 0
    spellcheck = 1
    noSpellcheck = 2
    wordCompletion = 4
    lowercase = 8
    uppercaseChars = 16
    uppercaseWords = 32
    uppercaseSentences = 64
    inhibitOsk = 128
    verticalWriting = 256
    emoji = 512
    noEmoji = 1024

proc gtk_entry_get_input_hints(self: ptr Entry00): InputHints {.
    importc, libprag.}

proc getInputHints*(self: Entry): InputHints =
  gtk_entry_get_input_hints(cast[ptr Entry00](self.impl))

proc inputHints*(self: Entry): InputHints =
  gtk_entry_get_input_hints(cast[ptr Entry00](self.impl))

proc gtk_entry_set_input_hints(self: ptr Entry00; hints: InputHints) {.
    importc, libprag.}

proc setInputHints*(self: Entry; hints: InputHints) =
  gtk_entry_set_input_hints(cast[ptr Entry00](self.impl), hints)

proc `inputHints=`*(self: Entry; hints: InputHints) =
  gtk_entry_set_input_hints(cast[ptr Entry00](self.impl), hints)

type
  InputPurpose* {.size: sizeof(cint), pure.} = enum
    freeForm = 0
    alpha = 1
    digits = 2
    number = 3
    phone = 4
    url = 5
    email = 6
    name = 7
    password = 8
    pin = 9
    terminal = 10

proc gtk_entry_get_input_purpose(self: ptr Entry00): InputPurpose {.
    importc, libprag.}

proc getInputPurpose*(self: Entry): InputPurpose =
  gtk_entry_get_input_purpose(cast[ptr Entry00](self.impl))

proc inputPurpose*(self: Entry): InputPurpose =
  gtk_entry_get_input_purpose(cast[ptr Entry00](self.impl))

proc gtk_entry_set_input_purpose(self: ptr Entry00; purpose: InputPurpose) {.
    importc, libprag.}

proc setInputPurpose*(self: Entry; purpose: InputPurpose) =
  gtk_entry_set_input_purpose(cast[ptr Entry00](self.impl), purpose)

proc `inputPurpose=`*(self: Entry; purpose: InputPurpose) =
  gtk_entry_set_input_purpose(cast[ptr Entry00](self.impl), purpose)

type
  SpinButtonUpdatePolicy* {.size: sizeof(cint), pure.} = enum
    always = 0
    ifValid = 1

proc gtk_spin_button_get_update_policy(self: ptr SpinButton00): SpinButtonUpdatePolicy {.
    importc, libprag.}

proc getUpdatePolicy*(self: SpinButton): SpinButtonUpdatePolicy =
  gtk_spin_button_get_update_policy(cast[ptr SpinButton00](self.impl))

proc updatePolicy*(self: SpinButton): SpinButtonUpdatePolicy =
  gtk_spin_button_get_update_policy(cast[ptr SpinButton00](self.impl))

proc gtk_spin_button_set_update_policy(self: ptr SpinButton00; policy: SpinButtonUpdatePolicy) {.
    importc, libprag.}

proc setUpdatePolicy*(self: SpinButton; policy: SpinButtonUpdatePolicy) =
  gtk_spin_button_set_update_policy(cast[ptr SpinButton00](self.impl), policy)

proc `updatePolicy=`*(self: SpinButton; policy: SpinButtonUpdatePolicy) =
  gtk_spin_button_set_update_policy(cast[ptr SpinButton00](self.impl), policy)

type
  SpinType* {.size: sizeof(cint), pure.} = enum
    stepForward = 0
    stepBackward = 1
    pageForward = 2
    pageBackward = 3
    home = 4
    `end` = 5
    userDefined = 6

proc gtk_spin_button_spin(self: ptr SpinButton00; direction: SpinType; increment: cdouble) {.
    importc, libprag.}

proc spin*(self: SpinButton; direction: SpinType; increment: cdouble) =
  gtk_spin_button_spin(cast[ptr SpinButton00](self.impl), direction, increment)

type
  TreeIter* {.pure, byRef.} = object
    stamp*: int32
    userData*: pointer
    userData2*: pointer
    userData3*: pointer

proc gtk_tree_iter_get_type*(): GType {.importc, libprag.}

proc gtk_tree_iter_free(self: TreeIter) {.
    importc, libprag.}

proc free*(self: TreeIter) =
  gtk_tree_iter_free(self)

proc gtk_tree_iter_copy(self: TreeIter): ptr TreeIter {.
    importc, libprag.}

proc copy*(self: TreeIter): ptr TreeIter =
  gtk_tree_iter_copy(self)

proc gtk_combo_box_get_active_iter(self: ptr ComboBox00; iter: var TreeIter): gboolean {.
    importc, libprag.}

proc getActiveIter*(self: ComboBox; iter: var TreeIter): bool =
  toBool(gtk_combo_box_get_active_iter(cast[ptr ComboBox00](self.impl), iter))

proc gtk_combo_box_set_active_iter(self: ptr ComboBox00; iter: TreeIter) {.
    importc, libprag.}

proc setActiveIter*(self: ComboBox; iter: TreeIter = cast[var TreeIter](nil)) =
  gtk_combo_box_set_active_iter(cast[ptr ComboBox00](self.impl), iter)

proc `activeIter=`*(self: ComboBox; iter: TreeIter = cast[var TreeIter](nil)) =
  gtk_combo_box_set_active_iter(cast[ptr ComboBox00](self.impl), iter)

type
  SensitivityType* {.size: sizeof(cint), pure.} = enum
    auto = 0
    on = 1
    off = 2

proc gtk_combo_box_get_button_sensitivity(self: ptr ComboBox00): SensitivityType {.
    importc, libprag.}

proc getButtonSensitivity*(self: ComboBox): SensitivityType =
  gtk_combo_box_get_button_sensitivity(cast[ptr ComboBox00](self.impl))

proc buttonSensitivity*(self: ComboBox): SensitivityType =
  gtk_combo_box_get_button_sensitivity(cast[ptr ComboBox00](self.impl))

proc gtk_combo_box_set_button_sensitivity(self: ptr ComboBox00; sensitivity: SensitivityType) {.
    importc, libprag.}

proc setButtonSensitivity*(self: ComboBox; sensitivity: SensitivityType) =
  gtk_combo_box_set_button_sensitivity(cast[ptr ComboBox00](self.impl), sensitivity)

proc `buttonSensitivity=`*(self: ComboBox; sensitivity: SensitivityType) =
  gtk_combo_box_set_button_sensitivity(cast[ptr ComboBox00](self.impl), sensitivity)

type
  TreePath00* {.pure.} = object
  TreePath* = ref object
    impl*: ptr TreePath00
    ignoreFinalizer*: bool

proc gtk_tree_path_get_type*(): GType {.importc, libprag.}

proc gBoxedFreeGtkTreePath*(self: TreePath) =
  if not self.ignoreFinalizer:
    boxedFree(gtk_tree_path_get_type(), cast[ptr TreePath00](self.impl))

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(TreePath()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    if not self.ignoreFinalizer and self.impl != nil:
      boxedFree(gtk_tree_path_get_type(), cast[ptr TreePath00](self.impl))
      self.impl = nil

proc newWithFinalizer*(x: var TreePath) =
  when defined(gcDestructors):
    new(x)
  else:
    new(x, gBoxedFreeGtkTreePath)

proc gtk_tree_path_free(self: ptr TreePath00) {.
    importc, libprag.}

proc free*(self: TreePath) =
  gtk_tree_path_free(cast[ptr TreePath00](self.impl))

proc finalizerfree*(self: TreePath) =
  if not self.ignoreFinalizer:
    gtk_tree_path_free(cast[ptr TreePath00](self.impl))

proc gtk_tree_path_new_first(): ptr TreePath00 {.
    importc, libprag.}

proc newTreePathFirst*(): TreePath =
  fnew(result, gBoxedFreeGtkTreePath)
  result.impl = gtk_tree_path_new_first()

proc newTreePathFirst*(tdesc: typedesc): tdesc =
  assert(result is TreePath)
  fnew(result, gBoxedFreeGtkTreePath)
  result.impl = gtk_tree_path_new_first()

proc initTreePathFirst*[T](result: var T) {.deprecated.} =
  assert(result is TreePath)
  fnew(result, gBoxedFreeGtkTreePath)
  result.impl = gtk_tree_path_new_first()

proc gtk_tree_path_new_from_indicesv(indices: ptr int32; length: uint64): ptr TreePath00 {.
    importc, libprag.}

proc newTreePathFromIndices*(indices: seq[int32]): TreePath =
  let length = uint64(indices.len)
  fnew(result, gBoxedFreeGtkTreePath)
  result.impl = gtk_tree_path_new_from_indicesv(cast[ptr int32](unsafeaddr(indices[0])), length)

proc newTreePathFromIndices*(tdesc: typedesc; indices: seq[int32]): tdesc =
  let length = uint64(indices.len)
  assert(result is TreePath)
  fnew(result, gBoxedFreeGtkTreePath)
  result.impl = gtk_tree_path_new_from_indicesv(cast[ptr int32](unsafeaddr(indices[0])), length)

proc initTreePathFromIndices*[T](result: var T; indices: seq[int32]) {.deprecated.} =
  let length = uint64(indices.len)
  assert(result is TreePath)
  fnew(result, gBoxedFreeGtkTreePath)
  result.impl = gtk_tree_path_new_from_indicesv(cast[ptr int32](unsafeaddr(indices[0])), length)

proc gtk_tree_path_new_from_string(path: cstring): ptr TreePath00 {.
    importc, libprag.}

proc newTreePathFromString*(path: cstring): TreePath =
  fnew(result, gBoxedFreeGtkTreePath)
  result.impl = gtk_tree_path_new_from_string(path)

proc newTreePathFromString*(tdesc: typedesc; path: cstring): tdesc =
  assert(result is TreePath)
  fnew(result, gBoxedFreeGtkTreePath)
  result.impl = gtk_tree_path_new_from_string(path)

proc initTreePathFromString*[T](result: var T; path: cstring) {.deprecated.} =
  assert(result is TreePath)
  fnew(result, gBoxedFreeGtkTreePath)
  result.impl = gtk_tree_path_new_from_string(path)

proc gtk_tree_path_append_index(self: ptr TreePath00; index: int32) {.
    importc, libprag.}

proc appendIndex*(self: TreePath; index: int) =
  gtk_tree_path_append_index(cast[ptr TreePath00](self.impl), int32(index))

proc gtk_tree_path_compare(self: ptr TreePath00; b: ptr TreePath00): int32 {.
    importc, libprag.}

proc compare*(self: TreePath; b: TreePath): int =
  int(gtk_tree_path_compare(cast[ptr TreePath00](self.impl), cast[ptr TreePath00](b.impl)))

proc gtk_tree_path_copy(self: ptr TreePath00): ptr TreePath00 {.
    importc, libprag.}

proc copy*(self: TreePath): TreePath =
  fnew(result, gBoxedFreeGtkTreePath)
  result.impl = gtk_tree_path_copy(cast[ptr TreePath00](self.impl))

proc gtk_tree_path_down(self: ptr TreePath00) {.
    importc, libprag.}

proc down*(self: TreePath) =
  gtk_tree_path_down(cast[ptr TreePath00](self.impl))

proc gtk_tree_path_new(): ptr TreePath00 {.
    importc, libprag.}

proc newTreePath*(): TreePath =
  fnew(result, gBoxedFreeGtkTreePath)
  result.impl = gtk_tree_path_new()

proc newTreePath*(tdesc: typedesc): tdesc =
  assert(result is TreePath)
  fnew(result, gBoxedFreeGtkTreePath)
  result.impl = gtk_tree_path_new()

proc initTreePath*[T](result: var T) {.deprecated.} =
  assert(result is TreePath)
  fnew(result, gBoxedFreeGtkTreePath)
  result.impl = gtk_tree_path_new()

proc gtk_tree_path_get_depth(self: ptr TreePath00): int32 {.
    importc, libprag.}

proc getDepth*(self: TreePath): int =
  int(gtk_tree_path_get_depth(cast[ptr TreePath00](self.impl)))

proc depth*(self: TreePath): int =
  int(gtk_tree_path_get_depth(cast[ptr TreePath00](self.impl)))

proc gtk_tree_path_get_indices_with_depth(self: ptr TreePath00; depth: var int32): ptr int32 {.
    importc, libprag.}

proc getIndices*(self: TreePath; depth: var int = cast[var int](nil)): seq[int32] =
  var depth_00: int32
  result = int32ArrayToSeq(gtk_tree_path_get_indices_with_depth(cast[ptr TreePath00](self.impl), depth_00), depth.int)
  if depth.addr != nil:
    depth = int(depth_00)

proc gtk_tree_path_is_ancestor(self: ptr TreePath00; descendant: ptr TreePath00): gboolean {.
    importc, libprag.}

proc isAncestor*(self: TreePath; descendant: TreePath): bool =
  toBool(gtk_tree_path_is_ancestor(cast[ptr TreePath00](self.impl), cast[ptr TreePath00](descendant.impl)))

proc gtk_tree_path_is_descendant(self: ptr TreePath00; ancestor: ptr TreePath00): gboolean {.
    importc, libprag.}

proc isDescendant*(self: TreePath; ancestor: TreePath): bool =
  toBool(gtk_tree_path_is_descendant(cast[ptr TreePath00](self.impl), cast[ptr TreePath00](ancestor.impl)))

proc gtk_tree_path_next(self: ptr TreePath00) {.
    importc, libprag.}

proc next*(self: TreePath) =
  gtk_tree_path_next(cast[ptr TreePath00](self.impl))

proc gtk_tree_path_prepend_index(self: ptr TreePath00; index: int32) {.
    importc, libprag.}

proc prependIndex*(self: TreePath; index: int) =
  gtk_tree_path_prepend_index(cast[ptr TreePath00](self.impl), int32(index))

proc gtk_tree_path_prev(self: ptr TreePath00): gboolean {.
    importc, libprag.}

proc prev*(self: TreePath): bool =
  toBool(gtk_tree_path_prev(cast[ptr TreePath00](self.impl)))

proc gtk_tree_path_to_string(self: ptr TreePath00): cstring {.
    importc, libprag.}

proc toString*(self: TreePath): string =
  let resul0 = gtk_tree_path_to_string(cast[ptr TreePath00](self.impl))
  result = $resul0
  cogfree(resul0)

proc gtk_tree_path_up(self: ptr TreePath00): gboolean {.
    importc, libprag.}

proc up*(self: TreePath): bool =
  toBool(gtk_tree_path_up(cast[ptr TreePath00](self.impl)))

type
  TreeModelSort* = ref object of gobject.Object
  TreeModelSort00* = object of gobject.Object00

proc gtk_tree_model_sort_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(TreeModelSort()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_tree_model_sort_clear_cache(self: ptr TreeModelSort00) {.
    importc, libprag.}

proc clearCache*(self: TreeModelSort) =
  gtk_tree_model_sort_clear_cache(cast[ptr TreeModelSort00](self.impl))

proc gtk_tree_model_sort_convert_child_iter_to_iter(self: ptr TreeModelSort00;
    sortIter: var TreeIter; childIter: TreeIter): gboolean {.
    importc, libprag.}

proc convertChildIterToIter*(self: TreeModelSort;
    sortIter: var TreeIter; childIter: TreeIter): bool =
  toBool(gtk_tree_model_sort_convert_child_iter_to_iter(cast[ptr TreeModelSort00](self.impl), sortIter, childIter))

proc gtk_tree_model_sort_convert_child_path_to_path(self: ptr TreeModelSort00;
    childPath: ptr TreePath00): ptr TreePath00 {.
    importc, libprag.}

proc convertChildPathToPath*(self: TreeModelSort;
    childPath: TreePath): TreePath =
  let impl0 = gtk_tree_model_sort_convert_child_path_to_path(cast[ptr TreeModelSort00](self.impl), cast[ptr TreePath00](childPath.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreeGtkTreePath)
  result.impl = impl0

proc gtk_tree_model_sort_convert_iter_to_child_iter(self: ptr TreeModelSort00;
    childIter: var TreeIter; sortedIter: TreeIter) {.
    importc, libprag.}

proc convertIterToChildIter*(self: TreeModelSort;
    childIter: var TreeIter; sortedIter: TreeIter) =
  gtk_tree_model_sort_convert_iter_to_child_iter(cast[ptr TreeModelSort00](self.impl), childIter, sortedIter)

proc gtk_tree_model_sort_convert_path_to_child_path(self: ptr TreeModelSort00;
    sortedPath: ptr TreePath00): ptr TreePath00 {.
    importc, libprag.}

proc convertPathToChildPath*(self: TreeModelSort;
    sortedPath: TreePath): TreePath =
  let impl0 = gtk_tree_model_sort_convert_path_to_child_path(cast[ptr TreeModelSort00](self.impl), cast[ptr TreePath00](sortedPath.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreeGtkTreePath)
  result.impl = impl0

proc gtk_tree_model_sort_iter_is_valid(self: ptr TreeModelSort00; iter: TreeIter): gboolean {.
    importc, libprag.}

proc iterIsValid*(self: TreeModelSort; iter: TreeIter): bool =
  toBool(gtk_tree_model_sort_iter_is_valid(cast[ptr TreeModelSort00](self.impl), iter))

proc gtk_tree_model_sort_reset_default_sort_func(self: ptr TreeModelSort00) {.
    importc, libprag.}

proc resetDefaultSortFunc*(self: TreeModelSort) =
  gtk_tree_model_sort_reset_default_sort_func(cast[ptr TreeModelSort00](self.impl))

type
  ListStore* = ref object of gobject.Object
  ListStore00* = object of gobject.Object00

proc gtk_list_store_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ListStore()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_list_store_newv(nColumns: int32; types: ptr GType): ptr ListStore00 {.
    importc, libprag.}

proc newListStore*(nColumns: int; types: ptr GType): ListStore =
  let gobj = gtk_list_store_newv(int32(nColumns), types)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newListStore*(tdesc: typedesc; nColumns: int; types: ptr GType): tdesc =
  assert(result is ListStore)
  let gobj = gtk_list_store_newv(int32(nColumns), types)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initListStore*[T](result: var T; nColumns: int; types: ptr GType) {.deprecated.} =
  assert(result is ListStore)
  let gobj = gtk_list_store_newv(int32(nColumns), types)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_list_store_append(self: ptr ListStore00; iter: var TreeIter) {.
    importc, libprag.}

proc append*(self: ListStore; iter: var TreeIter) =
  gtk_list_store_append(cast[ptr ListStore00](self.impl), iter)

proc append*(self: ListStore): TreeIter =
  gtk_list_store_append(cast[ptr ListStore00](self.impl), result)

proc gtk_list_store_clear(self: ptr ListStore00) {.
    importc, libprag.}

proc clear*(self: ListStore) =
  gtk_list_store_clear(cast[ptr ListStore00](self.impl))

proc gtk_list_store_insert(self: ptr ListStore00; iter: var TreeIter; position: int32) {.
    importc, libprag.}

proc insert*(self: ListStore; iter: var TreeIter; position: int) =
  gtk_list_store_insert(cast[ptr ListStore00](self.impl), iter, int32(position))

proc gtk_list_store_insert_after(self: ptr ListStore00; iter: var TreeIter;
    sibling: TreeIter) {.
    importc, libprag.}

proc insertAfter*(self: ListStore; iter: var TreeIter; sibling: TreeIter = cast[var TreeIter](nil)) =
  gtk_list_store_insert_after(cast[ptr ListStore00](self.impl), iter, sibling)

proc gtk_list_store_insert_before(self: ptr ListStore00; iter: var TreeIter;
    sibling: TreeIter) {.
    importc, libprag.}

proc insertBefore*(self: ListStore; iter: var TreeIter; sibling: TreeIter = cast[var TreeIter](nil)) =
  gtk_list_store_insert_before(cast[ptr ListStore00](self.impl), iter, sibling)

proc gtk_list_store_iter_is_valid(self: ptr ListStore00; iter: TreeIter): gboolean {.
    importc, libprag.}

proc iterIsValid*(self: ListStore; iter: TreeIter): bool =
  toBool(gtk_list_store_iter_is_valid(cast[ptr ListStore00](self.impl), iter))

proc gtk_list_store_move_after(self: ptr ListStore00; iter: TreeIter; position: TreeIter) {.
    importc, libprag.}

proc moveAfter*(self: ListStore; iter: TreeIter; position: TreeIter = cast[var TreeIter](nil)) =
  gtk_list_store_move_after(cast[ptr ListStore00](self.impl), iter, position)

proc gtk_list_store_move_before(self: ptr ListStore00; iter: TreeIter; position: TreeIter) {.
    importc, libprag.}

proc moveBefore*(self: ListStore; iter: TreeIter; position: TreeIter = cast[var TreeIter](nil)) =
  gtk_list_store_move_before(cast[ptr ListStore00](self.impl), iter, position)

proc gtk_list_store_prepend(self: ptr ListStore00; iter: var TreeIter) {.
    importc, libprag.}

proc prepend*(self: ListStore; iter: var TreeIter) =
  gtk_list_store_prepend(cast[ptr ListStore00](self.impl), iter)

proc prepend*(self: ListStore): TreeIter =
  gtk_list_store_prepend(cast[ptr ListStore00](self.impl), result)

proc gtk_list_store_remove(self: ptr ListStore00; iter: TreeIter): gboolean {.
    importc, libprag.}

proc remove*(self: ListStore; iter: TreeIter): bool =
  toBool(gtk_list_store_remove(cast[ptr ListStore00](self.impl), iter))

proc gtk_list_store_reorder(self: ptr ListStore00; newOrder: ptr int32) {.
    importc, libprag.}

proc reorder*(self: ListStore; newOrder: seq[int32]) =
  gtk_list_store_reorder(cast[ptr ListStore00](self.impl), cast[ptr int32](unsafeaddr(newOrder[0])))

proc gtk_list_store_set_column_types(self: ptr ListStore00; nColumns: int32;
    types: ptr GType) {.
    importc, libprag.}

proc setColumnTypes*(self: ListStore; nColumns: int; types: ptr GType) =
  gtk_list_store_set_column_types(cast[ptr ListStore00](self.impl), int32(nColumns), types)

proc gtk_list_store_set_value(self: ptr ListStore00; iter: TreeIter; column: int32;
    value: gobject.Value) {.
    importc, libprag.}

proc setValue*(self: ListStore; iter: TreeIter; column: int;
    value: gobject.Value) =
  gtk_list_store_set_value(cast[ptr ListStore00](self.impl), iter, int32(column), value)

proc gtk_list_store_swap(self: ptr ListStore00; a: TreeIter; b: TreeIter) {.
    importc, libprag.}

proc swap*(self: ListStore; a: TreeIter; b: TreeIter) =
  gtk_list_store_swap(cast[ptr ListStore00](self.impl), a, b)

type
  TreeModelFilter* = ref object of gobject.Object
  TreeModelFilter00* = object of gobject.Object00

proc gtk_tree_model_filter_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(TreeModelFilter()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_tree_model_filter_clear_cache(self: ptr TreeModelFilter00) {.
    importc, libprag.}

proc clearCache*(self: TreeModelFilter) =
  gtk_tree_model_filter_clear_cache(cast[ptr TreeModelFilter00](self.impl))

proc gtk_tree_model_filter_convert_child_iter_to_iter(self: ptr TreeModelFilter00;
    filterIter: var TreeIter; childIter: TreeIter): gboolean {.
    importc, libprag.}

proc convertChildIterToIter*(self: TreeModelFilter;
    filterIter: var TreeIter; childIter: TreeIter): bool =
  toBool(gtk_tree_model_filter_convert_child_iter_to_iter(cast[ptr TreeModelFilter00](self.impl), filterIter, childIter))

proc gtk_tree_model_filter_convert_child_path_to_path(self: ptr TreeModelFilter00;
    childPath: ptr TreePath00): ptr TreePath00 {.
    importc, libprag.}

proc convertChildPathToPath*(self: TreeModelFilter;
    childPath: TreePath): TreePath =
  let impl0 = gtk_tree_model_filter_convert_child_path_to_path(cast[ptr TreeModelFilter00](self.impl), cast[ptr TreePath00](childPath.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreeGtkTreePath)
  result.impl = impl0

proc gtk_tree_model_filter_convert_iter_to_child_iter(self: ptr TreeModelFilter00;
    childIter: var TreeIter; filterIter: TreeIter) {.
    importc, libprag.}

proc convertIterToChildIter*(self: TreeModelFilter;
    childIter: var TreeIter; filterIter: TreeIter) =
  gtk_tree_model_filter_convert_iter_to_child_iter(cast[ptr TreeModelFilter00](self.impl), childIter, filterIter)

proc gtk_tree_model_filter_convert_path_to_child_path(self: ptr TreeModelFilter00;
    filterPath: ptr TreePath00): ptr TreePath00 {.
    importc, libprag.}

proc convertPathToChildPath*(self: TreeModelFilter;
    filterPath: TreePath): TreePath =
  let impl0 = gtk_tree_model_filter_convert_path_to_child_path(cast[ptr TreeModelFilter00](self.impl), cast[ptr TreePath00](filterPath.impl))
  if impl0.isNil:
    return nil
  fnew(result, gBoxedFreeGtkTreePath)
  result.impl = impl0

proc gtk_tree_model_filter_refilter(self: ptr TreeModelFilter00) {.
    importc, libprag.}

proc refilter*(self: TreeModelFilter) =
  gtk_tree_model_filter_refilter(cast[ptr TreeModelFilter00](self.impl))

proc gtk_tree_model_filter_set_visible_column(self: ptr TreeModelFilter00;
    column: int32) {.
    importc, libprag.}

proc setVisibleColumn*(self: TreeModelFilter; column: int) =
  gtk_tree_model_filter_set_visible_column(cast[ptr TreeModelFilter00](self.impl), int32(column))

proc `visibleColumn=`*(self: TreeModelFilter; column: int) =
  gtk_tree_model_filter_set_visible_column(cast[ptr TreeModelFilter00](self.impl), int32(column))

type
  TreeStore* = ref object of gobject.Object
  TreeStore00* = object of gobject.Object00

proc gtk_tree_store_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(TreeStore()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_tree_store_newv(nColumns: int32; types: ptr GType): ptr TreeStore00 {.
    importc, libprag.}

proc newTreeStore*(nColumns: int; types: ptr GType): TreeStore =
  let gobj = gtk_tree_store_newv(int32(nColumns), types)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newTreeStore*(tdesc: typedesc; nColumns: int; types: ptr GType): tdesc =
  assert(result is TreeStore)
  let gobj = gtk_tree_store_newv(int32(nColumns), types)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initTreeStore*[T](result: var T; nColumns: int; types: ptr GType) {.deprecated.} =
  assert(result is TreeStore)
  let gobj = gtk_tree_store_newv(int32(nColumns), types)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_tree_store_append(self: ptr TreeStore00; iter: var TreeIter; parent: TreeIter) {.
    importc, libprag.}

proc append*(self: TreeStore; iter: var TreeIter; parent: TreeIter = cast[var TreeIter](nil)) =
  gtk_tree_store_append(cast[ptr TreeStore00](self.impl), iter, parent)

proc gtk_tree_store_clear(self: ptr TreeStore00) {.
    importc, libprag.}

proc clear*(self: TreeStore) =
  gtk_tree_store_clear(cast[ptr TreeStore00](self.impl))

proc gtk_tree_store_insert(self: ptr TreeStore00; iter: var TreeIter; parent: TreeIter;
    position: int32) {.
    importc, libprag.}

proc insert*(self: TreeStore; iter: var TreeIter; parent: TreeIter = cast[var TreeIter](nil);
    position: int) =
  gtk_tree_store_insert(cast[ptr TreeStore00](self.impl), iter, parent, int32(position))

proc gtk_tree_store_insert_after(self: ptr TreeStore00; iter: var TreeIter;
    parent: TreeIter; sibling: TreeIter) {.
    importc, libprag.}

proc insertAfter*(self: TreeStore; iter: var TreeIter; parent: TreeIter = cast[var TreeIter](nil);
    sibling: TreeIter = cast[var TreeIter](nil)) =
  gtk_tree_store_insert_after(cast[ptr TreeStore00](self.impl), iter, parent, sibling)

proc gtk_tree_store_insert_before(self: ptr TreeStore00; iter: var TreeIter;
    parent: TreeIter; sibling: TreeIter) {.
    importc, libprag.}

proc insertBefore*(self: TreeStore; iter: var TreeIter; parent: TreeIter = cast[var TreeIter](nil);
    sibling: TreeIter = cast[var TreeIter](nil)) =
  gtk_tree_store_insert_before(cast[ptr TreeStore00](self.impl), iter, parent, sibling)

proc gtk_tree_store_is_ancestor(self: ptr TreeStore00; iter: TreeIter; descendant: TreeIter): gboolean {.
    importc, libprag.}

proc isAncestor*(self: TreeStore; iter: TreeIter; descendant: TreeIter): bool =
  toBool(gtk_tree_store_is_ancestor(cast[ptr TreeStore00](self.impl), iter, descendant))

proc gtk_tree_store_iter_depth(self: ptr TreeStore00; iter: TreeIter): int32 {.
    importc, libprag.}

proc iterDepth*(self: TreeStore; iter: TreeIter): int =
  int(gtk_tree_store_iter_depth(cast[ptr TreeStore00](self.impl), iter))

proc gtk_tree_store_iter_is_valid(self: ptr TreeStore00; iter: TreeIter): gboolean {.
    importc, libprag.}

proc iterIsValid*(self: TreeStore; iter: TreeIter): bool =
  toBool(gtk_tree_store_iter_is_valid(cast[ptr TreeStore00](self.impl), iter))

proc gtk_tree_store_move_after(self: ptr TreeStore00; iter: TreeIter; position: TreeIter) {.
    importc, libprag.}

proc moveAfter*(self: TreeStore; iter: TreeIter; position: TreeIter = cast[var TreeIter](nil)) =
  gtk_tree_store_move_after(cast[ptr TreeStore00](self.impl), iter, position)

proc gtk_tree_store_move_before(self: ptr TreeStore00; iter: TreeIter; position: TreeIter) {.
    importc, libprag.}

proc moveBefore*(self: TreeStore; iter: TreeIter; position: TreeIter = cast[var TreeIter](nil)) =
  gtk_tree_store_move_before(cast[ptr TreeStore00](self.impl), iter, position)

proc gtk_tree_store_prepend(self: ptr TreeStore00; iter: var TreeIter; parent: TreeIter) {.
    importc, libprag.}

proc prepend*(self: TreeStore; iter: var TreeIter; parent: TreeIter = cast[var TreeIter](nil)) =
  gtk_tree_store_prepend(cast[ptr TreeStore00](self.impl), iter, parent)

proc gtk_tree_store_remove(self: ptr TreeStore00; iter: TreeIter): gboolean {.
    importc, libprag.}

proc remove*(self: TreeStore; iter: TreeIter): bool =
  toBool(gtk_tree_store_remove(cast[ptr TreeStore00](self.impl), iter))

proc gtk_tree_store_set_column_types(self: ptr TreeStore00; nColumns: int32;
    types: ptr GType) {.
    importc, libprag.}

proc setColumnTypes*(self: TreeStore; nColumns: int; types: ptr GType) =
  gtk_tree_store_set_column_types(cast[ptr TreeStore00](self.impl), int32(nColumns), types)

proc gtk_tree_store_set_value(self: ptr TreeStore00; iter: TreeIter; column: int32;
    value: gobject.Value) {.
    importc, libprag.}

proc setValue*(self: TreeStore; iter: TreeIter; column: int;
    value: gobject.Value) =
  gtk_tree_store_set_value(cast[ptr TreeStore00](self.impl), iter, int32(column), value)

proc gtk_tree_store_swap(self: ptr TreeStore00; a: TreeIter; b: TreeIter) {.
    importc, libprag.}

proc swap*(self: TreeStore; a: TreeIter; b: TreeIter) =
  gtk_tree_store_swap(cast[ptr TreeStore00](self.impl), a, b)

type
  TreeModel00* = object of gobject.Object00
  TreeModel* = ref object of gobject.Object

proc scRowChanged*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;  p: proc (self: ptr TreeModel00; path: ptr TreePath00; iter: TreeIter; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "row-changed", cast[GCallback](p), xdata, nil, cf)

proc scRowDeleted*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;  p: proc (self: ptr TreeModel00; path: ptr TreePath00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "row-deleted", cast[GCallback](p), xdata, nil, cf)

proc scRowHasChildToggled*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;  p: proc (self: ptr TreeModel00; path: ptr TreePath00; iter: TreeIter; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "row-has-child-toggled", cast[GCallback](p), xdata, nil, cf)

proc scRowInserted*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;  p: proc (self: ptr TreeModel00; path: ptr TreePath00; iter: TreeIter; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "row-inserted", cast[GCallback](p), xdata, nil, cf)

proc gtk_tree_model_filter_new(self: ptr TreeModel00; root: ptr TreePath00): ptr TreeModel00 {.
    importc, libprag.}

proc filterNew*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    root: TreePath = nil): TreeModel =
  let gobj = gtk_tree_model_filter_new(cast[ptr TreeModel00](self.impl), if root.isNil: nil else: cast[ptr TreePath00](root.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_tree_model_get_column_type(self: ptr TreeModel00; index: int32): GType {.
    importc, libprag.}

proc getColumnType*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    index: int): GType =
  gtk_tree_model_get_column_type(cast[ptr TreeModel00](self.impl), int32(index))

proc gtk_tree_model_get_iter(self: ptr TreeModel00; iter: var TreeIter; path: ptr TreePath00): gboolean {.
    importc, libprag.}

proc getIter*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    iter: var TreeIter; path: TreePath): bool =
  toBool(gtk_tree_model_get_iter(cast[ptr TreeModel00](self.impl), iter, cast[ptr TreePath00](path.impl)))

proc gtk_tree_model_get_iter_first(self: ptr TreeModel00; iter: var TreeIter): gboolean {.
    importc, libprag.}

proc getIterFirst*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    iter: var TreeIter): bool =
  toBool(gtk_tree_model_get_iter_first(cast[ptr TreeModel00](self.impl), iter))

proc gtk_tree_model_get_iter_from_string(self: ptr TreeModel00; iter: var TreeIter;
    pathString: cstring): gboolean {.
    importc, libprag.}

proc getIterFromString*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    iter: var TreeIter; pathString: cstring): bool =
  toBool(gtk_tree_model_get_iter_from_string(cast[ptr TreeModel00](self.impl), iter, pathString))

proc gtk_tree_model_get_n_columns(self: ptr TreeModel00): int32 {.
    importc, libprag.}

proc getNColumns*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore): int =
  int(gtk_tree_model_get_n_columns(cast[ptr TreeModel00](self.impl)))

proc nColumns*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore): int =
  int(gtk_tree_model_get_n_columns(cast[ptr TreeModel00](self.impl)))

proc gtk_tree_model_get_path(self: ptr TreeModel00; iter: TreeIter): ptr TreePath00 {.
    importc, libprag.}

proc getPath*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    iter: TreeIter): TreePath =
  fnew(result, gBoxedFreeGtkTreePath)
  result.impl = gtk_tree_model_get_path(cast[ptr TreeModel00](self.impl), iter)

proc gtk_tree_model_get_string_from_iter(self: ptr TreeModel00; iter: TreeIter): cstring {.
    importc, libprag.}

proc getStringFromIter*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    iter: TreeIter): string =
  let resul0 = gtk_tree_model_get_string_from_iter(cast[ptr TreeModel00](self.impl), iter)
  result = $resul0
  cogfree(resul0)

proc gtk_tree_model_get_value(self: ptr TreeModel00; iter: TreeIter; column: int32;
    value: var gobject.Value) {.
    importc, libprag.}

proc getValue*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    iter: TreeIter; column: int; value: var gobject.Value) =
  gtk_tree_model_get_value(cast[ptr TreeModel00](self.impl), iter, int32(column), value)

proc gtk_tree_model_iter_children(self: ptr TreeModel00; iter: var TreeIter;
    parent: TreeIter): gboolean {.
    importc, libprag.}

proc iterChildren*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    iter: var TreeIter; parent: TreeIter = cast[var TreeIter](nil)): bool =
  toBool(gtk_tree_model_iter_children(cast[ptr TreeModel00](self.impl), iter, parent))

proc gtk_tree_model_iter_has_child(self: ptr TreeModel00; iter: TreeIter): gboolean {.
    importc, libprag.}

proc iterHasChild*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    iter: TreeIter): bool =
  toBool(gtk_tree_model_iter_has_child(cast[ptr TreeModel00](self.impl), iter))

proc gtk_tree_model_iter_n_children(self: ptr TreeModel00; iter: TreeIter): int32 {.
    importc, libprag.}

proc iterNChildren*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    iter: TreeIter = cast[var TreeIter](nil)): int =
  int(gtk_tree_model_iter_n_children(cast[ptr TreeModel00](self.impl), iter))

proc gtk_tree_model_iter_next(self: ptr TreeModel00; iter: TreeIter): gboolean {.
    importc, libprag.}

proc iterNext*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    iter: TreeIter): bool =
  toBool(gtk_tree_model_iter_next(cast[ptr TreeModel00](self.impl), iter))

proc gtk_tree_model_iter_nth_child(self: ptr TreeModel00; iter: var TreeIter;
    parent: TreeIter; n: int32): gboolean {.
    importc, libprag.}

proc iterNthChild*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    iter: var TreeIter; parent: TreeIter = cast[var TreeIter](nil); n: int): bool =
  toBool(gtk_tree_model_iter_nth_child(cast[ptr TreeModel00](self.impl), iter, parent, int32(n)))

proc gtk_tree_model_iter_parent(self: ptr TreeModel00; iter: var TreeIter;
    child: TreeIter): gboolean {.
    importc, libprag.}

proc iterParent*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    iter: var TreeIter; child: TreeIter): bool =
  toBool(gtk_tree_model_iter_parent(cast[ptr TreeModel00](self.impl), iter, child))

proc gtk_tree_model_iter_previous(self: ptr TreeModel00; iter: TreeIter): gboolean {.
    importc, libprag.}

proc iterPrevious*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    iter: TreeIter): bool =
  toBool(gtk_tree_model_iter_previous(cast[ptr TreeModel00](self.impl), iter))

proc gtk_tree_model_ref_node(self: ptr TreeModel00; iter: TreeIter) {.
    importc, libprag.}

proc refNode*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    iter: TreeIter) =
  gtk_tree_model_ref_node(cast[ptr TreeModel00](self.impl), iter)

proc gtk_tree_model_row_changed(self: ptr TreeModel00; path: ptr TreePath00;
    iter: TreeIter) {.
    importc, libprag.}

proc rowChanged*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    path: TreePath; iter: TreeIter) =
  gtk_tree_model_row_changed(cast[ptr TreeModel00](self.impl), cast[ptr TreePath00](path.impl), iter)

proc gtk_tree_model_row_deleted(self: ptr TreeModel00; path: ptr TreePath00) {.
    importc, libprag.}

proc rowDeleted*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    path: TreePath) =
  gtk_tree_model_row_deleted(cast[ptr TreeModel00](self.impl), cast[ptr TreePath00](path.impl))

proc gtk_tree_model_row_has_child_toggled(self: ptr TreeModel00; path: ptr TreePath00;
    iter: TreeIter) {.
    importc, libprag.}

proc rowHasChildToggled*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    path: TreePath; iter: TreeIter) =
  gtk_tree_model_row_has_child_toggled(cast[ptr TreeModel00](self.impl), cast[ptr TreePath00](path.impl), iter)

proc gtk_tree_model_row_inserted(self: ptr TreeModel00; path: ptr TreePath00;
    iter: TreeIter) {.
    importc, libprag.}

proc rowInserted*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    path: TreePath; iter: TreeIter) =
  gtk_tree_model_row_inserted(cast[ptr TreeModel00](self.impl), cast[ptr TreePath00](path.impl), iter)

proc gtk_tree_model_rows_reordered_with_length(self: ptr TreeModel00; path: ptr TreePath00;
    iter: TreeIter; newOrder: ptr int32; length: int32) {.
    importc, libprag.}

proc rowsReordered*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    path: TreePath; iter: TreeIter = cast[var TreeIter](nil); newOrder: seq[int32]) =
  let length = int(newOrder.len)
  gtk_tree_model_rows_reordered_with_length(cast[ptr TreeModel00](self.impl), cast[ptr TreePath00](path.impl), iter, cast[ptr int32](unsafeaddr(newOrder[0])), int32(length))

proc gtk_tree_model_unref_node(self: ptr TreeModel00; iter: TreeIter) {.
    importc, libprag.}

proc unrefNode*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    iter: TreeIter) =
  gtk_tree_model_unref_node(cast[ptr TreeModel00](self.impl), iter)

type
  CellArea* = ref object of gobject.InitiallyUnowned
  CellArea00* = object of gobject.InitiallyUnowned00

proc gtk_cell_area_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(CellArea()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scAddEditable*(self: CellArea;  p: proc (self: ptr CellArea00; renderer: ptr CellRenderer00; editable: ptr CellEditable00; cellArea: gdk.Rectangle;
    path: cstring; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "add-editable", cast[GCallback](p), xdata, nil, cf)

proc scApplyAttributes*(self: CellArea;  p: proc (self: ptr CellArea00; model: ptr TreeModel00; iter: TreeIter; isExpander: gboolean; isExpanded: gboolean; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "apply-attributes", cast[GCallback](p), xdata, nil, cf)

proc scFocusChanged*(self: CellArea;  p: proc (self: ptr CellArea00; renderer: ptr CellRenderer00; path: cstring; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "focus-changed", cast[GCallback](p), xdata, nil, cf)

proc scRemoveEditable*(self: CellArea;  p: proc (self: ptr CellArea00; renderer: ptr CellRenderer00; editable: ptr CellEditable00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "remove-editable", cast[GCallback](p), xdata, nil, cf)

proc gtk_cell_area_activate_cell(self: ptr CellArea00; widget: ptr Widget00;
    renderer: ptr CellRenderer00; event: ptr gdk.Event00; cellArea: gdk.Rectangle;
    flags: CellRendererState): gboolean {.
    importc, libprag.}

proc activateCell*(self: CellArea; widget: Widget; renderer: CellRenderer;
    event: gdk.Event; cellArea: gdk.Rectangle; flags: CellRendererState): bool =
  toBool(gtk_cell_area_activate_cell(cast[ptr CellArea00](self.impl), cast[ptr Widget00](widget.impl), cast[ptr CellRenderer00](renderer.impl), cast[ptr gdk.Event00](event.impl), cellArea, flags))

proc gtk_cell_area_add(self: ptr CellArea00; renderer: ptr CellRenderer00) {.
    importc, libprag.}

proc add*(self: CellArea; renderer: CellRenderer) =
  gtk_cell_area_add(cast[ptr CellArea00](self.impl), cast[ptr CellRenderer00](renderer.impl))

proc gtk_cell_area_add_focus_sibling(self: ptr CellArea00; renderer: ptr CellRenderer00;
    sibling: ptr CellRenderer00) {.
    importc, libprag.}

proc addFocusSibling*(self: CellArea; renderer: CellRenderer;
    sibling: CellRenderer) =
  gtk_cell_area_add_focus_sibling(cast[ptr CellArea00](self.impl), cast[ptr CellRenderer00](renderer.impl), cast[ptr CellRenderer00](sibling.impl))

proc gtk_cell_area_apply_attributes(self: ptr CellArea00; treeModel: ptr TreeModel00;
    iter: TreeIter; isExpander: gboolean; isExpanded: gboolean) {.
    importc, libprag.}

proc applyAttributes*(self: CellArea; treeModel: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore;
    iter: TreeIter; isExpander: bool; isExpanded: bool) =
  gtk_cell_area_apply_attributes(cast[ptr CellArea00](self.impl), cast[ptr TreeModel00](treeModel.impl), iter, gboolean(isExpander), gboolean(isExpanded))

proc gtk_cell_area_attribute_connect(self: ptr CellArea00; renderer: ptr CellRenderer00;
    attribute: cstring; column: int32) {.
    importc, libprag.}

proc attributeConnect*(self: CellArea; renderer: CellRenderer;
    attribute: cstring; column: int) =
  gtk_cell_area_attribute_connect(cast[ptr CellArea00](self.impl), cast[ptr CellRenderer00](renderer.impl), attribute, int32(column))

proc gtk_cell_area_attribute_disconnect(self: ptr CellArea00; renderer: ptr CellRenderer00;
    attribute: cstring) {.
    importc, libprag.}

proc attributeDisconnect*(self: CellArea; renderer: CellRenderer;
    attribute: cstring) =
  gtk_cell_area_attribute_disconnect(cast[ptr CellArea00](self.impl), cast[ptr CellRenderer00](renderer.impl), attribute)

proc gtk_cell_area_attribute_get_column(self: ptr CellArea00; renderer: ptr CellRenderer00;
    attribute: cstring): int32 {.
    importc, libprag.}

proc attributeGetColumn*(self: CellArea; renderer: CellRenderer;
    attribute: cstring): int =
  int(gtk_cell_area_attribute_get_column(cast[ptr CellArea00](self.impl), cast[ptr CellRenderer00](renderer.impl), attribute))

proc gtk_cell_area_cell_get_property(self: ptr CellArea00; renderer: ptr CellRenderer00;
    propertyName: cstring; value: gobject.Value) {.
    importc, libprag.}

proc cellGetProperty*(self: CellArea; renderer: CellRenderer;
    propertyName: cstring; value: gobject.Value) =
  gtk_cell_area_cell_get_property(cast[ptr CellArea00](self.impl), cast[ptr CellRenderer00](renderer.impl), propertyName, value)

proc gtk_cell_area_cell_set_property(self: ptr CellArea00; renderer: ptr CellRenderer00;
    propertyName: cstring; value: gobject.Value) {.
    importc, libprag.}

proc cellSetProperty*(self: CellArea; renderer: CellRenderer;
    propertyName: cstring; value: gobject.Value) =
  gtk_cell_area_cell_set_property(cast[ptr CellArea00](self.impl), cast[ptr CellRenderer00](renderer.impl), propertyName, value)

proc gtk_cell_area_focus(self: ptr CellArea00; direction: DirectionType): gboolean {.
    importc, libprag.}

proc focus*(self: CellArea; direction: DirectionType): bool =
  toBool(gtk_cell_area_focus(cast[ptr CellArea00](self.impl), direction))

proc gtk_cell_area_get_current_path_string(self: ptr CellArea00): cstring {.
    importc, libprag.}

proc getCurrentPathString*(self: CellArea): string =
  result = $gtk_cell_area_get_current_path_string(cast[ptr CellArea00](self.impl))

proc currentPathString*(self: CellArea): string =
  result = $gtk_cell_area_get_current_path_string(cast[ptr CellArea00](self.impl))

proc gtk_cell_area_get_edit_widget(self: ptr CellArea00): ptr CellEditable00 {.
    importc, libprag.}

proc getEditWidget*(self: CellArea): CellEditable =
  let gobj = gtk_cell_area_get_edit_widget(cast[ptr CellArea00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc editWidget*(self: CellArea): CellEditable =
  let gobj = gtk_cell_area_get_edit_widget(cast[ptr CellArea00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_cell_area_get_edited_cell(self: ptr CellArea00): ptr CellRenderer00 {.
    importc, libprag.}

proc getEditedCell*(self: CellArea): CellRenderer =
  let gobj = gtk_cell_area_get_edited_cell(cast[ptr CellArea00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc editedCell*(self: CellArea): CellRenderer =
  let gobj = gtk_cell_area_get_edited_cell(cast[ptr CellArea00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_cell_area_get_focus_cell(self: ptr CellArea00): ptr CellRenderer00 {.
    importc, libprag.}

proc getFocusCell*(self: CellArea): CellRenderer =
  let gobj = gtk_cell_area_get_focus_cell(cast[ptr CellArea00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc focusCell*(self: CellArea): CellRenderer =
  let gobj = gtk_cell_area_get_focus_cell(cast[ptr CellArea00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_cell_area_get_focus_from_sibling(self: ptr CellArea00; renderer: ptr CellRenderer00): ptr CellRenderer00 {.
    importc, libprag.}

proc getFocusFromSibling*(self: CellArea; renderer: CellRenderer): CellRenderer =
  let gobj = gtk_cell_area_get_focus_from_sibling(cast[ptr CellArea00](self.impl), cast[ptr CellRenderer00](renderer.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_cell_area_get_focus_siblings(self: ptr CellArea00; renderer: ptr CellRenderer00): ptr glib.List {.
    importc, libprag.}

proc getFocusSiblings*(self: CellArea; renderer: CellRenderer): seq[CellRenderer] =
  result = glistObjects2seq(CellRenderer, gtk_cell_area_get_focus_siblings(cast[ptr CellArea00](self.impl), cast[ptr CellRenderer00](renderer.impl)), false)

proc gtk_cell_area_get_request_mode(self: ptr CellArea00): SizeRequestMode {.
    importc, libprag.}

proc getRequestMode*(self: CellArea): SizeRequestMode =
  gtk_cell_area_get_request_mode(cast[ptr CellArea00](self.impl))

proc requestMode*(self: CellArea): SizeRequestMode =
  gtk_cell_area_get_request_mode(cast[ptr CellArea00](self.impl))

proc gtk_cell_area_has_renderer(self: ptr CellArea00; renderer: ptr CellRenderer00): gboolean {.
    importc, libprag.}

proc hasRenderer*(self: CellArea; renderer: CellRenderer): bool =
  toBool(gtk_cell_area_has_renderer(cast[ptr CellArea00](self.impl), cast[ptr CellRenderer00](renderer.impl)))

proc gtk_cell_area_inner_cell_area(self: ptr CellArea00; widget: ptr Widget00;
    cellArea: gdk.Rectangle; innerArea: var gdk.Rectangle) {.
    importc, libprag.}

proc innerCellArea*(self: CellArea; widget: Widget; cellArea: gdk.Rectangle;
    innerArea: var gdk.Rectangle) =
  gtk_cell_area_inner_cell_area(cast[ptr CellArea00](self.impl), cast[ptr Widget00](widget.impl), cellArea, innerArea)

proc gtk_cell_area_is_activatable(self: ptr CellArea00): gboolean {.
    importc, libprag.}

proc isActivatable*(self: CellArea): bool =
  toBool(gtk_cell_area_is_activatable(cast[ptr CellArea00](self.impl)))

proc gtk_cell_area_is_focus_sibling(self: ptr CellArea00; renderer: ptr CellRenderer00;
    sibling: ptr CellRenderer00): gboolean {.
    importc, libprag.}

proc isFocusSibling*(self: CellArea; renderer: CellRenderer;
    sibling: CellRenderer): bool =
  toBool(gtk_cell_area_is_focus_sibling(cast[ptr CellArea00](self.impl), cast[ptr CellRenderer00](renderer.impl), cast[ptr CellRenderer00](sibling.impl)))

proc gtk_cell_area_remove(self: ptr CellArea00; renderer: ptr CellRenderer00) {.
    importc, libprag.}

proc remove*(self: CellArea; renderer: CellRenderer) =
  gtk_cell_area_remove(cast[ptr CellArea00](self.impl), cast[ptr CellRenderer00](renderer.impl))

proc gtk_cell_area_remove_focus_sibling(self: ptr CellArea00; renderer: ptr CellRenderer00;
    sibling: ptr CellRenderer00) {.
    importc, libprag.}

proc removeFocusSibling*(self: CellArea; renderer: CellRenderer;
    sibling: CellRenderer) =
  gtk_cell_area_remove_focus_sibling(cast[ptr CellArea00](self.impl), cast[ptr CellRenderer00](renderer.impl), cast[ptr CellRenderer00](sibling.impl))

proc gtk_cell_area_request_renderer(self: ptr CellArea00; renderer: ptr CellRenderer00;
    orientation: Orientation; widget: ptr Widget00; forSize: int32; minimumSize: var int32;
    naturalSize: var int32) {.
    importc, libprag.}

proc requestRenderer*(self: CellArea; renderer: CellRenderer;
    orientation: Orientation; widget: Widget; forSize: int; minimumSize: var int = cast[var int](nil);
    naturalSize: var int = cast[var int](nil)) =
  var minimumSize_00: int32
  var naturalSize_00: int32
  gtk_cell_area_request_renderer(cast[ptr CellArea00](self.impl), cast[ptr CellRenderer00](renderer.impl), orientation, cast[ptr Widget00](widget.impl), int32(forSize), minimumSize_00, naturalSize_00)
  if minimumSize.addr != nil:
    minimumSize = int(minimumSize_00)
  if naturalSize.addr != nil:
    naturalSize = int(naturalSize_00)

proc gtk_cell_area_set_focus_cell(self: ptr CellArea00; renderer: ptr CellRenderer00) {.
    importc, libprag.}

proc setFocusCell*(self: CellArea; renderer: CellRenderer) =
  gtk_cell_area_set_focus_cell(cast[ptr CellArea00](self.impl), cast[ptr CellRenderer00](renderer.impl))

proc `focusCell=`*(self: CellArea; renderer: CellRenderer) =
  gtk_cell_area_set_focus_cell(cast[ptr CellArea00](self.impl), cast[ptr CellRenderer00](renderer.impl))

proc gtk_cell_area_stop_editing(self: ptr CellArea00; canceled: gboolean) {.
    importc, libprag.}

proc stopEditing*(self: CellArea; canceled: bool) =
  gtk_cell_area_stop_editing(cast[ptr CellArea00](self.impl), gboolean(canceled))

type
  EntryCompletion* = ref object of gobject.Object
  EntryCompletion00* = object of gobject.Object00

proc gtk_entry_completion_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(EntryCompletion()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scActionActivated*(self: EntryCompletion;  p: proc (self: ptr EntryCompletion00; index: int32; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "action-activated", cast[GCallback](p), xdata, nil, cf)

proc scCursorOnMatch*(self: EntryCompletion;  p: proc (self: ptr EntryCompletion00; model: ptr TreeModel00; iter: TreeIter; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "cursor-on-match", cast[GCallback](p), xdata, nil, cf)

proc scInsertPrefix*(self: EntryCompletion;  p: proc (self: ptr EntryCompletion00; prefix: cstring; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "insert-prefix", cast[GCallback](p), xdata, nil, cf)

proc scMatchSelected*(self: EntryCompletion;  p: proc (self: ptr EntryCompletion00; model: ptr TreeModel00; iter: TreeIter; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "match-selected", cast[GCallback](p), xdata, nil, cf)

proc scNoMatches*(self: EntryCompletion;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "no-matches", cast[GCallback](p), xdata, nil, cf)

proc gtk_entry_completion_new(): ptr EntryCompletion00 {.
    importc, libprag.}

proc newEntryCompletion*(): EntryCompletion =
  let gobj = gtk_entry_completion_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newEntryCompletion*(tdesc: typedesc): tdesc =
  assert(result is EntryCompletion)
  let gobj = gtk_entry_completion_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initEntryCompletion*[T](result: var T) {.deprecated.} =
  assert(result is EntryCompletion)
  let gobj = gtk_entry_completion_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_entry_completion_new_with_area(area: ptr CellArea00): ptr EntryCompletion00 {.
    importc, libprag.}

proc newEntryCompletionWithArea*(area: CellArea): EntryCompletion =
  let gobj = gtk_entry_completion_new_with_area(cast[ptr CellArea00](area.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newEntryCompletionWithArea*(tdesc: typedesc; area: CellArea): tdesc =
  assert(result is EntryCompletion)
  let gobj = gtk_entry_completion_new_with_area(cast[ptr CellArea00](area.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initEntryCompletionWithArea*[T](result: var T; area: CellArea) {.deprecated.} =
  assert(result is EntryCompletion)
  let gobj = gtk_entry_completion_new_with_area(cast[ptr CellArea00](area.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_entry_completion_complete(self: ptr EntryCompletion00) {.
    importc, libprag.}

proc complete*(self: EntryCompletion) =
  gtk_entry_completion_complete(cast[ptr EntryCompletion00](self.impl))

proc gtk_entry_completion_compute_prefix(self: ptr EntryCompletion00; key: cstring): cstring {.
    importc, libprag.}

proc computePrefix*(self: EntryCompletion; key: cstring): string =
  let resul0 = gtk_entry_completion_compute_prefix(cast[ptr EntryCompletion00](self.impl), key)
  if resul0.isNil:
    return
  result = $resul0
  cogfree(resul0)

proc gtk_entry_completion_delete_action(self: ptr EntryCompletion00; index: int32) {.
    importc, libprag.}

proc deleteAction*(self: EntryCompletion; index: int) =
  gtk_entry_completion_delete_action(cast[ptr EntryCompletion00](self.impl), int32(index))

proc gtk_entry_completion_get_completion_prefix(self: ptr EntryCompletion00): cstring {.
    importc, libprag.}

proc getCompletionPrefix*(self: EntryCompletion): string =
  result = $gtk_entry_completion_get_completion_prefix(cast[ptr EntryCompletion00](self.impl))

proc completionPrefix*(self: EntryCompletion): string =
  result = $gtk_entry_completion_get_completion_prefix(cast[ptr EntryCompletion00](self.impl))

proc gtk_entry_completion_get_entry(self: ptr EntryCompletion00): ptr Widget00 {.
    importc, libprag.}

proc getEntry*(self: EntryCompletion): Widget =
  let gobj = gtk_entry_completion_get_entry(cast[ptr EntryCompletion00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc entry*(self: EntryCompletion): Widget =
  let gobj = gtk_entry_completion_get_entry(cast[ptr EntryCompletion00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_entry_completion_get_inline_completion(self: ptr EntryCompletion00): gboolean {.
    importc, libprag.}

proc getInlineCompletion*(self: EntryCompletion): bool =
  toBool(gtk_entry_completion_get_inline_completion(cast[ptr EntryCompletion00](self.impl)))

proc inlineCompletion*(self: EntryCompletion): bool =
  toBool(gtk_entry_completion_get_inline_completion(cast[ptr EntryCompletion00](self.impl)))

proc gtk_entry_completion_get_inline_selection(self: ptr EntryCompletion00): gboolean {.
    importc, libprag.}

proc getInlineSelection*(self: EntryCompletion): bool =
  toBool(gtk_entry_completion_get_inline_selection(cast[ptr EntryCompletion00](self.impl)))

proc inlineSelection*(self: EntryCompletion): bool =
  toBool(gtk_entry_completion_get_inline_selection(cast[ptr EntryCompletion00](self.impl)))

proc gtk_entry_completion_get_minimum_key_length(self: ptr EntryCompletion00): int32 {.
    importc, libprag.}

proc getMinimumKeyLength*(self: EntryCompletion): int =
  int(gtk_entry_completion_get_minimum_key_length(cast[ptr EntryCompletion00](self.impl)))

proc minimumKeyLength*(self: EntryCompletion): int =
  int(gtk_entry_completion_get_minimum_key_length(cast[ptr EntryCompletion00](self.impl)))

proc gtk_entry_completion_get_model(self: ptr EntryCompletion00): ptr TreeModel00 {.
    importc, libprag.}

proc getModel*(self: EntryCompletion): TreeModel =
  let gobj = gtk_entry_completion_get_model(cast[ptr EntryCompletion00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc model*(self: EntryCompletion): TreeModel =
  let gobj = gtk_entry_completion_get_model(cast[ptr EntryCompletion00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_entry_completion_get_popup_completion(self: ptr EntryCompletion00): gboolean {.
    importc, libprag.}

proc getPopupCompletion*(self: EntryCompletion): bool =
  toBool(gtk_entry_completion_get_popup_completion(cast[ptr EntryCompletion00](self.impl)))

proc popupCompletion*(self: EntryCompletion): bool =
  toBool(gtk_entry_completion_get_popup_completion(cast[ptr EntryCompletion00](self.impl)))

proc gtk_entry_completion_get_popup_set_width(self: ptr EntryCompletion00): gboolean {.
    importc, libprag.}

proc getPopupSetWidth*(self: EntryCompletion): bool =
  toBool(gtk_entry_completion_get_popup_set_width(cast[ptr EntryCompletion00](self.impl)))

proc popupSetWidth*(self: EntryCompletion): bool =
  toBool(gtk_entry_completion_get_popup_set_width(cast[ptr EntryCompletion00](self.impl)))

proc gtk_entry_completion_get_popup_single_match(self: ptr EntryCompletion00): gboolean {.
    importc, libprag.}

proc getPopupSingleMatch*(self: EntryCompletion): bool =
  toBool(gtk_entry_completion_get_popup_single_match(cast[ptr EntryCompletion00](self.impl)))

proc popupSingleMatch*(self: EntryCompletion): bool =
  toBool(gtk_entry_completion_get_popup_single_match(cast[ptr EntryCompletion00](self.impl)))

proc gtk_entry_completion_get_text_column(self: ptr EntryCompletion00): int32 {.
    importc, libprag.}

proc getTextColumn*(self: EntryCompletion): int =
  int(gtk_entry_completion_get_text_column(cast[ptr EntryCompletion00](self.impl)))

proc textColumn*(self: EntryCompletion): int =
  int(gtk_entry_completion_get_text_column(cast[ptr EntryCompletion00](self.impl)))

proc gtk_entry_completion_insert_action_markup(self: ptr EntryCompletion00;
    index: int32; markup: cstring) {.
    importc, libprag.}

proc insertActionMarkup*(self: EntryCompletion; index: int;
    markup: cstring) =
  gtk_entry_completion_insert_action_markup(cast[ptr EntryCompletion00](self.impl), int32(index), markup)

proc gtk_entry_completion_insert_action_text(self: ptr EntryCompletion00;
    index: int32; text: cstring) {.
    importc, libprag.}

proc insertActionText*(self: EntryCompletion; index: int;
    text: cstring) =
  gtk_entry_completion_insert_action_text(cast[ptr EntryCompletion00](self.impl), int32(index), text)

proc gtk_entry_completion_insert_prefix(self: ptr EntryCompletion00) {.
    importc, libprag.}

proc insertPrefix*(self: EntryCompletion) =
  gtk_entry_completion_insert_prefix(cast[ptr EntryCompletion00](self.impl))

proc gtk_entry_completion_set_inline_completion(self: ptr EntryCompletion00;
    inlineCompletion: gboolean) {.
    importc, libprag.}

proc setInlineCompletion*(self: EntryCompletion; inlineCompletion: bool = true) =
  gtk_entry_completion_set_inline_completion(cast[ptr EntryCompletion00](self.impl), gboolean(inlineCompletion))

proc `inlineCompletion=`*(self: EntryCompletion; inlineCompletion: bool) =
  gtk_entry_completion_set_inline_completion(cast[ptr EntryCompletion00](self.impl), gboolean(inlineCompletion))

proc gtk_entry_completion_set_inline_selection(self: ptr EntryCompletion00;
    inlineSelection: gboolean) {.
    importc, libprag.}

proc setInlineSelection*(self: EntryCompletion; inlineSelection: bool = true) =
  gtk_entry_completion_set_inline_selection(cast[ptr EntryCompletion00](self.impl), gboolean(inlineSelection))

proc `inlineSelection=`*(self: EntryCompletion; inlineSelection: bool) =
  gtk_entry_completion_set_inline_selection(cast[ptr EntryCompletion00](self.impl), gboolean(inlineSelection))

proc gtk_entry_completion_set_minimum_key_length(self: ptr EntryCompletion00;
    length: int32) {.
    importc, libprag.}

proc setMinimumKeyLength*(self: EntryCompletion; length: int) =
  gtk_entry_completion_set_minimum_key_length(cast[ptr EntryCompletion00](self.impl), int32(length))

proc `minimumKeyLength=`*(self: EntryCompletion; length: int) =
  gtk_entry_completion_set_minimum_key_length(cast[ptr EntryCompletion00](self.impl), int32(length))

proc gtk_entry_completion_set_model(self: ptr EntryCompletion00; model: ptr TreeModel00) {.
    importc, libprag.}

proc setModel*(self: EntryCompletion; model: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore = nil) =
  gtk_entry_completion_set_model(cast[ptr EntryCompletion00](self.impl), if model.isNil: nil else: cast[ptr TreeModel00](model.impl))

proc `model=`*(self: EntryCompletion; model: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore = nil) =
  gtk_entry_completion_set_model(cast[ptr EntryCompletion00](self.impl), if model.isNil: nil else: cast[ptr TreeModel00](model.impl))

proc gtk_entry_completion_set_popup_completion(self: ptr EntryCompletion00;
    popupCompletion: gboolean) {.
    importc, libprag.}

proc setPopupCompletion*(self: EntryCompletion; popupCompletion: bool = true) =
  gtk_entry_completion_set_popup_completion(cast[ptr EntryCompletion00](self.impl), gboolean(popupCompletion))

proc `popupCompletion=`*(self: EntryCompletion; popupCompletion: bool) =
  gtk_entry_completion_set_popup_completion(cast[ptr EntryCompletion00](self.impl), gboolean(popupCompletion))

proc gtk_entry_completion_set_popup_set_width(self: ptr EntryCompletion00;
    popupSetWidth: gboolean) {.
    importc, libprag.}

proc setPopupSetWidth*(self: EntryCompletion; popupSetWidth: bool = true) =
  gtk_entry_completion_set_popup_set_width(cast[ptr EntryCompletion00](self.impl), gboolean(popupSetWidth))

proc `popupSetWidth=`*(self: EntryCompletion; popupSetWidth: bool) =
  gtk_entry_completion_set_popup_set_width(cast[ptr EntryCompletion00](self.impl), gboolean(popupSetWidth))

proc gtk_entry_completion_set_popup_single_match(self: ptr EntryCompletion00;
    popupSingleMatch: gboolean) {.
    importc, libprag.}

proc setPopupSingleMatch*(self: EntryCompletion; popupSingleMatch: bool = true) =
  gtk_entry_completion_set_popup_single_match(cast[ptr EntryCompletion00](self.impl), gboolean(popupSingleMatch))

proc `popupSingleMatch=`*(self: EntryCompletion; popupSingleMatch: bool) =
  gtk_entry_completion_set_popup_single_match(cast[ptr EntryCompletion00](self.impl), gboolean(popupSingleMatch))

proc gtk_entry_completion_set_text_column(self: ptr EntryCompletion00; column: int32) {.
    importc, libprag.}

proc setTextColumn*(self: EntryCompletion; column: int) =
  gtk_entry_completion_set_text_column(cast[ptr EntryCompletion00](self.impl), int32(column))

proc `textColumn=`*(self: EntryCompletion; column: int) =
  gtk_entry_completion_set_text_column(cast[ptr EntryCompletion00](self.impl), int32(column))

proc gtk_combo_box_new_with_area(area: ptr CellArea00): ptr ComboBox00 {.
    importc, libprag.}

proc newComboBoxWithArea*(area: CellArea): ComboBox =
  let gobj = gtk_combo_box_new_with_area(cast[ptr CellArea00](area.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newComboBoxWithArea*(tdesc: typedesc; area: CellArea): tdesc =
  assert(result is ComboBox)
  let gobj = gtk_combo_box_new_with_area(cast[ptr CellArea00](area.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initComboBoxWithArea*[T](result: var T; area: CellArea) {.deprecated.} =
  assert(result is ComboBox)
  let gobj = gtk_combo_box_new_with_area(cast[ptr CellArea00](area.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_combo_box_new_with_area_and_entry(area: ptr CellArea00): ptr ComboBox00 {.
    importc, libprag.}

proc newComboBoxWithAreaAndEntry*(area: CellArea): ComboBox =
  let gobj = gtk_combo_box_new_with_area_and_entry(cast[ptr CellArea00](area.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newComboBoxWithAreaAndEntry*(tdesc: typedesc; area: CellArea): tdesc =
  assert(result is ComboBox)
  let gobj = gtk_combo_box_new_with_area_and_entry(cast[ptr CellArea00](area.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initComboBoxWithAreaAndEntry*[T](result: var T; area: CellArea) {.deprecated.} =
  assert(result is ComboBox)
  let gobj = gtk_combo_box_new_with_area_and_entry(cast[ptr CellArea00](area.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_combo_box_new_with_model(model: ptr TreeModel00): ptr ComboBox00 {.
    importc, libprag.}

proc newComboBoxWithModel*(model: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore): ComboBox =
  let gobj = gtk_combo_box_new_with_model(cast[ptr TreeModel00](model.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newComboBoxWithModel*(tdesc: typedesc; model: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore): tdesc =
  assert(result is ComboBox)
  let gobj = gtk_combo_box_new_with_model(cast[ptr TreeModel00](model.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initComboBoxWithModel*[T](result: var T; model: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore) {.deprecated.} =
  assert(result is ComboBox)
  let gobj = gtk_combo_box_new_with_model(cast[ptr TreeModel00](model.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_combo_box_new_with_model_and_entry(model: ptr TreeModel00): ptr ComboBox00 {.
    importc, libprag.}

proc newComboBoxWithModelAndEntry*(model: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore): ComboBox =
  let gobj = gtk_combo_box_new_with_model_and_entry(cast[ptr TreeModel00](model.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newComboBoxWithModelAndEntry*(tdesc: typedesc; model: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore): tdesc =
  assert(result is ComboBox)
  let gobj = gtk_combo_box_new_with_model_and_entry(cast[ptr TreeModel00](model.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initComboBoxWithModelAndEntry*[T](result: var T; model: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore) {.deprecated.} =
  assert(result is ComboBox)
  let gobj = gtk_combo_box_new_with_model_and_entry(cast[ptr TreeModel00](model.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_combo_box_get_model(self: ptr ComboBox00): ptr TreeModel00 {.
    importc, libprag.}

proc getModel*(self: ComboBox): TreeModel =
  let gobj = gtk_combo_box_get_model(cast[ptr ComboBox00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc model*(self: ComboBox): TreeModel =
  let gobj = gtk_combo_box_get_model(cast[ptr ComboBox00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_combo_box_set_model(self: ptr ComboBox00; model: ptr TreeModel00) {.
    importc, libprag.}

proc setModel*(self: ComboBox; model: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore = nil) =
  gtk_combo_box_set_model(cast[ptr ComboBox00](self.impl), if model.isNil: nil else: cast[ptr TreeModel00](model.impl))

proc `model=`*(self: ComboBox; model: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore = nil) =
  gtk_combo_box_set_model(cast[ptr ComboBox00](self.impl), if model.isNil: nil else: cast[ptr TreeModel00](model.impl))

proc gtk_entry_get_completion(self: ptr Entry00): ptr EntryCompletion00 {.
    importc, libprag.}

proc getCompletion*(self: Entry): EntryCompletion =
  let gobj = gtk_entry_get_completion(cast[ptr Entry00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc completion*(self: Entry): EntryCompletion =
  let gobj = gtk_entry_get_completion(cast[ptr Entry00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_entry_set_completion(self: ptr Entry00; completion: ptr EntryCompletion00) {.
    importc, libprag.}

proc setCompletion*(self: Entry; completion: EntryCompletion = nil) =
  gtk_entry_set_completion(cast[ptr Entry00](self.impl), if completion.isNil: nil else: cast[ptr EntryCompletion00](completion.impl))

proc `completion=`*(self: Entry; completion: EntryCompletion = nil) =
  gtk_entry_set_completion(cast[ptr Entry00](self.impl), if completion.isNil: nil else: cast[ptr EntryCompletion00](completion.impl))

proc gtk_tree_model_sort_new_with_model(childModel: ptr TreeModel00): ptr TreeModelSort00 {.
    importc, libprag.}

proc newTreeModelSortWithModel*(childModel: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore): TreeModelSort =
  let gobj = gtk_tree_model_sort_new_with_model(cast[ptr TreeModel00](childModel.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newTreeModelSortWithModel*(tdesc: typedesc; childModel: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore): tdesc =
  assert(result is TreeModelSort)
  let gobj = gtk_tree_model_sort_new_with_model(cast[ptr TreeModel00](childModel.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initTreeModelSortWithModel*[T](result: var T; childModel: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore) {.deprecated.} =
  assert(result is TreeModelSort)
  let gobj = gtk_tree_model_sort_new_with_model(cast[ptr TreeModel00](childModel.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_tree_model_sort_get_model(self: ptr TreeModelSort00): ptr TreeModel00 {.
    importc, libprag.}

proc getModel*(self: TreeModelSort): TreeModel =
  let gobj = gtk_tree_model_sort_get_model(cast[ptr TreeModelSort00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc model*(self: TreeModelSort): TreeModel =
  let gobj = gtk_tree_model_sort_get_model(cast[ptr TreeModelSort00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_tree_model_filter_get_model(self: ptr TreeModelFilter00): ptr TreeModel00 {.
    importc, libprag.}

proc getModel*(self: TreeModelFilter): TreeModel =
  let gobj = gtk_tree_model_filter_get_model(cast[ptr TreeModelFilter00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc model*(self: TreeModelFilter): TreeModel =
  let gobj = gtk_tree_model_filter_get_model(cast[ptr TreeModelFilter00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  TreeModelFlag* {.size: sizeof(cint), pure.} = enum
    itersPersist = 0
    listOnly = 1

  TreeModelFlags* {.size: sizeof(cint).} = set[TreeModelFlag]

proc gtk_tree_model_get_flags(self: ptr TreeModel00): TreeModelFlags {.
    importc, libprag.}

proc getFlags*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore): TreeModelFlags =
  gtk_tree_model_get_flags(cast[ptr TreeModel00](self.impl))

proc flags*(self: TreeModel | TreeModelSort | ListStore | TreeModelFilter | TreeStore): TreeModelFlags =
  gtk_tree_model_get_flags(cast[ptr TreeModel00](self.impl))

type
  CellAreaContext* = ref object of gobject.Object
  CellAreaContext00* = object of gobject.Object00

proc gtk_cell_area_context_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(CellAreaContext()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_cell_area_context_allocate(self: ptr CellAreaContext00; width: int32;
    height: int32) {.
    importc, libprag.}

proc allocate*(self: CellAreaContext; width: int; height: int) =
  gtk_cell_area_context_allocate(cast[ptr CellAreaContext00](self.impl), int32(width), int32(height))

proc gtk_cell_area_context_get_allocation(self: ptr CellAreaContext00; width: var int32;
    height: var int32) {.
    importc, libprag.}

proc getAllocation*(self: CellAreaContext; width: var int = cast[var int](nil);
    height: var int = cast[var int](nil)) =
  var width_00: int32
  var height_00: int32
  gtk_cell_area_context_get_allocation(cast[ptr CellAreaContext00](self.impl), width_00, height_00)
  if width.addr != nil:
    width = int(width_00)
  if height.addr != nil:
    height = int(height_00)

proc gtk_cell_area_context_get_area(self: ptr CellAreaContext00): ptr CellArea00 {.
    importc, libprag.}

proc getArea*(self: CellAreaContext): CellArea =
  let gobj = gtk_cell_area_context_get_area(cast[ptr CellAreaContext00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc area*(self: CellAreaContext): CellArea =
  let gobj = gtk_cell_area_context_get_area(cast[ptr CellAreaContext00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_cell_area_context_get_preferred_height(self: ptr CellAreaContext00;
    minimumHeight: var int32; naturalHeight: var int32) {.
    importc, libprag.}

proc getPreferredHeight*(self: CellAreaContext; minimumHeight: var int = cast[var int](nil);
    naturalHeight: var int = cast[var int](nil)) =
  var naturalHeight_00: int32
  var minimumHeight_00: int32
  gtk_cell_area_context_get_preferred_height(cast[ptr CellAreaContext00](self.impl), minimumHeight_00, naturalHeight_00)
  if naturalHeight.addr != nil:
    naturalHeight = int(naturalHeight_00)
  if minimumHeight.addr != nil:
    minimumHeight = int(minimumHeight_00)

proc gtk_cell_area_context_get_preferred_height_for_width(self: ptr CellAreaContext00;
    width: int32; minimumHeight: var int32; naturalHeight: var int32) {.
    importc, libprag.}

proc getPreferredHeightForWidth*(self: CellAreaContext;
    width: int; minimumHeight: var int = cast[var int](nil); naturalHeight: var int = cast[var int](nil)) =
  var naturalHeight_00: int32
  var minimumHeight_00: int32
  gtk_cell_area_context_get_preferred_height_for_width(cast[ptr CellAreaContext00](self.impl), int32(width), minimumHeight_00, naturalHeight_00)
  if naturalHeight.addr != nil:
    naturalHeight = int(naturalHeight_00)
  if minimumHeight.addr != nil:
    minimumHeight = int(minimumHeight_00)

proc gtk_cell_area_context_get_preferred_width(self: ptr CellAreaContext00;
    minimumWidth: var int32; naturalWidth: var int32) {.
    importc, libprag.}

proc getPreferredWidth*(self: CellAreaContext; minimumWidth: var int = cast[var int](nil);
    naturalWidth: var int = cast[var int](nil)) =
  var minimumWidth_00: int32
  var naturalWidth_00: int32
  gtk_cell_area_context_get_preferred_width(cast[ptr CellAreaContext00](self.impl), minimumWidth_00, naturalWidth_00)
  if minimumWidth.addr != nil:
    minimumWidth = int(minimumWidth_00)
  if naturalWidth.addr != nil:
    naturalWidth = int(naturalWidth_00)

proc gtk_cell_area_context_get_preferred_width_for_height(self: ptr CellAreaContext00;
    height: int32; minimumWidth: var int32; naturalWidth: var int32) {.
    importc, libprag.}

proc getPreferredWidthForHeight*(self: CellAreaContext;
    height: int; minimumWidth: var int = cast[var int](nil); naturalWidth: var int = cast[var int](nil)) =
  var minimumWidth_00: int32
  var naturalWidth_00: int32
  gtk_cell_area_context_get_preferred_width_for_height(cast[ptr CellAreaContext00](self.impl), int32(height), minimumWidth_00, naturalWidth_00)
  if minimumWidth.addr != nil:
    minimumWidth = int(minimumWidth_00)
  if naturalWidth.addr != nil:
    naturalWidth = int(naturalWidth_00)

proc gtk_cell_area_context_push_preferred_height(self: ptr CellAreaContext00;
    minimumHeight: int32; naturalHeight: int32) {.
    importc, libprag.}

proc pushPreferredHeight*(self: CellAreaContext; minimumHeight: int;
    naturalHeight: int) =
  gtk_cell_area_context_push_preferred_height(cast[ptr CellAreaContext00](self.impl), int32(minimumHeight), int32(naturalHeight))

proc gtk_cell_area_context_push_preferred_width(self: ptr CellAreaContext00;
    minimumWidth: int32; naturalWidth: int32) {.
    importc, libprag.}

proc pushPreferredWidth*(self: CellAreaContext; minimumWidth: int;
    naturalWidth: int) =
  gtk_cell_area_context_push_preferred_width(cast[ptr CellAreaContext00](self.impl), int32(minimumWidth), int32(naturalWidth))

proc gtk_cell_area_context_reset(self: ptr CellAreaContext00) {.
    importc, libprag.}

proc reset*(self: CellAreaContext) =
  gtk_cell_area_context_reset(cast[ptr CellAreaContext00](self.impl))

proc gtk_cell_area_activate(self: ptr CellArea00; context: ptr CellAreaContext00;
    widget: ptr Widget00; cellArea: gdk.Rectangle; flags: CellRendererState;
    editOnly: gboolean): gboolean {.
    importc, libprag.}

proc activate*(self: CellArea; context: CellAreaContext; widget: Widget;
    cellArea: gdk.Rectangle; flags: CellRendererState; editOnly: bool): bool =
  toBool(gtk_cell_area_activate(cast[ptr CellArea00](self.impl), cast[ptr CellAreaContext00](context.impl), cast[ptr Widget00](widget.impl), cellArea, flags, gboolean(editOnly)))

proc gtk_cell_area_copy_context(self: ptr CellArea00; context: ptr CellAreaContext00): ptr CellAreaContext00 {.
    importc, libprag.}

proc copyContext*(self: CellArea; context: CellAreaContext): CellAreaContext =
  let gobj = gtk_cell_area_copy_context(cast[ptr CellArea00](self.impl), cast[ptr CellAreaContext00](context.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_cell_area_create_context(self: ptr CellArea00): ptr CellAreaContext00 {.
    importc, libprag.}

proc createContext*(self: CellArea): CellAreaContext =
  let gobj = gtk_cell_area_create_context(cast[ptr CellArea00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_cell_area_event(self: ptr CellArea00; context: ptr CellAreaContext00;
    widget: ptr Widget00; event: ptr gdk.Event00; cellArea: gdk.Rectangle;
    flags: CellRendererState): int32 {.
    importc, libprag.}

proc event*(self: CellArea; context: CellAreaContext; widget: Widget;
    event: gdk.Event; cellArea: gdk.Rectangle; flags: CellRendererState): int =
  int(gtk_cell_area_event(cast[ptr CellArea00](self.impl), cast[ptr CellAreaContext00](context.impl), cast[ptr Widget00](widget.impl), cast[ptr gdk.Event00](event.impl), cellArea, flags))

proc gtk_cell_area_get_cell_allocation(self: ptr CellArea00; context: ptr CellAreaContext00;
    widget: ptr Widget00; renderer: ptr CellRenderer00; cellArea: gdk.Rectangle;
    allocation: var gdk.Rectangle) {.
    importc, libprag.}

proc getCellAllocation*(self: CellArea; context: CellAreaContext;
    widget: Widget; renderer: CellRenderer; cellArea: gdk.Rectangle; allocation: var gdk.Rectangle) =
  gtk_cell_area_get_cell_allocation(cast[ptr CellArea00](self.impl), cast[ptr CellAreaContext00](context.impl), cast[ptr Widget00](widget.impl), cast[ptr CellRenderer00](renderer.impl), cellArea, allocation)

proc gtk_cell_area_get_cell_at_position(self: ptr CellArea00; context: ptr CellAreaContext00;
    widget: ptr Widget00; cellArea: gdk.Rectangle; x: int32; y: int32; allocArea: var gdk.Rectangle): ptr CellRenderer00 {.
    importc, libprag.}

proc getCellAtPosition*(self: CellArea; context: CellAreaContext;
    widget: Widget; cellArea: gdk.Rectangle; x: int; y: int; allocArea: var gdk.Rectangle = cast[var gdk.Rectangle](nil)): CellRenderer =
  let gobj = gtk_cell_area_get_cell_at_position(cast[ptr CellArea00](self.impl), cast[ptr CellAreaContext00](context.impl), cast[ptr Widget00](widget.impl), cellArea, int32(x), int32(y), allocArea)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_cell_area_get_preferred_height(self: ptr CellArea00; context: ptr CellAreaContext00;
    widget: ptr Widget00; minimumHeight: var int32; naturalHeight: var int32) {.
    importc, libprag.}

proc getPreferredHeight*(self: CellArea; context: CellAreaContext;
    widget: Widget; minimumHeight: var int = cast[var int](nil); naturalHeight: var int = cast[var int](nil)) =
  var naturalHeight_00: int32
  var minimumHeight_00: int32
  gtk_cell_area_get_preferred_height(cast[ptr CellArea00](self.impl), cast[ptr CellAreaContext00](context.impl), cast[ptr Widget00](widget.impl), minimumHeight_00, naturalHeight_00)
  if naturalHeight.addr != nil:
    naturalHeight = int(naturalHeight_00)
  if minimumHeight.addr != nil:
    minimumHeight = int(minimumHeight_00)

proc gtk_cell_area_get_preferred_height_for_width(self: ptr CellArea00; context: ptr CellAreaContext00;
    widget: ptr Widget00; width: int32; minimumHeight: var int32; naturalHeight: var int32) {.
    importc, libprag.}

proc getPreferredHeightForWidth*(self: CellArea; context: CellAreaContext;
    widget: Widget; width: int; minimumHeight: var int = cast[var int](nil);
    naturalHeight: var int = cast[var int](nil)) =
  var naturalHeight_00: int32
  var minimumHeight_00: int32
  gtk_cell_area_get_preferred_height_for_width(cast[ptr CellArea00](self.impl), cast[ptr CellAreaContext00](context.impl), cast[ptr Widget00](widget.impl), int32(width), minimumHeight_00, naturalHeight_00)
  if naturalHeight.addr != nil:
    naturalHeight = int(naturalHeight_00)
  if minimumHeight.addr != nil:
    minimumHeight = int(minimumHeight_00)

proc gtk_cell_area_get_preferred_width(self: ptr CellArea00; context: ptr CellAreaContext00;
    widget: ptr Widget00; minimumWidth: var int32; naturalWidth: var int32) {.
    importc, libprag.}

proc getPreferredWidth*(self: CellArea; context: CellAreaContext;
    widget: Widget; minimumWidth: var int = cast[var int](nil); naturalWidth: var int = cast[var int](nil)) =
  var minimumWidth_00: int32
  var naturalWidth_00: int32
  gtk_cell_area_get_preferred_width(cast[ptr CellArea00](self.impl), cast[ptr CellAreaContext00](context.impl), cast[ptr Widget00](widget.impl), minimumWidth_00, naturalWidth_00)
  if minimumWidth.addr != nil:
    minimumWidth = int(minimumWidth_00)
  if naturalWidth.addr != nil:
    naturalWidth = int(naturalWidth_00)

proc gtk_cell_area_get_preferred_width_for_height(self: ptr CellArea00; context: ptr CellAreaContext00;
    widget: ptr Widget00; height: int32; minimumWidth: var int32; naturalWidth: var int32) {.
    importc, libprag.}

proc getPreferredWidthForHeight*(self: CellArea; context: CellAreaContext;
    widget: Widget; height: int; minimumWidth: var int = cast[var int](nil);
    naturalWidth: var int = cast[var int](nil)) =
  var minimumWidth_00: int32
  var naturalWidth_00: int32
  gtk_cell_area_get_preferred_width_for_height(cast[ptr CellArea00](self.impl), cast[ptr CellAreaContext00](context.impl), cast[ptr Widget00](widget.impl), int32(height), minimumWidth_00, naturalWidth_00)
  if minimumWidth.addr != nil:
    minimumWidth = int(minimumWidth_00)
  if naturalWidth.addr != nil:
    naturalWidth = int(naturalWidth_00)

proc gtk_cell_area_render(self: ptr CellArea00; context: ptr CellAreaContext00;
    widget: ptr Widget00; cr: ptr cairo.Context00; backgroundArea: gdk.Rectangle;
    cellArea: gdk.Rectangle; flags: CellRendererState; paintFocus: gboolean) {.
    importc, libprag.}

proc render*(self: CellArea; context: CellAreaContext; widget: Widget;
    cr: cairo.Context; backgroundArea: gdk.Rectangle; cellArea: gdk.Rectangle;
    flags: CellRendererState; paintFocus: bool) =
  gtk_cell_area_render(cast[ptr CellArea00](self.impl), cast[ptr CellAreaContext00](context.impl), cast[ptr Widget00](widget.impl), cast[ptr cairo.Context00](cr.impl), backgroundArea, cellArea, flags, gboolean(paintFocus))

type
  ActionBar* = ref object of Bin
  ActionBar00* = object of Bin00

proc gtk_action_bar_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ActionBar()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_action_bar_new(): ptr ActionBar00 {.
    importc, libprag.}

proc newActionBar*(): ActionBar =
  let gobj = gtk_action_bar_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newActionBar*(tdesc: typedesc): tdesc =
  assert(result is ActionBar)
  let gobj = gtk_action_bar_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initActionBar*[T](result: var T) {.deprecated.} =
  assert(result is ActionBar)
  let gobj = gtk_action_bar_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_action_bar_get_center_widget(self: ptr ActionBar00): ptr Widget00 {.
    importc, libprag.}

proc getCenterWidget*(self: ActionBar): Widget =
  let gobj = gtk_action_bar_get_center_widget(cast[ptr ActionBar00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc centerWidget*(self: ActionBar): Widget =
  let gobj = gtk_action_bar_get_center_widget(cast[ptr ActionBar00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_action_bar_pack_end(self: ptr ActionBar00; child: ptr Widget00) {.
    importc, libprag.}

proc packEnd*(self: ActionBar; child: Widget) =
  gtk_action_bar_pack_end(cast[ptr ActionBar00](self.impl), cast[ptr Widget00](child.impl))

proc gtk_action_bar_pack_start(self: ptr ActionBar00; child: ptr Widget00) {.
    importc, libprag.}

proc packStart*(self: ActionBar; child: Widget) =
  gtk_action_bar_pack_start(cast[ptr ActionBar00](self.impl), cast[ptr Widget00](child.impl))

proc gtk_action_bar_set_center_widget(self: ptr ActionBar00; centerWidget: ptr Widget00) {.
    importc, libprag.}

proc setCenterWidget*(self: ActionBar; centerWidget: Widget = nil) =
  gtk_action_bar_set_center_widget(cast[ptr ActionBar00](self.impl), if centerWidget.isNil: nil else: cast[ptr Widget00](centerWidget.impl))

proc `centerWidget=`*(self: ActionBar; centerWidget: Widget = nil) =
  gtk_action_bar_set_center_widget(cast[ptr ActionBar00](self.impl), if centerWidget.isNil: nil else: cast[ptr Widget00](centerWidget.impl))

type
  ActionEntry00* {.pure.} = object
  ActionEntry* = ref object
    impl*: ptr ActionEntry00
    ignoreFinalizer*: bool

type
  ApplicationWindow* = ref object of Window
  ApplicationWindow00* = object of Window00

proc gtk_application_window_get_type*(): GType {.importc, libprag.}

proc gtk_application_window_new(application: ptr Application00): ptr ApplicationWindow00 {.
    importc, libprag.}

proc newApplicationWindow*(application: Application): ApplicationWindow =
  let gobj = gtk_application_window_new(cast[ptr Application00](application.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    GC_ref(result)
    result.ignoreFinalizer = true
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newApplicationWindow*(tdesc: typedesc; application: Application): tdesc =
  assert(result is ApplicationWindow)
  let gobj = gtk_application_window_new(cast[ptr Application00](application.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    GC_ref(result)
    result.ignoreFinalizer = true
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initApplicationWindow*[T](result: var T; application: Application) {.deprecated.} =
  assert(result is ApplicationWindow)
  let gobj = gtk_application_window_new(cast[ptr Application00](application.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    GC_ref(result)
    result.ignoreFinalizer = true
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_application_window_get_id(self: ptr ApplicationWindow00): uint32 {.
    importc, libprag.}

proc getId*(self: ApplicationWindow): int =
  int(gtk_application_window_get_id(cast[ptr ApplicationWindow00](self.impl)))

proc id*(self: ApplicationWindow): int =
  int(gtk_application_window_get_id(cast[ptr ApplicationWindow00](self.impl)))

proc gtk_application_window_get_show_menubar(self: ptr ApplicationWindow00): gboolean {.
    importc, libprag.}

proc getShowMenubar*(self: ApplicationWindow): bool =
  toBool(gtk_application_window_get_show_menubar(cast[ptr ApplicationWindow00](self.impl)))

proc showMenubar*(self: ApplicationWindow): bool =
  toBool(gtk_application_window_get_show_menubar(cast[ptr ApplicationWindow00](self.impl)))

proc gtk_application_window_set_show_menubar(self: ptr ApplicationWindow00;
    showMenubar: gboolean) {.
    importc, libprag.}

proc setShowMenubar*(self: ApplicationWindow; showMenubar: bool = true) =
  gtk_application_window_set_show_menubar(cast[ptr ApplicationWindow00](self.impl), gboolean(showMenubar))

proc `showMenubar=`*(self: ApplicationWindow; showMenubar: bool) =
  gtk_application_window_set_show_menubar(cast[ptr ApplicationWindow00](self.impl), gboolean(showMenubar))

type
  ActionGroup* = ref object of gobject.Object
  ActionGroup00* = object of gobject.Object00

proc gtk_action_group_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ActionGroup()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scConnectProxy*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow;  p: proc (self: ptr ActionGroup00; action: ptr Action00; proxy: ptr Widget00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "connect-proxy", cast[GCallback](p), xdata, nil, cf)

proc scDisconnectProxy*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow;  p: proc (self: ptr ActionGroup00; action: ptr Action00; proxy: ptr Widget00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "disconnect-proxy", cast[GCallback](p), xdata, nil, cf)

proc scPostActivate*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow;  p: proc (self: ptr ActionGroup00; action: ptr Action00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "post-activate", cast[GCallback](p), xdata, nil, cf)

proc scPreActivate*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow;  p: proc (self: ptr ActionGroup00; action: ptr Action00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "pre-activate", cast[GCallback](p), xdata, nil, cf)

proc gtk_action_group_new(name: cstring): ptr ActionGroup00 {.
    importc, libprag.}

proc newActionGroup*(name: cstring): ActionGroup {.deprecated.}  =
  let gobj = gtk_action_group_new(name)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newActionGroup*(tdesc: typedesc; name: cstring): tdesc {.deprecated.}  =
  assert(result is ActionGroup)
  let gobj = gtk_action_group_new(name)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initActionGroup*[T](result: var T; name: cstring) {.deprecated.} =
  assert(result is ActionGroup)
  let gobj = gtk_action_group_new(name)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    if g_object_is_floating(result.impl).int != 0:
      discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_action_group_add_action(self: ptr ActionGroup00; action: ptr Action00) {.
    importc, libprag.}

proc addAction*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow;
    action: Action) =
  gtk_action_group_add_action(cast[ptr ActionGroup00](self.impl), cast[ptr Action00](action.impl))

proc gtk_action_group_add_action_with_accel(self: ptr ActionGroup00; action: ptr Action00;
    accelerator: cstring) {.
    importc, libprag.}

proc addActionWithAccel*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow;
    action: Action; accelerator: cstring = nil) =
  gtk_action_group_add_action_with_accel(cast[ptr ActionGroup00](self.impl), cast[ptr Action00](action.impl), accelerator)

proc gtk_action_group_get_accel_group(self: ptr ActionGroup00): ptr AccelGroup00 {.
    importc, libprag.}

proc getAccelGroup*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow): AccelGroup =
  let gobj = gtk_action_group_get_accel_group(cast[ptr ActionGroup00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc accelGroup*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow): AccelGroup =
  let gobj = gtk_action_group_get_accel_group(cast[ptr ActionGroup00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_action_group_get_action(self: ptr ActionGroup00; actionName: cstring): ptr Action00 {.
    importc, libprag.}

proc getAction*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow;
    actionName: cstring): Action =
  let gobj = gtk_action_group_get_action(cast[ptr ActionGroup00](self.impl), actionName)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_action_group_get_name(self: ptr ActionGroup00): cstring {.
    importc, libprag.}

proc getName*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow): string =
  result = $gtk_action_group_get_name(cast[ptr ActionGroup00](self.impl))

proc name*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow): string =
  result = $gtk_action_group_get_name(cast[ptr ActionGroup00](self.impl))

proc gtk_action_group_get_sensitive(self: ptr ActionGroup00): gboolean {.
    importc, libprag.}

proc getSensitive*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow): bool =
  toBool(gtk_action_group_get_sensitive(cast[ptr ActionGroup00](self.impl)))

proc sensitive*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow): bool =
  toBool(gtk_action_group_get_sensitive(cast[ptr ActionGroup00](self.impl)))

proc gtk_action_group_get_visible(self: ptr ActionGroup00): gboolean {.
    importc, libprag.}

proc getVisible*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow): bool =
  toBool(gtk_action_group_get_visible(cast[ptr ActionGroup00](self.impl)))

proc visible*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow): bool =
  toBool(gtk_action_group_get_visible(cast[ptr ActionGroup00](self.impl)))

proc gtk_action_group_list_actions(self: ptr ActionGroup00): ptr glib.List {.
    importc, libprag.}

proc listActions*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow): seq[Action] =
  let resul0 = gtk_action_group_list_actions(cast[ptr ActionGroup00](self.impl))
  result = glistObjects2seq(Action, resul0, false)
  g_list_free(resul0)

proc gtk_action_group_remove_action(self: ptr ActionGroup00; action: ptr Action00) {.
    importc, libprag.}

proc removeAction*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow;
    action: Action) =
  gtk_action_group_remove_action(cast[ptr ActionGroup00](self.impl), cast[ptr Action00](action.impl))

proc gtk_action_group_set_accel_group(self: ptr ActionGroup00; accelGroup: ptr AccelGroup00) {.
    importc, libprag.}

proc setAccelGroup*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow;
    accelGroup: AccelGroup = nil) =
  gtk_action_group_set_accel_group(cast[ptr ActionGroup00](self.impl), if accelGroup.isNil: nil else: cast[ptr AccelGroup00](accelGroup.impl))

proc `accelGroup=`*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow;
    accelGroup: AccelGroup = nil) =
  gtk_action_group_set_accel_group(cast[ptr ActionGroup00](self.impl), if accelGroup.isNil: nil else: cast[ptr AccelGroup00](accelGroup.impl))

proc gtk_action_group_set_sensitive(self: ptr ActionGroup00; sensitive: gboolean) {.
    importc, libprag.}

proc setSensitive*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow;
    sensitive: bool = true) =
  gtk_action_group_set_sensitive(cast[ptr ActionGroup00](self.impl), gboolean(sensitive))

proc `sensitive=`*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow;
    sensitive: bool) =
  gtk_action_group_set_sensitive(cast[ptr ActionGroup00](self.impl), gboolean(sensitive))

proc gtk_action_group_set_translation_domain(self: ptr ActionGroup00; domain: cstring) {.
    importc, libprag.}

proc setTranslationDomain*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow;
    domain: cstring = nil) =
  gtk_action_group_set_translation_domain(cast[ptr ActionGroup00](self.impl), domain)

proc `translationDomain=`*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow;
    domain: cstring = nil) =
  gtk_action_group_set_translation_domain(cast[ptr ActionGroup00](self.impl), domain)

proc gtk_action_group_set_visible(self: ptr ActionGroup00; visible: gboolean) {.
    importc, libprag.}

proc setVisible*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow;
    visible: bool = true) =
  gtk_action_group_set_visible(cast[ptr ActionGroup00](self.impl), gboolean(visible))

proc `visible=`*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow;
    visible: bool) =
  gtk_action_group_set_visible(cast[ptr ActionGroup00](self.impl), gboolean(visible))

proc gtk_action_group_translate_string(self: ptr ActionGroup00; string: cstring): cstring {.
    importc, libprag.}

proc translateString*(self: ActionGroup | gio.SimpleActionGroup | Application | ApplicationWindow;
    string: cstring): string =
  result = $gtk_action_group_translate_string(cast[ptr ActionGroup00](self.impl), string)

type
  ShortcutsWindow* = ref object of Window
  ShortcutsWindow00* = object of Window00

proc gtk_shortcuts_window_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ShortcutsWindow()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scClose*(self: ShortcutsWindow;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "close", cast[GCallback](p), xdata, nil, cf)

proc scSearch*(self: ShortcutsWindow;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "search", cast[GCallback](p), xdata, nil, cf)

proc gtk_application_window_get_help_overlay(self: ptr ApplicationWindow00): ptr ShortcutsWindow00 {.
    importc, libprag.}

proc getHelpOverlay*(self: ApplicationWindow): ShortcutsWindow =
  let gobj = gtk_application_window_get_help_overlay(cast[ptr ApplicationWindow00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc helpOverlay*(self: ApplicationWindow): ShortcutsWindow =
  let gobj = gtk_application_window_get_help_overlay(cast[ptr ApplicationWindow00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_application_window_set_help_overlay(self: ptr ApplicationWindow00;
    helpOverlay: ptr ShortcutsWindow00) {.
    importc, libprag.}

proc setHelpOverlay*(self: ApplicationWindow; helpOverlay: ShortcutsWindow = nil) =
  gtk_application_window_set_help_overlay(cast[ptr ApplicationWindow00](self.impl), if helpOverlay.isNil: nil else: cast[ptr ShortcutsWindow00](helpOverlay.impl))

proc `helpOverlay=`*(self: ApplicationWindow; helpOverlay: ShortcutsWindow = nil) =
  gtk_application_window_set_help_overlay(cast[ptr ApplicationWindow00](self.impl), if helpOverlay.isNil: nil else: cast[ptr ShortcutsWindow00](helpOverlay.impl))

type
  Actionable00* = object of gobject.Object00
  Actionable* = ref object of gobject.Object

type
  TearoffMenuItem* = ref object of MenuItem
  TearoffMenuItem00* = object of MenuItem00

proc gtk_tearoff_menu_item_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(TearoffMenuItem()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_tearoff_menu_item_new(): ptr TearoffMenuItem00 {.
    importc, libprag.}

proc newTearoffMenuItem*(): TearoffMenuItem {.deprecated.}  =
  let gobj = gtk_tearoff_menu_item_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newTearoffMenuItem*(tdesc: typedesc): tdesc {.deprecated.}  =
  assert(result is TearoffMenuItem)
  let gobj = gtk_tearoff_menu_item_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initTearoffMenuItem*[T](result: var T) {.deprecated.} =
  assert(result is TearoffMenuItem)
  let gobj = gtk_tearoff_menu_item_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  Button* = ref object of Bin
  Button00* = object of Bin00

proc gtk_button_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Button()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scActivate*(self: Button;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "activate", cast[GCallback](p), xdata, nil, cf)

proc scClicked*(self: Button;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "clicked", cast[GCallback](p), xdata, nil, cf)

proc scEnter*(self: Button;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "enter", cast[GCallback](p), xdata, nil, cf)

proc scLeave*(self: Button;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "leave", cast[GCallback](p), xdata, nil, cf)

proc scPressed*(self: Button;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "pressed", cast[GCallback](p), xdata, nil, cf)

proc scReleased*(self: Button;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "released", cast[GCallback](p), xdata, nil, cf)

proc gtk_button_new(): ptr Button00 {.
    importc, libprag.}

proc newButton*(): Button =
  let gobj = gtk_button_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newButton*(tdesc: typedesc): tdesc =
  assert(result is Button)
  let gobj = gtk_button_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initButton*[T](result: var T) {.deprecated.} =
  assert(result is Button)
  let gobj = gtk_button_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_button_new_from_icon_name(iconName: cstring; size: int32): ptr Button00 {.
    importc, libprag.}

proc newButtonFromIconName*(iconName: cstring = nil; size: int): Button =
  let gobj = gtk_button_new_from_icon_name(iconName, int32(size))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newButtonFromIconName*(tdesc: typedesc; iconName: cstring = nil; size: int): tdesc =
  assert(result is Button)
  let gobj = gtk_button_new_from_icon_name(iconName, int32(size))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initButtonFromIconName*[T](result: var T; iconName: cstring = nil; size: int) {.deprecated.} =
  assert(result is Button)
  let gobj = gtk_button_new_from_icon_name(iconName, int32(size))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_button_new_from_stock(stockId: cstring): ptr Button00 {.
    importc, libprag.}

proc newButtonFromStock*(stockId: cstring): Button {.deprecated.}  =
  let gobj = gtk_button_new_from_stock(stockId)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newButtonFromStock*(tdesc: typedesc; stockId: cstring): tdesc {.deprecated.}  =
  assert(result is Button)
  let gobj = gtk_button_new_from_stock(stockId)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initButtonFromStock*[T](result: var T; stockId: cstring) {.deprecated.} =
  assert(result is Button)
  let gobj = gtk_button_new_from_stock(stockId)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_button_new_with_label(label: cstring): ptr Button00 {.
    importc, libprag.}

proc newButton*(label: cstring): Button =
  let gobj = gtk_button_new_with_label(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newButton*(tdesc: typedesc; label: cstring): tdesc =
  assert(result is Button)
  let gobj = gtk_button_new_with_label(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initButton*[T](result: var T; label: cstring) {.deprecated.} =
  assert(result is Button)
  let gobj = gtk_button_new_with_label(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_button_new_with_mnemonic(label: cstring): ptr Button00 {.
    importc, libprag.}

proc newButtonWithMnemonic*(label: cstring): Button =
  let gobj = gtk_button_new_with_mnemonic(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newButtonWithMnemonic*(tdesc: typedesc; label: cstring): tdesc =
  assert(result is Button)
  let gobj = gtk_button_new_with_mnemonic(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initButtonWithMnemonic*[T](result: var T; label: cstring) {.deprecated.} =
  assert(result is Button)
  let gobj = gtk_button_new_with_mnemonic(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_button_clicked(self: ptr Button00) {.
    importc, libprag.}

proc clicked*(self: Button) =
  gtk_button_clicked(cast[ptr Button00](self.impl))

proc gtk_button_enter(self: ptr Button00) {.
    importc, libprag.}

proc enter*(self: Button) =
  gtk_button_enter(cast[ptr Button00](self.impl))

proc gtk_button_get_alignment(self: ptr Button00; xalign: var cfloat; yalign: var cfloat) {.
    importc, libprag.}

proc getAlignment*(self: Button; xalign: var cfloat; yalign: var cfloat) =
  gtk_button_get_alignment(cast[ptr Button00](self.impl), xalign, yalign)

proc gtk_button_get_always_show_image(self: ptr Button00): gboolean {.
    importc, libprag.}

proc getAlwaysShowImage*(self: Button): bool =
  toBool(gtk_button_get_always_show_image(cast[ptr Button00](self.impl)))

proc alwaysShowImage*(self: Button): bool =
  toBool(gtk_button_get_always_show_image(cast[ptr Button00](self.impl)))

proc gtk_button_get_event_window(self: ptr Button00): ptr gdk.Window00 {.
    importc, libprag.}

proc getEventWindow*(self: Button): gdk.Window =
  let gobj = gtk_button_get_event_window(cast[ptr Button00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc eventWindow*(self: Button): gdk.Window =
  let gobj = gtk_button_get_event_window(cast[ptr Button00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gdk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_button_get_focus_on_click(self: ptr Button00): gboolean {.
    importc, libprag.}

proc getFocusOnClick*(self: Button): bool =
  toBool(gtk_button_get_focus_on_click(cast[ptr Button00](self.impl)))

proc focusOnClick*(self: Button): bool =
  toBool(gtk_button_get_focus_on_click(cast[ptr Button00](self.impl)))

proc gtk_button_get_image(self: ptr Button00): ptr Widget00 {.
    importc, libprag.}

proc getImage*(self: Button): Widget =
  let gobj = gtk_button_get_image(cast[ptr Button00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc image*(self: Button): Widget =
  let gobj = gtk_button_get_image(cast[ptr Button00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_button_get_label(self: ptr Button00): cstring {.
    importc, libprag.}

proc getLabel*(self: Button): string =
  result = $gtk_button_get_label(cast[ptr Button00](self.impl))

proc label*(self: Button): string =
  result = $gtk_button_get_label(cast[ptr Button00](self.impl))

proc gtk_button_get_use_stock(self: ptr Button00): gboolean {.
    importc, libprag.}

proc getUseStock*(self: Button): bool =
  toBool(gtk_button_get_use_stock(cast[ptr Button00](self.impl)))

proc useStock*(self: Button): bool =
  toBool(gtk_button_get_use_stock(cast[ptr Button00](self.impl)))

proc gtk_button_get_use_underline(self: ptr Button00): gboolean {.
    importc, libprag.}

proc getUseUnderline*(self: Button): bool =
  toBool(gtk_button_get_use_underline(cast[ptr Button00](self.impl)))

proc useUnderline*(self: Button): bool =
  toBool(gtk_button_get_use_underline(cast[ptr Button00](self.impl)))

proc gtk_button_leave(self: ptr Button00) {.
    importc, libprag.}

proc leave*(self: Button) =
  gtk_button_leave(cast[ptr Button00](self.impl))

proc gtk_button_pressed(self: ptr Button00) {.
    importc, libprag.}

proc pressed*(self: Button) =
  gtk_button_pressed(cast[ptr Button00](self.impl))

proc gtk_button_released(self: ptr Button00) {.
    importc, libprag.}

proc released*(self: Button) =
  gtk_button_released(cast[ptr Button00](self.impl))

proc gtk_button_set_alignment(self: ptr Button00; xalign: cfloat; yalign: cfloat) {.
    importc, libprag.}

proc setAlignment*(self: Button; xalign: cfloat; yalign: cfloat) =
  gtk_button_set_alignment(cast[ptr Button00](self.impl), xalign, yalign)

proc gtk_button_set_always_show_image(self: ptr Button00; alwaysShow: gboolean) {.
    importc, libprag.}

proc setAlwaysShowImage*(self: Button; alwaysShow: bool = true) =
  gtk_button_set_always_show_image(cast[ptr Button00](self.impl), gboolean(alwaysShow))

proc `alwaysShowImage=`*(self: Button; alwaysShow: bool) =
  gtk_button_set_always_show_image(cast[ptr Button00](self.impl), gboolean(alwaysShow))

proc gtk_button_set_focus_on_click(self: ptr Button00; focusOnClick: gboolean) {.
    importc, libprag.}

proc setFocusOnClick*(self: Button; focusOnClick: bool = true) =
  gtk_button_set_focus_on_click(cast[ptr Button00](self.impl), gboolean(focusOnClick))

proc `focusOnClick=`*(self: Button; focusOnClick: bool) =
  gtk_button_set_focus_on_click(cast[ptr Button00](self.impl), gboolean(focusOnClick))

proc gtk_button_set_image(self: ptr Button00; image: ptr Widget00) {.
    importc, libprag.}

proc setImage*(self: Button; image: Widget = nil) =
  gtk_button_set_image(cast[ptr Button00](self.impl), if image.isNil: nil else: cast[ptr Widget00](image.impl))

proc `image=`*(self: Button; image: Widget = nil) =
  gtk_button_set_image(cast[ptr Button00](self.impl), if image.isNil: nil else: cast[ptr Widget00](image.impl))

proc gtk_button_set_label(self: ptr Button00; label: cstring) {.
    importc, libprag.}

proc setLabel*(self: Button; label: cstring) =
  gtk_button_set_label(cast[ptr Button00](self.impl), label)

proc `label=`*(self: Button; label: cstring) =
  gtk_button_set_label(cast[ptr Button00](self.impl), label)

proc gtk_button_set_use_stock(self: ptr Button00; useStock: gboolean) {.
    importc, libprag.}

proc setUseStock*(self: Button; useStock: bool = true) =
  gtk_button_set_use_stock(cast[ptr Button00](self.impl), gboolean(useStock))

proc `useStock=`*(self: Button; useStock: bool) =
  gtk_button_set_use_stock(cast[ptr Button00](self.impl), gboolean(useStock))

proc gtk_button_set_use_underline(self: ptr Button00; useUnderline: gboolean) {.
    importc, libprag.}

proc setUseUnderline*(self: Button; useUnderline: bool = true) =
  gtk_button_set_use_underline(cast[ptr Button00](self.impl), gboolean(useUnderline))

proc `useUnderline=`*(self: Button; useUnderline: bool) =
  gtk_button_set_use_underline(cast[ptr Button00](self.impl), gboolean(useUnderline))

type
  ToggleButton* = ref object of Button
  ToggleButton00* = object of Button00

proc gtk_toggle_button_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ToggleButton()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scToggled*(self: ToggleButton;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "toggled", cast[GCallback](p), xdata, nil, cf)

proc gtk_toggle_button_new(): ptr ToggleButton00 {.
    importc, libprag.}

proc newToggleButton*(): ToggleButton =
  let gobj = gtk_toggle_button_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newToggleButton*(tdesc: typedesc): tdesc =
  assert(result is ToggleButton)
  let gobj = gtk_toggle_button_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initToggleButton*[T](result: var T) {.deprecated.} =
  assert(result is ToggleButton)
  let gobj = gtk_toggle_button_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_toggle_button_new_with_label(label: cstring): ptr ToggleButton00 {.
    importc, libprag.}

proc newToggleButton*(label: cstring): ToggleButton =
  let gobj = gtk_toggle_button_new_with_label(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newToggleButton*(tdesc: typedesc; label: cstring): tdesc =
  assert(result is ToggleButton)
  let gobj = gtk_toggle_button_new_with_label(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initToggleButton*[T](result: var T; label: cstring) {.deprecated.} =
  assert(result is ToggleButton)
  let gobj = gtk_toggle_button_new_with_label(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_toggle_button_new_with_mnemonic(label: cstring): ptr ToggleButton00 {.
    importc, libprag.}

proc newToggleButtonWithMnemonic*(label: cstring): ToggleButton =
  let gobj = gtk_toggle_button_new_with_mnemonic(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newToggleButtonWithMnemonic*(tdesc: typedesc; label: cstring): tdesc =
  assert(result is ToggleButton)
  let gobj = gtk_toggle_button_new_with_mnemonic(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initToggleButtonWithMnemonic*[T](result: var T; label: cstring) {.deprecated.} =
  assert(result is ToggleButton)
  let gobj = gtk_toggle_button_new_with_mnemonic(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_toggle_button_get_active(self: ptr ToggleButton00): gboolean {.
    importc, libprag.}

proc getActive*(self: ToggleButton): bool =
  toBool(gtk_toggle_button_get_active(cast[ptr ToggleButton00](self.impl)))

proc active*(self: ToggleButton): bool =
  toBool(gtk_toggle_button_get_active(cast[ptr ToggleButton00](self.impl)))

proc gtk_toggle_button_get_inconsistent(self: ptr ToggleButton00): gboolean {.
    importc, libprag.}

proc getInconsistent*(self: ToggleButton): bool =
  toBool(gtk_toggle_button_get_inconsistent(cast[ptr ToggleButton00](self.impl)))

proc inconsistent*(self: ToggleButton): bool =
  toBool(gtk_toggle_button_get_inconsistent(cast[ptr ToggleButton00](self.impl)))

proc gtk_toggle_button_get_mode(self: ptr ToggleButton00): gboolean {.
    importc, libprag.}

proc getMode*(self: ToggleButton): bool =
  toBool(gtk_toggle_button_get_mode(cast[ptr ToggleButton00](self.impl)))

proc mode*(self: ToggleButton): bool =
  toBool(gtk_toggle_button_get_mode(cast[ptr ToggleButton00](self.impl)))

proc gtk_toggle_button_set_active(self: ptr ToggleButton00; isActive: gboolean) {.
    importc, libprag.}

proc setActive*(self: ToggleButton; isActive: bool = true) =
  gtk_toggle_button_set_active(cast[ptr ToggleButton00](self.impl), gboolean(isActive))

proc `active=`*(self: ToggleButton; isActive: bool) =
  gtk_toggle_button_set_active(cast[ptr ToggleButton00](self.impl), gboolean(isActive))

proc gtk_toggle_button_set_inconsistent(self: ptr ToggleButton00; setting: gboolean) {.
    importc, libprag.}

proc setInconsistent*(self: ToggleButton; setting: bool = true) =
  gtk_toggle_button_set_inconsistent(cast[ptr ToggleButton00](self.impl), gboolean(setting))

proc `inconsistent=`*(self: ToggleButton; setting: bool) =
  gtk_toggle_button_set_inconsistent(cast[ptr ToggleButton00](self.impl), gboolean(setting))

proc gtk_toggle_button_set_mode(self: ptr ToggleButton00; drawIndicator: gboolean) {.
    importc, libprag.}

proc setMode*(self: ToggleButton; drawIndicator: bool = true) =
  gtk_toggle_button_set_mode(cast[ptr ToggleButton00](self.impl), gboolean(drawIndicator))

proc `mode=`*(self: ToggleButton; drawIndicator: bool) =
  gtk_toggle_button_set_mode(cast[ptr ToggleButton00](self.impl), gboolean(drawIndicator))

proc gtk_toggle_button_toggled(self: ptr ToggleButton00) {.
    importc, libprag.}

proc toggled*(self: ToggleButton) =
  gtk_toggle_button_toggled(cast[ptr ToggleButton00](self.impl))

type
  CheckButton* = ref object of ToggleButton
  CheckButton00* = object of ToggleButton00

proc gtk_check_button_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(CheckButton()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_check_button_new(): ptr CheckButton00 {.
    importc, libprag.}

proc newCheckButton*(): CheckButton =
  let gobj = gtk_check_button_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newCheckButton*(tdesc: typedesc): tdesc =
  assert(result is CheckButton)
  let gobj = gtk_check_button_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initCheckButton*[T](result: var T) {.deprecated.} =
  assert(result is CheckButton)
  let gobj = gtk_check_button_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_check_button_new_with_label(label: cstring): ptr CheckButton00 {.
    importc, libprag.}

proc newCheckButton*(label: cstring): CheckButton =
  let gobj = gtk_check_button_new_with_label(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newCheckButton*(tdesc: typedesc; label: cstring): tdesc =
  assert(result is CheckButton)
  let gobj = gtk_check_button_new_with_label(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initCheckButton*[T](result: var T; label: cstring) {.deprecated.} =
  assert(result is CheckButton)
  let gobj = gtk_check_button_new_with_label(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_check_button_new_with_mnemonic(label: cstring): ptr CheckButton00 {.
    importc, libprag.}

proc newCheckButtonWithMnemonic*(label: cstring): CheckButton =
  let gobj = gtk_check_button_new_with_mnemonic(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newCheckButtonWithMnemonic*(tdesc: typedesc; label: cstring): tdesc =
  assert(result is CheckButton)
  let gobj = gtk_check_button_new_with_mnemonic(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initCheckButtonWithMnemonic*[T](result: var T; label: cstring) {.deprecated.} =
  assert(result is CheckButton)
  let gobj = gtk_check_button_new_with_mnemonic(label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  ToolItem* = ref object of Bin
  ToolItem00* = object of Bin00

proc gtk_tool_item_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ToolItem()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scCreateMenuProxy*(self: ToolItem;  p: proc (self: ptr ToolItem00; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "create-menu-proxy", cast[GCallback](p), xdata, nil, cf)

proc scToolbarReconfigured*(self: ToolItem;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "toolbar-reconfigured", cast[GCallback](p), xdata, nil, cf)

proc gtk_tool_item_new(): ptr ToolItem00 {.
    importc, libprag.}

proc newToolItem*(): ToolItem =
  let gobj = gtk_tool_item_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newToolItem*(tdesc: typedesc): tdesc =
  assert(result is ToolItem)
  let gobj = gtk_tool_item_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initToolItem*[T](result: var T) {.deprecated.} =
  assert(result is ToolItem)
  let gobj = gtk_tool_item_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_tool_item_get_ellipsize_mode(self: ptr ToolItem00): pango.EllipsizeMode {.
    importc, libprag.}

proc getEllipsizeMode*(self: ToolItem): pango.EllipsizeMode =
  gtk_tool_item_get_ellipsize_mode(cast[ptr ToolItem00](self.impl))

proc ellipsizeMode*(self: ToolItem): pango.EllipsizeMode =
  gtk_tool_item_get_ellipsize_mode(cast[ptr ToolItem00](self.impl))

proc gtk_tool_item_get_expand(self: ptr ToolItem00): gboolean {.
    importc, libprag.}

proc getExpand*(self: ToolItem): bool =
  toBool(gtk_tool_item_get_expand(cast[ptr ToolItem00](self.impl)))

proc expand*(self: ToolItem): bool =
  toBool(gtk_tool_item_get_expand(cast[ptr ToolItem00](self.impl)))

proc gtk_tool_item_get_homogeneous(self: ptr ToolItem00): gboolean {.
    importc, libprag.}

proc getHomogeneous*(self: ToolItem): bool =
  toBool(gtk_tool_item_get_homogeneous(cast[ptr ToolItem00](self.impl)))

proc homogeneous*(self: ToolItem): bool =
  toBool(gtk_tool_item_get_homogeneous(cast[ptr ToolItem00](self.impl)))

proc gtk_tool_item_get_icon_size(self: ptr ToolItem00): int32 {.
    importc, libprag.}

proc getIconSize*(self: ToolItem): int =
  int(gtk_tool_item_get_icon_size(cast[ptr ToolItem00](self.impl)))

proc iconSize*(self: ToolItem): int =
  int(gtk_tool_item_get_icon_size(cast[ptr ToolItem00](self.impl)))

proc gtk_tool_item_get_is_important(self: ptr ToolItem00): gboolean {.
    importc, libprag.}

proc getIsImportant*(self: ToolItem): bool =
  toBool(gtk_tool_item_get_is_important(cast[ptr ToolItem00](self.impl)))

proc isImportant*(self: ToolItem): bool =
  toBool(gtk_tool_item_get_is_important(cast[ptr ToolItem00](self.impl)))

proc gtk_tool_item_get_orientation(self: ptr ToolItem00): Orientation {.
    importc, libprag.}

proc getOrientation*(self: ToolItem): Orientation =
  gtk_tool_item_get_orientation(cast[ptr ToolItem00](self.impl))

proc orientation*(self: ToolItem): Orientation =
  gtk_tool_item_get_orientation(cast[ptr ToolItem00](self.impl))

proc gtk_tool_item_get_proxy_menu_item(self: ptr ToolItem00; menuItemId: cstring): ptr Widget00 {.
    importc, libprag.}

proc getProxyMenuItem*(self: ToolItem; menuItemId: cstring): Widget =
  let gobj = gtk_tool_item_get_proxy_menu_item(cast[ptr ToolItem00](self.impl), menuItemId)
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_tool_item_get_text_alignment(self: ptr ToolItem00): cfloat {.
    importc, libprag.}

proc getTextAlignment*(self: ToolItem): cfloat =
  gtk_tool_item_get_text_alignment(cast[ptr ToolItem00](self.impl))

proc textAlignment*(self: ToolItem): cfloat =
  gtk_tool_item_get_text_alignment(cast[ptr ToolItem00](self.impl))

proc gtk_tool_item_get_text_orientation(self: ptr ToolItem00): Orientation {.
    importc, libprag.}

proc getTextOrientation*(self: ToolItem): Orientation =
  gtk_tool_item_get_text_orientation(cast[ptr ToolItem00](self.impl))

proc textOrientation*(self: ToolItem): Orientation =
  gtk_tool_item_get_text_orientation(cast[ptr ToolItem00](self.impl))

proc gtk_tool_item_get_use_drag_window(self: ptr ToolItem00): gboolean {.
    importc, libprag.}

proc getUseDragWindow*(self: ToolItem): bool =
  toBool(gtk_tool_item_get_use_drag_window(cast[ptr ToolItem00](self.impl)))

proc useDragWindow*(self: ToolItem): bool =
  toBool(gtk_tool_item_get_use_drag_window(cast[ptr ToolItem00](self.impl)))

proc gtk_tool_item_get_visible_horizontal(self: ptr ToolItem00): gboolean {.
    importc, libprag.}

proc getVisibleHorizontal*(self: ToolItem): bool =
  toBool(gtk_tool_item_get_visible_horizontal(cast[ptr ToolItem00](self.impl)))

proc visibleHorizontal*(self: ToolItem): bool =
  toBool(gtk_tool_item_get_visible_horizontal(cast[ptr ToolItem00](self.impl)))

proc gtk_tool_item_get_visible_vertical(self: ptr ToolItem00): gboolean {.
    importc, libprag.}

proc getVisibleVertical*(self: ToolItem): bool =
  toBool(gtk_tool_item_get_visible_vertical(cast[ptr ToolItem00](self.impl)))

proc visibleVertical*(self: ToolItem): bool =
  toBool(gtk_tool_item_get_visible_vertical(cast[ptr ToolItem00](self.impl)))

proc gtk_tool_item_rebuild_menu(self: ptr ToolItem00) {.
    importc, libprag.}

proc rebuildMenu*(self: ToolItem) =
  gtk_tool_item_rebuild_menu(cast[ptr ToolItem00](self.impl))

proc gtk_tool_item_retrieve_proxy_menu_item(self: ptr ToolItem00): ptr Widget00 {.
    importc, libprag.}

proc retrieveProxyMenuItem*(self: ToolItem): Widget =
  let gobj = gtk_tool_item_retrieve_proxy_menu_item(cast[ptr ToolItem00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_tool_item_set_expand(self: ptr ToolItem00; expand: gboolean) {.
    importc, libprag.}

proc setExpand*(self: ToolItem; expand: bool = true) =
  gtk_tool_item_set_expand(cast[ptr ToolItem00](self.impl), gboolean(expand))

proc `expand=`*(self: ToolItem; expand: bool) =
  gtk_tool_item_set_expand(cast[ptr ToolItem00](self.impl), gboolean(expand))

proc gtk_tool_item_set_homogeneous(self: ptr ToolItem00; homogeneous: gboolean) {.
    importc, libprag.}

proc setHomogeneous*(self: ToolItem; homogeneous: bool = true) =
  gtk_tool_item_set_homogeneous(cast[ptr ToolItem00](self.impl), gboolean(homogeneous))

proc `homogeneous=`*(self: ToolItem; homogeneous: bool) =
  gtk_tool_item_set_homogeneous(cast[ptr ToolItem00](self.impl), gboolean(homogeneous))

proc gtk_tool_item_set_is_important(self: ptr ToolItem00; isImportant: gboolean) {.
    importc, libprag.}

proc setIsImportant*(self: ToolItem; isImportant: bool = true) =
  gtk_tool_item_set_is_important(cast[ptr ToolItem00](self.impl), gboolean(isImportant))

proc `isImportant=`*(self: ToolItem; isImportant: bool) =
  gtk_tool_item_set_is_important(cast[ptr ToolItem00](self.impl), gboolean(isImportant))

proc gtk_tool_item_set_proxy_menu_item(self: ptr ToolItem00; menuItemId: cstring;
    menuItem: ptr Widget00) {.
    importc, libprag.}

proc setProxyMenuItem*(self: ToolItem; menuItemId: cstring;
    menuItem: Widget = nil) =
  gtk_tool_item_set_proxy_menu_item(cast[ptr ToolItem00](self.impl), menuItemId, if menuItem.isNil: nil else: cast[ptr Widget00](menuItem.impl))

proc gtk_tool_item_set_tooltip_markup(self: ptr ToolItem00; markup: cstring) {.
    importc, libprag.}

proc setTooltipMarkup*(self: ToolItem; markup: cstring) =
  gtk_tool_item_set_tooltip_markup(cast[ptr ToolItem00](self.impl), markup)

proc `tooltipMarkup=`*(self: ToolItem; markup: cstring) =
  gtk_tool_item_set_tooltip_markup(cast[ptr ToolItem00](self.impl), markup)

proc gtk_tool_item_set_tooltip_text(self: ptr ToolItem00; text: cstring) {.
    importc, libprag.}

proc setTooltipText*(self: ToolItem; text: cstring) =
  gtk_tool_item_set_tooltip_text(cast[ptr ToolItem00](self.impl), text)

proc `tooltipText=`*(self: ToolItem; text: cstring) =
  gtk_tool_item_set_tooltip_text(cast[ptr ToolItem00](self.impl), text)

proc gtk_tool_item_set_use_drag_window(self: ptr ToolItem00; useDragWindow: gboolean) {.
    importc, libprag.}

proc setUseDragWindow*(self: ToolItem; useDragWindow: bool = true) =
  gtk_tool_item_set_use_drag_window(cast[ptr ToolItem00](self.impl), gboolean(useDragWindow))

proc `useDragWindow=`*(self: ToolItem; useDragWindow: bool) =
  gtk_tool_item_set_use_drag_window(cast[ptr ToolItem00](self.impl), gboolean(useDragWindow))

proc gtk_tool_item_set_visible_horizontal(self: ptr ToolItem00; visibleHorizontal: gboolean) {.
    importc, libprag.}

proc setVisibleHorizontal*(self: ToolItem; visibleHorizontal: bool = true) =
  gtk_tool_item_set_visible_horizontal(cast[ptr ToolItem00](self.impl), gboolean(visibleHorizontal))

proc `visibleHorizontal=`*(self: ToolItem; visibleHorizontal: bool) =
  gtk_tool_item_set_visible_horizontal(cast[ptr ToolItem00](self.impl), gboolean(visibleHorizontal))

proc gtk_tool_item_set_visible_vertical(self: ptr ToolItem00; visibleVertical: gboolean) {.
    importc, libprag.}

proc setVisibleVertical*(self: ToolItem; visibleVertical: bool = true) =
  gtk_tool_item_set_visible_vertical(cast[ptr ToolItem00](self.impl), gboolean(visibleVertical))

proc `visibleVertical=`*(self: ToolItem; visibleVertical: bool) =
  gtk_tool_item_set_visible_vertical(cast[ptr ToolItem00](self.impl), gboolean(visibleVertical))

proc gtk_tool_item_toolbar_reconfigured(self: ptr ToolItem00) {.
    importc, libprag.}

proc toolbarReconfigured*(self: ToolItem) =
  gtk_tool_item_toolbar_reconfigured(cast[ptr ToolItem00](self.impl))

type
  ToolButton* = ref object of ToolItem
  ToolButton00* = object of ToolItem00

proc gtk_tool_button_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ToolButton()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scClicked*(self: ToolButton;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "clicked", cast[GCallback](p), xdata, nil, cf)

proc gtk_tool_button_new(iconWidget: ptr Widget00; label: cstring): ptr ToolButton00 {.
    importc, libprag.}

proc newToolButton*(iconWidget: Widget = nil; label: cstring = nil): ToolButton =
  let gobj = gtk_tool_button_new(if iconWidget.isNil: nil else: cast[ptr Widget00](iconWidget.impl), label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newToolButton*(tdesc: typedesc; iconWidget: Widget = nil; label: cstring = nil): tdesc =
  assert(result is ToolButton)
  let gobj = gtk_tool_button_new(if iconWidget.isNil: nil else: cast[ptr Widget00](iconWidget.impl), label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initToolButton*[T](result: var T; iconWidget: Widget = nil; label: cstring = nil) {.deprecated.} =
  assert(result is ToolButton)
  let gobj = gtk_tool_button_new(if iconWidget.isNil: nil else: cast[ptr Widget00](iconWidget.impl), label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_tool_button_new_from_stock(stockId: cstring): ptr ToolButton00 {.
    importc, libprag.}

proc newToolButtonFromStock*(stockId: cstring): ToolButton {.deprecated.}  =
  let gobj = gtk_tool_button_new_from_stock(stockId)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newToolButtonFromStock*(tdesc: typedesc; stockId: cstring): tdesc {.deprecated.}  =
  assert(result is ToolButton)
  let gobj = gtk_tool_button_new_from_stock(stockId)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initToolButtonFromStock*[T](result: var T; stockId: cstring) {.deprecated.} =
  assert(result is ToolButton)
  let gobj = gtk_tool_button_new_from_stock(stockId)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_tool_button_get_icon_name(self: ptr ToolButton00): cstring {.
    importc, libprag.}

proc getIconName*(self: ToolButton): string =
  let resul0 = gtk_tool_button_get_icon_name(cast[ptr ToolButton00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc iconName*(self: ToolButton): string =
  let resul0 = gtk_tool_button_get_icon_name(cast[ptr ToolButton00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc gtk_tool_button_get_icon_widget(self: ptr ToolButton00): ptr Widget00 {.
    importc, libprag.}

proc getIconWidget*(self: ToolButton): Widget =
  let gobj = gtk_tool_button_get_icon_widget(cast[ptr ToolButton00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc iconWidget*(self: ToolButton): Widget =
  let gobj = gtk_tool_button_get_icon_widget(cast[ptr ToolButton00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_tool_button_get_label(self: ptr ToolButton00): cstring {.
    importc, libprag.}

proc getLabel*(self: ToolButton): string =
  let resul0 = gtk_tool_button_get_label(cast[ptr ToolButton00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc label*(self: ToolButton): string =
  let resul0 = gtk_tool_button_get_label(cast[ptr ToolButton00](self.impl))
  if resul0.isNil:
    return
  result = $resul0

proc gtk_tool_button_get_label_widget(self: ptr ToolButton00): ptr Widget00 {.
    importc, libprag.}

proc getLabelWidget*(self: ToolButton): Widget =
  let gobj = gtk_tool_button_get_label_widget(cast[ptr ToolButton00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc labelWidget*(self: ToolButton): Widget =
  let gobj = gtk_tool_button_get_label_widget(cast[ptr ToolButton00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_tool_button_get_stock_id(self: ptr ToolButton00): cstring {.
    importc, libprag.}

proc getStockId*(self: ToolButton): string =
  result = $gtk_tool_button_get_stock_id(cast[ptr ToolButton00](self.impl))

proc stockId*(self: ToolButton): string =
  result = $gtk_tool_button_get_stock_id(cast[ptr ToolButton00](self.impl))

proc gtk_tool_button_get_use_underline(self: ptr ToolButton00): gboolean {.
    importc, libprag.}

proc getUseUnderline*(self: ToolButton): bool =
  toBool(gtk_tool_button_get_use_underline(cast[ptr ToolButton00](self.impl)))

proc useUnderline*(self: ToolButton): bool =
  toBool(gtk_tool_button_get_use_underline(cast[ptr ToolButton00](self.impl)))

proc gtk_tool_button_set_icon_name(self: ptr ToolButton00; iconName: cstring) {.
    importc, libprag.}

proc setIconName*(self: ToolButton; iconName: cstring = nil) =
  gtk_tool_button_set_icon_name(cast[ptr ToolButton00](self.impl), iconName)

proc `iconName=`*(self: ToolButton; iconName: cstring = nil) =
  gtk_tool_button_set_icon_name(cast[ptr ToolButton00](self.impl), iconName)

proc gtk_tool_button_set_icon_widget(self: ptr ToolButton00; iconWidget: ptr Widget00) {.
    importc, libprag.}

proc setIconWidget*(self: ToolButton; iconWidget: Widget = nil) =
  gtk_tool_button_set_icon_widget(cast[ptr ToolButton00](self.impl), if iconWidget.isNil: nil else: cast[ptr Widget00](iconWidget.impl))

proc `iconWidget=`*(self: ToolButton; iconWidget: Widget = nil) =
  gtk_tool_button_set_icon_widget(cast[ptr ToolButton00](self.impl), if iconWidget.isNil: nil else: cast[ptr Widget00](iconWidget.impl))

proc gtk_tool_button_set_label(self: ptr ToolButton00; label: cstring) {.
    importc, libprag.}

proc setLabel*(self: ToolButton; label: cstring = nil) =
  gtk_tool_button_set_label(cast[ptr ToolButton00](self.impl), label)

proc `label=`*(self: ToolButton; label: cstring = nil) =
  gtk_tool_button_set_label(cast[ptr ToolButton00](self.impl), label)

proc gtk_tool_button_set_label_widget(self: ptr ToolButton00; labelWidget: ptr Widget00) {.
    importc, libprag.}

proc setLabelWidget*(self: ToolButton; labelWidget: Widget = nil) =
  gtk_tool_button_set_label_widget(cast[ptr ToolButton00](self.impl), if labelWidget.isNil: nil else: cast[ptr Widget00](labelWidget.impl))

proc `labelWidget=`*(self: ToolButton; labelWidget: Widget = nil) =
  gtk_tool_button_set_label_widget(cast[ptr ToolButton00](self.impl), if labelWidget.isNil: nil else: cast[ptr Widget00](labelWidget.impl))

proc gtk_tool_button_set_stock_id(self: ptr ToolButton00; stockId: cstring) {.
    importc, libprag.}

proc setStockId*(self: ToolButton; stockId: cstring = nil) =
  gtk_tool_button_set_stock_id(cast[ptr ToolButton00](self.impl), stockId)

proc `stockId=`*(self: ToolButton; stockId: cstring = nil) =
  gtk_tool_button_set_stock_id(cast[ptr ToolButton00](self.impl), stockId)

proc gtk_tool_button_set_use_underline(self: ptr ToolButton00; useUnderline: gboolean) {.
    importc, libprag.}

proc setUseUnderline*(self: ToolButton; useUnderline: bool = true) =
  gtk_tool_button_set_use_underline(cast[ptr ToolButton00](self.impl), gboolean(useUnderline))

proc `useUnderline=`*(self: ToolButton; useUnderline: bool) =
  gtk_tool_button_set_use_underline(cast[ptr ToolButton00](self.impl), gboolean(useUnderline))

type
  ToggleToolButton* = ref object of ToolButton
  ToggleToolButton00* = object of ToolButton00

proc gtk_toggle_tool_button_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ToggleToolButton()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scToggled*(self: ToggleToolButton;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "toggled", cast[GCallback](p), xdata, nil, cf)

proc gtk_toggle_tool_button_new(): ptr ToggleToolButton00 {.
    importc, libprag.}

proc newToggleToolButton*(): ToggleToolButton =
  let gobj = gtk_toggle_tool_button_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newToggleToolButton*(tdesc: typedesc): tdesc =
  assert(result is ToggleToolButton)
  let gobj = gtk_toggle_tool_button_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initToggleToolButton*[T](result: var T) {.deprecated.} =
  assert(result is ToggleToolButton)
  let gobj = gtk_toggle_tool_button_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_toggle_tool_button_new_from_stock(stockId: cstring): ptr ToggleToolButton00 {.
    importc, libprag.}

proc newToggleToolButtonFromStock*(stockId: cstring): ToggleToolButton {.deprecated.}  =
  let gobj = gtk_toggle_tool_button_new_from_stock(stockId)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newToggleToolButtonFromStock*(tdesc: typedesc; stockId: cstring): tdesc {.deprecated.}  =
  assert(result is ToggleToolButton)
  let gobj = gtk_toggle_tool_button_new_from_stock(stockId)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initToggleToolButtonFromStock*[T](result: var T; stockId: cstring) {.deprecated.} =
  assert(result is ToggleToolButton)
  let gobj = gtk_toggle_tool_button_new_from_stock(stockId)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_toggle_tool_button_get_active(self: ptr ToggleToolButton00): gboolean {.
    importc, libprag.}

proc getActive*(self: ToggleToolButton): bool =
  toBool(gtk_toggle_tool_button_get_active(cast[ptr ToggleToolButton00](self.impl)))

proc active*(self: ToggleToolButton): bool =
  toBool(gtk_toggle_tool_button_get_active(cast[ptr ToggleToolButton00](self.impl)))

proc gtk_toggle_tool_button_set_active(self: ptr ToggleToolButton00; isActive: gboolean) {.
    importc, libprag.}

proc setActive*(self: ToggleToolButton; isActive: bool = true) =
  gtk_toggle_tool_button_set_active(cast[ptr ToggleToolButton00](self.impl), gboolean(isActive))

proc `active=`*(self: ToggleToolButton; isActive: bool) =
  gtk_toggle_tool_button_set_active(cast[ptr ToggleToolButton00](self.impl), gboolean(isActive))

type
  ModelButton* = ref object of Button
  ModelButton00* = object of Button00

proc gtk_model_button_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ModelButton()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_model_button_new(): ptr ModelButton00 {.
    importc, libprag.}

proc newModelButton*(): ModelButton =
  let gobj = gtk_model_button_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newModelButton*(tdesc: typedesc): tdesc =
  assert(result is ModelButton)
  let gobj = gtk_model_button_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initModelButton*[T](result: var T) {.deprecated.} =
  assert(result is ModelButton)
  let gobj = gtk_model_button_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  ScaleButton* = ref object of Button
  ScaleButton00* = object of Button00

proc gtk_scale_button_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ScaleButton()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scPopdown*(self: ScaleButton;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "popdown", cast[GCallback](p), xdata, nil, cf)

proc scPopup*(self: ScaleButton;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "popup", cast[GCallback](p), xdata, nil, cf)

proc scValueChanged*(self: ScaleButton;  p: proc (self: ptr ScaleButton00; value: cdouble; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "value-changed", cast[GCallback](p), xdata, nil, cf)

proc gtk_scale_button_new(size: int32; min: cdouble; max: cdouble; step: cdouble;
    icons: ptr cstring): ptr ScaleButton00 {.
    importc, libprag.}

proc newScaleButton*(size: int; min: cdouble; max: cdouble; step: cdouble;
    icons: varargs[string, `$`]): ScaleButton =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  let gobj = gtk_scale_button_new(int32(size), min, max, step, seq2CstringArray(icons, fs469n23))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newScaleButton*(tdesc: typedesc; size: int; min: cdouble; max: cdouble; step: cdouble;
    icons: varargs[string, `$`]): tdesc =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  assert(result is ScaleButton)
  let gobj = gtk_scale_button_new(int32(size), min, max, step, seq2CstringArray(icons, fs469n23))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initScaleButton*[T](result: var T; size: int; min: cdouble; max: cdouble; step: cdouble;
    icons: varargs[string, `$`]) {.deprecated.} =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  assert(result is ScaleButton)
  let gobj = gtk_scale_button_new(int32(size), min, max, step, seq2CstringArray(icons, fs469n23))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_scale_button_get_adjustment(self: ptr ScaleButton00): ptr Adjustment00 {.
    importc, libprag.}

proc getAdjustment*(self: ScaleButton): Adjustment =
  let gobj = gtk_scale_button_get_adjustment(cast[ptr ScaleButton00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc adjustment*(self: ScaleButton): Adjustment =
  let gobj = gtk_scale_button_get_adjustment(cast[ptr ScaleButton00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_scale_button_get_minus_button(self: ptr ScaleButton00): ptr Button00 {.
    importc, libprag.}

proc getMinusButton*(self: ScaleButton): Button =
  let gobj = gtk_scale_button_get_minus_button(cast[ptr ScaleButton00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc minusButton*(self: ScaleButton): Button =
  let gobj = gtk_scale_button_get_minus_button(cast[ptr ScaleButton00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_scale_button_get_plus_button(self: ptr ScaleButton00): ptr Button00 {.
    importc, libprag.}

proc getPlusButton*(self: ScaleButton): Button =
  let gobj = gtk_scale_button_get_plus_button(cast[ptr ScaleButton00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc plusButton*(self: ScaleButton): Button =
  let gobj = gtk_scale_button_get_plus_button(cast[ptr ScaleButton00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_scale_button_get_popup(self: ptr ScaleButton00): ptr Widget00 {.
    importc, libprag.}

proc getPopup*(self: ScaleButton): Widget =
  let gobj = gtk_scale_button_get_popup(cast[ptr ScaleButton00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc popup*(self: ScaleButton): Widget =
  let gobj = gtk_scale_button_get_popup(cast[ptr ScaleButton00](self.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_scale_button_get_value(self: ptr ScaleButton00): cdouble {.
    importc, libprag.}

proc getValue*(self: ScaleButton): cdouble =
  gtk_scale_button_get_value(cast[ptr ScaleButton00](self.impl))

proc value*(self: ScaleButton): cdouble =
  gtk_scale_button_get_value(cast[ptr ScaleButton00](self.impl))

proc gtk_scale_button_set_adjustment(self: ptr ScaleButton00; adjustment: ptr Adjustment00) {.
    importc, libprag.}

proc setAdjustment*(self: ScaleButton; adjustment: Adjustment) =
  gtk_scale_button_set_adjustment(cast[ptr ScaleButton00](self.impl), cast[ptr Adjustment00](adjustment.impl))

proc `adjustment=`*(self: ScaleButton; adjustment: Adjustment) =
  gtk_scale_button_set_adjustment(cast[ptr ScaleButton00](self.impl), cast[ptr Adjustment00](adjustment.impl))

proc gtk_scale_button_set_icons(self: ptr ScaleButton00; icons: ptr cstring) {.
    importc, libprag.}

proc setIcons*(self: ScaleButton; icons: varargs[string, `$`]) =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  gtk_scale_button_set_icons(cast[ptr ScaleButton00](self.impl), seq2CstringArray(icons, fs469n23))

proc `icons=`*(self: ScaleButton; icons: varargs[string, `$`]) =
  var fs469n23x: array[256, pointer]
  var fs469n23: cstringArray = cast[cstringArray](addr fs469n23x)
  gtk_scale_button_set_icons(cast[ptr ScaleButton00](self.impl), seq2CstringArray(icons, fs469n23))

proc gtk_scale_button_set_value(self: ptr ScaleButton00; value: cdouble) {.
    importc, libprag.}

proc setValue*(self: ScaleButton; value: cdouble) =
  gtk_scale_button_set_value(cast[ptr ScaleButton00](self.impl), value)

proc `value=`*(self: ScaleButton; value: cdouble) =
  gtk_scale_button_set_value(cast[ptr ScaleButton00](self.impl), value)

type
  Switch* = ref object of Widget
  Switch00* = object of Widget00

proc gtk_switch_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(Switch()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scActivate*(self: Switch;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "activate", cast[GCallback](p), xdata, nil, cf)

proc scStateSet*(self: Switch;  p: proc (self: ptr Switch00; state: gboolean; xdata: pointer): gboolean {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "state-set", cast[GCallback](p), xdata, nil, cf)

proc gtk_switch_new(): ptr Switch00 {.
    importc, libprag.}

proc newSwitch*(): Switch =
  let gobj = gtk_switch_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newSwitch*(tdesc: typedesc): tdesc =
  assert(result is Switch)
  let gobj = gtk_switch_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initSwitch*[T](result: var T) {.deprecated.} =
  assert(result is Switch)
  let gobj = gtk_switch_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_switch_get_active(self: ptr Switch00): gboolean {.
    importc, libprag.}

proc getActive*(self: Switch): bool =
  toBool(gtk_switch_get_active(cast[ptr Switch00](self.impl)))

proc active*(self: Switch): bool =
  toBool(gtk_switch_get_active(cast[ptr Switch00](self.impl)))

proc gtk_switch_get_state(self: ptr Switch00): gboolean {.
    importc, libprag.}

proc getState*(self: Switch): bool =
  toBool(gtk_switch_get_state(cast[ptr Switch00](self.impl)))

proc state*(self: Switch): bool =
  toBool(gtk_switch_get_state(cast[ptr Switch00](self.impl)))

proc gtk_switch_set_active(self: ptr Switch00; isActive: gboolean) {.
    importc, libprag.}

proc setActive*(self: Switch; isActive: bool = true) =
  gtk_switch_set_active(cast[ptr Switch00](self.impl), gboolean(isActive))

proc `active=`*(self: Switch; isActive: bool) =
  gtk_switch_set_active(cast[ptr Switch00](self.impl), gboolean(isActive))

proc gtk_switch_set_state(self: ptr Switch00; state: gboolean) {.
    importc, libprag.}

proc setState*(self: Switch; state: bool = true) =
  gtk_switch_set_state(cast[ptr Switch00](self.impl), gboolean(state))

proc `state=`*(self: Switch; state: bool) =
  gtk_switch_set_state(cast[ptr Switch00](self.impl), gboolean(state))

type
  RadioToolButton* = ref object of ToggleToolButton
  RadioToolButton00* = object of ToggleToolButton00

proc gtk_radio_tool_button_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(RadioToolButton()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc gtk_radio_tool_button_new_from_widget(group: ptr RadioToolButton00): ptr RadioToolButton00 {.
    importc, libprag.}

proc newRadioToolButtonFromWidget*(group: RadioToolButton = nil): RadioToolButton =
  let gobj = gtk_radio_tool_button_new_from_widget(if group.isNil: nil else: cast[ptr RadioToolButton00](group.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newRadioToolButtonFromWidget*(tdesc: typedesc; group: RadioToolButton = nil): tdesc =
  assert(result is RadioToolButton)
  let gobj = gtk_radio_tool_button_new_from_widget(if group.isNil: nil else: cast[ptr RadioToolButton00](group.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initRadioToolButtonFromWidget*[T](result: var T; group: RadioToolButton = nil) {.deprecated.} =
  assert(result is RadioToolButton)
  let gobj = gtk_radio_tool_button_new_from_widget(if group.isNil: nil else: cast[ptr RadioToolButton00](group.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_radio_tool_button_new_with_stock_from_widget(group: ptr RadioToolButton00;
    stockId: cstring): ptr RadioToolButton00 {.
    importc, libprag.}

proc newRadioToolButtonWithStockFromWidget*(group: RadioToolButton = nil;
    stockId: cstring): RadioToolButton {.deprecated.}  =
  let gobj = gtk_radio_tool_button_new_with_stock_from_widget(if group.isNil: nil else: cast[ptr RadioToolButton00](group.impl), stockId)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newRadioToolButtonWithStockFromWidget*(tdesc: typedesc; group: RadioToolButton = nil;
    stockId: cstring): tdesc {.deprecated.}  =
  assert(result is RadioToolButton)
  let gobj = gtk_radio_tool_button_new_with_stock_from_widget(if group.isNil: nil else: cast[ptr RadioToolButton00](group.impl), stockId)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initRadioToolButtonWithStockFromWidget*[T](result: var T; group: RadioToolButton = nil;
    stockId: cstring) {.deprecated.} =
  assert(result is RadioToolButton)
  let gobj = gtk_radio_tool_button_new_with_stock_from_widget(if group.isNil: nil else: cast[ptr RadioToolButton00](group.impl), stockId)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

type
  ListBoxRow* = ref object of Bin
  ListBoxRow00* = object of Bin00

proc gtk_list_box_row_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ListBoxRow()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scActivate*(self: ListBoxRow;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "activate", cast[GCallback](p), xdata, nil, cf)

proc gtk_list_box_row_new(): ptr ListBoxRow00 {.
    importc, libprag.}

proc newListBoxRow*(): ListBoxRow =
  let gobj = gtk_list_box_row_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newListBoxRow*(tdesc: typedesc): tdesc =
  assert(result is ListBoxRow)
  let gobj = gtk_list_box_row_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initListBoxRow*[T](result: var T) {.deprecated.} =
  assert(result is ListBoxRow)
  let gobj = gtk_list_box_row_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_list_box_row_changed(self: ptr ListBoxRow00) {.
    importc, libprag.}

proc changed*(self: ListBoxRow) =
  gtk_list_box_row_changed(cast[ptr ListBoxRow00](self.impl))

proc gtk_list_box_row_get_activatable(self: ptr ListBoxRow00): gboolean {.
    importc, libprag.}

proc getActivatable*(self: ListBoxRow): bool =
  toBool(gtk_list_box_row_get_activatable(cast[ptr ListBoxRow00](self.impl)))

proc activatable*(self: ListBoxRow): bool =
  toBool(gtk_list_box_row_get_activatable(cast[ptr ListBoxRow00](self.impl)))

proc gtk_list_box_row_get_header(self: ptr ListBoxRow00): ptr Widget00 {.
    importc, libprag.}

proc getHeader*(self: ListBoxRow): Widget =
  let gobj = gtk_list_box_row_get_header(cast[ptr ListBoxRow00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc header*(self: ListBoxRow): Widget =
  let gobj = gtk_list_box_row_get_header(cast[ptr ListBoxRow00](self.impl))
  if gobj.isNil:
    return nil
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_list_box_row_get_index(self: ptr ListBoxRow00): int32 {.
    importc, libprag.}

proc getIndex*(self: ListBoxRow): int =
  int(gtk_list_box_row_get_index(cast[ptr ListBoxRow00](self.impl)))

proc index*(self: ListBoxRow): int =
  int(gtk_list_box_row_get_index(cast[ptr ListBoxRow00](self.impl)))

proc gtk_list_box_row_get_selectable(self: ptr ListBoxRow00): gboolean {.
    importc, libprag.}

proc getSelectable*(self: ListBoxRow): bool =
  toBool(gtk_list_box_row_get_selectable(cast[ptr ListBoxRow00](self.impl)))

proc selectable*(self: ListBoxRow): bool =
  toBool(gtk_list_box_row_get_selectable(cast[ptr ListBoxRow00](self.impl)))

proc gtk_list_box_row_is_selected(self: ptr ListBoxRow00): gboolean {.
    importc, libprag.}

proc isSelected*(self: ListBoxRow): bool =
  toBool(gtk_list_box_row_is_selected(cast[ptr ListBoxRow00](self.impl)))

proc gtk_list_box_row_set_activatable(self: ptr ListBoxRow00; activatable: gboolean) {.
    importc, libprag.}

proc setActivatable*(self: ListBoxRow; activatable: bool = true) =
  gtk_list_box_row_set_activatable(cast[ptr ListBoxRow00](self.impl), gboolean(activatable))

proc `activatable=`*(self: ListBoxRow; activatable: bool) =
  gtk_list_box_row_set_activatable(cast[ptr ListBoxRow00](self.impl), gboolean(activatable))

proc gtk_list_box_row_set_header(self: ptr ListBoxRow00; header: ptr Widget00) {.
    importc, libprag.}

proc setHeader*(self: ListBoxRow; header: Widget = nil) =
  gtk_list_box_row_set_header(cast[ptr ListBoxRow00](self.impl), if header.isNil: nil else: cast[ptr Widget00](header.impl))

proc `header=`*(self: ListBoxRow; header: Widget = nil) =
  gtk_list_box_row_set_header(cast[ptr ListBoxRow00](self.impl), if header.isNil: nil else: cast[ptr Widget00](header.impl))

proc gtk_list_box_row_set_selectable(self: ptr ListBoxRow00; selectable: gboolean) {.
    importc, libprag.}

proc setSelectable*(self: ListBoxRow; selectable: bool = true) =
  gtk_list_box_row_set_selectable(cast[ptr ListBoxRow00](self.impl), gboolean(selectable))

proc `selectable=`*(self: ListBoxRow; selectable: bool) =
  gtk_list_box_row_set_selectable(cast[ptr ListBoxRow00](self.impl), gboolean(selectable))

type
  ColorButton* = ref object of Button
  ColorButton00* = object of Button00

proc gtk_color_button_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(ColorButton()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scColorSet*(self: ColorButton;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "color-set", cast[GCallback](p), xdata, nil, cf)

proc gtk_color_button_new(): ptr ColorButton00 {.
    importc, libprag.}

proc newColorButton*(): ColorButton =
  let gobj = gtk_color_button_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newColorButton*(tdesc: typedesc): tdesc =
  assert(result is ColorButton)
  let gobj = gtk_color_button_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initColorButton*[T](result: var T) {.deprecated.} =
  assert(result is ColorButton)
  let gobj = gtk_color_button_new()
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_color_button_new_with_color(color: gdk.Color): ptr ColorButton00 {.
    importc, libprag.}

proc newColorButtonWithColor*(color: gdk.Color): ColorButton {.deprecated.}  =
  let gobj = gtk_color_button_new_with_color(color)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newColorButtonWithColor*(tdesc: typedesc; color: gdk.Color): tdesc {.deprecated.}  =
  assert(result is ColorButton)
  let gobj = gtk_color_button_new_with_color(color)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initColorButtonWithColor*[T](result: var T; color: gdk.Color) {.deprecated.} =
  assert(result is ColorButton)
  let gobj = gtk_color_button_new_with_color(color)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_color_button_new_with_rgba(rgba: gdk.RGBA): ptr ColorButton00 {.
    importc, libprag.}

proc newColorButtonWithRgba*(rgba: gdk.RGBA): ColorButton =
  let gobj = gtk_color_button_new_with_rgba(rgba)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newColorButtonWithRgba*(tdesc: typedesc; rgba: gdk.RGBA): tdesc =
  assert(result is ColorButton)
  let gobj = gtk_color_button_new_with_rgba(rgba)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initColorButtonWithRgba*[T](result: var T; rgba: gdk.RGBA) {.deprecated.} =
  assert(result is ColorButton)
  let gobj = gtk_color_button_new_with_rgba(rgba)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_color_button_get_alpha(self: ptr ColorButton00): uint16 {.
    importc, libprag.}

proc getAlpha*(self: ColorButton): uint16 =
  gtk_color_button_get_alpha(cast[ptr ColorButton00](self.impl))

proc alpha*(self: ColorButton): uint16 =
  gtk_color_button_get_alpha(cast[ptr ColorButton00](self.impl))

proc gtk_color_button_get_color(self: ptr ColorButton00; color: var gdk.Color) {.
    importc, libprag.}

proc getColor*(self: ColorButton; color: var gdk.Color) =
  gtk_color_button_get_color(cast[ptr ColorButton00](self.impl), color)

proc getColor*(self: ColorButton): gdk.Color =
  gtk_color_button_get_color(cast[ptr ColorButton00](self.impl), result)

proc gtk_color_button_get_title(self: ptr ColorButton00): cstring {.
    importc, libprag.}

proc getTitle*(self: ColorButton): string =
  result = $gtk_color_button_get_title(cast[ptr ColorButton00](self.impl))

proc title*(self: ColorButton): string =
  result = $gtk_color_button_get_title(cast[ptr ColorButton00](self.impl))

proc gtk_color_button_get_use_alpha(self: ptr ColorButton00): gboolean {.
    importc, libprag.}

proc getUseAlpha*(self: ColorButton): bool =
  toBool(gtk_color_button_get_use_alpha(cast[ptr ColorButton00](self.impl)))

proc useAlpha*(self: ColorButton): bool =
  toBool(gtk_color_button_get_use_alpha(cast[ptr ColorButton00](self.impl)))

proc gtk_color_button_set_alpha(self: ptr ColorButton00; alpha: uint16) {.
    importc, libprag.}

proc setAlpha*(self: ColorButton; alpha: uint16) =
  gtk_color_button_set_alpha(cast[ptr ColorButton00](self.impl), alpha)

proc `alpha=`*(self: ColorButton; alpha: uint16) =
  gtk_color_button_set_alpha(cast[ptr ColorButton00](self.impl), alpha)

proc gtk_color_button_set_color(self: ptr ColorButton00; color: gdk.Color) {.
    importc, libprag.}

proc setColor*(self: ColorButton; color: gdk.Color) =
  gtk_color_button_set_color(cast[ptr ColorButton00](self.impl), color)

proc `color=`*(self: ColorButton; color: gdk.Color) =
  gtk_color_button_set_color(cast[ptr ColorButton00](self.impl), color)

proc gtk_color_button_set_title(self: ptr ColorButton00; title: cstring) {.
    importc, libprag.}

proc setTitle*(self: ColorButton; title: cstring) =
  gtk_color_button_set_title(cast[ptr ColorButton00](self.impl), title)

proc `title=`*(self: ColorButton; title: cstring) =
  gtk_color_button_set_title(cast[ptr ColorButton00](self.impl), title)

proc gtk_color_button_set_use_alpha(self: ptr ColorButton00; useAlpha: gboolean) {.
    importc, libprag.}

proc setUseAlpha*(self: ColorButton; useAlpha: bool = true) =
  gtk_color_button_set_use_alpha(cast[ptr ColorButton00](self.impl), gboolean(useAlpha))

proc `useAlpha=`*(self: ColorButton; useAlpha: bool) =
  gtk_color_button_set_use_alpha(cast[ptr ColorButton00](self.impl), gboolean(useAlpha))

type
  RadioButton* = ref object of CheckButton
  RadioButton00* = object of CheckButton00

proc gtk_radio_button_get_type*(): GType {.importc, libprag.}

when defined(gcDestructors):
  proc `=destroy`*(self: var typeof(RadioButton()[])) =
    when defined(gintroDebug):
      echo "destroy ", $typeof(self), ' ', cast[int](unsafeaddr self)
    g_object_set_qdata(self.impl, Quark, nil)
    if not self.ignoreFinalizer and self.impl != nil:
      g_object_remove_toggle_ref(self.impl, toggleNotify, addr(self))
      self.impl = nil

proc scGroupChanged*(self: RadioButton;  p: proc (self: ptr gobject.Object00; xdata: pointer) {.cdecl.}, xdata: pointer, cf: gobject.ConnectFlags): culong =
  g_signal_connect_data(self.impl, "group-changed", cast[GCallback](p), xdata, nil, cf)

proc gtk_radio_button_new(group: ptr glib.SList): ptr RadioButton00 {.
    importc, libprag.}

proc newRadioButton*(group: seq[RadioButton]): RadioButton =
  var tempResGL = seq2GSList(group)
  let gobj = gtk_radio_button_new(tempResGL)
  g_slist_free(tempResGL)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newRadioButton*(tdesc: typedesc; group: seq[RadioButton]): tdesc =
  assert(result is RadioButton)
  var tempResGL = seq2GSList(group)
  let gobj = gtk_radio_button_new(tempResGL)
  g_slist_free(tempResGL)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initRadioButton*[T](result: var T; group: seq[RadioButton]) {.deprecated.} =
  assert(result is RadioButton)
  var tempResGL = seq2GSList(group)
  let gobj = gtk_radio_button_new(tempResGL)
  g_slist_free(tempResGL)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_radio_button_new_from_widget(radioGroupMember: ptr RadioButton00): ptr RadioButton00 {.
    importc, libprag.}

proc newRadioButtonFromWidget*(radioGroupMember: RadioButton = nil): RadioButton =
  let gobj = gtk_radio_button_new_from_widget(if radioGroupMember.isNil: nil else: cast[ptr RadioButton00](radioGroupMember.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newRadioButtonFromWidget*(tdesc: typedesc; radioGroupMember: RadioButton = nil): tdesc =
  assert(result is RadioButton)
  let gobj = gtk_radio_button_new_from_widget(if radioGroupMember.isNil: nil else: cast[ptr RadioButton00](radioGroupMember.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initRadioButtonFromWidget*[T](result: var T; radioGroupMember: RadioButton = nil) {.deprecated.} =
  assert(result is RadioButton)
  let gobj = gtk_radio_button_new_from_widget(if radioGroupMember.isNil: nil else: cast[ptr RadioButton00](radioGroupMember.impl))
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_radio_button_new_with_label(group: ptr glib.SList; label: cstring): ptr RadioButton00 {.
    importc, libprag.}

proc newRadioButtonWithLabel*(group: seq[RadioButton]; label: cstring): RadioButton =
  var tempResGL = seq2GSList(group)
  let gobj = gtk_radio_button_new_with_label(tempResGL, label)
  g_slist_free(tempResGL)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newRadioButtonWithLabel*(tdesc: typedesc; group: seq[RadioButton]; label: cstring): tdesc =
  assert(result is RadioButton)
  var tempResGL = seq2GSList(group)
  let gobj = gtk_radio_button_new_with_label(tempResGL, label)
  g_slist_free(tempResGL)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initRadioButtonWithLabel*[T](result: var T; group: seq[RadioButton]; label: cstring) {.deprecated.} =
  assert(result is RadioButton)
  var tempResGL = seq2GSList(group)
  let gobj = gtk_radio_button_new_with_label(tempResGL, label)
  g_slist_free(tempResGL)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_radio_button_new_with_label_from_widget(radioGroupMember: ptr RadioButton00;
    label: cstring): ptr RadioButton00 {.
    importc, libprag.}

proc newRadioButtonWithLabelFromWidget*(radioGroupMember: RadioButton = nil;
    label: cstring): RadioButton =
  let gobj = gtk_radio_button_new_with_label_from_widget(if radioGroupMember.isNil: nil else: cast[ptr RadioButton00](radioGroupMember.impl), label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newRadioButtonWithLabelFromWidget*(tdesc: typedesc; radioGroupMember: RadioButton = nil;
    label: cstring): tdesc =
  assert(result is RadioButton)
  let gobj = gtk_radio_button_new_with_label_from_widget(if radioGroupMember.isNil: nil else: cast[ptr RadioButton00](radioGroupMember.impl), label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initRadioButtonWithLabelFromWidget*[T](result: var T; radioGroupMember: RadioButton = nil;
    label: cstring) {.deprecated.} =
  assert(result is RadioButton)
  let gobj = gtk_radio_button_new_with_label_from_widget(if radioGroupMember.isNil: nil else: cast[ptr RadioButton00](radioGroupMember.impl), label)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc gtk_radio_button_new_with_mnemonic(group: ptr glib.SList; label: cstring): ptr RadioButton00 {.
    importc, libprag.}

proc newRadioButtonWithMnemonic*(group: seq[RadioButton]; label: cstring): RadioButton =
  var tempResGL = seq2GSList(group)
  let gobj = gtk_radio_button_new_with_mnemonic(tempResGL, label)
  g_slist_free(tempResGL)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc newRadioButtonWithMnemonic*(tdesc: typedesc; group: seq[RadioButton]; label: cstring): tdesc =
  assert(result is RadioButton)
  var tempResGL = seq2GSList(group)
  let gobj = gtk_radio_button_new_with_mnemonic(tempResGL, label)
  g_slist_free(tempResGL)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    GC_ref(result)
    discard g_object_ref_sink(result.impl)
    g_object_add_toggle_ref(result.impl, toggleNotify, addr(result[]))
    g_object_unref(result.impl)
    assert(g_object_get_qdata(result.impl, Quark) == nil)
    g_object_set_qdata(result.impl, Quark, addr(result[]))

proc initRadioButtonWithMnemonic*[T](result: var T; group: seq[RadioButton]; label: cstring) {.deprecated.} =
  assert(result is RadioButton)
  var tempResGL = seq2GSList(group)
  let gobj = gtk_radio_button_new_with_mnemonic(tempResGL, label)
  g_slist_free(tempResGL)
  let qdata = g_object_get_qdata(gobj, Quark)
  if qdata != nil:
    result = cast[type(result)](qdata)
    assert(result.impl == gobj)
  else:
    fnew(result, gtk.finalizeGObject)
    result.impl = gobj
    