#include "mixerhandle.h"
#include "elddisp.h"
#include "rmixcheckbox.h"
#include "rmixenumbox.h"
#include "rmixnumspin.h"
#include "rmixslider.h"
#include "t5disp.h"

mixerHandle::mixerHandle(ushort card) {
	snd_hctl_open(&m_hctl, ("hw:" + std::to_string(card)).c_str(), SND_CTL_NONBLOCK);
	snd_hctl_load(m_hctl);
	m_ctl= snd_hctl_ctl(m_hctl);
	m_elemCount= snd_hctl_get_count(m_hctl);
	snd_hctl_poll_descriptors(m_hctl, &m_pollfd, 1);
}

mixerHandle::~mixerHandle() {
	snd_hctl_close(m_hctl);
}

void mixerHandle::updat() {
	if(poll(&m_pollfd, 1, 20))
		snd_hctl_handle_events(m_hctl);
}

int callback(snd_hctl_elem_t *elem, unsigned int mask) {
	mixerHandle::callbackData *cbd= (mixerHandle::callbackData *)snd_hctl_elem_get_callback_private(elem);
	if(cbd->type == mixerHandle::CB)
	{
		rmixCheckBox *w= (rmixCheckBox *)cbd->widget;
		w->updat();
	} else if(cbd->type == mixerHandle::SL)
	{
		rmixSlider *w= (rmixSlider *)cbd->widget;
		w->updat();
	} else if(cbd->type == mixerHandle::EB)
	{
		rmixEnumBox *w= (rmixEnumBox *)cbd->widget;
		w->updat();
	} else if(cbd->type == mixerHandle::NS)
	{
		rmixNumSpin *w= (rmixNumSpin *)cbd->widget;
		w->updat();
	} else if(cbd->type == mixerHandle::T5)
	{
		t5Disp *w= (t5Disp *)cbd->widget;
		w->updat();
	} else if(cbd->type == mixerHandle::EL)
	{
		eldDisp *w= (eldDisp *)cbd->widget;
		w->updat();
	}
	return 0;
}
