/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.SubnetDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeSubnets
extends BaseCmd {
    public DescribeSubnets(String[] args) {
        super("ec2dsubnet", "ec2-describe-subnets");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "[ SUBNET ... ] [SPECIFIC OPTIONS]";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)this.joinDescription("Add a filter criterion for the result-set."));
        options.addOption(OptionBuilder.create((String)"F"));
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Gives you information about your subnets. The SUBNET parameters, if");
        System.out.println("     specified, are the IDs of the subnets to describe.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("filter");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair rsp = jec2.describeSubnets(this.getFilterMap(true), this.getNonOptions());
        for (SubnetDescription subnet : (List)rsp.getResponse()) {
            out.output(System.out, subnet);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new DescribeSubnets(args).invoke();
    }
}

