/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.gson;

import java.math.BigInteger;
import org.jetbrains.kotlin.com.google.gson.JsonElement;
import org.jetbrains.kotlin.com.google.gson.internal.$Gson$Preconditions;
import org.jetbrains.kotlin.com.google.gson.internal.LazilyParsedNumber;

public final class JsonPrimitive
extends JsonElement {
    private final Object value;

    public JsonPrimitive(Boolean bool2) {
        this.value = $Gson$Preconditions.checkNotNull(bool2);
    }

    public JsonPrimitive(Number number2) {
        this.value = $Gson$Preconditions.checkNotNull(number2);
    }

    public JsonPrimitive(String string2) {
        this.value = $Gson$Preconditions.checkNotNull(string2);
    }

    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    @Override
    public boolean getAsBoolean() {
        if (this.isBoolean()) {
            return (Boolean)this.value;
        }
        return Boolean.parseBoolean(this.getAsString());
    }

    public boolean isNumber() {
        return this.value instanceof Number;
    }

    @Override
    public Number getAsNumber() {
        return this.value instanceof String ? new LazilyParsedNumber((String)this.value) : (Number)this.value;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    @Override
    public String getAsString() {
        if (this.isNumber()) {
            return this.getAsNumber().toString();
        }
        if (this.isBoolean()) {
            return ((Boolean)this.value).toString();
        }
        return (String)this.value;
    }

    public int hashCode() {
        if (this.value == null) {
            return 31;
        }
        if (JsonPrimitive.isIntegral(this)) {
            long value2 = this.getAsNumber().longValue();
            return (int)(value2 ^ value2 >>> 32);
        }
        if (this.value instanceof Number) {
            long value3 = Double.doubleToLongBits(this.getAsNumber().doubleValue());
            return (int)(value3 ^ value3 >>> 32);
        }
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JsonPrimitive other = (JsonPrimitive)obj;
        if (this.value == null) {
            return other.value == null;
        }
        if (JsonPrimitive.isIntegral(this) && JsonPrimitive.isIntegral(other)) {
            return this.getAsNumber().longValue() == other.getAsNumber().longValue();
        }
        if (this.value instanceof Number && other.value instanceof Number) {
            double b;
            double a = this.getAsNumber().doubleValue();
            return a == (b = other.getAsNumber().doubleValue()) || Double.isNaN(a) && Double.isNaN(b);
        }
        return this.value.equals(other.value);
    }

    private static boolean isIntegral(JsonPrimitive primitive) {
        if (primitive.value instanceof Number) {
            Number number2 = (Number)primitive.value;
            return number2 instanceof BigInteger || number2 instanceof Long || number2 instanceof Integer || number2 instanceof Short || number2 instanceof Byte;
        }
        return false;
    }
}

