/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.common.Profile;
import org.keycloak.config.HealthOptions;
import org.keycloak.config.MetricsOptions;
import org.keycloak.config.Option;
import org.keycloak.config.database.Database;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.configuration.Configuration;

public class IgnoredArtifacts {
    public static final Set<String> FIPS_ENABLED = Set.of("org.bouncycastle:bcprov-jdk18on", "org.bouncycastle:bcpkix-jdk18on", "org.bouncycastle:bcutil-jdk18on", "org.keycloak:keycloak-crypto-default");
    public static final Set<String> FIPS_DISABLED = Set.of("org.keycloak:keycloak-crypto-fips1402", "org.bouncycastle:bc-fips", "org.bouncycastle:bctls-fips", "org.bouncycastle:bcpkix-fips", "org.bouncycastle:bcutil-fips");
    public static final Set<String> JDBC_H2 = Set.of("io.quarkus:quarkus-jdbc-h2", "io.quarkus:quarkus-jdbc-h2-deployment", "com.h2database:h2");
    public static final Set<String> JDBC_POSTGRES = Set.of("io.quarkus:quarkus-jdbc-postgresql", "io.quarkus:quarkus-jdbc-postgresql-deployment", "org.postgresql:postgresql");
    public static final Set<String> JDBC_MARIADB = Set.of("io.quarkus:quarkus-jdbc-mariadb", "io.quarkus:quarkus-jdbc-mariadb-deployment", "org.mariadb.jdbc:mariadb-java-client");
    public static final Set<String> JDBC_MYSQL = Set.of("io.quarkus:quarkus-jdbc-mysql", "io.quarkus:quarkus-jdbc-mysql-deployment", "com.mysql:mysql-connector-j");
    public static final Set<String> JDBC_MSSQL = Set.of("io.quarkus:quarkus-jdbc-mssql", "io.quarkus:quarkus-jdbc-mssql-deployment", "com.microsoft.sqlserver:mssql-jdbc");
    public static final Set<String> JDBC_ORACLE = Set.of("io.quarkus:quarkus-jdbc-oracle", "io.quarkus:quarkus-jdbc-oracle-deployment", "com.oracle.database.jdbc:ojdbc11", "com.oracle.database.nls:orai18n");
    public static final Set<String> JDBC_DRIVERS = Stream.of(JDBC_H2, JDBC_POSTGRES, JDBC_MARIADB, JDBC_MYSQL, JDBC_MSSQL, JDBC_ORACLE).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    public static final Set<String> HEALTH = Set.of("io.quarkus:quarkus-smallrye-health", "io.quarkus:quarkus-smallrye-health-deployment");
    public static Set<String> METRICS = Set.of("io.quarkus:quarkus-micrometer", "io.quarkus:quarkus-micrometer-deployment", "io.quarkus:quarkus-micrometer-registry-prometheus", "io.quarkus:quarkus-micrometer-registry-prometheus-deployment");

    public static Set<String> getDefaultIgnoredArtifacts() {
        return Stream.of(IgnoredArtifacts.fips(), IgnoredArtifacts.jdbcDrivers(), IgnoredArtifacts.health(), IgnoredArtifacts.metrics()).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    }

    private static Set<String> fips() {
        Profile profile = Environment.getCurrentOrCreateFeatureProfile();
        boolean isFipsEnabled = (Boolean)profile.getFeatures().get(Profile.Feature.FIPS);
        return isFipsEnabled ? FIPS_ENABLED : FIPS_DISABLED;
    }

    private static Set<String> jdbcDrivers() {
        HashSet vendorsOfAllDatasources = new HashSet();
        Configuration.getConfig().getPropertyNames().forEach(p -> {
            if (p.startsWith("quarkus.datasource.") && p.endsWith(".db-kind")) {
                Configuration.getOptionalValue(p).flatMap(Database::getVendor).ifPresent(vendorsOfAllDatasources::add);
            }
        });
        Configuration.getOptionalValue("quarkus.datasource.db-kind").flatMap(Database::getVendor).ifPresent(vendorsOfAllDatasources::add);
        Set jdbcArtifacts = vendorsOfAllDatasources.stream().map(vendor -> switch (vendor) {
            default -> throw new IncompatibleClassChangeError();
            case Database.Vendor.H2 -> JDBC_H2;
            case Database.Vendor.MYSQL -> JDBC_MYSQL;
            case Database.Vendor.MARIADB -> JDBC_MARIADB;
            case Database.Vendor.POSTGRES -> JDBC_POSTGRES;
            case Database.Vendor.MSSQL -> JDBC_MSSQL;
            case Database.Vendor.ORACLE -> JDBC_ORACLE;
        }).flatMap(Collection::stream).collect(Collectors.toSet());
        HashSet<String> allJdbcDrivers = new HashSet<String>(JDBC_DRIVERS);
        allJdbcDrivers.removeAll(jdbcArtifacts);
        return allJdbcDrivers;
    }

    private static Set<String> health() {
        boolean isHealthEnabled = Configuration.isTrue((Option<Boolean>)HealthOptions.HEALTH_ENABLED);
        return !isHealthEnabled ? HEALTH : Collections.emptySet();
    }

    private static Set<String> metrics() {
        boolean isMetricsEnabled = Configuration.isTrue((Option<Boolean>)MetricsOptions.METRICS_ENABLED);
        return !isMetricsEnabled ? METRICS : Collections.emptySet();
    }
}

