/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.List;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.Set;

public class OrderedHashSet<E>
extends HashSet<E>
implements List<E>,
Set<E> {
    public OrderedHashSet() {
        super(8);
        this.isList = true;
    }

    public OrderedHashSet(int n) {
        super(n);
        this.isList = true;
    }

    public OrderedHashSet(int n, ObjectComparator<E> objectComparator) {
        super(n, objectComparator);
        this.isList = true;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return (Boolean)super.remove(0L, 0L, object, null, false, true);
    }

    @Override
    public E remove(int n) {
        this.checkRange(n);
        Object object = this.objectKeyTable[n];
        super.remove(0L, 0L, object, null, false, true);
        return (E)object;
    }

    public void removeEntry(int n) throws IndexOutOfBoundsException {
        this.remove(n);
    }

    public boolean insert(int n, E e) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.contains(e)) {
            return false;
        }
        if (n < this.size()) {
            super.insertRow(n);
        }
        return this.add(e);
    }

    @Override
    public E set(int n, E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.checkRange(n);
        if (this.contains(e) && this.getIndex(e) != n) {
            throw new IllegalArgumentException();
        }
        Object object = this.objectKeyTable[n];
        super.remove(0L, 0L, object, null, false, false);
        this.add(e);
        return (E)object;
    }

    @Override
    public void add(int n, E e) {
        boolean bl = this.insert(n, e);
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public E get(int n) {
        this.checkRange(n);
        return (E)this.objectKeyTable[n];
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        return this.toArray(objectArray);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        System.arraycopy(this.objectKeyTable, 0, TArray, 0, TArray.length);
        return TArray;
    }

    public int indexOf(Object object) {
        return this.getLookup(object);
    }

    public int getIndex(Object object) {
        return this.getLookup(object);
    }

    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    public int getLargestIndex(OrderedHashSet<E> orderedHashSet) {
        int n = -1;
        int n2 = orderedHashSet.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.indexOf(orderedHashSet.get(i));
            if (n3 <= n) continue;
            n = n3;
        }
        return n;
    }

    public int getSmallestIndex(OrderedHashSet<E> orderedHashSet) {
        int n = -1;
        int n2 = orderedHashSet.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.indexOf(orderedHashSet.get(i));
            if (n3 == -1 || n != -1 && n3 >= n) continue;
            n = n3;
        }
        return n;
    }

    @Override
    public int getCommonElementCount(Set<E> set) {
        int n = 0;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (!set.contains(this.objectKeyTable[i])) continue;
            ++n;
        }
        return n;
    }

    public static <E> OrderedHashSet<E> addAll(OrderedHashSet<E> orderedHashSet, OrderedHashSet<E> orderedHashSet2) {
        if (orderedHashSet2 == null) {
            return orderedHashSet;
        }
        if (orderedHashSet == null) {
            orderedHashSet = new OrderedHashSet<E>();
        }
        orderedHashSet.addAll(orderedHashSet2);
        return orderedHashSet;
    }

    public static <E> OrderedHashSet<E> add(OrderedHashSet<E> orderedHashSet, E e) {
        if (e == null) {
            return orderedHashSet;
        }
        if (orderedHashSet == null) {
            orderedHashSet = new OrderedHashSet<E>();
        }
        orderedHashSet.add(e);
        return orderedHashSet;
    }

    private void checkRange(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

