/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Return;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.SpecialOperator;
import org.armedbear.lisp.Symbol;

public final class Do {
    private static final SpecialOperator DO = new sf_do();
    private static final SpecialOperator DO_STAR = new sf_do_star();

    static final LispObject _do(LispObject args, Environment env, boolean sequential) {
        LispObject varlist = args.car();
        LispObject second = args.cadr();
        LispObject end_test_form = second.car();
        LispObject result_forms = second.cdr();
        LispObject body = args.cddr();
        int numvars = varlist.length();
        Symbol[] vars = new Symbol[numvars];
        LispObject[] initforms = new LispObject[numvars];
        LispObject[] stepforms = new LispObject[numvars];
        for (int i = 0; i < numvars; ++i) {
            LispObject varspec = varlist.car();
            if (varspec instanceof Cons) {
                vars[i] = Lisp.checkSymbol(varspec.car());
                initforms[i] = varspec.cadr();
                if (varspec.cddr() != Lisp.NIL) {
                    stepforms[i] = varspec.caddr();
                }
            } else {
                vars[i] = Lisp.checkSymbol(varspec);
                initforms[i] = Lisp.NIL;
            }
            varlist = varlist.cdr();
        }
        LispThread thread = LispThread.currentThread();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        LispObject bodyAndDecls = Lisp.parseBody(body, false);
        LispObject specials = Lisp.parseSpecials(bodyAndDecls.NTH(1));
        body = bodyAndDecls.car();
        Environment ext = new Environment(env);
        for (int i = 0; i < numvars; ++i) {
            Symbol var = vars[i];
            LispObject value = Lisp.eval(initforms[i], sequential ? ext : env, thread);
            ext = new Environment(ext);
            if (specials != Lisp.NIL && Lisp.memq(var, specials)) {
                thread.bindSpecial(var, value);
                continue;
            }
            if (var.isSpecialVariable()) {
                thread.bindSpecial(var, value);
                continue;
            }
            ext.bind(var, value);
        }
        for (LispObject list = specials; list != Lisp.NIL; list = list.cdr()) {
            ext.declareSpecial(Lisp.checkSymbol(list.car()));
        }
        LispObject localTags = Lisp.preprocessTagBody(body, ext);
        LispObject blockId = new LispObject();
        try {
            LispObject result;
            thread.envStack.push(ext);
            ext.addBlock(Lisp.NIL, blockId);
            while (Lisp.eval(end_test_form, ext, thread) == Lisp.NIL) {
                LispObject value;
                Symbol symbol;
                Lisp.processTagBody(body, localTags, ext);
                if (sequential) {
                    for (int i = 0; i < numvars; ++i) {
                        LispObject step = stepforms[i];
                        if (step == null) continue;
                        symbol = vars[i];
                        value = Lisp.eval(step, ext, thread);
                        if (symbol.isSpecialVariable() || ext.isDeclaredSpecial(symbol)) {
                            thread.rebindSpecial(symbol, value);
                            continue;
                        }
                        ext.rebind(symbol, value);
                    }
                } else {
                    int i;
                    LispObject[] results = new LispObject[numvars];
                    for (i = 0; i < numvars; ++i) {
                        LispObject result2;
                        LispObject step = stepforms[i];
                        if (step == null) continue;
                        results[i] = result2 = Lisp.eval(step, ext, thread);
                    }
                    for (i = 0; i < numvars; ++i) {
                        if (results[i] == null) continue;
                        symbol = vars[i];
                        value = results[i];
                        if (symbol.isSpecialVariable() || ext.isDeclaredSpecial(symbol)) {
                            thread.rebindSpecial(symbol, value);
                            continue;
                        }
                        ext.rebind(symbol, value);
                    }
                }
                if (!Lisp.interrupted) continue;
                Lisp.handleInterrupt();
            }
            LispObject lispObject = result = Lisp.progn(result_forms, ext, thread);
            return lispObject;
        }
        catch (Return ret) {
            if (ret.getBlock() == blockId) {
                LispObject lispObject = ret.getResult();
                return lispObject;
            }
            throw ret;
        }
        finally {
            while (thread.envStack.pop() != ext) {
            }
            thread.resetSpecialBindings(mark);
            ext.inactive = true;
        }
    }

    private static final class sf_do_star
    extends SpecialOperator {
        sf_do_star() {
            super(Symbol.DO_STAR, "varlist endlist &body body");
        }

        @Override
        public LispObject execute(LispObject args, Environment env) {
            return Do._do(args, env, true);
        }
    }

    private static final class sf_do
    extends SpecialOperator {
        sf_do() {
            super(Symbol.DO, "varlist endlist &body body");
        }

        @Override
        public LispObject execute(LispObject args, Environment env) {
            return Do._do(args, env, false);
        }
    }
}

