/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.method;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.intercept.method.MethodDefinitionSource;
import org.springframework.util.Assert;

public final class DelegatingMethodDefinitionSource
implements MethodDefinitionSource,
InitializingBean {
    private List methodDefinitionSources;

    public void afterPropertiesSet() throws Exception {
        Assert.notEmpty((Collection)this.methodDefinitionSources, (String)"A list of MethodDefinitionSources is required");
    }

    public ConfigAttributeDefinition getAttributes(Method method, Class targetClass) {
        Iterator i = this.methodDefinitionSources.iterator();
        while (i.hasNext()) {
            MethodDefinitionSource s = (MethodDefinitionSource)i.next();
            ConfigAttributeDefinition result = s.getAttributes(method, targetClass);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public ConfigAttributeDefinition getAttributes(Object object) throws IllegalArgumentException {
        Iterator i = this.methodDefinitionSources.iterator();
        while (i.hasNext()) {
            MethodDefinitionSource s = (MethodDefinitionSource)i.next();
            ConfigAttributeDefinition result = s.getAttributes(object);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Collection getConfigAttributeDefinitions() {
        HashSet set = new HashSet();
        Iterator i = this.methodDefinitionSources.iterator();
        while (i.hasNext()) {
            MethodDefinitionSource s = (MethodDefinitionSource)i.next();
            Collection attrs = s.getConfigAttributeDefinitions();
            if (attrs == null) continue;
            set.addAll(attrs);
        }
        return set;
    }

    public boolean supports(Class clazz) {
        Iterator i = this.methodDefinitionSources.iterator();
        while (i.hasNext()) {
            MethodDefinitionSource s = (MethodDefinitionSource)i.next();
            if (!s.supports(clazz)) continue;
            return true;
        }
        return false;
    }

    public void setMethodDefinitionSources(List methodDefinitionSources) {
        Assert.notEmpty((Collection)methodDefinitionSources, (String)"A list of MethodDefinitionSources is required");
        this.methodDefinitionSources = methodDefinitionSources;
    }
}

