/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.popup;

import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.intellij.openapi.util.Comparing;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactInfoModel {
    public static final ArtifactInfoModel EMPTY = new ArtifactInfoModel(Collections.<ArtifactInfo>emptyList());
    private final List<ListDataListener> myListeners;
    private final List<ArtifactInfo> myValues;

    public ArtifactInfoModel(@NotNull List<ArtifactInfo> list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/popup/ArtifactInfoModel.<init> must not be null");
        }
        this.myListeners = new ArrayList<ListDataListener>();
        this.myValues = new ArrayList<ArtifactInfo>(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInfoChanged(@NotNull ArtifactInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/popup/ArtifactInfoModel.onInfoChanged must not be null");
        }
        int minChange = Integer.MAX_VALUE;
        int maxChange = Integer.MIN_VALUE;
        List<ArtifactInfo> list = this.myValues;
        synchronized (list) {
            for (int i = 0; i < this.myValues.size(); ++i) {
                ArtifactInfo oldInfo = this.myValues.get(i);
                if (!Comparing.strEqual((String)oldInfo.getUrl(), (String)info.getUrl())) continue;
                this.myValues.set(i, info);
                if (i > maxChange) {
                    maxChange = i;
                }
                if (i >= minChange) continue;
                minChange = i;
            }
        }
        if (minChange <= maxChange) {
            this.fireValueChanged(minChange, maxChange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getURLs() {
        List<ArtifactInfo> list = this.myValues;
        synchronized (list) {
            ArrayList<String> urls = new ArrayList<String>();
            for (ArtifactInfo info : this.myValues) {
                urls.add(info.getUrl());
            }
            return urls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireValueChanged(int minChange, int maxChange) {
        ListDataListener[] listDataListeners;
        ListDataEvent event = new ListDataEvent(this, 0, minChange, maxChange);
        List<ListDataListener> list = this.myListeners;
        synchronized (list) {
            listDataListeners = this.myListeners.toArray(new ListDataListener[this.myListeners.size()]);
        }
        for (ListDataListener listDataListener : listDataListeners) {
            listDataListener.contentsChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListDataListener(ListDataListener l) {
        List<ListDataListener> list = this.myListeners;
        synchronized (list) {
            this.myListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListDataListener(ListDataListener l) {
        List<ListDataListener> list = this.myListeners;
        synchronized (list) {
            this.myListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactInfo[] getValuesSnapshot() {
        List<ArtifactInfo> list = this.myValues;
        synchronized (list) {
            return this.myValues.toArray(new ArtifactInfo[this.myValues.size()]);
        }
    }
}

