/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.ObjectMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;

public class AnimateAttackMessage
extends ObjectMessage {
    public static final String TAG = "animateAttack";
    private static final String ATTACKER_TAG = "attacker";
    private static final String ATTACKER_TILE_TAG = "attackerTile";
    private static final String DEFENDER_TAG = "defender";
    private static final String DEFENDER_TILE_TAG = "defenderTile";
    private static final String SUCCESS_TAG = "success";

    public AnimateAttackMessage(Unit attacker, Unit defender, boolean result, boolean addAttacker, boolean addDefender) {
        super(TAG, ATTACKER_TAG, attacker.getId(), ATTACKER_TILE_TAG, attacker.getTile().getId(), DEFENDER_TAG, defender.getId(), DEFENDER_TILE_TAG, defender.getTile().getId(), SUCCESS_TAG, Boolean.toString(result));
        if (addAttacker) {
            this.appendChild(attacker.isOnCarrier() ? attacker.getCarrier() : attacker);
        }
        if (addDefender) {
            this.appendChild(defender.isOnCarrier() ? defender.getCarrier() : defender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnimateAttackMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, ATTACKER_TAG, ATTACKER_TILE_TAG, DEFENDER_TAG, DEFENDER_TILE_TAG, SUCCESS_TAG);
        FreeColXMLReader.ReadScope rs = xr.replaceScope(FreeColXMLReader.ReadScope.NOINTERN);
        ArrayList<Unit> units = new ArrayList<Unit>();
        try {
            while (xr.moreTags()) {
                String tag = xr.getLocalName();
                if ("unit".equals(tag)) {
                    Unit u = xr.readFreeColObject(game, Unit.class);
                    if (u != null) {
                        units.add(u);
                    }
                } else {
                    this.expected("unit", tag);
                }
                xr.expectTag(tag);
            }
            xr.expectTag(TAG);
        }
        finally {
            xr.replaceScope(rs);
        }
        this.appendChildren(units);
    }

    private Unit getUnit(Game game, String key) {
        String id = this.getStringAttribute(key);
        if (id == null) {
            return null;
        }
        Unit unit = game.getFreeColGameObject(id, Unit.class);
        if (unit != null) {
            return unit;
        }
        for (Unit u : this.getChildren(Unit.class)) {
            if (id.equals(u.getId())) {
                u.intern();
                return u;
            }
            if ((u = u.getCarriedUnitById(id)) == null) continue;
            u.intern();
            return u;
        }
        return null;
    }

    private Unit getAttacker(Game game) {
        return this.getUnit(game, ATTACKER_TAG);
    }

    private Unit getDefender(Game game) {
        return this.getUnit(game, DEFENDER_TAG);
    }

    private Tile getAttackerTile(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(ATTACKER_TILE_TAG), Tile.class);
    }

    private Tile getDefenderTile(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(DEFENDER_TILE_TAG), Tile.class);
    }

    private boolean getResult() {
        return this.getBooleanAttribute(SUCCESS_TAG, Boolean.FALSE);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.ANIMATION;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        Player player = freeColClient.getMyPlayer();
        Tile attackerTile = this.getAttackerTile(game);
        Tile defenderTile = this.getDefenderTile(game);
        boolean result = this.getResult();
        Unit attacker = this.getAttacker(game);
        Unit defender = this.getDefender(game);
        if (attacker == null) {
            logger.warning("Attack animation missing attacker unit.");
            return;
        }
        if (defender == null) {
            logger.warning("Attack animation missing defender unit.");
            return;
        }
        if (attackerTile == null) {
            logger.warning("Attack animation for: " + player.getId() + " omitted attacker tile.");
        }
        if (defenderTile == null) {
            logger.warning("Attack animation for: " + player.getId() + " omitted defender tile.");
        }
        this.igc(freeColClient).animateAttackHandler(attacker, defender, attackerTile, defenderTile, result);
        this.clientGeneric(freeColClient);
    }
}

