/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.apachehttpclient.v4_3;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.ApacheHttpClientHttpAttributesGetter;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.ApacheHttpClientRequest;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.ApacheHttpClientTelemetry;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpClientExperimentalMetrics;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientMetrics;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractorBuilder;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanStatusExtractor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.apache.http.HttpResponse;

public final class ApacheHttpClientTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.apache-httpclient-4.3";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<? super ApacheHttpClientRequest, ? super HttpResponse>> additionalExtractors = new ArrayList<AttributesExtractor<? super ApacheHttpClientRequest, ? super HttpResponse>>();
    private final HttpClientAttributesExtractorBuilder<ApacheHttpClientRequest, HttpResponse> httpAttributesExtractorBuilder = HttpClientAttributesExtractor.builder((HttpClientAttributesGetter)ApacheHttpClientHttpAttributesGetter.INSTANCE);
    private final HttpSpanNameExtractorBuilder<ApacheHttpClientRequest> httpSpanNameExtractorBuilder = HttpSpanNameExtractor.builder((HttpClientAttributesGetter)ApacheHttpClientHttpAttributesGetter.INSTANCE);
    private Function<SpanNameExtractor<ApacheHttpClientRequest>, ? extends SpanNameExtractor<? super ApacheHttpClientRequest>> spanNameExtractorTransformer = Function.identity();
    private boolean emitExperimentalHttpClientMetrics = false;

    ApacheHttpClientTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public ApacheHttpClientTelemetryBuilder addAttributeExtractor(AttributesExtractor<? super ApacheHttpClientRequest, ? super HttpResponse> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public ApacheHttpClientTelemetryBuilder setCapturedRequestHeaders(List<String> requestHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public ApacheHttpClientTelemetryBuilder setCapturedResponseHeaders(List<String> responseHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public ApacheHttpClientTelemetryBuilder setKnownMethods(Set<String> knownMethods) {
        this.httpAttributesExtractorBuilder.setKnownMethods(knownMethods);
        this.httpSpanNameExtractorBuilder.setKnownMethods(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    public ApacheHttpClientTelemetryBuilder setEmitExperimentalHttpClientMetrics(boolean emitExperimentalHttpClientMetrics) {
        this.emitExperimentalHttpClientMetrics = emitExperimentalHttpClientMetrics;
        return this;
    }

    @CanIgnoreReturnValue
    public ApacheHttpClientTelemetryBuilder setSpanNameExtractor(Function<SpanNameExtractor<ApacheHttpClientRequest>, ? extends SpanNameExtractor<? super ApacheHttpClientRequest>> spanNameExtractorTransformer) {
        this.spanNameExtractorTransformer = spanNameExtractorTransformer;
        return this;
    }

    public ApacheHttpClientTelemetry build() {
        ApacheHttpClientHttpAttributesGetter httpAttributesGetter = ApacheHttpClientHttpAttributesGetter.INSTANCE;
        SpanNameExtractor<? super ApacheHttpClientRequest> spanNameExtractor = this.spanNameExtractorTransformer.apply((SpanNameExtractor<ApacheHttpClientRequest>)this.httpSpanNameExtractorBuilder.build());
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, spanNameExtractor).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addAttributesExtractor(this.httpAttributesExtractorBuilder.build()).addAttributesExtractors(this.additionalExtractors).addOperationMetrics(HttpClientMetrics.get());
        if (this.emitExperimentalHttpClientMetrics) {
            builder.addAttributesExtractor(HttpExperimentalAttributesExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addOperationMetrics(HttpClientExperimentalMetrics.get());
        }
        Instrumenter instrumenter = builder.buildInstrumenter(SpanKindExtractor.alwaysClient());
        return new ApacheHttpClientTelemetry((Instrumenter<ApacheHttpClientRequest, HttpResponse>)instrumenter, this.openTelemetry.getPropagators());
    }
}

