/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.util;

import jakarta.ws.rs.core.MultivaluedMap;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.regex.Pattern;

public class URLUtils {
    private static final char PATH_SEPARATOR = '/';
    private static final QueryStringParser QUERY_STRING_PARSER = new QueryStringParser('&', false){

        @Override
        void handle(MultivaluedMap<String, String> exchange, String key, String value) {
            exchange.add((Object)key, (Object)value);
        }
    };
    private static final QueryStringParser PATH_PARAM_PARSER = new QueryStringParser(';', true){

        @Override
        void handle(MultivaluedMap<String, String> exchange, String key, String value) {
            exchange.add((Object)key, (Object)value);
        }
    };
    private static final Pattern SCHEME_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9+-.]*:.*");

    private URLUtils() {
    }

    public static void parseQueryString(String string, MultivaluedMap<String, String> exchange, Charset charset, boolean doDecode, int maxParameters) {
        QUERY_STRING_PARSER.parse(string, exchange, charset, doDecode, maxParameters);
    }

    @Deprecated
    public static void parsePathParms(String string, MultivaluedMap<String, String> exchange, Charset charset, boolean doDecode, int maxParameters) {
        URLUtils.parsePathParams(string, exchange, charset, doDecode, maxParameters);
    }

    public static int parsePathParams(String string, MultivaluedMap<String, String> exchange, Charset charset, boolean doDecode, int maxParameters) {
        return PATH_PARAM_PARSER.parse(string, exchange, charset, doDecode, maxParameters);
    }

    public static String decode(String s, Charset enc, boolean decodeSlash, StringBuilder buffer) {
        return URLUtils.decode(s, enc, decodeSlash, true, buffer);
    }

    public static String decode(String s, Charset enc, boolean decodeSlash, boolean formEncoding, StringBuilder buffer) {
        if (buffer != null) {
            buffer.setLength(0);
        }
        int numChars = s.length();
        for (int i = 0; i < numChars; ++i) {
            char c = s.charAt(i);
            if (c != '%' && c <= '\u007f' && c != '+') continue;
            buffer = new StringBuilder();
            buffer.append(s, 0, i);
            try {
                byte[] bytes = new byte[numChars - i + 1];
                int pos = 0;
                while (i < numChars) {
                    if (c == '%') {
                        if (i + 2 >= s.length()) {
                            throw URLUtils.failedToDecodeURL(s, enc, null);
                        }
                        char p1 = Character.toLowerCase(s.charAt(i + 1));
                        char p2 = Character.toLowerCase(s.charAt(i + 2));
                        if (!decodeSlash && (p1 == '2' && p2 == 'f' || p1 == '5' && p2 == 'c')) {
                            if (pos + 2 >= bytes.length) {
                                bytes = URLUtils.expandBytes(bytes);
                            }
                            bytes[pos++] = (byte)c;
                            bytes[pos++] = (byte)s.charAt(i + 1);
                            bytes[pos++] = (byte)s.charAt(i + 2);
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                            continue;
                        }
                        int v = 0;
                        if (p1 >= '0' && p1 <= '9') {
                            v = p1 - 48 << 4;
                        } else if (p1 >= 'a' && p1 <= 'f') {
                            v = p1 - 97 + 10 << 4;
                        } else {
                            throw URLUtils.failedToDecodeURL(s, enc, null);
                        }
                        if (p2 >= '0' && p2 <= '9') {
                            v += p2 - 48;
                        } else if (p2 >= 'a' && p2 <= 'f') {
                            v += p2 - 97 + 10;
                        } else {
                            throw URLUtils.failedToDecodeURL(s, enc, null);
                        }
                        if (v < 0) {
                            throw URLUtils.failedToDecodeURL(s, enc, null);
                        }
                        if (pos == bytes.length) {
                            bytes = URLUtils.expandBytes(bytes);
                        }
                        bytes[pos++] = (byte)v;
                        if ((i += 3) >= numChars) continue;
                        c = s.charAt(i);
                        continue;
                    }
                    if (c == '+' && formEncoding) {
                        if (pos == bytes.length) {
                            bytes = URLUtils.expandBytes(bytes);
                        }
                        bytes[pos++] = 32;
                        if (++i >= numChars) continue;
                        c = s.charAt(i);
                        continue;
                    }
                    if (pos == bytes.length) {
                        bytes = URLUtils.expandBytes(bytes);
                    }
                    ++i;
                    if (c >> 8 != 0) {
                        bytes[pos++] = (byte)(c >> 8);
                        if (pos == bytes.length) {
                            bytes = URLUtils.expandBytes(bytes);
                        }
                        bytes[pos++] = (byte)c;
                        continue;
                    }
                    bytes[pos++] = (byte)c;
                    if (i >= numChars) continue;
                    c = s.charAt(i);
                }
                String decoded = new String(bytes, 0, pos, enc);
                buffer.append(decoded);
                return buffer.toString();
            }
            catch (NumberFormatException e) {
                throw URLUtils.failedToDecodeURL(s, enc, e);
            }
        }
        return s;
    }

    private static RuntimeException failedToDecodeURL(String s, Charset enc, Throwable o) {
        return new RuntimeException("Failed to decode URL " + s + " to " + String.valueOf(enc), o);
    }

    private static byte[] expandBytes(byte[] bytes) {
        byte[] newBytes = new byte[bytes.length + 10];
        System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
        return newBytes;
    }

    public static void parsePathParameters(String path, Set<String> pathParameters) {
        if (path == null || path.isEmpty() || path.indexOf(123) == -1) {
            return;
        }
        int len = path.length();
        int open = 0;
        int startName = -1;
        int endName = -1;
        block5: for (int i = 0; i < len; ++i) {
            switch (path.charAt(i)) {
                case '{': {
                    if (open == 0) {
                        startName = i + 1;
                        endName = -1;
                    }
                    ++open;
                    continue block5;
                }
                case '}': {
                    if (open <= 0 || --open != 0) continue block5;
                    if (endName == -1) {
                        endName = i;
                    }
                    String pathParam = path.substring(startName, endName);
                    pathParameters.add(pathParam);
                    continue block5;
                }
                case ':': {
                    if (open != 1 || endName != -1) continue block5;
                    endName = i;
                }
            }
        }
    }

    public static String normalizeSlashes(String path) {
        StringBuilder builder = new StringBuilder(path);
        boolean modified = false;
        while (builder.length() > 0 && builder.length() != 1 && '/' == builder.charAt(builder.length() - 1)) {
            builder.deleteCharAt(builder.length() - 1);
            modified = true;
        }
        if (builder.length() == 0 || '/' != builder.charAt(0)) {
            builder.insert(0, '/');
            modified = true;
        }
        if (modified) {
            return builder.toString();
        }
        return path;
    }

    public static boolean isAbsoluteUrl(String location) {
        if (location != null && location.length() > 0 && location.contains(":")) {
            return SCHEME_PATTERN.matcher(location).matches();
        }
        return false;
    }

    private static abstract class QueryStringParser {
        private final char separator;
        private final boolean parseUntilSeparator;

        QueryStringParser(char separator, boolean parseUntilSeparator) {
            this.separator = separator;
            this.parseUntilSeparator = parseUntilSeparator;
        }

        int parse(String string, MultivaluedMap<String, String> exchange, Charset charset, boolean doDecode, int max) {
            int count = 0;
            int i = 0;
            try {
                int stringStart = 0;
                String attrName = null;
                for (i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '=' && attrName == null) {
                        attrName = string.substring(stringStart, i);
                        stringStart = i + 1;
                        continue;
                    }
                    if (c == this.separator) {
                        if (attrName != null) {
                            this.handle(exchange, this.decode(charset, attrName, doDecode), this.decode(charset, string.substring(stringStart, i), doDecode));
                            if (++count > max) {
                                throw this.tooManyParameters(max);
                            }
                        } else {
                            this.handle(exchange, this.decode(charset, string.substring(stringStart, i), doDecode), "");
                            if (++count > max) {
                                throw this.tooManyParameters(max);
                            }
                        }
                        stringStart = i + 1;
                        attrName = null;
                        continue;
                    }
                    if (this.parseUntilSeparator && (c == '?' || c == '/')) break;
                }
                if (attrName != null) {
                    this.handle(exchange, this.decode(charset, attrName, doDecode), this.decode(charset, string.substring(stringStart, i), doDecode));
                    if (++count > max) {
                        throw this.tooManyParameters(max);
                    }
                } else if (string.length() != stringStart) {
                    this.handle(exchange, this.decode(charset, string.substring(stringStart, i), doDecode), "");
                    if (++count > max) {
                        throw this.tooManyParameters(max);
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            return i;
        }

        private RuntimeException tooManyParameters(int max) {
            return new RuntimeException("Too many parameters: max=" + max);
        }

        private String decode(Charset charset, String attrName, boolean doDecode) throws UnsupportedEncodingException {
            if (doDecode) {
                return URLUtils.decode(attrName, charset, true, true, new StringBuilder());
            }
            return attrName;
        }

        abstract void handle(MultivaluedMap<String, String> var1, String var2, String var3);
    }
}

