/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.modules.factory.svg;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.gvt.GraphicsNode;

public class SVGDrawable {
    private GraphicsNode rootNode;
    private int width;
    private int height;

    public SVGDrawable(GraphicsNode rootNode) {
        if (rootNode == null) {
            throw new NullPointerException();
        }
        this.rootNode = rootNode;
        Rectangle2D bounds = rootNode.getBounds();
        this.width = (int)bounds.getWidth();
        this.height = (int)bounds.getHeight();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public boolean isPreserveAspectRatio() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D g, Rectangle2D area) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.translate(-area.getX(), -area.getY());
            double sx = area.getWidth() / (double)this.width;
            double sy = area.getHeight() / (double)this.height;
            double sm = Math.min(sx, sy);
            g2.scale(sm, sm);
            this.rootNode.paint(g2);
        }
        finally {
            g2.dispose();
        }
    }
}

