/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.JarPathname;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.Utilities;

public class URLPathname
extends Pathname {
    public static final Symbol SCHEME = Lisp.internKeyword("SCHEME");
    public static final Symbol AUTHORITY = Lisp.internKeyword("AUTHORITY");
    public static final Symbol QUERY = Lisp.internKeyword("QUERY");
    public static final Symbol FRAGMENT = Lisp.internKeyword("FRAGMENT");
    public static final LispObject FILE = new SimpleString("file");
    @DocString(name="uri-decode", args="string", returns="string", doc="Decode STRING percent escape sequences in the manner of URI encodings.")
    private static final Primitive URI_DECODE = new pf_uri_decode();
    @DocString(name="uri-encode", args="string", returns="string", doc="Encode percent escape sequences in the manner of URI encodings.")
    private static final Primitive URI_ENCODE = new pf_uri_encode();

    protected URLPathname() {
    }

    public static URLPathname create() {
        return new URLPathname();
    }

    public static URLPathname create(Pathname p) {
        if (p instanceof URLPathname) {
            URLPathname result = new URLPathname();
            result.copyFrom(p);
            return result;
        }
        return URLPathname.createFromFile(p);
    }

    public static URLPathname create(URL url) {
        return URLPathname.create(url.toString());
    }

    public static URLPathname create(URI uri) {
        return URLPathname.create(uri.toString());
    }

    public static URLPathname createFromFile(Pathname p) {
        URLPathname result = new URLPathname();
        result.copyFrom(p);
        LispObject scheme = Lisp.NIL;
        scheme = scheme.push(FILE).push(SCHEME);
        result.setHost(scheme);
        return result;
    }

    public static URLPathname create(String s) {
        String fragment;
        String query;
        if (!URLPathname.isValidURL(s)) {
            Lisp.parse_error("Cannot form a PATHNAME-URL from " + s);
        }
        if (s.startsWith("jar:")) {
            return JarPathname.create(s);
        }
        URLPathname result = new URLPathname();
        URL url = null;
        try {
            url = new URL(s);
        }
        catch (MalformedURLException e) {
            Lisp.parse_error("Malformed URL in namestring '" + s + "': " + e.toString());
            return (URLPathname)Lisp.UNREACHED;
        }
        String scheme = url.getProtocol();
        if (scheme.equals("file")) {
            URI uri = null;
            try {
                uri = new URI(s);
            }
            catch (URISyntaxException ex) {
                Lisp.parse_error("Improper URI syntax for '" + url.toString() + "': " + ex.toString());
                return (URLPathname)Lisp.UNREACHED;
            }
            String uriPath = uri.getPath();
            if (null == uriPath && ((uriPath = uri.getSchemeSpecificPart()) == null || uriPath.equals(""))) {
                Lisp.parse_error("The namestring URI has no path: " + uri);
                return (URLPathname)Lisp.UNREACHED;
            }
            File file = new File(uriPath);
            Object path = file.getPath();
            if (uri.toString().endsWith("/") && !((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            Pathname p = Pathname.create((String)path);
            LispObject host = Lisp.NIL.push(FILE).push(SCHEME);
            result.setHost(host).setDevice(p.getDevice()).setDirectory(p.getDirectory()).setName(p.getName()).setType(p.getType()).setVersion(p.getVersion());
            return result;
        }
        Debug.assertTrue(scheme != null);
        URI uri = null;
        try {
            uri = url.toURI().normalize();
        }
        catch (URISyntaxException e) {
            Lisp.parse_error("Couldn't form URI from '" + url + "' because: " + e);
            return (URLPathname)Lisp.UNREACHED;
        }
        String authority = uri.getAuthority();
        if (authority == null) {
            authority = url.getAuthority();
        }
        LispObject host = Lisp.NIL;
        host = host.push(SCHEME).push(new SimpleString(scheme));
        if (authority != null) {
            host = host.push(AUTHORITY).push(new SimpleString(authority));
        }
        if ((query = uri.getRawQuery()) != null) {
            host = host.push(QUERY).push(new SimpleString(query));
        }
        if ((fragment = uri.getRawFragment()) != null) {
            host = host.push(FRAGMENT).push(new SimpleString(fragment));
        }
        host = host.nreverse();
        result.setHost(host);
        String path = uri.getRawPath();
        if (path == null) {
            path = "";
        }
        Pathname p = Pathname.create(path != null ? path : "");
        result.setDirectory(p.getDirectory()).setName(p.getName()).setType(p.getType());
        return result;
    }

    public URI toURI() {
        String uriString = this.getNamestringAsURL();
        try {
            URI uri = new URI(uriString);
            return uri;
        }
        catch (URISyntaxException eo) {
            return null;
        }
    }

    public URL toURL() {
        URI uri = this.toURI();
        try {
            if (uri != null) {
                return uri.toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public File getFile() {
        if (!URLPathname.hasExplicitFile(this)) {
            return null;
        }
        URI uri = this.toURI();
        if (uri == null) {
            return null;
        }
        File result = new File(uri);
        return result;
    }

    public static boolean isFile(Pathname p) {
        LispObject scheme = Symbol.GETF.execute(p.getHost(), SCHEME, Lisp.NIL);
        return scheme.equals(Lisp.NIL) || URLPathname.hasExplicitFile(p);
    }

    public static boolean hasExplicitFile(Pathname p) {
        if (!p.getHost().listp()) {
            return false;
        }
        LispObject scheme = Symbol.GETF.execute(p.getHost(), SCHEME, Lisp.NIL);
        return scheme.equalp(FILE);
    }

    @Override
    public String getNamestring() {
        StringBuilder sb = new StringBuilder();
        return this.getNamestring(sb);
    }

    public String getNamestring(StringBuilder sb) {
        LispObject scheme = Symbol.GETF.execute(this.getHost(), SCHEME, Lisp.NIL);
        LispObject authority = Symbol.GETF.execute(this.getHost(), AUTHORITY, Lisp.NIL);
        boolean percentEncode = true;
        if (scheme.equals(Lisp.NIL)) {
            percentEncode = false;
        } else {
            sb.append(scheme.getStringValue());
            sb.append(":");
            if (authority != Lisp.NIL) {
                sb.append("//");
                sb.append(authority.getStringValue());
            } else if (scheme.equalp(FILE)) {
                sb.append("//");
            }
        }
        if (Utilities.isPlatformWindows && this.getDevice() instanceof SimpleString) {
            sb.append("/").append(this.getDevice().getStringValue()).append(":");
        }
        String directoryNamestring = this.getDirectoryNamestring();
        if (percentEncode) {
            directoryNamestring = URLPathname.uriEncode(directoryNamestring);
        }
        sb.append(directoryNamestring);
        Pathname p = new Pathname();
        p.copyFrom(this).setHost(Lisp.NIL).setDevice(Lisp.NIL).setDirectory(Lisp.NIL);
        String nameTypeVersion = p.getNamestring();
        if (percentEncode) {
            nameTypeVersion = URLPathname.uriEncode(nameTypeVersion);
        }
        sb.append(nameTypeVersion);
        LispObject o = Symbol.GETF.execute(this.getHost(), QUERY, Lisp.NIL);
        if (o != Lisp.NIL) {
            sb.append("?").append(URLPathname.uriEncode(o.getStringValue()));
        }
        if ((o = Symbol.GETF.execute(this.getHost(), FRAGMENT, Lisp.NIL)) != Lisp.NIL) {
            sb.append("#").append(URLPathname.uriEncode(o.getStringValue()));
        }
        return sb.toString();
    }

    public String getNamestringAsURL() {
        String scheme;
        LispObject schemeProperty = Symbol.GETF.execute(this.getHost(), SCHEME, Lisp.NIL);
        LispObject authorityProperty = Symbol.GETF.execute(this.getHost(), AUTHORITY, Lisp.NIL);
        LispObject queryProperty = Symbol.GETF.execute(this.getHost(), QUERY, Lisp.NIL);
        LispObject fragmentProperty = Symbol.GETF.execute(this.getHost(), FRAGMENT, Lisp.NIL);
        String authority = null;
        if (!schemeProperty.equals(Lisp.NIL)) {
            scheme = schemeProperty.getStringValue();
            if (!authorityProperty.equals(Lisp.NIL)) {
                authority = authorityProperty.getStringValue();
            }
        } else {
            scheme = "file";
        }
        String directory = this.getDirectoryNamestring();
        String file = "";
        LispObject fileNamestring = Symbol.FILE_NAMESTRING.execute(this);
        if (!fileNamestring.equals(Lisp.NIL)) {
            file = fileNamestring.getStringValue();
        }
        Object path = "";
        path = !directory.equals("") ? (Utilities.isPlatformWindows && this.getDevice() instanceof SimpleString ? this.getDevice().getStringValue() + ":" + directory + file : directory + file) : file;
        path = URLPathname.uriEncode((String)path);
        String query = null;
        if (!queryProperty.equals(Lisp.NIL)) {
            query = queryProperty.getStringValue();
        }
        String fragment = null;
        if (!fragmentProperty.equals(Lisp.NIL)) {
            fragment = fragmentProperty.getStringValue();
        }
        StringBuffer result = new StringBuffer(scheme);
        result.append(":");
        result.append("//");
        if (authority != null) {
            result.append(authority);
        }
        if (!((String)path).startsWith("/")) {
            result.append("/");
        }
        result.append((String)path);
        if (query != null) {
            result.append("?").append(query);
        }
        if (fragment != null) {
            result.append("#").append(fragment);
        }
        return result.toString();
    }

    @Override
    public LispObject typeOf() {
        return Symbol.URL_PATHNAME;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.URL_PATHNAME;
    }

    public static LispObject truename(Pathname p, boolean errorIfDoesNotExist) {
        URLPathname pathnameURL = URLPathname.createFromFile(p);
        return URLPathname.truename(pathnameURL, errorIfDoesNotExist);
    }

    public static LispObject truename(URLPathname p, boolean errorIfDoesNotExist) {
        if (p.getHost().equals(Lisp.NIL) || URLPathname.hasExplicitFile(p)) {
            LispObject fileTruename = Pathname.truename(p, errorIfDoesNotExist);
            if (fileTruename.equals(Lisp.NIL)) {
                return Lisp.NIL;
            }
            if (!(fileTruename instanceof URLPathname)) {
                URLPathname urlTruename = URLPathname.createFromFile((Pathname)fileTruename);
                return urlTruename;
            }
            return fileTruename;
        }
        if (p.getInputStream() != null) {
            if (p.getName() != Lisp.NIL && p.getType() == Lisp.NIL && Symbol.GETF.execute(p.getHost(), QUERY, Lisp.NIL) == Lisp.NIL && Symbol.GETF.execute(p.getHost(), FRAGMENT, Lisp.NIL) == Lisp.NIL && p.getInputStream() != null) {
                return p;
            }
            return p;
        }
        return Pathname.doTruenameExit(p, errorIfDoesNotExist);
    }

    @Override
    public InputStream getInputStream() {
        InputStream result = null;
        if (URLPathname.isFile(this)) {
            Pathname p = new Pathname();
            p.copyFrom(this).setHost(Lisp.NIL);
            return p.getInputStream();
        }
        if (URLPathname.isFile(this)) {
            Pathname p = new Pathname();
            p.copyFrom(this).setHost(Lisp.NIL);
            return p.getInputStream();
        }
        URL url = this.toURL();
        try {
            result = url.openStream();
        }
        catch (IOException e) {
            Debug.warn("Failed to get InputStream from '" + this.getNamestring() + "': " + e);
        }
        return result;
    }

    URLConnection getURLConnection() {
        Debug.assertTrue(this.isURL());
        URL url = this.toURL();
        URLConnection result = null;
        try {
            result = url.openConnection();
        }
        catch (IOException e) {
            Lisp.error(new FileError("Failed to open URL connection.", this));
        }
        return result;
    }

    @Override
    public long getLastModified() {
        return this.getURLConnection().getLastModified();
    }

    static String uriDecode(String s) {
        try {
            URI uri = new URI("file://foo?" + s);
            return uri.getQuery();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    static String uriEncode(String s) {
        Object u = !s.startsWith("/") ? "/" + s : new String(s);
        try {
            URI uri = new URI("file", "", (String)u, "");
            String result = uri.getRawPath();
            if (!s.startsWith("/")) {
                return result.substring(1);
            }
            return result;
        }
        catch (URISyntaxException e) {
            Debug.assertTrue(false);
            return null;
        }
    }

    private static final class pf_uri_encode
    extends Primitive {
        pf_uri_encode() {
            super("uri-encode", Lisp.PACKAGE_EXT, true);
        }

        @Override
        public LispObject execute(LispObject arg) {
            if (!(arg instanceof AbstractString)) {
                return Lisp.type_error(arg, Symbol.STRING);
            }
            String result = URLPathname.uriEncode(((AbstractString)arg).toString());
            return new SimpleString(result);
        }
    }

    private static final class pf_uri_decode
    extends Primitive {
        pf_uri_decode() {
            super("uri-decode", Lisp.PACKAGE_EXT, true);
        }

        @Override
        public LispObject execute(LispObject arg) {
            if (!(arg instanceof AbstractString)) {
                return Lisp.type_error(arg, Symbol.STRING);
            }
            String result = URLPathname.uriDecode(((AbstractString)arg).toString());
            return new SimpleString(result);
        }
    }
}

