/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.colopedia;

import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaPanel;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaTreeItem;
import net.sf.freecol.common.util.ImageUtils;

public class ColopediaTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final ColopediaPanel colopediaPanel;
    private final ImageLibrary lib;

    public ColopediaTreeCellRenderer(ColopediaPanel colopediaPanel, ImageLibrary lib) {
        this.colopediaPanel = colopediaPanel;
        this.lib = lib;
        this.setBackgroundNonSelectionColor(new Color(0, 0, 0, 1));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        ColopediaTreeItem nodeItem = (ColopediaTreeItem)node.getUserObject();
        if (nodeItem.getIcon() != null) {
            this.setIcon(nodeItem.getIcon());
        } else if (!leaf) {
            BufferedImage image = ImageUtils.createCenteredImage(this.lib.getColopediaCellImage(expanded), this.colopediaPanel.getListItemIconSize());
            this.setIcon(new ImageIcon(image));
        }
        return this;
    }
}

