/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;

public class ExportData
extends FreeColObject {
    public static final String TAG = "exportData";
    private static final int HIGH_LEVEL_DEFAULT = 90;
    private static final int LOW_LEVEL_DEFAULT = 10;
    private static final int EXPORT_LEVEL_DEFAULT = 50;
    private int highLevel = 90;
    private int lowLevel = 10;
    private int importLevel = -1;
    private int exportLevel = 50;
    private boolean exported = false;
    private static final String EXPORTED_TAG = "exported";
    private static final String EXPORT_LEVEL_TAG = "exportLevel";
    private static final String IMPORT_LEVEL_TAG = "importLevel";
    private static final String HIGH_LEVEL_TAG = "highLevel";
    private static final String LOW_LEVEL_TAG = "lowLevel";

    public ExportData() {
    }

    public ExportData(GoodsType goodsType, int importLevel) {
        this.setId(goodsType.getId());
        this.setImportLevel(importLevel);
    }

    public ExportData(FreeColXMLReader xr) throws XMLStreamException {
        this.readFromXML(xr);
    }

    public final int getHighLevel() {
        return this.highLevel;
    }

    public final ExportData setHighLevel(int newHighLevel) {
        this.highLevel = newHighLevel;
        return this;
    }

    public final int getLowLevel() {
        return this.lowLevel;
    }

    public final ExportData setLowLevel(int newLowLevel) {
        this.lowLevel = newLowLevel;
        return this;
    }

    public final int getImportLevel() {
        return this.importLevel;
    }

    public final int getEffectiveImportLevel(int capacity) {
        return this.importLevel >= 0 ? this.importLevel : capacity;
    }

    public final ExportData setImportLevel(int newImportLevel) {
        this.importLevel = newImportLevel;
        return this;
    }

    public final int getExportLevel() {
        return this.exportLevel;
    }

    public final ExportData setExportLevel(int newExportLevel) {
        this.exportLevel = newExportLevel;
        return this;
    }

    public final boolean getExported() {
        return this.exported;
    }

    public final void setExported(boolean newExport) {
        this.exported = newExport;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        ExportData o = this.copyInCast(other, ExportData.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.highLevel = o.getHighLevel();
        this.lowLevel = o.getLowLevel();
        this.importLevel = o.getImportLevel();
        this.exportLevel = o.getExportLevel();
        this.exported = o.getExported();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(EXPORTED_TAG, this.exported);
        xw.writeAttribute(HIGH_LEVEL_TAG, this.highLevel);
        xw.writeAttribute(LOW_LEVEL_TAG, this.lowLevel);
        xw.writeAttribute(IMPORT_LEVEL_TAG, this.importLevel);
        xw.writeAttribute(EXPORT_LEVEL_TAG, this.exportLevel);
    }

    @Override
    public void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.exported = xr.getAttribute(EXPORTED_TAG, false);
        this.highLevel = xr.getAttribute(HIGH_LEVEL_TAG, 90);
        this.lowLevel = xr.getAttribute(LOW_LEVEL_TAG, 10);
        this.importLevel = xr.getAttribute(IMPORT_LEVEL_TAG, -1);
        this.exportLevel = xr.getAttribute(EXPORT_LEVEL_TAG, 50);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }
}

