/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.util.CollectionUtils;

public class GoodsContainer
extends FreeColGameObject
implements Ownable {
    private static final Logger logger = Logger.getLogger(GoodsContainer.class.getName());
    public static final String TAG = "goodsContainer";
    public static final int CARGO_SIZE = 100;
    public static final int HUGE_CARGO_SIZE = 10000;
    private final Map<GoodsType, Integer> storedGoods = new HashMap<GoodsType, Integer>();
    private final Map<GoodsType, Integer> oldStoredGoods = new HashMap<GoodsType, Integer>();
    private Location parent = null;
    public static final String AMOUNT_TAG = "amount";
    public static final String OLD_STORED_GOODS_TAG = "oldStoredGoods";
    public static final String STORED_GOODS_TAG = "storedGoods";
    public static final String TYPE_TAG = "type";

    public GoodsContainer(Game game, Location parent) {
        super(game);
        this.parent = parent;
    }

    public GoodsContainer(Game game, String id) {
        super(game, id);
    }

    protected Location getParent() {
        return this.parent;
    }

    public void setLocation(Location location) {
        if (location == null) {
            throw new RuntimeException("Null GoodsContainer location: " + this);
        }
        this.parent = location;
    }

    protected Map<GoodsType, Integer> getStoredGoods() {
        return this.storedGoods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStoredGoods(Map<GoodsType, Integer> goods) {
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            this.storedGoods.clear();
            this.storedGoods.putAll(goods);
        }
    }

    protected Map<GoodsType, Integer> getOldStoredGoods() {
        return this.oldStoredGoods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOldStoredGoods(Map<GoodsType, Integer> goods) {
        Map<GoodsType, Integer> map = this.oldStoredGoods;
        synchronized (map) {
            this.oldStoredGoods.clear();
            this.oldStoredGoods.putAll(goods);
        }
    }

    public <T extends AbstractGoods> boolean contains(T g) {
        return this.getGoodsCount(g.getType()) >= g.getAmount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGoodsCount(GoodsType type) {
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            Integer val = this.storedGoods.get(type);
            return val == null ? 0 : val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOldGoodsCount(GoodsType type) {
        Map<GoodsType, Integer> map = this.oldStoredGoods;
        synchronized (map) {
            Integer val = this.oldStoredGoods.get(type);
            return val == null ? 0 : val;
        }
    }

    public <T extends AbstractGoods> boolean addGoods(T goods) {
        return this.addGoods(goods.getType(), goods.getAmount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addGoods(GoodsType type, int amount) {
        int oldAmount = this.getGoodsCount(type);
        int newAmount = oldAmount + amount;
        if (newAmount < 0) {
            throw new IllegalStateException("Operation would leave " + newAmount + " goods of type " + type + " in Location " + this.parent);
        }
        if (newAmount == 0) {
            Map<GoodsType, Integer> map = this.storedGoods;
            synchronized (map) {
                this.storedGoods.remove(type);
            }
        }
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            this.storedGoods.put(type, newAmount);
        }
        return true;
    }

    public <T extends AbstractGoods> Goods removeGoods(T goods) {
        return this.removeGoods(goods.getType(), goods.getAmount());
    }

    public Goods removeGoods(GoodsType type) {
        return this.removeGoods(type, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Goods removeGoods(GoodsType type, int amount) {
        Goods removedGoods;
        int oldAmount = this.getGoodsCount(type);
        if (oldAmount <= 0) {
            return null;
        }
        int newAmount = oldAmount - amount;
        if (newAmount > 0) {
            removedGoods = new Goods(this.getGame(), null, type, amount);
            Map<GoodsType, Integer> map = this.storedGoods;
            synchronized (map) {
                this.storedGoods.put(type, newAmount);
            }
        }
        removedGoods = new Goods(this.getGame(), null, type, oldAmount);
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            this.storedGoods.remove(type);
        }
        return removedGoods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAmount(GoodsType goodsType, int newAmount) {
        if (newAmount == 0) {
            Map<GoodsType, Integer> map = this.storedGoods;
            synchronized (map) {
                this.storedGoods.remove(goodsType);
            }
        }
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            this.storedGoods.put(goodsType, newAmount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            this.storedGoods.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearContainers() {
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            this.storedGoods.clear();
            Map<GoodsType, Integer> map2 = this.oldStoredGoods;
            synchronized (map2) {
                this.oldStoredGoods.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAbove(int newAmount) {
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            if (newAmount <= 0) {
                this.storedGoods.clear();
                return;
            }
            Predicate hiPred = e -> {
                GoodsType gt = (GoodsType)e.getKey();
                return gt.isStorable() && !gt.limitIgnored() && (Integer)e.getValue() > newAmount;
            };
            CollectionUtils.forEachMapEntry(this.storedGoods, hiPred, e -> this.storedGoods.put((GoodsType)e.getKey(), newAmount));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasReachedCapacity(int amount) {
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            return CollectionUtils.any(this.storedGoods.entrySet(), e -> ((GoodsType)e.getKey()).isStorable() && !((GoodsType)e.getKey()).limitIgnored() && (Integer)e.getValue() > amount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSpaceTaken() {
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            return CollectionUtils.sum(this.storedGoods.values(), amount -> amount % 100 == 0 ? amount / 100 : amount / 100 + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Goods> getGoodsList() {
        Game game = this.getGame();
        ArrayList<Goods> result = new ArrayList<Goods>();
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            CollectionUtils.forEachMapEntry(this.storedGoods, e -> {
                for (int amount = ((Integer)e.getValue()).intValue(); amount > 0; amount -= 100) {
                    result.add(new Goods(game, this.parent, (GoodsType)e.getKey(), amount >= 100 ? 100 : amount));
                }
            });
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Goods> getCompactGoodsList() {
        Game game = this.getGame();
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            return CollectionUtils.transform(this.storedGoods.entrySet(), e -> (Integer)e.getValue() > 0, e -> new Goods(game, this.parent, (GoodsType)e.getKey(), (Integer)e.getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState() {
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            Map<GoodsType, Integer> map2 = this.oldStoredGoods;
            synchronized (map2) {
                this.oldStoredGoods.clear();
                this.oldStoredGoods.putAll(this.storedGoods);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreState() {
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            Map<GoodsType, Integer> map2 = this.oldStoredGoods;
            synchronized (map2) {
                this.storedGoods.clear();
                this.storedGoods.putAll(this.oldStoredGoods);
            }
        }
    }

    public boolean hasChanged() {
        return CollectionUtils.any(this.getSpecification().getGoodsTypeList(), gt -> this.getOldGoodsCount((GoodsType)gt) != this.getGoodsCount((GoodsType)gt));
    }

    public boolean fireChanges() {
        boolean ret = false;
        for (GoodsType type : this.getSpecification().getGoodsTypeList()) {
            int newCount;
            int oldCount = this.getOldGoodsCount(type);
            if (oldCount == (newCount = this.getGoodsCount(type))) continue;
            this.firePropertyChange(type.getId(), oldCount, newCount);
            ret = true;
        }
        return ret;
    }

    public static void moveGoods(GoodsContainer src, GoodsType goodsType, int amount, GoodsContainer dst) {
        if (src != null) {
            src.saveState();
            src.removeGoods(goodsType, amount);
        }
        if (dst != null) {
            dst.saveState();
            dst.addGoods(goodsType, amount);
        }
    }

    @Override
    public Player getOwner() {
        return this.parent instanceof Ownable ? ((Ownable)((Object)this.parent)).getOwner() : null;
    }

    @Override
    public void setOwner(Player p) {
        throw new UnsupportedOperationException("Can not set GoodsContainer owner");
    }

    @Override
    public void disposeResources() {
        this.clearContainers();
        super.disposeResources();
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        GoodsContainer o = this.copyInCast(other, GoodsContainer.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.setStoredGoods(o.getStoredGoods());
        this.setOldStoredGoods(o.getOldStoredGoods());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (xw.validFor(this.getOwner())) {
            Map<GoodsType, Integer> map = this.storedGoods;
            synchronized (map) {
                this.writeStorage(xw, STORED_GOODS_TAG, this.storedGoods);
                Map<GoodsType, Integer> map2 = this.oldStoredGoods;
                synchronized (map2) {
                    this.writeStorage(xw, OLD_STORED_GOODS_TAG, this.oldStoredGoods);
                }
            }
        }
    }

    private void writeStorage(FreeColXMLWriter xw, String tag, Map<GoodsType, Integer> storage) throws XMLStreamException {
        if (storage.isEmpty()) {
            return;
        }
        xw.writeStartElement(tag);
        for (GoodsType goodsType : CollectionUtils.sort(storage.keySet())) {
            xw.writeStartElement("goods");
            xw.writeAttribute(TYPE_TAG, goodsType);
            xw.writeAttribute(AMOUNT_TAG, storage.get(goodsType));
            xw.writeEndElement();
        }
        xw.writeEndElement();
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.clearContainers();
        super.readChildren(xr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (OLD_STORED_GOODS_TAG.equals(tag)) {
            Map<GoodsType, Integer> map = this.oldStoredGoods;
            synchronized (map) {
                this.readStorage(xr, this.oldStoredGoods);
            }
        } else if (STORED_GOODS_TAG.equals(tag)) {
            Map<GoodsType, Integer> map = this.storedGoods;
            synchronized (map) {
                this.readStorage(xr, this.storedGoods);
            }
        } else {
            super.readChild(xr);
        }
    }

    private void readStorage(FreeColXMLReader xr, Map<GoodsType, Integer> storage) throws XMLStreamException {
        Specification spec = this.getGame().getSpecification();
        while (xr.moreTags()) {
            String tag = xr.getLocalName();
            if (!"goods".equals(tag)) {
                throw new XMLStreamException("Bogus GoodsContainer tag: " + tag);
            }
            GoodsType goodsType = xr.getType(spec, TYPE_TAG, GoodsType.class, null);
            int amount = xr.getAttribute(AMOUNT_TAG, 0);
            storage.put(goodsType, amount);
            xr.closeTag(tag);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        String sep = ", ";
        StringBuilder sb = new StringBuilder(128);
        sb.append('[').append(this.getId()).append(" [");
        CollectionUtils.forEachMapEntry(this.storedGoods, e -> sb.append(e.getKey()).append('=').append(e.getValue()).append(", "));
        sb.setLength(sb.length() - ", ".length());
        sb.append("][");
        CollectionUtils.forEachMapEntry(this.oldStoredGoods, e -> sb.append(e.getKey()).append('=').append(e.getValue()).append(", "));
        sb.setLength(sb.length() - ", ".length());
        sb.append("]]");
        return sb.toString();
    }
}

