/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;

public class HighSeas
extends UnitLocation {
    private static final Logger logger = Logger.getLogger(HighSeas.class.getName());
    public static final String TAG = "highSeas";
    private final List<Location> destinations = new ArrayList<Location>();
    private static final String DESTINATION_TAG = "destination";

    public HighSeas(Game game) {
        super(game);
    }

    public HighSeas(Game game, String id) {
        super(game, id);
    }

    public final List<Location> getDestinations() {
        return this.destinations;
    }

    public final String destinationsToString() {
        return StringUtils.join(",", CollectionUtils.transform(this.destinations, CollectionUtils.alwaysTrue(), Location::getId));
    }

    protected void setDestinations(List<Location> destinations) {
        this.destinations.clear();
        this.destinations.addAll(destinations);
    }

    public void addDestination(Location destination) {
        if (destination != null) {
            if (!this.destinations.contains(destination)) {
                this.destinations.add(destination);
            }
        } else {
            logger.warning("Tried to add null destination to " + this.getId());
        }
    }

    public void removeDestination(Location destination) {
        this.destinations.remove(destination);
    }

    @Override
    public StringTemplate getLocationLabel() {
        return StringTemplate.key("model.tile.highSeas.name");
    }

    @Override
    public Location up() {
        return this;
    }

    @Override
    public int getRank() {
        return -1;
    }

    @Override
    public String toShortString() {
        return "HighSeas";
    }

    @Override
    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        return locatable instanceof Unit && ((Unit)locatable).isNaval() ? UnitLocation.NoAddReason.NONE : UnitLocation.NoAddReason.WRONG_TYPE;
    }

    @Override
    public FreeColGameObject getLinkTarget(Player player) {
        return player.getEurope();
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        HighSeas o = this.copyInCast(other, HighSeas.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        Game game = this.getGame();
        this.destinations.clear();
        for (Location loc : o.getDestinations()) {
            this.destinations.add(game.updateLocationRef(loc));
        }
        return true;
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Location loc : CollectionUtils.transform(this.destinations, CollectionUtils.isNotNull())) {
            xw.writeStartElement(DESTINATION_TAG);
            xw.writeLocationAttribute("id", loc);
            xw.writeEndElement();
        }
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.destinations.clear();
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if (DESTINATION_TAG.equals(tag)) {
            this.addDestination(xr.getLocationAttribute(game, "id", true));
            xr.closeTag(DESTINATION_TAG);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        return this.getId();
    }
}

