/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class AbandonColonyMessage
extends AttributeMessage {
    public static final String TAG = "abandonColony";
    private static final String COLONY_TAG = "colony";

    public AbandonColonyMessage(Colony colony) {
        super(TAG, COLONY_TAG, colony.getId());
    }

    public AbandonColonyMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, COLONY_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Colony colony;
        String colonyId = this.getStringAttribute(COLONY_TAG);
        try {
            colony = serverPlayer.getOurFreeColGameObject(colonyId, Colony.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        int count = colony.getUnitCount();
        if (count != 0) {
            return serverPlayer.clientError("Attempt to abandon colony " + colonyId + " with non-zero unit count " + Integer.toString(count));
        }
        return this.igc(freeColServer).abandonSettlement(serverPlayer, colony);
    }
}

