/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.Request;
import com.amazonaws.auth.Signer;
import com.amazonaws.retry.internal.AuthErrorRetryStrategy;
import com.amazonaws.retry.internal.AuthRetryParameters;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.internal.AWSS3V4Signer;
import com.amazonaws.services.s3.internal.BucketNameUtils;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.annotation.Immutable;

@Immutable
public class S3V4AuthErrorRetryStrategy
implements AuthErrorRetryStrategy {
    private static Log log = LogFactory.getLog(AmazonS3Client.class);
    private static final String V4_REGION_WARNING = "please use region-specific endpoint to access buckets located in regions that require V4 signing.";
    private final String bucketName;

    public S3V4AuthErrorRetryStrategy(String bucketName) {
        this.bucketName = bucketName;
    }

    public AuthRetryParameters shouldRetryWithAuthParam(Request<?> originalRequest, AmazonServiceException ase) {
        if (S3V4AuthErrorRetryStrategy.isAwsV4SigningRequiredError(ase)) {
            if (!BucketNameUtils.isDNSBucketName(this.bucketName)) {
                throw new AmazonClientException(V4_REGION_WARNING, (Throwable)ase);
            }
            AWSS3V4Signer v4Signer = new AWSS3V4Signer();
            v4Signer.setRegionName("us-east-1");
            v4Signer.setServiceName("s3");
            URI bucketEndpoint = null;
            try {
                bucketEndpoint = new URI(String.format("https://%s.s3-external-1.amazonaws.com", this.bucketName));
            }
            catch (URISyntaxException e) {
                throw new AmazonClientException("Failed to re-send the request to \"s3-external-1.amazonaws.com\". please use region-specific endpoint to access buckets located in regions that require V4 signing.", (Throwable)e);
            }
            log.warn((Object)("Attempting to re-send the request to " + bucketEndpoint.getHost() + " with AWS V4 authentication. " + "To avoid this warning in the future, " + V4_REGION_WARNING));
            return new AuthRetryParameters((Signer)v4Signer, bucketEndpoint);
        }
        return null;
    }

    private static boolean isAwsV4SigningRequiredError(AmazonServiceException ase) {
        if (ase == null) {
            return false;
        }
        String INVALID_REQUEST = "InvalidRequest";
        String PLEASE_USE_SIGV4 = "Please use AWS4-HMAC-SHA256.";
        String errorCode = ase.getErrorCode();
        String errorMsg = ase.getErrorMessage();
        return "InvalidRequest".equalsIgnoreCase(errorCode) && errorMsg != null && errorMsg.contains("Please use AWS4-HMAC-SHA256.");
    }
}

