/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime;

import io.micrometer.common.annotation.NoOpValueResolver;
import io.micrometer.common.annotation.ValueExpressionResolver;
import io.micrometer.common.annotation.ValueResolver;
import io.micrometer.common.util.StringUtils;
import io.micrometer.core.aop.MeterTag;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.quarkus.arc.All;
import io.quarkus.arc.ArcInvocationContext;
import io.quarkus.arc.ClientProxy;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Singleton
public class MeterTagsSupport {
    private final Map<Class<?>, ValueResolver> valueResolvers;
    private final ValueExpressionResolver valueExpressionResolver;

    public MeterTagsSupport(@All List<ValueResolver> valueResolvers, Instance<ValueExpressionResolver> valueExpressionResolver) {
        this.valueResolvers = MeterTagsSupport.createValueResolverMap(valueResolvers);
        this.valueExpressionResolver = valueExpressionResolver.isUnsatisfied() ? null : (ValueExpressionResolver)valueExpressionResolver.get();
    }

    Tags getTags(ArcInvocationContext context) {
        return MeterTagsSupport.getCommonTags(context).and((Iterable)this.getMeterTags(context));
    }

    private Tags getMeterTags(ArcInvocationContext context) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        Method method = context.getMethod();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter methodParameter = parameters[i];
            MeterTag annotation = methodParameter.getAnnotation(MeterTag.class);
            if (annotation == null) continue;
            Object parameterValue = context.getParameters()[i];
            tags.add(Tag.of((String)MeterTagsSupport.resolveTagKey(annotation, methodParameter.getName()), (String)this.resolveTagValue(annotation, parameterValue)));
        }
        return Tags.of(tags);
    }

    private static Tags getCommonTags(ArcInvocationContext context) {
        Method method = context.getMethod();
        String className = method.getDeclaringClass().getName();
        String methodName = method.getName();
        return Tags.of((String[])new String[]{"class", className, "method", methodName});
    }

    private String resolveTagValue(MeterTag annotation, Object parameterValue) {
        if (annotation.resolver() != NoOpValueResolver.class) {
            ValueResolver valueResolver = this.valueResolvers.get(annotation.resolver());
            return valueResolver.resolve(parameterValue);
        }
        if (StringUtils.isNotBlank((String)annotation.expression())) {
            if (this.valueExpressionResolver == null) {
                throw new IllegalArgumentException("No valueExpressionResolver is defined");
            }
            return this.valueExpressionResolver.resolve(annotation.expression(), parameterValue);
        }
        if (parameterValue != null) {
            return parameterValue.toString();
        }
        return "";
    }

    private static String resolveTagKey(MeterTag annotation, String parameterName) {
        if (StringUtils.isNotBlank((String)annotation.value())) {
            return annotation.value();
        }
        if (StringUtils.isNotBlank((String)annotation.key())) {
            return annotation.key();
        }
        return parameterName;
    }

    private static Map<Class<?>, ValueResolver> createValueResolverMap(List<ValueResolver> valueResolvers) {
        HashMap valueResolverMap = new HashMap();
        for (ValueResolver valueResolver : valueResolvers) {
            ValueResolver instance = (ValueResolver)ClientProxy.unwrap((Object)valueResolver);
            valueResolverMap.put(instance.getClass(), valueResolver);
        }
        return valueResolverMap;
    }
}

