/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace.node;

import com.google.inject.Inject;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.generator.trace.node.GeneratorWhiteSpaceConfig;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.generator.trace.node.IndentNode;
import org.eclipse.xtext.generator.trace.node.NewLineNode;
import org.eclipse.xtext.generator.trace.node.TemplateNode;
import org.eclipse.xtext.generator.trace.node.TextNode;
import org.eclipse.xtext.generator.trace.node.TraceNode;

public class GeneratorNodeExtensions {
    @Inject
    private GeneratorWhiteSpaceConfig wsConfig = new GeneratorWhiteSpaceConfig();

    public CompositeGeneratorNode trace(ILocationData data) {
        return new TraceNode(data);
    }

    public CompositeGeneratorNode trace(ILocationData data, boolean useForDebugging) {
        TraceNode result = new TraceNode(data);
        result.setUseForDebugging(useForDebugging);
        return result;
    }

    public CompositeGeneratorNode trace(CompositeGeneratorNode parent, ILocationData data) {
        TraceNode result = new TraceNode(data);
        parent.getChildren().add(result);
        return result;
    }

    public CompositeGeneratorNode trace(CompositeGeneratorNode parent, ILocationData data, boolean useForDebugging) {
        TraceNode result = new TraceNode(data);
        result.setUseForDebugging(useForDebugging);
        parent.getChildren().add(result);
        return result;
    }

    public CompositeGeneratorNode indent(CompositeGeneratorNode parent) {
        return this.indent(parent, this.wsConfig.getIndentationString());
    }

    public CompositeGeneratorNode indent(CompositeGeneratorNode parent, String indentString) {
        IndentNode indent = new IndentNode(indentString);
        parent.getChildren().add(indent);
        return indent;
    }

    public CompositeGeneratorNode appendNewLine(CompositeGeneratorNode parent) {
        parent.getChildren().add(new NewLineNode(this.wsConfig.getLineDelimiter(), false));
        return parent;
    }

    public CompositeGeneratorNode appendNewLine(CompositeGeneratorNode parent, String lineSeparator) {
        parent.getChildren().add(new NewLineNode(lineSeparator, false));
        return parent;
    }

    public CompositeGeneratorNode appendNewLineIfNotEmpty(CompositeGeneratorNode parent) {
        parent.getChildren().add(new NewLineNode(this.wsConfig.getLineDelimiter(), true));
        return parent;
    }

    public CompositeGeneratorNode append(CompositeGeneratorNode parent, Object object) {
        if (object instanceof StringConcatenationClient) {
            this.appendTemplate(parent, (StringConcatenationClient)object);
        } else if (object instanceof IGeneratorNode) {
            parent.getChildren().add((IGeneratorNode)object);
        } else if (object != null) {
            parent.getChildren().add(new TextNode(object.toString()));
        }
        return parent;
    }

    public CompositeGeneratorNode appendTemplate(CompositeGeneratorNode parent, StringConcatenationClient templateString) {
        TemplateNode proc = new TemplateNode(templateString, this);
        parent.getChildren().add(proc);
        return parent;
    }
}

