/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import javax.jmdns.impl.DNSCache;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSListener;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.DNSState;
import javax.jmdns.impl.HostInfo;
import javax.jmdns.impl.ServiceEventImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.SocketListener;
import javax.jmdns.impl.tasks.Announcer;
import javax.jmdns.impl.tasks.Canceler;
import javax.jmdns.impl.tasks.Prober;
import javax.jmdns.impl.tasks.RecordReaper;
import javax.jmdns.impl.tasks.Renewer;
import javax.jmdns.impl.tasks.Responder;
import javax.jmdns.impl.tasks.ServiceInfoResolver;
import javax.jmdns.impl.tasks.ServiceResolver;
import javax.jmdns.impl.tasks.TypeResolver;

public class JmDNSImpl
extends JmDNS {
    private static Logger logger = Logger.getLogger(JmDNSImpl.class.getName());
    private InetAddress group;
    private MulticastSocket socket;
    private boolean closed = false;
    private List listeners;
    private Map serviceListeners;
    private List typeListeners;
    private DNSCache cache;
    Map services;
    Map serviceTypes;
    private Thread shutdown;
    private HostInfo localHost;
    private Thread incomingListener = null;
    private int throttle;
    private long lastThrottleIncrement;
    Timer timer;
    private static final Random random = new Random();
    private Object ioLock = new Object();
    private DNSIncoming plannedAnswer;
    private DNSState state = DNSState.PROBING_1;
    private TimerTask task;
    private final HashMap serviceCollectors = new HashMap();

    public JmDNSImpl() throws IOException {
        logger.finer("JmDNS instance created");
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.init(addr.isLoopbackAddress() ? null : addr, addr.getHostName());
        }
        catch (IOException e) {
            this.init(null, "computer");
        }
    }

    public JmDNSImpl(InetAddress addr) throws IOException {
        try {
            this.init(addr, addr.getHostName());
        }
        catch (IOException e) {
            this.init(null, "computer");
        }
    }

    private void init(InetAddress address, String name) throws IOException {
        int idx = name.indexOf(".");
        if (idx > 0) {
            name = name.substring(0, idx);
        }
        name = name + ".local.";
        this.localHost = new HostInfo(address, name);
        this.cache = new DNSCache(100);
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.serviceListeners = new HashMap();
        this.typeListeners = new ArrayList();
        this.services = new Hashtable(20);
        this.serviceTypes = new Hashtable(20);
        this.timer = new Timer();
        new RecordReaper(this).start(this.timer);
        this.shutdown = new Thread((Runnable)new Shutdown(), "JmDNS.Shutdown");
        Runtime.getRuntime().addShutdownHook(this.shutdown);
        this.incomingListener = new Thread((Runnable)new SocketListener(this), "JmDNS.SocketListener");
        this.openMulticastSocket(this.getLocalHost());
        this.start(this.getServices().values());
    }

    private void start(Collection serviceInfos) {
        this.setState(DNSState.PROBING_1);
        this.incomingListener.start();
        new Prober(this).start(this.timer);
        Iterator iterator = serviceInfos.iterator();
        while (iterator.hasNext()) {
            try {
                this.registerService(new ServiceInfoImpl((ServiceInfoImpl)iterator.next()));
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "start() Registration exception ", exception);
            }
        }
    }

    private void openMulticastSocket(HostInfo hostInfo) throws IOException {
        if (this.group == null) {
            this.group = InetAddress.getByName("224.0.0.251");
        }
        if (this.socket != null) {
            this.closeMulticastSocket();
        }
        this.socket = new MulticastSocket(5353);
        if (hostInfo != null && this.localHost.getInterface() != null) {
            this.socket.setNetworkInterface(hostInfo.getInterface());
        }
        this.socket.setTimeToLive(255);
        this.socket.joinGroup(this.group);
    }

    private void closeMulticastSocket() {
        logger.finer("closeMulticastSocket()");
        if (this.socket != null) {
            try {
                this.socket.leaveGroup(this.group);
                this.socket.close();
                if (this.incomingListener != null) {
                    this.incomingListener.join();
                }
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "closeMulticastSocket() Close socket exception ", exception);
            }
            this.socket = null;
        }
    }

    public synchronized void advanceState() {
        this.setState(this.getState().advance());
        this.notifyAll();
    }

    synchronized void revertState() {
        this.setState(this.getState().revert());
        this.notifyAll();
    }

    synchronized void cancel() {
        this.setState(DNSState.CANCELED);
        this.notifyAll();
    }

    public DNSState getState() {
        return this.state;
    }

    public DNSCache getCache() {
        return this.cache;
    }

    public String getHostName() {
        return this.localHost.getName();
    }

    public HostInfo getLocalHost() {
        return this.localHost;
    }

    public InetAddress getInterface() throws IOException {
        return this.socket.getInterface();
    }

    public ServiceInfo getServiceInfo(String type, String name) {
        return this.getServiceInfo(type, name, 3000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo getServiceInfo(String type, String name, int timeout) {
        ServiceInfoImpl info = new ServiceInfoImpl(type, name);
        new ServiceInfoResolver(this, info).start(this.timer);
        try {
            long end = System.currentTimeMillis() + (long)timeout;
            ServiceInfoImpl serviceInfoImpl = info;
            synchronized (serviceInfoImpl) {
                long delay;
                while (!info.hasData() && (delay = end - System.currentTimeMillis()) > 0L) {
                    info.wait(delay);
                }
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return info.hasData() ? info : null;
    }

    public void requestServiceInfo(String type, String name) {
        this.requestServiceInfo(type, name, 3000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestServiceInfo(String type, String name, int timeout) {
        this.registerServiceType(type);
        ServiceInfoImpl info = new ServiceInfoImpl(type, name);
        new ServiceInfoResolver(this, info).start(this.timer);
        try {
            long end = System.currentTimeMillis() + (long)timeout;
            ServiceInfoImpl serviceInfoImpl = info;
            synchronized (serviceInfoImpl) {
                long delay;
                while (!info.hasData() && (delay = end - System.currentTimeMillis()) > 0L) {
                    info.wait(delay);
                }
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleServiceResolved(ServiceInfoImpl info) {
        List list = null;
        ArrayList listCopy = null;
        Map map = this.serviceListeners;
        synchronized (map) {
            list = (List)this.serviceListeners.get(info.type.toLowerCase());
            if (list != null) {
                listCopy = new ArrayList(list);
            }
        }
        if (listCopy != null) {
            ServiceEventImpl event = new ServiceEventImpl(this, info.type, info.getName(), info);
            Iterator iterator = listCopy.iterator();
            while (iterator.hasNext()) {
                ((ServiceListener)iterator.next()).serviceResolved(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceTypeListener(ServiceTypeListener listener) throws IOException {
        JmDNSImpl jmDNSImpl = this;
        synchronized (jmDNSImpl) {
            this.typeListeners.remove(listener);
            this.typeListeners.add(listener);
        }
        Iterator iterator = this.serviceTypes.values().iterator();
        while (iterator.hasNext()) {
            listener.serviceTypeAdded(new ServiceEventImpl(this, (String)iterator.next(), null, null));
        }
        new TypeResolver(this).start(this.timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceTypeListener(ServiceTypeListener listener) {
        JmDNSImpl jmDNSImpl = this;
        synchronized (jmDNSImpl) {
            this.typeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceListener(String type, ServiceListener listener) {
        String lotype = type.toLowerCase();
        this.removeServiceListener(lotype, listener);
        List<ServiceListener> list = null;
        Map map = this.serviceListeners;
        synchronized (map) {
            list = (List<ServiceListener>)this.serviceListeners.get(lotype);
            if (list == null) {
                list = Collections.synchronizedList(new LinkedList());
                this.serviceListeners.put(lotype, list);
            }
            list.add(listener);
        }
        ArrayList<ServiceEventImpl> serviceEvents = new ArrayList<ServiceEventImpl>();
        DNSCache dNSCache = this.cache;
        synchronized (dNSCache) {
            Iterator i = this.cache.iterator();
            while (i.hasNext()) {
                for (DNSCache.CacheNode n = (DNSCache.CacheNode)i.next(); n != null; n = n.next()) {
                    DNSRecord rec = (DNSRecord)n.getValue();
                    if (rec.type != 33 || !rec.name.endsWith(type)) continue;
                    serviceEvents.add(new ServiceEventImpl(this, type, JmDNSImpl.toUnqualifiedName(type, rec.name), null));
                }
            }
        }
        Iterator i = serviceEvents.iterator();
        while (i.hasNext()) {
            listener.serviceAdded((ServiceEventImpl)i.next());
        }
        new ServiceResolver(this, type).start(this.timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(String type, ServiceListener listener) {
        type = type.toLowerCase();
        List list = null;
        Map map = this.serviceListeners;
        synchronized (map) {
            list = (List)this.serviceListeners.get(type);
            if (list != null) {
                list.remove(listener);
                if (list.size() == 0) {
                    this.serviceListeners.remove(type);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerService(ServiceInfo infoAbstract) throws IOException {
        ServiceInfoImpl info = (ServiceInfoImpl)infoAbstract;
        this.registerServiceType(info.type);
        info.server = this.localHost.getName();
        info.addr = this.localHost.getAddress();
        Object object = this;
        synchronized (object) {
            this.makeServiceNameUnique(info);
            this.services.put(info.getQualifiedName().toLowerCase(), info);
        }
        new Prober(this).start(this.timer);
        try {
            object = info;
            synchronized (object) {
                while (info.getState().compareTo(DNSState.ANNOUNCED) < 0) {
                    info.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.fine("registerService() JmDNS registered service as " + info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(ServiceInfo infoAbstract) {
        ServiceInfoImpl info = (ServiceInfoImpl)infoAbstract;
        JmDNSImpl jmDNSImpl = this;
        synchronized (jmDNSImpl) {
            this.services.remove(info.getQualifiedName().toLowerCase());
        }
        info.cancel();
        Object lock = new Object();
        new Canceler(this, info, lock).start(this.timer);
        try {
            Object object = lock;
            synchronized (object) {
                lock.wait();
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAllServices() {
        LinkedList list;
        logger.finer("unregisterAllServices()");
        if (this.services.size() == 0) {
            return;
        }
        JmDNSImpl jmDNSImpl = this;
        synchronized (jmDNSImpl) {
            list = new LinkedList(this.services.values());
            this.services.clear();
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((ServiceInfoImpl)iterator.next()).cancel();
        }
        Object lock = new Object();
        new Canceler(this, list, lock).start(this.timer);
        try {
            Object object = lock;
            synchronized (object) {
                if (!this.closed) {
                    lock.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServiceType(String type) {
        String name = type.toLowerCase();
        if (this.serviceTypes.get(name) == null && type.indexOf("._mdns._udp.") < 0 && !type.endsWith(".in-addr.arpa.")) {
            LinkedList list;
            JmDNSImpl jmDNSImpl = this;
            synchronized (jmDNSImpl) {
                this.serviceTypes.put(name, type);
                list = new LinkedList(this.typeListeners);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ((ServiceTypeListener)iterator.next()).serviceTypeAdded(new ServiceEventImpl(this, type, null, null));
            }
        }
    }

    private boolean makeHostNameUnique(DNSRecord.Address host) {
        boolean collision;
        String originalName = host.getName();
        System.currentTimeMillis();
        do {
            collision = false;
            for (DNSCache.CacheNode j = this.cache.find(host.getName().toLowerCase()); j != null; j = j.next()) {
            }
        } while (collision);
        return !originalName.equals(host.getName());
    }

    private boolean makeServiceNameUnique(ServiceInfoImpl info) {
        boolean collision;
        String originalQualifiedName = info.getQualifiedName();
        long now = System.currentTimeMillis();
        do {
            Object selfService;
            collision = false;
            for (DNSCache.CacheNode j = this.cache.find(info.getQualifiedName().toLowerCase()); j != null; j = j.next()) {
                DNSRecord a = (DNSRecord)j.getValue();
                if (a.type != 33 || a.isExpired(now)) continue;
                DNSRecord.Service s = (DNSRecord.Service)a;
                if (s.port == info.port && s.server.equals(this.localHost.getName())) continue;
                logger.finer("makeServiceNameUnique() JmDNS.makeServiceNameUnique srv collision:" + a + " s.server=" + s.server + " " + this.localHost.getName() + " equals:" + s.server.equals(this.localHost.getName()));
                info.setName(this.incrementName(info.getName()));
                collision = true;
                break;
            }
            if ((selfService = this.services.get(info.getQualifiedName().toLowerCase())) == null || selfService == info) continue;
            info.setName(this.incrementName(info.getName()));
            collision = true;
        } while (collision);
        return !originalQualifiedName.equals(info.getQualifiedName());
    }

    String incrementName(String name) {
        try {
            int l = name.lastIndexOf(40);
            int r = name.lastIndexOf(41);
            name = l >= 0 && l < r ? name.substring(0, l) + "(" + (Integer.parseInt(name.substring(l + 1, r)) + 1) + ")" : name + " (2)";
        }
        catch (NumberFormatException e) {
            name = name + " (2)";
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DNSListener listener, DNSQuestion question) {
        long now = System.currentTimeMillis();
        JmDNSImpl jmDNSImpl = this;
        synchronized (jmDNSImpl) {
            this.listeners.add(listener);
        }
        if (question != null) {
            for (DNSCache.CacheNode i = this.cache.find(question.name); i != null; i = i.next()) {
                DNSRecord c = (DNSRecord)i.getValue();
                if (!question.answeredBy(c) || c.isExpired(now)) continue;
                listener.updateRecord(this, now, c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DNSListener listener) {
        JmDNSImpl jmDNSImpl = this;
        synchronized (jmDNSImpl) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(long now, DNSRecord rec) {
        block13: {
            Object listener2;
            ArrayList listenerList = null;
            JmDNSImpl jmDNSImpl = this;
            synchronized (jmDNSImpl) {
                listenerList = new ArrayList(this.listeners);
            }
            for (Object listener2 : listenerList) {
                listener2.updateRecord(this, now, rec);
            }
            if (rec.type != 12 && rec.type != 33) break block13;
            ArrayList serviceListenerList = null;
            listener2 = this.serviceListeners;
            synchronized (listener2) {
                serviceListenerList = (ArrayList)this.serviceListeners.get(rec.name.toLowerCase());
                if (serviceListenerList != null) {
                    serviceListenerList = new ArrayList(serviceListenerList);
                }
            }
            if (serviceListenerList != null) {
                boolean expired = rec.isExpired(now);
                String type = rec.getName();
                String name = ((DNSRecord.Pointer)rec).getAlias();
                if (!expired) {
                    ServiceEventImpl event = new ServiceEventImpl(this, type, JmDNSImpl.toUnqualifiedName(type, name), null);
                    Iterator iterator = serviceListenerList.iterator();
                    while (iterator.hasNext()) {
                        ((ServiceListener)iterator.next()).serviceAdded(event);
                    }
                } else {
                    ServiceEventImpl event = new ServiceEventImpl(this, type, JmDNSImpl.toUnqualifiedName(type, name), null);
                    Iterator iterator = serviceListenerList.iterator();
                    while (iterator.hasNext()) {
                        ((ServiceListener)iterator.next()).serviceRemoved(event);
                    }
                }
            }
        }
    }

    void handleResponse(DNSIncoming msg) throws IOException {
        long now = System.currentTimeMillis();
        boolean hostConflictDetected = false;
        boolean serviceConflictDetected = false;
        Iterator i = msg.answers.iterator();
        block3: while (i.hasNext()) {
            boolean isInformative = false;
            DNSRecord rec = (DNSRecord)i.next();
            boolean expired = rec.isExpired(now);
            DNSRecord c = (DNSRecord)this.cache.get(rec);
            if (c != null) {
                if (expired) {
                    isInformative = true;
                    this.cache.remove(c);
                } else {
                    c.resetTTL(rec);
                    rec = c;
                }
            } else if (!expired) {
                isInformative = true;
                this.cache.add(rec);
            }
            switch (rec.type) {
                case 12: {
                    if (rec.getName().indexOf("._mdns._udp.") >= 0) {
                        if (expired || !rec.name.startsWith("_services._mdns._udp.")) continue block3;
                        isInformative = true;
                        this.registerServiceType(((DNSRecord.Pointer)rec).alias);
                        continue block3;
                    }
                    this.registerServiceType(rec.name);
                }
            }
            if (rec.getType() == 1 || rec.getType() == 28) {
                hostConflictDetected |= rec.handleResponse(this);
            } else {
                serviceConflictDetected |= rec.handleResponse(this);
            }
            if (!isInformative) continue;
            this.updateRecord(now, rec);
        }
        if (hostConflictDetected || serviceConflictDetected) {
            new Prober(this).start(this.timer);
        }
    }

    void handleQuery(DNSIncoming in, InetAddress addr, int port) throws IOException {
        boolean hostConflictDetected = false;
        boolean serviceConflictDetected = false;
        long expirationTime = System.currentTimeMillis() + 120L;
        for (DNSRecord answer : in.answers) {
            if (answer.getType() == 1 || answer.getType() == 28) {
                hostConflictDetected |= answer.handleQuery(this, expirationTime);
                continue;
            }
            serviceConflictDetected |= answer.handleQuery(this, expirationTime);
        }
        if (this.plannedAnswer != null) {
            this.plannedAnswer.append(in);
        } else {
            if (in.isTruncated()) {
                this.plannedAnswer = in;
            }
            new Responder(this, in, addr, port).start();
        }
        if (hostConflictDetected || serviceConflictDetected) {
            new Prober(this).start(this.timer);
        }
    }

    public DNSOutgoing addAnswer(DNSIncoming in, InetAddress addr, int port, DNSOutgoing out, DNSRecord rec) throws IOException {
        if (out == null) {
            out = new DNSOutgoing(33792);
        }
        try {
            out.addAnswer(in, rec);
        }
        catch (IOException e) {
            out.flags |= 0x200;
            out.id = in.id;
            out.finish();
            this.send(out);
            out = new DNSOutgoing(33792);
            out.addAnswer(in, rec);
        }
        return out;
    }

    public void send(DNSOutgoing out) throws IOException {
        out.finish();
        if (!out.isEmpty()) {
            DatagramPacket packet = new DatagramPacket(out.data, out.off, this.group, 5353);
            try {
                DNSIncoming msg = new DNSIncoming(packet);
                logger.finest("send() JmDNS out:" + msg.print(true));
            }
            catch (IOException e) {
                logger.throwing(this.getClass().toString(), "send(DNSOutgoing) - JmDNS can not parse what it sends!!!", e);
            }
            MulticastSocket ms = this.socket;
            if (ms != null && !ms.isClosed()) {
                ms.send(packet);
            }
        }
    }

    public void startAnnouncer() {
        new Announcer(this).start(this.timer);
    }

    public void startRenewer() {
        new Renewer(this).start(this.timer);
    }

    public void schedule(TimerTask task, int delay) {
        this.timer.schedule(task, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() {
        logger.finer("recover()");
        if (DNSState.CANCELED != this.getState()) {
            JmDNSImpl jmDNSImpl = this;
            synchronized (jmDNSImpl) {
                logger.finer("recover() Cleanning up");
                this.setState(DNSState.CANCELED);
                ArrayList oldServiceInfos = new ArrayList(this.getServices().values());
                this.unregisterAllServices();
                this.disposeServiceCollectors();
                this.closeMulticastSocket();
                this.cache.clear();
                logger.finer("recover() All is clean");
                try {
                    this.openMulticastSocket(this.getLocalHost());
                    this.start(oldServiceInfos);
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "recover() Start services exception ", exception);
                }
                logger.log(Level.WARNING, "recover() We are back!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.getState() != DNSState.CANCELED) {
            JmDNSImpl jmDNSImpl = this;
            synchronized (jmDNSImpl) {
                this.setState(DNSState.CANCELED);
                this.unregisterAllServices();
                this.disposeServiceCollectors();
                this.closeMulticastSocket();
                this.timer.cancel();
                if (this.shutdown != null) {
                    Runtime.getRuntime().removeShutdownHook(this.shutdown);
                }
            }
        }
    }

    void print() {
        System.out.println("---- cache ----");
        this.cache.print();
        System.out.println();
    }

    public void printServices() {
        System.err.println(this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer aLog = new StringBuffer();
        aLog.append("\t---- Services -----");
        if (this.services != null) {
            for (Object key : this.services.keySet()) {
                aLog.append("\n\t\tService: " + key + ": " + this.services.get(key));
            }
        }
        aLog.append("\n");
        aLog.append("\t---- Types ----");
        if (this.serviceTypes != null) {
            for (Object key : this.serviceTypes.keySet()) {
                aLog.append("\n\t\tType: " + key + ": " + this.serviceTypes.get(key));
            }
        }
        aLog.append("\n");
        aLog.append(this.cache.toString());
        aLog.append("\n");
        aLog.append("\t---- Service Collectors ----");
        if (this.serviceCollectors != null) {
            HashMap hashMap = this.serviceCollectors;
            synchronized (hashMap) {
                for (Object key : this.serviceCollectors.keySet()) {
                    aLog.append("\n\t\tService Collector: " + key + ": " + this.serviceCollectors.get(key));
                }
                this.serviceCollectors.clear();
            }
        }
        return aLog.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo[] list(String type) {
        boolean newCollectorCreated;
        ServiceCollector collector;
        HashMap hashMap = this.serviceCollectors;
        synchronized (hashMap) {
            collector = (ServiceCollector)this.serviceCollectors.get(type);
            if (collector == null) {
                collector = new ServiceCollector(type);
                this.serviceCollectors.put(type, collector);
                this.addServiceListener(type, collector);
                newCollectorCreated = true;
            } else {
                newCollectorCreated = false;
            }
        }
        if (newCollectorCreated) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return collector.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeServiceCollectors() {
        logger.finer("disposeServiceCollectors()");
        HashMap hashMap = this.serviceCollectors;
        synchronized (hashMap) {
            for (ServiceCollector collector : this.serviceCollectors.values()) {
                this.removeServiceListener(collector.type, collector);
            }
            this.serviceCollectors.clear();
        }
    }

    private static String toUnqualifiedName(String type, String qualifiedName) {
        if (qualifiedName.endsWith(type)) {
            return qualifiedName.substring(0, qualifiedName.length() - type.length() - 1);
        }
        return qualifiedName;
    }

    public void setState(DNSState state) {
        this.state = state;
    }

    public void setTask(TimerTask task) {
        this.task = task;
    }

    public TimerTask getTask() {
        return this.task;
    }

    public Map getServices() {
        return this.services;
    }

    public void setLastThrottleIncrement(long lastThrottleIncrement) {
        this.lastThrottleIncrement = lastThrottleIncrement;
    }

    public long getLastThrottleIncrement() {
        return this.lastThrottleIncrement;
    }

    public void setThrottle(int throttle) {
        this.throttle = throttle;
    }

    public int getThrottle() {
        return this.throttle;
    }

    public static Random getRandom() {
        return random;
    }

    public void setIoLock(Object ioLock) {
        this.ioLock = ioLock;
    }

    public Object getIoLock() {
        return this.ioLock;
    }

    public void setPlannedAnswer(DNSIncoming plannedAnswer) {
        this.plannedAnswer = plannedAnswer;
    }

    public DNSIncoming getPlannedAnswer() {
        return this.plannedAnswer;
    }

    void setLocalHost(HostInfo localHost) {
        this.localHost = localHost;
    }

    public Map getServiceTypes() {
        return this.serviceTypes;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public MulticastSocket getSocket() {
        return this.socket;
    }

    public InetAddress getGroup() {
        return this.group;
    }

    private static class ServiceCollector
    implements ServiceListener {
        private static Logger logger = Logger.getLogger(ServiceCollector.class.getName());
        private final Map infos = Collections.synchronizedMap(new HashMap());
        public String type;

        public ServiceCollector(String type) {
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceAdded(ServiceEvent event) {
            Map map = this.infos;
            synchronized (map) {
                event.getDNS().requestServiceInfo(event.getType(), event.getName(), 0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceRemoved(ServiceEvent event) {
            Map map = this.infos;
            synchronized (map) {
                this.infos.remove(event.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceResolved(ServiceEvent event) {
            Map map = this.infos;
            synchronized (map) {
                this.infos.put(event.getName(), event.getInfo());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServiceInfoImpl[] list() {
            Map map = this.infos;
            synchronized (map) {
                return this.infos.values().toArray(new ServiceInfoImpl[this.infos.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuffer aLog = new StringBuffer();
            Map map = this.infos;
            synchronized (map) {
                for (Object key : this.infos.keySet()) {
                    aLog.append("\n\t\tService: " + key + ": " + this.infos.get(key));
                }
            }
            return aLog.toString();
        }
    }

    private class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        public void run() {
            JmDNSImpl.this.shutdown = null;
            JmDNSImpl.this.close();
        }
    }
}

