/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import java.util.Locale;
import java.util.Objects;

public interface DataType {
    public static DataType create(String type) {
        try {
            return ScalarType.valueOf(type.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return new NamedType(Objects.requireNonNull(type));
        }
    }

    public static MapType create(DataType keyType, DataType valueType) {
        return new MapType(Objects.requireNonNull(keyType, "keyType"), Objects.requireNonNull(valueType, "valueType"));
    }

    public Kind kind();

    public static enum ScalarType implements DataType
    {
        ANY,
        BOOL,
        BYTES,
        DOUBLE,
        FLOAT,
        FIXED32,
        FIXED64,
        INT32,
        INT64,
        SFIXED32,
        SFIXED64,
        SINT32,
        SINT64,
        STRING,
        UINT32,
        UINT64;


        @Override
        public Kind kind() {
            return Kind.SCALAR;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    public static final class NamedType
    implements DataType {
        private final String name;

        private NamedType(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        @Override
        public Kind kind() {
            return Kind.NAMED;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamedType namedType = (NamedType)o;
            return Objects.equals(this.name, namedType.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }

    public static final class MapType
    implements DataType {
        private final DataType keyType;
        private final DataType valueType;

        private MapType(DataType keyType, DataType valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        public Kind kind() {
            return Kind.MAP;
        }

        public DataType keyType() {
            return this.keyType;
        }

        public DataType valueType() {
            return this.valueType;
        }
    }

    public static enum Kind {
        SCALAR,
        MAP,
        NAMED;

    }
}

