/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec3(22u, 23u, 4u) << ivec3(22, 23, 4)) => uvec3(92274688u, 192937984u, 64u)
 * (uvec3(22u, 23u, 4u) << ivec3(19, 1, 13)) => uvec3(11534336u, 46u, 32768u)
 * (uvec3(19u, 1u, 13u) << ivec3(22, 23, 4)) => uvec3(79691776u, 8388608u, 208u)
 * (uvec3(19u, 1u, 13u) << ivec3(19, 1, 13)) => uvec3(9961472u, 2u, 106496u)
 */
#version 150

void main()
{
  float[all(equal((uvec3(22u, 23u, 4u) << ivec3(22, 23, 4)), uvec3(92274688u, 192937984u, 64u))) ? 1 : -1] array0;
  float[all(equal((uvec3(22u, 23u, 4u) << ivec3(19, 1, 13)), uvec3(11534336u, 46u, 32768u))) ? 1 : -1] array1;
  float[all(equal((uvec3(19u, 1u, 13u) << ivec3(22, 23, 4)), uvec3(79691776u, 8388608u, 208u))) ? 1 : -1] array2;
  float[all(equal((uvec3(19u, 1u, 13u) << ivec3(19, 1, 13)), uvec3(9961472u, 2u, 106496u))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
