/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.immutable.reference;

import com.android.tools.smali.dexlib2.base.reference.BaseMethodReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableReference;
import com.android.tools.smali.dexlib2.immutable.util.CharSequenceConverter;
import com.google.common.collect.ImmutableList;

public class ImmutableMethodReference
extends BaseMethodReference
implements ImmutableReference {
    protected final String definingClass;
    protected final String name;
    protected final ImmutableList<String> parameters;
    protected final String returnType;

    public ImmutableMethodReference(String definingClass, String name, Iterable<? extends CharSequence> parameters, String returnType) {
        this.definingClass = definingClass;
        this.name = name;
        this.parameters = CharSequenceConverter.immutableStringList(parameters);
        this.returnType = returnType;
    }

    public static ImmutableMethodReference of(MethodReference methodReference) {
        if (methodReference instanceof ImmutableMethodReference) {
            return (ImmutableMethodReference)methodReference;
        }
        return new ImmutableMethodReference(methodReference.getDefiningClass(), methodReference.getName(), methodReference.getParameterTypes(), methodReference.getReturnType());
    }

    @Override
    public String getDefiningClass() {
        return this.definingClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ImmutableList<String> getParameterTypes() {
        return this.parameters;
    }

    @Override
    public String getReturnType() {
        return this.returnType;
    }
}

