/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CharacterStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DTVExecuteOp;
import com.microsoft.sqlserver.jdbc.InputStreamArgs;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;

final class Parameter {
    private static final String NULL = "null";
    private boolean isOutput;
    private int registeredOutJdbcType = 999;
    private int outScale = 4;
    String name;
    private DTV outDTV;
    private DTV inDTV;
    private DTV dtv;
    private boolean inBatch = false;
    private TypeInfo typeInfo = new TypeInfo();

    Parameter() {
    }

    boolean isOutput() {
        return this.isOutput;
    }

    int getJdbcType() throws SQLServerException {
        return null != this.inDTV ? this.inDTV.getJdbcType() : this.registeredOutJdbcType;
    }

    void registerForOutput(int n) {
        this.isOutput = true;
        this.registeredOutJdbcType = n;
    }

    int getOutScale() {
        return this.outScale;
    }

    void setOutScale(int n) {
        this.outScale = n;
    }

    DTV getBatchValue() {
        this.inBatch = true;
        return this.inDTV;
    }

    void setBatchValue(DTV dTV) throws SQLServerException {
        this.dtv = this.inDTV = dTV;
    }

    TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    void clearInputValue() {
        this.dtv = this.outDTV;
        this.inDTV = null;
    }

    int setFromTDS(int n, byte[] byArray) throws SQLServerException {
        if (null == this.outDTV) {
            this.outDTV = new DTV();
        }
        n = this.outDTV.setFromTDS(this.typeInfo, n, byArray, true);
        this.dtv = this.outDTV;
        return n;
    }

    int setFromReturnStatus(int n, byte[] byArray) throws SQLServerException {
        if (null == this.outDTV) {
            this.outDTV = new DTV();
        }
        this.outDTV.setValue(4, new Integer(Util.readInt(byArray, n)), null);
        this.dtv = this.outDTV;
        return n += 4;
    }

    void setValue(int n, Object object) throws SQLServerException {
        this.setValue(n, object, null);
    }

    void setValue(int n, Object object, Object object2) throws SQLServerException {
        DTV dTV = this.inDTV;
        if (this.inBatch || null == this.inDTV) {
            dTV = new DTV();
        }
        dTV.setValue(n, object, object2);
        this.dtv = this.inDTV = dTV;
        this.inBatch = false;
    }

    boolean isNull() {
        return this.outDTV.isNull();
    }

    Object getValue(int n) throws SQLServerException {
        return this.getValue(n, null);
    }

    Object getValue(int n, Object object) throws SQLServerException {
        return this.outDTV.getValue(n, this.outScale, object);
    }

    byte getByte() throws SQLServerException {
        return this.outDTV.getByte();
    }

    int getInt() throws SQLServerException {
        return this.outDTV.getInt();
    }

    short getShort() throws SQLServerException {
        return this.outDTV.getShort();
    }

    String getTypeDefinition(boolean bl) throws SQLServerException {
        DTV dTV = this.dtv;
        int n = this.getJdbcType();
        if (null == this.dtv) {
            if (!this.isOutput) {
                return null;
            }
            dTV = new DTV();
            dTV.setValue(n, null, null);
        }
        GetTypeDefinitionOp getTypeDefinitionOp = new GetTypeDefinitionOp(this, bl);
        DTV.executeOp(dTV, getTypeDefinitionOp, dTV.getValue(n, this.outScale, null), n);
        return getTypeDefinitionOp.getTypeDefinition();
    }

    void sendByRPC(TDSWriter tDSWriter, SQLServerConnection sQLServerConnection, int n) throws SQLServerException {
        DTV dTV = this.inDTV;
        int n2 = this.getJdbcType();
        if (null == dTV) {
            if (!this.isOutput) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_valueNotSetForParameter"));
                Object[] objectArray = new Object[]{new Integer(n + 1)};
                SQLServerException.makeFromDriverError(sQLServerConnection, null, messageFormat.format(objectArray), null, false);
            }
            dTV = new DTV();
            dTV.setValue(n2, null, null);
        }
        dTV.sendByRPC(this.name, n2, 0, this.outScale, this.isOutput, tDSWriter, sQLServerConnection, n);
    }

    final class GetTypeDefinitionOp
    extends DTVExecuteOp {
        private final Parameter param;
        private final boolean sendStringParametersAsUnicode;
        private String typeDefinition;
        int scale = 0;
        long streamLength = 0L;
        int streamType = 0;

        String getTypeDefinition() {
            return this.typeDefinition;
        }

        GetTypeDefinitionOp(Parameter parameter2, boolean bl) {
            this.param = parameter2;
            this.sendStringParametersAsUnicode = bl;
        }

        private void setTypeDefinition(int n) {
            switch (n) {
                case -6: {
                    this.typeDefinition = "tinyint";
                    break;
                }
                case 5: {
                    this.typeDefinition = "smallint";
                    break;
                }
                case 4: {
                    this.typeDefinition = "int";
                    break;
                }
                case -5: {
                    this.typeDefinition = "bigint";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.typeDefinition = "float";
                    break;
                }
                case 2: 
                case 3: {
                    Integer n2;
                    if (this.scale > 38) {
                        this.scale = 38;
                    }
                    if (null != this.param.dtv && null != (n2 = (Integer)this.param.dtv.getSetterArgs()) && this.scale < n2) {
                        this.scale = n2;
                    }
                    if (this.param.isOutput() && this.scale < this.param.getOutScale()) {
                        this.scale = this.param.getOutScale();
                    }
                    this.typeDefinition = "decimal(38," + this.scale + ")";
                    break;
                }
                case -7: 
                case 16: {
                    this.typeDefinition = "bit";
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    if (-1L == this.streamLength || 2 == this.streamType && this.streamLength > 16000L || this.streamLength > 8000L) {
                        this.typeDefinition = "image";
                        break;
                    }
                    this.typeDefinition = "varbinary(8000)";
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    this.typeDefinition = "datetime";
                    break;
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    if (-1L == this.streamLength) {
                        this.streamLength = 65535L;
                    }
                    if (2 == this.streamType && this.sendStringParametersAsUnicode) {
                        this.typeDefinition = this.streamLength > 4000L ? "ntext" : "nvarchar(4000)";
                        break;
                    }
                    this.typeDefinition = this.streamLength > 8000L ? "text" : "varchar(8000)";
                    break;
                }
                case 999: {
                    this.typeDefinition = null;
                    break;
                }
                default: {
                    this.typeDefinition = "nvarchar(4000)";
                }
            }
        }

        void execute(String string, int n) throws SQLServerException {
            this.streamType = 2;
            if (null != string) {
                this.streamLength = string.length();
            }
            this.setTypeDefinition(n);
        }

        void execute(Clob clob, int n) throws SQLServerException {
            this.streamType = 2;
            if (null != clob) {
                try {
                    this.streamLength = clob.length();
                }
                catch (SQLException sQLException) {
                    SQLServerException.makeFromDriverError(null, null, sQLException.toString(), null, false);
                }
            }
            this.setTypeDefinition(n);
        }

        void execute(Byte by, int n) throws SQLServerException {
            this.setTypeDefinition(n);
        }

        void execute(Integer n, int n2) throws SQLServerException {
            this.setTypeDefinition(n2);
        }

        void execute(Time time, DTV dTV, int n) throws SQLServerException {
            this.setTypeDefinition(n);
        }

        void execute(Date date, DTV dTV, int n) throws SQLServerException {
            this.setTypeDefinition(n);
        }

        void execute(Timestamp timestamp, DTV dTV, int n) throws SQLServerException {
            this.setTypeDefinition(n);
        }

        void execute(Float f, int n) throws SQLServerException {
            this.setTypeDefinition(n);
        }

        void execute(Double d, int n) throws SQLServerException {
            this.setTypeDefinition(n);
        }

        void execute(BigDecimal bigDecimal, int n) throws SQLServerException {
            if (null != bigDecimal) {
                this.scale = bigDecimal.scale();
                if (this.scale < 0) {
                    this.scale = 0;
                }
            }
            this.setTypeDefinition(n);
        }

        void execute(Long l, int n) throws SQLServerException {
            this.setTypeDefinition(n);
        }

        void execute(Short s, int n) throws SQLServerException {
            this.setTypeDefinition(n);
        }

        void execute(Boolean bl, int n) throws SQLServerException {
            this.setTypeDefinition(n);
        }

        void execute(byte[] byArray, int n) throws SQLServerException {
            this.streamType = 1;
            if (null != byArray) {
                this.streamLength = byArray.length;
            }
            this.setTypeDefinition(n);
        }

        void execute(Blob blob, int n) throws SQLServerException {
            this.streamType = 1;
            if (null != blob) {
                try {
                    this.streamLength = blob.length();
                }
                catch (SQLException sQLException) {
                    SQLServerException.makeFromDriverError(null, null, sQLException.toString(), null, false);
                }
            }
            this.setTypeDefinition(n);
        }

        void execute(InputStream inputStream, DTV dTV, int n) throws SQLServerException {
            if (null != inputStream) {
                this.streamLength = -1L;
                try {
                    InputStreamArgs inputStreamArgs = (InputStreamArgs)dTV.getSetterArgs();
                    if (null != inputStreamArgs) {
                        this.streamType = inputStreamArgs.streamType;
                        this.streamLength = inputStreamArgs.length;
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            this.setTypeDefinition(n);
        }

        void execute(Reader reader, DTV dTV, int n) throws SQLServerException {
            this.streamType = 2;
            if (null != reader) {
                this.streamLength = -1L;
                try {
                    CharacterStreamSetterArgs characterStreamSetterArgs = (CharacterStreamSetterArgs)dTV.getSetterArgs();
                    if (null != characterStreamSetterArgs) {
                        this.streamLength = characterStreamSetterArgs.length;
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            this.setTypeDefinition(n);
        }

        void executeDefault(Object object, int n) throws SQLServerException {
            this.setTypeDefinition(n);
        }
    }
}

