/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.security.SecureRandom;
import java.util.List;
import org.keycloak.common.util.Time;
import org.keycloak.migration.MigrationModel;
import org.keycloak.models.jpa.entities.MigrationModelEntity;

public class MigrationModelAdapter
implements MigrationModel {
    protected EntityManager em;
    protected MigrationModelEntity latest;
    private static final int RESOURCE_TAG_LENGTH = 5;
    private static final char[] RESOURCE_TAG_CHARSET = "0123456789abcdefghijklmnopqrstuvwxyz".toCharArray();

    public MigrationModelAdapter(EntityManager em) {
        this.em = em;
        this.init();
    }

    public String getStoredVersion() {
        return this.latest != null ? this.latest.getVersion() : null;
    }

    @Deprecated
    public String getResourcesTag() {
        return this.latest != null ? this.latest.getId() : null;
    }

    private void init() {
        TypedQuery q = this.em.createNamedQuery("getLatest", MigrationModelEntity.class);
        q.setMaxResults(1);
        List l = q.getResultList();
        this.latest = l.isEmpty() ? null : (MigrationModelEntity)l.get(0);
    }

    public void setStoredVersion(String version) {
        String resourceTag = this.createResourceTag();
        while (this.em.find(MigrationModelEntity.class, (Object)resourceTag) != null) {
            resourceTag = this.createResourceTag();
        }
        MigrationModelEntity entity = new MigrationModelEntity();
        entity.setId(resourceTag);
        entity.setVersion(version);
        entity.setUpdatedTime(Time.currentTime());
        this.em.persist((Object)entity);
        this.latest = entity;
    }

    private String createResourceTag() {
        StringBuilder sb = new StringBuilder(5);
        for (int i = 0; i < 5; ++i) {
            sb.append(RESOURCE_TAG_CHARSET[new SecureRandom().nextInt(RESOURCE_TAG_CHARSET.length)]);
        }
        return sb.toString();
    }
}

