/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dmat2(1.6lf, 1.53lf, 0.76lf, -1.0lf) * dvec2(-0.1lf, -1.2lf)) => dvec2(-1.072lf, 1.047lf)
 * (dmat2(1.6lf, 1.53lf, 0.76lf, -1.0lf) * dvec2(-0.42lf, 0.48lf)) => dvec2(-0.30720000000000003lf, -1.1225999999999998lf)
 * (dmat2(-0.13lf, -1.4lf, -0.87lf, 1.4lf) * dvec2(-0.1lf, -1.2lf)) => dvec2(1.057lf, -1.5399999999999998lf)
 * (dmat2(-0.13lf, -1.4lf, -0.87lf, 1.4lf) * dvec2(-0.42lf, 0.48lf)) => dvec2(-0.363lf, 1.26lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((dmat2(1.6lf, 1.53lf, 0.76lf, -1.0lf) * dvec2(-0.1lf, -1.2lf)), dvec2(-1.072lf, 1.047lf)) <= 1.4984635464368162e-05lf ? 1 : -1] array0;
  double[distance((dmat2(1.6lf, 1.53lf, 0.76lf, -1.0lf) * dvec2(-0.42lf, 0.48lf)), dvec2(-0.30720000000000003lf, -1.1225999999999998lf)) <= 1.16387396224849e-05lf ? 1 : -1] array1;
  double[distance((dmat2(-0.13lf, -1.4lf, -0.87lf, 1.4lf) * dvec2(-0.1lf, -1.2lf)), dvec2(1.057lf, -1.5399999999999998lf)) <= 1.8678460857361882e-05lf ? 1 : -1] array2;
  double[distance((dmat2(-0.13lf, -1.4lf, -0.87lf, 1.4lf) * dvec2(-0.42lf, 0.48lf)), dvec2(-0.363lf, 1.26lf)) <= 1.3112471162980685e-05lf ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
