/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.render.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.render.afp.modca.ImageSegment;
import org.apache.fop.render.afp.modca.ObjectEnvironmentGroup;
import org.apache.fop.render.afp.tools.BinaryUtils;

public class ImageObject
extends AbstractNamedAFPObject {
    private ObjectEnvironmentGroup _objectEnvironmentGroup = null;
    private ImageSegment _imageSegment = null;

    public ImageObject(String name) {
        super(name);
    }

    public void setImageViewport(int x, int y, int w, int h, int r) {
        if (this._objectEnvironmentGroup == null) {
            this._objectEnvironmentGroup = new ObjectEnvironmentGroup();
        }
        this._objectEnvironmentGroup.setObjectArea(x, y, w, h, r);
    }

    public void setImageParameters(int xresol, int yresol, int width, int height) {
        if (this._objectEnvironmentGroup == null) {
            this._objectEnvironmentGroup = new ObjectEnvironmentGroup();
        }
        this._objectEnvironmentGroup.setImageData(xresol, yresol, width, height);
        if (this._imageSegment == null) {
            this._imageSegment = new ImageSegment();
        }
        this._imageSegment.setImageSize(xresol, yresol, width, height);
    }

    public void setImageEncoding(byte encoding) {
        if (this._imageSegment == null) {
            this._imageSegment = new ImageSegment();
        }
        this._imageSegment.setImageEncoding(encoding);
    }

    public void setImageCompression(byte compression) {
        if (this._imageSegment == null) {
            this._imageSegment = new ImageSegment();
        }
        this._imageSegment.setImageCompression(compression);
    }

    public void setImageIDESize(byte size) {
        if (this._imageSegment == null) {
            this._imageSegment = new ImageSegment();
        }
        this._imageSegment.setImageIDESize(size);
    }

    public void setImageIDEColorModel(byte colorModel) {
        if (this._imageSegment == null) {
            this._imageSegment = new ImageSegment();
        }
        this._imageSegment.setImageIDEColorModel(colorModel);
    }

    public void setImageData(byte[] data) {
        if (this._imageSegment == null) {
            this._imageSegment = new ImageSegment();
        }
        this._imageSegment.setImageData(data);
    }

    public void setObjectEnvironmentGroup(ObjectEnvironmentGroup objectEnvironmentGroup) {
        this._objectEnvironmentGroup = objectEnvironmentGroup;
    }

    private byte[] getIPDStart(int len) {
        byte[] data = new byte[]{90, 0, 16, -45, -18, -5, 0, 0, 0};
        byte[] l = BinaryUtils.convert(len + 8, 2);
        data[1] = l[0];
        data[2] = l[1];
        return data;
    }

    public void writeDataStream(OutputStream os) throws IOException {
        this.writeStart(os);
        if (this._objectEnvironmentGroup != null) {
            this._objectEnvironmentGroup.writeDataStream(os);
        }
        if (this._imageSegment != null) {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this._imageSegment.writeDataStream(baos);
            byte[] b = baos.toByteArray();
            for (int off = 0; off < b.length; off += len) {
                len = Math.min(30000, b.length - off);
                os.write(this.getIPDStart(len));
                os.write(b, off, len);
            }
        }
        this.writeEnd(os);
    }

    private void writeStart(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        data[0] = 90;
        data[1] = 0;
        data[2] = 16;
        data[3] = -45;
        data[4] = -88;
        data[5] = -5;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this._nameBytes.length; ++i) {
            data[9 + i] = this._nameBytes[i];
        }
        os.write(data);
    }

    private void writeEnd(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        data[0] = 90;
        data[1] = 0;
        data[2] = 16;
        data[3] = -45;
        data[4] = -87;
        data[5] = -5;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this._nameBytes.length; ++i) {
            data[9 + i] = this._nameBytes[i];
        }
        os.write(data);
    }
}

