/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;

public class StackedTabComponent
extends JComponent {
    private static final Logger logger = Logger.getLogger(StackedTabComponent.class);
    private static final Color SELECTED_TAB_GRADIENT_TOP = new Color(255, 204, 66);
    private static final Color SELECTED_TAB_GRADIENT_BOTTOM = new Color(255, 99, 0);
    private static final Color UNSELECTED_TAB_RADIENT_TOP = new Color(221, 221, 221);
    private static final Color UNSELECTED_TAB_GRADIENT_BOTTOM = new Color(204, 204, 204);
    private final Border UNSELECTED_LABEL_BORDER = BorderFactory.createLineBorder(new Color(187, 187, 187), 1);
    private final Border SELECTED_OR_HOVERING_OVER_LABEL_BORDER = BorderFactory.createLineBorder(SELECTED_TAB_GRADIENT_TOP, 1);
    private static final Icon closeIcon = new ImageIcon(StackedTab.class.getClassLoader().getResource("ca/sqlpower/swingui/closeWorkspace-12.png"));
    private List<StackedTab> tabs = new ArrayList<StackedTab>();
    private StackedTab selectedTab;
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    public StackedTabComponent() {
        this.setLayout((LayoutManager)new MigLayout("flowy, hidemode 3, fill, ins 0, gap 0 0", "", ""));
    }

    public StackedTab addTab(String title, Component comp, boolean closeable) {
        StackedTab tab = new StackedTab(title, comp, closeable);
        tab.subComponent.setVisible(false);
        this.tabs.add(tab);
        this.add((Component)tab.tabComponent, "grow 100 0, push 100 0");
        this.add(tab.subComponent, "grow 100 100, push 100 100");
        return tab;
    }

    public void setSelectedIndex(int i) {
        StackedTab oldTab = this.selectedTab;
        if (oldTab != null) {
            oldTab.subComponent.setVisible(false);
            oldTab.tabComponent.setBorder(this.UNSELECTED_LABEL_BORDER);
        }
        if (i < 0 || i >= this.tabs.size()) {
            this.selectedTab = null;
        } else {
            this.selectedTab = this.tabs.get(i);
            this.selectedTab.subComponent.setVisible(true);
            this.selectedTab.tabComponent.setBorder(this.SELECTED_OR_HOVERING_OVER_LABEL_BORDER);
        }
        this.repaint();
        if (oldTab != this.selectedTab) {
            this.fireStateChanged();
        }
    }

    private void fireStateChanged() {
        for (ChangeListener listener : this.changeListeners) {
            ChangeEvent e = new ChangeEvent(this);
            listener.stateChanged(e);
        }
    }

    public int getTabCount() {
        return this.tabs.size();
    }

    public List<StackedTab> getTabs() {
        return Collections.unmodifiableList(this.tabs);
    }

    public void setTitleAt(int index, String newValue) {
        StackedTab tab = this.tabs.get(index);
        if (tab != null) {
            tab.title = newValue;
            tab.titleLabel.setText(" " + newValue);
        }
    }

    public void addChangeListener(ChangeListener tabChangeListener) {
        this.changeListeners.add(tabChangeListener);
    }

    public int indexOfTab(String string) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            StackedTab tab = this.tabs.get(i);
            if (!tab.title.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int indexOfTab(StackedTab tab) {
        return this.tabs.indexOf(tab);
    }

    public int getSelectedIndex() {
        return this.tabs.indexOf(this.selectedTab);
    }

    public void removeTabAt(int i) {
        StackedTab removedTab = this.tabs.get(i);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("removed tab at " + i + ", removed tab " + removedTab.titleLabel), (Throwable)new Exception("For stack trace"));
        }
        if (removedTab != null) {
            this.remove(removedTab.tabComponent);
            this.remove(removedTab.subComponent);
        }
        this.tabs.remove(i);
    }

    public int indexAtLocation(int x, int y) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            StackedTab tab = this.tabs.get(i);
            int xRelativeToLabel = x - tab.tabComponent.getX();
            int yRelativeToLabel = y - tab.tabComponent.getY();
            boolean labelContains = tab.tabComponent.contains(xRelativeToLabel, yRelativeToLabel);
            int xRelativeToSubComp = x - tab.tabComponent.getX();
            int yRelativeToSubComp = y - tab.tabComponent.getY();
            boolean subcompContains = tab.tabComponent.contains(xRelativeToSubComp, yRelativeToSubComp);
            if (!labelContains && !subcompContains) continue;
            return i;
        }
        return -1;
    }

    public StackedTab getSelectedTab() {
        return this.selectedTab;
    }

    public class StackedTab {
        private String title;
        private JLabel titleLabel;
        private final Component subComponent;
        private final JLabel closeIconComponent;
        private final JComponent tabComponent;
        private final boolean closeable;

        private StackedTab(String title, Component component, boolean closeable) {
            this.title = title;
            this.closeable = closeable;
            this.tabComponent = new JPanel((LayoutManager)new MigLayout("hidemode 3, fill, ins 0, gap 0 0", "", ""));
            if (closeable) {
                this.closeIconComponent = new JLabel(closeIcon){

                    @Override
                    protected void paintComponent(Graphics g) {
                        Graphics2D g2 = (Graphics2D)g;
                        Color topColor = StackedTab.this == StackedTabComponent.this.selectedTab ? SELECTED_TAB_GRADIENT_TOP : UNSELECTED_TAB_RADIENT_TOP;
                        Color bottomColor = StackedTab.this == StackedTabComponent.this.selectedTab ? SELECTED_TAB_GRADIENT_BOTTOM : UNSELECTED_TAB_GRADIENT_BOTTOM;
                        GradientPaint gp = new GradientPaint(0.0f, 0.0f, topColor, 0.0f, this.getHeight(), bottomColor);
                        g2.setPaint(gp);
                        g2.fillRect(0, 0, this.getWidth(), StackedTab.this.tabComponent.getHeight());
                        super.paintComponent(g);
                    }
                };
                this.closeIconComponent.setVisible(false);
            } else {
                this.closeIconComponent = null;
            }
            this.titleLabel = new JLabel(" " + title){

                @Override
                protected void paintComponent(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g;
                    Color topColor = StackedTab.this == StackedTabComponent.this.selectedTab ? SELECTED_TAB_GRADIENT_TOP : UNSELECTED_TAB_RADIENT_TOP;
                    Color bottomColor = StackedTab.this == StackedTabComponent.this.selectedTab ? SELECTED_TAB_GRADIENT_BOTTOM : UNSELECTED_TAB_GRADIENT_BOTTOM;
                    GradientPaint gp = new GradientPaint(0.0f, 0.0f, topColor, 0.0f, this.getHeight(), bottomColor);
                    g2.setPaint(gp);
                    g2.fillRect(0, 0, StackedTabComponent.this.getWidth(), StackedTab.this.tabComponent.getHeight());
                    super.paintComponent(g);
                }
            };
            this.titleLabel.setMinimumSize(new Dimension(StackedTabComponent.this.getMinimumSize().width, closeIcon.getIconHeight()));
            this.tabComponent.add((Component)this.titleLabel, "grow 100 100, push 100 100");
            if (this.closeIconComponent != null) {
                this.tabComponent.add((Component)this.closeIconComponent, "grow 0 100, push 0 100");
            }
            this.tabComponent.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (StackedTab.this.closeIconComponent != null) {
                        StackedTab.this.closeIconComponent.setVisible(true);
                    }
                    if (StackedTab.this != StackedTabComponent.this.selectedTab) {
                        StackedTab.this.tabComponent.setBorder(StackedTabComponent.this.SELECTED_OR_HOVERING_OVER_LABEL_BORDER);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (StackedTab.this.closeIconComponent != null) {
                        StackedTab.this.closeIconComponent.setVisible(false);
                    }
                    if (StackedTab.this != StackedTabComponent.this.selectedTab) {
                        StackedTab.this.tabComponent.setBorder(StackedTabComponent.this.UNSELECTED_LABEL_BORDER);
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    StackedTabComponent.this.setSelectedIndex(StackedTabComponent.this.tabs.indexOf(StackedTab.this));
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            });
            this.tabComponent.setBorder(StackedTabComponent.this.UNSELECTED_LABEL_BORDER);
            this.subComponent = component;
        }

        public Component getTabComponent() {
            return this.tabComponent;
        }

        public boolean isCloseable() {
            return this.closeable;
        }

        public boolean closeButtonContains(int x, int y) {
            int relativeY;
            int relativeX = x - this.closeIconComponent.getX();
            return this.closeIconComponent.contains(relativeX, relativeY = y - this.closeIconComponent.getY());
        }
    }
}

